/*
 * Decompiled with CFR 0.152.
 */
package picard.arrays.illumina;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import picard.arrays.illumina.IlluminaGenotype;
import picard.arrays.illumina.InfiniumDataFile;

public class IlluminaAdpcFileWriter
implements AutoCloseable {
    private final DataOutputStream outputStream;

    public IlluminaAdpcFileWriter(File adpcFile) throws IOException {
        this.outputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(adpcFile)));
        this.writeHeaderData();
    }

    private void writeHeaderData() throws IOException {
        this.outputStream.write("1234567890123456".getBytes());
    }

    public void write(Iterable<Record> illuminaAdpcRecords) throws IOException {
        for (Record illuminaAdpcRecord : illuminaAdpcRecords) {
            illuminaAdpcRecord.write(this.outputStream);
        }
    }

    @Override
    public void close() throws Exception {
        this.outputStream.close();
    }

    public static class Record {
        final short aIntensity;
        final short bIntensity;
        final float aNormalizedIntensity;
        final float bNormalizedIntensity;
        final float gcScore;
        final IlluminaGenotype genotype;

        public Record(short aIntensity, short bIntensity, float aNormalizedIntensity, float bNormalizedIntensity, float gcScore, IlluminaGenotype genotype) {
            this.aIntensity = aIntensity;
            this.bIntensity = bIntensity;
            this.aNormalizedIntensity = aNormalizedIntensity;
            this.bNormalizedIntensity = bNormalizedIntensity;
            this.gcScore = gcScore;
            this.genotype = genotype;
        }

        public void write(DataOutputStream outputStream) throws IOException {
            InfiniumDataFile.writeShort(outputStream, this.aIntensity);
            InfiniumDataFile.writeShort(outputStream, this.bIntensity);
            InfiniumDataFile.writeFloat(outputStream, this.aNormalizedIntensity);
            InfiniumDataFile.writeFloat(outputStream, this.bNormalizedIntensity);
            InfiniumDataFile.writeFloat(outputStream, this.gcScore);
            InfiniumDataFile.writeShort(outputStream, this.genotype.value);
        }
    }
}

