/*
 * Decompiled with CFR 0.152.
 */
package picard.arrays.illumina;

import htsjdk.samtools.util.Log;
import htsjdk.variant.variantcontext.Allele;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import picard.arrays.illumina.IlluminaManifestRecord;

public class Build37ExtendedIlluminaManifestRecord
extends IlluminaManifestRecord {
    private String b37Chr;
    private Integer b37Pos;
    private String snpRefAllele;
    private String snpAlleleA;
    private String snpAlleleB;
    private String rsId;
    private Flag flag = Flag.PASS;
    private Allele A;
    private Allele B;
    private Allele ref;
    private final Log log = Log.getInstance(Build37ExtendedIlluminaManifestRecord.class);

    Build37ExtendedIlluminaManifestRecord(Map<String, Integer> columnNameToIndex, String[] line, int index) {
        super(columnNameToIndex, line, index);
        int end = line.length;
        this.flag = Flag.valueOf(line[end - 1]);
        if (!this.isBad().booleanValue()) {
            this.b37Chr = line[end - 7];
            this.b37Pos = this.parseIntOrNull(line[end - 6]);
            this.snpRefAllele = line[end - 5];
            this.snpAlleleA = line[end - 4];
            this.snpAlleleB = line[end - 3];
            this.rsId = line[end - 2];
            this.A = Allele.create(this.snpAlleleA, this.snpAlleleA.equals(this.snpRefAllele));
            this.B = Allele.create(this.snpAlleleB, this.snpAlleleB.equals(this.snpRefAllele));
            this.ref = Allele.create(this.snpRefAllele, true);
        } else {
            this.b37Chr = "0";
            this.b37Pos = 0;
            this.snpRefAllele = "";
            this.snpAlleleA = "";
            this.snpAlleleB = "";
            this.rsId = "";
            this.A = Allele.NO_CALL;
            this.B = Allele.NO_CALL;
            this.ref = Allele.NO_CALL;
        }
    }

    public Allele getAlleleA() {
        return this.A;
    }

    public Allele getAlleleB() {
        return this.B;
    }

    public Allele getRefAllele() {
        return this.ref;
    }

    public String getB37Chr() {
        return this.b37Chr;
    }

    public Integer getB37Pos() {
        return this.b37Pos;
    }

    public String getRsId() {
        return this.rsId;
    }

    public Boolean isBad() {
        return this.flag != Flag.DUPE && this.flag != Flag.PASS;
    }

    public Boolean isDupe() {
        return this.flag == Flag.DUPE;
    }

    public Flag getFlag() {
        return this.flag;
    }

    @Override
    public String getLine() {
        String originalLine = super.getLine();
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add(this.b37Chr);
        extensions.add(this.b37Pos != null ? this.b37Pos.toString() : null);
        extensions.add(this.snpRefAllele);
        extensions.add(this.snpAlleleA);
        extensions.add(this.snpAlleleB);
        extensions.add(this.rsId);
        extensions.add(this.flag.name());
        return originalLine + "," + StringUtils.join(extensions, ",");
    }

    protected static enum Flag {
        ILLUMINA_FLAGGED,
        LIFTOVER_FAILED,
        UNSUPPORTED_GENOME_BUILD,
        PROBE_SEQUENCE_MISMATCH,
        PROBE_SEQUENCE_STRAND_INVALID,
        SOURCE_SEQUENCE_MISMATCH,
        SOURCE_SEQUENCE_INVALID,
        SOURCE_SEQUENCE_STRAND_INVALID,
        INDEL_NOT_FOUND,
        INDEL_CONFLICT,
        SEQUENCE_MISMATCH,
        INDEL_SEQ_MISMATCH,
        INDEL_EXTENSION_ERROR,
        DUPE,
        PASS;

    }
}

