/*
 * Decompiled with CFR 0.152.
 */
package picard.arrays;

import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.arrays.illumina.IlluminaAdpcFileWriter;
import picard.arrays.illumina.IlluminaGenotype;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.GenotypingArraysProgramGroup;

@CommandLineProgramProperties(summary="VcfToAdpc takes a VCF, as generated by GtcToVcf and generates an Illumina 'adpc.bin' file from it. An adpc.bin file is a binary file containing genotyping array intensity data that can be exported by Illumina's GenomeStudio and Beadstudio analysis tools. The adpc.bin file is used as an input to <a href='https://genome.sph.umich.edu/wiki/VerifyIDintensity'>VerifyIDintensity</a> a tool for detecting and estimating sample contamination of Illumina genotyping array data.<h4>Usage example:</h4><pre>java -jar picard.jar VcfToAdpc \\<br />      VCF=input.vcf \\<br />      OUTPUT=output.adpc.bin</pre>", oneLineSummary="Program to convert an Arrays VCF to an ADPC file.", programGroup=GenotypingArraysProgramGroup.class)
@DocumentedFeature
public class VcfToAdpc
extends CommandLineProgram {
    static final String USAGE_DETAILS = "VcfToAdpc takes a VCF, as generated by GtcToVcf and generates an Illumina 'adpc.bin' file from it. An adpc.bin file is a binary file containing genotyping array intensity data that can be exported by Illumina's GenomeStudio and Beadstudio analysis tools. The adpc.bin file is used as an input to <a href='https://genome.sph.umich.edu/wiki/VerifyIDintensity'>VerifyIDintensity</a> a tool for detecting and estimating sample contamination of Illumina genotyping array data.<h4>Usage example:</h4><pre>java -jar picard.jar VcfToAdpc \\<br />      VCF=input.vcf \\<br />      OUTPUT=output.adpc.bin</pre>";
    private final Log log = Log.getInstance(VcfToAdpc.class);
    @Argument(doc="The Input VCF")
    public File VCF;
    @Argument(shortName="O", doc="The output (adpc.bin) file to write.")
    public File OUTPUT;

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable(this.VCF);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        VCFFileReader vcfFileReader = new VCFFileReader(this.VCF, false);
        try (Iterator variants = vcfFileReader.iterator();
             IlluminaAdpcFileWriter adpcFileWriter = new IlluminaAdpcFileWriter(this.OUTPUT);){
            ArrayList<IlluminaAdpcFileWriter.Record> adpcRecordList = new ArrayList<IlluminaAdpcFileWriter.Record>();
            while (variants.hasNext()) {
                VariantContext context = (VariantContext)variants.next();
                float gcScore = this.getFloatAttribute(context, "GC_SCORE");
                for (Genotype genotype : context.getGenotypes()) {
                    IlluminaGenotype illuminaGenotype = this.getIlluminaGenotype(genotype, context);
                    short rawXIntensity = this.getShortAttribute(genotype, "X");
                    short rawYIntensity = this.getShortAttribute(genotype, "Y");
                    float normalizedXIntensity = this.getFloatAttribute(genotype, "NORMX");
                    float normalizedYIntensity = this.getFloatAttribute(genotype, "NORMY");
                    IlluminaAdpcFileWriter.Record record = new IlluminaAdpcFileWriter.Record(rawXIntensity, rawYIntensity, normalizedXIntensity, normalizedYIntensity, gcScore, illuminaGenotype);
                    adpcRecordList.add(record);
                }
            }
            adpcFileWriter.write(adpcRecordList);
        }
        catch (Exception e) {
            this.log.error(e, new Object[0]);
            return 1;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IlluminaGenotype getIlluminaGenotype(Genotype genotype, VariantContext context) {
        if (!genotype.isCalled()) return IlluminaGenotype.NN;
        String illuminaAlleleA = StringUtils.stripEnd(this.getStringAttribute(context, "ALLELE_A"), "*");
        String illuminaAlleleB = StringUtils.stripEnd(this.getStringAttribute(context, "ALLELE_B"), "*");
        if (genotype.getAlleles().size() != 2) {
            throw new PicardException("Unexpected number of called alleles in variant context " + context + " found alleles: " + genotype.getAlleles());
        }
        Allele calledAllele1 = genotype.getAllele(0);
        Allele calledAllele2 = genotype.getAllele(1);
        if (calledAllele1.basesMatch(illuminaAlleleA)) {
            if (calledAllele2.basesMatch(illuminaAlleleA)) {
                return IlluminaGenotype.AA;
            }
            if (!calledAllele2.basesMatch(illuminaAlleleB)) throw new PicardException("Error matching called alleles to Illumina alleles.  Context: " + context);
            return IlluminaGenotype.AB;
        }
        if (!calledAllele1.basesMatch(illuminaAlleleB)) throw new PicardException("Error matching called alleles to Illumina alleles.  Context: " + context);
        if (calledAllele2.basesMatch(illuminaAlleleA)) {
            return IlluminaGenotype.AB;
        }
        if (!calledAllele2.basesMatch(illuminaAlleleB)) throw new PicardException("Error matching called alleles to Illumina alleles.  Context: " + context);
        return IlluminaGenotype.BB;
    }

    private short getShortAttribute(Genotype genotype, String key) {
        int returnedAttribute;
        int attributeAsInt = Integer.parseInt(this.getRequiredAttribute(genotype, key).toString());
        if (attributeAsInt <= Short.MAX_VALUE) {
            returnedAttribute = attributeAsInt;
        } else {
            this.log.warn("Value for key " + key + " (" + attributeAsInt + ") is > " + Short.MAX_VALUE + " (truncating it)");
            returnedAttribute = Short.MAX_VALUE;
        }
        return (short)returnedAttribute;
    }

    private float getFloatAttribute(Genotype genotype, String key) {
        return Float.parseFloat(this.getRequiredAttribute(genotype, key).toString());
    }

    private Object getRequiredAttribute(Genotype genotype, String key) {
        Object value = genotype.getAnyAttribute(key);
        if (value == null) {
            throw new PicardException("Unable to find attribute " + key + " in VCF Genotype field.  Is this an Arrays VCF file?");
        }
        return value;
    }

    private float getFloatAttribute(VariantContext context, String key) {
        return Float.parseFloat(this.getRequiredAttribute(context, key).toString());
    }

    private String getStringAttribute(VariantContext context, String key) {
        return this.getRequiredAttribute(context, key).toString();
    }

    private Object getRequiredAttribute(VariantContext context, String key) {
        Object value = context.getAttribute(key);
        if (value == null) {
            throw new PicardException("Unable to find attribute " + key + " in VCF.  Is this an Arrays VCF file?");
        }
        return value;
    }
}

