/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.directed;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.samtools.util.SequenceUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.PicardException;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.RnaSeqMetrics;
import picard.annotation.Gene;
import picard.annotation.LocusFunction;
import picard.metrics.PerUnitMetricCollector;
import picard.metrics.SAMRecordMultiLevelCollector;
import picard.util.MathUtil;

public class RnaSeqMetricsCollector
extends SAMRecordMultiLevelCollector<RnaSeqMetrics, Integer> {
    private final int minimumLength;
    private final StrandSpecificity strandSpecificity;
    private final double rrnaFragmentPercentage;
    protected final Long ribosomalInitialValue;
    private final Set<Integer> ignoredSequenceIndices;
    private final OverlapDetector<Gene> geneOverlapDetector;
    private final OverlapDetector<Interval> ribosomalSequenceOverlapDetector;
    private final boolean collectCoverageStatistics;

    public RnaSeqMetricsCollector(Set<MetricAccumulationLevel> accumulationLevels, List<SAMReadGroupRecord> samRgRecords, Long ribosomalBasesInitialValue, OverlapDetector<Gene> geneOverlapDetector, OverlapDetector<Interval> ribosomalSequenceOverlapDetector, HashSet<Integer> ignoredSequenceIndices, int minimumLength, StrandSpecificity strandSpecificity, double rrnaFragmentPercentage, boolean collectCoverageStatistics) {
        this.ribosomalInitialValue = ribosomalBasesInitialValue;
        this.ignoredSequenceIndices = ignoredSequenceIndices;
        this.geneOverlapDetector = geneOverlapDetector;
        this.ribosomalSequenceOverlapDetector = ribosomalSequenceOverlapDetector;
        this.minimumLength = minimumLength;
        this.strandSpecificity = strandSpecificity;
        this.rrnaFragmentPercentage = rrnaFragmentPercentage;
        this.collectCoverageStatistics = collectCoverageStatistics;
        this.setup(accumulationLevels, samRgRecords);
    }

    @Override
    protected PerUnitMetricCollector<RnaSeqMetrics, Integer, SAMRecord> makeChildCollector(String sample, String library, String readGroup) {
        return new PerUnitRnaSeqMetricsCollector(sample, library, readGroup, this.ribosomalInitialValue);
    }

    public static OverlapDetector<Interval> makeOverlapDetector(File samFile, SAMFileHeader header, File ribosomalIntervalsFile, Log log) {
        OverlapDetector<Interval> ribosomalSequenceOverlapDetector = new OverlapDetector<Interval>(0, 0);
        if (ribosomalIntervalsFile != null) {
            IntervalList ribosomalIntervals = IntervalList.fromFile(ribosomalIntervalsFile);
            if (ribosomalIntervals.size() == 0) {
                log.warn("The RIBOSOMAL_INTERVALS file, " + ribosomalIntervalsFile.getAbsolutePath() + " does not contain intervals");
            }
            try {
                SequenceUtil.assertSequenceDictionariesEqual(header.getSequenceDictionary(), ribosomalIntervals.getHeader().getSequenceDictionary());
            }
            catch (SequenceUtil.SequenceListsDifferException e) {
                throw new PicardException("Sequence dictionaries differ in " + samFile.getAbsolutePath() + " and " + ribosomalIntervalsFile.getAbsolutePath(), e);
            }
            IntervalList uniquedRibosomalIntervals = ribosomalIntervals.uniqued();
            List<Interval> intervals = uniquedRibosomalIntervals.getIntervals();
            ribosomalSequenceOverlapDetector.addAll(intervals, intervals);
        }
        return ribosomalSequenceOverlapDetector;
    }

    public static HashSet<Integer> makeIgnoredSequenceIndicesSet(SAMFileHeader header, Set<String> ignoredSequence) {
        HashSet<Integer> ignoredSequenceIndices = new HashSet<Integer>();
        for (String sequenceName : ignoredSequence) {
            SAMSequenceRecord sequenceRecord = header.getSequence(sequenceName);
            if (sequenceRecord == null) {
                throw new PicardException("Unrecognized sequence " + sequenceName + " passed as argument to IGNORE_SEQUENCE");
            }
            ignoredSequenceIndices.add(sequenceRecord.getSequenceIndex());
        }
        return ignoredSequenceIndices;
    }

    protected class PerUnitRnaSeqMetricsCollector
    implements PerUnitMetricCollector<RnaSeqMetrics, Integer, SAMRecord> {
        protected final RnaSeqMetrics metrics;
        private final Map<Gene.Transcript, int[]> coverageByTranscript = new HashMap<Gene.Transcript, int[]>();

        protected PerUnitRnaSeqMetricsCollector(RnaSeqMetrics metrics, String sample, String library, String readGroup, Long ribosomalBasesInitialValue) {
            this.metrics = metrics;
            this.metrics.SAMPLE = sample;
            this.metrics.LIBRARY = library;
            this.metrics.READ_GROUP = readGroup;
            this.metrics.RIBOSOMAL_BASES = ribosomalBasesInitialValue;
        }

        public PerUnitRnaSeqMetricsCollector(String sample, String library, String readGroup, Long ribosomalBasesInitialValue) {
            this(new RnaSeqMetrics(), sample, library, readGroup, ribosomalBasesInitialValue);
        }

        @Override
        public void acceptRecord(SAMRecord rec) {
            Interval fragmentInterval;
            if (rec.getReadFailsVendorQualityCheckFlag()) {
                return;
            }
            if (!rec.getNotPrimaryAlignmentFlag()) {
                this.metrics.PF_BASES += (long)rec.getReadLength();
            }
            if (!rec.getReadUnmappedFlag() && !rec.getNotPrimaryAlignmentFlag() && RnaSeqMetricsCollector.this.ignoredSequenceIndices.contains(rec.getReferenceIndex())) {
                ++this.metrics.IGNORED_READS;
                return;
            }
            if (rec.getNotPrimaryAlignmentFlag() || rec.getReadUnmappedFlag()) {
                return;
            }
            Interval readInterval = new Interval(rec.getReferenceName(), rec.getAlignmentStart(), rec.getAlignmentEnd());
            if (!rec.getReadPairedFlag()) {
                fragmentInterval = readInterval;
            } else if (rec.getMateUnmappedFlag() || rec.getReferenceIndex() != rec.getMateReferenceIndex()) {
                fragmentInterval = null;
            } else {
                int fragmentStart = Math.min(rec.getAlignmentStart(), rec.getMateAlignmentStart());
                int fragmentEnd = CoordMath.getEnd(fragmentStart, Math.abs(rec.getInferredInsertSize()));
                fragmentInterval = new Interval(rec.getReferenceName(), fragmentStart, fragmentEnd);
            }
            if (fragmentInterval != null) {
                Set overlappingRibosomalIntervals = RnaSeqMetricsCollector.this.ribosomalSequenceOverlapDetector.getOverlaps(fragmentInterval);
                int intersectionLength = 0;
                for (Object overlappingInterval : overlappingRibosomalIntervals) {
                    int thisIntersectionLength = ((Interval)overlappingInterval).getIntersectionLength(fragmentInterval);
                    intersectionLength = Math.max(intersectionLength, thisIntersectionLength);
                }
                if ((double)intersectionLength / (double)fragmentInterval.length() >= RnaSeqMetricsCollector.this.rrnaFragmentPercentage) {
                    RnaSeqMetrics rnaSeqMetrics = this.metrics;
                    rnaSeqMetrics.RIBOSOMAL_BASES = rnaSeqMetrics.RIBOSOMAL_BASES + (long)this.getNumAlignedBases(rec);
                    this.metrics.PF_ALIGNED_BASES += (long)this.getNumAlignedBases(rec);
                    return;
                }
            }
            Set overlappingGenes = RnaSeqMetricsCollector.this.geneOverlapDetector.getOverlaps(readInterval);
            List<AlignmentBlock> alignmentBlocks = rec.getAlignmentBlocks();
            boolean overlapsExon = false;
            for (AlignmentBlock alignmentBlock : alignmentBlocks) {
                Object coverage;
                LocusFunction[] locusFunctions = new LocusFunction[alignmentBlock.getLength()];
                Arrays.fill((Object[])locusFunctions, 0, locusFunctions.length, (Object)LocusFunction.INTERGENIC);
                for (Gene gene : overlappingGenes) {
                    for (Gene.Transcript transcript : gene) {
                        transcript.assignLocusFunctionForRange(alignmentBlock.getReferenceStart(), locusFunctions);
                        if (!RnaSeqMetricsCollector.this.collectCoverageStatistics) continue;
                        coverage = this.coverageByTranscript.get(transcript);
                        if (coverage == null) {
                            coverage = new int[transcript.length()];
                            this.coverageByTranscript.put(transcript, (int[])coverage);
                        }
                        transcript.addCoverageCounts(alignmentBlock.getReferenceStart(), CoordMath.getEnd(alignmentBlock.getReferenceStart(), alignmentBlock.getLength()), (int[])coverage);
                    }
                }
                block11: for (LocusFunction locusFunction : locusFunctions) {
                    ++this.metrics.PF_ALIGNED_BASES;
                    switch (locusFunction) {
                        case INTERGENIC: {
                            ++this.metrics.INTERGENIC_BASES;
                            continue block11;
                        }
                        case INTRONIC: {
                            ++this.metrics.INTRONIC_BASES;
                            continue block11;
                        }
                        case UTR: {
                            ++this.metrics.UTR_BASES;
                            overlapsExon = true;
                            continue block11;
                        }
                        case CODING: {
                            ++this.metrics.CODING_BASES;
                            overlapsExon = true;
                            continue block11;
                        }
                        case RIBOSOMAL: {
                            coverage = this.metrics;
                            Long.valueOf(coverage.RIBOSOMAL_BASES + 1L);
                            coverage.RIBOSOMAL_BASES = coverage.RIBOSOMAL_BASES;
                        }
                    }
                }
            }
            if (!rec.getSupplementaryAlignmentFlag() && overlapsExon && overlappingGenes.size() == 1) {
                Gene gene = (Gene)overlappingGenes.iterator().next();
                boolean negativeTranscriptionStrand = gene.isNegativeStrand();
                boolean readOneOrUnpaired = !rec.getReadPairedFlag() || rec.getFirstOfPairFlag();
                boolean negativeReadStrand = rec.getReadNegativeStrandFlag();
                if (RnaSeqMetricsCollector.this.strandSpecificity != StrandSpecificity.NONE) {
                    boolean thisReadExpectedToAgree;
                    boolean readAndTranscriptStrandsAgree = negativeReadStrand == negativeTranscriptionStrand;
                    boolean firstReadExpectedToAgree = RnaSeqMetricsCollector.this.strandSpecificity == StrandSpecificity.FIRST_READ_TRANSCRIPTION_STRAND;
                    boolean bl = thisReadExpectedToAgree = readOneOrUnpaired == firstReadExpectedToAgree;
                    if (readAndTranscriptStrandsAgree == thisReadExpectedToAgree) {
                        ++this.metrics.CORRECT_STRAND_READS;
                    } else {
                        ++this.metrics.INCORRECT_STRAND_READS;
                    }
                }
                if (readOneOrUnpaired) {
                    int leftMostAlignedBase;
                    int rightMostAlignedBase;
                    boolean properOrientation;
                    if (rec.getReadPairedFlag()) {
                        if (rec.getMateUnmappedFlag()) {
                            properOrientation = false;
                            rightMostAlignedBase = 0;
                            leftMostAlignedBase = 0;
                        } else {
                            Cigar mateCigar = SAMUtils.getMateCigar(rec);
                            int mateReferenceLength = mateCigar == null ? rec.getReadLength() : mateCigar.getReferenceLength();
                            int mateAlignmentEnd = CoordMath.getEnd(rec.getMateAlignmentStart(), mateReferenceLength);
                            properOrientation = SamPairUtil.getPairOrientation(rec) == SamPairUtil.PairOrientation.FR;
                            leftMostAlignedBase = Math.min(rec.getAlignmentStart(), rec.getMateAlignmentStart());
                            rightMostAlignedBase = Math.max(rec.getAlignmentEnd(), mateAlignmentEnd);
                        }
                    } else {
                        properOrientation = true;
                        leftMostAlignedBase = rec.getAlignmentStart();
                        rightMostAlignedBase = rec.getAlignmentEnd();
                    }
                    if (properOrientation && CoordMath.encloses(gene.getStart(), gene.getEnd(), leftMostAlignedBase, rightMostAlignedBase)) {
                        if (negativeReadStrand == negativeTranscriptionStrand) {
                            ++this.metrics.NUM_R1_TRANSCRIPT_STRAND_READS;
                        } else {
                            ++this.metrics.NUM_R2_TRANSCRIPT_STRAND_READS;
                        }
                    } else {
                        ++this.metrics.NUM_UNEXPLAINED_READS;
                    }
                }
            }
        }

        protected int getNumAlignedBases(SAMRecord rec) {
            int numAlignedBases = 0;
            for (AlignmentBlock alignmentBlock : rec.getAlignmentBlocks()) {
                numAlignedBases += alignmentBlock.getLength();
            }
            return numAlignedBases;
        }

        @Override
        public void finish() {
            long readsExamined;
            if (this.metrics.PF_ALIGNED_BASES > 0L) {
                if (this.metrics.RIBOSOMAL_BASES != null) {
                    this.metrics.PCT_RIBOSOMAL_BASES = (double)this.metrics.RIBOSOMAL_BASES.longValue() / (double)this.metrics.PF_ALIGNED_BASES;
                }
                this.metrics.PCT_CODING_BASES = (double)this.metrics.CODING_BASES / (double)this.metrics.PF_ALIGNED_BASES;
                this.metrics.PCT_UTR_BASES = (double)this.metrics.UTR_BASES / (double)this.metrics.PF_ALIGNED_BASES;
                this.metrics.PCT_INTRONIC_BASES = (double)this.metrics.INTRONIC_BASES / (double)this.metrics.PF_ALIGNED_BASES;
                this.metrics.PCT_INTERGENIC_BASES = (double)this.metrics.INTERGENIC_BASES / (double)this.metrics.PF_ALIGNED_BASES;
                this.metrics.PCT_MRNA_BASES = this.metrics.PCT_CODING_BASES + this.metrics.PCT_UTR_BASES;
                this.metrics.PCT_USABLE_BASES = (double)(this.metrics.CODING_BASES + this.metrics.UTR_BASES) / (double)this.metrics.PF_BASES;
            }
            if (this.metrics.CORRECT_STRAND_READS > 0L || this.metrics.INCORRECT_STRAND_READS > 0L) {
                this.metrics.PCT_CORRECT_STRAND_READS = (double)this.metrics.CORRECT_STRAND_READS / (double)(this.metrics.CORRECT_STRAND_READS + this.metrics.INCORRECT_STRAND_READS);
            }
            if (0L < (readsExamined = this.metrics.NUM_R1_TRANSCRIPT_STRAND_READS + this.metrics.NUM_R2_TRANSCRIPT_STRAND_READS)) {
                this.metrics.PCT_R1_TRANSCRIPT_STRAND_READS = (double)this.metrics.NUM_R1_TRANSCRIPT_STRAND_READS / (double)readsExamined;
                this.metrics.PCT_R2_TRANSCRIPT_STRAND_READS = (double)this.metrics.NUM_R2_TRANSCRIPT_STRAND_READS / (double)readsExamined;
            }
        }

        @Override
        public void addMetricsToFile(MetricsFile<RnaSeqMetrics, Integer> file) {
            Histogram<Integer> normalizedCovByPos = this.computeCoverageMetrics();
            file.addMetric(this.metrics);
            file.addHistogram(normalizedCovByPos);
        }

        private Histogram<Integer> computeCoverageMetrics() {
            Histogram<Double> cvs = new Histogram<Double>();
            Histogram<Double> fivePrimeSkews = new Histogram<Double>();
            Histogram<Double> threePrimeSkews = new Histogram<Double>();
            Histogram gapBasesPerKb = new Histogram();
            Histogram<Double> fiveToThreeSkews = new Histogram<Double>();
            String prefix = null;
            prefix = this.metrics.READ_GROUP != null ? this.metrics.READ_GROUP + "." : (this.metrics.LIBRARY != null ? this.metrics.LIBRARY + "." : (this.metrics.SAMPLE != null ? this.metrics.SAMPLE + "." : "All_Reads."));
            Histogram<Integer> normalizedCoverageByNormalizedPosition = new Histogram<Integer>("normalized_position", prefix + "normalized_coverage");
            Map<Gene.Transcript, int[]> transcripts = this.pickTranscripts(this.coverageByTranscript);
            double transcriptCount = transcripts.size();
            for (Map.Entry<Gene.Transcript, int[]> entry : transcripts.entrySet()) {
                Gene.Transcript tx = entry.getKey();
                double[] tmp = MathUtil.promote(entry.getValue());
                double[] coverage = tx.getGene().isPositiveStrand() ? tmp : this.copyAndReverse(tmp);
                double mean = MathUtil.mean(coverage);
                double stdev = MathUtil.stddev(coverage, mean);
                double cv = stdev / mean;
                cvs.increment(cv);
                int PRIME_BASES = 100;
                double fivePrimeCoverage = MathUtil.mean(coverage, 0, 100);
                double threePrimeCoverage = MathUtil.mean(coverage, coverage.length - 100, coverage.length);
                fivePrimeSkews.increment(fivePrimeCoverage / mean);
                threePrimeSkews.increment(threePrimeCoverage / mean);
                fiveToThreeSkews.increment(MathUtil.divide(fivePrimeCoverage, threePrimeCoverage));
                int lastIndex = coverage.length - 1;
                for (int percent = 0; percent <= 100; ++percent) {
                    double p = (double)percent / 100.0;
                    int start = (int)Math.max(0.0, (double)lastIndex * (p - 0.005));
                    int end = (int)Math.min((double)lastIndex, (double)lastIndex * (p + 0.005));
                    int length = end - start + 1;
                    double sum = 0.0;
                    for (int i = start; i <= end; ++i) {
                        sum += coverage[i];
                    }
                    double normalized = sum / (double)length / mean;
                    normalizedCoverageByNormalizedPosition.increment(percent, normalized / transcriptCount);
                }
            }
            this.metrics.MEDIAN_CV_COVERAGE = cvs.getMedian();
            this.metrics.MEDIAN_5PRIME_BIAS = fivePrimeSkews.getMedian();
            this.metrics.MEDIAN_3PRIME_BIAS = threePrimeSkews.getMedian();
            this.metrics.MEDIAN_5PRIME_TO_3PRIME_BIAS = fiveToThreeSkews.getMedian();
            return normalizedCoverageByNormalizedPosition;
        }

        private double[] copyAndReverse(double[] in) {
            double[] out = new double[in.length];
            int i = 0;
            int j = in.length - 1;
            while (i < in.length) {
                out[j] = in[i];
                ++i;
                --j;
            }
            return out;
        }

        protected Set<Gene> getGenesForPickTranscripts() {
            return RnaSeqMetricsCollector.this.geneOverlapDetector.getAll();
        }

        public Map<Gene.Transcript, int[]> pickTranscripts(Map<Gene.Transcript, int[]> transcriptCoverage) {
            Object best;
            Set<Gene> genesWithTranscripts = this.getGenesWithTranscripts(transcriptCoverage.keySet());
            HashMap bestPerGene = new HashMap();
            for (Gene gene : genesWithTranscripts) {
                best = null;
                double bestMean = 0.0;
                for (Gene.Transcript transcript : gene) {
                    double mean;
                    int[] cov = transcriptCoverage.get(transcript);
                    if (transcript.length() < Math.max(RnaSeqMetricsCollector.this.minimumLength, 100) || (mean = MathUtil.mean(MathUtil.promote(cov), 0, cov.length)) < 1.0 || best != null && !(mean > bestMean)) continue;
                    best = transcript;
                    bestMean = mean;
                }
                if (best == null) continue;
                bestPerGene.put(best, bestMean);
            }
            double[] coverages = new double[bestPerGene.size()];
            int i = 0;
            best = bestPerGene.values().iterator();
            while (best.hasNext()) {
                double d = (Double)best.next();
                coverages[i++] = d;
            }
            Arrays.sort(coverages);
            double min = coverages.length == 0 ? 0.0 : coverages[Math.max(0, coverages.length - 1001)];
            HashMap<Gene.Transcript, int[]> retval = new HashMap<Gene.Transcript, int[]>();
            for (Map.Entry entry : bestPerGene.entrySet()) {
                Gene.Transcript tx = (Gene.Transcript)entry.getKey();
                double coverage = (Double)entry.getValue();
                if (!(coverage >= min)) continue;
                retval.put(tx, transcriptCoverage.get(tx));
            }
            return retval;
        }

        private Set<Gene> getGenesWithTranscripts(Collection<Gene.Transcript> transcripts) {
            HashSet<Gene> genesWithTranscripts = new HashSet<Gene>();
            Set<Gene> genesForPickTranscripts = this.getGenesForPickTranscripts();
            for (Gene.Transcript transcript : transcripts) {
                if (!genesForPickTranscripts.contains(transcript.getGene())) continue;
                genesWithTranscripts.add(transcript.getGene());
            }
            return genesWithTranscripts;
        }
    }

    public static enum StrandSpecificity {
        NONE,
        FIRST_READ_TRANSCRIPTION_STRAND,
        SECOND_READ_TRANSCRIPTION_STRAND;

    }
}

