/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.CommandLineParser;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.analysis.CollectAlignmentSummaryMetrics;
import picard.analysis.CollectBaseDistributionByCycle;
import picard.analysis.CollectGcBiasMetrics;
import picard.analysis.CollectInsertSizeMetrics;
import picard.analysis.CollectQualityYieldMetrics;
import picard.analysis.CollectRnaSeqMetrics;
import picard.analysis.MeanQualityByCycle;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.QualityScoreDistribution;
import picard.analysis.SinglePassSamProgram;
import picard.analysis.artifacts.CollectSequencingArtifactMetrics;
import picard.analysis.directed.RnaSeqMetricsCollector;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;

@CommandLineProgramProperties(summary="Collect multiple classes of metrics.This 'meta-metrics' tool runs one or more of the metrics collection modules at the same time to cut down on the time spent reading in data from input files. Available modules include CollectAlignmentSummaryMetrics, CollectInsertSizeMetrics, QualityScoreDistribution,  MeanQualityByCycle, CollectBaseDistributionByCycle, CollectGcBiasMetrics, RnaSeqMetrics, CollectSequencingArtifactMetrics and CollectQualityYieldMetrics. The tool produces outputs of '.pdf' and '.txt' files for each module, except for the CollectAlignmentSummaryMetrics module, which outputs only a '.txt' file. Output files are named by specifying a base name (without any file extensions).<br /><br /><p>Currently all programs are run with default options and fixed output extensions, but this may become more flexible in future. Specifying a reference sequence file is required.</p><p>Note: Metrics labeled as percentages are actually expressed as fractions!</p><h4>Usage example (all modules on by default):</h4><pre>java -jar picard.jar CollectMultipleMetrics \\<br />      I=input.bam \\<br />      O=multiple_metrics \\<br />      R=reference_sequence.fasta <br /></pre><h4>Usage example (two modules only):</h4>java -jar picard.jar CollectMultipleMetrics \\<br />      I=input.bam \\<br />      O=multiple_metrics \\<br />      R=reference_sequence.fasta \\<br />      PROGRAM=null \\<br />      PROGRAM=QualityScoreDistribution \\<br />      PROGRAM=MeanQualityByCycle </pre><hr />", oneLineSummary="Collect multiple classes of metrics.", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature
public class CollectMultipleMetrics
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Collect multiple classes of metrics.";
    static final String USAGE_DETAILS = "This 'meta-metrics' tool runs one or more of the metrics collection modules at the same time to cut down on the time spent reading in data from input files. Available modules include CollectAlignmentSummaryMetrics, CollectInsertSizeMetrics, QualityScoreDistribution,  MeanQualityByCycle, CollectBaseDistributionByCycle, CollectGcBiasMetrics, RnaSeqMetrics, CollectSequencingArtifactMetrics and CollectQualityYieldMetrics. The tool produces outputs of '.pdf' and '.txt' files for each module, except for the CollectAlignmentSummaryMetrics module, which outputs only a '.txt' file. Output files are named by specifying a base name (without any file extensions).<br /><br /><p>Currently all programs are run with default options and fixed output extensions, but this may become more flexible in future. Specifying a reference sequence file is required.</p><p>Note: Metrics labeled as percentages are actually expressed as fractions!</p><h4>Usage example (all modules on by default):</h4><pre>java -jar picard.jar CollectMultipleMetrics \\<br />      I=input.bam \\<br />      O=multiple_metrics \\<br />      R=reference_sequence.fasta <br /></pre><h4>Usage example (two modules only):</h4>java -jar picard.jar CollectMultipleMetrics \\<br />      I=input.bam \\<br />      O=multiple_metrics \\<br />      R=reference_sequence.fasta \\<br />      PROGRAM=null \\<br />      PROGRAM=QualityScoreDistribution \\<br />      PROGRAM=MeanQualityByCycle </pre><hr />";
    @Argument(shortName="I", doc="Input SAM or BAM file.")
    public File INPUT;
    @Argument(shortName="AS", doc="If true (default), then the sort order in the header file will be ignored.")
    public boolean ASSUME_SORTED = true;
    @Argument(doc="Stop after processing N reads, mainly for debugging.")
    public int STOP_AFTER = 0;
    @Argument(shortName="O", doc="Base name of output files.")
    public String OUTPUT;
    private final Set<MetricAccumulationLevel> accumLevelDefault = CollectionUtil.makeSet(MetricAccumulationLevel.ALL_READS);
    @Argument(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.")
    public Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = new HashSet<MetricAccumulationLevel>(this.accumLevelDefault);
    @Argument(shortName="EXT", doc="Append the given file extension to all metric file names (ex. OUTPUT.insert_size_metrics.EXT). None if null", optional=true)
    public String FILE_EXTENSION = null;
    @Argument(doc="Set of metrics programs to apply during the pass through the SAM file.")
    public Set<Program> PROGRAM = new LinkedHashSet<Program>(Arrays.asList(Program.CollectAlignmentSummaryMetrics, Program.CollectBaseDistributionByCycle, Program.CollectInsertSizeMetrics, Program.MeanQualityByCycle, Program.QualityScoreDistribution));
    @Argument(doc="An optional list of intervals to restrict analysis to. Only pertains to some of the PROGRAMs. Programs whose stand-alone CLP does not have an INTERVALS argument will silently ignore this argument.", optional=true)
    public File INTERVALS;
    @Argument(doc="VCF format dbSNP file, used to exclude regions around known polymorphisms from analysis by some PROGRAMs; PROGRAMs whose CLP doesn't allow for this argument will quietly ignore it.", optional=true)
    public File DB_SNP;
    @Argument(doc="Gene annotations in refFlat form.  Format described here: http://genome.ucsc.edu/goldenPath/gbdDescriptionsOld.html#RefFlat", optional=true)
    public File REF_FLAT;
    @Argument(doc="If a read maps to a sequence specified with this option, all the bases in the read are counted as ignored bases.", optional=true)
    public Set<String> IGNORE_SEQUENCE = new HashSet<String>();
    @Argument(shortName="UNPAIRED", doc="Include unpaired reads in CollectSequencingArtifactMetrics. If set to true then all paired reads will be included as well - MINIMUM_INSERT_SIZE and MAXIMUM_INSERT_SIZE will be ignored in CollectSequencingArtifactMetrics.")
    public boolean INCLUDE_UNPAIRED = false;
    @Argument(doc="extra arguments to the various tools can be specified using the following format:<PROGRAM>::<ARGUMENT_AND_VALUE> where <PROGRAM> is one of the programs specified in PROGRAM, and <ARGUMENT_AND_VALUE> are the argument and value that you'd like to specify as you would on the command line. For example, to change the HISTOGRAM_WIDTH in CollectInsertSizeMetrics to 200, use:\n \"EXTRA_ARGUMENT=CollectInsertSizeMetrics::HISTOGRAM_WIDTH=200\"\n or, in the new parser:--EXTRA_ARGUMENT \"CollectInsertSizeMetrics::--HISTOGRAM_WIDTH 200\"\n (Quotes are required to avoid the shell from separating this into two arguments.) Note that the following arguments cannot be modified on a per-program level: INPUT, REFERENCE_SEQUENCE, ASSUME_SORTED, and STOP_AFTER. Providing them in an EXTRA_ARGUMENT will _not_ result in an error, but they will be silently ignored. ", optional=true)
    public List<String> EXTRA_ARGUMENT = null;
    private Set<ProgramInterface> programsToRun;
    private static final Log log = Log.getInstance(CollectMultipleMetrics.class);

    @Override
    protected String[] customCommandLineValidation() {
        if (this.PROGRAM.isEmpty()) {
            return new String[]{"No programs specified with PROGRAM"};
        }
        this.programsToRun = new LinkedHashSet<Program>(this.PROGRAM);
        return super.customCommandLineValidation();
    }

    public void setProgramsToRun(Collection<ProgramInterface> programsToRun) {
        this.programsToRun.clear();
        this.programsToRun.addAll(programsToRun);
    }

    @Override
    public int doWork() {
        if (this.OUTPUT.endsWith(".")) {
            this.OUTPUT = this.OUTPUT.substring(0, this.OUTPUT.length() - 1);
        }
        Map<ProgramInterface, List<String>> additionalArguments = CollectMultipleMetrics.processAdditionalArguments(this.EXTRA_ARGUMENT);
        ArrayList<SinglePassSamProgram> programs = new ArrayList<SinglePassSamProgram>();
        for (ProgramInterface program : this.programsToRun) {
            if (program.needsReferenceSequence() && this.REFERENCE_SEQUENCE == null) {
                throw new PicardException("The " + program.toString() + " program needs a REF Sequence, please set REFERENCE_SEQUENCE in the command line");
            }
            if (program.needsRefflatFile() && this.REF_FLAT == null) {
                throw new PicardException("The " + program.toString() + " program needs a gene annotations file, please set REF_FLAT in the command line");
            }
            if (!this.accumLevelDefault.equals(this.METRIC_ACCUMULATION_LEVEL) && !program.supportsMetricAccumulationLevel()) {
                log.warn("The " + program.toString() + " program does not support a metric accumulation level, but METRIC_ACCUMULATION_LEVEL was overridden in the command line. " + program.toString() + " will be run against the entire input.");
            }
            String outext = null != this.FILE_EXTENSION ? this.FILE_EXTENSION : "";
            SinglePassSamProgram instance = program.makeInstance(this.OUTPUT, outext, this.INPUT, this.REFERENCE_SEQUENCE, this.METRIC_ACCUMULATION_LEVEL, this.DB_SNP, this.INTERVALS, this.REF_FLAT, this.IGNORE_SEQUENCE, this.INCLUDE_UNPAIRED);
            if (additionalArguments.containsKey(program)) {
                CommandLineParser commandLineParser = CollectMultipleMetrics.getCommandLineParser(instance);
                boolean success = commandLineParser.parseArguments(System.err, additionalArguments.get(program).toArray(new String[0]));
                if (!success) {
                    throw new CommandLineException("Failed to parse arguments [" + String.join((CharSequence)",", (Iterable<? extends CharSequence>)additionalArguments.get(program)) + "] for " + program);
                }
                additionalArguments.remove(program);
            }
            instance.setDefaultHeaders(this.getDefaultHeaders());
            programs.add(instance);
        }
        if (!additionalArguments.isEmpty()) {
            throw new CommandLineException("EXTRA_ARGUMENT values were provided, but corresponding PROGRAM wasn't requested:" + additionalArguments.entrySet().stream().map(e -> ((ProgramInterface)e.getKey()).toString() + "::" + ((List)e.getValue()).toString()).collect(Collectors.joining()));
        }
        SinglePassSamProgram.makeItSo(this.INPUT, this.REFERENCE_SEQUENCE, this.ASSUME_SORTED, this.STOP_AFTER, programs);
        return 0;
    }

    private static Map<ProgramInterface, List<String>> processAdditionalArguments(List<String> arguments) {
        HashMap<ProgramInterface, List<String>> map = new HashMap<ProgramInterface, List<String>>();
        Pattern pattern = Pattern.compile("(?<program>.*)::(?<argumentAndValue>.+?)( +(?<optionalValue>.+))?");
        for (String str : arguments) {
            Program program;
            Matcher matcher = pattern.matcher(str);
            if (!matcher.matches()) {
                throw new CommandLineException("couldn't understand EXTRA_ARGUMENT " + str + " it doesn't conform to the form '<PROGRAM>::<ARGUMENT_AND_VALUE>'.");
            }
            String programName = matcher.group("program");
            try {
                program = Program.valueOf(programName);
            }
            catch (IllegalArgumentException e) {
                throw new CommandLineException("Couldn't find program with value " + programName, e);
            }
            String argumentAndValue = matcher.group("argumentAndValue");
            map.computeIfAbsent(program, k -> new ArrayList()).add(argumentAndValue);
            String optionalValue = matcher.group("optionalValue");
            if (StringUtils.isEmpty(optionalValue)) continue;
            ((List)map.get(program)).add(optionalValue);
        }
        return map;
    }

    public static enum Program implements ProgramInterface
    {
        CollectAlignmentSummaryMetrics{

            @Override
            public boolean supportsMetricAccumulationLevel() {
                return true;
            }

            @Override
            public SinglePassSamProgram makeInstance(String outbase, String outext, File input, File reference, Set<MetricAccumulationLevel> metricAccumulationLevel, File dbSnp, File intervals, File refflat, Set<String> ignoreSequence) {
                CollectAlignmentSummaryMetrics program = new CollectAlignmentSummaryMetrics();
                program.OUTPUT = new File(outbase + ".alignment_summary_metrics" + outext);
                program.METRIC_ACCUMULATION_LEVEL = metricAccumulationLevel;
                program.INPUT = input;
                program.setReferenceSequence(reference);
                return program;
            }
        }
        ,
        CollectInsertSizeMetrics{

            @Override
            public boolean supportsMetricAccumulationLevel() {
                return true;
            }

            @Override
            public SinglePassSamProgram makeInstance(String outbase, String outext, File input, File reference, Set<MetricAccumulationLevel> metricAccumulationLevel, File dbSnp, File intervals, File refflat, Set<String> ignoreSequence) {
                CollectInsertSizeMetrics program = new CollectInsertSizeMetrics();
                program.OUTPUT = new File(outbase + ".insert_size_metrics" + outext);
                program.Histogram_FILE = new File(outbase + ".insert_size_histogram.pdf");
                program.METRIC_ACCUMULATION_LEVEL = metricAccumulationLevel;
                program.INPUT = input;
                program.setReferenceSequence(reference);
                return program;
            }
        }
        ,
        QualityScoreDistribution{

            @Override
            public SinglePassSamProgram makeInstance(String outbase, String outext, File input, File reference, Set<MetricAccumulationLevel> metricAccumulationLevel, File dbSnp, File intervals, File refflat, Set<String> ignoreSequence) {
                QualityScoreDistribution program = new QualityScoreDistribution();
                program.OUTPUT = new File(outbase + ".quality_distribution_metrics" + outext);
                program.CHART_OUTPUT = new File(outbase + ".quality_distribution.pdf");
                program.INPUT = input;
                program.setReferenceSequence(reference);
                return program;
            }
        }
        ,
        MeanQualityByCycle{

            @Override
            public SinglePassSamProgram makeInstance(String outbase, String outext, File input, File reference, Set<MetricAccumulationLevel> metricAccumulationLevel, File dbSnp, File intervals, File refflat, Set<String> ignoreSequence) {
                MeanQualityByCycle program = new MeanQualityByCycle();
                program.OUTPUT = new File(outbase + ".quality_by_cycle_metrics" + outext);
                program.CHART_OUTPUT = new File(outbase + ".quality_by_cycle.pdf");
                program.INPUT = input;
                program.setReferenceSequence(reference);
                return program;
            }
        }
        ,
        CollectBaseDistributionByCycle{

            @Override
            public SinglePassSamProgram makeInstance(String outbase, String outext, File input, File reference, Set<MetricAccumulationLevel> metricAccumulationLevel, File dbSnp, File intervals, File refflat, Set<String> ignoreSequence) {
                CollectBaseDistributionByCycle program = new CollectBaseDistributionByCycle();
                program.OUTPUT = new File(outbase + ".base_distribution_by_cycle_metrics" + outext);
                program.CHART_OUTPUT = new File(outbase + ".base_distribution_by_cycle.pdf");
                program.INPUT = input;
                program.setReferenceSequence(reference);
                return program;
            }
        }
        ,
        CollectGcBiasMetrics{

            @Override
            public boolean needsReferenceSequence() {
                return true;
            }

            @Override
            public boolean supportsMetricAccumulationLevel() {
                return true;
            }

            @Override
            public SinglePassSamProgram makeInstance(String outbase, String outext, File input, File reference, Set<MetricAccumulationLevel> metricAccumulationLevel, File dbSnp, File intervals, File refflat, Set<String> ignoreSequence) {
                CollectGcBiasMetrics program = new CollectGcBiasMetrics();
                program.OUTPUT = new File(outbase + ".gc_bias.detail_metrics" + outext);
                program.SUMMARY_OUTPUT = new File(outbase + ".gc_bias.summary_metrics" + outext);
                program.CHART_OUTPUT = new File(outbase + ".gc_bias.pdf");
                program.INPUT = input;
                program.METRIC_ACCUMULATION_LEVEL = metricAccumulationLevel;
                program.SCAN_WINDOW_SIZE = 100;
                program.MINIMUM_GENOME_FRACTION = 1.0E-5;
                program.IS_BISULFITE_SEQUENCED = false;
                program.ASSUME_SORTED = false;
                program.ALSO_IGNORE_DUPLICATES = false;
                program.setReferenceSequence(reference);
                return program;
            }
        }
        ,
        RnaSeqMetrics{

            @Override
            public boolean needsRefflatFile() {
                return true;
            }

            @Override
            public boolean supportsMetricAccumulationLevel() {
                return true;
            }

            @Override
            public SinglePassSamProgram makeInstance(String outbase, String outext, File input, File reference, Set<MetricAccumulationLevel> metricAccumulationLevel, File dbSnp, File intervals, File refflat, Set<String> ignoreSequence) {
                CollectRnaSeqMetrics program = new CollectRnaSeqMetrics();
                program.OUTPUT = new File(outbase + ".rna_metrics" + outext);
                program.CHART_OUTPUT = new File(outbase + ".rna_coverage.pdf");
                program.METRIC_ACCUMULATION_LEVEL = metricAccumulationLevel;
                program.INPUT = input;
                program.RIBOSOMAL_INTERVALS = intervals;
                program.IGNORE_SEQUENCE = ignoreSequence;
                program.REF_FLAT = refflat;
                program.STRAND_SPECIFICITY = RnaSeqMetricsCollector.StrandSpecificity.SECOND_READ_TRANSCRIPTION_STRAND;
                return program;
            }
        }
        ,
        CollectSequencingArtifactMetrics{

            @Override
            public boolean needsReferenceSequence() {
                return true;
            }

            @Override
            public SinglePassSamProgram makeInstance(String outbase, String outext, File input, File reference, Set<MetricAccumulationLevel> metricAccumulationLevel, File dbSnp, File intervals, File refflat, Set<String> ignoreSequence) {
                return this.makeInstance(outbase, outext, input, reference, metricAccumulationLevel, dbSnp, intervals, refflat, ignoreSequence, false);
            }

            @Override
            public SinglePassSamProgram makeInstance(String outbase, String outext, File input, File reference, Set<MetricAccumulationLevel> metricAccumulationLevel, File dbSnp, File intervals, File refflat, Set<String> ignoreSequence, boolean includeUnpaired) {
                CollectSequencingArtifactMetrics program = new CollectSequencingArtifactMetrics();
                program.OUTPUT = new File(outbase);
                program.FILE_EXTENSION = outext;
                program.DB_SNP = dbSnp;
                program.INTERVALS = intervals;
                program.INCLUDE_UNPAIRED = includeUnpaired;
                program.INPUT = input;
                program.setReferenceSequence(reference);
                return program;
            }
        }
        ,
        CollectQualityYieldMetrics{

            @Override
            public SinglePassSamProgram makeInstance(String outbase, String outext, File input, File reference, Set<MetricAccumulationLevel> metricAccumulationLevel, File dbSnp, File intervals, File refflat, Set<String> ignoreSequence) {
                CollectQualityYieldMetrics program = new CollectQualityYieldMetrics();
                program.OUTPUT = new File(outbase + ".quality_yield_metrics" + outext);
                program.INPUT = input;
                return program;
            }
        };

    }

    public static interface ProgramInterface {
        default public SinglePassSamProgram makeInstance(String outbase, String outext, File input, File reference, Set<MetricAccumulationLevel> metricAccumulationLevel, File dbSnp, File intervals, File refflat, Set<String> ignoreSequence, boolean includeUnpaired) {
            return this.makeInstance(outbase, outext, input, reference, metricAccumulationLevel, dbSnp, intervals, refflat, ignoreSequence);
        }

        public SinglePassSamProgram makeInstance(String var1, String var2, File var3, File var4, Set<MetricAccumulationLevel> var5, File var6, File var7, File var8, Set<String> var9);

        default public boolean needsReferenceSequence() {
            return false;
        }

        default public boolean needsRefflatFile() {
            return false;
        }

        default public boolean supportsMetricAccumulationLevel() {
            return false;
        }
    }
}

