/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.TextCigarCodec;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class CigarUtil {
    private static final Log log = Log.getInstance(CigarUtil.class);

    public static List<CigarElement> softClipEndOfRead(int clipFrom, List<CigarElement> oldCigar) {
        int clippedBases = CoordMath.getLength(clipFrom, Cigar.getReadLength(oldCigar));
        LinkedList<CigarElement> newCigar = new LinkedList<CigarElement>();
        int pos = 1;
        for (CigarElement c : oldCigar) {
            CigarOperator op = c.getOperator();
            int length = op.consumesReadBases() ? c.getLength() : 0;
            int endPos = pos + length - 1;
            if (endPos < clipFrom - 1) {
                newCigar.add(c);
            } else if (endPos >= clipFrom - 1) {
                CigarUtil.elementStraddlesClippedRead(newCigar, c, clipFrom - 1 - (pos - 1), clippedBases);
                break;
            }
            pos = endPos + 1;
        }
        return newCigar;
    }

    private static void elementStraddlesClippedRead(List<CigarElement> newCigar, CigarElement c, int relativeClippedPosition, int clippedBases) {
        CigarOperator op = c.getOperator();
        int clipAmount = clippedBases;
        if (op.consumesReadBases()) {
            if (op.consumesReferenceBases() && relativeClippedPosition > 0) {
                newCigar.add(new CigarElement(relativeClippedPosition, op));
            }
            if (!op.consumesReferenceBases()) {
                clipAmount = clippedBases + relativeClippedPosition;
            }
        } else if (relativeClippedPosition != 0) {
            throw new SAMException("Unexpected non-0 relativeClippedPosition " + relativeClippedPosition);
        }
        newCigar.add(new CigarElement(clipAmount, CigarOperator.S));
    }

    public static void softClip3PrimeEndOfRead(SAMRecord rec, int clipFrom) {
        Cigar cigar = rec.getCigar();
        boolean negativeStrand = rec.getReadNegativeStrandFlag();
        List<CigarElement> oldCigar = cigar.getCigarElements();
        if (!CigarUtil.isValidCigar(rec, cigar, true)) {
            return;
        }
        if (negativeStrand) {
            oldCigar = new ArrayList<CigarElement>(oldCigar);
            Collections.reverse(oldCigar);
        }
        List<CigarElement> newCigarElems = CigarUtil.softClipEndOfRead(clipFrom, oldCigar);
        if (negativeStrand) {
            Collections.reverse(newCigarElems);
        }
        Cigar newCigar = new Cigar(newCigarElems);
        if (negativeStrand) {
            int newLength;
            int oldLength = cigar.getReferenceLength();
            int sizeChange = oldLength - (newLength = newCigar.getReferenceLength());
            if (sizeChange > 0) {
                rec.setAlignmentStart(rec.getAlignmentStart() + sizeChange);
            } else if (sizeChange < 0) {
                throw new SAMException("The clipped length " + newLength + " is longer than the old unclipped length " + oldLength);
            }
        }
        rec.setCigar(newCigar);
        boolean hasMappedBases = false;
        for (CigarElement elem : newCigar.getCigarElements()) {
            CigarOperator op = elem.getOperator();
            if (!op.consumesReferenceBases() || !op.consumesReadBases()) continue;
            hasMappedBases = true;
            break;
        }
        if (!hasMappedBases) {
            rec.setReadUnmappedFlag(true);
            rec.setCigarString("*");
            rec.setReferenceIndex(-1);
            rec.setAlignmentStart(0);
            rec.setMappingQuality(0);
            rec.setInferredInsertSize(0);
        } else if (!CigarUtil.isValidCigar(rec, newCigar, false)) {
            throw new IllegalStateException("Invalid new Cigar: " + newCigar + " (" + oldCigar + ") for " + rec.getReadName());
        }
    }

    private static boolean isValidCigar(SAMRecord rec, Cigar cigar, boolean isOldCigar) {
        List<SAMValidationError> validationErrors;
        if (cigar == null || cigar.getCigarElements() == null || cigar.getCigarElements().isEmpty()) {
            if (isOldCigar) {
                if (!rec.getReadUnmappedFlag()) {
                    log.warn("Cigar is empty for read " + rec);
                }
            } else {
                log.error("Empty new cigar");
            }
            return false;
        }
        if (rec.getReadUnmappedFlag()) {
            log.info("Unmapped read with cigar: " + rec.getReadName() + " (" + rec.getCigarString() + "/" + cigar.toString() + ")");
        }
        if ((validationErrors = cigar.isValid(rec.getReadName(), -1L)) != null && !validationErrors.isEmpty()) {
            log.error("Invalid cigar for read " + rec + (isOldCigar ? " " : " for new cigar with clipped adapter ") + " (" + rec.getCigarString() + "/" + cigar.toString() + ") " + validationErrors);
            return false;
        }
        if (rec.getReadLength() != cigar.getReadLength()) {
            log.error(rec.getReadLength() + " read length does not = cigar length " + cigar.getReferenceLength() + (isOldCigar ? " oldCigar " : " ") + rec + " cigar:" + cigar);
            return false;
        }
        return true;
    }

    public static Cigar addSoftClippedBasesToEndsOfCigar(Cigar cigar, boolean negativeStrand, int threePrimeEnd, int fivePrimeEnd) {
        ArrayList<CigarElement> newCigar = new ArrayList<CigarElement>(cigar.getCigarElements());
        if (negativeStrand) {
            Collections.reverse(newCigar);
        }
        if (threePrimeEnd > 0) {
            int last = newCigar.size() - 1;
            int bases = threePrimeEnd;
            if (((CigarElement)newCigar.get(last)).getOperator() == CigarOperator.SOFT_CLIP) {
                CigarElement oldSoftClip = (CigarElement)newCigar.remove(last);
                bases += oldSoftClip.getLength();
            }
            newCigar.add(new CigarElement(bases, CigarOperator.SOFT_CLIP));
        }
        if (fivePrimeEnd > 0) {
            int bases = fivePrimeEnd;
            if (((CigarElement)newCigar.get(0)).getOperator() == CigarOperator.SOFT_CLIP) {
                CigarElement oldSoftClip = (CigarElement)newCigar.remove(0);
                bases += oldSoftClip.getLength();
            }
            newCigar.add(0, new CigarElement(bases, CigarOperator.SOFT_CLIP));
        }
        if (negativeStrand) {
            Collections.reverse(newCigar);
        }
        return new Cigar(newCigar);
    }

    public static char[] cigarArrayFromElements(List<CigarElement> cigar) {
        int pos = 0;
        int length = 0;
        for (CigarElement e : cigar) {
            length += e.getLength();
        }
        char[] result = new char[length];
        for (CigarElement e : cigar) {
            for (int i = 0; i < e.getLength(); ++i) {
                CigarOperator o = e.getOperator();
                result[i + pos] = (char)CigarOperator.enumToCharacter(o);
            }
            pos += e.getLength();
        }
        return result;
    }

    public static char[] cigarArrayFromString(String cigar) {
        return CigarUtil.cigarArrayFromElements(TextCigarCodec.decode(cigar).getCigarElements());
    }

    public static String cigarStringFromArray(char[] cigar) {
        String result = "";
        int length = cigar.length;
        char lastOp = '\u0000';
        int lastLen = 0;
        for (int i = 0; i < length; ++i) {
            if (cigar[i] == lastOp) {
                ++lastLen;
                continue;
            }
            if (cigar[i] == '-') continue;
            if (lastOp != '\u0000') {
                result = result + Integer.toString(lastLen) + Character.toString(lastOp);
            }
            lastLen = 1;
            lastOp = cigar[i];
        }
        return result + Integer.toString(lastLen) + Character.toString(lastOp);
    }
}

