/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.SAMBinaryTagAndUnsignedArrayValue;
import htsjdk.samtools.SAMBinaryTagAndValue;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.CRAIEntry;
import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.compression.ExternalCompressor;
import htsjdk.samtools.cram.digest.ContentDigests;
import htsjdk.samtools.cram.encoding.reader.CramRecordReader;
import htsjdk.samtools.cram.encoding.reader.MultiRefSliceAlignmentSpanReader;
import htsjdk.samtools.cram.encoding.writer.CramRecordWriter;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.DefaultBitInputStream;
import htsjdk.samtools.cram.io.DefaultBitOutputStream;
import htsjdk.samtools.cram.ref.ReferenceContext;
import htsjdk.samtools.cram.structure.AlignmentSpan;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.block.Block;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.SequenceUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Slice {
    public static final int NO_ALIGNMENT_START = -1;
    public static final int NO_ALIGNMENT_SPAN = 0;
    public static final int NO_ALIGNMENT_END = 0;
    private static final Log log = Log.getInstance(Slice.class);
    private final ReferenceContext referenceContext;
    public int alignmentStart = -1;
    public int alignmentSpan = 0;
    public int nofRecords = -1;
    public long globalRecordCounter = -1L;
    public int nofBlocks = -1;
    public int[] contentIDs;
    public int embeddedRefBlockContentID = -1;
    public byte[] refMD5 = new byte[16];
    public Block headerBlock;
    public Block coreBlock;
    public Block embeddedRefBlock;
    public Map<Integer, Block> external;
    public static final int UNINITIALIZED_INDEXING_PARAMETER = -1;
    public int byteOffsetFromCompressionHeaderStart = -1;
    public long containerByteOffset = -1L;
    public int byteSize = -1;
    public int index = -1;
    public long bases;
    public SAMBinaryTagAndValue sliceTags;
    public int mappedReadsCount = 0;
    public int unmappedReadsCount = 0;
    public int unplacedReadsCount = 0;

    public Slice(ReferenceContext refContext) {
        this.referenceContext = refContext;
    }

    public ReferenceContext getReferenceContext() {
        return this.referenceContext;
    }

    public void baiIndexInitializationCheck() {
        StringBuilder error = new StringBuilder();
        if (this.byteOffsetFromCompressionHeaderStart == -1) {
            error.append("Cannot index this Slice for BAI because its byteOffsetFromCompressionHeaderStart is unknown.").append(System.lineSeparator());
        }
        if (this.containerByteOffset == -1L) {
            error.append("Cannot index this Slice for BAI because its containerByteOffset is unknown.").append(System.lineSeparator());
        }
        if (this.index == -1) {
            error.append("Cannot index this Slice for BAI because its index is unknown.").append(System.lineSeparator());
        }
        if (error.length() > 0) {
            throw new CRAMException(error.toString());
        }
    }

    void craiIndexInitializationCheck() {
        StringBuilder error = new StringBuilder();
        if (this.byteOffsetFromCompressionHeaderStart == -1) {
            error.append("Cannot index this Slice for CRAI because its byteOffsetFromCompressionHeaderStart is unknown.").append(System.lineSeparator());
        }
        if (this.containerByteOffset == -1L) {
            error.append("Cannot index this Slice for CRAI because its containerByteOffset is unknown.").append(System.lineSeparator());
        }
        if (this.byteSize == -1) {
            error.append("Cannot index this Slice for CRAI because its byteSize is unknown.").append(System.lineSeparator());
        }
        if (error.length() > 0) {
            throw new CRAMException(error.toString());
        }
    }

    private void alignmentBordersSanityCheck(byte[] ref) {
        if (this.referenceContext.isUnmappedUnplaced()) {
            return;
        }
        if (this.alignmentStart > 0 && this.referenceContext.isMappedSingleRef() && ref == null) {
            throw new IllegalArgumentException("Mapped slice reference is null.");
        }
        if (this.alignmentStart > ref.length) {
            log.error(String.format("Slice mapped outside of reference: seqID=%s, start=%d, counter=%d.", this.referenceContext, this.alignmentStart, this.globalRecordCounter));
            throw new RuntimeException("Slice mapped outside of the reference.");
        }
        if (this.alignmentStart - 1 + this.alignmentSpan > ref.length) {
            log.warn(String.format("Slice partially mapped outside of reference: seqID=%s, start=%d, span=%d, counter=%d.", this.referenceContext, this.alignmentStart, this.alignmentSpan, this.globalRecordCounter));
        }
    }

    public boolean validateRefMD5(byte[] ref) {
        if (this.referenceContext.isMultiRef()) {
            throw new SAMException("Cannot verify a slice with multiple references on a single reference.");
        }
        if (this.referenceContext.isUnmappedUnplaced()) {
            return true;
        }
        this.alignmentBordersSanityCheck(ref);
        if (!Slice.validateRefMD5(ref, this.alignmentStart, this.alignmentSpan, this.refMD5)) {
            int shoulderLength = 10;
            String excerpt = Slice.getBrief(this.alignmentStart, this.alignmentSpan, ref, 10);
            if (Slice.validateRefMD5(ref, this.alignmentStart, this.alignmentSpan - 1, this.refMD5)) {
                log.warn(String.format("Reference MD5 matches partially for slice %s:%d-%d, %s", this.referenceContext, this.alignmentStart, this.alignmentStart + this.alignmentSpan - 1, excerpt));
                return true;
            }
            log.error(String.format("Reference MD5 mismatch for slice %s:%d-%d, %s", this.referenceContext, this.alignmentStart, this.alignmentStart + this.alignmentSpan - 1, excerpt));
            return false;
        }
        return true;
    }

    private static boolean validateRefMD5(byte[] ref, int alignmentStart, int alignmentSpan, byte[] expectedMD5) {
        int span = Math.min(alignmentSpan, ref.length - alignmentStart + 1);
        String md5 = SequenceUtil.calculateMD5String(ref, alignmentStart - 1, span);
        return md5.equals(String.format("%032x", new BigInteger(1, expectedMD5)));
    }

    private static String getBrief(int startOneBased, int span, byte[] bases, int shoulderLength) {
        if (span >= bases.length) {
            return new String(bases);
        }
        StringBuilder sb = new StringBuilder();
        int fromInc = startOneBased - 1;
        int toExc = startOneBased + span - 1;
        if ((toExc = Math.min(toExc, bases.length)) - fromInc <= 2 * shoulderLength) {
            sb.append(new String(Arrays.copyOfRange(bases, fromInc, toExc)));
        } else {
            sb.append(new String(Arrays.copyOfRange(bases, fromInc, fromInc + shoulderLength)));
            sb.append("...");
            sb.append(new String(Arrays.copyOfRange(bases, toExc - shoulderLength, toExc)));
        }
        return sb.toString();
    }

    public String toString() {
        return String.format("slice: seqID %s, start %d, span %d, records %d.", this.referenceContext, this.alignmentStart, this.alignmentSpan, this.nofRecords);
    }

    public void setRefMD5(byte[] ref) {
        this.alignmentBordersSanityCheck(ref);
        if (!this.referenceContext.isMappedSingleRef() && this.alignmentStart < 1) {
            this.refMD5 = new byte[16];
            Arrays.fill(this.refMD5, (byte)0);
            log.debug("Empty slice ref md5 is set.");
        } else {
            int span = Math.min(this.alignmentSpan, ref.length - this.alignmentStart + 1);
            if (this.alignmentStart + span > ref.length + 1) {
                throw new RuntimeException("Invalid alignment boundaries.");
            }
            this.refMD5 = SequenceUtil.calculateMD5(ref, this.alignmentStart - 1, span);
            if (Log.isEnabled(Log.LogLevel.DEBUG)) {
                StringBuilder sb = new StringBuilder();
                int shoulder = 10;
                if (ref.length <= 20) {
                    sb.append(new String(ref));
                } else {
                    sb.append(Slice.getBrief(this.alignmentStart, this.alignmentSpan, ref, 10));
                }
                log.debug(String.format("Slice md5: %s for %s:%d-%d, %s", String.format("%032x", new BigInteger(1, this.refMD5)), this.referenceContext, this.alignmentStart, this.alignmentStart + span - 1, sb.toString()));
            }
        }
    }

    public Object getAttribute(short tag) {
        if (this.sliceTags == null) {
            return null;
        }
        SAMBinaryTagAndValue tmp = this.sliceTags.find(tag);
        if (tmp != null) {
            return tmp.value;
        }
        return null;
    }

    public void setAttribute(String tag, Object value) {
        if (value != null && value.getClass().isArray() && Array.getLength(value) == 0) {
            throw new IllegalArgumentException("Empty value passed for tag " + tag);
        }
        this.setAttribute(SAMTag.makeBinaryTag(tag), value);
    }

    public void setUnsignedArrayAttribute(String tag, Object value) {
        if (!value.getClass().isArray()) {
            throw new IllegalArgumentException("Non-array passed to setUnsignedArrayAttribute for tag " + tag);
        }
        if (Array.getLength(value) == 0) {
            throw new IllegalArgumentException("Empty array passed to setUnsignedArrayAttribute for tag " + tag);
        }
        this.setAttribute(SAMTag.makeBinaryTag(tag), value, true);
    }

    void setAttribute(short tag, Object value) {
        this.setAttribute(tag, value, false);
    }

    void setAttribute(short tag, Object value, boolean isUnsignedArray) {
        if (value == null) {
            if (this.sliceTags != null) {
                this.sliceTags = this.sliceTags.remove(tag);
            }
        } else {
            SAMBinaryTagAndValue tmp = !isUnsignedArray ? new SAMBinaryTagAndValue(tag, value) : new SAMBinaryTagAndUnsignedArrayValue(tag, value);
            this.sliceTags = this.sliceTags == null ? tmp : this.sliceTags.insert(tmp);
        }
    }

    private BitInputStream getCoreBlockInputStream() {
        return new DefaultBitInputStream(new ByteArrayInputStream(this.coreBlock.getUncompressedContent()));
    }

    private Map<Integer, ByteArrayInputStream> getExternalBlockInputMap() {
        return this.external.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ByteArrayInputStream(((Block)e.getValue()).getUncompressedContent())));
    }

    public CramRecordReader createCramRecordReader(CompressionHeader header, ValidationStringency validationStringency) {
        return new CramRecordReader(this.getCoreBlockInputStream(), this.getExternalBlockInputMap(), header, this.referenceContext, validationStringency);
    }

    public Map<ReferenceContext, AlignmentSpan> getMultiRefAlignmentSpans(CompressionHeader header, ValidationStringency validationStringency) {
        MultiRefSliceAlignmentSpanReader reader = new MultiRefSliceAlignmentSpanReader(this.getCoreBlockInputStream(), this.getExternalBlockInputMap(), header, validationStringency, this.alignmentStart, this.nofRecords);
        return reader.getReferenceSpans();
    }

    public List<CRAIEntry> getCRAIEntries(CompressionHeader compressionHeader) {
        if (!compressionHeader.isCoordinateSorted()) {
            throw new CRAMException("Cannot construct index if the CRAM is not Coordinate Sorted");
        }
        this.craiIndexInitializationCheck();
        if (this.referenceContext.isMultiRef()) {
            Map<ReferenceContext, AlignmentSpan> spans = this.getMultiRefAlignmentSpans(compressionHeader, ValidationStringency.DEFAULT_STRINGENCY);
            return spans.entrySet().stream().map(e -> new CRAIEntry(((ReferenceContext)e.getKey()).getSerializableId(), ((AlignmentSpan)e.getValue()).getStart(), ((AlignmentSpan)e.getValue()).getSpan(), this.containerByteOffset, this.byteOffsetFromCompressionHeaderStart, this.byteSize)).sorted().collect(Collectors.toList());
        }
        int sequenceId = this.referenceContext.getSerializableId();
        return Collections.singletonList(new CRAIEntry(sequenceId, this.alignmentStart, this.alignmentSpan, this.containerByteOffset, this.byteOffsetFromCompressionHeaderStart, this.byteSize));
    }

    public static Slice buildSlice(List<CramCompressionRecord> records, CompressionHeader header) {
        Slice slice = Slice.initializeFromRecords(records);
        HashMap<Integer, ByteArrayOutputStream> externalBlockMap = new HashMap<Integer, ByteArrayOutputStream>();
        for (int id : header.externalIds) {
            externalBlockMap.put(id, new ByteArrayOutputStream());
        }
        try (ByteArrayOutputStream bitBAOS = new ByteArrayOutputStream();
             DefaultBitOutputStream bitOutputStream = new DefaultBitOutputStream(bitBAOS);){
            CramRecordWriter writer = new CramRecordWriter(bitOutputStream, externalBlockMap, header, slice.referenceContext);
            writer.writeCramCompressionRecords(records, slice.alignmentStart);
            bitOutputStream.close();
            slice.coreBlock = Block.createRawCoreDataBlock(bitBAOS.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        slice.external = new HashMap<Integer, Block>();
        for (Integer contentId : externalBlockMap.keySet()) {
            if (contentId == 0) {
                throw new CRAMException("Valid Content ID required.  Given: " + contentId);
            }
            ExternalCompressor compressor = header.externalCompressors.get(contentId);
            byte[] rawContent = ((ByteArrayOutputStream)externalBlockMap.get(contentId)).toByteArray();
            Block externalBlock = Block.createExternalBlock(compressor.getMethod(), contentId, compressor.compress(rawContent), rawContent.length);
            slice.external.put(contentId, externalBlock);
        }
        return slice;
    }

    private static Slice initializeFromRecords(Collection<CramCompressionRecord> records) {
        ReferenceContext sliceRefContext;
        ContentDigests hasher = ContentDigests.create(ContentDigests.ALL);
        HashSet<ReferenceContext> referenceContexts = new HashSet<ReferenceContext>();
        int singleRefAlignmentStart = Integer.MAX_VALUE;
        int singleRefAlignmentEnd = 0;
        int baseCount = 0;
        int mappedReadsCount = 0;
        int unmappedReadsCount = 0;
        int unplacedReadsCount = 0;
        for (CramCompressionRecord record : records) {
            hasher.add(record);
            baseCount += record.readLength;
            if (record.isPlaced()) {
                referenceContexts.add(new ReferenceContext(record.sequenceId));
                singleRefAlignmentStart = Math.min(record.alignmentStart, singleRefAlignmentStart);
                singleRefAlignmentEnd = Math.max(record.getAlignmentEnd(), singleRefAlignmentEnd);
                if (record.isSegmentUnmapped()) {
                    ++unmappedReadsCount;
                } else {
                    ++mappedReadsCount;
                }
            } else {
                referenceContexts.add(ReferenceContext.UNMAPPED_UNPLACED_CONTEXT);
            }
            if (record.alignmentStart != 0) continue;
            ++unplacedReadsCount;
        }
        switch (referenceContexts.size()) {
            case 0: {
                sliceRefContext = ReferenceContext.UNMAPPED_UNPLACED_CONTEXT;
                break;
            }
            case 1: {
                sliceRefContext = (ReferenceContext)referenceContexts.iterator().next();
                break;
            }
            default: {
                sliceRefContext = ReferenceContext.MULTIPLE_REFERENCE_CONTEXT;
            }
        }
        Slice slice = new Slice(sliceRefContext);
        if (sliceRefContext.isMappedSingleRef()) {
            slice.alignmentStart = singleRefAlignmentStart;
            slice.alignmentSpan = singleRefAlignmentEnd - singleRefAlignmentStart + 1;
        }
        slice.sliceTags = hasher.getAsTags();
        slice.bases = baseCount;
        slice.nofRecords = records.size();
        slice.mappedReadsCount = mappedReadsCount;
        slice.unmappedReadsCount = unmappedReadsCount;
        slice.unplacedReadsCount = unplacedReadsCount;
        return slice;
    }
}

