/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.ByteArrayLenCodec;
import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.encoding.CRAMEncoding;
import htsjdk.samtools.cram.encoding.EncodingFactory;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.DataSeriesType;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;

public class ByteArrayLenEncoding
extends CRAMEncoding<byte[]> {
    private final CRAMEncoding<Integer> lenEncoding;
    private final CRAMEncoding<byte[]> byteEncoding;

    public ByteArrayLenEncoding(CRAMEncoding<Integer> lenEncoding, CRAMEncoding<byte[]> byteEncoding) {
        super(EncodingID.BYTE_ARRAY_LEN);
        this.lenEncoding = lenEncoding;
        this.byteEncoding = byteEncoding;
    }

    public static ByteArrayLenEncoding fromParams(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        EncodingID lenID = EncodingID.values()[buffer.get()];
        int lenLength = ITF8.readUnsignedITF8(buffer);
        byte[] lenBytes = new byte[lenLength];
        buffer.get(lenBytes);
        CRAMEncoding<Integer> lenEncoding = EncodingFactory.createEncoding(DataSeriesType.INT, lenID, lenBytes);
        EncodingID byteID = EncodingID.values()[buffer.get()];
        int byteLength = ITF8.readUnsignedITF8(buffer);
        byte[] byteBytes = new byte[byteLength];
        buffer.get(byteBytes);
        CRAMEncoding<byte[]> byteEncoding = EncodingFactory.createEncoding(DataSeriesType.BYTE_ARRAY, byteID, byteBytes);
        return new ByteArrayLenEncoding(lenEncoding, byteEncoding);
    }

    @Override
    public byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write((byte)this.lenEncoding.id().getId());
            byte[] lenBytes = this.lenEncoding.toByteArray();
            ITF8.writeUnsignedITF8(lenBytes.length, byteArrayOutputStream);
            byteArrayOutputStream.write(lenBytes);
            byteArrayOutputStream.write((byte)this.byteEncoding.id().getId());
            byte[] byteBytes = this.byteEncoding.toByteArray();
            ITF8.writeUnsignedITF8(byteBytes.length, byteArrayOutputStream);
            byteArrayOutputStream.write(byteBytes);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public CRAMCodec<byte[]> buildCodec(BitInputStream coreBlockInputStream, BitOutputStream coreBlockOutputStream, Map<Integer, ByteArrayInputStream> externalBlockInputMap, Map<Integer, ByteArrayOutputStream> externalBlockOutputMap) {
        return new ByteArrayLenCodec(this.lenEncoding.buildCodec(coreBlockInputStream, coreBlockOutputStream, externalBlockInputMap, externalBlockOutputMap), this.byteEncoding.buildCodec(coreBlockInputStream, coreBlockOutputStream, externalBlockInputMap, externalBlockOutputMap));
    }
}

