/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Scanner;
import javax.imageio.ImageIO;

public class jHeatmap {
    protected static File SAMPLE = null;
    protected static int startROW = 1;
    protected static int startCOL = 2;
    protected static int pixelWidth = 200;
    protected static int pixelHeight = 600;
    protected static String scaleType = "treeview";
    protected static double quantile = 0.9;
    protected static double absolute = -999.0;
    protected static String COLOR = null;
    public static Color MINCOLOR = new Color(255, 255, 255);
    public static Color MAXCOLOR = new Color(255, 0, 0);
    protected static String OUTPUTPATH = null;
    protected static String FILEID = null;
    private static ArrayList<double[]> MATRIX = null;
    public static double COLOR_RATIO = 1.0;

    public static void main(String[] args) throws IOException {
        System.out.println(jHeatmap.getTimeStamp());
        jHeatmap.loadConfig(args);
        System.out.println("Loading Matrix file...");
        MATRIX = jHeatmap.loadMatrix(SAMPLE);
        System.out.println("Matrix file loaded.");
        System.out.println("Rows detected: " + MATRIX.size());
        System.out.println("Columns detected: " + MATRIX.get(0).length);
        if (scaleType.equalsIgnoreCase("treeview")) {
            ArrayList<double[]> newMatrix = jHeatmap.rebinMatrix(MATRIX);
            COLOR_RATIO = absolute != -999.0 ? absolute : jHeatmap.getQuantile(newMatrix, quantile);
            System.out.println("Contrast threshold: " + COLOR_RATIO);
            BufferedImage treeMap = jHeatmap.generateHeatMap(newMatrix);
            ImageIO.write((RenderedImage)treeMap, "png", new File(String.valueOf(OUTPUTPATH) + File.separator + FILEID + "_" + scaleType + ".png"));
        } else if (!scaleType.equalsIgnoreCase("treeview")) {
            COLOR_RATIO = absolute != -999.0 ? absolute : jHeatmap.getQuantile(MATRIX, quantile);
            System.out.println("Contrast threshold: " + COLOR_RATIO);
            BufferedImage rawMap = jHeatmap.generateHeatMap(MATRIX);
            ImageIO.write((RenderedImage)jHeatmap.resize(rawMap, pixelWidth, pixelHeight), "png", new File(String.valueOf(OUTPUTPATH) + File.separator + FILEID + "_" + scaleType + ".png"));
        }
        System.out.println("Program Complete");
        System.out.println(jHeatmap.getTimeStamp());
    }

    public static BufferedImage generateHeatMap(ArrayList<double[]> matrix) throws FileNotFoundException {
        int width = 1;
        int height = 1;
        int pixwidth = matrix.get(0).length * width;
        int pixheight = matrix.size() * height;
        System.setProperty("java.awt.headless", "true");
        BufferedImage im = new BufferedImage(pixwidth, pixheight, 2);
        Graphics g = im.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(new Color(255, 255, 255));
        g2.fillRect(0, 0, pixwidth, pixheight);
        int count = 0;
        int x = 0;
        while (x < matrix.size()) {
            double[] ID = matrix.get(x);
            int j = 0;
            while (j < ID.length) {
                if (ID[j] > 0.0) {
                    double v = ID[j] / COLOR_RATIO;
                    double sVal = v > 1.0 ? 1.0 : (v < 0.0 ? 0.0 : v);
                    int red = (int)((double)MAXCOLOR.getRed() * sVal + (double)MINCOLOR.getRed() * (1.0 - sVal));
                    int green = (int)((double)MAXCOLOR.getGreen() * sVal + (double)MINCOLOR.getGreen() * (1.0 - sVal));
                    int blue = (int)((double)MAXCOLOR.getBlue() * sVal + (double)MINCOLOR.getBlue() * (1.0 - sVal));
                    g.setColor(new Color(red, green, blue));
                } else {
                    g.setColor(Color.WHITE);
                }
                g.fillRect(j * width, count * height, width, height);
                ++j;
            }
            ++count;
            ++x;
        }
        return im;
    }

    public static BufferedImage resize(BufferedImage img, int newW, int newH) {
        BufferedImage resized_image = new BufferedImage(newW, newH, 2);
        Graphics2D g2 = resized_image.createGraphics();
        if (scaleType.equalsIgnoreCase("bicubic")) {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        } else if (scaleType.equalsIgnoreCase("bilinear")) {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        } else if (scaleType.equalsIgnoreCase("neighbor")) {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        }
        g2.drawImage(img, 0, 0, newW, newH, null);
        g2.dispose();
        return resized_image;
    }

    public static ArrayList<double[]> rebinMatrix(ArrayList<double[]> oldmatrix) {
        int x;
        ArrayList<double[]> temp;
        ArrayList<double[]> newmatrix = new ArrayList<double[]>();
        int R = oldmatrix.size();
        int C = oldmatrix.get(0).length;
        int r = pixelHeight;
        int c = pixelWidth;
        if (r > R) {
            int rowAdd = r / R + 1;
            temp = new ArrayList<double[]>();
            x = 0;
            while (x < R) {
                int y = 0;
                while (y <= rowAdd) {
                    temp.add((double[])((double[])oldmatrix.get(x)).clone());
                    ++y;
                }
                ++x;
            }
            oldmatrix = temp;
            R = oldmatrix.size();
        }
        if (c > C) {
            int colAdd = c / C + 1;
            temp = new ArrayList();
            x = 0;
            while (x < R) {
                double[] oldarray = (double[])oldmatrix.get(x);
                double[] newarray = new double[oldarray.length * colAdd];
                int y = 0;
                while (y < newarray.length) {
                    newarray[y] = oldarray[y / colAdd];
                    ++y;
                }
                temp.add(newarray);
                ++x;
            }
            oldmatrix = temp;
            C = ((double[])oldmatrix.get(0)).length;
        }
        int rowDelete = R % r;
        int colDelete = C % c;
        if (rowDelete > 0) {
            int[] row_delete = jHeatmap.linspace(0, R - 1, rowDelete);
            int x2 = 0;
            while (x2 < row_delete.length) {
                if (row_delete[x2] == oldmatrix.size() - 1) {
                    int n = x2;
                    row_delete[n] = row_delete[n] - 1;
                }
                ++x2;
            }
            int[] row_delete_plus1 = jHeatmap.frameshift(row_delete);
            if (row_delete.length != row_delete_plus1.length) {
                System.err.println("Row delete frameshift/merge failure!!!");
                System.exit(1);
            }
            int x3 = 0;
            while (x3 < row_delete.length) {
                double[] oldrow = (double[])oldmatrix.get(row_delete[x3]);
                double[] updatedrow = (double[])oldmatrix.get(row_delete_plus1[x3]);
                int y = 0;
                while (y < oldrow.length) {
                    updatedrow[y] = (oldrow[y] + updatedrow[y]) / 2.0;
                    ++y;
                }
                ++x3;
            }
            x3 = row_delete.length - 1;
            while (x3 >= 0) {
                oldmatrix.remove(row_delete[x3]);
                --x3;
            }
            R = oldmatrix.size();
        }
        if (colDelete > 0) {
            int[] col_delete = jHeatmap.linspace(0, C - 1, colDelete);
            int x4 = 0;
            while (x4 < col_delete.length) {
                if (col_delete[x4] == ((double[])oldmatrix.get(0)).length - 1) {
                    int n = x4;
                    col_delete[n] = col_delete[n] - 1;
                }
                ++x4;
            }
            int[] col_delete_plus1 = jHeatmap.frameshift(col_delete);
            if (col_delete.length != col_delete_plus1.length) {
                System.err.println("Column delete frameshift/merge failure!!!");
                System.exit(1);
            }
            int x5 = 0;
            while (x5 < oldmatrix.size()) {
                double[] oldcol = (double[])oldmatrix.get(x5);
                double[] avgcol = (double[])oldcol.clone();
                int y = 0;
                while (y < col_delete.length) {
                    avgcol[col_delete_plus1[y]] = (oldcol[col_delete[y]] + oldcol[col_delete_plus1[y]]) / 2.0;
                    ++y;
                }
                double[] updatedcol = new double[oldcol.length - col_delete.length];
                int currentIndex = 0;
                int y2 = 0;
                while (y2 < oldcol.length) {
                    boolean remove = false;
                    int z = 0;
                    while (z < col_delete.length) {
                        if (col_delete[z] == y2) {
                            remove = true;
                        }
                        ++z;
                    }
                    if (!remove) {
                        updatedcol[currentIndex] = avgcol[y2];
                        ++currentIndex;
                    }
                    ++y2;
                }
                oldmatrix.set(x5, updatedcol);
                ++x5;
            }
            C = ((double[])oldmatrix.get(0)).length;
        }
        if (R % r != 0) {
            System.err.println("Failure to remove rows modularly!!!");
            System.exit(1);
        }
        if (C % c != 0) {
            System.err.println("Failure to remove columns modularly!!!");
            System.exit(1);
        }
        int i = 0;
        while (i < R) {
            double[] newRow = new double[c];
            int j = 0;
            while (j < C) {
                double AVG = 0.0;
                double count = 0.0;
                int x6 = i;
                while (x6 < i + R / r) {
                    int y = j;
                    while (y < j + C / c) {
                        AVG += ((double[])oldmatrix.get(x6))[y];
                        count += 1.0;
                        ++y;
                    }
                    ++x6;
                }
                newRow[j / (C / c)] = AVG / count;
                j += C / c;
            }
            newmatrix.add(newRow);
            i += R / r;
        }
        return newmatrix;
    }

    public static void printArray(int[] array) {
        int x = 0;
        while (x < array.length) {
            System.out.print(String.valueOf(array[x]) + "\t");
            ++x;
        }
        System.out.println();
    }

    public static void printMatrix(ArrayList<double[]> array) {
        int x = 0;
        while (x < array.size()) {
            int y = 0;
            while (y < array.get(x).length) {
                System.out.print(String.valueOf(array.get(x)[y]) + "\t");
                ++y;
            }
            System.out.println();
            ++x;
        }
    }

    public static int[] linspace(int min, int max, int points) {
        int[] d = new int[points];
        if (points < 0) {
            System.err.println("Invalid number of points to parse!!!\n" + points);
            System.exit(1);
        }
        int i = 1;
        while (i < points) {
            d[i] = min + i * (max - min) / (points - 1);
            ++i;
        }
        return d;
    }

    public static int[] frameshift(int[] orig) {
        int[] newarray = new int[orig.length];
        int x = 0;
        while (x < orig.length) {
            newarray[x] = orig[x] + 1;
            ++x;
        }
        return newarray;
    }

    public static double getNonZeroAvg(ArrayList<double[]> matrix) {
        double average = 0.0;
        int count = 0;
        int x = 0;
        while (x < matrix.size()) {
            int y = 0;
            while (y < matrix.get(x).length) {
                if (matrix.get(x)[y] != 0.0) {
                    average += matrix.get(x)[y];
                    ++count;
                }
                ++y;
            }
            ++x;
        }
        if (count != 0) {
            average /= (double)count;
        }
        return average;
    }

    public static double getQuantile(ArrayList<double[]> matrix, double percent) {
        ArrayList<Double> nonZero = new ArrayList<Double>();
        int x = 0;
        while (x < matrix.size()) {
            int y = 0;
            while (y < matrix.get(x).length) {
                if (matrix.get(x)[y] != 0.0) {
                    nonZero.add(new Double(matrix.get(x)[y]));
                }
                ++y;
            }
            ++x;
        }
        Collections.sort(nonZero);
        int index = (int)(percent * (double)(nonZero.size() - 1));
        return (Double)nonZero.get(index);
    }

    public static ArrayList<double[]> loadMatrix(File input) throws FileNotFoundException {
        ArrayList<double[]> matrix = new ArrayList<double[]>();
        int currentRow = 0;
        Scanner scan = new Scanner(input);
        while (scan.hasNextLine()) {
            String[] temp = scan.nextLine().split("\t");
            if (!temp[0].contains("YORF") && currentRow >= startROW) {
                double[] ARRAY = new double[temp.length - startCOL];
                int x = startCOL;
                while (x < temp.length) {
                    ARRAY[x - jHeatmap.startCOL] = Double.parseDouble(temp[x]);
                    ++x;
                }
                matrix.add(ARRAY);
            }
            ++currentRow;
        }
        scan.close();
        return matrix;
    }

    public static void loadConfig(String[] command) {
        int i = 0;
        while (i < command.length) {
            switch (command[i].charAt(1)) {
                case 'm': {
                    SAMPLE = new File(command[i + 1]);
                    ++i;
                    break;
                }
                case 'C': {
                    COLOR = command[i + 1];
                    ++i;
                    break;
                }
                case 'r': {
                    startROW = Integer.parseInt(command[i + 1]);
                    ++i;
                    break;
                }
                case 'c': {
                    startCOL = Integer.parseInt(command[i + 1]);
                    ++i;
                    break;
                }
                case 'h': {
                    pixelHeight = Integer.parseInt(command[i + 1]);
                    ++i;
                    break;
                }
                case 'w': {
                    pixelWidth = Integer.parseInt(command[i + 1]);
                    ++i;
                    break;
                }
                case 's': {
                    scaleType = command[i + 1];
                    ++i;
                    break;
                }
                case 'q': {
                    quantile = Double.parseDouble(command[i + 1]);
                    ++i;
                    break;
                }
                case 'a': {
                    absolute = Double.parseDouble(command[i + 1]);
                    ++i;
                    break;
                }
                case 'o': {
                    OUTPUTPATH = command[i + 1];
                    ++i;
                    break;
                }
                case 'f': {
                    FILEID = command[i + 1];
                    ++i;
                    break;
                }
                case 'H': {
                    jHeatmap.printUsage();
                    System.exit(0);
                }
            }
            ++i;
        }
        if (SAMPLE == null) {
            System.err.println("No matrix file entered!!!");
            jHeatmap.printUsage();
            System.exit(1);
        }
        if (COLOR != null) {
            Color tempColor = jHeatmap.verifyRGB(COLOR);
            if (tempColor == null) {
                System.err.println("Invalid RGB Color!!!\n");
                jHeatmap.printUsage();
                System.exit(1);
            } else {
                MAXCOLOR = tempColor;
            }
        }
        if (startROW < 0 || startCOL < 0) {
            System.err.println("Invalid starting row or column entered!!!");
            jHeatmap.printUsage();
            System.exit(1);
        }
        if (pixelHeight < 0 || pixelWidth < 0) {
            System.err.println("Invalid pixel height/width entered!!!");
            jHeatmap.printUsage();
            System.exit(1);
        }
        if (quantile < 0.0 || quantile > 1.0) {
            System.err.println("Invalid quantile contrast threshold value entered!!!");
            jHeatmap.printUsage();
            System.exit(1);
        }
        if (absolute < 0.0 && absolute != -999.0) {
            System.err.println("Invalid absolute contrast threshold value entered!!!");
            jHeatmap.printUsage();
            System.exit(1);
        } else if (absolute != -999.0) {
            quantile = -999.0;
        }
        if (OUTPUTPATH == null) {
            OUTPUTPATH = System.getProperty("user.dir");
        }
        if (FILEID == null) {
            FILEID = SAMPLE.getName().split("\\.")[0];
        }
        if (!(scaleType.equalsIgnoreCase("treeview") || scaleType.equalsIgnoreCase("bicubic") || scaleType.equalsIgnoreCase("bilinear") || scaleType.equalsIgnoreCase("neighbor"))) {
            System.err.println("Invalid PNG scaling type selected!!!");
            jHeatmap.printUsage();
            System.exit(1);
        }
        System.out.println("-----------------------------------------\nCommand Line Arguments:");
        System.out.println("Sample to process: " + SAMPLE);
        System.out.println("Matrix color: " + MAXCOLOR);
        System.out.println("Starting row index: " + startROW);
        System.out.println("Starting column index: " + startCOL);
        System.out.println("Final pixel height: " + pixelHeight);
        System.out.println("Final pixel width: " + pixelWidth);
        System.out.println("Scaling type: " + scaleType);
        if (quantile != -999.0) {
            System.out.println("Quantile contrast thresholding: " + quantile);
        } else {
            System.out.println("Absolute contrast thresholding: " + absolute);
        }
        System.out.println("-----------------------------------------");
        System.out.println("Output path: " + OUTPUTPATH);
        System.out.println("File ID: " + FILEID);
        System.out.println("-----------------------------------------");
    }

    public static Color verifyRGB(String color) {
        Color newColor = null;
        if (color == null) {
            return newColor;
        }
        String[] rgb = color.split(",");
        if (rgb.length != 3) {
            return newColor;
        }
        int RED = Integer.parseInt(rgb[0]);
        if (RED < 0 || RED > 255) {
            return newColor;
        }
        int GREEN = Integer.parseInt(rgb[1]);
        if (GREEN < 0 || GREEN > 255) {
            return newColor;
        }
        int BLUE = Integer.parseInt(rgb[2]);
        if (BLUE < 0 || BLUE > 255) {
            return newColor;
        }
        newColor = new Color(RED, GREEN, BLUE);
        return newColor;
    }

    public static void printUsage() {
        System.err.println("\nUsage: java -jar jHeatmap.jar -m [Matrix.file] [Options]");
        System.err.println("-----------------------------------------");
        System.err.println("Required Parameter:");
        System.err.println("Matrix file:\t\t-m");
        System.err.println("\nSupported Options:");
        System.err.println("Color RGB comma-delimited:\t-C\t(Default 255,0,0)");
        System.err.println("Starting row:\t\t-r\tDefault start at row index 1");
        System.err.println("Starting column:\t-c\tDefault start at column index 2");
        System.err.println("Pixel height:\t\t-h\tDefault 500");
        System.err.println("Pixel width:\t\t-w\tDefault 200");
        System.err.println("Scaling type:\t\t-s\ttreeview (default), bicubic, bilinear, neighbor");
        System.err.println("Quantile thresholding:\t-q\tDefault 0.9");
        System.err.println("Absolute thresholding:\t-a\tDefault off, overrides quantile parameter");
        System.err.println("Output path:\t\t-o\tDefault current directory");
        System.err.println("File ID:\t\t-f\tDefault based on Sample BAM filename");
        System.err.println("Help:\t\t\t-H\tPrint this message");
    }

    private static String getTimeStamp() {
        Date date = new Date();
        String time = new Timestamp(date.getTime()).toString();
        return time;
    }
}

