import pylab
import numpy
import sys

input_filename = sys.argv[1]
output_filename = sys.argv[2]

output_items = ['Haplotype ID', 'Last pre-ABX day', 'First post-ABX day', 'Ne from all timepoints (1/days)', 'Ne without ABX (1/days)', 'Ne before ABX (1/days)', 'Ne after ABX (1/days)', 'Pvalue (all Ne)', 'pre-ABX-Pvalue (all Ne)', 'post-ABX-Pvalue (all Ne)', 'Pvalue (w/o-ABX Ne)', 'pre-ABX-Pvalue (w/o-ABX Ne)', 'post-ABX-Pvalue (w/o-ABX Ne)', 'Pvalue (separate Nes)', 'pre-ABX-Pvalue (pre-ABX-Ne)', 'post-ABX-Pvalue (post-ABX-Ne)']

output_file = open(output_filename,"w")
output_file.write(", ".join(output_items))
output_file.write("\n")

file = open(input_filename,"r")
line = file.readline().strip()
line = file.readline().strip() # species name
while line!="":

	# Read in one species' worth
		
	species_name = line.strip()
	print "processing", species_name
	
	line = file.readline().strip() # ts
	if line[-1]!=']':
		# need to add another
		line = (line+file.readline().strip())
	
	times = numpy.array([long(item) for item in line[1:-1].split()])
	
	line = file.readline() # birth
	while not line.startswith('Birth'):
		print "Skipping line:", line
		line = file.readline()
	file.readline() # death
	line = file.readline() # 20-70 times
	print line
	first_high_idx = long((line.split(":")[-1]).split()[-1])
	
	file.readline()# mid
	
	line = file.readline()
	line = line.split(":")[-1] # pre post abx
	
	pre_post_items = line.split()
	pre_abx_idx = long(pre_post_items[0])
	post_abx_idx = long(pre_post_items[1])
	
	first_high_t = times[first_high_idx]
	pre_abx_t = times[pre_abx_idx]
	post_abx_t = times[post_abx_idx]
	
	file.readline() # fit test
	file.readline() # fit test
	file.readline() # fit test
	file.readline() # "Jorde Ryman Scores"
	line = file.readline() # actual Jorde Ryman scores
	while not line.startswith('All'):
		print "Skipping line", line
		line = file.readline() # soak up these scores
	#print line
	file.readline() # Post-fixation guess
	file.readline() # pre-fixation guess
	file.readline() # fixation time
	file.readline() # fixation Ne
	
	effective_gens_per_day = float(file.readline().split(":")[-1])
	
	file.readline() # nhat
	line = file.readline() # rescaled ts
	while not line.startswith('All'):
		print "Skipping line:", line
		line = file.readline()
	
	all_Ne = float(line.split(":")[-1])/effective_gens_per_day
	post_Ne = float(file.readline().split(":")[-1])/effective_gens_per_day
	pre_Ne = float(file.readline().split(":")[-1])/effective_gens_per_day
	postpre_Ne = float(file.readline().split(":")[-1])/effective_gens_per_day
	
	line = file.readline() # 'all'
	all_post_pvalue = float(file.readline().split(":")[-1])
	all_pre_pvalue = float(file.readline().split(":")[-1])
	all_both_pvalue = float(file.readline().split(":")[-1])
	
	line = file.readline() # 'joint'
	joint_post_pvalue = float(file.readline().split(":")[-1])
	joint_pre_pvalue = float(file.readline().split(":")[-1])
	joint_both_pvalue = float(file.readline().split(":")[-1])
	
	line = file.readline() # 'separate'
	separate_post_pvalue = float(file.readline().split(":")[-1])
	separate_pre_pvalue = float(file.readline().split(":")[-1])
	separate_both_pvalue = float(file.readline().split(":")[-1])
	
	output_items = [species_name, pre_abx_t, post_abx_t, all_Ne, postpre_Ne, pre_Ne, post_Ne, all_both_pvalue, all_pre_pvalue, all_post_pvalue, joint_both_pvalue, joint_pre_pvalue, joint_post_pvalue, separate_both_pvalue, separate_pre_pvalue, separate_post_pvalue]
	output_str = ", ".join([str(item) for item in output_items])
	
	output_file.write(output_str)
	output_file.write("\n")
	
	file.readline() # blank line
	line = file.readline() # next species