#!/usr/bin/env python

import sys

output_directory = sys.argv[1]
output_stem = sys.argv[2]


fastq_files = sys.argv[3:]

total_read_number = 1

max_num_records = 10000000
current_file_number = 1
current_record_number = 1

output_file = open("%s/%s_%03d.fa" % (output_directory, output_stem, current_file_number), "w")

for fastq_file in fastq_files:
    
    file = open(fastq_file,"r")
    line = file.readline()
    while line!="":
         
        # first line is read name
        # just extract barcode at end
        barcode_str = line.split(" ")[0].split(":")[-1]
        sequence = file.readline()
        file.readline() # +
        file.readline() # quality score
        line=file.readline()

        output_file.write(">%d:%s\n" % (total_read_number, barcode_str))
        output_file.write(sequence)
        
        current_record_number += 1
        total_read_number += 1

        if current_record_number > max_num_records:
            # switch files!
            output_file.close()
            current_file_number += 1
            current_record_number = 1
            output_file = open("%s/%s_%03d.fa" % (output_directory, output_stem, current_file_number), "w")

    file.close()

output_file.close()
output_file = open("%s/%s.num_reads.txt" % (output_directory, output_stem),"w")
output_file.write("%d\n" % (total_read_number-1))
output_file.close()
