#!/usr/bin/env python

# MIDAS: Metagenomic Intra-species Diversity Analysis System
# Copyright (C) 2015 Stephen Nayfach
# Freely distributed under the GNU General Public License (GPLv3)

import argparse, sys, os, platform, csv, gzip

cpd_to_enzyme = [
	('C00001','1.1.3.17'),
	('C00001','1.1.3.20'),
	('C00001','1.1.3.23'),
	('C00001','1.1.1.394'),
	('C00001','1.1.1.336'),
	('C00001','1.1.1.314'),
	('C00001','1.1.1.306'),
	('C00001','1.1.1.308'),
	('C00001','1.1.1.312'),
	('C00001','1.1.1.270'),
	('C00001','1.1.1.23'),
	('C00001','1.1.1.240'),
	('C00001','1.1.1.22'),
	('C00001','1.1.1.205'),
	('C00001','1.1.1.186'),
	('C00001','1.1.1.192'),
	('C00001','1.1.1.170'),
	('C00001','1.1.1.132'),
	('C00001','1.1.1.136'),
	('C00001','1.1.1.115'),
	('C00001','1.1.1.1'),
	('C00001','1.13.12.9'),
	('C00001','1.13.99.1'),
	('C00001','1.14.11.12'),
	('C00001','1.13.11.79'),
	('C00001','1.13.12.1'),
	('C00001','1.13.12.16'),
	('C00001','1.13.12.17'),
	('C00001','1.13.12.18'),
	('C00001','1.13.12.19'),
	('C00001','1.13.12.2'),
	('C00001','1.13.12.20'),
	('C00001','1.13.12.21'),
	('C00001','1.13.11.3'),
	('C00001','1.13.11.34'),
	('C00001','1.13.11.55'),
	('C00001','1.11.2.5'),
	('C00001','1.13.11.18'),
	('C00001','1.13.11.2'),
	('C00001','1.11.1.13'),
	('C00001','1.11.1.14'),
	('C00001','1.11.1.15'),
	('C00001','1.11.1.16'),
	('C00001','1.11.1.17'),
	('C00001','1.11.1.18'),
	('C00001','1.11.1.19'),
	('C00001','1.11.1.2'),
	('C00001','1.11.1.21'),
	('C00001','1.11.1.23'),
	('C00001','1.11.1.3'),
	('C00001','1.11.1.5'),
	('C00001','1.11.1.6'),
	('C00001','1.11.1.7'),
	('C00001','1.11.1.8'),
	('C00001','1.11.1.9'),
	('C00001','1.11.2.1'),
	('C00001','1.11.2.2'),
	('C00001','1.11.2.4'),
	('C00001','1.10.3.1'),
	('C00001','1.10.3.10'),
	('C00001','1.10.3.11'),
	('C00001','1.10.3.12'),
	('C00001','1.10.3.13'),
	('C00001','1.10.3.14'),
	('C00001','1.10.3.15'),
	('C00001','1.10.3.2'),
	('C00001','1.10.3.3'),
	('C00001','1.10.3.4'),
	('C00001','1.10.3.9'),
	('C00001','1.11.1.1'),
	('C00001','1.11.1.10'),
	('C00001','1.11.1.11'),
	('C00001','1.11.1.12'),
	('C00001','1.1.3.28'),
	('C00001','1.1.3.29'),
	('C00001','1.1.3.39'),
	('C00001','1.1.3.47'),
	('C00001','1.1.3.9'),
	('C00001','1.1.3.14'),
	('C00001','1.14.13.157'),
	('C00001','1.14.13.131'),
	('C00001','1.14.13.133'),
	('C00001','1.14.13.134'),
	('C00001','1.14.13.135'),
	('C00001','1.14.13.136'),
	('C00001','1.14.13.137'),
	('C00001','1.14.13.138'),
	('C00001','1.14.13.139'),
	('C00001','1.14.13.14'),
	('C00001','1.14.13.140'),
	('C00001','1.14.13.141'),
	('C00001','1.14.13.142'),
	('C00001','1.14.13.12'),
	('C00001','1.14.13.120'),
	('C00001','1.14.13.121'),
	('C00001','1.14.13.122'),
	('C00001','1.14.13.123'),
	('C00001','1.14.13.124'),
	('C00001','1.14.13.125'),
	('C00001','1.14.13.127'),
	('C00001','1.14.13.128'),
	('C00001','1.14.13.129'),
	('C00001','1.14.13.130'),
	('C00001','1.14.13.109'),
	('C00001','1.14.13.11'),
	('C00001','1.14.13.110'),
	('C00001','1.14.13.111'),
	('C00001','1.14.13.112'),
	('C00001','1.14.13.113'),
	('C00001','1.14.13.114'),
	('C00001','1.14.13.115'),
	('C00001','1.14.13.116'),
	('C00001','1.14.13.117'),
	('C00001','1.14.13.118'),
	('C00001','1.14.13.119'),
	('C00001','1.14.13.1'),
	('C00001','1.14.13.10'),
	('C00001','1.14.13.101'),
	('C00001','1.14.13.102'),
	('C00001','1.14.13.103'),
	('C00001','1.14.13.104'),
	('C00001','1.14.13.105'),
	('C00001','1.14.13.106'),
	('C00001','1.14.13.107'),
	('C00001','1.14.13.108'),
	('C00001','1.14.12.11'),
	('C00001','1.14.12.12'),
	('C00001','1.14.11.50'),
	('C00001','1.14.11.6'),
	('C00001','1.14.11.34'),
	('C00001','1.14.11.36'),
	('C00001','1.14.11.38'),
	('C00001','1.14.11.4'),
	('C00001','1.14.11.14'),
	('C00001','1.14.11.19'),
	('C00001','1.14.11.21'),
	('C00001','1.14.11.22'),
	('C00001','1.14.11.23'),
	('C00001','1.13.12.22'),
	('C00001','1.13.12.3'),
	('C00001','1.13.12.4'),
	('C00001','1.14.13.216'),
	('C00001','1.14.13.217'),
	('C00001','1.14.13.218'),
	('C00001','1.14.13.219'),
	('C00001','1.14.13.196'),
	('C00001','1.14.13.197'),
	('C00001','1.14.13.198'),
	('C00001','1.14.13.199'),
	('C00001','1.14.13.2'),
	('C00001','1.14.13.20'),
	('C00001','1.14.13.200'),
	('C00001','1.14.13.201'),
	('C00001','1.14.13.202'),
	('C00001','1.14.13.203'),
	('C00001','1.14.13.204'),
	('C00001','1.14.13.206'),
	('C00001','1.14.13.209'),
	('C00001','1.14.13.182'),
	('C00001','1.14.13.183'),
	('C00001','1.14.13.184'),
	('C00001','1.14.13.185'),
	('C00001','1.14.13.186'),
	('C00001','1.14.13.187'),
	('C00001','1.14.13.188'),
	('C00001','1.14.13.189'),
	('C00001','1.14.13.19'),
	('C00001','1.14.13.190'),
	('C00001','1.14.13.194'),
	('C00001','1.14.13.195'),
	('C00001','1.14.13.173'),
	('C00001','1.14.13.174'),
	('C00001','1.14.13.175'),
	('C00001','1.14.13.176'),
	('C00001','1.14.13.177'),
	('C00001','1.14.13.178'),
	('C00001','1.14.13.179'),
	('C00001','1.14.13.18'),
	('C00001','1.14.13.180'),
	('C00001','1.14.13.181'),
	('C00001','1.14.13.158'),
	('C00001','1.14.13.16'),
	('C00001','1.14.13.160'),
	('C00001','1.14.13.161'),
	('C00001','1.14.13.162'),
	('C00001','1.14.13.163'),
	('C00001','1.14.13.165'),
	('C00001','1.14.13.167'),
	('C00001','1.14.13.168'),
	('C00001','1.14.13.170'),
	('C00001','1.14.13.171'),
	('C00001','1.14.13.172'),
	('C00001','1.14.13.143'),
	('C00001','1.14.13.144'),
	('C00001','1.14.13.145'),
	('C00001','1.14.13.146'),
	('C00001','1.14.13.147'),
	('C00001','1.14.13.148'),
	('C00001','1.14.13.149'),
	('C00001','1.14.13.150'),
	('C00001','1.14.13.151'),
	('C00001','1.14.13.152'),
	('C00001','1.14.13.153'),
	('C00001','1.14.13.154'),
	('C00001','1.14.13.156'),
	('C00001','1.14.13.87'),
	('C00001','1.14.13.64'),
	('C00001','1.14.13.66'),
	('C00001','1.14.13.67'),
	('C00001','1.14.13.68'),
	('C00001','1.14.13.69'),
	('C00001','1.14.13.7'),
	('C00001','1.14.13.70'),
	('C00001','1.14.13.71'),
	('C00001','1.14.13.72'),
	('C00001','1.14.13.73'),
	('C00001','1.14.13.74'),
	('C00001','1.14.13.52'),
	('C00001','1.14.13.53'),
	('C00001','1.14.13.54'),
	('C00001','1.14.13.55'),
	('C00001','1.14.13.56'),
	('C00001','1.14.13.57'),
	('C00001','1.14.13.58'),
	('C00001','1.14.13.59'),
	('C00001','1.14.13.6'),
	('C00001','1.14.13.61'),
	('C00001','1.14.13.62'),
	('C00001','1.14.13.63'),
	('C00001','1.14.13.4'),
	('C00001','1.14.13.40'),
	('C00001','1.14.13.41'),
	('C00001','1.14.13.44'),
	('C00001','1.14.13.46'),
	('C00001','1.14.13.47'),
	('C00001','1.14.13.48'),
	('C00001','1.14.13.49'),
	('C00001','1.14.13.5'),
	('C00001','1.14.13.50'),
	('C00001','1.14.13.51'),
	('C00001','1.14.13.28'),
	('C00001','1.14.13.29'),
	('C00001','1.14.13.30'),
	('C00001','1.14.13.31'),
	('C00001','1.14.13.32'),
	('C00001','1.14.13.33'),
	('C00001','1.14.13.34'),
	('C00001','1.14.13.36'),
	('C00001','1.14.13.37'),
	('C00001','1.14.13.38'),
	('C00001','1.14.13.39'),
	('C00001','1.14.13.22'),
	('C00001','1.14.13.220'),
	('C00001','1.14.13.221'),
	('C00001','1.14.13.222'),
	('C00001','1.14.13.224'),
	('C00001','1.14.13.226'),
	('C00001','1.14.13.227'),
	('C00001','1.14.13.23'),
	('C00001','1.14.13.24'),
	('C00001','1.14.13.25'),
	('C00001','1.14.13.27'),
	('C00001','1.14.13.21'),
	('C00001','1.14.13.210'),
	('C00001','1.14.13.211'),
	('C00001','1.14.13.212'),
	('C00001','1.14.13.213'),
	('C00001','1.14.13.214'),
	('C00001','1.14.13.215'),
	('C00001','1.14.16.2'),
	('C00001','1.14.16.3'),
	('C00001','1.14.16.4'),
	('C00001','1.14.16.5'),
	('C00001','1.14.16.6'),
	('C00001','1.14.17.1'),
	('C00001','1.14.17.3'),
	('C00001','1.14.17.4'),
	('C00001','1.14.14.25'),
	('C00001','1.14.14.26'),
	('C00001','1.14.14.27'),
	('C00001','1.14.14.29'),
	('C00001','1.14.14.3'),
	('C00001','1.14.14.31'),
	('C00001','1.14.14.32'),
	('C00001','1.14.14.5'),
	('C00001','1.14.14.8'),
	('C00001','1.14.14.9'),
	('C00001','1.14.15.1'),
	('C00001','1.14.15.10'),
	('C00001','1.14.15.11'),
	('C00001','1.14.15.12'),
	('C00001','1.14.15.13'),
	('C00001','1.14.15.15'),
	('C00001','1.14.15.16'),
	('C00001','1.14.14.10'),
	('C00001','1.14.14.11'),
	('C00001','1.14.14.12'),
	('C00001','1.14.14.13'),
	('C00001','1.14.14.14'),
	('C00001','1.14.14.15'),
	('C00001','1.14.14.16'),
	('C00001','1.14.14.17'),
	('C00001','1.14.14.18'),
	('C00001','1.14.14.19'),
	('C00001','1.14.14.21'),
	('C00001','1.14.14.22'),
	('C00001','1.14.14.23'),
	('C00001','1.14.14.24'),
	('C00001','1.14.13.88'),
	('C00001','1.14.13.89'),
	('C00001','1.14.13.9'),
	('C00001','1.14.13.90'),
	('C00001','1.14.13.91'),
	('C00001','1.14.13.92'),
	('C00001','1.14.13.93'),
	('C00001','1.14.13.94'),
	('C00001','1.14.13.96'),
	('C00001','1.14.13.97'),
	('C00001','1.14.14.1'),
	('C00001','1.14.13.75'),
	('C00001','1.14.13.76'),
	('C00001','1.14.13.77'),
	('C00001','1.14.13.78'),
	('C00001','1.14.13.79'),
	('C00001','1.14.13.8'),
	('C00001','1.14.13.80'),
	('C00001','1.14.13.81'),
	('C00001','1.14.13.82'),
	('C00001','1.14.13.83'),
	('C00001','1.14.13.84'),
	('C00001','1.14.13.85'),
	('C00001','1.14.99.21'),
	('C00001','1.14.99.22'),
	('C00001','1.14.99.23'),
	('C00001','1.14.99.24'),
	('C00001','1.14.99.26'),
	('C00001','1.14.99.27'),
	('C00001','1.14.20.3'),
	('C00001','1.14.21.1'),
	('C00001','1.14.21.10'),
	('C00001','1.14.21.11'),
	('C00001','1.14.21.2'),
	('C00001','1.14.21.3'),
	('C00001','1.14.21.4'),
	('C00001','1.14.21.5'),
	('C00001','1.14.21.7'),
	('C00001','1.14.21.8'),
	('C00001','1.14.21.9'),
	('C00001','1.14.19.20'),
	('C00001','1.14.19.21'),
	('C00001','1.14.19.26'),
	('C00001','1.14.19.29'),
	('C00001','1.14.19.3'),
	('C00001','1.14.19.32'),
	('C00001','1.14.19.37'),
	('C00001','1.14.19.39'),
	('C00001','1.14.19.41'),
	('C00001','1.14.19.44'),
	('C00001','1.14.19.6'),
	('C00001','1.14.19.8'),
	('C00001','1.14.19.9'),
	('C00001','1.14.20.1'),
	('C00001','1.14.18.1'),
	('C00001','1.14.18.2'),
	('C00001','1.14.18.3'),
	('C00001','1.14.18.4'),
	('C00001','1.14.18.5'),
	('C00001','1.14.18.6'),
	('C00001','1.14.18.7'),
	('C00001','1.14.18.8'),
	('C00001','1.14.19.1'),
	('C00001','1.14.19.10'),
	('C00001','1.14.19.11'),
	('C00001','1.14.19.15'),
	('C00001','1.14.19.17'),
	('C00001','1.14.19.18'),
	('C00001','1.14.19.19'),
	('C00001','1.14.19.2'),
	('C00001','1.14.15.17'),
	('C00001','1.14.15.18'),
	('C00001','1.14.15.19'),
	('C00001','1.14.15.3'),
	('C00001','1.14.15.4'),
	('C00001','1.14.15.5'),
	('C00001','1.14.15.6'),
	('C00001','1.14.15.7'),
	('C00001','1.14.15.8'),
	('C00001','1.14.15.9'),
	('C00001','1.14.16.1'),
	('C00001','1.2.1.19'),
	('C00001','1.2.1.20'),
	('C00001','1.2.1.21'),
	('C00001','1.2.1.22'),
	('C00001','1.2.1.23'),
	('C00001','1.2.1.24'),
	('C00001','1.2.1.26'),
	('C00001','1.2.1.28'),
	('C00001','1.18.6.1'),
	('C00001','1.19.6.1'),
	('C00001','1.2.1.15'),
	('C00001','1.2.1.16'),
	('C00001','1.17.1.8'),
	('C00001','1.17.2.1'),
	('C00001','1.17.2.2'),
	('C00001','1.17.3.2'),
	('C00001','1.17.3.3'),
	('C00001','1.17.4.1'),
	('C00001','1.17.4.2'),
	('C00001','1.17.4.4'),
	('C00001','1.17.5.1'),
	('C00001','1.17.5.2'),
	('C00001','1.17.7.1'),
	('C00001','1.17.7.2'),
	('C00001','1.17.7.3'),
	('C00001','1.17.7.4'),
	('C00001','1.17.99.1'),
	('C00001','1.17.99.2'),
	('C00001','1.17.99.3'),
	('C00001','1.17.99.4'),
	('C00001','1.14.99.52'),
	('C00001','1.16.1.3'),
	('C00001','1.16.1.5'),
	('C00001','1.16.3.1'),
	('C00001','1.17.1.1'),
	('C00001','1.17.1.3'),
	('C00001','1.17.1.4'),
	('C00001','1.17.1.5'),
	('C00001','1.14.99.29'),
	('C00001','1.14.99.34'),
	('C00001','1.14.99.35'),
	('C00001','1.14.99.37'),
	('C00001','1.14.99.38'),
	('C00001','1.14.99.39'),
	('C00001','1.14.99.4'),
	('C00001','1.14.99.43'),
	('C00001','1.14.99.44'),
	('C00001','1.14.99.45'),
	('C00001','1.14.99.47'),
	('C00001','1.14.99.48'),
	('C00001','1.14.99.49'),
	('C00001','1.14.99.50'),
	('C00001','1.14.99.51'),
	('C00001','1.14.99.1'),
	('C00001','1.14.99.11'),
	('C00001','1.14.99.12'),
	('C00001','1.14.99.14'),
	('C00001','1.14.99.15'),
	('C00001','1.14.99.19'),
	('C00001','1.14.99.20'),
	('C00001','1.21.3.5'),
	('C00001','1.21.3.6'),
	('C00001','1.21.4.2'),
	('C00001','1.2.5.1'),
	('C00001','1.2.5.2'),
	('C00001','1.2.5.3'),
	('C00001','1.2.7.4'),
	('C00001','1.2.7.5'),
	('C00001','1.2.7.6'),
	('C00001','1.2.2.4'),
	('C00001','1.2.3.1'),
	('C00001','1.2.3.14'),
	('C00001','1.2.3.15'),
	('C00001','1.2.3.5'),
	('C00001','1.2.3.7'),
	('C00001','1.2.3.8'),
	('C00001','1.2.3.9'),
	('C00001','1.2.1.85'),
	('C00001','1.2.1.86'),
	('C00001','1.2.1.88'),
	('C00001','1.2.1.89'),
	('C00001','1.2.1.9'),
	('C00001','1.2.1.90'),
	('C00001','1.2.1.91'),
	('C00001','1.2.1.92'),
	('C00001','1.2.1.96'),
	('C00001','1.2.1.98'),
	('C00001','1.2.1.71'),
	('C00001','1.2.1.72'),
	('C00001','1.2.1.73'),
	('C00001','1.2.1.74'),
	('C00001','1.2.1.77'),
	('C00001','1.2.1.78'),
	('C00001','1.2.1.79'),
	('C00001','1.2.1.8'),
	('C00001','1.2.1.82'),
	('C00001','1.2.1.83'),
	('C00001','1.2.1.54'),
	('C00001','1.2.1.60'),
	('C00001','1.2.1.61'),
	('C00001','1.2.1.62'),
	('C00001','1.2.1.63'),
	('C00001','1.2.1.64'),
	('C00001','1.2.1.65'),
	('C00001','1.2.1.67'),
	('C00001','1.2.1.68'),
	('C00001','1.2.1.69'),
	('C00001','1.2.1.7'),
	('C00001','1.2.1.46'),
	('C00001','1.2.1.47'),
	('C00001','1.2.1.48'),
	('C00001','1.2.1.49'),
	('C00001','1.2.1.5'),
	('C00001','1.2.1.53'),
	('C00001','1.2.1.29'),
	('C00001','1.2.1.3'),
	('C00001','1.2.1.31'),
	('C00001','1.2.1.32'),
	('C00001','1.2.1.33'),
	('C00001','1.2.1.36'),
	('C00001','1.2.1.39'),
	('C00001','1.2.1.4'),
	('C00001','1.4.3.21'),
	('C00001','1.4.1.4'),
	('C00001','1.4.1.5'),
	('C00001','1.4.1.7'),
	('C00001','1.4.1.8'),
	('C00001','1.4.1.9'),
	('C00001','1.4.2.1'),
	('C00001','1.4.3.1'),
	('C00001','1.4.1.16'),
	('C00001','1.4.1.17'),
	('C00001','1.4.1.18'),
	('C00001','1.4.1.19'),
	('C00001','1.4.1.2'),
	('C00001','1.4.1.20'),
	('C00001','1.4.1.21'),
	('C00001','1.4.1.23'),
	('C00001','1.4.1.24'),
	('C00001','1.4.1.3'),
	('C00001','1.4.1.1'),
	('C00001','1.4.1.10'),
	('C00001','1.4.1.11'),
	('C00001','1.4.1.12'),
	('C00001','1.4.1.13'),
	('C00001','1.4.1.15'),
	('C00001','1.3.99.16'),
	('C00001','1.3.99.17'),
	('C00001','1.3.99.18'),
	('C00001','1.3.99.19'),
	('C00001','1.3.99.26'),
	('C00001','1.3.99.28'),
	('C00001','1.3.99.30'),
	('C00001','1.3.99.31'),
	('C00001','1.3.99.8'),
	('C00001','1.3.3.5'),
	('C00001','1.3.3.9'),
	('C00001','1.3.5.6'),
	('C00001','1.3.7.15'),
	('C00001','1.3.7.7'),
	('C00001','1.3.7.8'),
	('C00001','1.3.7.9'),
	('C00001','1.3.3.11'),
	('C00001','1.3.3.3'),
	('C00001','1.21.4.3'),
	('C00001','1.21.4.4'),
	('C00001','1.21.98.2'),
	('C00001','1.23.5.1'),
	('C00001','1.2.98.1'),
	('C00001','1.2.99.5'),
	('C00001','1.2.99.6'),
	('C00001','1.2.99.7'),
	('C00001','1.2.99.8'),
	('C00001','1.20.1.1'),
	('C00001','1.20.2.1'),
	('C00001','1.20.4.2'),
	('C00001','1.20.4.4'),
	('C00001','1.20.9.1'),
	('C00001','1.21.3.1'),
	('C00001','1.21.3.2'),
	('C00001','1.21.3.4'),
	('C00001','1.5.3.4'),
	('C00001','1.5.3.5'),
	('C00001','1.5.3.6'),
	('C00001','1.5.4.1'),
	('C00001','1.5.8.1'),
	('C00001','1.5.8.2'),
	('C00001','1.5.8.3'),
	('C00001','1.5.8.4'),
	('C00001','1.5.99.12'),
	('C00001','1.5.99.14'),
	('C00001','1.5.99.4'),
	('C00001','1.5.99.5'),
	('C00001','1.5.99.6'),
	('C00001','1.5.1.6'),
	('C00001','1.5.1.7'),
	('C00001','1.5.1.8'),
	('C00001','1.5.1.9'),
	('C00001','1.5.3.1'),
	('C00001','1.5.3.10'),
	('C00001','1.5.3.13'),
	('C00001','1.5.3.14'),
	('C00001','1.5.3.15'),
	('C00001','1.5.3.16'),
	('C00001','1.5.3.17'),
	('C00001','1.5.3.18'),
	('C00001','1.5.3.19'),
	('C00001','1.5.3.2'),
	('C00001','1.5.1.43'),
	('C00001','1.5.1.22'),
	('C00001','1.5.1.23'),
	('C00001','1.5.1.24'),
	('C00001','1.5.1.26'),
	('C00001','1.5.1.28'),
	('C00001','1.4.99.6'),
	('C00001','1.5.1.10'),
	('C00001','1.5.1.11'),
	('C00001','1.5.1.16'),
	('C00001','1.5.1.17'),
	('C00001','1.5.1.19'),
	('C00001','1.4.3.22'),
	('C00001','1.4.3.24'),
	('C00001','1.4.3.3'),
	('C00001','1.4.3.4'),
	('C00001','1.4.3.5'),
	('C00001','1.4.3.7'),
	('C00001','1.4.3.8'),
	('C00001','1.4.5.1'),
	('C00001','1.4.7.1'),
	('C00001','1.4.9.1'),
	('C00001','1.4.9.2'),
	('C00001','1.4.99.2'),
	('C00001','1.4.3.10'),
	('C00001','1.4.3.11'),
	('C00001','1.4.3.12'),
	('C00001','1.4.3.13'),
	('C00001','1.4.3.14'),
	('C00001','1.4.3.15'),
	('C00001','1.4.3.16'),
	('C00001','1.4.3.19'),
	('C00001','1.4.3.2'),
	('C00001','1.4.3.20'),
	('C00001','2.1.2.11'),
	('C00001','2.1.2.2'),
	('C00001','2.1.2.3'),
	('C00001','2.1.2.7'),
	('C00001','2.1.2.8'),
	('C00001','2.1.1.246'),
	('C00001','2.1.1.152'),
	('C00001','1.8.5.3'),
	('C00001','1.8.7.1'),
	('C00001','1.8.98.3'),
	('C00001','1.8.99.5'),
	('C00001','1.9.3.1'),
	('C00001','1.9.6.1'),
	('C00001','1.97.1.1'),
	('C00001','1.97.1.9'),
	('C00001','1.8.1.9'),
	('C00001','1.8.2.1'),
	('C00001','1.8.2.4'),
	('C00001','1.8.3.1'),
	('C00001','1.8.3.4'),
	('C00001','1.8.3.5'),
	('C00001','1.8.3.6'),
	('C00001','1.8.4.11'),
	('C00001','1.8.4.12'),
	('C00001','1.8.4.13'),
	('C00001','1.8.4.14'),
	('C00001','1.8.1.17'),
	('C00001','1.8.1.2'),
	('C00001','1.8.1.3'),
	('C00001','1.7.2.2'),
	('C00001','1.7.2.4'),
	('C00001','1.7.2.5'),
	('C00001','1.7.2.6'),
	('C00001','1.7.2.7'),
	('C00001','1.7.3.1'),
	('C00001','1.7.3.3'),
	('C00001','1.7.3.5'),
	('C00001','1.7.3.6'),
	('C00001','1.7.5.1'),
	('C00001','1.7.5.2'),
	('C00001','1.7.6.1'),
	('C00001','1.7.7.1'),
	('C00001','1.7.7.2'),
	('C00001','1.7.99.1'),
	('C00001','1.7.99.4'),
	('C00001','1.7.1.12'),
	('C00001','1.7.1.14'),
	('C00001','1.7.1.15'),
	('C00001','1.7.1.2'),
	('C00001','1.7.1.3'),
	('C00001','1.7.1.4'),
	('C00001','1.7.1.9'),
	('C00001','1.7.2.1'),
	('C00001','1.6.6.9'),
	('C00001','1.7.1.1'),
	('C00001','1.7.1.10'),
	('C00001','1.7.1.11'),
	('C00001','1.6.3.2'),
	('C00001','1.6.3.4'),
	('C00001','1.5.3.21'),
	('C00001','1.5.3.22'),
	('C00001','2.5.1.61'),
	('C00001','2.5.1.72'),
	('C00001','2.5.1.77'),
	('C00001','2.5.1.78'),
	('C00001','2.5.1.15'),
	('C00001','2.5.1.18'),
	('C00001','2.5.1.48'),
	('C00001','2.5.1.54'),
	('C00001','2.5.1.101'),
	('C00001','2.5.1.120'),
	('C00001','2.4.2.14'),
	('C00001','2.4.1.139'),
	('C00001','2.4.1.17'),
	('C00001','2.3.3.9'),
	('C00001','2.3.2.2'),
	('C00001','2.3.3.1'),
	('C00001','2.3.3.10'),
	('C00001','2.3.3.11'),
	('C00001','2.3.3.12'),
	('C00001','2.3.3.13'),
	('C00001','2.3.3.14'),
	('C00001','2.3.3.16'),
	('C00001','2.3.3.2'),
	('C00001','2.3.3.3'),
	('C00001','2.3.3.4'),
	('C00001','2.3.3.5'),
	('C00001','2.3.3.6'),
	('C00001','2.3.3.7'),
	('C00001','2.3.1.85'),
	('C00001','2.3.1.86'),
	('C00001','2.3.1.89'),
	('C00001','2.3.1.94'),
	('C00001','2.3.1.246'),
	('C00001','2.3.1.226'),
	('C00001','2.3.1.230'),
	('C00001','2.3.1.233'),
	('C00001','2.3.1.235'),
	('C00001','2.3.1.236'),
	('C00001','2.3.1.237'),
	('C00001','2.3.1.239'),
	('C00001','2.3.1.240'),
	('C00001','2.3.1.211'),
	('C00001','2.3.1.212'),
	('C00001','2.3.1.216'),
	('C00001','2.3.1.217'),
	('C00001','2.3.1.219'),
	('C00001','2.3.1.221'),
	('C00001','2.3.1.182'),
	('C00001','2.3.1.159'),
	('C00001','2.3.1.161'),
	('C00001','2.3.1.164'),
	('C00001','2.3.1.165'),
	('C00001','2.3.1.169'),
	('C00001','2.3.1.170'),
	('C00001','2.3.1.117'),
	('C00001','2.10.1.1'),
	('C00001','2.3.1.111'),
	('C00001','2.1.1.90'),
	('C00001','2.1.2.1'),
	('C00001','2.1.2.10'),
	('C00001','3.1.1.50'),
	('C00001','3.1.1.51'),
	('C00001','3.1.1.52'),
	('C00001','3.1.1.53'),
	('C00001','3.1.1.54'),
	('C00001','3.1.1.55'),
	('C00001','3.1.1.56'),
	('C00001','3.1.1.57'),
	('C00001','3.1.1.58'),
	('C00001','3.1.1.59'),
	('C00001','3.1.1.6'),
	('C00001','3.1.1.60'),
	('C00001','3.1.1.61'),
	('C00001','3.1.1.63'),
	('C00001','3.1.1.64'),
	('C00001','3.1.1.65'),
	('C00001','3.1.1.66'),
	('C00001','3.1.1.67'),
	('C00001','3.1.1.68'),
	('C00001','3.1.1.7'),
	('C00001','3.1.1.70'),
	('C00001','3.1.1.71'),
	('C00001','3.1.1.73'),
	('C00001','3.1.1.74'),
	('C00001','2.9.1.2'),
	('C00001','3.1.1.1'),
	('C00001','3.1.1.10'),
	('C00001','3.1.1.11'),
	('C00001','3.1.1.13'),
	('C00001','3.1.1.14'),
	('C00001','3.1.1.15'),
	('C00001','3.1.1.17'),
	('C00001','3.1.1.19'),
	('C00001','3.1.1.2'),
	('C00001','3.1.1.20'),
	('C00001','3.1.1.22'),
	('C00001','3.1.1.23'),
	('C00001','3.1.1.24'),
	('C00001','3.1.1.25'),
	('C00001','3.1.1.26'),
	('C00001','3.1.1.27'),
	('C00001','3.1.1.28'),
	('C00001','3.1.1.29'),
	('C00001','3.1.1.3'),
	('C00001','3.1.1.30'),
	('C00001','3.1.1.31'),
	('C00001','3.1.1.32'),
	('C00001','2.7.9.3'),
	('C00001','2.8.1.10'),
	('C00001','2.7.7.87'),
	('C00001','2.7.9.2'),
	('C00001','2.7.1.170'),
	('C00001','2.6.99.2'),
	('C00001','2.6.1.82'),
	('C00001','2.6.1.83'),
	('C00001','2.5.1.97'),
	('C00001','2.6.1.13'),
	('C00001','2.5.1.55'),
	('C00001','2.5.1.56'),
	('C00001','2.5.1.57'),
	('C00001','2.5.1.6'),
	('C00001','3.1.3.100'),
	('C00001','3.1.3.101'),
	('C00001','3.1.3.104'),
	('C00001','3.1.3.11'),
	('C00001','3.1.3.12'),
	('C00001','3.1.3.14'),
	('C00001','3.1.3.15'),
	('C00001','3.1.3.16'),
	('C00001','3.1.3.17'),
	('C00001','3.1.1.75'),
	('C00001','3.1.1.76'),
	('C00001','3.1.1.77'),
	('C00001','3.1.1.78'),
	('C00001','3.1.1.79'),
	('C00001','3.1.1.8'),
	('C00001','3.1.1.80'),
	('C00001','3.1.1.81'),
	('C00001','3.1.1.82'),
	('C00001','3.1.1.83'),
	('C00001','3.1.1.84'),
	('C00001','3.1.1.85'),
	('C00001','3.1.1.87'),
	('C00001','3.1.1.88'),
	('C00001','3.1.1.90'),
	('C00001','3.1.1.91'),
	('C00001','3.1.1.92'),
	('C00001','3.1.1.93'),
	('C00001','3.1.1.94'),
	('C00001','3.1.1.95'),
	('C00001','3.1.1.97'),
	('C00001','3.1.1.98'),
	('C00001','3.1.1.99'),
	('C00001','3.1.2.1'),
	('C00001','3.1.2.10'),
	('C00001','3.1.2.11'),
	('C00001','3.1.2.12'),
	('C00001','3.1.2.13'),
	('C00001','3.1.2.14'),
	('C00001','3.1.2.16'),
	('C00001','3.1.2.17'),
	('C00001','3.1.2.18'),
	('C00001','3.1.2.19'),
	('C00001','3.1.2.2'),
	('C00001','3.1.2.20'),
	('C00001','3.1.1.33'),
	('C00001','3.1.1.34'),
	('C00001','3.1.1.35'),
	('C00001','3.1.1.36'),
	('C00001','3.1.1.37'),
	('C00001','3.1.1.38'),
	('C00001','3.1.1.39'),
	('C00001','3.1.1.4'),
	('C00001','3.1.1.40'),
	('C00001','3.1.1.41'),
	('C00001','3.1.1.42'),
	('C00001','3.1.1.43'),
	('C00001','3.1.1.44'),
	('C00001','3.1.1.45'),
	('C00001','3.1.1.46'),
	('C00001','3.1.1.47'),
	('C00001','3.1.1.48'),
	('C00001','3.1.1.49'),
	('C00001','3.1.1.5'),
	('C00001','3.1.3.54'),
	('C00001','3.1.3.55'),
	('C00001','3.1.3.56'),
	('C00001','3.1.3.57'),
	('C00001','3.1.3.58'),
	('C00001','3.1.3.59'),
	('C00001','3.1.3.6'),
	('C00001','3.1.3.60'),
	('C00001','3.1.3.62'),
	('C00001','3.1.3.63'),
	('C00001','3.1.3.64'),
	('C00001','3.1.3.66'),
	('C00001','3.1.3.67'),
	('C00001','3.1.3.68'),
	('C00001','3.1.3.69'),
	('C00001','3.1.3.7'),
	('C00001','3.1.3.70'),
	('C00001','3.1.3.18'),
	('C00001','3.1.3.19'),
	('C00001','3.1.3.2'),
	('C00001','3.1.3.20'),
	('C00001','3.1.3.21'),
	('C00001','3.1.3.22'),
	('C00001','3.1.3.23'),
	('C00001','3.1.3.24'),
	('C00001','3.1.3.25'),
	('C00001','3.1.3.26'),
	('C00001','3.1.3.27'),
	('C00001','3.1.3.28'),
	('C00001','3.1.3.29'),
	('C00001','3.1.3.3'),
	('C00001','3.1.3.31'),
	('C00001','3.1.3.32'),
	('C00001','3.1.3.33'),
	('C00001','3.1.3.34'),
	('C00001','3.1.3.35'),
	('C00001','3.1.3.36'),
	('C00001','3.1.3.37'),
	('C00001','3.1.3.38'),
	('C00001','3.1.3.39'),
	('C00001','3.1.3.4'),
	('C00001','3.1.3.40'),
	('C00001','3.1.3.41'),
	('C00001','3.1.3.42'),
	('C00001','3.1.3.43'),
	('C00001','3.1.3.44'),
	('C00001','3.1.3.45'),
	('C00001','3.1.2.21'),
	('C00001','3.1.2.22'),
	('C00001','3.1.2.23'),
	('C00001','3.1.2.25'),
	('C00001','3.1.2.27'),
	('C00001','3.1.2.28'),
	('C00001','3.1.2.29'),
	('C00001','3.1.2.3'),
	('C00001','3.1.2.30'),
	('C00001','3.1.2.31'),
	('C00001','3.1.2.4'),
	('C00001','3.1.2.5'),
	('C00001','3.1.2.6'),
	('C00001','3.1.2.7'),
	('C00001','3.1.3.1'),
	('C00001','3.1.3.10'),
	('C00001','3.1.4.42'),
	('C00001','3.1.4.43'),
	('C00001','3.1.4.44'),
	('C00001','3.1.4.45'),
	('C00001','3.1.4.46'),
	('C00001','3.1.4.48'),
	('C00001','3.1.4.49'),
	('C00001','3.1.4.50'),
	('C00001','3.1.4.51'),
	('C00001','3.1.4.52'),
	('C00001','3.1.4.53'),
	('C00001','3.1.4.55'),
	('C00001','3.1.4.56'),
	('C00001','3.1.4.57'),
	('C00001','3.1.5.1'),
	('C00001','3.1.6.1'),
	('C00001','3.1.6.10'),
	('C00001','3.1.6.11'),
	('C00001','3.1.6.12'),
	('C00001','3.1.6.13'),
	('C00001','3.1.6.14'),
	('C00001','3.1.6.16'),
	('C00001','3.1.6.17'),
	('C00001','3.1.6.18'),
	('C00001','3.1.6.2'),
	('C00001','3.1.6.3'),
	('C00001','3.1.3.71'),
	('C00001','3.1.3.72'),
	('C00001','3.1.3.73'),
	('C00001','3.1.3.74'),
	('C00001','3.1.3.75'),
	('C00001','3.1.3.76'),
	('C00001','3.1.3.77'),
	('C00001','3.1.3.78'),
	('C00001','3.1.3.79'),
	('C00001','3.1.3.8'),
	('C00001','3.1.3.80'),
	('C00001','3.1.3.81'),
	('C00001','3.1.3.82'),
	('C00001','3.1.3.83'),
	('C00001','3.1.3.85'),
	('C00001','3.1.3.86'),
	('C00001','3.1.3.87'),
	('C00001','3.1.3.88'),
	('C00001','3.1.3.89'),
	('C00001','3.1.3.9'),
	('C00001','3.1.3.90'),
	('C00001','3.1.3.91'),
	('C00001','3.1.3.92'),
	('C00001','3.1.3.93'),
	('C00001','3.1.3.94'),
	('C00001','3.1.3.95'),
	('C00001','3.1.3.96'),
	('C00001','3.1.3.97'),
	('C00001','3.1.3.99'),
	('C00001','3.1.3.46'),
	('C00001','3.1.3.47'),
	('C00001','3.1.3.48'),
	('C00001','3.1.3.49'),
	('C00001','3.1.3.5'),
	('C00001','3.1.3.50'),
	('C00001','3.1.3.51'),
	('C00001','3.1.3.52'),
	('C00001','3.1.3.53'),
	('C00001','3.2.1.140'),
	('C00001','3.2.1.141'),
	('C00001','3.2.1.144'),
	('C00001','3.2.1.147'),
	('C00001','3.2.1.149'),
	('C00001','3.2.1.15'),
	('C00001','3.2.1.163'),
	('C00001','3.2.1.165'),
	('C00001','3.2.1.166'),
	('C00001','3.2.1.167'),
	('C00001','3.2.1.168'),
	('C00001','3.2.1.169'),
	('C00001','3.2.1.170'),
	('C00001','3.2.1.175'),
	('C00001','3.2.1.179'),
	('C00001','3.2.1.18'),
	('C00001','3.2.1.180'),
	('C00001','3.2.1.183'),
	('C00001','3.2.1.184'),
	('C00001','3.1.6.4'),
	('C00001','3.1.6.6'),
	('C00001','3.1.6.8'),
	('C00001','3.1.6.9'),
	('C00001','3.1.7.1'),
	('C00001','3.1.7.10'),
	('C00001','3.1.7.11'),
	('C00001','3.1.7.2'),
	('C00001','3.1.7.3'),
	('C00001','3.1.7.5'),
	('C00001','3.1.7.6'),
	('C00001','3.1.7.7'),
	('C00001','3.1.7.8'),
	('C00001','3.1.7.9'),
	('C00001','3.1.8.1'),
	('C00001','3.1.8.2'),
	('C00001','3.10.1.1'),
	('C00001','3.10.1.2'),
	('C00001','3.11.1.1'),
	('C00001','3.11.1.2'),
	('C00001','3.11.1.3'),
	('C00001','3.12.1.1'),
	('C00001','3.13.1.1'),
	('C00001','3.13.1.3'),
	('C00001','3.13.1.4'),
	('C00001','3.2.1.1'),
	('C00001','3.2.1.10'),
	('C00001','3.1.4.11'),
	('C00001','3.1.4.12'),
	('C00001','3.1.4.13'),
	('C00001','3.1.4.14'),
	('C00001','3.1.4.16'),
	('C00001','3.1.4.17'),
	('C00001','3.1.4.2'),
	('C00001','3.1.4.3'),
	('C00001','3.1.4.35'),
	('C00001','3.1.4.37'),
	('C00001','3.1.4.38'),
	('C00001','3.1.4.39'),
	('C00001','3.1.4.4'),
	('C00001','3.1.4.40'),
	('C00001','3.1.4.41'),
	('C00001','3.2.2.8'),
	('C00001','3.2.2.9'),
	('C00001','3.3.1.1'),
	('C00001','3.3.1.2'),
	('C00001','3.3.2.1'),
	('C00001','3.2.1.185'),
	('C00001','3.2.1.186'),
	('C00001','3.2.1.187'),
	('C00001','3.2.1.188'),
	('C00001','3.2.1.189'),
	('C00001','3.2.1.190'),
	('C00001','3.2.1.2'),
	('C00001','3.2.1.20'),
	('C00001','3.2.1.21'),
	('C00001','3.2.1.22'),
	('C00001','3.2.1.23'),
	('C00001','3.2.1.24'),
	('C00001','3.2.1.25'),
	('C00001','3.2.1.26'),
	('C00001','3.2.1.28'),
	('C00001','3.2.1.3'),
	('C00001','3.2.1.31'),
	('C00001','3.2.1.33'),
	('C00001','3.2.1.35'),
	('C00001','3.2.1.37'),
	('C00001','3.2.1.39'),
	('C00001','3.2.1.4'),
	('C00001','3.2.1.42'),
	('C00001','3.2.1.45'),
	('C00001','3.2.1.46'),
	('C00001','3.2.1.47'),
	('C00001','3.2.1.48'),
	('C00001','3.2.1.49'),
	('C00001','3.2.1.50'),
	('C00001','3.2.1.51'),
	('C00001','3.2.1.52'),
	('C00001','3.2.1.54'),
	('C00001','3.2.1.55'),
	('C00001','3.2.1.56'),
	('C00001','3.2.1.58'),
	('C00001','3.2.1.103'),
	('C00001','3.2.1.104'),
	('C00001','3.2.1.105'),
	('C00001','3.2.1.106'),
	('C00001','3.2.1.107'),
	('C00001','3.2.1.108'),
	('C00001','3.2.1.112'),
	('C00001','3.2.1.113'),
	('C00001','3.2.1.114'),
	('C00001','3.2.1.117'),
	('C00001','3.2.1.118'),
	('C00001','3.2.1.119'),
	('C00001','3.2.1.122'),
	('C00001','3.2.1.123'),
	('C00001','3.2.1.125'),
	('C00001','3.2.1.126'),
	('C00001','3.2.1.128'),
	('C00001','3.2.1.132'),
	('C00001','3.2.1.133'),
	('C00001','3.2.1.134'),
	('C00001','3.2.1.137'),
	('C00001','3.2.1.139'),
	('C00001','3.2.1.14'),
	('C00001','3.3.2.7'),
	('C00001','3.3.2.8'),
	('C00001','3.3.2.9'),
	('C00001','3.4.11.1'),
	('C00001','3.4.11.2'),
	('C00001','3.4.11.23'),
	('C00001','3.4.11.5'),
	('C00001','3.4.13.12'),
	('C00001','3.4.13.18'),
	('C00001','3.4.13.20'),
	('C00001','3.4.13.22'),
	('C00001','3.4.13.4'),
	('C00001','3.4.13.5'),
	('C00001','3.4.14.13'),
	('C00001','3.4.15.6'),
	('C00001','3.4.17.21'),
	('C00001','3.4.17.23'),
	('C00001','3.4.17.8'),
	('C00001','3.4.19.12'),
	('C00001','3.4.19.13'),
	('C00001','3.4.19.14'),
	('C00001','3.4.19.9'),
	('C00001','3.4.24.84'),
	('C00001','3.2.1.62'),
	('C00001','3.2.1.63'),
	('C00001','3.2.1.64'),
	('C00001','3.2.1.65'),
	('C00001','3.2.1.66'),
	('C00001','3.2.1.67'),
	('C00001','3.2.1.68'),
	('C00001','3.2.1.74'),
	('C00001','3.2.1.76'),
	('C00001','3.2.1.77'),
	('C00001','3.2.1.78'),
	('C00001','3.2.1.80'),
	('C00001','3.2.1.84'),
	('C00001','3.2.1.85'),
	('C00001','3.2.1.86'),
	('C00001','3.2.1.88'),
	('C00001','3.2.1.91'),
	('C00001','3.2.1.93'),
	('C00001','3.2.1.97'),
	('C00001','3.2.2.1'),
	('C00001','3.2.2.10'),
	('C00001','3.2.2.11'),
	('C00001','3.2.2.12'),
	('C00001','3.2.2.13'),
	('C00001','3.2.2.14'),
	('C00001','3.2.2.16'),
	('C00001','3.2.2.19'),
	('C00001','3.2.2.2'),
	('C00001','3.2.2.24'),
	('C00001','3.2.2.25'),
	('C00001','3.2.2.26'),
	('C00001','3.2.2.3'),
	('C00001','3.2.2.30'),
	('C00001','3.2.2.4'),
	('C00001','3.2.2.5'),
	('C00001','3.2.2.6'),
	('C00001','3.2.2.7'),
	('C00001','3.5.1.5'),
	('C00001','3.5.1.50'),
	('C00001','3.5.1.51'),
	('C00001','3.5.1.52'),
	('C00001','3.5.1.53'),
	('C00001','3.5.1.54'),
	('C00001','3.5.1.55'),
	('C00001','3.5.1.56'),
	('C00001','3.5.1.57'),
	('C00001','3.5.1.58'),
	('C00001','3.5.1.59'),
	('C00001','3.5.1.15'),
	('C00001','3.5.1.16'),
	('C00001','3.5.1.17'),
	('C00001','3.5.1.18'),
	('C00001','3.5.1.19'),
	('C00001','3.5.1.2'),
	('C00001','3.5.1.20'),
	('C00001','3.5.1.21'),
	('C00001','3.5.1.22'),
	('C00001','3.5.1.23'),
	('C00001','3.5.1.24'),
	('C00001','3.5.1.25'),
	('C00001','3.5.1.26'),
	('C00001','3.5.1.28'),
	('C00001','3.5.1.29'),
	('C00001','3.5.1.3'),
	('C00001','3.5.1.30'),
	('C00001','3.5.1.31'),
	('C00001','3.5.1.32'),
	('C00001','3.5.1.33'),
	('C00001','3.5.1.1'),
	('C00001','3.5.1.10'),
	('C00001','3.5.1.100'),
	('C00001','3.5.1.101'),
	('C00001','3.5.1.102'),
	('C00001','3.5.1.103'),
	('C00001','3.5.1.104'),
	('C00001','3.5.1.106'),
	('C00001','3.5.1.107'),
	('C00001','3.5.1.108'),
	('C00001','3.5.1.11'),
	('C00001','3.5.1.110'),
	('C00001','3.5.1.111'),
	('C00001','3.5.1.112'),
	('C00001','3.5.1.113'),
	('C00001','3.5.1.114'),
	('C00001','3.5.1.115'),
	('C00001','3.5.1.116'),
	('C00001','3.5.1.117'),
	('C00001','3.5.1.118'),
	('C00001','3.5.1.119'),
	('C00001','3.5.1.12'),
	('C00001','3.5.1.13'),
	('C00001','3.5.1.14'),
	('C00001','3.3.2.10'),
	('C00001','3.3.2.11'),
	('C00001','3.3.2.12'),
	('C00001','3.3.2.13'),
	('C00001','3.3.2.14'),
	('C00001','3.3.2.2'),
	('C00001','3.3.2.4'),
	('C00001','3.3.2.6'),
	('C00001','3.5.1.97'),
	('C00001','3.5.1.99'),
	('C00001','3.5.2.1'),
	('C00001','3.5.2.10'),
	('C00001','3.5.2.11'),
	('C00001','3.5.2.12'),
	('C00001','3.5.2.13'),
	('C00001','3.5.2.14'),
	('C00001','3.5.2.15'),
	('C00001','3.5.2.16'),
	('C00001','3.5.2.17'),
	('C00001','3.5.2.18'),
	('C00001','3.5.2.19'),
	('C00001','3.5.2.2'),
	('C00001','3.5.2.20'),
	('C00001','3.5.2.3'),
	('C00001','3.5.2.4'),
	('C00001','3.5.2.5'),
	('C00001','3.5.2.6'),
	('C00001','3.5.2.7'),
	('C00001','3.5.2.9'),
	('C00001','3.5.3.1'),
	('C00001','3.5.1.6'),
	('C00001','3.5.1.60'),
	('C00001','3.5.1.61'),
	('C00001','3.5.1.62'),
	('C00001','3.5.1.63'),
	('C00001','3.5.1.64'),
	('C00001','3.5.1.65'),
	('C00001','3.5.1.66'),
	('C00001','3.5.1.67'),
	('C00001','3.5.1.68'),
	('C00001','3.5.1.7'),
	('C00001','3.5.1.71'),
	('C00001','3.5.1.72'),
	('C00001','3.5.1.73'),
	('C00001','3.5.1.74'),
	('C00001','3.5.1.75'),
	('C00001','3.5.1.76'),
	('C00001','3.5.1.77'),
	('C00001','3.5.1.78'),
	('C00001','3.5.1.79'),
	('C00001','3.5.1.8'),
	('C00001','3.5.1.81'),
	('C00001','3.5.1.82'),
	('C00001','3.5.1.83'),
	('C00001','3.5.1.84'),
	('C00001','3.5.1.85'),
	('C00001','3.5.1.35'),
	('C00001','3.5.1.36'),
	('C00001','3.5.1.38'),
	('C00001','3.5.1.39'),
	('C00001','3.5.1.4'),
	('C00001','3.5.1.40'),
	('C00001','3.5.1.41'),
	('C00001','3.5.1.42'),
	('C00001','3.5.1.43'),
	('C00001','3.5.1.44'),
	('C00001','3.5.1.46'),
	('C00001','3.5.1.47'),
	('C00001','3.5.1.48'),
	('C00001','3.5.1.49'),
	('C00001','3.5.4.16'),
	('C00001','3.5.4.17'),
	('C00001','3.5.4.18'),
	('C00001','3.5.4.19'),
	('C00001','3.5.4.2'),
	('C00001','3.5.4.20'),
	('C00001','3.5.4.21'),
	('C00001','3.5.4.22'),
	('C00001','3.5.4.23'),
	('C00001','3.5.4.24'),
	('C00001','3.5.4.25'),
	('C00001','3.5.4.26'),
	('C00001','3.5.4.27'),
	('C00001','3.5.4.28'),
	('C00001','3.5.4.29'),
	('C00001','3.5.4.3'),
	('C00001','3.5.4.30'),
	('C00001','3.5.4.31'),
	('C00001','3.5.4.32'),
	('C00001','3.5.4.33'),
	('C00001','3.5.4.34'),
	('C00001','3.5.4.35'),
	('C00001','3.5.4.39'),
	('C00001','3.5.3.10'),
	('C00001','3.5.3.11'),
	('C00001','3.5.3.12'),
	('C00001','3.5.3.13'),
	('C00001','3.5.3.14'),
	('C00001','3.5.3.15'),
	('C00001','3.5.3.16'),
	('C00001','3.5.3.17'),
	('C00001','3.5.3.18'),
	('C00001','3.5.3.2'),
	('C00001','3.5.3.20'),
	('C00001','3.5.3.21'),
	('C00001','3.5.3.22'),
	('C00001','3.5.3.23'),
	('C00001','3.5.3.24'),
	('C00001','3.5.3.25'),
	('C00001','3.5.3.26'),
	('C00001','3.5.3.3'),
	('C00001','3.5.3.4'),
	('C00001','3.5.3.5'),
	('C00001','3.5.3.6'),
	('C00001','3.5.3.7'),
	('C00001','3.5.3.8'),
	('C00001','3.5.3.9'),
	('C00001','3.5.4.1'),
	('C00001','3.5.4.10'),
	('C00001','3.5.4.11'),
	('C00001','3.5.4.12'),
	('C00001','3.5.1.86'),
	('C00001','3.5.1.87'),
	('C00001','3.5.1.88'),
	('C00001','3.5.1.89'),
	('C00001','3.5.1.9'),
	('C00001','3.5.1.90'),
	('C00001','3.5.1.91'),
	('C00001','3.5.1.92'),
	('C00001','3.5.1.93'),
	('C00001','3.5.1.94'),
	('C00001','3.5.1.95'),
	('C00001','3.5.1.96'),
	('C00001','3.6.1.42'),
	('C00001','3.6.1.43'),
	('C00001','3.6.1.44'),
	('C00001','3.6.1.45'),
	('C00001','3.6.1.5'),
	('C00001','3.6.1.52'),
	('C00001','3.6.1.53'),
	('C00001','3.6.1.54'),
	('C00001','3.6.1.55'),
	('C00001','3.6.1.56'),
	('C00001','3.6.1.57'),
	('C00001','3.6.1.58'),
	('C00001','3.6.1.59'),
	('C00001','3.6.1.6'),
	('C00001','3.6.1.60'),
	('C00001','3.6.1.61'),
	('C00001','3.6.1.1'),
	('C00001','3.6.1.10'),
	('C00001','3.6.1.11'),
	('C00001','3.6.1.12'),
	('C00001','3.6.1.13'),
	('C00001','3.6.1.14'),
	('C00001','3.6.1.15'),
	('C00001','3.6.1.16'),
	('C00001','3.6.1.17'),
	('C00001','3.6.1.18'),
	('C00001','3.6.1.2'),
	('C00001','3.6.1.20'),
	('C00001','3.6.1.21'),
	('C00001','3.6.1.22'),
	('C00001','3.6.1.23'),
	('C00001','3.6.1.25'),
	('C00001','3.6.1.26'),
	('C00001','3.6.1.27'),
	('C00001','3.5.4.4'),
	('C00001','3.5.4.40'),
	('C00001','3.5.4.41'),
	('C00001','3.5.4.42'),
	('C00001','3.5.4.43'),
	('C00001','3.5.4.5'),
	('C00001','3.5.4.6'),
	('C00001','3.5.4.7'),
	('C00001','3.5.4.8'),
	('C00001','3.5.4.9'),
	('C00001','3.5.5.1'),
	('C00001','3.5.5.2'),
	('C00001','3.5.5.4'),
	('C00001','3.5.5.5'),
	('C00001','3.5.5.6'),
	('C00001','3.5.5.7'),
	('C00001','3.5.5.8'),
	('C00001','3.5.99.1'),
	('C00001','3.5.99.10'),
	('C00001','3.5.99.2'),
	('C00001','3.5.99.5'),
	('C00001','3.5.99.6'),
	('C00001','3.5.99.7'),
	('C00001','3.5.99.8'),
	('C00001','3.5.99.9'),
	('C00001','3.5.4.13'),
	('C00001','3.5.4.15'),
	('C00001','3.6.3.5'),
	('C00001','3.6.3.50'),
	('C00001','3.6.3.51'),
	('C00001','3.6.3.52'),
	('C00001','3.6.3.53'),
	('C00001','3.6.3.54'),
	('C00001','3.6.3.55'),
	('C00001','3.6.3.6'),
	('C00001','3.6.3.7'),
	('C00001','3.6.3.8'),
	('C00001','3.6.3.29'),
	('C00001','3.6.3.3'),
	('C00001','3.6.3.30'),
	('C00001','3.6.3.31'),
	('C00001','3.6.3.32'),
	('C00001','3.6.3.33'),
	('C00001','3.6.3.34'),
	('C00001','3.6.3.35'),
	('C00001','3.6.3.36'),
	('C00001','3.6.3.37'),
	('C00001','3.6.3.38'),
	('C00001','3.6.3.39'),
	('C00001','3.6.3.4'),
	('C00001','3.6.3.40'),
	('C00001','3.6.3.41'),
	('C00001','3.6.3.42'),
	('C00001','3.6.3.14'),
	('C00001','3.6.3.15'),
	('C00001','3.6.3.16'),
	('C00001','3.6.3.17'),
	('C00001','3.6.3.18'),
	('C00001','3.6.3.19'),
	('C00001','3.6.3.2'),
	('C00001','3.6.3.20'),
	('C00001','3.6.3.21'),
	('C00001','3.6.3.22'),
	('C00001','3.6.3.23'),
	('C00001','3.6.3.24'),
	('C00001','3.6.3.25'),
	('C00001','3.6.3.26'),
	('C00001','3.6.3.27'),
	('C00001','3.6.3.28'),
	('C00001','3.6.1.62'),
	('C00001','3.6.1.63'),
	('C00001','3.6.1.64'),
	('C00001','3.6.1.65'),
	('C00001','3.6.1.66'),
	('C00001','3.6.1.67'),
	('C00001','3.6.1.7'),
	('C00001','3.6.1.8'),
	('C00001','3.6.1.9'),
	('C00001','3.6.2.1'),
	('C00001','3.6.2.2'),
	('C00001','3.6.3.1'),
	('C00001','3.6.3.10'),
	('C00001','3.6.3.11'),
	('C00001','3.6.3.12'),
	('C00001','3.6.1.28'),
	('C00001','3.6.1.29'),
	('C00001','3.6.1.3'),
	('C00001','3.6.1.31'),
	('C00001','3.6.1.39'),
	('C00001','3.6.1.40'),
	('C00001','3.6.1.41'),
	('C00001','3.8.1.7'),
	('C00001','3.8.1.8'),
	('C00001','3.8.1.9'),
	('C00001','3.9.1.1'),
	('C00001','3.9.1.2'),
	('C00001','3.9.1.3'),
	('C00001','3.6.5.3'),
	('C00001','3.6.5.4'),
	('C00001','3.6.5.5'),
	('C00001','3.6.5.6'),
	('C00001','3.7.1.1'),
	('C00001','3.7.1.10'),
	('C00001','3.7.1.11'),
	('C00001','3.7.1.12'),
	('C00001','3.7.1.13'),
	('C00001','3.7.1.14'),
	('C00001','3.7.1.17'),
	('C00001','3.7.1.18'),
	('C00001','3.7.1.19'),
	('C00001','3.7.1.2'),
	('C00001','3.7.1.20'),
	('C00001','3.7.1.21'),
	('C00001','3.7.1.22'),
	('C00001','3.7.1.23'),
	('C00001','3.7.1.3'),
	('C00001','3.7.1.4'),
	('C00001','3.7.1.5'),
	('C00001','3.7.1.6'),
	('C00001','3.7.1.7'),
	('C00001','3.7.1.8'),
	('C00001','3.7.1.9'),
	('C00001','3.8.1.1'),
	('C00001','3.8.1.10'),
	('C00001','3.8.1.11'),
	('C00001','3.8.1.2'),
	('C00001','3.8.1.3'),
	('C00001','3.8.1.5'),
	('C00001','3.8.1.6'),
	('C00001','3.6.3.9'),
	('C00001','3.6.4.1'),
	('C00001','3.6.4.10'),
	('C00001','3.6.4.11'),
	('C00001','3.6.4.12'),
	('C00001','3.6.4.13'),
	('C00001','3.6.4.2'),
	('C00001','3.6.4.3'),
	('C00001','3.6.4.4'),
	('C00001','3.6.4.5'),
	('C00001','3.6.4.6'),
	('C00001','3.6.4.7'),
	('C00001','3.6.4.8'),
	('C00001','3.6.4.9'),
	('C00001','3.6.5.1'),
	('C00001','3.6.5.2'),
	('C00001','3.6.3.43'),
	('C00001','3.6.3.44'),
	('C00001','3.6.3.46'),
	('C00001','3.6.3.47'),
	('C00001','3.6.3.48'),
	('C00001','3.6.3.49'),
	('C00001','4.2.1.41'),
	('C00001','4.2.1.42'),
	('C00001','4.1.99.5'),
	('C00001','4.2.1.1'),
	('C00001','4.2.1.10'),
	('C00001','4.2.1.100'),
	('C00001','4.2.1.101'),
	('C00001','4.2.1.103'),
	('C00001','4.2.1.105'),
	('C00001','4.2.1.106'),
	('C00001','4.2.1.107'),
	('C00001','4.2.1.108'),
	('C00001','4.2.1.109'),
	('C00001','4.2.1.11'),
	('C00001','4.2.1.110'),
	('C00001','4.2.1.111'),
	('C00001','4.2.1.112'),
	('C00001','4.2.1.113'),
	('C00001','4.2.1.114'),
	('C00001','4.2.1.115'),
	('C00001','4.2.1.116'),
	('C00001','4.2.1.117'),
	('C00001','4.2.1.118'),
	('C00001','4.2.1.119'),
	('C00001','4.2.1.12'),
	('C00001','4.2.1.120'),
	('C00001','4.2.1.121'),
	('C00001','4.2.1.122'),
	('C00001','4.2.1.123'),
	('C00001','4.2.1.124'),
	('C00001','4.2.1.125'),
	('C00001','4.2.1.126'),
	('C00001','4.2.1.127'),
	('C00001','4.2.1.128'),
	('C00001','4.2.1.129'),
	('C00001','4.2.1.130'),
	('C00001','4.2.1.131'),
	('C00001','4.2.1.132'),
	('C00001','4.2.1.133'),
	('C00001','4.2.1.134'),
	('C00001','4.2.1.135'),
	('C00001','4.1.3.27'),
	('C00001','4.1.3.36'),
	('C00001','4.1.3.44'),
	('C00001','4.1.99.1'),
	('C00001','4.1.99.16'),
	('C00001','4.1.99.2'),
	('C00001','4.1.99.20'),
	('C00001','4.1.2.22'),
	('C00001','4.1.2.34'),
	('C00001','4.1.2.44'),
	('C00001','4.1.2.45'),
	('C00001','4.1.2.50'),
	('C00001','4.1.2.9'),
	('C00001','4.1.1.60'),
	('C00001','4.1.1.78'),
	('C00001','4.1.1.90'),
	('C00001','4.1.1.93'),
	('C00001','4.1.1.31'),
	('C00001','4.1.1.39'),
	('C00001','4.1.1.48'),
	('C00001','4.2.1.79'),
	('C00001','4.2.1.8'),
	('C00001','4.2.1.80'),
	('C00001','4.2.1.81'),
	('C00001','4.2.1.82'),
	('C00001','4.2.1.83'),
	('C00001','4.2.1.84'),
	('C00001','4.2.1.85'),
	('C00001','4.2.1.9'),
	('C00001','4.2.1.90'),
	('C00001','4.2.1.91'),
	('C00001','4.2.1.92'),
	('C00001','4.2.1.94'),
	('C00001','4.2.1.95'),
	('C00001','4.2.1.96'),
	('C00001','4.2.1.97'),
	('C00001','4.2.1.98'),
	('C00001','4.2.1.99'),
	('C00001','4.2.1.137'),
	('C00001','4.2.1.138'),
	('C00001','4.2.1.139'),
	('C00001','4.2.1.140'),
	('C00001','4.2.1.141'),
	('C00001','4.2.1.142'),
	('C00001','4.2.1.143'),
	('C00001','4.2.1.144'),
	('C00001','4.2.1.145'),
	('C00001','4.2.1.146'),
	('C00001','4.2.1.147'),
	('C00001','4.2.1.148'),
	('C00001','4.2.1.149'),
	('C00001','4.2.1.151'),
	('C00001','4.2.1.152'),
	('C00001','4.2.1.153'),
	('C00001','4.2.1.154'),
	('C00001','4.2.1.155'),
	('C00001','4.2.1.156'),
	('C00001','4.2.1.157'),
	('C00001','4.2.1.158'),
	('C00001','4.2.1.159'),
	('C00001','4.2.1.160'),
	('C00001','4.2.1.162'),
	('C00001','4.2.1.164'),
	('C00001','4.2.1.165'),
	('C00001','4.2.1.17'),
	('C00001','4.2.1.18'),
	('C00001','4.2.1.19'),
	('C00001','4.2.1.2'),
	('C00001','4.2.1.20'),
	('C00001','4.2.1.22'),
	('C00001','4.2.1.24'),
	('C00001','4.2.1.25'),
	('C00001','4.2.1.27'),
	('C00001','4.2.1.28'),
	('C00001','4.2.1.3'),
	('C00001','4.2.1.30'),
	('C00001','4.2.1.31'),
	('C00001','4.2.1.32'),
	('C00001','4.2.1.33'),
	('C00001','4.2.1.34'),
	('C00001','4.2.1.35'),
	('C00001','4.2.1.36'),
	('C00001','4.2.1.39'),
	('C00001','4.2.1.40'),
	('C00001','4.2.3.70'),
	('C00001','4.2.3.74'),
	('C00001','4.2.3.84'),
	('C00001','4.2.3.85'),
	('C00001','4.2.3.91'),
	('C00001','4.2.3.96'),
	('C00001','4.2.3.98'),
	('C00001','4.2.3.145'),
	('C00001','4.2.3.146'),
	('C00001','4.2.3.149'),
	('C00001','4.2.3.151'),
	('C00001','4.2.3.153'),
	('C00001','4.2.3.154'),
	('C00001','4.2.3.2'),
	('C00001','4.2.3.22'),
	('C00001','4.2.3.25'),
	('C00001','4.2.3.26'),
	('C00001','4.2.3.39'),
	('C00001','4.2.3.42'),
	('C00001','4.2.3.45'),
	('C00001','4.2.3.48'),
	('C00001','4.2.3.1'),
	('C00001','4.2.3.10'),
	('C00001','4.2.3.108'),
	('C00001','4.2.3.11'),
	('C00001','4.2.3.111'),
	('C00001','4.2.3.112'),
	('C00001','4.2.3.118'),
	('C00001','4.2.3.134'),
	('C00001','4.2.3.138'),
	('C00001','4.2.3.141'),
	('C00001','4.2.3.143'),
	('C00001','4.2.3.144'),
	('C00001','4.2.1.43'),
	('C00001','4.2.1.44'),
	('C00001','4.2.1.45'),
	('C00001','4.2.1.46'),
	('C00001','4.2.1.47'),
	('C00001','4.2.1.48'),
	('C00001','4.2.1.49'),
	('C00001','4.2.1.5'),
	('C00001','4.2.1.50'),
	('C00001','4.2.1.51'),
	('C00001','4.2.1.53'),
	('C00001','4.2.1.54'),
	('C00001','4.2.1.55'),
	('C00001','4.2.1.56'),
	('C00001','4.2.1.57'),
	('C00001','4.2.1.59'),
	('C00001','4.2.1.6'),
	('C00001','4.2.1.62'),
	('C00001','4.2.1.65'),
	('C00001','4.2.1.66'),
	('C00001','4.2.1.67'),
	('C00001','4.2.1.68'),
	('C00001','4.2.1.69'),
	('C00001','4.2.1.7'),
	('C00001','4.2.1.70'),
	('C00001','4.2.1.73'),
	('C00001','4.2.1.74'),
	('C00001','4.2.1.75'),
	('C00001','4.2.1.76'),
	('C00001','4.2.1.77'),
	('C00001','4.2.1.78'),
	('C00001','6.6.1.1'),
	('C00001','6.6.1.2'),
	('C00001','6.4.1.6'),
	('C00001','6.4.1.8'),
	('C00001','6.3.5.1'),
	('C00001','6.3.5.10'),
	('C00001','6.3.5.11'),
	('C00001','6.3.5.2'),
	('C00001','6.3.5.3'),
	('C00001','6.3.5.4'),
	('C00001','6.3.5.5'),
	('C00001','6.3.5.6'),
	('C00001','6.3.5.7'),
	('C00001','6.3.5.9'),
	('C00001','6.3.4.20'),
	('C00001','6.3.4.21'),
	('C00001','6.3.4.22'),
	('C00001','6.3.4.8'),
	('C00001','6.3.3.5'),
	('C00001','6.3.4.16'),
	('C00001','6.3.4.19'),
	('C00001','6.3.4.2'),
	('C00001','6.3.2.26'),
	('C00001','6.1.2.2'),
	('C00001','5.1.3.14'),
	('C00001','4.4.1.6'),
	('C00001','4.4.1.8'),
	('C00001','4.5.1.2'),
	('C00001','4.5.1.3'),
	('C00001','4.5.1.4'),
	('C00001','4.6.1.13'),
	('C00001','4.6.1.17'),
	('C00001','4.99.1.5'),
	('C00001','4.99.1.6'),
	('C00001','4.99.1.7'),
	('C00001','5.1.1.11'),
	('C00001','4.3.1.9'),
	('C00001','4.3.2.4'),
	('C00001','4.3.3.2'),
	('C00001','4.3.3.3'),
	('C00001','4.3.3.4'),
	('C00001','4.3.3.5'),
	('C00001','4.3.3.6'),
	('C00001','4.3.3.7'),
	('C00001','4.4.1.1'),
	('C00001','4.4.1.11'),
	('C00001','4.4.1.13'),
	('C00001','4.4.1.15'),
	('C00001','4.4.1.2'),
	('C00001','4.4.1.25'),
	('C00001','4.4.1.27'),
	('C00001','4.4.1.28'),
	('C00001','4.3.1.10'),
	('C00001','4.3.1.13'),
	('C00001','4.3.1.15'),
	('C00001','4.3.1.17'),
	('C00001','4.2.3.49'),
	('C00001','4.2.3.64'),
	('C00001','4.2.3.68'),
	('C00002','2.5.1.17'),
	('C00002','2.5.1.112'),
	('C00002','2.4.2.17'),
	('C00002','2.4.2.52'),
	('C00002','2.3.3.8'),
	('C00002','1.3.7.15'),
	('C00002','1.3.7.7'),
	('C00002','1.3.7.8'),
	('C00002','1.2.1.30'),
	('C00002','1.2.1.31'),
	('C00002','1.18.6.1'),
	('C00002','1.19.6.1'),
	('C00002','1.17.4.2'),
	('C00002','1.13.12.7'),
	('C00002','2.7.1.165'),
	('C00002','2.7.1.166'),
	('C00002','2.7.1.167'),
	('C00002','2.7.1.168'),
	('C00002','2.7.1.169'),
	('C00002','2.7.1.17'),
	('C00002','2.7.1.170'),
	('C00002','2.7.1.173'),
	('C00002','2.7.1.175'),
	('C00002','2.7.1.176'),
	('C00002','2.7.1.177'),
	('C00002','2.7.1.178'),
	('C00002','2.7.1.179'),
	('C00002','2.7.1.18'),
	('C00002','2.7.1.181'),
	('C00002','2.7.1.184'),
	('C00002','2.7.1.185'),
	('C00002','2.7.1.186'),
	('C00002','2.7.1.187'),
	('C00002','2.7.1.188'),
	('C00002','2.7.1.189'),
	('C00002','2.7.1.19'),
	('C00002','2.7.1.2'),
	('C00002','2.7.1.20'),
	('C00002','2.7.1.13'),
	('C00002','2.7.1.130'),
	('C00002','2.7.1.134'),
	('C00002','2.7.1.136'),
	('C00002','2.7.1.137'),
	('C00002','2.7.1.138'),
	('C00002','2.7.1.14'),
	('C00002','2.7.1.140'),
	('C00002','2.7.1.144'),
	('C00002','2.7.1.145'),
	('C00002','2.7.1.148'),
	('C00002','2.7.1.149'),
	('C00002','2.7.1.15'),
	('C00002','2.7.1.150'),
	('C00002','2.7.1.151'),
	('C00002','2.7.1.153'),
	('C00002','2.7.1.154'),
	('C00002','2.7.1.156'),
	('C00002','2.7.1.157'),
	('C00002','2.7.1.158'),
	('C00002','2.7.1.159'),
	('C00002','2.7.1.16'),
	('C00002','2.7.1.162'),
	('C00002','2.7.1.163'),
	('C00002','2.7.1.1'),
	('C00002','2.7.1.10'),
	('C00002','2.7.1.100'),
	('C00002','2.7.1.101'),
	('C00002','2.7.1.102'),
	('C00002','2.7.1.103'),
	('C00002','2.7.1.105'),
	('C00002','2.7.1.107'),
	('C00002','2.7.1.11'),
	('C00002','2.7.1.113'),
	('C00002','2.7.1.119'),
	('C00002','2.7.1.12'),
	('C00002','2.7.1.122'),
	('C00002','2.7.1.127'),
	('C00002','2.5.1.6'),
	('C00002','2.7.1.83'),
	('C00002','2.7.1.84'),
	('C00002','2.7.1.85'),
	('C00002','2.7.1.86'),
	('C00002','2.7.1.87'),
	('C00002','2.7.1.88'),
	('C00002','2.7.1.89'),
	('C00002','2.7.1.91'),
	('C00002','2.7.1.92'),
	('C00002','2.7.1.93'),
	('C00002','2.7.1.94'),
	('C00002','2.7.1.95'),
	('C00002','2.7.10.1'),
	('C00002','2.7.10.2'),
	('C00002','2.7.11.1'),
	('C00002','2.7.11.10'),
	('C00002','2.7.11.11'),
	('C00002','2.7.1.44'),
	('C00002','2.7.1.45'),
	('C00002','2.7.1.46'),
	('C00002','2.7.1.47'),
	('C00002','2.7.1.48'),
	('C00002','2.7.1.49'),
	('C00002','2.7.1.5'),
	('C00002','2.7.1.50'),
	('C00002','2.7.1.51'),
	('C00002','2.7.1.52'),
	('C00002','2.7.1.53'),
	('C00002','2.7.1.54'),
	('C00002','2.7.1.55'),
	('C00002','2.7.1.56'),
	('C00002','2.7.1.58'),
	('C00002','2.7.1.59'),
	('C00002','2.7.1.6'),
	('C00002','2.7.1.60'),
	('C00002','2.7.1.64'),
	('C00002','2.7.1.65'),
	('C00002','2.7.1.66'),
	('C00002','2.7.1.67'),
	('C00002','2.7.1.68'),
	('C00002','2.7.1.7'),
	('C00002','2.7.1.71'),
	('C00002','2.7.1.21'),
	('C00002','2.7.1.22'),
	('C00002','2.7.1.23'),
	('C00002','2.7.1.24'),
	('C00002','2.7.1.25'),
	('C00002','2.7.1.26'),
	('C00002','2.7.1.27'),
	('C00002','2.7.1.28'),
	('C00002','2.7.1.29'),
	('C00002','2.7.1.3'),
	('C00002','2.7.1.30'),
	('C00002','2.7.1.31'),
	('C00002','2.7.1.32'),
	('C00002','2.7.1.33'),
	('C00002','2.7.1.34'),
	('C00002','2.7.1.35'),
	('C00002','2.7.1.36'),
	('C00002','2.7.1.39'),
	('C00002','2.7.1.4'),
	('C00002','2.7.1.40'),
	('C00002','2.7.1.43'),
	('C00002','2.7.1.164'),
	('C00002','2.7.4.25'),
	('C00002','2.7.4.26'),
	('C00002','2.7.4.3'),
	('C00002','2.7.4.31'),
	('C00002','2.7.4.4'),
	('C00002','2.7.4.6'),
	('C00002','2.7.12.2'),
	('C00002','2.7.13.1'),
	('C00002','2.7.13.2'),
	('C00002','2.7.14.1'),
	('C00002','2.7.2.1'),
	('C00002','2.7.2.11'),
	('C00002','2.7.2.13'),
	('C00002','2.7.2.14'),
	('C00002','2.7.2.15'),
	('C00002','2.7.2.2'),
	('C00002','2.7.2.3'),
	('C00002','2.7.2.4'),
	('C00002','2.7.2.6'),
	('C00002','2.7.2.7'),
	('C00002','2.7.2.8'),
	('C00002','2.7.3.1'),
	('C00002','2.7.3.10'),
	('C00002','2.7.3.2'),
	('C00002','2.7.3.3'),
	('C00002','2.7.3.4'),
	('C00002','2.7.3.5'),
	('C00002','2.7.3.6'),
	('C00002','2.7.3.7'),
	('C00002','2.7.11.12'),
	('C00002','2.7.11.13'),
	('C00002','2.7.11.14'),
	('C00002','2.7.11.15'),
	('C00002','2.7.11.17'),
	('C00002','2.7.11.18'),
	('C00002','2.7.11.19'),
	('C00002','2.7.11.2'),
	('C00002','2.7.11.21'),
	('C00002','2.7.11.22'),
	('C00002','2.7.11.23'),
	('C00002','2.7.11.24'),
	('C00002','2.7.11.25'),
	('C00002','2.7.11.26'),
	('C00002','2.7.11.27'),
	('C00002','2.7.11.28'),
	('C00002','2.7.11.29'),
	('C00002','2.7.11.3'),
	('C00002','2.7.11.30'),
	('C00002','2.7.11.31'),
	('C00002','2.7.11.4'),
	('C00002','2.7.11.5'),
	('C00002','2.7.11.6'),
	('C00002','2.7.11.7'),
	('C00002','2.7.11.8'),
	('C00002','2.7.11.9'),
	('C00002','2.7.12.1'),
	('C00002','2.7.1.72'),
	('C00002','2.7.1.73'),
	('C00002','2.7.1.74'),
	('C00002','2.7.1.76'),
	('C00002','2.7.1.78'),
	('C00002','2.7.1.8'),
	('C00002','2.7.1.82'),
	('C00002','3.6.3.11'),
	('C00002','3.6.3.12'),
	('C00002','3.6.1.3'),
	('C00002','3.6.1.5'),
	('C00002','3.6.1.61'),
	('C00002','3.6.1.14'),
	('C00002','3.6.1.15'),
	('C00002','3.6.1.17'),
	('C00002','3.5.4.17'),
	('C00002','3.5.4.18'),
	('C00002','3.5.2.14'),
	('C00002','3.5.2.9'),
	('C00002','2.7.9.3'),
	('C00002','2.8.1.13'),
	('C00002','2.7.7.87'),
	('C00002','2.7.8.37'),
	('C00002','2.7.9.1'),
	('C00002','2.7.9.2'),
	('C00002','2.7.7.58'),
	('C00002','2.7.7.6'),
	('C00002','2.7.7.70'),
	('C00002','2.7.7.72'),
	('C00002','2.7.7.73'),
	('C00002','2.7.7.75'),
	('C00002','2.7.7.84'),
	('C00002','2.7.7.85'),
	('C00002','2.7.7.86'),
	('C00002','2.7.7.4'),
	('C00002','2.7.7.42'),
	('C00002','2.7.7.46'),
	('C00002','2.7.7.47'),
	('C00002','2.7.7.48'),
	('C00002','2.7.7.53'),
	('C00002','2.7.4.7'),
	('C00002','2.7.4.8'),
	('C00002','2.7.4.9'),
	('C00002','2.7.6.1'),
	('C00002','2.7.6.2'),
	('C00002','2.7.6.3'),
	('C00002','2.7.6.4'),
	('C00002','2.7.6.5'),
	('C00002','2.7.7.1'),
	('C00002','2.7.7.18'),
	('C00002','2.7.7.19'),
	('C00002','2.7.7.2'),
	('C00002','2.7.7.27'),
	('C00002','2.7.7.3'),
	('C00002','2.7.3.8'),
	('C00002','2.7.4.1'),
	('C00002','2.7.4.11'),
	('C00002','2.7.4.12'),
	('C00002','2.7.4.13'),
	('C00002','2.7.4.14'),
	('C00002','2.7.4.15'),
	('C00002','2.7.4.16'),
	('C00002','2.7.4.18'),
	('C00002','2.7.4.19'),
	('C00002','2.7.4.2'),
	('C00002','2.7.4.21'),
	('C00002','2.7.4.22'),
	('C00002','2.7.4.23'),
	('C00002','2.7.4.24'),
	('C00002','3.6.4.10'),
	('C00002','3.6.4.11'),
	('C00002','3.6.4.12'),
	('C00002','3.6.4.13'),
	('C00002','3.6.4.2'),
	('C00002','3.6.4.3'),
	('C00002','3.6.4.4'),
	('C00002','3.6.4.5'),
	('C00002','3.6.4.6'),
	('C00002','3.6.4.7'),
	('C00002','3.6.4.8'),
	('C00002','3.6.4.9'),
	('C00002','3.6.3.43'),
	('C00002','3.6.3.44'),
	('C00002','3.6.3.46'),
	('C00002','3.6.3.47'),
	('C00002','3.6.3.48'),
	('C00002','3.6.3.49'),
	('C00002','3.6.3.5'),
	('C00002','3.6.3.50'),
	('C00002','3.6.3.51'),
	('C00002','3.6.3.52'),
	('C00002','3.6.3.53'),
	('C00002','3.6.3.54'),
	('C00002','3.6.3.55'),
	('C00002','3.6.3.6'),
	('C00002','3.6.3.7'),
	('C00002','3.6.3.8'),
	('C00002','3.6.3.29'),
	('C00002','3.6.3.3'),
	('C00002','3.6.3.30'),
	('C00002','3.6.3.31'),
	('C00002','3.6.3.32'),
	('C00002','3.6.3.33'),
	('C00002','3.6.3.34'),
	('C00002','3.6.3.35'),
	('C00002','3.6.3.36'),
	('C00002','3.6.3.37'),
	('C00002','3.6.3.38'),
	('C00002','3.6.3.39'),
	('C00002','3.6.3.4'),
	('C00002','3.6.3.40'),
	('C00002','3.6.3.41'),
	('C00002','3.6.3.42'),
	('C00002','3.6.3.14'),
	('C00002','3.6.3.15'),
	('C00002','3.6.3.16'),
	('C00002','3.6.3.17'),
	('C00002','3.6.3.18'),
	('C00002','3.6.3.19'),
	('C00002','3.6.3.2'),
	('C00002','3.6.3.20'),
	('C00002','3.6.3.21'),
	('C00002','3.6.3.22'),
	('C00002','3.6.3.23'),
	('C00002','3.6.3.24'),
	('C00002','3.6.3.25'),
	('C00002','3.6.3.26'),
	('C00002','3.6.3.27'),
	('C00002','3.6.3.28'),
	('C00002','3.6.1.8'),
	('C00002','3.6.1.9'),
	('C00002','3.6.3.1'),
	('C00002','3.6.3.10'),
	('C00002','6.2.1.6'),
	('C00002','6.2.1.7'),
	('C00002','6.2.1.19'),
	('C00002','6.2.1.2'),
	('C00002','6.2.1.20'),
	('C00002','6.2.1.22'),
	('C00002','6.2.1.23'),
	('C00002','6.2.1.24'),
	('C00002','6.2.1.25'),
	('C00002','6.2.1.26'),
	('C00002','6.2.1.27'),
	('C00002','6.2.1.28'),
	('C00002','6.2.1.3'),
	('C00002','6.2.1.30'),
	('C00002','6.2.1.31'),
	('C00002','6.2.1.32'),
	('C00002','6.2.1.33'),
	('C00002','6.2.1.34'),
	('C00002','6.1.1.9'),
	('C00002','6.1.2.1'),
	('C00002','6.1.2.2'),
	('C00002','6.2.1.1'),
	('C00002','6.2.1.11'),
	('C00002','6.2.1.12'),
	('C00002','6.2.1.13'),
	('C00002','6.2.1.14'),
	('C00002','6.2.1.15'),
	('C00002','6.2.1.16'),
	('C00002','6.2.1.17'),
	('C00002','6.2.1.18'),
	('C00002','6.1.1.15'),
	('C00002','6.1.1.16'),
	('C00002','6.1.1.17'),
	('C00002','6.1.1.18'),
	('C00002','6.1.1.19'),
	('C00002','6.1.1.2'),
	('C00002','6.1.1.20'),
	('C00002','6.1.1.21'),
	('C00002','6.1.1.22'),
	('C00002','6.1.1.23'),
	('C00002','6.1.1.24'),
	('C00002','6.1.1.26'),
	('C00002','6.1.1.27'),
	('C00002','6.1.1.3'),
	('C00002','6.1.1.4'),
	('C00002','6.1.1.5'),
	('C00002','6.1.1.6'),
	('C00002','6.1.1.7'),
	('C00002','6.1.1.1'),
	('C00002','6.1.1.10'),
	('C00002','6.1.1.11'),
	('C00002','6.1.1.12'),
	('C00002','6.1.1.13'),
	('C00002','6.1.1.14'),
	('C00002','4.6.1.1'),
	('C00002','5.1.1.11'),
	('C00002','4.2.1.93'),
	('C00002','4.1.1.99'),
	('C00002','4.1.1.33'),
	('C00002','4.1.1.49'),
	('C00002','3.6.3.9'),
	('C00002','3.6.4.1'),
	('C00002','6.3.2.49'),
	('C00002','6.3.2.5'),
	('C00002','6.3.2.6'),
	('C00002','6.3.2.7'),
	('C00002','6.3.2.8'),
	('C00002','6.3.2.9'),
	('C00002','6.3.2.23'),
	('C00002','6.3.2.24'),
	('C00002','6.3.2.25'),
	('C00002','6.3.2.26'),
	('C00002','6.3.2.29'),
	('C00002','6.3.2.3'),
	('C00002','6.3.2.30'),
	('C00002','6.3.2.32'),
	('C00002','6.3.2.33'),
	('C00002','6.3.2.35'),
	('C00002','6.3.2.36'),
	('C00002','6.3.2.37'),
	('C00002','6.3.2.38'),
	('C00002','6.3.2.39'),
	('C00002','6.3.1.6'),
	('C00002','6.3.1.7'),
	('C00002','6.3.1.8'),
	('C00002','6.3.1.9'),
	('C00002','6.3.2.1'),
	('C00002','6.3.2.10'),
	('C00002','6.3.2.11'),
	('C00002','6.3.2.12'),
	('C00002','6.3.2.13'),
	('C00002','6.3.2.14'),
	('C00002','6.3.2.16'),
	('C00002','6.3.2.17'),
	('C00002','6.3.2.18'),
	('C00002','6.3.2.2'),
	('C00002','6.3.2.20'),
	('C00002','6.2.1.8'),
	('C00002','6.2.1.9'),
	('C00002','6.3.1.1'),
	('C00002','6.3.1.10'),
	('C00002','6.3.1.11'),
	('C00002','6.3.1.12'),
	('C00002','6.3.1.13'),
	('C00002','6.3.1.14'),
	('C00002','6.3.1.15'),
	('C00002','6.3.1.17'),
	('C00002','6.3.1.18'),
	('C00002','6.3.1.19'),
	('C00002','6.3.1.2'),
	('C00002','6.3.1.20'),
	('C00002','6.3.1.4'),
	('C00002','6.3.1.5'),
	('C00002','6.2.1.35'),
	('C00002','6.2.1.36'),
	('C00002','6.2.1.37'),
	('C00002','6.2.1.38'),
	('C00002','6.2.1.39'),
	('C00002','6.2.1.40'),
	('C00002','6.2.1.41'),
	('C00002','6.2.1.42'),
	('C00002','6.2.1.43'),
	('C00002','6.2.1.44'),
	('C00002','6.2.1.46'),
	('C00002','6.2.1.5'),
	('C00002','6.6.1.1'),
	('C00002','6.6.1.2'),
	('C00002','6.3.5.9'),
	('C00002','6.4.1.1'),
	('C00002','6.4.1.2'),
	('C00002','6.4.1.3'),
	('C00002','6.4.1.4'),
	('C00002','6.4.1.5'),
	('C00002','6.4.1.6'),
	('C00002','6.4.1.7'),
	('C00002','6.4.1.8'),
	('C00002','6.5.1.1'),
	('C00002','6.5.1.3'),
	('C00002','6.5.1.4'),
	('C00002','6.5.1.6'),
	('C00002','6.5.1.7'),
	('C00002','6.3.5.1'),
	('C00002','6.3.5.10'),
	('C00002','6.3.5.11'),
	('C00002','6.3.5.2'),
	('C00002','6.3.5.3'),
	('C00002','6.3.5.4'),
	('C00002','6.3.5.5'),
	('C00002','6.3.5.6'),
	('C00002','6.3.5.7'),
	('C00002','6.3.4.20'),
	('C00002','6.3.4.21'),
	('C00002','6.3.4.22'),
	('C00002','6.3.4.23'),
	('C00002','6.3.4.24'),
	('C00002','6.3.4.3'),
	('C00002','6.3.4.5'),
	('C00002','6.3.4.6'),
	('C00002','6.3.4.7'),
	('C00002','6.3.4.8'),
	('C00002','6.3.4.9'),
	('C00002','6.3.3.1'),
	('C00002','6.3.3.2'),
	('C00002','6.3.3.3'),
	('C00002','6.3.3.4'),
	('C00002','6.3.3.5'),
	('C00002','6.3.3.6'),
	('C00002','6.3.4.10'),
	('C00002','6.3.4.11'),
	('C00002','6.3.4.12'),
	('C00002','6.3.4.13'),
	('C00002','6.3.4.14'),
	('C00002','6.3.4.15'),
	('C00002','6.3.4.16'),
	('C00002','6.3.4.17'),
	('C00002','6.3.4.18'),
	('C00002','6.3.4.19'),
	('C00002','6.3.4.2'),
	('C00002','6.3.2.4'),
	('C00002','6.3.2.40'),
	('C00002','6.3.2.41'),
	('C00002','6.3.2.42'),
	('C00002','6.3.2.43'),
	('C00002','6.3.2.44'),
	('C00002','6.3.2.45'),
	('C00002','6.3.2.46'),
	('C00002','6.3.2.47'),
	('C00002','6.3.2.48'),
	('C00003','1.1.1.185'),
	('C00003','1.1.1.186'),
	('C00003','1.1.1.187'),
	('C00003','1.1.1.190'),
	('C00003','1.1.1.192'),
	('C00003','1.1.1.159'),
	('C00003','1.1.1.16'),
	('C00003','1.1.1.163'),
	('C00003','1.1.1.164'),
	('C00003','1.1.1.165'),
	('C00003','1.1.1.166'),
	('C00003','1.1.1.167'),
	('C00003','1.1.1.17'),
	('C00003','1.1.1.170'),
	('C00003','1.1.1.172'),
	('C00003','1.1.1.173'),
	('C00003','1.1.1.174'),
	('C00003','1.1.1.175'),
	('C00003','1.1.1.141'),
	('C00003','1.1.1.143'),
	('C00003','1.1.1.144'),
	('C00003','1.1.1.145'),
	('C00003','1.1.1.147'),
	('C00003','1.1.1.148'),
	('C00003','1.1.1.149'),
	('C00003','1.1.1.15'),
	('C00003','1.1.1.150'),
	('C00003','1.1.1.152'),
	('C00003','1.1.1.154'),
	('C00003','1.1.1.157'),
	('C00003','1.1.1.125'),
	('C00003','1.1.1.127'),
	('C00003','1.1.1.129'),
	('C00003','1.1.1.13'),
	('C00003','1.1.1.130'),
	('C00003','1.1.1.131'),
	('C00003','1.1.1.132'),
	('C00003','1.1.1.135'),
	('C00003','1.1.1.136'),
	('C00003','1.1.1.137'),
	('C00003','1.1.1.14'),
	('C00003','1.1.1.140'),
	('C00003','1.1.1.108'),
	('C00003','1.1.1.11'),
	('C00003','1.1.1.110'),
	('C00003','1.1.1.111'),
	('C00003','1.1.1.112'),
	('C00003','1.1.1.114'),
	('C00003','1.1.1.116'),
	('C00003','1.1.1.117'),
	('C00003','1.1.1.118'),
	('C00003','1.1.1.12'),
	('C00003','1.1.1.121'),
	('C00003','1.1.1.122'),
	('C00003','1.1.1.1'),
	('C00003','1.1.1.103'),
	('C00003','1.1.1.104'),
	('C00003','1.1.1.105'),
	('C00003','1.1.1.106'),
	('C00003','1.1.1.107'),
	('C00003','1.1.1.282'),
	('C00003','1.1.1.284'),
	('C00003','1.1.1.285'),
	('C00003','1.1.1.286'),
	('C00003','1.1.1.288'),
	('C00003','1.1.1.29'),
	('C00003','1.1.1.290'),
	('C00003','1.1.1.291'),
	('C00003','1.1.1.294'),
	('C00003','1.1.1.295'),
	('C00003','1.1.1.296'),
	('C00003','1.1.1.297'),
	('C00003','1.1.1.268'),
	('C00003','1.1.1.269'),
	('C00003','1.1.1.27'),
	('C00003','1.1.1.275'),
	('C00003','1.1.1.28'),
	('C00003','1.1.1.281'),
	('C00003','1.1.1.250'),
	('C00003','1.1.1.251'),
	('C00003','1.1.1.254'),
	('C00003','1.1.1.255'),
	('C00003','1.1.1.256'),
	('C00003','1.1.1.257'),
	('C00003','1.1.1.258'),
	('C00003','1.1.1.259'),
	('C00003','1.1.1.26'),
	('C00003','1.1.1.260'),
	('C00003','1.1.1.261'),
	('C00003','1.1.1.262'),
	('C00003','1.1.1.264'),
	('C00003','1.1.1.265'),
	('C00003','1.1.1.23'),
	('C00003','1.1.1.232'),
	('C00003','1.1.1.233'),
	('C00003','1.1.1.237'),
	('C00003','1.1.1.239'),
	('C00003','1.1.1.24'),
	('C00003','1.1.1.240'),
	('C00003','1.1.1.241'),
	('C00003','1.1.1.244'),
	('C00003','1.1.1.245'),
	('C00003','1.1.1.211'),
	('C00003','1.1.1.212'),
	('C00003','1.1.1.213'),
	('C00003','1.1.1.218'),
	('C00003','1.1.1.22'),
	('C00003','1.1.1.221'),
	('C00003','1.1.1.222'),
	('C00003','1.1.1.223'),
	('C00003','1.1.1.226'),
	('C00003','1.1.1.227'),
	('C00003','1.1.1.228'),
	('C00003','1.1.1.196'),
	('C00003','1.1.1.198'),
	('C00003','1.1.1.199'),
	('C00003','1.1.1.202'),
	('C00003','1.1.1.203'),
	('C00003','1.1.1.205'),
	('C00003','1.1.1.209'),
	('C00003','1.1.1.21'),
	('C00003','1.1.1.178'),
	('C00003','1.1.1.18'),
	('C00003','1.1.1.181'),
	('C00003','1.1.1.386'),
	('C00003','1.1.1.387'),
	('C00003','1.1.1.388'),
	('C00003','1.1.1.389'),
	('C00003','1.1.1.39'),
	('C00003','1.1.1.390'),
	('C00003','1.1.1.391'),
	('C00003','1.1.1.363'),
	('C00003','1.1.1.364'),
	('C00003','1.1.1.366'),
	('C00003','1.1.1.368'),
	('C00003','1.1.1.369'),
	('C00003','1.1.1.37'),
	('C00003','1.1.1.370'),
	('C00003','1.1.1.373'),
	('C00003','1.1.1.374'),
	('C00003','1.1.1.375'),
	('C00003','1.1.1.376'),
	('C00003','1.1.1.347'),
	('C00003','1.1.1.35'),
	('C00003','1.1.1.350'),
	('C00003','1.1.1.351'),
	('C00003','1.1.1.352'),
	('C00003','1.1.1.354'),
	('C00003','1.1.1.356'),
	('C00003','1.1.1.357'),
	('C00003','1.1.1.359'),
	('C00003','1.1.1.361'),
	('C00003','1.1.1.329'),
	('C00003','1.1.1.331'),
	('C00003','1.1.1.332'),
	('C00003','1.1.1.333'),
	('C00003','1.1.1.335'),
	('C00003','1.1.1.336'),
	('C00003','1.1.1.337'),
	('C00003','1.1.1.339'),
	('C00003','1.1.1.340'),
	('C00003','1.1.1.343'),
	('C00003','1.1.1.344'),
	('C00003','1.1.1.345'),
	('C00003','1.1.1.315'),
	('C00003','1.1.1.316'),
	('C00003','1.1.1.32'),
	('C00003','1.1.1.322'),
	('C00003','1.1.1.323'),
	('C00003','1.1.1.326'),
	('C00003','1.1.1.327'),
	('C00003','1.1.1.328'),
	('C00003','1.1.1.299'),
	('C00003','1.1.1.3'),
	('C00003','1.1.1.30'),
	('C00003','1.1.1.301'),
	('C00003','1.1.1.302'),
	('C00003','1.1.1.303'),
	('C00003','1.1.1.304'),
	('C00003','1.1.1.305'),
	('C00003','1.1.1.306'),
	('C00003','1.1.1.307'),
	('C00003','1.1.1.308'),
	('C00003','1.1.1.309'),
	('C00003','1.1.1.31'),
	('C00003','1.1.1.310'),
	('C00003','1.1.1.311'),
	('C00003','1.1.1.312'),
	('C00003','1.13.11.29'),
	('C00003','1.11.1.1'),
	('C00003','1.1.1.98'),
	('C00003','1.1.1.99'),
	('C00003','1.1.1.83'),
	('C00003','1.1.1.84'),
	('C00003','1.1.1.85'),
	('C00003','1.1.1.87'),
	('C00003','1.1.1.88'),
	('C00003','1.1.1.9'),
	('C00003','1.1.1.90'),
	('C00003','1.1.1.92'),
	('C00003','1.1.1.93'),
	('C00003','1.1.1.94'),
	('C00003','1.1.1.95'),
	('C00003','1.1.1.96'),
	('C00003','1.1.1.66'),
	('C00003','1.1.1.67'),
	('C00003','1.1.1.69'),
	('C00003','1.1.1.7'),
	('C00003','1.1.1.71'),
	('C00003','1.1.1.72'),
	('C00003','1.1.1.73'),
	('C00003','1.1.1.75'),
	('C00003','1.1.1.76'),
	('C00003','1.1.1.77'),
	('C00003','1.1.1.78'),
	('C00003','1.1.1.79'),
	('C00003','1.1.1.8'),
	('C00003','1.1.1.81'),
	('C00003','1.1.1.47'),
	('C00003','1.1.1.48'),
	('C00003','1.1.1.50'),
	('C00003','1.1.1.51'),
	('C00003','1.1.1.52'),
	('C00003','1.1.1.53'),
	('C00003','1.1.1.56'),
	('C00003','1.1.1.57'),
	('C00003','1.1.1.58'),
	('C00003','1.1.1.59'),
	('C00003','1.1.1.6'),
	('C00003','1.1.1.60'),
	('C00003','1.1.1.61'),
	('C00003','1.1.1.62'),
	('C00003','1.1.1.394'),
	('C00003','1.1.1.396'),
	('C00003','1.1.1.397'),
	('C00003','1.1.1.399'),
	('C00003','1.1.1.4'),
	('C00003','1.1.1.400'),
	('C00003','1.1.1.401'),
	('C00003','1.1.1.403'),
	('C00003','1.1.1.41'),
	('C00003','1.1.1.43'),
	('C00003','1.1.1.45'),
	('C00003','1.1.1.46'),
	('C00003','1.1.1.378'),
	('C00003','1.1.1.379'),
	('C00003','1.1.1.38'),
	('C00003','1.1.1.380'),
	('C00003','1.1.1.382'),
	('C00003','1.1.1.383'),
	('C00003','1.1.1.385'),
	('C00003','1.14.13.24'),
	('C00003','1.14.13.25'),
	('C00003','1.14.13.27'),
	('C00003','1.14.13.209'),
	('C00003','1.14.13.210'),
	('C00003','1.14.13.211'),
	('C00003','1.14.13.212'),
	('C00003','1.14.13.215'),
	('C00003','1.14.13.216'),
	('C00003','1.14.13.217'),
	('C00003','1.14.13.218'),
	('C00003','1.14.13.196'),
	('C00003','1.14.13.182'),
	('C00003','1.14.13.19'),
	('C00003','1.14.13.172'),
	('C00003','1.14.13.178'),
	('C00003','1.14.13.179'),
	('C00003','1.14.13.18'),
	('C00003','1.14.13.162'),
	('C00003','1.14.13.163'),
	('C00003','1.14.13.165'),
	('C00003','1.14.13.151'),
	('C00003','1.14.13.131'),
	('C00003','1.14.13.135'),
	('C00003','1.14.13.141'),
	('C00003','1.14.13.142'),
	('C00003','1.14.13.127'),
	('C00003','1.14.13.128'),
	('C00003','1.14.13.129'),
	('C00003','1.14.13.130'),
	('C00003','1.14.13.111'),
	('C00003','1.14.13.113'),
	('C00003','1.14.13.114'),
	('C00003','1.14.13.1'),
	('C00003','1.14.13.10'),
	('C00003','1.14.13.107'),
	('C00003','1.14.12.18'),
	('C00003','1.14.12.19'),
	('C00003','1.14.12.22'),
	('C00003','1.14.12.23'),
	('C00003','1.14.12.24'),
	('C00003','1.14.12.3'),
	('C00003','1.14.12.4'),
	('C00003','1.14.12.7'),
	('C00003','1.14.12.8'),
	('C00003','1.14.12.9'),
	('C00003','1.14.12.1'),
	('C00003','1.14.12.10'),
	('C00003','1.14.12.11'),
	('C00003','1.14.12.12'),
	('C00003','1.14.12.13'),
	('C00003','1.14.12.14'),
	('C00003','1.14.12.15'),
	('C00003','1.14.12.16'),
	('C00003','1.14.12.17'),
	('C00003','1.13.12.17'),
	('C00003','1.13.11.30'),
	('C00003','1.12.1.2'),
	('C00003','1.12.1.4'),
	('C00003','1.12.1.5'),
	('C00003','1.2.1.46'),
	('C00003','1.2.1.47'),
	('C00003','1.2.1.48'),
	('C00003','1.2.1.5'),
	('C00003','1.2.1.29'),
	('C00003','1.2.1.3'),
	('C00003','1.2.1.31'),
	('C00003','1.2.1.32'),
	('C00003','1.2.1.33'),
	('C00003','1.2.1.36'),
	('C00003','1.2.1.39'),
	('C00003','1.2.1.18'),
	('C00003','1.2.1.19'),
	('C00003','1.2.1.2'),
	('C00003','1.2.1.20'),
	('C00003','1.2.1.21'),
	('C00003','1.2.1.22'),
	('C00003','1.2.1.23'),
	('C00003','1.2.1.24'),
	('C00003','1.2.1.25'),
	('C00003','1.2.1.27'),
	('C00003','1.2.1.28'),
	('C00003','1.18.1.5'),
	('C00003','1.2.1.10'),
	('C00003','1.2.1.12'),
	('C00003','1.2.1.15'),
	('C00003','1.2.1.16'),
	('C00003','1.17.1.8'),
	('C00003','1.18.1.1'),
	('C00003','1.18.1.3'),
	('C00003','1.18.1.4'),
	('C00003','1.16.1.2'),
	('C00003','1.16.1.3'),
	('C00003','1.16.1.4'),
	('C00003','1.16.1.7'),
	('C00003','1.17.1.1'),
	('C00003','1.17.1.4'),
	('C00003','1.14.99.2'),
	('C00003','1.14.19.21'),
	('C00003','1.14.18.1'),
	('C00003','1.14.15.3'),
	('C00003','1.14.14.9'),
	('C00003','1.14.13.90'),
	('C00003','1.14.14.1'),
	('C00003','1.14.13.82'),
	('C00003','1.14.13.83'),
	('C00003','1.14.13.64'),
	('C00003','1.14.13.69'),
	('C00003','1.14.13.72'),
	('C00003','1.14.13.6'),
	('C00003','1.14.13.61'),
	('C00003','1.14.13.62'),
	('C00003','1.14.13.63'),
	('C00003','1.14.13.4'),
	('C00003','1.14.13.40'),
	('C00003','1.14.13.44'),
	('C00003','1.14.13.5'),
	('C00003','1.14.13.29'),
	('C00003','1.14.13.33'),
	('C00003','1.14.13.220'),
	('C00003','1.14.13.222'),
	('C00003','1.14.13.224'),
	('C00003','1.14.13.227'),
	('C00003','1.3.1.53'),
	('C00003','1.3.1.56'),
	('C00003','1.3.1.58'),
	('C00003','1.3.1.6'),
	('C00003','1.3.1.60'),
	('C00003','1.3.1.62'),
	('C00003','1.3.1.64'),
	('C00003','1.3.1.65'),
	('C00003','1.3.1.66'),
	('C00003','1.3.1.24'),
	('C00003','1.3.1.25'),
	('C00003','1.3.1.28'),
	('C00003','1.3.1.29'),
	('C00003','1.3.1.31'),
	('C00003','1.3.1.32'),
	('C00003','1.3.1.41'),
	('C00003','1.3.1.43'),
	('C00003','1.3.1.44'),
	('C00003','1.3.1.105'),
	('C00003','1.3.1.106'),
	('C00003','1.3.1.107'),
	('C00003','1.3.1.11'),
	('C00003','1.3.1.12'),
	('C00003','1.3.1.14'),
	('C00003','1.3.1.18'),
	('C00003','1.3.1.19'),
	('C00003','1.3.1.21'),
	('C00003','1.3.1.1'),
	('C00003','1.3.1.101'),
	('C00003','1.20.1.1'),
	('C00003','1.2.4.2'),
	('C00003','1.2.3.9'),
	('C00003','1.2.4.1'),
	('C00003','1.2.1.85'),
	('C00003','1.2.1.86'),
	('C00003','1.2.1.87'),
	('C00003','1.2.1.88'),
	('C00003','1.2.1.90'),
	('C00003','1.2.1.92'),
	('C00003','1.2.1.98'),
	('C00003','1.2.1.71'),
	('C00003','1.2.1.72'),
	('C00003','1.2.1.73'),
	('C00003','1.2.1.74'),
	('C00003','1.2.1.78'),
	('C00003','1.2.1.8'),
	('C00003','1.2.1.80'),
	('C00003','1.2.1.82'),
	('C00003','1.2.1.53'),
	('C00003','1.2.1.54'),
	('C00003','1.2.1.57'),
	('C00003','1.2.1.58'),
	('C00003','1.2.1.59'),
	('C00003','1.2.1.60'),
	('C00003','1.2.1.61'),
	('C00003','1.2.1.62'),
	('C00003','1.2.1.64'),
	('C00003','1.2.1.65'),
	('C00003','1.2.1.67'),
	('C00003','1.2.1.68'),
	('C00003','1.2.1.69'),
	('C00003','1.2.1.42'),
	('C00003','1.6.5.11'),
	('C00003','1.6.1.1'),
	('C00003','1.5.1.7'),
	('C00003','1.5.1.9'),
	('C00003','1.5.1.36'),
	('C00003','1.5.1.37'),
	('C00003','1.5.1.39'),
	('C00003','1.5.1.41'),
	('C00003','1.5.1.42'),
	('C00003','1.5.1.44'),
	('C00003','1.5.1.45'),
	('C00003','1.5.1.47'),
	('C00003','1.5.1.49'),
	('C00003','1.5.1.22'),
	('C00003','1.5.1.23'),
	('C00003','1.5.1.25'),
	('C00003','1.5.1.26'),
	('C00003','1.5.1.28'),
	('C00003','1.5.1.3'),
	('C00003','1.5.1.34'),
	('C00003','1.5.1.1'),
	('C00003','1.5.1.11'),
	('C00003','1.5.1.15'),
	('C00003','1.5.1.17'),
	('C00003','1.5.1.18'),
	('C00003','1.5.1.2'),
	('C00003','1.5.1.20'),
	('C00003','1.4.4.2'),
	('C00003','1.4.1.3'),
	('C00003','1.4.1.4'),
	('C00003','1.4.1.5'),
	('C00003','1.4.1.7'),
	('C00003','1.4.1.8'),
	('C00003','1.4.1.9'),
	('C00003','1.4.1.18'),
	('C00003','1.4.1.19'),
	('C00003','1.4.1.2'),
	('C00003','1.4.1.20'),
	('C00003','1.4.1.21'),
	('C00003','1.4.1.23'),
	('C00003','1.4.1.24'),
	('C00003','1.4.1.1'),
	('C00003','1.4.1.10'),
	('C00003','1.4.1.11'),
	('C00003','1.4.1.12'),
	('C00003','1.4.1.14'),
	('C00003','1.4.1.15'),
	('C00003','1.3.1.87'),
	('C00003','1.3.1.9'),
	('C00003','1.3.1.95'),
	('C00003','1.3.1.98'),
	('C00003','1.3.1.67'),
	('C00003','1.3.1.68'),
	('C00003','1.3.1.7'),
	('C00003','1.3.1.74'),
	('C00003','1.3.1.76'),
	('C00003','1.3.1.77'),
	('C00003','1.3.1.79'),
	('C00003','1.3.1.47'),
	('C00003','1.3.1.48'),
	('C00003','1.3.1.49'),
	('C00003','1.3.1.5'),
	('C00003','6.5.1.2'),
	('C00003','6.5.1.6'),
	('C00003','6.3.5.1'),
	('C00003','6.3.1.5'),
	('C00003','5.3.3.1'),
	('C00003','4.3.1.22'),
	('C00003','3.6.1.9'),
	('C00003','3.6.1.22'),
	('C00003','3.2.2.5'),
	('C00003','3.2.2.6'),
	('C00003','2.7.7.1'),
	('C00003','2.7.7.18'),
	('C00003','2.7.1.23'),
	('C00003','2.5.1.46'),
	('C00003','2.4.2.30'),
	('C00003','2.4.2.31'),
	('C00003','2.4.2.36'),
	('C00003','2.4.2.37'),
	('C00003','2.3.1.61'),
	('C00003','2.3.1.190'),
	('C00003','2.3.1.12'),
	('C00003','2.1.2.10'),
	('C00003','1.8.1.7'),
	('C00003','1.8.1.8'),
	('C00003','1.8.1.11'),
	('C00003','1.8.1.15'),
	('C00003','1.8.1.16'),
	('C00003','1.8.1.17'),
	('C00003','1.8.1.18'),
	('C00003','1.8.1.3'),
	('C00003','1.8.1.4'),
	('C00003','1.8.1.6'),
	('C00003','1.7.99.1'),
	('C00003','1.7.1.12'),
	('C00003','1.7.1.14'),
	('C00003','1.7.1.15'),
	('C00003','1.7.1.2'),
	('C00003','1.7.1.4'),
	('C00003','1.7.1.5'),
	('C00003','1.7.1.9'),
	('C00003','1.6.5.2'),
	('C00003','1.6.5.3'),
	('C00003','1.6.5.4'),
	('C00003','1.6.5.7'),
	('C00003','1.6.5.8'),
	('C00003','1.6.5.9'),
	('C00003','1.6.6.9'),
	('C00003','1.6.99.3'),
	('C00003','1.7.1.1'),
	('C00003','1.7.1.10'),
	('C00003','1.6.1.2'),
	('C00003','1.6.1.3'),
	('C00003','1.6.2.2'),
	('C00003','1.6.2.6'),
	('C00003','1.6.3.1'),
	('C00003','1.6.3.2'),
	('C00003','1.6.3.3'),
	('C00003','1.6.3.4'),
	('C00003','1.6.3.5'),
	('C00004','1.1.1.172'),
	('C00004','1.1.1.173'),
	('C00004','1.1.1.174'),
	('C00004','1.1.1.175'),
	('C00004','1.1.1.141'),
	('C00004','1.1.1.143'),
	('C00004','1.1.1.144'),
	('C00004','1.1.1.145'),
	('C00004','1.1.1.147'),
	('C00004','1.1.1.148'),
	('C00004','1.1.1.149'),
	('C00004','1.1.1.15'),
	('C00004','1.1.1.150'),
	('C00004','1.1.1.152'),
	('C00004','1.1.1.154'),
	('C00004','1.1.1.157'),
	('C00004','1.1.1.125'),
	('C00004','1.1.1.127'),
	('C00004','1.1.1.129'),
	('C00004','1.1.1.13'),
	('C00004','1.1.1.130'),
	('C00004','1.1.1.131'),
	('C00004','1.1.1.132'),
	('C00004','1.1.1.135'),
	('C00004','1.1.1.136'),
	('C00004','1.1.1.137'),
	('C00004','1.1.1.14'),
	('C00004','1.1.1.140'),
	('C00004','1.1.1.108'),
	('C00004','1.1.1.11'),
	('C00004','1.1.1.110'),
	('C00004','1.1.1.111'),
	('C00004','1.1.1.112'),
	('C00004','1.1.1.114'),
	('C00004','1.1.1.116'),
	('C00004','1.1.1.117'),
	('C00004','1.1.1.118'),
	('C00004','1.1.1.12'),
	('C00004','1.1.1.121'),
	('C00004','1.1.1.122'),
	('C00004','1.1.1.1'),
	('C00004','1.1.1.103'),
	('C00004','1.1.1.104'),
	('C00004','1.1.1.105'),
	('C00004','1.1.1.106'),
	('C00004','1.1.1.107'),
	('C00004','1.1.1.27'),
	('C00004','1.1.1.275'),
	('C00004','1.1.1.28'),
	('C00004','1.1.1.281'),
	('C00004','1.1.1.250'),
	('C00004','1.1.1.251'),
	('C00004','1.1.1.254'),
	('C00004','1.1.1.255'),
	('C00004','1.1.1.256'),
	('C00004','1.1.1.257'),
	('C00004','1.1.1.258'),
	('C00004','1.1.1.259'),
	('C00004','1.1.1.26'),
	('C00004','1.1.1.260'),
	('C00004','1.1.1.261'),
	('C00004','1.1.1.262'),
	('C00004','1.1.1.264'),
	('C00004','1.1.1.265'),
	('C00004','1.1.1.23'),
	('C00004','1.1.1.232'),
	('C00004','1.1.1.233'),
	('C00004','1.1.1.237'),
	('C00004','1.1.1.239'),
	('C00004','1.1.1.24'),
	('C00004','1.1.1.240'),
	('C00004','1.1.1.241'),
	('C00004','1.1.1.244'),
	('C00004','1.1.1.245'),
	('C00004','1.1.1.211'),
	('C00004','1.1.1.212'),
	('C00004','1.1.1.213'),
	('C00004','1.1.1.218'),
	('C00004','1.1.1.22'),
	('C00004','1.1.1.221'),
	('C00004','1.1.1.222'),
	('C00004','1.1.1.223'),
	('C00004','1.1.1.226'),
	('C00004','1.1.1.227'),
	('C00004','1.1.1.228'),
	('C00004','1.1.1.196'),
	('C00004','1.1.1.198'),
	('C00004','1.1.1.199'),
	('C00004','1.1.1.202'),
	('C00004','1.1.1.203'),
	('C00004','1.1.1.205'),
	('C00004','1.1.1.209'),
	('C00004','1.1.1.21'),
	('C00004','1.1.1.178'),
	('C00004','1.1.1.18'),
	('C00004','1.1.1.181'),
	('C00004','1.1.1.185'),
	('C00004','1.1.1.186'),
	('C00004','1.1.1.187'),
	('C00004','1.1.1.190'),
	('C00004','1.1.1.192'),
	('C00004','1.1.1.159'),
	('C00004','1.1.1.16'),
	('C00004','1.1.1.163'),
	('C00004','1.1.1.164'),
	('C00004','1.1.1.165'),
	('C00004','1.1.1.166'),
	('C00004','1.1.1.167'),
	('C00004','1.1.1.17'),
	('C00004','1.1.1.170'),
	('C00004','1.1.1.373'),
	('C00004','1.1.1.374'),
	('C00004','1.1.1.375'),
	('C00004','1.1.1.376'),
	('C00004','1.1.1.347'),
	('C00004','1.1.1.35'),
	('C00004','1.1.1.350'),
	('C00004','1.1.1.351'),
	('C00004','1.1.1.352'),
	('C00004','1.1.1.354'),
	('C00004','1.1.1.356'),
	('C00004','1.1.1.357'),
	('C00004','1.1.1.359'),
	('C00004','1.1.1.361'),
	('C00004','1.1.1.329'),
	('C00004','1.1.1.331'),
	('C00004','1.1.1.332'),
	('C00004','1.1.1.333'),
	('C00004','1.1.1.335'),
	('C00004','1.1.1.336'),
	('C00004','1.1.1.337'),
	('C00004','1.1.1.339'),
	('C00004','1.1.1.340'),
	('C00004','1.1.1.343'),
	('C00004','1.1.1.344'),
	('C00004','1.1.1.345'),
	('C00004','1.1.1.315'),
	('C00004','1.1.1.316'),
	('C00004','1.1.1.32'),
	('C00004','1.1.1.322'),
	('C00004','1.1.1.323'),
	('C00004','1.1.1.326'),
	('C00004','1.1.1.327'),
	('C00004','1.1.1.328'),
	('C00004','1.1.1.299'),
	('C00004','1.1.1.3'),
	('C00004','1.1.1.30'),
	('C00004','1.1.1.301'),
	('C00004','1.1.1.302'),
	('C00004','1.1.1.303'),
	('C00004','1.1.1.304'),
	('C00004','1.1.1.305'),
	('C00004','1.1.1.306'),
	('C00004','1.1.1.307'),
	('C00004','1.1.1.308'),
	('C00004','1.1.1.309'),
	('C00004','1.1.1.31'),
	('C00004','1.1.1.310'),
	('C00004','1.1.1.311'),
	('C00004','1.1.1.312'),
	('C00004','1.1.1.282'),
	('C00004','1.1.1.284'),
	('C00004','1.1.1.285'),
	('C00004','1.1.1.286'),
	('C00004','1.1.1.288'),
	('C00004','1.1.1.29'),
	('C00004','1.1.1.290'),
	('C00004','1.1.1.291'),
	('C00004','1.1.1.294'),
	('C00004','1.1.1.295'),
	('C00004','1.1.1.296'),
	('C00004','1.1.1.297'),
	('C00004','1.1.1.268'),
	('C00004','1.1.1.269'),
	('C00004','1.1.1.93'),
	('C00004','1.1.1.94'),
	('C00004','1.1.1.95'),
	('C00004','1.1.1.96'),
	('C00004','1.1.1.66'),
	('C00004','1.1.1.67'),
	('C00004','1.1.1.69'),
	('C00004','1.1.1.7'),
	('C00004','1.1.1.71'),
	('C00004','1.1.1.72'),
	('C00004','1.1.1.73'),
	('C00004','1.1.1.75'),
	('C00004','1.1.1.76'),
	('C00004','1.1.1.77'),
	('C00004','1.1.1.78'),
	('C00004','1.1.1.79'),
	('C00004','1.1.1.8'),
	('C00004','1.1.1.47'),
	('C00004','1.1.1.48'),
	('C00004','1.1.1.50'),
	('C00004','1.1.1.51'),
	('C00004','1.1.1.52'),
	('C00004','1.1.1.53'),
	('C00004','1.1.1.56'),
	('C00004','1.1.1.57'),
	('C00004','1.1.1.58'),
	('C00004','1.1.1.59'),
	('C00004','1.1.1.6'),
	('C00004','1.1.1.60'),
	('C00004','1.1.1.61'),
	('C00004','1.1.1.62'),
	('C00004','1.1.1.394'),
	('C00004','1.1.1.396'),
	('C00004','1.1.1.397'),
	('C00004','1.1.1.399'),
	('C00004','1.1.1.4'),
	('C00004','1.1.1.400'),
	('C00004','1.1.1.401'),
	('C00004','1.1.1.403'),
	('C00004','1.1.1.41'),
	('C00004','1.1.1.43'),
	('C00004','1.1.1.45'),
	('C00004','1.1.1.46'),
	('C00004','1.1.1.378'),
	('C00004','1.1.1.379'),
	('C00004','1.1.1.38'),
	('C00004','1.1.1.380'),
	('C00004','1.1.1.382'),
	('C00004','1.1.1.383'),
	('C00004','1.1.1.385'),
	('C00004','1.1.1.386'),
	('C00004','1.1.1.387'),
	('C00004','1.1.1.388'),
	('C00004','1.1.1.389'),
	('C00004','1.1.1.39'),
	('C00004','1.1.1.390'),
	('C00004','1.1.1.391'),
	('C00004','1.1.1.363'),
	('C00004','1.1.1.364'),
	('C00004','1.1.1.366'),
	('C00004','1.1.1.368'),
	('C00004','1.1.1.369'),
	('C00004','1.1.1.37'),
	('C00004','1.1.1.370'),
	('C00004','1.14.13.172'),
	('C00004','1.14.13.178'),
	('C00004','1.14.13.179'),
	('C00004','1.14.13.18'),
	('C00004','1.14.13.162'),
	('C00004','1.14.13.163'),
	('C00004','1.14.13.165'),
	('C00004','1.14.13.151'),
	('C00004','1.14.13.131'),
	('C00004','1.14.13.135'),
	('C00004','1.14.13.141'),
	('C00004','1.14.13.142'),
	('C00004','1.14.13.127'),
	('C00004','1.14.13.128'),
	('C00004','1.14.13.129'),
	('C00004','1.14.13.130'),
	('C00004','1.14.13.111'),
	('C00004','1.14.13.113'),
	('C00004','1.14.13.114'),
	('C00004','1.14.13.1'),
	('C00004','1.14.13.10'),
	('C00004','1.14.13.107'),
	('C00004','1.14.12.18'),
	('C00004','1.14.12.19'),
	('C00004','1.14.12.22'),
	('C00004','1.14.12.23'),
	('C00004','1.14.12.24'),
	('C00004','1.14.12.3'),
	('C00004','1.14.12.4'),
	('C00004','1.14.12.7'),
	('C00004','1.14.12.8'),
	('C00004','1.14.12.9'),
	('C00004','1.14.12.1'),
	('C00004','1.14.12.10'),
	('C00004','1.14.12.11'),
	('C00004','1.14.12.12'),
	('C00004','1.14.12.13'),
	('C00004','1.14.12.14'),
	('C00004','1.14.12.15'),
	('C00004','1.14.12.16'),
	('C00004','1.14.12.17'),
	('C00004','1.13.12.17'),
	('C00004','1.13.11.30'),
	('C00004','1.12.1.2'),
	('C00004','1.12.1.4'),
	('C00004','1.12.1.5'),
	('C00004','1.13.11.29'),
	('C00004','1.11.1.1'),
	('C00004','1.1.1.98'),
	('C00004','1.1.1.99'),
	('C00004','1.1.1.81'),
	('C00004','1.1.1.83'),
	('C00004','1.1.1.84'),
	('C00004','1.1.1.85'),
	('C00004','1.1.1.87'),
	('C00004','1.1.1.88'),
	('C00004','1.1.1.9'),
	('C00004','1.1.1.90'),
	('C00004','1.1.1.92'),
	('C00004','1.2.1.20'),
	('C00004','1.2.1.21'),
	('C00004','1.2.1.22'),
	('C00004','1.2.1.23'),
	('C00004','1.2.1.24'),
	('C00004','1.2.1.25'),
	('C00004','1.2.1.27'),
	('C00004','1.2.1.28'),
	('C00004','1.18.1.5'),
	('C00004','1.2.1.10'),
	('C00004','1.2.1.12'),
	('C00004','1.2.1.15'),
	('C00004','1.2.1.16'),
	('C00004','1.17.1.8'),
	('C00004','1.18.1.1'),
	('C00004','1.18.1.3'),
	('C00004','1.18.1.4'),
	('C00004','1.16.1.2'),
	('C00004','1.16.1.3'),
	('C00004','1.16.1.4'),
	('C00004','1.16.1.7'),
	('C00004','1.17.1.1'),
	('C00004','1.17.1.4'),
	('C00004','1.14.99.2'),
	('C00004','1.14.19.21'),
	('C00004','1.14.18.1'),
	('C00004','1.14.15.3'),
	('C00004','1.14.14.9'),
	('C00004','1.14.13.90'),
	('C00004','1.14.14.1'),
	('C00004','1.14.13.82'),
	('C00004','1.14.13.83'),
	('C00004','1.14.13.64'),
	('C00004','1.14.13.69'),
	('C00004','1.14.13.72'),
	('C00004','1.14.13.6'),
	('C00004','1.14.13.61'),
	('C00004','1.14.13.62'),
	('C00004','1.14.13.63'),
	('C00004','1.14.13.4'),
	('C00004','1.14.13.40'),
	('C00004','1.14.13.44'),
	('C00004','1.14.13.5'),
	('C00004','1.14.13.29'),
	('C00004','1.14.13.33'),
	('C00004','1.14.13.220'),
	('C00004','1.14.13.222'),
	('C00004','1.14.13.224'),
	('C00004','1.14.13.227'),
	('C00004','1.14.13.24'),
	('C00004','1.14.13.25'),
	('C00004','1.14.13.27'),
	('C00004','1.14.13.209'),
	('C00004','1.14.13.210'),
	('C00004','1.14.13.211'),
	('C00004','1.14.13.212'),
	('C00004','1.14.13.215'),
	('C00004','1.14.13.216'),
	('C00004','1.14.13.217'),
	('C00004','1.14.13.218'),
	('C00004','1.14.13.196'),
	('C00004','1.14.13.182'),
	('C00004','1.14.13.19'),
	('C00004','1.3.1.31'),
	('C00004','1.3.1.32'),
	('C00004','1.3.1.41'),
	('C00004','1.3.1.43'),
	('C00004','1.3.1.105'),
	('C00004','1.3.1.106'),
	('C00004','1.3.1.107'),
	('C00004','1.3.1.11'),
	('C00004','1.3.1.12'),
	('C00004','1.3.1.14'),
	('C00004','1.3.1.18'),
	('C00004','1.3.1.19'),
	('C00004','1.3.1.21'),
	('C00004','1.3.1.1'),
	('C00004','1.3.1.101'),
	('C00004','1.20.1.1'),
	('C00004','1.2.4.2'),
	('C00004','1.2.3.9'),
	('C00004','1.2.4.1'),
	('C00004','1.2.1.85'),
	('C00004','1.2.1.86'),
	('C00004','1.2.1.87'),
	('C00004','1.2.1.88'),
	('C00004','1.2.1.90'),
	('C00004','1.2.1.92'),
	('C00004','1.2.1.98'),
	('C00004','1.2.1.71'),
	('C00004','1.2.1.72'),
	('C00004','1.2.1.73'),
	('C00004','1.2.1.74'),
	('C00004','1.2.1.78'),
	('C00004','1.2.1.8'),
	('C00004','1.2.1.80'),
	('C00004','1.2.1.82'),
	('C00004','1.2.1.53'),
	('C00004','1.2.1.54'),
	('C00004','1.2.1.57'),
	('C00004','1.2.1.58'),
	('C00004','1.2.1.59'),
	('C00004','1.2.1.60'),
	('C00004','1.2.1.61'),
	('C00004','1.2.1.62'),
	('C00004','1.2.1.64'),
	('C00004','1.2.1.65'),
	('C00004','1.2.1.67'),
	('C00004','1.2.1.68'),
	('C00004','1.2.1.69'),
	('C00004','1.2.1.42'),
	('C00004','1.2.1.46'),
	('C00004','1.2.1.47'),
	('C00004','1.2.1.48'),
	('C00004','1.2.1.5'),
	('C00004','1.2.1.29'),
	('C00004','1.2.1.3'),
	('C00004','1.2.1.31'),
	('C00004','1.2.1.32'),
	('C00004','1.2.1.33'),
	('C00004','1.2.1.36'),
	('C00004','1.2.1.39'),
	('C00004','1.2.1.18'),
	('C00004','1.2.1.19'),
	('C00004','1.2.1.2'),
	('C00004','1.5.1.22'),
	('C00004','1.5.1.23'),
	('C00004','1.5.1.25'),
	('C00004','1.5.1.26'),
	('C00004','1.5.1.28'),
	('C00004','1.5.1.3'),
	('C00004','1.5.1.34'),
	('C00004','1.5.1.1'),
	('C00004','1.5.1.11'),
	('C00004','1.5.1.15'),
	('C00004','1.5.1.17'),
	('C00004','1.5.1.18'),
	('C00004','1.5.1.2'),
	('C00004','1.4.4.2'),
	('C00004','1.4.1.3'),
	('C00004','1.4.1.4'),
	('C00004','1.4.1.5'),
	('C00004','1.4.1.7'),
	('C00004','1.4.1.8'),
	('C00004','1.4.1.9'),
	('C00004','1.4.1.18'),
	('C00004','1.4.1.19'),
	('C00004','1.4.1.2'),
	('C00004','1.4.1.20'),
	('C00004','1.4.1.21'),
	('C00004','1.4.1.23'),
	('C00004','1.4.1.24'),
	('C00004','1.4.1.1'),
	('C00004','1.4.1.10'),
	('C00004','1.4.1.11'),
	('C00004','1.4.1.12'),
	('C00004','1.4.1.14'),
	('C00004','1.4.1.15'),
	('C00004','1.3.1.87'),
	('C00004','1.3.1.9'),
	('C00004','1.3.1.95'),
	('C00004','1.3.1.98'),
	('C00004','1.3.1.67'),
	('C00004','1.3.1.68'),
	('C00004','1.3.1.7'),
	('C00004','1.3.1.74'),
	('C00004','1.3.1.76'),
	('C00004','1.3.1.77'),
	('C00004','1.3.1.79'),
	('C00004','1.3.1.44'),
	('C00004','1.3.1.47'),
	('C00004','1.3.1.48'),
	('C00004','1.3.1.49'),
	('C00004','1.3.1.5'),
	('C00004','1.3.1.53'),
	('C00004','1.3.1.56'),
	('C00004','1.3.1.58'),
	('C00004','1.3.1.6'),
	('C00004','1.3.1.60'),
	('C00004','1.3.1.62'),
	('C00004','1.3.1.64'),
	('C00004','1.3.1.65'),
	('C00004','1.3.1.66'),
	('C00004','1.3.1.24'),
	('C00004','1.3.1.25'),
	('C00004','1.3.1.28'),
	('C00004','1.3.1.29'),
	('C00004','5.3.3.1'),
	('C00004','4.3.1.22'),
	('C00004','4.2.1.93'),
	('C00004','4.2.1.136'),
	('C00004','3.6.1.22'),
	('C00004','2.7.1.86'),
	('C00004','2.5.1.46'),
	('C00004','2.3.1.61'),
	('C00004','2.3.1.190'),
	('C00004','2.3.1.12'),
	('C00004','2.1.2.10'),
	('C00004','1.8.1.7'),
	('C00004','1.8.1.8'),
	('C00004','1.8.1.11'),
	('C00004','1.8.1.15'),
	('C00004','1.8.1.16'),
	('C00004','1.8.1.17'),
	('C00004','1.8.1.18'),
	('C00004','1.8.1.3'),
	('C00004','1.8.1.4'),
	('C00004','1.8.1.6'),
	('C00004','1.7.99.1'),
	('C00004','1.7.1.12'),
	('C00004','1.7.1.14'),
	('C00004','1.7.1.15'),
	('C00004','1.7.1.2'),
	('C00004','1.7.1.4'),
	('C00004','1.7.1.5'),
	('C00004','1.7.1.9'),
	('C00004','1.6.5.2'),
	('C00004','1.6.5.3'),
	('C00004','1.6.5.4'),
	('C00004','1.6.5.7'),
	('C00004','1.6.5.8'),
	('C00004','1.6.5.9'),
	('C00004','1.6.6.9'),
	('C00004','1.6.99.3'),
	('C00004','1.7.1.1'),
	('C00004','1.7.1.10'),
	('C00004','1.6.1.2'),
	('C00004','1.6.1.3'),
	('C00004','1.6.2.2'),
	('C00004','1.6.2.6'),
	('C00004','1.6.3.1'),
	('C00004','1.6.3.2'),
	('C00004','1.6.3.3'),
	('C00004','1.6.3.4'),
	('C00004','1.6.5.11'),
	('C00004','1.6.1.1'),
	('C00004','1.5.1.7'),
	('C00004','1.5.1.9'),
	('C00004','1.5.1.36'),
	('C00004','1.5.1.37'),
	('C00004','1.5.1.39'),
	('C00004','1.5.1.41'),
	('C00004','1.5.1.42'),
	('C00004','1.5.1.44'),
	('C00004','1.5.1.45'),
	('C00004','1.5.1.47'),
	('C00004','1.5.1.49'),
	('C00004','1.5.1.20'),
	('C00005','1.1.1.1'),
	('C00005','1.1.1.10'),
	('C00005','1.1.1.100'),
	('C00005','1.1.1.101'),
	('C00005','1.1.1.102'),
	('C00005','1.1.1.104'),
	('C00005','1.1.1.222'),
	('C00005','1.1.1.224'),
	('C00005','1.1.1.225'),
	('C00005','1.1.1.196'),
	('C00005','1.1.1.197'),
	('C00005','1.1.1.2'),
	('C00005','1.1.1.20'),
	('C00005','1.1.1.200'),
	('C00005','1.1.1.201'),
	('C00005','1.1.1.206'),
	('C00005','1.1.1.207'),
	('C00005','1.1.1.208'),
	('C00005','1.1.1.209'),
	('C00005','1.1.1.21'),
	('C00005','1.1.1.210'),
	('C00005','1.1.1.179'),
	('C00005','1.1.1.181'),
	('C00005','1.1.1.183'),
	('C00005','1.1.1.184'),
	('C00005','1.1.1.185'),
	('C00005','1.1.1.186'),
	('C00005','1.1.1.187'),
	('C00005','1.1.1.188'),
	('C00005','1.1.1.189'),
	('C00005','1.1.1.19'),
	('C00005','1.1.1.191'),
	('C00005','1.1.1.193'),
	('C00005','1.1.1.194'),
	('C00005','1.1.1.195'),
	('C00005','1.1.1.160'),
	('C00005','1.1.1.162'),
	('C00005','1.1.1.168'),
	('C00005','1.1.1.169'),
	('C00005','1.1.1.170'),
	('C00005','1.1.1.176'),
	('C00005','1.1.1.177'),
	('C00005','1.1.1.142'),
	('C00005','1.1.1.145'),
	('C00005','1.1.1.146'),
	('C00005','1.1.1.147'),
	('C00005','1.1.1.148'),
	('C00005','1.1.1.149'),
	('C00005','1.1.1.151'),
	('C00005','1.1.1.153'),
	('C00005','1.1.1.154'),
	('C00005','1.1.1.156'),
	('C00005','1.1.1.157'),
	('C00005','1.1.1.126'),
	('C00005','1.1.1.130'),
	('C00005','1.1.1.131'),
	('C00005','1.1.1.133'),
	('C00005','1.1.1.134'),
	('C00005','1.1.1.135'),
	('C00005','1.1.1.137'),
	('C00005','1.1.1.138'),
	('C00005','1.1.1.111'),
	('C00005','1.1.1.112'),
	('C00005','1.1.1.113'),
	('C00005','1.1.1.115'),
	('C00005','1.1.1.117'),
	('C00005','1.1.1.119'),
	('C00005','1.1.1.120'),
	('C00005','1.1.1.123'),
	('C00005','1.1.1.124'),
	('C00005','1.1.1.318'),
	('C00005','1.1.1.319'),
	('C00005','1.1.1.320'),
	('C00005','1.1.1.321'),
	('C00005','1.1.1.322'),
	('C00005','1.1.1.323'),
	('C00005','1.1.1.324'),
	('C00005','1.1.1.325'),
	('C00005','1.1.1.328'),
	('C00005','1.1.1.299'),
	('C00005','1.1.1.3'),
	('C00005','1.1.1.300'),
	('C00005','1.1.1.302'),
	('C00005','1.1.1.307'),
	('C00005','1.1.1.282'),
	('C00005','1.1.1.283'),
	('C00005','1.1.1.284'),
	('C00005','1.1.1.285'),
	('C00005','1.1.1.287'),
	('C00005','1.1.1.289'),
	('C00005','1.1.1.292'),
	('C00005','1.1.1.294'),
	('C00005','1.1.1.295'),
	('C00005','1.1.1.298'),
	('C00005','1.1.1.266'),
	('C00005','1.1.1.267'),
	('C00005','1.1.1.270'),
	('C00005','1.1.1.271'),
	('C00005','1.1.1.272'),
	('C00005','1.1.1.273'),
	('C00005','1.1.1.274'),
	('C00005','1.1.1.276'),
	('C00005','1.1.1.277'),
	('C00005','1.1.1.278'),
	('C00005','1.1.1.279'),
	('C00005','1.1.1.280'),
	('C00005','1.1.1.281'),
	('C00005','1.1.1.248'),
	('C00005','1.1.1.25'),
	('C00005','1.1.1.252'),
	('C00005','1.1.1.256'),
	('C00005','1.1.1.261'),
	('C00005','1.1.1.263'),
	('C00005','1.1.1.264'),
	('C00005','1.1.1.265'),
	('C00005','1.1.1.229'),
	('C00005','1.1.1.230'),
	('C00005','1.1.1.231'),
	('C00005','1.1.1.232'),
	('C00005','1.1.1.234'),
	('C00005','1.1.1.235'),
	('C00005','1.1.1.236'),
	('C00005','1.1.1.237'),
	('C00005','1.1.1.238'),
	('C00005','1.1.1.243'),
	('C00005','1.1.1.247'),
	('C00005','1.1.1.213'),
	('C00005','1.1.1.214'),
	('C00005','1.1.1.215'),
	('C00005','1.1.1.216'),
	('C00005','1.1.1.217'),
	('C00005','1.1.1.218'),
	('C00005','1.1.1.219'),
	('C00005','1.1.1.220'),
	('C00005','1.1.1.97'),
	('C00005','1.1.1.64'),
	('C00005','1.1.1.65'),
	('C00005','1.1.1.69'),
	('C00005','1.1.1.71'),
	('C00005','1.1.1.72'),
	('C00005','1.1.1.79'),
	('C00005','1.1.1.80'),
	('C00005','1.1.1.47'),
	('C00005','1.1.1.48'),
	('C00005','1.1.1.49'),
	('C00005','1.1.1.50'),
	('C00005','1.1.1.51'),
	('C00005','1.1.1.54'),
	('C00005','1.1.1.55'),
	('C00005','1.1.1.60'),
	('C00005','1.1.1.62'),
	('C00005','1.1.1.393'),
	('C00005','1.1.1.40'),
	('C00005','1.1.1.402'),
	('C00005','1.1.1.42'),
	('C00005','1.1.1.43'),
	('C00005','1.1.1.44'),
	('C00005','1.1.1.378'),
	('C00005','1.1.1.381'),
	('C00005','1.1.1.383'),
	('C00005','1.1.1.384'),
	('C00005','1.1.1.386'),
	('C00005','1.1.1.392'),
	('C00005','1.1.1.362'),
	('C00005','1.1.1.363'),
	('C00005','1.1.1.364'),
	('C00005','1.1.1.365'),
	('C00005','1.1.1.367'),
	('C00005','1.1.1.371'),
	('C00005','1.1.1.372'),
	('C00005','1.1.1.375'),
	('C00005','1.1.1.376'),
	('C00005','1.1.1.377'),
	('C00005','1.1.1.346'),
	('C00005','1.1.1.348'),
	('C00005','1.1.1.349'),
	('C00005','1.1.1.351'),
	('C00005','1.1.1.353'),
	('C00005','1.1.1.355'),
	('C00005','1.1.1.356'),
	('C00005','1.1.1.357'),
	('C00005','1.1.1.358'),
	('C00005','1.1.1.359'),
	('C00005','1.1.1.36'),
	('C00005','1.1.1.360'),
	('C00005','1.1.1.329'),
	('C00005','1.1.1.33'),
	('C00005','1.1.1.330'),
	('C00005','1.1.1.334'),
	('C00005','1.1.1.338'),
	('C00005','1.1.1.34'),
	('C00005','1.1.1.341'),
	('C00005','1.1.1.342'),
	('C00005','1.1.1.344'),
	('C00005','1.1.1.312'),
	('C00005','1.1.1.313'),
	('C00005','1.1.1.314'),
	('C00005','1.1.1.317'),
	('C00005','1.14.13.149'),
	('C00005','1.14.13.150'),
	('C00005','1.14.13.153'),
	('C00005','1.14.13.154'),
	('C00005','1.14.13.156'),
	('C00005','1.14.13.157'),
	('C00005','1.14.13.133'),
	('C00005','1.14.13.134'),
	('C00005','1.14.13.135'),
	('C00005','1.14.13.136'),
	('C00005','1.14.13.137'),
	('C00005','1.14.13.138'),
	('C00005','1.14.13.139'),
	('C00005','1.14.13.14'),
	('C00005','1.14.13.140'),
	('C00005','1.14.13.12'),
	('C00005','1.14.13.120'),
	('C00005','1.14.13.121'),
	('C00005','1.14.13.122'),
	('C00005','1.14.13.123'),
	('C00005','1.14.13.124'),
	('C00005','1.14.13.125'),
	('C00005','1.14.13.128'),
	('C00005','1.14.13.109'),
	('C00005','1.14.13.11'),
	('C00005','1.14.13.110'),
	('C00005','1.14.13.112'),
	('C00005','1.14.13.115'),
	('C00005','1.14.13.116'),
	('C00005','1.14.13.117'),
	('C00005','1.14.13.118'),
	('C00005','1.14.13.119'),
	('C00005','1.14.13.101'),
	('C00005','1.14.13.102'),
	('C00005','1.14.13.103'),
	('C00005','1.14.13.104'),
	('C00005','1.14.13.105'),
	('C00005','1.14.13.106'),
	('C00005','1.14.13.107'),
	('C00005','1.14.13.108'),
	('C00005','1.14.12.17'),
	('C00005','1.14.12.18'),
	('C00005','1.14.12.22'),
	('C00005','1.14.12.4'),
	('C00005','1.14.12.5'),
	('C00005','1.14.12.1'),
	('C00005','1.14.12.10'),
	('C00005','1.13.11.29'),
	('C00005','1.13.11.30'),
	('C00005','1.12.1.3'),
	('C00005','1.12.1.5'),
	('C00005','1.11.1.2'),
	('C00005','1.10.1.1'),
	('C00005','1.1.1.81'),
	('C00005','1.1.1.82'),
	('C00005','1.1.1.86'),
	('C00005','1.1.1.91'),
	('C00005','1.1.1.92'),
	('C00005','1.1.1.94'),
	('C00005','1.14.13.22'),
	('C00005','1.14.13.221'),
	('C00005','1.14.13.222'),
	('C00005','1.14.13.224'),
	('C00005','1.14.13.226'),
	('C00005','1.14.13.23'),
	('C00005','1.14.13.25'),
	('C00005','1.14.13.27'),
	('C00005','1.14.13.21'),
	('C00005','1.14.13.210'),
	('C00005','1.14.13.211'),
	('C00005','1.14.13.213'),
	('C00005','1.14.13.214'),
	('C00005','1.14.13.216'),
	('C00005','1.14.13.217'),
	('C00005','1.14.13.196'),
	('C00005','1.14.13.197'),
	('C00005','1.14.13.198'),
	('C00005','1.14.13.199'),
	('C00005','1.14.13.2'),
	('C00005','1.14.13.20'),
	('C00005','1.14.13.200'),
	('C00005','1.14.13.201'),
	('C00005','1.14.13.202'),
	('C00005','1.14.13.203'),
	('C00005','1.14.13.204'),
	('C00005','1.14.13.206'),
	('C00005','1.14.13.183'),
	('C00005','1.14.13.184'),
	('C00005','1.14.13.185'),
	('C00005','1.14.13.186'),
	('C00005','1.14.13.187'),
	('C00005','1.14.13.188'),
	('C00005','1.14.13.189'),
	('C00005','1.14.13.19'),
	('C00005','1.14.13.190'),
	('C00005','1.14.13.194'),
	('C00005','1.14.13.195'),
	('C00005','1.14.13.172'),
	('C00005','1.14.13.173'),
	('C00005','1.14.13.174'),
	('C00005','1.14.13.175'),
	('C00005','1.14.13.176'),
	('C00005','1.14.13.177'),
	('C00005','1.14.13.178'),
	('C00005','1.14.13.179'),
	('C00005','1.14.13.18'),
	('C00005','1.14.13.180'),
	('C00005','1.14.13.181'),
	('C00005','1.14.13.158'),
	('C00005','1.14.13.16'),
	('C00005','1.14.13.160'),
	('C00005','1.14.13.161'),
	('C00005','1.14.13.165'),
	('C00005','1.14.13.167'),
	('C00005','1.14.13.168'),
	('C00005','1.14.13.170'),
	('C00005','1.14.13.171'),
	('C00005','1.14.13.143'),
	('C00005','1.14.13.144'),
	('C00005','1.14.13.145'),
	('C00005','1.14.13.146'),
	('C00005','1.14.13.147'),
	('C00005','1.14.13.148'),
	('C00005','1.14.14.17'),
	('C00005','1.14.14.19'),
	('C00005','1.14.14.23'),
	('C00005','1.14.13.87'),
	('C00005','1.14.13.88'),
	('C00005','1.14.13.89'),
	('C00005','1.14.13.9'),
	('C00005','1.14.13.90'),
	('C00005','1.14.13.91'),
	('C00005','1.14.13.92'),
	('C00005','1.14.13.93'),
	('C00005','1.14.13.94'),
	('C00005','1.14.13.96'),
	('C00005','1.14.13.97'),
	('C00005','1.14.13.75'),
	('C00005','1.14.13.76'),
	('C00005','1.14.13.77'),
	('C00005','1.14.13.78'),
	('C00005','1.14.13.79'),
	('C00005','1.14.13.8'),
	('C00005','1.14.13.80'),
	('C00005','1.14.13.81'),
	('C00005','1.14.13.84'),
	('C00005','1.14.13.85'),
	('C00005','1.14.13.64'),
	('C00005','1.14.13.66'),
	('C00005','1.14.13.67'),
	('C00005','1.14.13.68'),
	('C00005','1.14.13.7'),
	('C00005','1.14.13.70'),
	('C00005','1.14.13.71'),
	('C00005','1.14.13.72'),
	('C00005','1.14.13.73'),
	('C00005','1.14.13.74'),
	('C00005','1.14.13.52'),
	('C00005','1.14.13.53'),
	('C00005','1.14.13.54'),
	('C00005','1.14.13.55'),
	('C00005','1.14.13.56'),
	('C00005','1.14.13.57'),
	('C00005','1.14.13.58'),
	('C00005','1.14.13.59'),
	('C00005','1.14.13.63'),
	('C00005','1.14.13.40'),
	('C00005','1.14.13.41'),
	('C00005','1.14.13.43'),
	('C00005','1.14.13.46'),
	('C00005','1.14.13.47'),
	('C00005','1.14.13.48'),
	('C00005','1.14.13.49'),
	('C00005','1.14.13.50'),
	('C00005','1.14.13.51'),
	('C00005','1.14.13.28'),
	('C00005','1.14.13.30'),
	('C00005','1.14.13.31'),
	('C00005','1.14.13.32'),
	('C00005','1.14.13.33'),
	('C00005','1.14.13.34'),
	('C00005','1.14.13.35'),
	('C00005','1.14.13.36'),
	('C00005','1.14.13.37'),
	('C00005','1.14.13.38'),
	('C00005','1.14.13.39'),
	('C00005','1.14.13.219'),
	('C00005','1.2.1.80'),
	('C00005','1.2.1.81'),
	('C00005','1.2.1.57'),
	('C00005','1.2.1.59'),
	('C00005','1.2.1.63'),
	('C00005','1.2.1.68'),
	('C00005','1.2.1.7'),
	('C00005','1.2.1.43'),
	('C00005','1.2.1.44'),
	('C00005','1.2.1.49'),
	('C00005','1.2.1.5'),
	('C00005','1.2.1.50'),
	('C00005','1.2.1.51'),
	('C00005','1.2.1.52'),
	('C00005','1.2.1.28'),
	('C00005','1.2.1.3'),
	('C00005','1.2.1.30'),
	('C00005','1.2.1.31'),
	('C00005','1.2.1.38'),
	('C00005','1.2.1.4'),
	('C00005','1.2.1.41'),
	('C00005','1.2.1.18'),
	('C00005','1.2.1.26'),
	('C00005','1.18.1.6'),
	('C00005','1.2.1.11'),
	('C00005','1.2.1.13'),
	('C00005','1.2.1.15'),
	('C00005','1.2.1.16'),
	('C00005','1.2.1.17'),
	('C00005','1.17.1.8'),
	('C00005','1.18.1.2'),
	('C00005','1.18.1.4'),
	('C00005','1.16.1.1'),
	('C00005','1.16.1.5'),
	('C00005','1.16.1.6'),
	('C00005','1.16.1.8'),
	('C00005','1.16.1.9'),
	('C00005','1.17.1.1'),
	('C00005','1.17.1.3'),
	('C00005','1.17.1.5'),
	('C00005','1.14.99.34'),
	('C00005','1.14.99.2'),
	('C00005','1.14.21.1'),
	('C00005','1.14.21.10'),
	('C00005','1.14.21.11'),
	('C00005','1.14.21.2'),
	('C00005','1.14.21.3'),
	('C00005','1.14.21.4'),
	('C00005','1.14.21.5'),
	('C00005','1.14.21.7'),
	('C00005','1.14.21.8'),
	('C00005','1.14.21.9'),
	('C00005','1.14.19.21'),
	('C00005','1.14.19.41'),
	('C00005','1.14.15.3'),
	('C00005','1.14.14.24'),
	('C00005','1.14.14.25'),
	('C00005','1.14.14.26'),
	('C00005','1.14.14.29'),
	('C00005','1.14.14.1'),
	('C00005','1.14.14.16'),
	('C00005','1.3.1.77'),
	('C00005','1.3.1.78'),
	('C00005','1.3.1.79'),
	('C00005','1.3.1.8'),
	('C00005','1.3.1.81'),
	('C00005','1.3.1.45'),
	('C00005','1.3.1.46'),
	('C00005','1.3.1.47'),
	('C00005','1.3.1.48'),
	('C00005','1.3.1.5'),
	('C00005','1.3.1.51'),
	('C00005','1.3.1.54'),
	('C00005','1.3.1.57'),
	('C00005','1.3.1.24'),
	('C00005','1.3.1.27'),
	('C00005','1.3.1.3'),
	('C00005','1.3.1.32'),
	('C00005','1.3.1.33'),
	('C00005','1.3.1.34'),
	('C00005','1.3.1.36'),
	('C00005','1.3.1.37'),
	('C00005','1.3.1.38'),
	('C00005','1.3.1.39'),
	('C00005','1.3.1.40'),
	('C00005','1.3.1.42'),
	('C00005','1.3.1.104'),
	('C00005','1.3.1.105'),
	('C00005','1.3.1.107'),
	('C00005','1.3.1.111'),
	('C00005','1.3.1.13'),
	('C00005','1.3.1.15'),
	('C00005','1.3.1.16'),
	('C00005','1.3.1.17'),
	('C00005','1.3.1.2'),
	('C00005','1.3.1.20'),
	('C00005','1.3.1.21'),
	('C00005','1.3.1.22'),
	('C00005','1.23.1.1'),
	('C00005','1.23.1.2'),
	('C00005','1.23.1.3'),
	('C00005','1.23.1.4'),
	('C00005','1.3.1.10'),
	('C00005','1.3.1.101'),
	('C00005','1.3.1.102'),
	('C00005','1.3.1.103'),
	('C00005','1.21.1.1'),
	('C00005','1.21.1.2'),
	('C00005','1.2.1.83'),
	('C00005','1.2.1.84'),
	('C00005','1.2.1.88'),
	('C00005','1.2.1.89'),
	('C00005','1.2.1.9'),
	('C00005','1.2.1.90'),
	('C00005','1.2.1.91'),
	('C00005','1.2.1.92'),
	('C00005','1.2.1.96'),
	('C00005','1.2.1.70'),
	('C00005','1.2.1.75'),
	('C00005','1.2.1.76'),
	('C00005','1.2.1.77'),
	('C00005','1.2.1.79'),
	('C00005','1.2.1.8'),
	('C00005','1.5.1.41'),
	('C00005','1.5.1.43'),
	('C00005','1.5.1.45'),
	('C00005','1.5.1.46'),
	('C00005','1.5.1.47'),
	('C00005','1.5.1.48'),
	('C00005','1.5.1.49'),
	('C00005','1.5.1.5'),
	('C00005','1.5.1.50'),
	('C00005','1.5.1.20'),
	('C00005','1.5.1.21'),
	('C00005','1.5.1.24'),
	('C00005','1.5.1.25'),
	('C00005','1.5.1.27'),
	('C00005','1.5.1.3'),
	('C00005','1.5.1.30'),
	('C00005','1.5.1.31'),
	('C00005','1.5.1.32'),
	('C00005','1.5.1.33'),
	('C00005','1.5.1.34'),
	('C00005','1.5.1.1'),
	('C00005','1.5.1.10'),
	('C00005','1.5.1.16'),
	('C00005','1.5.1.19'),
	('C00005','1.5.1.2'),
	('C00005','1.4.1.3'),
	('C00005','1.4.1.4'),
	('C00005','1.4.1.5'),
	('C00005','1.4.1.7'),
	('C00005','1.4.1.8'),
	('C00005','1.4.1.9'),
	('C00005','1.4.1.16'),
	('C00005','1.4.1.17'),
	('C00005','1.4.1.19'),
	('C00005','1.4.1.2'),
	('C00005','1.4.1.20'),
	('C00005','1.4.1.21'),
	('C00005','1.4.1.1'),
	('C00005','1.4.1.10'),
	('C00005','1.4.1.12'),
	('C00005','1.4.1.13'),
	('C00005','1.4.1.15'),
	('C00005','1.3.99.6'),
	('C00005','1.3.3.9'),
	('C00005','1.3.1.82'),
	('C00005','1.3.1.83'),
	('C00005','1.3.1.84'),
	('C00005','1.3.1.85'),
	('C00005','1.3.1.86'),
	('C00005','1.3.1.92'),
	('C00005','1.3.1.93'),
	('C00005','1.3.1.96'),
	('C00005','1.3.1.97'),
	('C00005','1.3.1.98'),
	('C00005','1.3.1.67'),
	('C00005','1.3.1.69'),
	('C00005','1.3.1.70'),
	('C00005','1.3.1.71'),
	('C00005','1.3.1.72'),
	('C00005','1.3.1.73'),
	('C00005','1.3.1.74'),
	('C00005','1.3.1.75'),
	('C00005','5.3.3.1'),
	('C00005','4.2.1.93'),
	('C00005','4.2.1.136'),
	('C00005','4.1.99.5'),
	('C00005','2.7.1.86'),
	('C00005','2.5.1.21'),
	('C00005','2.3.1.85'),
	('C00005','2.3.1.86'),
	('C00005','2.3.1.94'),
	('C00005','2.3.1.236'),
	('C00005','2.3.1.237'),
	('C00005','2.3.1.239'),
	('C00005','2.3.1.240'),
	('C00005','2.3.1.161'),
	('C00005','2.3.1.165'),
	('C00005','2.3.1.170'),
	('C00005','2.3.1.111'),
	('C00005','2.1.1.147'),
	('C00005','2.1.1.148'),
	('C00005','1.8.1.7'),
	('C00005','1.8.1.8'),
	('C00005','1.8.1.9'),
	('C00005','1.8.1.12'),
	('C00005','1.8.1.13'),
	('C00005','1.8.1.14'),
	('C00005','1.8.1.15'),
	('C00005','1.8.1.18'),
	('C00005','1.8.1.19'),
	('C00005','1.8.1.2'),
	('C00005','1.8.1.5'),
	('C00005','1.8.1.10'),
	('C00005','1.7.1.11'),
	('C00005','1.7.1.12'),
	('C00005','1.7.1.13'),
	('C00005','1.7.1.14'),
	('C00005','1.7.1.2'),
	('C00005','1.7.1.3'),
	('C00005','1.7.1.4'),
	('C00005','1.7.1.6'),
	('C00005','1.7.1.7'),
	('C00005','1.7.1.9'),
	('C00005','1.6.5.12'),
	('C00005','1.6.5.2'),
	('C00005','1.6.5.5'),
	('C00005','1.6.5.6'),
	('C00005','1.6.99.1'),
	('C00005','1.6.1.1'),
	('C00005','1.6.1.2'),
	('C00005','1.6.1.3'),
	('C00005','1.6.2.4'),
	('C00005','1.6.2.5'),
	('C00005','1.6.2.6'),
	('C00005','1.6.3.1'),
	('C00005','1.6.3.2'),
	('C00005','1.6.5.10'),
	('C00005','1.5.1.6'),
	('C00005','1.5.1.8'),
	('C00005','1.5.1.38'),
	('C00005','1.5.1.39'),
	('C00005','1.5.1.40'),
	('C00006','1.1.1.123'),
	('C00006','1.1.1.1'),
	('C00006','1.1.1.10'),
	('C00006','1.1.1.100'),
	('C00006','1.1.1.101'),
	('C00006','1.1.1.102'),
	('C00006','1.1.1.104'),
	('C00006','1.1.1.220'),
	('C00006','1.1.1.222'),
	('C00006','1.1.1.224'),
	('C00006','1.1.1.225'),
	('C00006','1.1.1.195'),
	('C00006','1.1.1.196'),
	('C00006','1.1.1.197'),
	('C00006','1.1.1.2'),
	('C00006','1.1.1.20'),
	('C00006','1.1.1.200'),
	('C00006','1.1.1.201'),
	('C00006','1.1.1.206'),
	('C00006','1.1.1.207'),
	('C00006','1.1.1.208'),
	('C00006','1.1.1.209'),
	('C00006','1.1.1.21'),
	('C00006','1.1.1.210'),
	('C00006','1.1.1.179'),
	('C00006','1.1.1.181'),
	('C00006','1.1.1.183'),
	('C00006','1.1.1.184'),
	('C00006','1.1.1.185'),
	('C00006','1.1.1.186'),
	('C00006','1.1.1.187'),
	('C00006','1.1.1.188'),
	('C00006','1.1.1.189'),
	('C00006','1.1.1.19'),
	('C00006','1.1.1.191'),
	('C00006','1.1.1.193'),
	('C00006','1.1.1.194'),
	('C00006','1.1.1.157'),
	('C00006','1.1.1.160'),
	('C00006','1.1.1.162'),
	('C00006','1.1.1.168'),
	('C00006','1.1.1.169'),
	('C00006','1.1.1.170'),
	('C00006','1.1.1.176'),
	('C00006','1.1.1.177'),
	('C00006','1.1.1.142'),
	('C00006','1.1.1.145'),
	('C00006','1.1.1.146'),
	('C00006','1.1.1.147'),
	('C00006','1.1.1.148'),
	('C00006','1.1.1.149'),
	('C00006','1.1.1.151'),
	('C00006','1.1.1.153'),
	('C00006','1.1.1.154'),
	('C00006','1.1.1.156'),
	('C00006','1.1.1.124'),
	('C00006','1.1.1.126'),
	('C00006','1.1.1.130'),
	('C00006','1.1.1.131'),
	('C00006','1.1.1.133'),
	('C00006','1.1.1.134'),
	('C00006','1.1.1.135'),
	('C00006','1.1.1.137'),
	('C00006','1.1.1.138'),
	('C00006','1.1.1.111'),
	('C00006','1.1.1.112'),
	('C00006','1.1.1.113'),
	('C00006','1.1.1.115'),
	('C00006','1.1.1.117'),
	('C00006','1.1.1.119'),
	('C00006','1.1.1.120'),
	('C00006','1.1.1.317'),
	('C00006','1.1.1.318'),
	('C00006','1.1.1.319'),
	('C00006','1.1.1.320'),
	('C00006','1.1.1.321'),
	('C00006','1.1.1.322'),
	('C00006','1.1.1.323'),
	('C00006','1.1.1.324'),
	('C00006','1.1.1.325'),
	('C00006','1.1.1.328'),
	('C00006','1.1.1.299'),
	('C00006','1.1.1.3'),
	('C00006','1.1.1.300'),
	('C00006','1.1.1.302'),
	('C00006','1.1.1.307'),
	('C00006','1.1.1.282'),
	('C00006','1.1.1.283'),
	('C00006','1.1.1.284'),
	('C00006','1.1.1.285'),
	('C00006','1.1.1.287'),
	('C00006','1.1.1.289'),
	('C00006','1.1.1.292'),
	('C00006','1.1.1.294'),
	('C00006','1.1.1.295'),
	('C00006','1.1.1.298'),
	('C00006','1.1.1.266'),
	('C00006','1.1.1.267'),
	('C00006','1.1.1.270'),
	('C00006','1.1.1.271'),
	('C00006','1.1.1.272'),
	('C00006','1.1.1.273'),
	('C00006','1.1.1.274'),
	('C00006','1.1.1.276'),
	('C00006','1.1.1.277'),
	('C00006','1.1.1.278'),
	('C00006','1.1.1.279'),
	('C00006','1.1.1.280'),
	('C00006','1.1.1.281'),
	('C00006','1.1.1.248'),
	('C00006','1.1.1.25'),
	('C00006','1.1.1.252'),
	('C00006','1.1.1.256'),
	('C00006','1.1.1.261'),
	('C00006','1.1.1.263'),
	('C00006','1.1.1.264'),
	('C00006','1.1.1.265'),
	('C00006','1.1.1.229'),
	('C00006','1.1.1.230'),
	('C00006','1.1.1.231'),
	('C00006','1.1.1.232'),
	('C00006','1.1.1.234'),
	('C00006','1.1.1.235'),
	('C00006','1.1.1.236'),
	('C00006','1.1.1.237'),
	('C00006','1.1.1.238'),
	('C00006','1.1.1.243'),
	('C00006','1.1.1.247'),
	('C00006','1.1.1.213'),
	('C00006','1.1.1.214'),
	('C00006','1.1.1.215'),
	('C00006','1.1.1.216'),
	('C00006','1.1.1.217'),
	('C00006','1.1.1.218'),
	('C00006','1.1.1.219'),
	('C00006','1.1.1.92'),
	('C00006','1.1.1.94'),
	('C00006','1.1.1.64'),
	('C00006','1.1.1.65'),
	('C00006','1.1.1.69'),
	('C00006','1.1.1.71'),
	('C00006','1.1.1.72'),
	('C00006','1.1.1.79'),
	('C00006','1.1.1.80'),
	('C00006','1.1.1.47'),
	('C00006','1.1.1.48'),
	('C00006','1.1.1.49'),
	('C00006','1.1.1.50'),
	('C00006','1.1.1.51'),
	('C00006','1.1.1.54'),
	('C00006','1.1.1.55'),
	('C00006','1.1.1.60'),
	('C00006','1.1.1.62'),
	('C00006','1.1.1.392'),
	('C00006','1.1.1.393'),
	('C00006','1.1.1.40'),
	('C00006','1.1.1.402'),
	('C00006','1.1.1.42'),
	('C00006','1.1.1.43'),
	('C00006','1.1.1.44'),
	('C00006','1.1.1.378'),
	('C00006','1.1.1.381'),
	('C00006','1.1.1.383'),
	('C00006','1.1.1.384'),
	('C00006','1.1.1.386'),
	('C00006','1.1.1.362'),
	('C00006','1.1.1.363'),
	('C00006','1.1.1.364'),
	('C00006','1.1.1.365'),
	('C00006','1.1.1.367'),
	('C00006','1.1.1.371'),
	('C00006','1.1.1.372'),
	('C00006','1.1.1.375'),
	('C00006','1.1.1.376'),
	('C00006','1.1.1.377'),
	('C00006','1.1.1.346'),
	('C00006','1.1.1.348'),
	('C00006','1.1.1.349'),
	('C00006','1.1.1.351'),
	('C00006','1.1.1.353'),
	('C00006','1.1.1.355'),
	('C00006','1.1.1.356'),
	('C00006','1.1.1.357'),
	('C00006','1.1.1.358'),
	('C00006','1.1.1.359'),
	('C00006','1.1.1.36'),
	('C00006','1.1.1.360'),
	('C00006','1.1.1.329'),
	('C00006','1.1.1.33'),
	('C00006','1.1.1.330'),
	('C00006','1.1.1.334'),
	('C00006','1.1.1.338'),
	('C00006','1.1.1.34'),
	('C00006','1.1.1.341'),
	('C00006','1.1.1.342'),
	('C00006','1.1.1.344'),
	('C00006','1.1.1.312'),
	('C00006','1.1.1.313'),
	('C00006','1.1.1.314'),
	('C00006','1.14.13.147'),
	('C00006','1.14.13.148'),
	('C00006','1.14.13.149'),
	('C00006','1.14.13.150'),
	('C00006','1.14.13.153'),
	('C00006','1.14.13.154'),
	('C00006','1.14.13.156'),
	('C00006','1.14.13.133'),
	('C00006','1.14.13.134'),
	('C00006','1.14.13.135'),
	('C00006','1.14.13.136'),
	('C00006','1.14.13.137'),
	('C00006','1.14.13.138'),
	('C00006','1.14.13.139'),
	('C00006','1.14.13.14'),
	('C00006','1.14.13.140'),
	('C00006','1.14.13.12'),
	('C00006','1.14.13.120'),
	('C00006','1.14.13.121'),
	('C00006','1.14.13.122'),
	('C00006','1.14.13.123'),
	('C00006','1.14.13.124'),
	('C00006','1.14.13.125'),
	('C00006','1.14.13.128'),
	('C00006','1.14.13.109'),
	('C00006','1.14.13.11'),
	('C00006','1.14.13.110'),
	('C00006','1.14.13.112'),
	('C00006','1.14.13.115'),
	('C00006','1.14.13.116'),
	('C00006','1.14.13.117'),
	('C00006','1.14.13.118'),
	('C00006','1.14.13.119'),
	('C00006','1.14.13.101'),
	('C00006','1.14.13.102'),
	('C00006','1.14.13.103'),
	('C00006','1.14.13.104'),
	('C00006','1.14.13.105'),
	('C00006','1.14.13.106'),
	('C00006','1.14.13.107'),
	('C00006','1.14.13.108'),
	('C00006','1.14.12.17'),
	('C00006','1.14.12.18'),
	('C00006','1.14.12.22'),
	('C00006','1.14.12.4'),
	('C00006','1.14.12.5'),
	('C00006','1.14.12.1'),
	('C00006','1.14.12.10'),
	('C00006','1.13.11.29'),
	('C00006','1.13.11.30'),
	('C00006','1.12.1.3'),
	('C00006','1.12.1.5'),
	('C00006','1.11.1.2'),
	('C00006','1.10.1.1'),
	('C00006','1.1.1.97'),
	('C00006','1.1.1.81'),
	('C00006','1.1.1.82'),
	('C00006','1.1.1.86'),
	('C00006','1.1.1.91'),
	('C00006','1.14.13.38'),
	('C00006','1.14.13.219'),
	('C00006','1.14.13.22'),
	('C00006','1.14.13.221'),
	('C00006','1.14.13.222'),
	('C00006','1.14.13.224'),
	('C00006','1.14.13.226'),
	('C00006','1.14.13.23'),
	('C00006','1.14.13.25'),
	('C00006','1.14.13.21'),
	('C00006','1.14.13.210'),
	('C00006','1.14.13.211'),
	('C00006','1.14.13.213'),
	('C00006','1.14.13.214'),
	('C00006','1.14.13.216'),
	('C00006','1.14.13.217'),
	('C00006','1.14.13.196'),
	('C00006','1.14.13.197'),
	('C00006','1.14.13.198'),
	('C00006','1.14.13.199'),
	('C00006','1.14.13.2'),
	('C00006','1.14.13.20'),
	('C00006','1.14.13.200'),
	('C00006','1.14.13.201'),
	('C00006','1.14.13.202'),
	('C00006','1.14.13.203'),
	('C00006','1.14.13.204'),
	('C00006','1.14.13.206'),
	('C00006','1.14.13.183'),
	('C00006','1.14.13.184'),
	('C00006','1.14.13.185'),
	('C00006','1.14.13.186'),
	('C00006','1.14.13.187'),
	('C00006','1.14.13.188'),
	('C00006','1.14.13.189'),
	('C00006','1.14.13.19'),
	('C00006','1.14.13.190'),
	('C00006','1.14.13.194'),
	('C00006','1.14.13.195'),
	('C00006','1.14.13.172'),
	('C00006','1.14.13.173'),
	('C00006','1.14.13.174'),
	('C00006','1.14.13.175'),
	('C00006','1.14.13.176'),
	('C00006','1.14.13.177'),
	('C00006','1.14.13.178'),
	('C00006','1.14.13.179'),
	('C00006','1.14.13.18'),
	('C00006','1.14.13.180'),
	('C00006','1.14.13.181'),
	('C00006','1.14.13.157'),
	('C00006','1.14.13.158'),
	('C00006','1.14.13.16'),
	('C00006','1.14.13.160'),
	('C00006','1.14.13.161'),
	('C00006','1.14.13.165'),
	('C00006','1.14.13.167'),
	('C00006','1.14.13.168'),
	('C00006','1.14.13.170'),
	('C00006','1.14.13.171'),
	('C00006','1.14.13.143'),
	('C00006','1.14.13.144'),
	('C00006','1.14.13.145'),
	('C00006','1.14.13.146'),
	('C00006','1.14.14.16'),
	('C00006','1.14.14.17'),
	('C00006','1.14.14.19'),
	('C00006','1.14.14.23'),
	('C00006','1.14.13.87'),
	('C00006','1.14.13.88'),
	('C00006','1.14.13.89'),
	('C00006','1.14.13.9'),
	('C00006','1.14.13.90'),
	('C00006','1.14.13.91'),
	('C00006','1.14.13.92'),
	('C00006','1.14.13.93'),
	('C00006','1.14.13.94'),
	('C00006','1.14.13.96'),
	('C00006','1.14.13.97'),
	('C00006','1.14.13.75'),
	('C00006','1.14.13.76'),
	('C00006','1.14.13.77'),
	('C00006','1.14.13.78'),
	('C00006','1.14.13.79'),
	('C00006','1.14.13.8'),
	('C00006','1.14.13.80'),
	('C00006','1.14.13.81'),
	('C00006','1.14.13.84'),
	('C00006','1.14.13.85'),
	('C00006','1.14.13.63'),
	('C00006','1.14.13.64'),
	('C00006','1.14.13.66'),
	('C00006','1.14.13.67'),
	('C00006','1.14.13.68'),
	('C00006','1.14.13.7'),
	('C00006','1.14.13.70'),
	('C00006','1.14.13.71'),
	('C00006','1.14.13.72'),
	('C00006','1.14.13.73'),
	('C00006','1.14.13.74'),
	('C00006','1.14.13.51'),
	('C00006','1.14.13.52'),
	('C00006','1.14.13.53'),
	('C00006','1.14.13.54'),
	('C00006','1.14.13.55'),
	('C00006','1.14.13.56'),
	('C00006','1.14.13.57'),
	('C00006','1.14.13.58'),
	('C00006','1.14.13.59'),
	('C00006','1.14.13.39'),
	('C00006','1.14.13.40'),
	('C00006','1.14.13.41'),
	('C00006','1.14.13.43'),
	('C00006','1.14.13.46'),
	('C00006','1.14.13.47'),
	('C00006','1.14.13.48'),
	('C00006','1.14.13.49'),
	('C00006','1.14.13.50'),
	('C00006','1.14.13.27'),
	('C00006','1.14.13.28'),
	('C00006','1.14.13.30'),
	('C00006','1.14.13.31'),
	('C00006','1.14.13.32'),
	('C00006','1.14.13.33'),
	('C00006','1.14.13.34'),
	('C00006','1.14.13.35'),
	('C00006','1.14.13.36'),
	('C00006','1.14.13.37'),
	('C00006','1.2.1.79'),
	('C00006','1.2.1.8'),
	('C00006','1.2.1.80'),
	('C00006','1.2.1.81'),
	('C00006','1.2.1.57'),
	('C00006','1.2.1.59'),
	('C00006','1.2.1.63'),
	('C00006','1.2.1.68'),
	('C00006','1.2.1.43'),
	('C00006','1.2.1.44'),
	('C00006','1.2.1.49'),
	('C00006','1.2.1.5'),
	('C00006','1.2.1.50'),
	('C00006','1.2.1.51'),
	('C00006','1.2.1.52'),
	('C00006','1.2.1.28'),
	('C00006','1.2.1.3'),
	('C00006','1.2.1.30'),
	('C00006','1.2.1.31'),
	('C00006','1.2.1.38'),
	('C00006','1.2.1.4'),
	('C00006','1.2.1.41'),
	('C00006','1.2.1.17'),
	('C00006','1.2.1.18'),
	('C00006','1.2.1.26'),
	('C00006','1.18.1.6'),
	('C00006','1.2.1.11'),
	('C00006','1.2.1.13'),
	('C00006','1.2.1.15'),
	('C00006','1.2.1.16'),
	('C00006','1.17.1.5'),
	('C00006','1.17.1.8'),
	('C00006','1.18.1.2'),
	('C00006','1.18.1.4'),
	('C00006','1.16.1.1'),
	('C00006','1.16.1.5'),
	('C00006','1.16.1.6'),
	('C00006','1.16.1.8'),
	('C00006','1.16.1.9'),
	('C00006','1.17.1.1'),
	('C00006','1.17.1.3'),
	('C00006','1.14.99.34'),
	('C00006','1.14.99.2'),
	('C00006','1.14.21.1'),
	('C00006','1.14.21.10'),
	('C00006','1.14.21.11'),
	('C00006','1.14.21.2'),
	('C00006','1.14.21.3'),
	('C00006','1.14.21.4'),
	('C00006','1.14.21.5'),
	('C00006','1.14.21.7'),
	('C00006','1.14.21.8'),
	('C00006','1.14.21.9'),
	('C00006','1.14.19.21'),
	('C00006','1.14.19.41'),
	('C00006','1.14.15.3'),
	('C00006','1.14.14.24'),
	('C00006','1.14.14.25'),
	('C00006','1.14.14.26'),
	('C00006','1.14.14.29'),
	('C00006','1.14.14.1'),
	('C00006','1.3.1.75'),
	('C00006','1.3.1.77'),
	('C00006','1.3.1.78'),
	('C00006','1.3.1.79'),
	('C00006','1.3.1.8'),
	('C00006','1.3.1.81'),
	('C00006','1.3.1.45'),
	('C00006','1.3.1.46'),
	('C00006','1.3.1.47'),
	('C00006','1.3.1.48'),
	('C00006','1.3.1.5'),
	('C00006','1.3.1.51'),
	('C00006','1.3.1.54'),
	('C00006','1.3.1.57'),
	('C00006','1.3.1.24'),
	('C00006','1.3.1.27'),
	('C00006','1.3.1.3'),
	('C00006','1.3.1.32'),
	('C00006','1.3.1.33'),
	('C00006','1.3.1.34'),
	('C00006','1.3.1.36'),
	('C00006','1.3.1.37'),
	('C00006','1.3.1.38'),
	('C00006','1.3.1.39'),
	('C00006','1.3.1.40'),
	('C00006','1.3.1.42'),
	('C00006','1.3.1.104'),
	('C00006','1.3.1.105'),
	('C00006','1.3.1.107'),
	('C00006','1.3.1.111'),
	('C00006','1.3.1.13'),
	('C00006','1.3.1.15'),
	('C00006','1.3.1.16'),
	('C00006','1.3.1.17'),
	('C00006','1.3.1.2'),
	('C00006','1.3.1.20'),
	('C00006','1.3.1.21'),
	('C00006','1.3.1.22'),
	('C00006','1.23.1.1'),
	('C00006','1.23.1.2'),
	('C00006','1.23.1.3'),
	('C00006','1.23.1.4'),
	('C00006','1.3.1.10'),
	('C00006','1.3.1.101'),
	('C00006','1.3.1.102'),
	('C00006','1.3.1.103'),
	('C00006','1.21.1.1'),
	('C00006','1.21.1.2'),
	('C00006','1.2.1.83'),
	('C00006','1.2.1.84'),
	('C00006','1.2.1.88'),
	('C00006','1.2.1.89'),
	('C00006','1.2.1.9'),
	('C00006','1.2.1.90'),
	('C00006','1.2.1.91'),
	('C00006','1.2.1.92'),
	('C00006','1.2.1.96'),
	('C00006','1.2.1.7'),
	('C00006','1.2.1.70'),
	('C00006','1.2.1.75'),
	('C00006','1.2.1.76'),
	('C00006','1.2.1.77'),
	('C00006','1.5.1.40'),
	('C00006','1.5.1.41'),
	('C00006','1.5.1.43'),
	('C00006','1.5.1.45'),
	('C00006','1.5.1.46'),
	('C00006','1.5.1.47'),
	('C00006','1.5.1.48'),
	('C00006','1.5.1.49'),
	('C00006','1.5.1.5'),
	('C00006','1.5.1.50'),
	('C00006','1.5.1.20'),
	('C00006','1.5.1.21'),
	('C00006','1.5.1.24'),
	('C00006','1.5.1.25'),
	('C00006','1.5.1.27'),
	('C00006','1.5.1.3'),
	('C00006','1.5.1.30'),
	('C00006','1.5.1.31'),
	('C00006','1.5.1.32'),
	('C00006','1.5.1.33'),
	('C00006','1.5.1.34'),
	('C00006','1.5.1.1'),
	('C00006','1.5.1.10'),
	('C00006','1.5.1.16'),
	('C00006','1.5.1.19'),
	('C00006','1.5.1.2'),
	('C00006','1.4.1.3'),
	('C00006','1.4.1.4'),
	('C00006','1.4.1.5'),
	('C00006','1.4.1.7'),
	('C00006','1.4.1.8'),
	('C00006','1.4.1.9'),
	('C00006','1.4.1.16'),
	('C00006','1.4.1.17'),
	('C00006','1.4.1.19'),
	('C00006','1.4.1.2'),
	('C00006','1.4.1.20'),
	('C00006','1.4.1.21'),
	('C00006','1.4.1.1'),
	('C00006','1.4.1.10'),
	('C00006','1.4.1.12'),
	('C00006','1.4.1.13'),
	('C00006','1.4.1.15'),
	('C00006','1.3.99.6'),
	('C00006','1.3.3.9'),
	('C00006','1.3.1.82'),
	('C00006','1.3.1.83'),
	('C00006','1.3.1.84'),
	('C00006','1.3.1.85'),
	('C00006','1.3.1.86'),
	('C00006','1.3.1.92'),
	('C00006','1.3.1.93'),
	('C00006','1.3.1.96'),
	('C00006','1.3.1.97'),
	('C00006','1.3.1.98'),
	('C00006','1.3.1.67'),
	('C00006','1.3.1.69'),
	('C00006','1.3.1.70'),
	('C00006','1.3.1.71'),
	('C00006','1.3.1.72'),
	('C00006','1.3.1.73'),
	('C00006','1.3.1.74'),
	('C00006','5.3.3.1'),
	('C00006','4.1.99.5'),
	('C00006','2.7.1.23'),
	('C00006','2.5.1.21'),
	('C00006','2.4.99.20'),
	('C00006','2.3.1.85'),
	('C00006','2.3.1.86'),
	('C00006','2.3.1.94'),
	('C00006','2.3.1.236'),
	('C00006','2.3.1.237'),
	('C00006','2.3.1.239'),
	('C00006','2.3.1.240'),
	('C00006','2.3.1.161'),
	('C00006','2.3.1.165'),
	('C00006','2.3.1.170'),
	('C00006','2.3.1.111'),
	('C00006','2.1.1.147'),
	('C00006','2.1.1.148'),
	('C00006','1.8.1.7'),
	('C00006','1.8.1.8'),
	('C00006','1.8.1.9'),
	('C00006','1.8.1.12'),
	('C00006','1.8.1.13'),
	('C00006','1.8.1.14'),
	('C00006','1.8.1.15'),
	('C00006','1.8.1.18'),
	('C00006','1.8.1.19'),
	('C00006','1.8.1.2'),
	('C00006','1.8.1.5'),
	('C00006','1.8.1.10'),
	('C00006','1.7.1.11'),
	('C00006','1.7.1.12'),
	('C00006','1.7.1.13'),
	('C00006','1.7.1.14'),
	('C00006','1.7.1.2'),
	('C00006','1.7.1.3'),
	('C00006','1.7.1.4'),
	('C00006','1.7.1.6'),
	('C00006','1.7.1.7'),
	('C00006','1.7.1.9'),
	('C00006','1.6.5.12'),
	('C00006','1.6.5.2'),
	('C00006','1.6.5.5'),
	('C00006','1.6.5.6'),
	('C00006','1.6.99.1'),
	('C00006','1.6.1.1'),
	('C00006','1.6.1.2'),
	('C00006','1.6.1.3'),
	('C00006','1.6.2.4'),
	('C00006','1.6.2.5'),
	('C00006','1.6.2.6'),
	('C00006','1.6.3.1'),
	('C00006','1.6.3.2'),
	('C00006','1.6.3.5'),
	('C00006','1.6.5.10'),
	('C00006','1.5.1.6'),
	('C00006','1.5.1.8'),
	('C00006','1.5.1.38'),
	('C00006','1.5.1.39'),
	('C00007','1.1.3.45'),
	('C00007','1.1.3.46'),
	('C00007','1.1.3.47'),
	('C00007','1.1.3.49'),
	('C00007','1.1.3.5'),
	('C00007','1.1.3.6'),
	('C00007','1.1.3.7'),
	('C00007','1.1.3.8'),
	('C00007','1.1.3.9'),
	('C00007','1.1.5.4'),
	('C00007','1.1.3.10'),
	('C00007','1.1.3.11'),
	('C00007','1.1.3.12'),
	('C00007','1.1.3.13'),
	('C00007','1.1.3.14'),
	('C00007','1.1.3.15'),
	('C00007','1.1.3.16'),
	('C00007','1.1.3.17'),
	('C00007','1.1.3.18'),
	('C00007','1.1.3.19'),
	('C00007','1.1.3.20'),
	('C00007','1.1.3.21'),
	('C00007','1.1.3.23'),
	('C00007','1.1.3.27'),
	('C00007','1.1.1.270'),
	('C00007','1.1.1.170'),
	('C00007','1.13.11.6'),
	('C00007','1.13.11.60'),
	('C00007','1.13.11.61'),
	('C00007','1.13.11.62'),
	('C00007','1.13.11.63'),
	('C00007','1.13.11.64'),
	('C00007','1.13.11.65'),
	('C00007','1.13.11.66'),
	('C00007','1.13.11.67'),
	('C00007','1.13.11.68'),
	('C00007','1.13.11.69'),
	('C00007','1.13.11.70'),
	('C00007','1.13.11.71'),
	('C00007','1.13.11.1'),
	('C00007','1.13.11.10'),
	('C00007','1.13.11.11'),
	('C00007','1.13.11.12'),
	('C00007','1.13.11.14'),
	('C00007','1.13.11.15'),
	('C00007','1.13.11.16'),
	('C00007','1.13.11.17'),
	('C00007','1.13.11.18'),
	('C00007','1.13.11.19'),
	('C00007','1.13.11.2'),
	('C00007','1.13.11.20'),
	('C00007','1.13.11.22'),
	('C00007','1.13.11.23'),
	('C00007','1.13.11.24'),
	('C00007','1.13.11.25'),
	('C00007','1.13.11.26'),
	('C00007','1.13.11.27'),
	('C00007','1.13.11.28'),
	('C00007','1.11.1.21'),
	('C00007','1.11.1.6'),
	('C00007','1.1.99.9'),
	('C00007','1.10.3.1'),
	('C00007','1.10.3.10'),
	('C00007','1.10.3.11'),
	('C00007','1.10.3.12'),
	('C00007','1.10.3.13'),
	('C00007','1.10.3.14'),
	('C00007','1.10.3.15'),
	('C00007','1.10.3.2'),
	('C00007','1.10.3.3'),
	('C00007','1.10.3.4'),
	('C00007','1.10.3.5'),
	('C00007','1.10.3.6'),
	('C00007','1.10.3.9'),
	('C00007','1.1.99.18'),
	('C00007','1.1.3.28'),
	('C00007','1.1.3.29'),
	('C00007','1.1.3.30'),
	('C00007','1.1.3.37'),
	('C00007','1.1.3.38'),
	('C00007','1.1.3.39'),
	('C00007','1.1.3.4'),
	('C00007','1.1.3.40'),
	('C00007','1.1.3.41'),
	('C00007','1.1.3.42'),
	('C00007','1.1.3.43'),
	('C00007','1.1.3.44'),
	('C00007','1.13.12.9'),
	('C00007','1.13.99.1'),
	('C00007','1.13.99.3'),
	('C00007','1.14.11.1'),
	('C00007','1.14.11.10'),
	('C00007','1.14.11.11'),
	('C00007','1.14.11.12'),
	('C00007','1.13.11.72'),
	('C00007','1.13.11.73'),
	('C00007','1.13.11.74'),
	('C00007','1.13.11.75'),
	('C00007','1.13.11.76'),
	('C00007','1.13.11.77'),
	('C00007','1.13.11.78'),
	('C00007','1.13.11.79'),
	('C00007','1.13.11.8'),
	('C00007','1.13.11.80'),
	('C00007','1.13.11.81'),
	('C00007','1.13.11.82'),
	('C00007','1.13.11.9'),
	('C00007','1.13.12.1'),
	('C00007','1.13.12.13'),
	('C00007','1.13.12.15'),
	('C00007','1.13.12.16'),
	('C00007','1.13.12.17'),
	('C00007','1.13.12.18'),
	('C00007','1.13.12.19'),
	('C00007','1.13.12.2'),
	('C00007','1.13.12.20'),
	('C00007','1.13.12.21'),
	('C00007','1.13.11.29'),
	('C00007','1.13.11.3'),
	('C00007','1.13.11.30'),
	('C00007','1.13.11.31'),
	('C00007','1.13.11.33'),
	('C00007','1.13.11.34'),
	('C00007','1.13.11.35'),
	('C00007','1.13.11.36'),
	('C00007','1.13.11.37'),
	('C00007','1.13.11.38'),
	('C00007','1.13.11.39'),
	('C00007','1.13.11.4'),
	('C00007','1.13.11.40'),
	('C00007','1.13.11.41'),
	('C00007','1.13.11.43'),
	('C00007','1.13.11.45'),
	('C00007','1.13.11.46'),
	('C00007','1.13.11.47'),
	('C00007','1.13.11.48'),
	('C00007','1.13.11.49'),
	('C00007','1.13.11.5'),
	('C00007','1.13.11.50'),
	('C00007','1.13.11.51'),
	('C00007','1.13.11.52'),
	('C00007','1.13.11.53'),
	('C00007','1.13.11.54'),
	('C00007','1.13.11.55'),
	('C00007','1.13.11.56'),
	('C00007','1.13.11.57'),
	('C00007','1.13.11.58'),
	('C00007','1.13.11.59'),
	('C00007','1.14.12.5'),
	('C00007','1.14.12.7'),
	('C00007','1.14.12.8'),
	('C00007','1.14.12.9'),
	('C00007','1.14.11.8'),
	('C00007','1.14.11.9'),
	('C00007','1.14.12.1'),
	('C00007','1.14.12.10'),
	('C00007','1.14.12.11'),
	('C00007','1.14.12.12'),
	('C00007','1.14.12.13'),
	('C00007','1.14.12.14'),
	('C00007','1.14.12.15'),
	('C00007','1.14.12.16'),
	('C00007','1.14.11.40'),
	('C00007','1.14.11.41'),
	('C00007','1.14.11.42'),
	('C00007','1.14.11.43'),
	('C00007','1.14.11.44'),
	('C00007','1.14.11.45'),
	('C00007','1.14.11.46'),
	('C00007','1.14.11.48'),
	('C00007','1.14.11.49'),
	('C00007','1.14.11.50'),
	('C00007','1.14.11.51'),
	('C00007','1.14.11.52'),
	('C00007','1.14.11.6'),
	('C00007','1.14.11.7'),
	('C00007','1.14.11.26'),
	('C00007','1.14.11.27'),
	('C00007','1.14.11.28'),
	('C00007','1.14.11.3'),
	('C00007','1.14.11.31'),
	('C00007','1.14.11.32'),
	('C00007','1.14.11.34'),
	('C00007','1.14.11.35'),
	('C00007','1.14.11.36'),
	('C00007','1.14.11.37'),
	('C00007','1.14.11.38'),
	('C00007','1.14.11.39'),
	('C00007','1.14.11.4'),
	('C00007','1.14.11.13'),
	('C00007','1.14.11.14'),
	('C00007','1.14.11.15'),
	('C00007','1.14.11.16'),
	('C00007','1.14.11.17'),
	('C00007','1.14.11.18'),
	('C00007','1.14.11.19'),
	('C00007','1.14.11.2'),
	('C00007','1.14.11.20'),
	('C00007','1.14.11.21'),
	('C00007','1.14.11.22'),
	('C00007','1.14.11.23'),
	('C00007','1.14.11.24'),
	('C00007','1.14.11.25'),
	('C00007','1.13.12.22'),
	('C00007','1.13.12.3'),
	('C00007','1.13.12.4'),
	('C00007','1.13.12.5'),
	('C00007','1.13.12.6'),
	('C00007','1.13.12.7'),
	('C00007','1.13.12.8'),
	('C00007','1.14.13.145'),
	('C00007','1.14.13.146'),
	('C00007','1.14.13.147'),
	('C00007','1.14.13.148'),
	('C00007','1.14.13.149'),
	('C00007','1.14.13.150'),
	('C00007','1.14.13.151'),
	('C00007','1.14.13.152'),
	('C00007','1.14.13.153'),
	('C00007','1.14.13.154'),
	('C00007','1.14.13.156'),
	('C00007','1.14.13.131'),
	('C00007','1.14.13.133'),
	('C00007','1.14.13.134'),
	('C00007','1.14.13.135'),
	('C00007','1.14.13.136'),
	('C00007','1.14.13.137'),
	('C00007','1.14.13.138'),
	('C00007','1.14.13.139'),
	('C00007','1.14.13.14'),
	('C00007','1.14.13.140'),
	('C00007','1.14.13.141'),
	('C00007','1.14.13.142'),
	('C00007','1.14.13.119'),
	('C00007','1.14.13.12'),
	('C00007','1.14.13.120'),
	('C00007','1.14.13.121'),
	('C00007','1.14.13.122'),
	('C00007','1.14.13.123'),
	('C00007','1.14.13.124'),
	('C00007','1.14.13.125'),
	('C00007','1.14.13.127'),
	('C00007','1.14.13.128'),
	('C00007','1.14.13.129'),
	('C00007','1.14.13.130'),
	('C00007','1.14.13.109'),
	('C00007','1.14.13.11'),
	('C00007','1.14.13.110'),
	('C00007','1.14.13.111'),
	('C00007','1.14.13.112'),
	('C00007','1.14.13.113'),
	('C00007','1.14.13.114'),
	('C00007','1.14.13.115'),
	('C00007','1.14.13.116'),
	('C00007','1.14.13.117'),
	('C00007','1.14.13.118'),
	('C00007','1.14.13.1'),
	('C00007','1.14.13.10'),
	('C00007','1.14.13.101'),
	('C00007','1.14.13.102'),
	('C00007','1.14.13.103'),
	('C00007','1.14.13.104'),
	('C00007','1.14.13.105'),
	('C00007','1.14.13.106'),
	('C00007','1.14.13.107'),
	('C00007','1.14.13.108'),
	('C00007','1.14.12.17'),
	('C00007','1.14.12.18'),
	('C00007','1.14.12.19'),
	('C00007','1.14.12.22'),
	('C00007','1.14.12.23'),
	('C00007','1.14.12.24'),
	('C00007','1.14.12.3'),
	('C00007','1.14.12.4'),
	('C00007','1.14.13.227'),
	('C00007','1.14.13.23'),
	('C00007','1.14.13.24'),
	('C00007','1.14.13.25'),
	('C00007','1.14.13.209'),
	('C00007','1.14.13.21'),
	('C00007','1.14.13.210'),
	('C00007','1.14.13.211'),
	('C00007','1.14.13.212'),
	('C00007','1.14.13.213'),
	('C00007','1.14.13.214'),
	('C00007','1.14.13.215'),
	('C00007','1.14.13.216'),
	('C00007','1.14.13.217'),
	('C00007','1.14.13.218'),
	('C00007','1.14.13.196'),
	('C00007','1.14.13.197'),
	('C00007','1.14.13.198'),
	('C00007','1.14.13.199'),
	('C00007','1.14.13.2'),
	('C00007','1.14.13.20'),
	('C00007','1.14.13.200'),
	('C00007','1.14.13.201'),
	('C00007','1.14.13.202'),
	('C00007','1.14.13.203'),
	('C00007','1.14.13.204'),
	('C00007','1.14.13.206'),
	('C00007','1.14.13.182'),
	('C00007','1.14.13.183'),
	('C00007','1.14.13.184'),
	('C00007','1.14.13.185'),
	('C00007','1.14.13.186'),
	('C00007','1.14.13.187'),
	('C00007','1.14.13.188'),
	('C00007','1.14.13.189'),
	('C00007','1.14.13.19'),
	('C00007','1.14.13.190'),
	('C00007','1.14.13.194'),
	('C00007','1.14.13.195'),
	('C00007','1.14.13.172'),
	('C00007','1.14.13.173'),
	('C00007','1.14.13.174'),
	('C00007','1.14.13.175'),
	('C00007','1.14.13.176'),
	('C00007','1.14.13.177'),
	('C00007','1.14.13.178'),
	('C00007','1.14.13.179'),
	('C00007','1.14.13.18'),
	('C00007','1.14.13.180'),
	('C00007','1.14.13.181'),
	('C00007','1.14.13.157'),
	('C00007','1.14.13.158'),
	('C00007','1.14.13.16'),
	('C00007','1.14.13.160'),
	('C00007','1.14.13.161'),
	('C00007','1.14.13.162'),
	('C00007','1.14.13.163'),
	('C00007','1.14.13.165'),
	('C00007','1.14.13.167'),
	('C00007','1.14.13.168'),
	('C00007','1.14.13.170'),
	('C00007','1.14.13.171'),
	('C00007','1.14.13.143'),
	('C00007','1.14.13.144'),
	('C00007','1.14.13.77'),
	('C00007','1.14.13.78'),
	('C00007','1.14.13.79'),
	('C00007','1.14.13.8'),
	('C00007','1.14.13.80'),
	('C00007','1.14.13.81'),
	('C00007','1.14.13.82'),
	('C00007','1.14.13.83'),
	('C00007','1.14.13.84'),
	('C00007','1.14.13.85'),
	('C00007','1.14.13.63'),
	('C00007','1.14.13.64'),
	('C00007','1.14.13.66'),
	('C00007','1.14.13.67'),
	('C00007','1.14.13.68'),
	('C00007','1.14.13.69'),
	('C00007','1.14.13.7'),
	('C00007','1.14.13.70'),
	('C00007','1.14.13.71'),
	('C00007','1.14.13.72'),
	('C00007','1.14.13.73'),
	('C00007','1.14.13.51'),
	('C00007','1.14.13.52'),
	('C00007','1.14.13.53'),
	('C00007','1.14.13.54'),
	('C00007','1.14.13.55'),
	('C00007','1.14.13.56'),
	('C00007','1.14.13.57'),
	('C00007','1.14.13.58'),
	('C00007','1.14.13.59'),
	('C00007','1.14.13.6'),
	('C00007','1.14.13.61'),
	('C00007','1.14.13.62'),
	('C00007','1.14.13.39'),
	('C00007','1.14.13.4'),
	('C00007','1.14.13.40'),
	('C00007','1.14.13.41'),
	('C00007','1.14.13.43'),
	('C00007','1.14.13.44'),
	('C00007','1.14.13.46'),
	('C00007','1.14.13.47'),
	('C00007','1.14.13.48'),
	('C00007','1.14.13.49'),
	('C00007','1.14.13.5'),
	('C00007','1.14.13.50'),
	('C00007','1.14.13.27'),
	('C00007','1.14.13.28'),
	('C00007','1.14.13.29'),
	('C00007','1.14.13.30'),
	('C00007','1.14.13.31'),
	('C00007','1.14.13.32'),
	('C00007','1.14.13.33'),
	('C00007','1.14.13.34'),
	('C00007','1.14.13.35'),
	('C00007','1.14.13.36'),
	('C00007','1.14.13.37'),
	('C00007','1.14.13.38'),
	('C00007','1.14.13.219'),
	('C00007','1.14.13.22'),
	('C00007','1.14.13.220'),
	('C00007','1.14.13.221'),
	('C00007','1.14.13.222'),
	('C00007','1.14.13.224'),
	('C00007','1.14.13.226'),
	('C00007','1.14.15.3'),
	('C00007','1.14.15.4'),
	('C00007','1.14.15.5'),
	('C00007','1.14.15.6'),
	('C00007','1.14.15.7'),
	('C00007','1.14.15.8'),
	('C00007','1.14.15.9'),
	('C00007','1.14.16.1'),
	('C00007','1.14.16.2'),
	('C00007','1.14.16.3'),
	('C00007','1.14.16.4'),
	('C00007','1.14.16.5'),
	('C00007','1.14.16.6'),
	('C00007','1.14.16.7'),
	('C00007','1.14.17.1'),
	('C00007','1.14.17.3'),
	('C00007','1.14.14.24'),
	('C00007','1.14.14.25'),
	('C00007','1.14.14.26'),
	('C00007','1.14.14.27'),
	('C00007','1.14.14.29'),
	('C00007','1.14.14.3'),
	('C00007','1.14.14.31'),
	('C00007','1.14.14.32'),
	('C00007','1.14.14.5'),
	('C00007','1.14.14.8'),
	('C00007','1.14.14.9'),
	('C00007','1.14.15.1'),
	('C00007','1.14.15.10'),
	('C00007','1.14.15.11'),
	('C00007','1.14.15.12'),
	('C00007','1.14.15.13'),
	('C00007','1.14.15.15'),
	('C00007','1.14.14.1'),
	('C00007','1.14.14.10'),
	('C00007','1.14.14.11'),
	('C00007','1.14.14.12'),
	('C00007','1.14.14.13'),
	('C00007','1.14.14.14'),
	('C00007','1.14.14.15'),
	('C00007','1.14.14.16'),
	('C00007','1.14.14.17'),
	('C00007','1.14.14.18'),
	('C00007','1.14.14.19'),
	('C00007','1.14.14.21'),
	('C00007','1.14.14.22'),
	('C00007','1.14.14.23'),
	('C00007','1.14.13.87'),
	('C00007','1.14.13.88'),
	('C00007','1.14.13.89'),
	('C00007','1.14.13.9'),
	('C00007','1.14.13.90'),
	('C00007','1.14.13.91'),
	('C00007','1.14.13.92'),
	('C00007','1.14.13.93'),
	('C00007','1.14.13.94'),
	('C00007','1.14.13.96'),
	('C00007','1.14.13.97'),
	('C00007','1.14.13.74'),
	('C00007','1.14.13.75'),
	('C00007','1.14.13.76'),
	('C00007','1.14.99.12'),
	('C00007','1.14.99.14'),
	('C00007','1.14.99.15'),
	('C00007','1.14.99.19'),
	('C00007','1.14.99.2'),
	('C00007','1.14.99.20'),
	('C00007','1.14.99.21'),
	('C00007','1.14.99.22'),
	('C00007','1.14.99.23'),
	('C00007','1.14.99.24'),
	('C00007','1.14.99.26'),
	('C00007','1.14.99.27'),
	('C00007','1.14.20.3'),
	('C00007','1.14.21.1'),
	('C00007','1.14.21.10'),
	('C00007','1.14.21.11'),
	('C00007','1.14.21.2'),
	('C00007','1.14.21.3'),
	('C00007','1.14.21.4'),
	('C00007','1.14.21.5'),
	('C00007','1.14.21.7'),
	('C00007','1.14.21.8'),
	('C00007','1.14.21.9'),
	('C00007','1.14.19.20'),
	('C00007','1.14.19.21'),
	('C00007','1.14.19.26'),
	('C00007','1.14.19.29'),
	('C00007','1.14.19.3'),
	('C00007','1.14.19.32'),
	('C00007','1.14.19.37'),
	('C00007','1.14.19.39'),
	('C00007','1.14.19.41'),
	('C00007','1.14.19.44'),
	('C00007','1.14.19.6'),
	('C00007','1.14.19.8'),
	('C00007','1.14.19.9'),
	('C00007','1.14.20.1'),
	('C00007','1.14.20.2'),
	('C00007','1.14.17.4'),
	('C00007','1.14.18.1'),
	('C00007','1.14.18.2'),
	('C00007','1.14.18.3'),
	('C00007','1.14.18.4'),
	('C00007','1.14.18.5'),
	('C00007','1.14.18.6'),
	('C00007','1.14.18.7'),
	('C00007','1.14.18.8'),
	('C00007','1.14.19.1'),
	('C00007','1.14.19.10'),
	('C00007','1.14.19.11'),
	('C00007','1.14.19.15'),
	('C00007','1.14.19.17'),
	('C00007','1.14.19.18'),
	('C00007','1.14.19.19'),
	('C00007','1.14.19.2'),
	('C00007','1.14.15.16'),
	('C00007','1.14.15.17'),
	('C00007','1.14.15.18'),
	('C00007','1.14.15.19'),
	('C00007','1.3.99.28'),
	('C00007','1.3.99.30'),
	('C00007','1.3.99.31'),
	('C00007','1.3.3.4'),
	('C00007','1.3.3.5'),
	('C00007','1.3.3.6'),
	('C00007','1.3.3.7'),
	('C00007','1.3.3.8'),
	('C00007','1.3.3.9'),
	('C00007','1.3.5.6'),
	('C00007','1.3.3.10'),
	('C00007','1.3.3.11'),
	('C00007','1.3.3.12'),
	('C00007','1.3.3.13'),
	('C00007','1.3.3.14'),
	('C00007','1.3.3.15'),
	('C00007','1.3.3.3'),
	('C00007','1.21.98.2'),
	('C00007','1.21.3.1'),
	('C00007','1.21.3.2'),
	('C00007','1.21.3.3'),
	('C00007','1.21.3.4'),
	('C00007','1.21.3.5'),
	('C00007','1.21.3.6'),
	('C00007','1.21.3.8'),
	('C00007','1.2.2.4'),
	('C00007','1.2.3.1'),
	('C00007','1.2.3.13'),
	('C00007','1.2.3.14'),
	('C00007','1.2.3.15'),
	('C00007','1.2.3.3'),
	('C00007','1.2.3.4'),
	('C00007','1.2.3.5'),
	('C00007','1.2.3.6'),
	('C00007','1.2.3.7'),
	('C00007','1.2.3.8'),
	('C00007','1.2.3.9'),
	('C00007','1.17.3.1'),
	('C00007','1.17.3.2'),
	('C00007','1.17.3.3'),
	('C00007','1.14.99.51'),
	('C00007','1.14.99.52'),
	('C00007','1.15.1.1'),
	('C00007','1.16.3.1'),
	('C00007','1.14.99.29'),
	('C00007','1.14.99.34'),
	('C00007','1.14.99.35'),
	('C00007','1.14.99.37'),
	('C00007','1.14.99.38'),
	('C00007','1.14.99.39'),
	('C00007','1.14.99.4'),
	('C00007','1.14.99.42'),
	('C00007','1.14.99.43'),
	('C00007','1.14.99.44'),
	('C00007','1.14.99.45'),
	('C00007','1.14.99.46'),
	('C00007','1.14.99.47'),
	('C00007','1.14.99.48'),
	('C00007','1.14.99.49'),
	('C00007','1.14.99.50'),
	('C00007','1.14.99.1'),
	('C00007','1.14.99.11'),
	('C00007','4.1.99.5'),
	('C00007','4.1.1.90'),
	('C00007','4.1.1.39'),
	('C00007','1.9.3.1'),
	('C00007','1.8.3.1'),
	('C00007','1.8.3.2'),
	('C00007','1.8.3.3'),
	('C00007','1.8.3.4'),
	('C00007','1.8.3.5'),
	('C00007','1.8.3.6'),
	('C00007','1.7.3.1'),
	('C00007','1.7.3.2'),
	('C00007','1.7.3.3'),
	('C00007','1.7.3.5'),
	('C00007','1.7.3.6'),
	('C00007','1.7.2.1'),
	('C00007','1.6.3.1'),
	('C00007','1.6.3.2'),
	('C00007','1.6.3.3'),
	('C00007','1.6.3.4'),
	('C00007','1.6.3.5'),
	('C00007','1.5.3.21'),
	('C00007','1.5.3.22'),
	('C00007','1.5.3.4'),
	('C00007','1.5.3.5'),
	('C00007','1.5.3.6'),
	('C00007','1.5.3.7'),
	('C00007','1.5.99.6'),
	('C00007','1.5.3.1'),
	('C00007','1.5.3.10'),
	('C00007','1.5.3.12'),
	('C00007','1.5.3.13'),
	('C00007','1.5.3.14'),
	('C00007','1.5.3.15'),
	('C00007','1.5.3.16'),
	('C00007','1.5.3.17'),
	('C00007','1.5.3.18'),
	('C00007','1.5.3.19'),
	('C00007','1.5.3.2'),
	('C00007','1.4.3.22'),
	('C00007','1.4.3.23'),
	('C00007','1.4.3.24'),
	('C00007','1.4.3.3'),
	('C00007','1.4.3.4'),
	('C00007','1.4.3.5'),
	('C00007','1.4.3.7'),
	('C00007','1.4.3.8'),
	('C00007','1.4.9.2'),
	('C00007','1.4.3.10'),
	('C00007','1.4.3.11'),
	('C00007','1.4.3.12'),
	('C00007','1.4.3.13'),
	('C00007','1.4.3.14'),
	('C00007','1.4.3.15'),
	('C00007','1.4.3.16'),
	('C00007','1.4.3.19'),
	('C00007','1.4.3.2'),
	('C00007','1.4.3.20'),
	('C00007','1.4.3.21'),
	('C00007','1.4.3.1'),
	('C00007','1.3.99.26'),
	('C00008','6.5.1.7'),
	('C00008','6.6.1.1'),
	('C00008','6.6.1.2'),
	('C00008','6.3.5.9'),
	('C00008','6.4.1.1'),
	('C00008','6.4.1.2'),
	('C00008','6.4.1.3'),
	('C00008','6.4.1.4'),
	('C00008','6.4.1.5'),
	('C00008','6.4.1.7'),
	('C00008','6.4.1.8'),
	('C00008','6.3.5.10'),
	('C00008','6.3.5.11'),
	('C00008','6.3.5.3'),
	('C00008','6.3.5.5'),
	('C00008','6.3.5.6'),
	('C00008','6.3.5.7'),
	('C00008','6.3.4.20'),
	('C00008','6.3.4.21'),
	('C00008','6.3.4.23'),
	('C00008','6.3.4.24'),
	('C00008','6.3.4.3'),
	('C00008','6.3.4.6'),
	('C00008','6.3.4.7'),
	('C00008','6.3.4.8'),
	('C00008','6.3.3.1'),
	('C00008','6.3.3.2'),
	('C00008','6.3.3.3'),
	('C00008','6.3.3.5'),
	('C00008','6.3.4.12'),
	('C00008','6.3.4.13'),
	('C00008','6.3.4.14'),
	('C00008','6.3.4.16'),
	('C00008','6.3.4.17'),
	('C00008','6.3.4.18'),
	('C00008','6.3.4.2'),
	('C00008','6.3.2.4'),
	('C00008','6.3.2.41'),
	('C00008','6.3.2.42'),
	('C00008','6.3.2.43'),
	('C00008','6.3.2.44'),
	('C00008','6.3.2.45'),
	('C00008','6.3.2.47'),
	('C00008','6.3.2.48'),
	('C00008','6.3.2.49'),
	('C00008','6.3.2.6'),
	('C00008','6.3.2.7'),
	('C00008','6.3.2.8'),
	('C00008','6.3.2.9'),
	('C00008','6.3.2.20'),
	('C00008','6.3.2.23'),
	('C00008','6.3.2.25'),
	('C00008','6.3.2.29'),
	('C00008','6.3.2.3'),
	('C00008','6.3.2.30'),
	('C00008','6.3.2.32'),
	('C00008','6.3.2.33'),
	('C00008','6.3.2.35'),
	('C00008','6.3.2.37'),
	('C00008','6.3.1.6'),
	('C00008','6.3.1.8'),
	('C00008','6.3.1.9'),
	('C00008','6.3.2.10'),
	('C00008','6.3.2.11'),
	('C00008','6.3.2.12'),
	('C00008','6.3.2.13'),
	('C00008','6.3.2.16'),
	('C00008','6.3.2.17'),
	('C00008','6.3.2.18'),
	('C00008','6.3.2.2'),
	('C00008','6.2.1.9'),
	('C00008','6.3.1.10'),
	('C00008','6.3.1.11'),
	('C00008','6.3.1.12'),
	('C00008','6.3.1.17'),
	('C00008','6.3.1.18'),
	('C00008','6.3.1.19'),
	('C00008','6.3.1.2'),
	('C00008','6.3.1.4'),
	('C00008','6.2.1.39'),
	('C00008','6.2.1.5'),
	('C00008','6.2.1.6'),
	('C00008','6.1.2.1'),
	('C00008','6.2.1.13'),
	('C00008','6.2.1.18'),
	('C00008','4.2.1.93'),
	('C00008','4.2.1.136'),
	('C00008','4.1.1.99'),
	('C00008','4.1.1.33'),
	('C00008','4.1.1.49'),
	('C00008','3.6.3.9'),
	('C00008','3.6.4.1'),
	('C00008','3.6.4.10'),
	('C00008','3.6.4.11'),
	('C00008','3.6.4.12'),
	('C00008','3.6.4.13'),
	('C00008','3.6.4.2'),
	('C00008','3.6.4.3'),
	('C00008','3.6.4.4'),
	('C00008','3.6.4.5'),
	('C00008','3.6.4.6'),
	('C00008','3.6.4.7'),
	('C00008','3.6.4.8'),
	('C00008','3.6.4.9'),
	('C00008','3.6.3.43'),
	('C00008','3.6.3.44'),
	('C00008','3.6.3.46'),
	('C00008','3.6.3.47'),
	('C00008','3.6.3.48'),
	('C00008','3.6.3.49'),
	('C00008','3.6.3.5'),
	('C00008','3.6.3.50'),
	('C00008','3.6.3.51'),
	('C00008','3.6.3.52'),
	('C00008','3.6.3.53'),
	('C00008','3.6.3.54'),
	('C00008','3.6.3.55'),
	('C00008','3.6.3.6'),
	('C00008','3.6.3.7'),
	('C00008','3.6.3.8'),
	('C00008','3.6.3.29'),
	('C00008','3.6.3.3'),
	('C00008','3.6.3.30'),
	('C00008','3.6.3.31'),
	('C00008','3.6.3.32'),
	('C00008','3.6.3.33'),
	('C00008','3.6.3.34'),
	('C00008','3.6.3.35'),
	('C00008','3.6.3.36'),
	('C00008','3.6.3.37'),
	('C00008','3.6.3.38'),
	('C00008','3.6.3.39'),
	('C00008','3.6.3.4'),
	('C00008','3.6.3.40'),
	('C00008','3.6.3.41'),
	('C00008','3.6.3.42'),
	('C00008','3.6.3.14'),
	('C00008','3.6.3.15'),
	('C00008','3.6.3.16'),
	('C00008','3.6.3.17'),
	('C00008','3.6.3.18'),
	('C00008','3.6.3.19'),
	('C00008','3.6.3.2'),
	('C00008','3.6.3.20'),
	('C00008','3.6.3.21'),
	('C00008','3.6.3.22'),
	('C00008','3.6.3.23'),
	('C00008','3.6.3.24'),
	('C00008','3.6.3.25'),
	('C00008','3.6.3.26'),
	('C00008','3.6.3.27'),
	('C00008','3.6.3.28'),
	('C00008','3.6.1.8'),
	('C00008','3.6.3.1'),
	('C00008','3.6.3.10'),
	('C00008','3.6.3.11'),
	('C00008','3.6.3.12'),
	('C00008','3.6.1.29'),
	('C00008','3.6.1.3'),
	('C00008','3.6.1.41'),
	('C00008','3.6.1.5'),
	('C00008','3.6.1.61'),
	('C00008','3.6.1.15'),
	('C00008','3.5.4.7'),
	('C00008','3.5.4.17'),
	('C00008','3.5.2.14'),
	('C00008','3.5.2.9'),
	('C00008','2.7.7.89'),
	('C00008','2.7.7.8'),
	('C00008','2.7.7.35'),
	('C00008','2.7.7.36'),
	('C00008','2.7.7.5'),
	('C00008','2.7.7.53'),
	('C00008','2.7.4.7'),
	('C00008','2.7.4.8'),
	('C00008','2.7.4.9'),
	('C00008','2.7.3.7'),
	('C00008','2.7.3.8'),
	('C00008','2.7.4.1'),
	('C00008','2.7.4.10'),
	('C00008','2.7.4.11'),
	('C00008','2.7.4.12'),
	('C00008','2.7.4.13'),
	('C00008','2.7.4.14'),
	('C00008','2.7.4.15'),
	('C00008','2.7.4.16'),
	('C00008','2.7.4.18'),
	('C00008','2.7.4.19'),
	('C00008','2.7.4.2'),
	('C00008','2.7.4.21'),
	('C00008','2.7.4.22'),
	('C00008','2.7.4.23'),
	('C00008','2.7.4.24'),
	('C00008','2.7.4.25'),
	('C00008','2.7.4.26'),
	('C00008','2.7.4.3'),
	('C00008','2.7.4.31'),
	('C00008','2.7.4.4'),
	('C00008','2.7.4.6'),
	('C00008','2.7.12.1'),
	('C00008','2.7.12.2'),
	('C00008','2.7.13.1'),
	('C00008','2.7.13.2'),
	('C00008','2.7.14.1'),
	('C00008','2.7.2.1'),
	('C00008','2.7.2.11'),
	('C00008','2.7.2.13'),
	('C00008','2.7.2.14'),
	('C00008','2.7.2.15'),
	('C00008','2.7.2.2'),
	('C00008','2.7.2.3'),
	('C00008','2.7.2.4'),
	('C00008','2.7.2.6'),
	('C00008','2.7.2.7'),
	('C00008','2.7.2.8'),
	('C00008','2.7.3.1'),
	('C00008','2.7.3.10'),
	('C00008','2.7.3.2'),
	('C00008','2.7.3.3'),
	('C00008','2.7.3.4'),
	('C00008','2.7.3.5'),
	('C00008','2.7.3.6'),
	('C00008','2.7.11.12'),
	('C00008','2.7.11.13'),
	('C00008','2.7.11.14'),
	('C00008','2.7.11.15'),
	('C00008','2.7.11.17'),
	('C00008','2.7.11.18'),
	('C00008','2.7.11.19'),
	('C00008','2.7.11.2'),
	('C00008','2.7.11.21'),
	('C00008','2.7.11.22'),
	('C00008','2.7.11.23'),
	('C00008','2.7.11.24'),
	('C00008','2.7.11.25'),
	('C00008','2.7.11.26'),
	('C00008','2.7.11.27'),
	('C00008','2.7.11.28'),
	('C00008','2.7.11.29'),
	('C00008','2.7.11.3'),
	('C00008','2.7.11.30'),
	('C00008','2.7.11.31'),
	('C00008','2.7.11.4'),
	('C00008','2.7.11.5'),
	('C00008','2.7.11.6'),
	('C00008','2.7.11.7'),
	('C00008','2.7.11.8'),
	('C00008','2.7.11.9'),
	('C00008','2.7.1.71'),
	('C00008','2.7.1.72'),
	('C00008','2.7.1.73'),
	('C00008','2.7.1.74'),
	('C00008','2.7.1.76'),
	('C00008','2.7.1.78'),
	('C00008','2.7.1.8'),
	('C00008','2.7.1.82'),
	('C00008','2.7.1.83'),
	('C00008','2.7.1.84'),
	('C00008','2.7.1.85'),
	('C00008','2.7.1.86'),
	('C00008','2.7.1.87'),
	('C00008','2.7.1.88'),
	('C00008','2.7.1.89'),
	('C00008','2.7.1.91'),
	('C00008','2.7.1.92'),
	('C00008','2.7.1.93'),
	('C00008','2.7.1.94'),
	('C00008','2.7.1.95'),
	('C00008','2.7.10.1'),
	('C00008','2.7.10.2'),
	('C00008','2.7.11.1'),
	('C00008','2.7.11.10'),
	('C00008','2.7.11.11'),
	('C00008','2.7.1.44'),
	('C00008','2.7.1.45'),
	('C00008','2.7.1.46'),
	('C00008','2.7.1.47'),
	('C00008','2.7.1.48'),
	('C00008','2.7.1.49'),
	('C00008','2.7.1.5'),
	('C00008','2.7.1.50'),
	('C00008','2.7.1.51'),
	('C00008','2.7.1.52'),
	('C00008','2.7.1.53'),
	('C00008','2.7.1.54'),
	('C00008','2.7.1.55'),
	('C00008','2.7.1.56'),
	('C00008','2.7.1.58'),
	('C00008','2.7.1.59'),
	('C00008','2.7.1.6'),
	('C00008','2.7.1.60'),
	('C00008','2.7.1.64'),
	('C00008','2.7.1.65'),
	('C00008','2.7.1.66'),
	('C00008','2.7.1.67'),
	('C00008','2.7.1.68'),
	('C00008','2.7.1.7'),
	('C00008','2.7.1.21'),
	('C00008','2.7.1.22'),
	('C00008','2.7.1.23'),
	('C00008','2.7.1.24'),
	('C00008','2.7.1.25'),
	('C00008','2.7.1.26'),
	('C00008','2.7.1.27'),
	('C00008','2.7.1.28'),
	('C00008','2.7.1.29'),
	('C00008','2.7.1.3'),
	('C00008','2.7.1.30'),
	('C00008','2.7.1.31'),
	('C00008','2.7.1.32'),
	('C00008','2.7.1.33'),
	('C00008','2.7.1.34'),
	('C00008','2.7.1.35'),
	('C00008','2.7.1.36'),
	('C00008','2.7.1.39'),
	('C00008','2.7.1.4'),
	('C00008','2.7.1.40'),
	('C00008','2.7.1.43'),
	('C00008','2.7.1.164'),
	('C00008','2.7.1.165'),
	('C00008','2.7.1.166'),
	('C00008','2.7.1.167'),
	('C00008','2.7.1.168'),
	('C00008','2.7.1.169'),
	('C00008','2.7.1.17'),
	('C00008','2.7.1.170'),
	('C00008','2.7.1.173'),
	('C00008','2.7.1.175'),
	('C00008','2.7.1.176'),
	('C00008','2.7.1.177'),
	('C00008','2.7.1.178'),
	('C00008','2.7.1.179'),
	('C00008','2.7.1.18'),
	('C00008','2.7.1.181'),
	('C00008','2.7.1.184'),
	('C00008','2.7.1.185'),
	('C00008','2.7.1.186'),
	('C00008','2.7.1.187'),
	('C00008','2.7.1.188'),
	('C00008','2.7.1.189'),
	('C00008','2.7.1.19'),
	('C00008','2.7.1.2'),
	('C00008','2.7.1.20'),
	('C00008','2.7.1.13'),
	('C00008','2.7.1.130'),
	('C00008','2.7.1.134'),
	('C00008','2.7.1.136'),
	('C00008','2.7.1.137'),
	('C00008','2.7.1.138'),
	('C00008','2.7.1.14'),
	('C00008','2.7.1.140'),
	('C00008','2.7.1.144'),
	('C00008','2.7.1.145'),
	('C00008','2.7.1.146'),
	('C00008','2.7.1.147'),
	('C00008','2.7.1.148'),
	('C00008','2.7.1.149'),
	('C00008','2.7.1.15'),
	('C00008','2.7.1.150'),
	('C00008','2.7.1.151'),
	('C00008','2.7.1.153'),
	('C00008','2.7.1.154'),
	('C00008','2.7.1.156'),
	('C00008','2.7.1.157'),
	('C00008','2.7.1.158'),
	('C00008','2.7.1.159'),
	('C00008','2.7.1.16'),
	('C00008','2.7.1.162'),
	('C00008','2.7.1.163'),
	('C00008','2.7.1.1'),
	('C00008','2.7.1.10'),
	('C00008','2.7.1.100'),
	('C00008','2.7.1.101'),
	('C00008','2.7.1.102'),
	('C00008','2.7.1.103'),
	('C00008','2.7.1.105'),
	('C00008','2.7.1.107'),
	('C00008','2.7.1.11'),
	('C00008','2.7.1.113'),
	('C00008','2.7.1.118'),
	('C00008','2.7.1.119'),
	('C00008','2.7.1.12'),
	('C00008','2.7.1.122'),
	('C00008','2.7.1.127'),
	('C00008','2.5.1.112'),
	('C00008','2.4.1.268'),
	('C00008','2.4.1.213'),
	('C00008','2.4.1.242'),
	('C00008','2.4.1.245'),
	('C00008','2.4.1.21'),
	('C00008','2.4.1.113'),
	('C00008','2.4.1.13'),
	('C00008','2.3.3.8'),
	('C00008','1.3.7.15'),
	('C00008','1.3.7.7'),
	('C00008','1.3.7.8'),
	('C00008','1.18.6.1'),
	('C00008','1.19.6.1'),
	('C00008','1.17.4.1'),
	('C00009','2.4.1.329'),
	('C00009','2.4.1.332'),
	('C00009','2.4.1.333'),
	('C00009','2.4.1.334'),
	('C00009','2.4.1.279'),
	('C00009','2.4.1.280'),
	('C00009','2.4.1.281'),
	('C00009','2.4.1.282'),
	('C00009','2.4.1.30'),
	('C00009','2.4.1.216'),
	('C00009','2.4.1.230'),
	('C00009','2.4.1.231'),
	('C00009','2.4.1.247'),
	('C00009','2.4.1.20'),
	('C00009','2.4.1.211'),
	('C00009','2.4.1.139'),
	('C00009','2.4.1.1'),
	('C00009','2.3.3.15'),
	('C00009','2.3.3.8'),
	('C00009','2.3.1.8'),
	('C00009','2.3.1.32'),
	('C00009','2.3.1.222'),
	('C00009','2.3.1.19'),
	('C00009','2.1.3.11'),
	('C00009','2.1.3.12'),
	('C00009','2.1.3.2'),
	('C00009','2.1.3.3'),
	('C00009','2.1.3.5'),
	('C00009','2.1.3.6'),
	('C00009','2.1.3.7'),
	('C00009','2.1.3.8'),
	('C00009','2.1.3.9'),
	('C00009','1.3.7.15'),
	('C00009','1.3.7.7'),
	('C00009','1.3.7.8'),
	('C00009','1.21.4.3'),
	('C00009','1.21.4.4'),
	('C00009','1.20.1.1'),
	('C00009','1.21.4.2'),
	('C00009','1.2.3.3'),
	('C00009','1.2.1.59'),
	('C00009','1.2.1.41'),
	('C00009','1.2.1.38'),
	('C00009','1.18.6.1'),
	('C00009','1.19.6.1'),
	('C00009','1.2.1.11'),
	('C00009','1.2.1.12'),
	('C00009','1.2.1.13'),
	('C00009','1.14.11.49'),
	('C00009','1.13.11.78'),
	('C00009','3.1.3.17'),
	('C00009','2.9.1.1'),
	('C00009','2.9.1.2'),
	('C00009','2.7.9.3'),
	('C00009','2.7.99.1'),
	('C00009','2.7.7.89'),
	('C00009','2.7.9.1'),
	('C00009','2.7.9.2'),
	('C00009','2.7.7.69'),
	('C00009','2.7.7.78'),
	('C00009','2.7.7.8'),
	('C00009','2.7.7.35'),
	('C00009','2.7.7.36'),
	('C00009','2.7.7.37'),
	('C00009','2.7.7.5'),
	('C00009','2.7.7.53'),
	('C00009','2.7.7.56'),
	('C00009','2.7.7.22'),
	('C00009','2.7.2.12'),
	('C00009','2.7.1.79'),
	('C00009','2.7.1.80'),
	('C00009','2.7.1.90'),
	('C00009','2.7.1.143'),
	('C00009','2.6.99.2'),
	('C00009','2.5.1.95'),
	('C00009','2.5.1.97'),
	('C00009','2.5.1.54'),
	('C00009','2.5.1.55'),
	('C00009','2.5.1.56'),
	('C00009','2.5.1.57'),
	('C00009','2.5.1.6'),
	('C00009','2.5.1.65'),
	('C00009','2.5.1.66'),
	('C00009','2.5.1.7'),
	('C00009','2.5.1.72'),
	('C00009','2.5.1.73'),
	('C00009','2.5.1.76'),
	('C00009','2.5.1.78'),
	('C00009','2.5.1.129'),
	('C00009','2.5.1.19'),
	('C00009','2.5.1.48'),
	('C00009','2.4.99.16'),
	('C00009','2.5.1.101'),
	('C00009','2.5.1.113'),
	('C00009','2.4.1.97'),
	('C00009','2.4.2.1'),
	('C00009','2.4.2.15'),
	('C00009','2.4.2.16'),
	('C00009','2.4.2.2'),
	('C00009','2.4.2.28'),
	('C00009','2.4.2.3'),
	('C00009','2.4.2.4'),
	('C00009','2.4.2.44'),
	('C00009','2.4.2.57'),
	('C00009','2.4.1.49'),
	('C00009','2.4.1.64'),
	('C00009','2.4.1.7'),
	('C00009','2.4.1.8'),
	('C00009','2.4.1.31'),
	('C00009','2.4.1.319'),
	('C00009','2.4.1.320'),
	('C00009','2.4.1.321'),
	('C00009','3.1.3.48'),
	('C00009','3.1.3.49'),
	('C00009','3.1.3.5'),
	('C00009','3.1.3.50'),
	('C00009','3.1.3.51'),
	('C00009','3.1.3.52'),
	('C00009','3.1.3.53'),
	('C00009','3.1.3.54'),
	('C00009','3.1.3.55'),
	('C00009','3.1.3.56'),
	('C00009','3.1.3.57'),
	('C00009','3.1.3.58'),
	('C00009','3.1.3.59'),
	('C00009','3.1.3.6'),
	('C00009','3.1.3.60'),
	('C00009','3.1.3.62'),
	('C00009','3.1.3.63'),
	('C00009','3.1.3.64'),
	('C00009','3.1.3.66'),
	('C00009','3.1.3.67'),
	('C00009','3.1.3.68'),
	('C00009','3.1.3.69'),
	('C00009','3.1.3.7'),
	('C00009','3.1.3.70'),
	('C00009','3.1.3.18'),
	('C00009','3.1.3.19'),
	('C00009','3.1.3.2'),
	('C00009','3.1.3.20'),
	('C00009','3.1.3.21'),
	('C00009','3.1.3.22'),
	('C00009','3.1.3.23'),
	('C00009','3.1.3.24'),
	('C00009','3.1.3.25'),
	('C00009','3.1.3.26'),
	('C00009','3.1.3.27'),
	('C00009','3.1.3.28'),
	('C00009','3.1.3.29'),
	('C00009','3.1.3.3'),
	('C00009','3.1.3.31'),
	('C00009','3.1.3.32'),
	('C00009','3.1.3.33'),
	('C00009','3.1.3.34'),
	('C00009','3.1.3.35'),
	('C00009','3.1.3.36'),
	('C00009','3.1.3.37'),
	('C00009','3.1.3.38'),
	('C00009','3.1.3.39'),
	('C00009','3.1.3.4'),
	('C00009','3.1.3.40'),
	('C00009','3.1.3.41'),
	('C00009','3.1.3.42'),
	('C00009','3.1.3.43'),
	('C00009','3.1.3.44'),
	('C00009','3.1.3.1'),
	('C00009','3.1.3.10'),
	('C00009','3.1.3.100'),
	('C00009','3.1.3.101'),
	('C00009','3.1.3.104'),
	('C00009','3.1.3.11'),
	('C00009','3.1.3.12'),
	('C00009','3.1.3.14'),
	('C00009','3.1.3.15'),
	('C00009','3.1.3.16'),
	('C00009','3.6.1.7'),
	('C00009','3.6.1.8'),
	('C00009','3.6.3.1'),
	('C00009','3.6.3.10'),
	('C00009','3.6.3.11'),
	('C00009','3.6.3.12'),
	('C00009','3.6.1.28'),
	('C00009','3.6.1.3'),
	('C00009','3.6.1.39'),
	('C00009','3.6.1.40'),
	('C00009','3.6.1.42'),
	('C00009','3.6.1.43'),
	('C00009','3.6.1.5'),
	('C00009','3.6.1.52'),
	('C00009','3.6.1.58'),
	('C00009','3.6.1.6'),
	('C00009','3.6.1.1'),
	('C00009','3.6.1.11'),
	('C00009','3.6.1.12'),
	('C00009','3.6.1.14'),
	('C00009','3.6.1.15'),
	('C00009','3.6.1.25'),
	('C00009','3.6.1.27'),
	('C00009','3.5.4.29'),
	('C00009','3.5.2.14'),
	('C00009','3.5.2.9'),
	('C00009','3.2.1.23'),
	('C00009','3.11.1.1'),
	('C00009','3.11.1.2'),
	('C00009','3.11.1.3'),
	('C00009','3.1.4.57'),
	('C00009','3.1.3.71'),
	('C00009','3.1.3.72'),
	('C00009','3.1.3.73'),
	('C00009','3.1.3.74'),
	('C00009','3.1.3.75'),
	('C00009','3.1.3.76'),
	('C00009','3.1.3.77'),
	('C00009','3.1.3.78'),
	('C00009','3.1.3.79'),
	('C00009','3.1.3.8'),
	('C00009','3.1.3.80'),
	('C00009','3.1.3.81'),
	('C00009','3.1.3.82'),
	('C00009','3.1.3.83'),
	('C00009','3.1.3.85'),
	('C00009','3.1.3.86'),
	('C00009','3.1.3.87'),
	('C00009','3.1.3.88'),
	('C00009','3.1.3.89'),
	('C00009','3.1.3.9'),
	('C00009','3.1.3.90'),
	('C00009','3.1.3.91'),
	('C00009','3.1.3.92'),
	('C00009','3.1.3.93'),
	('C00009','3.1.3.94'),
	('C00009','3.1.3.95'),
	('C00009','3.1.3.96'),
	('C00009','3.1.3.97'),
	('C00009','3.1.3.99'),
	('C00009','3.1.3.45'),
	('C00009','3.1.3.46'),
	('C00009','3.1.3.47'),
	('C00009','3.6.4.1'),
	('C00009','3.6.4.10'),
	('C00009','3.6.4.11'),
	('C00009','3.6.4.12'),
	('C00009','3.6.4.13'),
	('C00009','3.6.4.2'),
	('C00009','3.6.4.3'),
	('C00009','3.6.4.4'),
	('C00009','3.6.4.5'),
	('C00009','3.6.4.6'),
	('C00009','3.6.4.7'),
	('C00009','3.6.4.8'),
	('C00009','3.6.4.9'),
	('C00009','3.6.5.1'),
	('C00009','3.6.5.2'),
	('C00009','3.6.3.43'),
	('C00009','3.6.3.44'),
	('C00009','3.6.3.46'),
	('C00009','3.6.3.47'),
	('C00009','3.6.3.48'),
	('C00009','3.6.3.49'),
	('C00009','3.6.3.5'),
	('C00009','3.6.3.50'),
	('C00009','3.6.3.51'),
	('C00009','3.6.3.52'),
	('C00009','3.6.3.53'),
	('C00009','3.6.3.54'),
	('C00009','3.6.3.55'),
	('C00009','3.6.3.6'),
	('C00009','3.6.3.7'),
	('C00009','3.6.3.8'),
	('C00009','3.6.3.29'),
	('C00009','3.6.3.3'),
	('C00009','3.6.3.30'),
	('C00009','3.6.3.31'),
	('C00009','3.6.3.32'),
	('C00009','3.6.3.33'),
	('C00009','3.6.3.34'),
	('C00009','3.6.3.35'),
	('C00009','3.6.3.36'),
	('C00009','3.6.3.37'),
	('C00009','3.6.3.38'),
	('C00009','3.6.3.39'),
	('C00009','3.6.3.4'),
	('C00009','3.6.3.40'),
	('C00009','3.6.3.41'),
	('C00009','3.6.3.42'),
	('C00009','3.6.3.14'),
	('C00009','3.6.3.15'),
	('C00009','3.6.3.16'),
	('C00009','3.6.3.17'),
	('C00009','3.6.3.18'),
	('C00009','3.6.3.19'),
	('C00009','3.6.3.2'),
	('C00009','3.6.3.20'),
	('C00009','3.6.3.21'),
	('C00009','3.6.3.22'),
	('C00009','3.6.3.23'),
	('C00009','3.6.3.24'),
	('C00009','3.6.3.25'),
	('C00009','3.6.3.26'),
	('C00009','3.6.3.27'),
	('C00009','3.6.3.28'),
	('C00009','3.6.1.64'),
	('C00009','6.3.2.35'),
	('C00009','6.3.2.37'),
	('C00009','6.3.1.6'),
	('C00009','6.3.1.8'),
	('C00009','6.3.1.9'),
	('C00009','6.3.2.10'),
	('C00009','6.3.2.11'),
	('C00009','6.3.2.12'),
	('C00009','6.3.2.13'),
	('C00009','6.3.2.16'),
	('C00009','6.3.2.17'),
	('C00009','6.3.2.18'),
	('C00009','6.3.2.2'),
	('C00009','6.2.1.9'),
	('C00009','6.3.1.10'),
	('C00009','6.3.1.11'),
	('C00009','6.3.1.12'),
	('C00009','6.3.1.17'),
	('C00009','6.3.1.18'),
	('C00009','6.3.1.19'),
	('C00009','6.3.1.2'),
	('C00009','6.3.1.4'),
	('C00009','6.2.1.39'),
	('C00009','6.2.1.4'),
	('C00009','6.2.1.5'),
	('C00009','6.2.1.6'),
	('C00009','6.1.2.1'),
	('C00009','6.1.2.2'),
	('C00009','6.2.1.10'),
	('C00009','6.2.1.13'),
	('C00009','6.2.1.18'),
	('C00009','4.3.3.6'),
	('C00009','4.2.3.5'),
	('C00009','4.2.3.152'),
	('C00009','4.2.3.153'),
	('C00009','4.2.3.154'),
	('C00009','4.2.3.155'),
	('C00009','4.2.3.2'),
	('C00009','4.2.3.3'),
	('C00009','4.2.3.4'),
	('C00009','4.2.3.1'),
	('C00009','4.2.3.124'),
	('C00009','4.2.3.134'),
	('C00009','4.2.1.93'),
	('C00009','4.2.1.136'),
	('C00009','4.1.99.20'),
	('C00009','4.1.2.22'),
	('C00009','4.1.2.9'),
	('C00009','4.1.1.99'),
	('C00009','4.1.1.31'),
	('C00009','4.1.1.33'),
	('C00009','4.1.1.38'),
	('C00009','3.9.1.1'),
	('C00009','3.9.1.2'),
	('C00009','3.9.1.3'),
	('C00009','3.6.5.3'),
	('C00009','3.6.5.4'),
	('C00009','3.6.5.5'),
	('C00009','3.6.5.6'),
	('C00009','3.6.3.9'),
	('C00009','6.5.1.7'),
	('C00009','6.6.1.1'),
	('C00009','6.6.1.2'),
	('C00009','6.3.5.9'),
	('C00009','6.4.1.1'),
	('C00009','6.4.1.2'),
	('C00009','6.4.1.3'),
	('C00009','6.4.1.4'),
	('C00009','6.4.1.5'),
	('C00009','6.4.1.6'),
	('C00009','6.4.1.7'),
	('C00009','6.4.1.8'),
	('C00009','6.3.5.10'),
	('C00009','6.3.5.11'),
	('C00009','6.3.5.3'),
	('C00009','6.3.5.5'),
	('C00009','6.3.5.6'),
	('C00009','6.3.5.7'),
	('C00009','6.3.4.2'),
	('C00009','6.3.4.20'),
	('C00009','6.3.4.21'),
	('C00009','6.3.4.22'),
	('C00009','6.3.4.23'),
	('C00009','6.3.4.24'),
	('C00009','6.3.4.3'),
	('C00009','6.3.4.4'),
	('C00009','6.3.4.6'),
	('C00009','6.3.4.7'),
	('C00009','6.3.4.8'),
	('C00009','6.3.3.1'),
	('C00009','6.3.3.2'),
	('C00009','6.3.3.3'),
	('C00009','6.3.3.5'),
	('C00009','6.3.4.12'),
	('C00009','6.3.4.13'),
	('C00009','6.3.4.14'),
	('C00009','6.3.4.16'),
	('C00009','6.3.4.17'),
	('C00009','6.3.4.18'),
	('C00009','6.3.2.4'),
	('C00009','6.3.2.41'),
	('C00009','6.3.2.42'),
	('C00009','6.3.2.43'),
	('C00009','6.3.2.44'),
	('C00009','6.3.2.45'),
	('C00009','6.3.2.47'),
	('C00009','6.3.2.48'),
	('C00009','6.3.2.49'),
	('C00009','6.3.2.6'),
	('C00009','6.3.2.7'),
	('C00009','6.3.2.8'),
	('C00009','6.3.2.9'),
	('C00009','6.3.2.20'),
	('C00009','6.3.2.23'),
	('C00009','6.3.2.25'),
	('C00009','6.3.2.29'),
	('C00009','6.3.2.3'),
	('C00009','6.3.2.30'),
	('C00009','6.3.2.31'),
	('C00009','6.3.2.32'),
	('C00009','6.3.2.33'),
	('C00009','6.3.2.34'),
	('C00010','6.2.1.8'),
	('C00010','6.2.1.9'),
	('C00010','3.1.2.20'),
	('C00010','3.1.2.22'),
	('C00010','3.1.2.23'),
	('C00010','3.1.2.25'),
	('C00010','3.1.2.27'),
	('C00010','3.1.2.28'),
	('C00010','3.1.2.29'),
	('C00010','3.1.2.3'),
	('C00010','3.1.2.30'),
	('C00010','3.1.2.4'),
	('C00010','3.1.2.5'),
	('C00010','3.1.2.1'),
	('C00010','3.1.2.10'),
	('C00010','3.1.2.11'),
	('C00010','3.1.2.17'),
	('C00010','3.1.2.18'),
	('C00010','3.1.2.19'),
	('C00010','3.1.2.2'),
	('C00010','2.7.8.7'),
	('C00010','4.2.1.155'),
	('C00010','4.1.3.36'),
	('C00010','6.2.1.15'),
	('C00010','6.2.1.16'),
	('C00010','6.2.1.17'),
	('C00010','4.4.1.26'),
	('C00010','6.2.1.36'),
	('C00010','6.2.1.37'),
	('C00010','6.2.1.38'),
	('C00010','6.2.1.4'),
	('C00010','6.2.1.40'),
	('C00010','6.2.1.41'),
	('C00010','6.2.1.42'),
	('C00010','6.2.1.43'),
	('C00010','6.2.1.44'),
	('C00010','6.2.1.5'),
	('C00010','6.2.1.6'),
	('C00010','6.2.1.7'),
	('C00010','6.2.1.18'),
	('C00010','6.2.1.2'),
	('C00010','6.2.1.23'),
	('C00010','6.2.1.24'),
	('C00010','6.2.1.25'),
	('C00010','6.2.1.26'),
	('C00010','6.2.1.27'),
	('C00010','6.2.1.28'),
	('C00010','6.2.1.3'),
	('C00010','6.2.1.30'),
	('C00010','6.2.1.31'),
	('C00010','6.2.1.32'),
	('C00010','6.2.1.33'),
	('C00010','6.2.1.34'),
	('C00010','6.2.1.1'),
	('C00010','6.2.1.10'),
	('C00010','6.2.1.11'),
	('C00010','6.2.1.12'),
	('C00010','6.2.1.13'),
	('C00010','6.2.1.14'),
	('C00010','2.3.1.223'),
	('C00010','2.3.1.224'),
	('C00010','2.3.1.225'),
	('C00010','2.3.1.226'),
	('C00010','2.3.1.227'),
	('C00010','2.3.1.228'),
	('C00010','2.3.1.229'),
	('C00010','2.3.1.23'),
	('C00010','2.3.1.230'),
	('C00010','2.3.1.232'),
	('C00010','2.3.1.233'),
	('C00010','2.3.1.235'),
	('C00010','2.3.1.236'),
	('C00010','2.3.3.1'),
	('C00010','2.3.3.10'),
	('C00010','2.3.3.11'),
	('C00010','2.3.3.12'),
	('C00010','2.3.3.13'),
	('C00010','2.3.3.14'),
	('C00010','2.3.3.16'),
	('C00010','2.3.3.2'),
	('C00010','2.3.3.3'),
	('C00010','2.3.3.4'),
	('C00010','2.3.3.5'),
	('C00010','2.3.3.6'),
	('C00010','2.3.3.7'),
	('C00010','2.3.3.8'),
	('C00010','2.3.1.8'),
	('C00010','2.3.1.80'),
	('C00010','2.3.1.81'),
	('C00010','2.3.1.82'),
	('C00010','2.3.1.84'),
	('C00010','2.3.1.85'),
	('C00010','2.3.1.86'),
	('C00010','2.3.1.87'),
	('C00010','2.3.1.88'),
	('C00010','2.3.1.89'),
	('C00010','2.3.1.9'),
	('C00010','2.3.1.93'),
	('C00010','2.3.1.94'),
	('C00010','2.3.1.95'),
	('C00010','2.3.1.96'),
	('C00010','2.3.1.97'),
	('C00010','2.3.1.99'),
	('C00010','2.3.1.5'),
	('C00010','2.3.1.50'),
	('C00010','2.3.1.51'),
	('C00010','2.3.1.52'),
	('C00010','2.3.1.53'),
	('C00010','2.3.1.54'),
	('C00010','2.3.1.57'),
	('C00010','2.3.1.58'),
	('C00010','2.3.1.59'),
	('C00010','2.3.1.6'),
	('C00010','2.3.1.60'),
	('C00010','2.3.1.61'),
	('C00010','2.3.1.62'),
	('C00010','2.3.1.63'),
	('C00010','2.3.1.64'),
	('C00010','2.3.3.9'),
	('C00010','2.7.1.24'),
	('C00010','2.6.1.33'),
	('C00010','2.3.1.211'),
	('C00010','2.3.1.212'),
	('C00010','2.3.1.214'),
	('C00010','2.3.1.215'),
	('C00010','2.3.1.216'),
	('C00010','2.3.1.217'),
	('C00010','2.3.1.218'),
	('C00010','2.3.1.219'),
	('C00010','2.3.1.22'),
	('C00010','2.3.1.220'),
	('C00010','2.3.1.221'),
	('C00010','2.3.1.222'),
	('C00010','2.3.1.171'),
	('C00010','2.3.1.172'),
	('C00010','2.3.1.173'),
	('C00010','2.3.1.174'),
	('C00010','2.3.1.175'),
	('C00010','2.3.1.176'),
	('C00010','2.3.1.177'),
	('C00010','2.3.1.178'),
	('C00010','2.3.1.18'),
	('C00010','2.3.1.180'),
	('C00010','2.3.1.182'),
	('C00010','2.3.1.183'),
	('C00010','2.3.1.185'),
	('C00010','2.3.1.186'),
	('C00010','2.3.1.65'),
	('C00010','2.3.1.66'),
	('C00010','2.3.1.67'),
	('C00010','2.3.1.68'),
	('C00010','2.3.1.69'),
	('C00010','2.3.1.7'),
	('C00010','2.3.1.71'),
	('C00010','2.3.1.74'),
	('C00010','2.3.1.75'),
	('C00010','2.3.1.76'),
	('C00010','2.3.1.78'),
	('C00010','2.3.1.79'),
	('C00010','2.3.1.245'),
	('C00010','2.3.1.246'),
	('C00010','2.3.1.248'),
	('C00010','2.3.1.249'),
	('C00010','2.3.1.25'),
	('C00010','2.3.1.250'),
	('C00010','2.3.1.26'),
	('C00010','2.3.1.27'),
	('C00010','2.3.1.28'),
	('C00010','2.3.1.29'),
	('C00010','2.3.1.3'),
	('C00010','2.3.1.30'),
	('C00010','2.3.1.31'),
	('C00010','2.3.1.33'),
	('C00010','2.3.1.34'),
	('C00010','2.3.1.36'),
	('C00010','2.3.1.37'),
	('C00010','2.3.1.38'),
	('C00010','2.3.1.39'),
	('C00010','2.3.1.4'),
	('C00010','2.3.1.42'),
	('C00010','2.3.1.44'),
	('C00010','2.3.1.45'),
	('C00010','2.3.1.46'),
	('C00010','2.3.1.47'),
	('C00010','2.3.1.48'),
	('C00010','2.3.1.196'),
	('C00010','2.3.1.197'),
	('C00010','2.3.1.198'),
	('C00010','2.3.1.151'),
	('C00010','2.3.1.153'),
	('C00010','2.3.1.155'),
	('C00010','2.3.1.156'),
	('C00010','2.3.1.157'),
	('C00010','2.3.1.159'),
	('C00010','2.3.1.16'),
	('C00010','2.3.1.160'),
	('C00010','2.3.1.161'),
	('C00010','2.3.1.162'),
	('C00010','2.3.1.163'),
	('C00010','2.3.1.164'),
	('C00010','2.3.1.165'),
	('C00010','2.3.1.166'),
	('C00010','2.3.1.167'),
	('C00010','2.3.1.168'),
	('C00010','2.3.1.169'),
	('C00010','2.3.1.17'),
	('C00010','2.3.1.170'),
	('C00010','2.3.1.111'),
	('C00010','2.3.1.112'),
	('C00010','2.3.1.113'),
	('C00010','2.3.1.114'),
	('C00010','2.3.1.115'),
	('C00010','2.3.1.116'),
	('C00010','2.3.1.117'),
	('C00010','2.3.1.118'),
	('C00010','2.3.1.12'),
	('C00010','2.3.1.121'),
	('C00010','2.3.1.123'),
	('C00010','2.3.1.125'),
	('C00010','2.3.1.126'),
	('C00010','2.3.1.127'),
	('C00010','2.3.1.128'),
	('C00010','2.3.1.13'),
	('C00010','2.3.1.130'),
	('C00010','2.3.1.131'),
	('C00010','2.3.1.132'),
	('C00010','2.3.1.133'),
	('C00010','2.3.1.136'),
	('C00010','2.3.1.137'),
	('C00010','2.3.1.138'),
	('C00010','2.3.1.139'),
	('C00010','2.3.1.14'),
	('C00010','2.3.1.237'),
	('C00010','2.3.1.239'),
	('C00010','2.3.1.24'),
	('C00010','2.3.1.240'),
	('C00010','2.3.1.199'),
	('C00010','2.3.1.2'),
	('C00010','2.3.1.20'),
	('C00010','2.3.1.201'),
	('C00010','2.3.1.202'),
	('C00010','2.3.1.203'),
	('C00010','2.3.1.205'),
	('C00010','2.3.1.206'),
	('C00010','2.3.1.207'),
	('C00010','2.3.1.208'),
	('C00010','2.3.1.209'),
	('C00010','2.3.1.21'),
	('C00010','2.3.1.210'),
	('C00010','1.13.11.80'),
	('C00010','1.1.1.88'),
	('C00010','1.1.1.34'),
	('C00010','1.2.7.7'),
	('C00010','1.2.7.8'),
	('C00010','1.2.3.6'),
	('C00010','1.2.4.1'),
	('C00010','1.2.1.84'),
	('C00010','1.2.1.87'),
	('C00010','1.2.1.75'),
	('C00010','1.2.1.76'),
	('C00010','1.2.1.81'),
	('C00010','1.2.1.57'),
	('C00010','1.2.1.58'),
	('C00010','1.2.1.42'),
	('C00010','1.2.1.44'),
	('C00010','1.2.1.50'),
	('C00010','1.2.1.51'),
	('C00010','1.2.1.52'),
	('C00010','1.2.1.17'),
	('C00010','1.2.1.18'),
	('C00010','1.2.1.25'),
	('C00010','1.2.1.27'),
	('C00010','1.2.1.10'),
	('C00010','1.2.4.2'),
	('C00010','1.2.7.1'),
	('C00010','1.2.7.11'),
	('C00010','1.2.7.3'),
	('C00010','1.2.7.4'),
	('C00010','1.8.1.4'),
	('C00010','1.8.1.10'),
	('C00010','1.8.4.3'),
	('C00010','1.8.1.14'),
	('C00010','2.1.1.258'),
	('C00010','2.3.1.140'),
	('C00010','2.3.1.142'),
	('C00010','2.3.1.144'),
	('C00010','2.3.1.145'),
	('C00010','2.3.1.146'),
	('C00010','2.3.1.15'),
	('C00010','2.3.1.150'),
	('C00010','2.3.1.1'),
	('C00010','2.3.1.10'),
	('C00010','2.3.1.100'),
	('C00010','2.3.1.102'),
	('C00010','2.3.1.105'),
	('C00010','2.3.1.106'),
	('C00010','2.3.1.107'),
	('C00010','2.3.1.108'),
	('C00010','2.3.1.109'),
	('C00010','2.3.1.11'),
	('C00010','2.3.1.110'),
	('C00010','2.3.1.188'),
	('C00010','2.3.1.189'),
	('C00010','2.3.1.19'),
	('C00010','2.3.1.190'),
	('C00010','2.3.1.192'),
	('C00010','2.3.1.194'),
	('C00010','2.3.1.195'),
	('C00011','4.1.1.89'),
	('C00011','4.1.1.9'),
	('C00011','4.1.1.90'),
	('C00011','4.1.1.91'),
	('C00011','4.1.1.92'),
	('C00011','4.1.1.93'),
	('C00011','4.1.1.94'),
	('C00011','4.1.1.95'),
	('C00011','4.1.1.96'),
	('C00011','4.1.1.97'),
	('C00011','4.1.1.98'),
	('C00011','4.1.1.99'),
	('C00011','4.1.1.30'),
	('C00011','4.1.1.31'),
	('C00011','4.1.1.32'),
	('C00011','4.1.1.33'),
	('C00011','4.1.1.34'),
	('C00011','4.1.1.35'),
	('C00011','4.1.1.36'),
	('C00011','4.1.1.37'),
	('C00011','4.1.1.38'),
	('C00011','4.1.1.39'),
	('C00011','4.1.1.4'),
	('C00011','4.1.1.40'),
	('C00011','4.1.1.41'),
	('C00011','4.1.1.42'),
	('C00011','4.1.1.43'),
	('C00011','4.1.1.44'),
	('C00011','4.1.1.45'),
	('C00011','4.1.1.46'),
	('C00011','4.1.1.47'),
	('C00011','4.1.1.48'),
	('C00011','4.1.1.49'),
	('C00011','4.1.1.5'),
	('C00011','4.1.1.50'),
	('C00011','4.1.1.51'),
	('C00011','4.2.1.51'),
	('C00011','4.2.1.91'),
	('C00011','4.2.1.155'),
	('C00011','4.2.1.41'),
	('C00011','4.2.1.1'),
	('C00011','4.2.1.104'),
	('C00011','4.1.3.44'),
	('C00011','4.1.1.60'),
	('C00011','4.1.1.61'),
	('C00011','4.1.1.62'),
	('C00011','4.1.1.63'),
	('C00011','4.1.1.64'),
	('C00011','4.3.1.13'),
	('C00011','5.5.1.1'),
	('C00011','4.3.99.2'),
	('C00011','4.4.1.27'),
	('C00011','6.4.1.6'),
	('C00011','6.3.3.3'),
	('C00011','6.3.3.5'),
	('C00011','6.3.4.16'),
	('C00011','3.5.1.87'),
	('C00011','3.5.2.15'),
	('C00011','3.5.1.59'),
	('C00011','3.5.1.6'),
	('C00011','4.1.1.52'),
	('C00011','4.1.1.53'),
	('C00011','4.1.1.54'),
	('C00011','4.1.1.55'),
	('C00011','4.1.1.56'),
	('C00011','4.1.1.57'),
	('C00011','4.1.1.58'),
	('C00011','4.1.1.59'),
	('C00011','4.1.1.6'),
	('C00011','4.1.1.1'),
	('C00011','4.1.1.100'),
	('C00011','4.1.1.101'),
	('C00011','4.1.1.102'),
	('C00011','4.1.1.103'),
	('C00011','4.1.1.11'),
	('C00011','4.1.1.12'),
	('C00011','4.1.1.14'),
	('C00011','4.1.1.15'),
	('C00011','4.1.1.16'),
	('C00011','4.1.1.17'),
	('C00011','4.1.1.18'),
	('C00011','4.1.1.19'),
	('C00011','4.1.1.2'),
	('C00011','4.1.1.20'),
	('C00011','4.1.1.21'),
	('C00011','4.1.1.22'),
	('C00011','4.1.1.23'),
	('C00011','4.1.1.24'),
	('C00011','4.1.1.25'),
	('C00011','4.1.1.28'),
	('C00011','4.1.1.29'),
	('C00011','4.1.1.3'),
	('C00011','4.1.1.65'),
	('C00011','4.1.1.66'),
	('C00011','4.1.1.67'),
	('C00011','4.1.1.68'),
	('C00011','4.1.1.69'),
	('C00011','4.1.1.7'),
	('C00011','4.1.1.70'),
	('C00011','4.1.1.71'),
	('C00011','4.1.1.72'),
	('C00011','4.1.1.73'),
	('C00011','4.1.1.74'),
	('C00011','4.1.1.75'),
	('C00011','4.1.1.76'),
	('C00011','4.1.1.77'),
	('C00011','4.1.1.78'),
	('C00011','4.1.1.79'),
	('C00011','4.1.1.8'),
	('C00011','4.1.1.80'),
	('C00011','4.1.1.81'),
	('C00011','4.1.1.82'),
	('C00011','4.1.1.83'),
	('C00011','4.1.1.84'),
	('C00011','4.1.1.85'),
	('C00011','4.1.1.86'),
	('C00011','4.1.1.87'),
	('C00011','4.1.1.88'),
	('C00011','2.3.1.239'),
	('C00011','2.3.1.240'),
	('C00011','2.3.1.199'),
	('C00011','2.3.1.206'),
	('C00011','2.3.1.207'),
	('C00011','2.3.1.208'),
	('C00011','2.3.1.211'),
	('C00011','2.3.1.212'),
	('C00011','2.3.1.216'),
	('C00011','2.3.1.217'),
	('C00011','2.3.1.218'),
	('C00011','2.3.1.219'),
	('C00011','2.3.1.220'),
	('C00011','2.3.1.221'),
	('C00011','2.3.1.170'),
	('C00011','2.3.1.177'),
	('C00011','2.3.1.179'),
	('C00011','2.3.1.180'),
	('C00011','2.3.1.74'),
	('C00011','2.3.1.246'),
	('C00011','2.3.1.37'),
	('C00011','2.3.1.41'),
	('C00011','2.3.1.47'),
	('C00011','2.3.1.226'),
	('C00011','2.3.1.230'),
	('C00011','2.3.1.231'),
	('C00011','2.3.1.233'),
	('C00011','2.3.1.235'),
	('C00011','2.3.1.85'),
	('C00011','2.3.1.86'),
	('C00011','2.3.1.94'),
	('C00011','2.3.1.95'),
	('C00011','2.3.1.50'),
	('C00011','2.3.1.61'),
	('C00011','2.4.2.54'),
	('C00011','2.5.1.115'),
	('C00011','2.5.1.116'),
	('C00011','2.5.1.117'),
	('C00011','2.4.2.19'),
	('C00011','2.5.1.74'),
	('C00011','2.5.1.3'),
	('C00011','2.7.2.2'),
	('C00011','3.1.1.78'),
	('C00011','3.1.1.82'),
	('C00011','3.1.1.1'),
	('C00011','2.7.8.23'),
	('C00011','3.5.1.64'),
	('C00011','3.5.1.66'),
	('C00011','3.5.1.7'),
	('C00011','3.5.1.75'),
	('C00011','3.5.1.77'),
	('C00011','3.5.1.84'),
	('C00011','3.5.1.5'),
	('C00011','3.5.1.53'),
	('C00011','3.5.1.54'),
	('C00011','3.5.1.58'),
	('C00011','3.5.1.20'),
	('C00011','3.5.1.29'),
	('C00011','3.5.1.110'),
	('C00011','3.5.1.116'),
	('C00011','3.5.3.21'),
	('C00011','3.5.3.23'),
	('C00011','3.5.3.9'),
	('C00011','1.14.20.3'),
	('C00011','1.14.20.1'),
	('C00011','1.14.20.2'),
	('C00011','1.14.17.4'),
	('C00011','1.14.13.64'),
	('C00011','1.14.13.72'),
	('C00011','1.3.98.3'),
	('C00011','1.3.8.6'),
	('C00011','1.3.1.85'),
	('C00011','1.3.3.3'),
	('C00011','1.3.1.67'),
	('C00011','1.3.1.68'),
	('C00011','1.3.1.78'),
	('C00011','1.3.1.79'),
	('C00011','1.3.1.53'),
	('C00011','1.3.1.25'),
	('C00011','1.3.1.43'),
	('C00011','1.3.1.12'),
	('C00011','1.3.1.13'),
	('C00011','1.2.7.8'),
	('C00011','1.2.99.5'),
	('C00011','1.2.99.9'),
	('C00011','1.2.4.1'),
	('C00011','1.2.4.2'),
	('C00011','1.2.4.4'),
	('C00011','1.2.5.1'),
	('C00011','1.2.5.3'),
	('C00011','1.2.7.1'),
	('C00011','1.2.7.10'),
	('C00011','1.2.7.11'),
	('C00011','1.2.7.3'),
	('C00011','1.2.7.4'),
	('C00011','1.8.1.4'),
	('C00011','1.8.1.5'),
	('C00011','1.7.3.3'),
	('C00011','1.5.1.6'),
	('C00011','1.4.4.2'),
	('C00011','1.4.99.5'),
	('C00011','2.1.1.132'),
	('C00011','2.1.1.196'),
	('C00011','2.3.1.146'),
	('C00011','2.2.1.12'),
	('C00011','2.2.1.5'),
	('C00011','2.2.1.6'),
	('C00011','2.2.1.7'),
	('C00011','2.2.1.9'),
	('C00011','2.1.2.10'),
	('C00011','2.3.1.194'),
	('C00011','2.3.1.151'),
	('C00011','2.3.1.156'),
	('C00011','2.3.1.159'),
	('C00011','2.3.1.161'),
	('C00011','2.3.1.165'),
	('C00011','2.3.1.169'),
	('C00011','2.3.1.111'),
	('C00011','2.3.1.12'),
	('C00011','2.3.1.236'),
	('C00011','2.3.1.237'),
	('C00011','1.14.11.9'),
	('C00011','1.14.12.1'),
	('C00011','1.14.12.13'),
	('C00011','1.14.11.40'),
	('C00011','1.14.11.41'),
	('C00011','1.14.11.42'),
	('C00011','1.14.11.43'),
	('C00011','1.14.11.44'),
	('C00011','1.14.11.45'),
	('C00011','1.14.11.46'),
	('C00011','1.14.11.48'),
	('C00011','1.14.11.49'),
	('C00011','1.14.11.50'),
	('C00011','1.14.11.51'),
	('C00011','1.14.11.52'),
	('C00011','1.14.11.6'),
	('C00011','1.14.11.7'),
	('C00011','1.14.11.26'),
	('C00011','1.14.11.27'),
	('C00011','1.14.11.28'),
	('C00011','1.14.11.3'),
	('C00011','1.14.11.31'),
	('C00011','1.14.11.32'),
	('C00011','1.14.11.34'),
	('C00011','1.14.11.35'),
	('C00011','1.14.11.36'),
	('C00011','1.14.11.37'),
	('C00011','1.14.11.38'),
	('C00011','1.14.11.39'),
	('C00011','1.14.11.4'),
	('C00011','1.14.11.12'),
	('C00011','1.14.11.13'),
	('C00011','1.14.11.14'),
	('C00011','1.14.11.15'),
	('C00011','1.14.11.16'),
	('C00011','1.14.11.17'),
	('C00011','1.14.11.18'),
	('C00011','1.14.11.19'),
	('C00011','1.14.11.2'),
	('C00011','1.14.11.20'),
	('C00011','1.14.11.21'),
	('C00011','1.14.11.22'),
	('C00011','1.14.11.23'),
	('C00011','1.14.11.24'),
	('C00011','1.14.11.25'),
	('C00011','1.2.7.7'),
	('C00011','1.2.2.4'),
	('C00011','1.2.3.13'),
	('C00011','1.2.3.3'),
	('C00011','1.2.3.4'),
	('C00011','1.2.3.6'),
	('C00011','1.2.2.1'),
	('C00011','1.2.2.3'),
	('C00011','1.2.1.58'),
	('C00011','1.2.1.43'),
	('C00011','1.2.1.51'),
	('C00011','1.2.1.52'),
	('C00011','1.2.1.18'),
	('C00011','1.2.1.2'),
	('C00011','1.2.1.25'),
	('C00011','1.2.1.27'),
	('C00011','1.14.99.21'),
	('C00011','1.13.12.3'),
	('C00011','1.13.12.4'),
	('C00011','1.13.12.5'),
	('C00011','1.13.12.6'),
	('C00011','1.13.12.7'),
	('C00011','1.13.12.8'),
	('C00011','1.13.12.9'),
	('C00011','1.13.99.3'),
	('C00011','1.14.11.1'),
	('C00011','1.14.11.10'),
	('C00011','1.14.11.11'),
	('C00011','1.13.12.1'),
	('C00011','1.13.12.13'),
	('C00011','1.13.12.17'),
	('C00011','1.13.12.19'),
	('C00011','1.13.12.2'),
	('C00011','1.13.11.46'),
	('C00011','1.13.11.23'),
	('C00011','1.13.11.27'),
	('C00011','1.11.1.21'),
	('C00011','1.11.1.3'),
	('C00011','1.10.3.15'),
	('C00011','1.1.99.33'),
	('C00011','1.1.5.6'),
	('C00011','1.1.3.19'),
	('C00011','1.1.1.83'),
	('C00011','1.1.1.84'),
	('C00011','1.1.1.85'),
	('C00011','1.1.1.87'),
	('C00011','1.1.1.92'),
	('C00011','1.1.1.40'),
	('C00011','1.1.1.41'),
	('C00011','1.1.1.42'),
	('C00011','1.1.1.44'),
	('C00011','1.1.1.38'),
	('C00011','1.1.1.381'),
	('C00011','1.1.1.387'),
	('C00011','1.1.1.39'),
	('C00011','1.1.1.351'),
	('C00011','1.1.1.343'),
	('C00011','1.1.1.305'),
	('C00011','1.1.1.286'),
	('C00011','1.1.1.270'),
	('C00011','1.1.1.276'),
	('C00011','1.1.1.262'),
	('C00011','1.1.1.170'),
	('C00011','1.14.13.41'),
	('C00011','1.14.13.27'),
	('C00011','1.14.13.218'),
	('C00011','1.14.13.175'),
	('C00011','1.14.13.168'),
	('C00011','1.14.13.135'),
	('C00011','1.14.13.124'),
	('C00011','1.14.13.125'),
	('C00011','1.14.13.114'),
	('C00011','1.14.13.117'),
	('C00011','1.14.13.118'),
	('C00011','1.14.13.1'),
	('C00011','1.14.11.8'),
	('C00012','2.3.2.2'),
	('C00012','2.3.1.88'),
	('C00012','3.4.11.5'),
	('C00012','3.4.24.84'),
	('C00013','1.13.12.7'),
	('C00013','1.2.1.30'),
	('C00013','1.2.1.31'),
	('C00013','1.3.1.96'),
	('C00013','1.3.1.97'),
	('C00013','2.4.2.54'),
	('C00013','2.4.2.7'),
	('C00013','2.4.2.8'),
	('C00013','2.5.1.3'),
	('C00013','2.5.1.30'),
	('C00013','2.5.1.31'),
	('C00013','2.5.1.32'),
	('C00013','2.5.1.34'),
	('C00013','2.5.1.35'),
	('C00013','2.5.1.36'),
	('C00013','2.5.1.39'),
	('C00013','2.5.1.41'),
	('C00013','2.5.1.42'),
	('C00013','2.4.2.9'),
	('C00013','2.5.1.1'),
	('C00013','2.5.1.10'),
	('C00013','2.5.1.100'),
	('C00013','2.5.1.102'),
	('C00013','2.5.1.103'),
	('C00013','2.5.1.105'),
	('C00013','2.5.1.106'),
	('C00013','2.5.1.107'),
	('C00013','2.5.1.109'),
	('C00013','2.5.1.110'),
	('C00013','2.5.1.111'),
	('C00013','2.5.1.112'),
	('C00013','2.5.1.115'),
	('C00013','2.5.1.116'),
	('C00013','2.5.1.117'),
	('C00013','2.5.1.121'),
	('C00013','2.5.1.122'),
	('C00013','2.5.1.123'),
	('C00013','2.5.1.124'),
	('C00013','2.5.1.125'),
	('C00013','2.4.2.10'),
	('C00013','2.4.2.12'),
	('C00013','2.4.2.14'),
	('C00013','2.4.2.17'),
	('C00013','2.4.2.18'),
	('C00013','2.4.2.19'),
	('C00013','2.4.2.20'),
	('C00013','2.4.2.22'),
	('C00013','2.4.2.45'),
	('C00013','2.4.2.49'),
	('C00013','2.7.1.79'),
	('C00013','2.7.1.80'),
	('C00013','2.7.1.90'),
	('C00013','2.7.1.143'),
	('C00013','2.5.1.91'),
	('C00013','2.5.1.92'),
	('C00013','2.5.1.93'),
	('C00013','2.5.1.96'),
	('C00013','2.5.1.99'),
	('C00013','2.5.1.58'),
	('C00013','2.5.1.6'),
	('C00013','2.5.1.62'),
	('C00013','2.5.1.67'),
	('C00013','2.5.1.68'),
	('C00013','2.5.1.69'),
	('C00013','2.5.1.70'),
	('C00013','2.5.1.71'),
	('C00013','2.5.1.74'),
	('C00013','2.5.1.75'),
	('C00013','2.5.1.80'),
	('C00013','2.5.1.81'),
	('C00013','2.5.1.82'),
	('C00013','2.5.1.83'),
	('C00013','2.5.1.84'),
	('C00013','2.5.1.85'),
	('C00013','2.5.1.86'),
	('C00013','2.5.1.87'),
	('C00013','2.5.1.88'),
	('C00013','2.5.1.89'),
	('C00013','2.5.1.90'),
	('C00013','2.5.1.131'),
	('C00013','2.5.1.15'),
	('C00013','2.5.1.20'),
	('C00013','2.5.1.21'),
	('C00013','2.5.1.27'),
	('C00013','2.5.1.28'),
	('C00013','2.5.1.29'),
	('C00013','2.7.7.75'),
	('C00013','2.7.7.81'),
	('C00013','2.7.7.82'),
	('C00013','2.7.7.83'),
	('C00013','2.7.7.84'),
	('C00013','2.7.7.85'),
	('C00013','2.7.7.86'),
	('C00013','2.7.7.3'),
	('C00013','2.7.7.30'),
	('C00013','2.7.7.31'),
	('C00013','2.7.7.32'),
	('C00013','2.7.7.33'),
	('C00013','2.7.7.34'),
	('C00013','2.7.7.38'),
	('C00013','2.7.7.39'),
	('C00013','2.7.7.4'),
	('C00013','2.7.7.40'),
	('C00013','2.7.7.41'),
	('C00013','2.7.7.42'),
	('C00013','2.7.7.43'),
	('C00013','2.7.7.44'),
	('C00013','2.7.7.45'),
	('C00013','2.7.7.46'),
	('C00013','2.7.7.47'),
	('C00013','2.7.7.48'),
	('C00013','2.7.7.49'),
	('C00013','2.7.7.50'),
	('C00013','2.7.7.52'),
	('C00013','2.7.7.57'),
	('C00013','2.7.7.1'),
	('C00013','2.7.7.10'),
	('C00013','2.7.7.11'),
	('C00013','2.7.7.13'),
	('C00013','2.7.7.14'),
	('C00013','2.7.7.15'),
	('C00013','2.7.7.18'),
	('C00013','2.7.7.19'),
	('C00013','2.7.7.2'),
	('C00013','2.7.7.23'),
	('C00013','2.7.7.24'),
	('C00013','2.7.7.27'),
	('C00013','2.7.7.28'),
	('C00013','2.7.4.1'),
	('C00013','2.7.2.12'),
	('C00013','3.1.7.7'),
	('C00013','3.1.7.8'),
	('C00013','3.1.7.9'),
	('C00013','2.7.99.1'),
	('C00013','2.8.1.13'),
	('C00013','2.7.7.87'),
	('C00013','2.7.7.88'),
	('C00013','2.7.7.9'),
	('C00013','2.7.7.93'),
	('C00013','2.7.9.1'),
	('C00013','2.7.7.58'),
	('C00013','2.7.7.59'),
	('C00013','2.7.7.6'),
	('C00013','2.7.7.60'),
	('C00013','2.7.7.61'),
	('C00013','2.7.7.62'),
	('C00013','2.7.7.64'),
	('C00013','2.7.7.65'),
	('C00013','2.7.7.66'),
	('C00013','2.7.7.67'),
	('C00013','2.7.7.68'),
	('C00013','2.7.7.7'),
	('C00013','2.7.7.70'),
	('C00013','2.7.7.71'),
	('C00013','2.7.7.72'),
	('C00013','2.7.7.73'),
	('C00013','2.7.7.74'),
	('C00013','3.1.7.1'),
	('C00013','3.1.7.10'),
	('C00013','3.1.7.11'),
	('C00013','3.1.7.2'),
	('C00013','3.1.7.3'),
	('C00013','3.1.7.5'),
	('C00013','3.1.7.6'),
	('C00013','3.5.4.25'),
	('C00013','3.5.4.30'),
	('C00013','3.5.4.39'),
	('C00013','3.6.1.63'),
	('C00013','3.6.1.65'),
	('C00013','3.6.1.66'),
	('C00013','3.6.1.67'),
	('C00013','3.6.1.8'),
	('C00013','3.6.1.9'),
	('C00013','3.6.1.31'),
	('C00013','3.6.1.55'),
	('C00013','3.6.1.56'),
	('C00013','3.6.1.1'),
	('C00013','3.6.1.12'),
	('C00013','3.6.1.23'),
	('C00013','3.6.1.25'),
	('C00013','4.1.1.38'),
	('C00013','4.2.3.107'),
	('C00013','4.2.3.108'),
	('C00013','4.2.3.109'),
	('C00013','4.2.3.11'),
	('C00013','4.2.3.110'),
	('C00013','4.2.3.111'),
	('C00013','4.2.3.112'),
	('C00013','4.2.3.113'),
	('C00013','4.2.3.114'),
	('C00013','4.2.3.115'),
	('C00013','4.2.3.116'),
	('C00013','4.2.3.117'),
	('C00013','4.2.3.118'),
	('C00013','4.2.3.119'),
	('C00013','4.2.3.120'),
	('C00013','4.2.3.121'),
	('C00013','4.2.3.122'),
	('C00013','4.2.3.123'),
	('C00013','4.2.3.125'),
	('C00013','4.2.3.126'),
	('C00013','4.2.3.127'),
	('C00013','4.2.3.128'),
	('C00013','4.2.3.129'),
	('C00013','4.2.3.13'),
	('C00013','4.2.3.130'),
	('C00013','4.2.3.131'),
	('C00013','4.2.3.132'),
	('C00013','4.2.3.133'),
	('C00013','4.2.3.135'),
	('C00013','4.2.3.136'),
	('C00013','4.2.3.137'),
	('C00013','4.2.3.138'),
	('C00013','4.2.3.139'),
	('C00013','4.2.3.140'),
	('C00013','4.2.3.141'),
	('C00013','4.2.3.142'),
	('C00013','4.2.3.143'),
	('C00013','4.2.3.144'),
	('C00013','4.1.99.16'),
	('C00013','4.2.3.87'),
	('C00013','4.2.3.88'),
	('C00013','4.2.3.89'),
	('C00013','4.2.3.9'),
	('C00013','4.2.3.90'),
	('C00013','4.2.3.91'),
	('C00013','4.2.3.92'),
	('C00013','4.2.3.93'),
	('C00013','4.2.3.94'),
	('C00013','4.2.3.95'),
	('C00013','4.2.3.96'),
	('C00013','4.2.3.97'),
	('C00013','4.2.3.98'),
	('C00013','4.2.3.145'),
	('C00013','4.2.3.146'),
	('C00013','4.2.3.147'),
	('C00013','4.2.3.148'),
	('C00013','4.2.3.149'),
	('C00013','4.2.3.15'),
	('C00013','4.2.3.150'),
	('C00013','4.2.3.151'),
	('C00013','4.2.3.16'),
	('C00013','4.2.3.17'),
	('C00013','4.2.3.18'),
	('C00013','4.2.3.19'),
	('C00013','4.2.3.20'),
	('C00013','4.2.3.21'),
	('C00013','4.2.3.22'),
	('C00013','4.2.3.23'),
	('C00013','4.2.3.24'),
	('C00013','4.2.3.25'),
	('C00013','4.2.3.26'),
	('C00013','4.2.3.27'),
	('C00013','4.2.3.28'),
	('C00013','4.2.3.29'),
	('C00013','4.2.3.30'),
	('C00013','4.2.3.31'),
	('C00013','4.2.3.32'),
	('C00013','4.2.3.33'),
	('C00013','4.2.3.34'),
	('C00013','4.2.3.35'),
	('C00013','4.2.3.36'),
	('C00013','4.2.3.37'),
	('C00013','4.2.3.38'),
	('C00013','4.2.3.39'),
	('C00013','4.2.3.40'),
	('C00013','4.2.3.41'),
	('C00013','4.2.3.42'),
	('C00013','4.2.3.43'),
	('C00013','4.2.3.44'),
	('C00013','4.2.3.45'),
	('C00013','4.2.3.46'),
	('C00013','4.2.3.47'),
	('C00013','4.2.3.48'),
	('C00013','4.2.3.10'),
	('C00013','4.2.3.100'),
	('C00013','4.2.3.101'),
	('C00013','4.2.3.102'),
	('C00013','4.2.3.103'),
	('C00013','4.2.3.104'),
	('C00013','4.2.3.105'),
	('C00013','4.2.3.106'),
	('C00013','4.2.3.49'),
	('C00013','4.2.3.50'),
	('C00013','4.2.3.51'),
	('C00013','4.2.3.53'),
	('C00013','4.2.3.54'),
	('C00013','4.2.3.55'),
	('C00013','4.2.3.56'),
	('C00013','4.2.3.57'),
	('C00013','4.2.3.58'),
	('C00013','4.2.3.59'),
	('C00013','4.2.3.6'),
	('C00013','4.2.3.60'),
	('C00013','4.2.3.61'),
	('C00013','4.2.3.62'),
	('C00013','4.2.3.63'),
	('C00013','4.2.3.64'),
	('C00013','4.2.3.65'),
	('C00013','4.2.3.66'),
	('C00013','4.2.3.67'),
	('C00013','4.2.3.68'),
	('C00013','4.2.3.69'),
	('C00013','4.2.3.7'),
	('C00013','4.2.3.70'),
	('C00013','4.2.3.71'),
	('C00013','4.2.3.72'),
	('C00013','4.2.3.73'),
	('C00013','4.2.3.74'),
	('C00013','4.2.3.75'),
	('C00013','4.2.3.76'),
	('C00013','4.2.3.77'),
	('C00013','4.2.3.78'),
	('C00013','4.2.3.79'),
	('C00013','4.2.3.8'),
	('C00013','4.2.3.80'),
	('C00013','4.2.3.81'),
	('C00013','4.2.3.82'),
	('C00013','4.2.3.83'),
	('C00013','4.2.3.84'),
	('C00013','4.2.3.85'),
	('C00013','4.2.3.86'),
	('C00013','6.2.1.14'),
	('C00013','6.2.1.15'),
	('C00013','6.2.1.16'),
	('C00013','6.2.1.17'),
	('C00013','6.1.1.15'),
	('C00013','6.1.1.16'),
	('C00013','6.1.1.17'),
	('C00013','6.1.1.18'),
	('C00013','6.1.1.19'),
	('C00013','6.1.1.2'),
	('C00013','6.1.1.20'),
	('C00013','6.1.1.21'),
	('C00013','6.1.1.22'),
	('C00013','6.1.1.23'),
	('C00013','6.1.1.24'),
	('C00013','6.1.1.26'),
	('C00013','6.1.1.27'),
	('C00013','6.1.1.3'),
	('C00013','6.1.1.4'),
	('C00013','6.1.1.5'),
	('C00013','6.1.1.6'),
	('C00013','6.1.1.7'),
	('C00013','6.1.1.1'),
	('C00013','6.1.1.10'),
	('C00013','6.1.1.11'),
	('C00013','6.1.1.12'),
	('C00013','6.1.1.13'),
	('C00013','6.1.1.14'),
	('C00013','4.6.1.1'),
	('C00013','4.6.1.17'),
	('C00013','4.6.1.2'),
	('C00013','4.6.1.6'),
	('C00013','5.1.1.11'),
	('C00013','4.2.3.99'),
	('C00013','6.2.1.36'),
	('C00013','6.2.1.37'),
	('C00013','6.2.1.38'),
	('C00013','6.2.1.40'),
	('C00013','6.2.1.41'),
	('C00013','6.2.1.42'),
	('C00013','6.2.1.43'),
	('C00013','6.2.1.44'),
	('C00013','6.2.1.46'),
	('C00013','6.2.1.7'),
	('C00013','6.2.1.19'),
	('C00013','6.2.1.2'),
	('C00013','6.2.1.20'),
	('C00013','6.2.1.22'),
	('C00013','6.2.1.23'),
	('C00013','6.2.1.24'),
	('C00013','6.2.1.25'),
	('C00013','6.2.1.26'),
	('C00013','6.2.1.27'),
	('C00013','6.2.1.28'),
	('C00013','6.2.1.3'),
	('C00013','6.2.1.30'),
	('C00013','6.2.1.31'),
	('C00013','6.2.1.32'),
	('C00013','6.2.1.33'),
	('C00013','6.1.1.9'),
	('C00013','6.1.2.2'),
	('C00013','6.2.1.1'),
	('C00013','6.2.1.11'),
	('C00013','6.2.1.12'),
	('C00013','6.5.1.7'),
	('C00013','6.5.1.1'),
	('C00013','6.5.1.3'),
	('C00013','6.5.1.4'),
	('C00013','6.5.1.5'),
	('C00013','6.5.1.6'),
	('C00013','6.3.5.1'),
	('C00013','6.3.5.2'),
	('C00013','6.3.5.4'),
	('C00013','6.3.4.21'),
	('C00013','6.3.4.5'),
	('C00013','6.3.4.8'),
	('C00013','6.3.4.9'),
	('C00013','6.3.3.4'),
	('C00013','6.3.3.6'),
	('C00013','6.3.4.10'),
	('C00013','6.3.4.11'),
	('C00013','6.3.4.15'),
	('C00013','6.3.4.19'),
	('C00013','6.3.2.39'),
	('C00013','6.3.2.40'),
	('C00013','6.3.2.46'),
	('C00013','6.3.2.5'),
	('C00013','6.3.2.24'),
	('C00013','6.3.2.26'),
	('C00013','6.3.2.36'),
	('C00013','6.3.2.38'),
	('C00013','6.3.1.7'),
	('C00013','6.3.2.1'),
	('C00013','6.3.2.14'),
	('C00013','6.3.2.18'),
	('C00013','6.2.1.8'),
	('C00013','6.3.1.1'),
	('C00013','6.3.1.13'),
	('C00013','6.3.1.14'),
	('C00013','6.3.1.15'),
	('C00013','6.3.1.20'),
	('C00013','6.3.1.5'),
	('C00013','6.2.1.35'),
	('C00014','4.2.1.104'),
	('C00014','4.1.3.27'),
	('C00014','4.1.99.1'),
	('C00014','4.1.99.2'),
	('C00014','4.2.3.2'),
	('C00014','4.3.1.13'),
	('C00014','4.3.1.14'),
	('C00014','4.3.1.15'),
	('C00014','4.3.1.16'),
	('C00014','4.3.1.17'),
	('C00014','4.3.1.18'),
	('C00014','4.3.1.19'),
	('C00014','4.3.1.2'),
	('C00014','4.3.1.20'),
	('C00014','4.3.1.22'),
	('C00014','4.3.1.23'),
	('C00014','4.3.1.24'),
	('C00014','4.3.1.25'),
	('C00014','4.3.1.27'),
	('C00014','4.3.1.28'),
	('C00014','4.3.1.29'),
	('C00014','4.3.1.3'),
	('C00014','4.3.1.30'),
	('C00014','4.3.1.31'),
	('C00014','4.3.1.4'),
	('C00014','4.3.1.6'),
	('C00014','4.3.1.7'),
	('C00014','4.4.1.28'),
	('C00014','4.4.1.6'),
	('C00014','4.4.1.8'),
	('C00014','4.5.1.2'),
	('C00014','4.5.1.4'),
	('C00014','4.3.1.9'),
	('C00014','4.3.3.6'),
	('C00014','4.3.99.3'),
	('C00014','4.4.1.1'),
	('C00014','4.4.1.11'),
	('C00014','4.4.1.13'),
	('C00014','4.4.1.15'),
	('C00014','4.4.1.2'),
	('C00014','4.4.1.25'),
	('C00014','4.3.1.1'),
	('C00014','4.3.1.10'),
	('C00014','4.3.1.12'),
	('C00014','6.3.5.1'),
	('C00014','6.3.5.2'),
	('C00014','6.3.5.4'),
	('C00014','6.3.5.5'),
	('C00014','6.3.4.2'),
	('C00014','6.3.4.20'),
	('C00014','6.3.4.7'),
	('C00014','6.3.3.5'),
	('C00014','6.3.4.16'),
	('C00014','6.3.1.7'),
	('C00014','6.3.1.1'),
	('C00014','6.3.1.14'),
	('C00014','6.3.1.2'),
	('C00014','6.3.1.4'),
	('C00014','6.3.1.5'),
	('C00014','3.5.5.2'),
	('C00014','3.5.5.4'),
	('C00014','3.5.5.5'),
	('C00014','3.5.5.6'),
	('C00014','3.5.5.7'),
	('C00014','3.5.5.8'),
	('C00014','3.5.99.10'),
	('C00014','3.5.99.2'),
	('C00014','3.5.99.5'),
	('C00014','3.5.99.6'),
	('C00014','3.5.99.7'),
	('C00014','3.5.99.8'),
	('C00014','3.5.4.12'),
	('C00014','3.5.4.13'),
	('C00014','3.5.4.15'),
	('C00014','3.5.4.17'),
	('C00014','3.5.4.18'),
	('C00014','3.5.4.2'),
	('C00014','3.5.4.20'),
	('C00014','3.5.4.21'),
	('C00014','3.5.4.22'),
	('C00014','3.5.4.23'),
	('C00014','3.5.4.24'),
	('C00014','3.5.4.26'),
	('C00014','3.5.4.28'),
	('C00014','3.5.4.3'),
	('C00014','3.5.4.30'),
	('C00014','3.5.4.31'),
	('C00014','3.5.4.32'),
	('C00014','3.5.4.33'),
	('C00014','3.5.4.34'),
	('C00014','3.5.4.35'),
	('C00014','3.5.3.12'),
	('C00014','3.5.3.13'),
	('C00014','3.5.3.15'),
	('C00014','3.5.3.21'),
	('C00014','3.5.3.23'),
	('C00014','3.5.3.26'),
	('C00014','3.5.3.5'),
	('C00014','3.5.3.6'),
	('C00014','3.5.3.9'),
	('C00014','3.5.4.1'),
	('C00014','3.5.4.11'),
	('C00014','3.5.1.86'),
	('C00014','3.5.1.87'),
	('C00014','3.5.1.99'),
	('C00014','3.5.2.18'),
	('C00014','3.5.1.59'),
	('C00014','3.5.1.6'),
	('C00014','3.8.1.8'),
	('C00014','3.5.4.4'),
	('C00014','3.5.4.40'),
	('C00014','3.5.4.41'),
	('C00014','3.5.4.42'),
	('C00014','3.5.4.5'),
	('C00014','3.5.4.6'),
	('C00014','3.5.4.7'),
	('C00014','3.5.4.8'),
	('C00014','4.2.3.134'),
	('C00014','4.2.1.87'),
	('C00014','1.4.1.7'),
	('C00014','1.4.1.8'),
	('C00014','1.4.1.9'),
	('C00014','1.4.2.1'),
	('C00014','1.4.3.1'),
	('C00014','1.4.1.16'),
	('C00014','1.4.1.18'),
	('C00014','1.4.1.19'),
	('C00014','1.4.1.2'),
	('C00014','2.1.1.21'),
	('C00014','2.1.1.247'),
	('C00014','2.1.1.248'),
	('C00014','2.1.2.10'),
	('C00014','2.3.2.5'),
	('C00014','2.3.2.7'),
	('C00014','2.3.2.1'),
	('C00014','2.3.2.13'),
	('C00014','2.3.2.14'),
	('C00014','2.5.1.44'),
	('C00014','2.5.1.48'),
	('C00014','2.7.1.62'),
	('C00014','2.5.1.61'),
	('C00014','2.5.1.77'),
	('C00014','2.7.7.51'),
	('C00014','2.7.3.8'),
	('C00014','2.7.2.2'),
	('C00014','3.5.1.66'),
	('C00014','3.5.1.67'),
	('C00014','3.5.1.7'),
	('C00014','3.5.1.73'),
	('C00014','3.5.1.75'),
	('C00014','3.5.1.77'),
	('C00014','3.5.1.84'),
	('C00014','3.5.1.35'),
	('C00014','3.5.1.38'),
	('C00014','3.5.1.4'),
	('C00014','3.5.1.42'),
	('C00014','3.5.1.43'),
	('C00014','3.5.1.44'),
	('C00014','3.5.1.49'),
	('C00014','3.5.1.5'),
	('C00014','3.5.1.50'),
	('C00014','3.5.1.53'),
	('C00014','3.5.1.54'),
	('C00014','3.5.1.57'),
	('C00014','3.5.1.19'),
	('C00014','3.5.1.2'),
	('C00014','3.5.1.20'),
	('C00014','3.5.1.29'),
	('C00014','3.5.1.3'),
	('C00014','3.5.1.30'),
	('C00014','3.5.1.1'),
	('C00014','3.5.1.100'),
	('C00014','3.5.1.101'),
	('C00014','3.5.1.107'),
	('C00014','3.5.1.110'),
	('C00014','3.5.1.111'),
	('C00014','3.5.1.116'),
	('C00014','3.5.1.119'),
	('C00014','3.5.1.12'),
	('C00014','3.5.5.1'),
	('C00014','1.13.99.3'),
	('C00014','1.13.12.15'),
	('C00014','1.14.13.35'),
	('C00014','1.14.12.1'),
	('C00014','1.14.12.14'),
	('C00014','1.14.11.37'),
	('C00014','1.18.6.1'),
	('C00014','1.19.6.1'),
	('C00014','1.14.99.39'),
	('C00014','1.4.1.20'),
	('C00014','1.4.1.21'),
	('C00014','1.4.1.23'),
	('C00014','1.4.1.24'),
	('C00014','1.4.1.1'),
	('C00014','1.4.1.10'),
	('C00014','1.4.1.11'),
	('C00014','1.4.1.12'),
	('C00014','1.4.1.13'),
	('C00014','1.4.1.15'),
	('C00014','1.3.7.8'),
	('C00014','1.21.98.2'),
	('C00014','1.21.4.2'),
	('C00014','1.8.1.4'),
	('C00014','1.7.2.2'),
	('C00014','1.7.2.7'),
	('C00014','1.7.7.1'),
	('C00014','1.7.99.1'),
	('C00014','1.7.1.14'),
	('C00014','1.7.1.15'),
	('C00014','1.7.1.4'),
	('C00014','1.7.1.7'),
	('C00014','1.7.1.10'),
	('C00014','1.4.99.6'),
	('C00014','1.4.3.22'),
	('C00014','1.4.3.3'),
	('C00014','1.4.3.4'),
	('C00014','1.4.3.5'),
	('C00014','1.4.3.7'),
	('C00014','1.4.3.8'),
	('C00014','1.4.4.2'),
	('C00014','1.4.5.1'),
	('C00014','1.4.7.1'),
	('C00014','1.4.9.1'),
	('C00014','1.4.9.2'),
	('C00014','1.4.99.2'),
	('C00014','1.4.3.10'),
	('C00014','1.4.3.11'),
	('C00014','1.4.3.12'),
	('C00014','1.4.3.13'),
	('C00014','1.4.3.14'),
	('C00014','1.4.3.15'),
	('C00014','1.4.3.16'),
	('C00014','1.4.3.19'),
	('C00014','1.4.3.2'),
	('C00014','1.4.3.20'),
	('C00014','1.4.3.21'),
	('C00014','1.4.1.3'),
	('C00014','1.4.1.4'),
	('C00014','1.4.1.5'),
	('C00015','2.4.2.32'),
	('C00015','2.4.2.34'),
	('C00015','2.4.2.35'),
	('C00015','2.4.2.40'),
	('C00015','2.7.1.48'),
	('C00015','2.7.1.40'),
	('C00015','2.7.1.11'),
	('C00015','2.7.7.8'),
	('C00015','2.7.4.10'),
	('C00015','2.7.4.14'),
	('C00015','2.7.4.22'),
	('C00015','2.7.4.4'),
	('C00015','2.7.4.6'),
	('C00015','3.2.1.183'),
	('C00015','3.2.1.184'),
	('C00015','3.6.1.39'),
	('C00015','3.6.1.5'),
	('C00015','3.6.1.57'),
	('C00015','3.6.1.6'),
	('C00015','5.1.3.14'),
	('C00015','2.4.2.50'),
	('C00015','2.4.2.51'),
	('C00015','2.4.2.53'),
	('C00015','2.4.2.56'),
	('C00015','2.4.1.50'),
	('C00015','2.4.1.52'),
	('C00015','2.4.1.53'),
	('C00015','2.4.1.56'),
	('C00015','2.4.1.58'),
	('C00015','2.4.1.62'),
	('C00015','2.4.1.63'),
	('C00015','2.4.1.66'),
	('C00015','2.4.1.70'),
	('C00015','2.4.1.71'),
	('C00015','2.4.1.73'),
	('C00015','2.4.1.74'),
	('C00015','2.4.1.78'),
	('C00015','2.4.1.79'),
	('C00015','2.4.1.80'),
	('C00015','2.4.1.81'),
	('C00015','2.4.1.85'),
	('C00015','2.4.1.86'),
	('C00015','2.4.1.87'),
	('C00015','2.4.1.88'),
	('C00015','2.4.1.90'),
	('C00015','2.4.1.91'),
	('C00015','2.4.1.92'),
	('C00015','2.4.1.94'),
	('C00015','2.4.1.309'),
	('C00015','2.4.1.310'),
	('C00015','2.4.1.312'),
	('C00015','2.4.1.313'),
	('C00015','2.4.1.314'),
	('C00015','2.4.1.315'),
	('C00015','2.4.1.323'),
	('C00015','2.4.1.324'),
	('C00015','2.4.1.330'),
	('C00015','2.4.1.335'),
	('C00015','2.4.1.336'),
	('C00015','2.4.1.337'),
	('C00015','2.4.1.338'),
	('C00015','2.4.1.34'),
	('C00015','2.4.1.35'),
	('C00015','2.4.1.37'),
	('C00015','2.4.1.38'),
	('C00015','2.4.1.39'),
	('C00015','2.4.1.40'),
	('C00015','2.4.1.41'),
	('C00015','2.4.1.43'),
	('C00015','2.4.1.44'),
	('C00015','2.4.1.45'),
	('C00015','2.4.1.46'),
	('C00015','2.4.1.47'),
	('C00015','2.4.1.253'),
	('C00015','2.4.1.254'),
	('C00015','2.4.1.255'),
	('C00015','2.4.1.262'),
	('C00015','2.4.1.263'),
	('C00015','2.4.1.264'),
	('C00015','2.4.1.271'),
	('C00015','2.4.1.96'),
	('C00015','2.4.2.24'),
	('C00015','2.4.2.25'),
	('C00015','2.4.1.272'),
	('C00015','2.4.1.273'),
	('C00015','2.4.1.274'),
	('C00015','2.4.1.275'),
	('C00015','2.4.1.276'),
	('C00015','2.4.1.283'),
	('C00015','2.4.1.284'),
	('C00015','2.4.1.285'),
	('C00015','2.4.1.286'),
	('C00015','2.4.1.290'),
	('C00015','2.4.1.294'),
	('C00015','2.4.1.295'),
	('C00015','2.4.1.296'),
	('C00015','2.4.1.297'),
	('C00015','2.4.1.298'),
	('C00015','2.4.1.301'),
	('C00015','2.4.1.303'),
	('C00015','2.4.1.304'),
	('C00015','2.4.1.305'),
	('C00015','2.4.1.306'),
	('C00015','2.4.1.307'),
	('C00015','2.4.1.212'),
	('C00015','2.4.1.215'),
	('C00015','2.4.1.218'),
	('C00015','2.4.1.219'),
	('C00015','2.4.1.22'),
	('C00015','2.4.1.220'),
	('C00015','2.4.1.223'),
	('C00015','2.4.1.224'),
	('C00015','2.4.1.225'),
	('C00015','2.4.1.226'),
	('C00015','2.4.1.227'),
	('C00015','2.4.1.228'),
	('C00015','2.4.1.23'),
	('C00015','2.4.1.234'),
	('C00015','2.4.1.236'),
	('C00015','2.4.1.237'),
	('C00015','2.4.1.238'),
	('C00015','2.4.1.239'),
	('C00015','2.4.1.240'),
	('C00015','2.4.1.241'),
	('C00015','2.4.1.242'),
	('C00015','2.4.1.245'),
	('C00015','2.4.1.249'),
	('C00015','2.4.1.250'),
	('C00015','2.4.1.171'),
	('C00015','2.4.1.172'),
	('C00015','2.4.1.173'),
	('C00015','2.4.1.175'),
	('C00015','2.4.1.176'),
	('C00015','2.4.1.177'),
	('C00015','2.4.1.178'),
	('C00015','2.4.1.179'),
	('C00015','2.4.1.180'),
	('C00015','2.4.1.181'),
	('C00015','2.4.1.182'),
	('C00015','2.4.1.183'),
	('C00015','2.4.1.185'),
	('C00015','2.4.1.186'),
	('C00015','2.4.1.187'),
	('C00015','2.4.1.188'),
	('C00015','2.4.1.189'),
	('C00015','2.4.1.190'),
	('C00015','2.4.1.191'),
	('C00015','1.17.4.1'),
	('C00015','2.4.1.13'),
	('C00015','2.4.1.192'),
	('C00015','2.4.1.193'),
	('C00015','2.4.1.194'),
	('C00015','2.4.1.195'),
	('C00015','2.4.1.196'),
	('C00015','2.4.1.198'),
	('C00015','2.4.1.201'),
	('C00015','2.4.1.202'),
	('C00015','2.4.1.203'),
	('C00015','2.4.1.205'),
	('C00015','2.4.1.206'),
	('C00015','2.4.1.208'),
	('C00015','2.4.1.209'),
	('C00015','2.4.1.210'),
	('C00015','2.4.1.135'),
	('C00015','2.4.1.136'),
	('C00015','2.4.1.137'),
	('C00015','2.4.1.138'),
	('C00015','2.4.1.14'),
	('C00015','2.4.1.141'),
	('C00015','2.4.1.143'),
	('C00015','2.4.1.144'),
	('C00015','2.4.1.145'),
	('C00015','2.4.1.146'),
	('C00015','2.4.1.147'),
	('C00015','2.4.1.148'),
	('C00015','2.4.1.149'),
	('C00015','2.4.1.15'),
	('C00015','2.4.1.150'),
	('C00015','2.4.1.153'),
	('C00015','2.4.1.155'),
	('C00015','2.4.1.156'),
	('C00015','2.4.1.158'),
	('C00015','2.4.1.159'),
	('C00015','2.4.1.16'),
	('C00015','2.4.1.160'),
	('C00015','2.4.1.163'),
	('C00015','2.4.1.164'),
	('C00015','2.4.1.165'),
	('C00015','2.4.1.167'),
	('C00015','2.4.1.17'),
	('C00015','2.4.1.170'),
	('C00015','2.4.1.102'),
	('C00015','2.4.1.103'),
	('C00015','2.4.1.104'),
	('C00015','2.4.1.105'),
	('C00015','2.4.1.106'),
	('C00015','2.4.1.11'),
	('C00015','2.4.1.111'),
	('C00015','2.4.1.114'),
	('C00015','2.4.1.115'),
	('C00015','2.4.1.116'),
	('C00015','2.4.1.117'),
	('C00015','2.4.1.118'),
	('C00015','2.4.1.12'),
	('C00015','2.4.1.120'),
	('C00015','2.4.1.121'),
	('C00015','2.4.1.123'),
	('C00015','2.4.1.126'),
	('C00015','2.4.1.127'),
	('C00015','2.4.1.128'),
	('C00016','1.1.99.13'),
	('C00016','1.1.99.2'),
	('C00016','1.1.99.21'),
	('C00016','1.1.99.3'),
	('C00016','1.1.5.3'),
	('C00016','1.1.5.4'),
	('C00016','1.1.98.3'),
	('C00016','1.14.19.9'),
	('C00016','1.14.14.27'),
	('C00016','1.14.14.8'),
	('C00016','1.14.14.11'),
	('C00016','1.14.14.15'),
	('C00016','1.14.14.18'),
	('C00016','1.3.3.6'),
	('C00016','1.3.8.1'),
	('C00016','1.3.8.2'),
	('C00016','1.3.8.4'),
	('C00016','1.3.8.6'),
	('C00016','1.3.8.7'),
	('C00016','1.3.8.8'),
	('C00016','1.3.8.9'),
	('C00016','1.6.6.9'),
	('C00016','1.5.99.3'),
	('C00016','1.5.1.37'),
	('C00016','1.5.1.45'),
	('C00016','1.5.1.30'),
	('C00016','1.8.99.2'),
	('C00016','2.1.1.74'),
	('C00016','2.7.1.180'),
	('C00016','2.7.7.2'),
	('C00016','3.6.1.9'),
	('C00016','3.6.1.18'),
	('C00016','4.6.1.15'),
	('C00017','2.3.2.6'),
	('C00017','2.3.2.8'),
	('C00017','2.4.1.113'),
	('C00017','2.7.11.24'),
	('C00017','2.7.11.25'),
	('C00017','2.7.11.30'),
	('C00017','2.7.11.8'),
	('C00017','2.7.11.9'),
	('C00017','2.7.11.1'),
	('C00017','2.7.11.10'),
	('C00017','2.7.12.1'),
	('C00017','2.7.12.2'),
	('C00017','2.7.11.11'),
	('C00017','2.7.11.12'),
	('C00017','2.7.11.13'),
	('C00017','2.7.11.17'),
	('C00017','2.7.11.21'),
	('C00017','2.7.11.22'),
	('C00017','3.1.2.22'),
	('C00017','3.1.3.16'),
	('C00018','1.4.3.5'),
	('C00018','2.7.1.35'),
	('C00018','2.6.1.54'),
	('C00018','3.1.3.74'),
	('C00018','4.3.3.6'),
	('C00019','2.1.1.96'),
	('C00019','2.1.1.97'),
	('C00019','2.1.1.98'),
	('C00019','2.1.1.99'),
	('C00019','2.1.1.55'),
	('C00019','2.1.1.56'),
	('C00019','2.1.1.57'),
	('C00019','2.1.1.59'),
	('C00019','2.1.1.6'),
	('C00019','2.1.1.60'),
	('C00019','2.1.1.61'),
	('C00019','2.1.1.62'),
	('C00019','2.1.1.64'),
	('C00019','2.1.1.65'),
	('C00019','2.1.1.67'),
	('C00019','2.1.1.68'),
	('C00019','2.1.1.69'),
	('C00019','2.1.1.7'),
	('C00019','2.1.1.70'),
	('C00019','2.1.1.71'),
	('C00019','2.1.1.72'),
	('C00019','2.1.1.75'),
	('C00019','2.1.1.76'),
	('C00019','2.1.1.77'),
	('C00019','2.1.1.78'),
	('C00019','2.1.1.79'),
	('C00019','2.1.1.8'),
	('C00019','2.1.1.80'),
	('C00019','2.1.1.82'),
	('C00019','2.3.1.161'),
	('C00019','2.3.1.184'),
	('C00019','2.3.1.228'),
	('C00019','2.3.1.229'),
	('C00019','2.3.1.231'),
	('C00019','2.5.1.38'),
	('C00019','2.5.1.4'),
	('C00019','2.5.1.43'),
	('C00019','2.5.1.108'),
	('C00019','2.5.1.114'),
	('C00019','2.5.1.120'),
	('C00019','2.6.1.62'),
	('C00019','2.5.1.94'),
	('C00019','2.5.1.6'),
	('C00019','2.5.1.63'),
	('C00019','2.5.1.77'),
	('C00019','2.5.1.24'),
	('C00019','2.5.1.25'),
	('C00019','2.8.4.3'),
	('C00019','2.8.4.4'),
	('C00019','2.8.4.5'),
	('C00019','2.8.1.6'),
	('C00019','2.8.1.8'),
	('C00019','3.3.1.2'),
	('C00019','4.1.1.50'),
	('C00019','4.1.3.44'),
	('C00019','4.1.99.17'),
	('C00019','4.1.99.19'),
	('C00019','4.1.99.22'),
	('C00019','4.3.1.30'),
	('C00019','4.4.1.14'),
	('C00019','6.3.2.40'),
	('C00019','2.1.1.306'),
	('C00019','2.1.1.307'),
	('C00019','2.1.1.308'),
	('C00019','2.1.1.314'),
	('C00019','2.1.1.315'),
	('C00019','2.1.1.316'),
	('C00019','2.1.1.317'),
	('C00019','2.1.1.319'),
	('C00019','2.1.1.320'),
	('C00019','2.1.1.321'),
	('C00019','2.1.1.322'),
	('C00019','2.1.1.323'),
	('C00019','2.1.1.324'),
	('C00019','2.1.1.325'),
	('C00019','2.1.1.33'),
	('C00019','2.1.1.34'),
	('C00019','2.1.1.35'),
	('C00019','2.1.1.37'),
	('C00019','2.1.1.38'),
	('C00019','2.1.1.39'),
	('C00019','2.1.1.4'),
	('C00019','2.1.1.40'),
	('C00019','2.1.1.41'),
	('C00019','2.1.1.42'),
	('C00019','2.1.1.43'),
	('C00019','2.1.1.44'),
	('C00019','2.1.1.47'),
	('C00019','2.1.1.49'),
	('C00019','2.1.1.50'),
	('C00019','2.1.1.53'),
	('C00019','2.1.1.274'),
	('C00019','2.1.1.275'),
	('C00019','2.1.1.276'),
	('C00019','2.1.1.277'),
	('C00019','2.1.1.278'),
	('C00019','2.1.1.279'),
	('C00019','2.1.1.28'),
	('C00019','2.1.1.281'),
	('C00019','2.1.1.282'),
	('C00019','2.1.1.283'),
	('C00019','2.1.1.284'),
	('C00019','2.1.1.285'),
	('C00019','2.1.1.286'),
	('C00019','2.1.1.287'),
	('C00019','2.1.1.288'),
	('C00019','2.1.1.289'),
	('C00019','2.1.1.290'),
	('C00019','2.1.1.291'),
	('C00019','2.1.1.292'),
	('C00019','2.1.1.293'),
	('C00019','2.1.1.294'),
	('C00019','2.1.1.295'),
	('C00019','2.1.1.296'),
	('C00019','2.1.1.297'),
	('C00019','2.1.1.298'),
	('C00019','2.1.1.300'),
	('C00019','2.1.1.302'),
	('C00019','2.1.1.303'),
	('C00019','2.1.1.304'),
	('C00019','2.1.1.89'),
	('C00019','2.1.1.9'),
	('C00019','2.1.1.91'),
	('C00019','2.1.1.94'),
	('C00019','2.1.1.95'),
	('C00019','2.1.1.305'),
	('C00019','2.1.1.210'),
	('C00019','2.1.1.212'),
	('C00019','2.1.1.22'),
	('C00019','2.1.1.222'),
	('C00019','2.1.1.228'),
	('C00019','2.1.1.231'),
	('C00019','2.1.1.232'),
	('C00019','2.1.1.234'),
	('C00019','2.1.1.235'),
	('C00019','2.1.1.236'),
	('C00019','2.1.1.237'),
	('C00019','2.1.1.238'),
	('C00019','2.1.1.239'),
	('C00019','2.1.1.240'),
	('C00019','2.1.1.241'),
	('C00019','2.1.1.243'),
	('C00019','2.1.1.25'),
	('C00019','2.1.1.254'),
	('C00019','2.1.1.255'),
	('C00019','2.1.1.26'),
	('C00019','2.1.1.261'),
	('C00019','2.1.1.262'),
	('C00019','2.1.1.263'),
	('C00019','2.1.1.267'),
	('C00019','2.1.1.27'),
	('C00019','2.1.1.270'),
	('C00019','2.1.1.271'),
	('C00019','2.1.1.273'),
	('C00019','2.1.1.16'),
	('C00019','2.1.1.160'),
	('C00019','2.1.1.161'),
	('C00019','2.1.1.162'),
	('C00019','2.1.1.163'),
	('C00019','2.1.1.164'),
	('C00019','2.1.1.165'),
	('C00019','2.1.1.169'),
	('C00019','2.1.1.17'),
	('C00019','2.1.1.171'),
	('C00019','2.1.1.172'),
	('C00019','2.1.1.173'),
	('C00019','2.1.1.174'),
	('C00019','2.1.1.175'),
	('C00019','2.1.1.18'),
	('C00019','2.1.1.181'),
	('C00019','2.1.1.182'),
	('C00019','2.1.1.183'),
	('C00019','2.1.1.184'),
	('C00019','2.1.1.187'),
	('C00019','2.1.1.188'),
	('C00019','2.1.1.195'),
	('C00019','2.1.1.196'),
	('C00019','2.1.1.197'),
	('C00019','2.1.1.2'),
	('C00019','2.1.1.20'),
	('C00019','2.1.1.201'),
	('C00019','2.1.1.202'),
	('C00019','2.1.1.203'),
	('C00019','2.1.1.204'),
	('C00019','2.1.1.83'),
	('C00019','2.1.1.84'),
	('C00019','2.1.1.85'),
	('C00019','2.1.1.87'),
	('C00019','2.1.1.88'),
	('C00019','1.1.99.38'),
	('C00019','1.16.1.8'),
	('C00019','1.3.98.3'),
	('C00019','1.21.98.1'),
	('C00019','2.1.1.130'),
	('C00019','2.1.1.131'),
	('C00019','2.1.1.132'),
	('C00019','2.1.1.133'),
	('C00019','2.1.1.136'),
	('C00019','2.1.1.137'),
	('C00019','2.1.1.139'),
	('C00019','2.1.1.140'),
	('C00019','2.1.1.141'),
	('C00019','2.1.1.142'),
	('C00019','2.1.1.143'),
	('C00019','2.1.1.144'),
	('C00019','2.1.1.145'),
	('C00019','2.1.1.146'),
	('C00019','2.1.1.147'),
	('C00019','2.1.1.15'),
	('C00019','2.1.1.150'),
	('C00019','2.1.1.151'),
	('C00019','2.1.1.152'),
	('C00019','2.1.1.153'),
	('C00019','2.1.1.154'),
	('C00019','2.1.1.155'),
	('C00019','2.1.1.156'),
	('C00019','2.1.1.157'),
	('C00019','2.1.1.158'),
	('C00019','2.1.1.159'),
	('C00019','2.1.1.102'),
	('C00019','2.1.1.103'),
	('C00019','2.1.1.104'),
	('C00019','2.1.1.105'),
	('C00019','2.1.1.106'),
	('C00019','2.1.1.107'),
	('C00019','2.1.1.108'),
	('C00019','2.1.1.109'),
	('C00019','2.1.1.11'),
	('C00019','2.1.1.110'),
	('C00019','2.1.1.111'),
	('C00019','2.1.1.112'),
	('C00019','2.1.1.113'),
	('C00019','2.1.1.114'),
	('C00019','2.1.1.115'),
	('C00019','2.1.1.116'),
	('C00019','2.1.1.117'),
	('C00019','2.1.1.118'),
	('C00019','2.1.1.119'),
	('C00019','2.1.1.12'),
	('C00019','2.1.1.120'),
	('C00019','2.1.1.121'),
	('C00019','2.1.1.122'),
	('C00019','2.1.1.123'),
	('C00019','2.1.1.127'),
	('C00019','2.1.1.128'),
	('C00019','2.1.1.129'),
	('C00019','1.97.1.4'),
	('C00019','2.1.1.1'),
	('C00019','2.1.1.10'),
	('C00019','2.1.1.100'),
	('C00019','2.1.1.101'),
	('C00020','6.5.1.4'),
	('C00020','6.5.1.6'),
	('C00020','6.3.5.1'),
	('C00020','6.3.5.2'),
	('C00020','6.3.5.4'),
	('C00020','6.3.4.22'),
	('C00020','6.3.4.5'),
	('C00020','6.3.4.9'),
	('C00020','6.3.3.4'),
	('C00020','6.3.3.6'),
	('C00020','6.3.4.10'),
	('C00020','6.3.4.11'),
	('C00020','6.3.4.15'),
	('C00020','6.3.4.19'),
	('C00020','6.3.2.39'),
	('C00020','6.3.2.40'),
	('C00020','6.3.2.46'),
	('C00020','6.3.2.5'),
	('C00020','6.3.2.24'),
	('C00020','6.3.2.26'),
	('C00020','6.3.2.36'),
	('C00020','6.3.2.38'),
	('C00020','6.3.1.5'),
	('C00020','6.3.1.7'),
	('C00020','6.3.2.1'),
	('C00020','6.3.2.14'),
	('C00020','6.3.2.18'),
	('C00020','6.2.1.8'),
	('C00020','4.6.1.15'),
	('C00020','5.1.1.11'),
	('C00020','4.3.2.2'),
	('C00020','4.2.1.136'),
	('C00020','6.3.1.1'),
	('C00020','6.3.1.13'),
	('C00020','6.3.1.14'),
	('C00020','6.3.1.15'),
	('C00020','6.3.1.20'),
	('C00020','6.2.1.35'),
	('C00020','6.2.1.36'),
	('C00020','6.2.1.37'),
	('C00020','6.2.1.38'),
	('C00020','6.2.1.40'),
	('C00020','6.2.1.41'),
	('C00020','6.2.1.42'),
	('C00020','6.2.1.43'),
	('C00020','6.2.1.44'),
	('C00020','6.2.1.46'),
	('C00020','6.2.1.7'),
	('C00020','6.2.1.19'),
	('C00020','6.2.1.2'),
	('C00020','6.2.1.20'),
	('C00020','6.2.1.22'),
	('C00020','6.2.1.23'),
	('C00020','6.2.1.24'),
	('C00020','6.2.1.25'),
	('C00020','6.2.1.26'),
	('C00020','6.2.1.27'),
	('C00020','6.2.1.28'),
	('C00020','6.2.1.3'),
	('C00020','6.2.1.30'),
	('C00020','6.2.1.31'),
	('C00020','6.2.1.32'),
	('C00020','6.2.1.33'),
	('C00020','6.1.1.9'),
	('C00020','6.1.2.2'),
	('C00020','6.2.1.1'),
	('C00020','6.2.1.11'),
	('C00020','6.2.1.12'),
	('C00020','6.2.1.14'),
	('C00020','6.2.1.15'),
	('C00020','6.2.1.16'),
	('C00020','6.2.1.17'),
	('C00020','6.1.1.15'),
	('C00020','6.1.1.16'),
	('C00020','6.1.1.17'),
	('C00020','6.1.1.18'),
	('C00020','6.1.1.19'),
	('C00020','6.1.1.2'),
	('C00020','6.1.1.20'),
	('C00020','6.1.1.21'),
	('C00020','6.1.1.22'),
	('C00020','6.1.1.23'),
	('C00020','6.1.1.24'),
	('C00020','6.1.1.26'),
	('C00020','6.1.1.27'),
	('C00020','6.1.1.3'),
	('C00020','6.5.1.7'),
	('C00020','6.4.1.6'),
	('C00020','6.5.1.1'),
	('C00020','6.5.1.2'),
	('C00020','6.5.1.3'),
	('C00020','1.13.12.7'),
	('C00020','1.2.1.30'),
	('C00020','1.2.1.31'),
	('C00020','1.8.4.9'),
	('C00020','1.8.99.2'),
	('C00020','1.8.4.10'),
	('C00020','2.10.1.1'),
	('C00020','2.3.1.234'),
	('C00020','2.5.1.27'),
	('C00020','2.4.2.57'),
	('C00020','2.4.2.7'),
	('C00020','2.4.2.8'),
	('C00020','2.7.1.74'),
	('C00020','2.7.1.180'),
	('C00020','2.7.1.20'),
	('C00020','2.7.1.146'),
	('C00020','2.7.1.147'),
	('C00020','2.7.1.114'),
	('C00020','2.7.1.118'),
	('C00020','3.2.2.4'),
	('C00020','3.1.4.17'),
	('C00020','3.1.4.53'),
	('C00020','3.1.3.97'),
	('C00020','3.1.3.5'),
	('C00020','3.1.3.7'),
	('C00020','2.7.9.2'),
	('C00020','2.7.9.3'),
	('C00020','2.8.1.13'),
	('C00020','2.7.9.1'),
	('C00020','2.7.6.1'),
	('C00020','2.7.6.2'),
	('C00020','2.7.6.3'),
	('C00020','2.7.6.4'),
	('C00020','2.7.6.5'),
	('C00020','2.7.4.10'),
	('C00020','2.7.4.3'),
	('C00020','3.6.1.61'),
	('C00020','3.6.1.8'),
	('C00020','3.6.1.9'),
	('C00020','3.6.2.1'),
	('C00020','3.6.1.29'),
	('C00020','3.6.1.5'),
	('C00020','3.6.1.53'),
	('C00020','3.6.1.60'),
	('C00020','3.6.1.13'),
	('C00020','3.6.1.17'),
	('C00020','3.6.1.18'),
	('C00020','3.6.1.20'),
	('C00020','3.6.1.21'),
	('C00020','3.6.1.22'),
	('C00020','3.5.4.6'),
	('C00020','3.5.4.17'),
	('C00020','6.1.1.4'),
	('C00020','6.1.1.5'),
	('C00020','6.1.1.6'),
	('C00020','6.1.1.7'),
	('C00020','6.1.1.1'),
	('C00020','6.1.1.10'),
	('C00020','6.1.1.11'),
	('C00020','6.1.1.12'),
	('C00020','6.1.1.13'),
	('C00020','6.1.1.14'),
	('C00021','1.16.1.8'),
	('C00021','2.1.1.116'),
	('C00021','2.1.1.117'),
	('C00021','2.1.1.118'),
	('C00021','2.1.1.119'),
	('C00021','2.1.1.12'),
	('C00021','2.1.1.120'),
	('C00021','2.1.1.121'),
	('C00021','2.1.1.122'),
	('C00021','2.1.1.123'),
	('C00021','2.1.1.127'),
	('C00021','2.1.1.128'),
	('C00021','2.1.1.129'),
	('C00021','2.1.1.1'),
	('C00021','2.1.1.10'),
	('C00021','2.1.1.100'),
	('C00021','2.1.1.101'),
	('C00021','2.1.1.169'),
	('C00021','2.1.1.17'),
	('C00021','2.1.1.171'),
	('C00021','2.1.1.172'),
	('C00021','2.1.1.173'),
	('C00021','2.1.1.174'),
	('C00021','2.1.1.175'),
	('C00021','2.1.1.18'),
	('C00021','2.1.1.181'),
	('C00021','2.1.1.182'),
	('C00021','2.1.1.183'),
	('C00021','2.1.1.184'),
	('C00021','2.1.1.187'),
	('C00021','2.1.1.188'),
	('C00021','2.1.1.195'),
	('C00021','2.1.1.196'),
	('C00021','2.1.1.197'),
	('C00021','2.1.1.2'),
	('C00021','2.1.1.20'),
	('C00021','2.1.1.201'),
	('C00021','2.1.1.202'),
	('C00021','2.1.1.203'),
	('C00021','2.1.1.204'),
	('C00021','2.1.1.130'),
	('C00021','2.1.1.131'),
	('C00021','2.1.1.132'),
	('C00021','2.1.1.133'),
	('C00021','2.1.1.136'),
	('C00021','2.1.1.137'),
	('C00021','2.1.1.139'),
	('C00021','2.1.1.140'),
	('C00021','2.1.1.141'),
	('C00021','2.1.1.142'),
	('C00021','2.1.1.143'),
	('C00021','2.1.1.144'),
	('C00021','2.1.1.145'),
	('C00021','2.1.1.146'),
	('C00021','2.1.1.147'),
	('C00021','2.1.1.15'),
	('C00021','2.1.1.150'),
	('C00021','2.1.1.151'),
	('C00021','2.1.1.152'),
	('C00021','2.1.1.153'),
	('C00021','2.1.1.154'),
	('C00021','2.1.1.155'),
	('C00021','2.1.1.156'),
	('C00021','2.1.1.157'),
	('C00021','2.1.1.158'),
	('C00021','2.1.1.159'),
	('C00021','2.1.1.102'),
	('C00021','2.1.1.103'),
	('C00021','2.1.1.104'),
	('C00021','2.1.1.105'),
	('C00021','2.1.1.106'),
	('C00021','2.1.1.107'),
	('C00021','2.1.1.108'),
	('C00021','2.1.1.109'),
	('C00021','2.1.1.11'),
	('C00021','2.1.1.110'),
	('C00021','2.1.1.111'),
	('C00021','2.1.1.112'),
	('C00021','2.1.1.113'),
	('C00021','2.1.1.114'),
	('C00021','2.1.1.115'),
	('C00021','2.1.1.275'),
	('C00021','2.1.1.276'),
	('C00021','2.1.1.277'),
	('C00021','2.1.1.278'),
	('C00021','2.1.1.279'),
	('C00021','2.1.1.28'),
	('C00021','2.1.1.281'),
	('C00021','2.1.1.282'),
	('C00021','2.1.1.283'),
	('C00021','2.1.1.284'),
	('C00021','2.1.1.285'),
	('C00021','2.1.1.286'),
	('C00021','2.1.1.287'),
	('C00021','2.1.1.288'),
	('C00021','2.1.1.289'),
	('C00021','2.1.1.290'),
	('C00021','2.1.1.291'),
	('C00021','2.1.1.292'),
	('C00021','2.1.1.293'),
	('C00021','2.1.1.294'),
	('C00021','2.1.1.295'),
	('C00021','2.1.1.296'),
	('C00021','2.1.1.297'),
	('C00021','2.1.1.298'),
	('C00021','2.1.1.300'),
	('C00021','2.1.1.302'),
	('C00021','2.1.1.303'),
	('C00021','2.1.1.304'),
	('C00021','2.1.1.210'),
	('C00021','2.1.1.212'),
	('C00021','2.1.1.22'),
	('C00021','2.1.1.222'),
	('C00021','2.1.1.228'),
	('C00021','2.1.1.231'),
	('C00021','2.1.1.232'),
	('C00021','2.1.1.234'),
	('C00021','2.1.1.235'),
	('C00021','2.1.1.236'),
	('C00021','2.1.1.237'),
	('C00021','2.1.1.238'),
	('C00021','2.1.1.239'),
	('C00021','2.1.1.240'),
	('C00021','2.1.1.241'),
	('C00021','2.1.1.243'),
	('C00021','2.1.1.25'),
	('C00021','2.1.1.254'),
	('C00021','2.1.1.255'),
	('C00021','2.1.1.26'),
	('C00021','2.1.1.261'),
	('C00021','2.1.1.262'),
	('C00021','2.1.1.263'),
	('C00021','2.1.1.267'),
	('C00021','2.1.1.27'),
	('C00021','2.1.1.270'),
	('C00021','2.1.1.271'),
	('C00021','2.1.1.16'),
	('C00021','2.1.1.160'),
	('C00021','2.1.1.161'),
	('C00021','2.1.1.162'),
	('C00021','2.1.1.163'),
	('C00021','2.1.1.164'),
	('C00021','2.1.1.165'),
	('C00021','2.1.1.53'),
	('C00021','2.1.1.55'),
	('C00021','2.1.1.56'),
	('C00021','2.1.1.57'),
	('C00021','2.1.1.59'),
	('C00021','2.1.1.6'),
	('C00021','2.1.1.60'),
	('C00021','2.1.1.61'),
	('C00021','2.1.1.62'),
	('C00021','2.1.1.64'),
	('C00021','2.1.1.65'),
	('C00021','2.1.1.67'),
	('C00021','2.1.1.68'),
	('C00021','2.1.1.69'),
	('C00021','2.1.1.7'),
	('C00021','2.1.1.70'),
	('C00021','2.1.1.71'),
	('C00021','2.1.1.72'),
	('C00021','2.1.1.75'),
	('C00021','2.1.1.76'),
	('C00021','2.1.1.77'),
	('C00021','2.1.1.78'),
	('C00021','2.1.1.79'),
	('C00021','2.1.1.8'),
	('C00021','2.1.1.80'),
	('C00021','2.1.1.82'),
	('C00021','2.1.1.83'),
	('C00021','2.1.1.84'),
	('C00021','2.1.1.85'),
	('C00021','2.1.1.87'),
	('C00021','2.1.1.305'),
	('C00021','2.1.1.306'),
	('C00021','2.1.1.307'),
	('C00021','2.1.1.314'),
	('C00021','2.1.1.315'),
	('C00021','2.1.1.316'),
	('C00021','2.1.1.317'),
	('C00021','2.1.1.319'),
	('C00021','2.1.1.320'),
	('C00021','2.1.1.321'),
	('C00021','2.1.1.322'),
	('C00021','2.1.1.323'),
	('C00021','2.1.1.324'),
	('C00021','2.1.1.325'),
	('C00021','2.1.1.33'),
	('C00021','2.1.1.34'),
	('C00021','2.1.1.35'),
	('C00021','2.1.1.37'),
	('C00021','2.1.1.38'),
	('C00021','2.1.1.39'),
	('C00021','2.1.1.4'),
	('C00021','2.1.1.40'),
	('C00021','2.1.1.41'),
	('C00021','2.1.1.42'),
	('C00021','2.1.1.43'),
	('C00021','2.1.1.44'),
	('C00021','2.1.1.47'),
	('C00021','2.1.1.49'),
	('C00021','2.1.1.50'),
	('C00021','2.1.1.273'),
	('C00021','2.1.1.274'),
	('C00021','2.3.1.161'),
	('C00021','2.1.1.88'),
	('C00021','2.1.1.89'),
	('C00021','2.1.1.9'),
	('C00021','2.1.1.91'),
	('C00021','2.1.1.94'),
	('C00021','2.1.1.95'),
	('C00021','2.1.1.96'),
	('C00021','2.1.1.97'),
	('C00021','2.1.1.98'),
	('C00021','2.1.1.99'),
	('C00021','2.3.1.231'),
	('C00021','3.2.2.9'),
	('C00021','3.3.1.1'),
	('C00021','2.8.4.3'),
	('C00021','2.8.4.4'),
	('C00021','2.8.4.5'),
	('C00021','3.5.4.28'),
	('C00021','6.3.2.40'),
	('C00022','4.3.1.19'),
	('C00022','4.1.3.22'),
	('C00022','4.1.3.25'),
	('C00022','4.1.3.27'),
	('C00022','4.1.3.3'),
	('C00022','4.1.3.30'),
	('C00022','4.1.3.32'),
	('C00022','4.1.3.38'),
	('C00022','4.1.3.39'),
	('C00022','4.1.3.40'),
	('C00022','4.1.3.42'),
	('C00022','4.1.3.43'),
	('C00022','4.1.3.44'),
	('C00022','4.1.3.45'),
	('C00022','4.1.3.46'),
	('C00022','6.4.1.1'),
	('C00022','2.6.1.99'),
	('C00022','2.6.3.1'),
	('C00022','2.7.1.121'),
	('C00022','2.6.1.66'),
	('C00022','2.6.1.71'),
	('C00022','2.6.1.77'),
	('C00022','2.6.1.84'),
	('C00022','2.6.1.41'),
	('C00022','3.3.2.1'),
	('C00022','3.3.2.13'),
	('C00022','3.11.1.3'),
	('C00022','3.1.3.60'),
	('C00022','2.7.9.2'),
	('C00022','2.8.1.2'),
	('C00022','2.7.9.1'),
	('C00022','2.7.3.9'),
	('C00022','4.1.99.1'),
	('C00022','4.1.99.2'),
	('C00022','4.1.2.14'),
	('C00022','4.1.2.18'),
	('C00022','4.1.2.20'),
	('C00022','4.1.2.21'),
	('C00022','4.1.2.23'),
	('C00022','4.1.2.28'),
	('C00022','4.1.2.34'),
	('C00022','4.1.2.45'),
	('C00022','4.1.2.51'),
	('C00022','4.1.2.52'),
	('C00022','4.1.2.53'),
	('C00022','4.1.2.54'),
	('C00022','4.1.2.55'),
	('C00022','4.1.2.58'),
	('C00022','4.1.3.16'),
	('C00022','4.1.3.17'),
	('C00022','4.1.1.64'),
	('C00022','4.1.1.78'),
	('C00022','4.1.1.3'),
	('C00022','4.1.1.1'),
	('C00022','3.7.1.20'),
	('C00022','3.7.1.23'),
	('C00022','3.7.1.5'),
	('C00022','3.7.1.6'),
	('C00022','3.5.99.10'),
	('C00022','4.4.1.28'),
	('C00022','4.4.1.6'),
	('C00022','4.4.1.8'),
	('C00022','4.5.1.2'),
	('C00022','4.3.3.7'),
	('C00022','4.4.1.1'),
	('C00022','4.4.1.13'),
	('C00022','4.4.1.15'),
	('C00022','4.4.1.24'),
	('C00022','4.4.1.25'),
	('C00022','4.2.99.20'),
	('C00022','4.2.99.21'),
	('C00022','4.3.1.10'),
	('C00022','4.3.1.13'),
	('C00022','4.3.1.15'),
	('C00022','4.3.1.17'),
	('C00022','4.3.1.18'),
	('C00022','1.1.2.3'),
	('C00022','1.1.2.4'),
	('C00022','1.1.2.5'),
	('C00022','1.1.1.83'),
	('C00022','1.1.1.40'),
	('C00022','1.1.1.38'),
	('C00022','1.1.1.39'),
	('C00022','1.1.1.27'),
	('C00022','1.1.1.28'),
	('C00022','1.1.99.6'),
	('C00022','1.1.99.7'),
	('C00022','1.14.11.43'),
	('C00022','1.14.11.44'),
	('C00022','1.2.7.1'),
	('C00022','1.2.7.11'),
	('C00022','1.2.3.15'),
	('C00022','1.2.3.3'),
	('C00022','1.2.3.6'),
	('C00022','1.2.1.49'),
	('C00022','1.2.1.51'),
	('C00022','1.2.1.22'),
	('C00022','1.2.1.23'),
	('C00022','1.4.1.17'),
	('C00022','1.4.1.1'),
	('C00022','1.2.4.1'),
	('C00022','1.2.5.1'),
	('C00022','1.5.1.22'),
	('C00022','1.5.1.23'),
	('C00022','1.5.1.24'),
	('C00022','1.5.1.26'),
	('C00022','1.5.1.28'),
	('C00022','1.5.1.11'),
	('C00022','1.5.1.16'),
	('C00022','1.5.1.17'),
	('C00022','1.4.3.3'),
	('C00022','1.4.3.19'),
	('C00022','1.8.1.4'),
	('C00022','2.1.3.1'),
	('C00022','2.3.1.182'),
	('C00022','2.3.1.12'),
	('C00022','2.2.1.12'),
	('C00022','2.2.1.6'),
	('C00022','2.2.1.7'),
	('C00022','2.3.1.54'),
	('C00022','2.6.1.40'),
	('C00022','2.6.1.108'),
	('C00022','2.6.1.12'),
	('C00022','2.6.1.15'),
	('C00022','2.6.1.43'),
	('C00022','2.6.1.44'),
	('C00022','2.6.1.46'),
	('C00022','2.6.1.47'),
	('C00022','2.6.1.51'),
	('C00022','2.6.1.56'),
	('C00022','2.6.1.58'),
	('C00022','2.6.1.18'),
	('C00022','2.6.1.2'),
	('C00022','2.6.1.21'),
	('C00022','2.6.1.30'),
	('C00022','2.6.1.37'),
	('C00022','2.7.1.40'),
	('C00022','2.6.1.96'),
	('C00024','4.1.1.9'),
	('C00024','4.1.3.24'),
	('C00024','4.1.3.25'),
	('C00024','4.1.3.34'),
	('C00024','4.1.3.35'),
	('C00024','4.1.3.4'),
	('C00024','6.2.1.1'),
	('C00024','6.2.1.13'),
	('C00024','6.4.1.2'),
	('C00024','2.3.3.6'),
	('C00024','2.3.1.8'),
	('C00024','2.3.1.80'),
	('C00024','2.3.1.81'),
	('C00024','2.3.1.82'),
	('C00024','2.3.1.84'),
	('C00024','2.3.1.85'),
	('C00024','2.3.1.86'),
	('C00024','2.3.1.87'),
	('C00024','2.3.1.88'),
	('C00024','2.3.1.89'),
	('C00024','2.3.1.9'),
	('C00024','2.3.1.5'),
	('C00024','2.3.1.53'),
	('C00024','2.3.1.54'),
	('C00024','2.3.1.57'),
	('C00024','2.3.1.59'),
	('C00024','2.3.1.6'),
	('C00024','2.3.1.60'),
	('C00024','2.3.1.66'),
	('C00024','2.3.1.67'),
	('C00024','2.3.1.69'),
	('C00024','2.3.1.7'),
	('C00024','2.3.1.78'),
	('C00024','2.3.1.79'),
	('C00024','2.3.1.245'),
	('C00024','2.3.1.247'),
	('C00024','2.3.1.27'),
	('C00024','2.3.1.28'),
	('C00024','2.3.1.29'),
	('C00024','2.3.1.3'),
	('C00024','2.3.1.30'),
	('C00024','2.3.1.31'),
	('C00024','2.3.1.33'),
	('C00024','2.3.1.34'),
	('C00024','2.3.1.36'),
	('C00024','2.3.1.38'),
	('C00024','2.3.1.4'),
	('C00024','2.3.1.44'),
	('C00024','2.3.1.45'),
	('C00024','2.3.1.48'),
	('C00024','2.3.1.223'),
	('C00024','2.3.1.224'),
	('C00024','2.3.1.227'),
	('C00024','2.3.1.236'),
	('C00024','2.3.1.237'),
	('C00024','2.3.1.2'),
	('C00024','2.3.1.201'),
	('C00024','2.3.3.8'),
	('C00024','2.3.3.9'),
	('C00024','2.6.1.33'),
	('C00024','3.1.2.1'),
	('C00024','2.8.3.19'),
	('C00024','2.8.3.3'),
	('C00024','2.8.3.8'),
	('C00024','2.8.3.1'),
	('C00024','2.8.3.10'),
	('C00024','2.8.3.11'),
	('C00024','2.8.3.12'),
	('C00024','2.8.3.14'),
	('C00024','2.8.3.18'),
	('C00024','4.1.3.46'),
	('C00024','4.1.2.41'),
	('C00024','1.2.7.1'),
	('C00024','1.2.7.11'),
	('C00024','1.2.7.4'),
	('C00024','1.2.3.6'),
	('C00024','1.2.1.51'),
	('C00024','1.2.1.18'),
	('C00024','1.2.1.27'),
	('C00024','1.2.1.10'),
	('C00024','1.2.4.1'),
	('C00024','1.8.1.4'),
	('C00024','2.1.1.258'),
	('C00024','2.1.3.1'),
	('C00024','2.3.1.202'),
	('C00024','2.3.1.203'),
	('C00024','2.3.1.205'),
	('C00024','2.3.1.209'),
	('C00024','2.3.1.210'),
	('C00024','2.3.1.174'),
	('C00024','2.3.1.175'),
	('C00024','2.3.1.178'),
	('C00024','2.3.1.18'),
	('C00024','2.3.1.180'),
	('C00024','2.3.1.182'),
	('C00024','2.3.1.183'),
	('C00024','2.3.1.185'),
	('C00024','2.3.1.186'),
	('C00024','2.3.1.189'),
	('C00024','2.3.1.190'),
	('C00024','2.3.1.194'),
	('C00024','2.3.1.195'),
	('C00024','2.3.1.197'),
	('C00024','2.3.1.150'),
	('C00024','2.3.1.155'),
	('C00024','2.3.1.157'),
	('C00024','2.3.1.16'),
	('C00024','2.3.1.160'),
	('C00024','2.3.1.162'),
	('C00024','2.3.1.163'),
	('C00024','2.3.1.165'),
	('C00024','2.3.1.167'),
	('C00024','2.3.1.169'),
	('C00024','2.3.1.17'),
	('C00024','2.3.1.118'),
	('C00024','2.3.1.12'),
	('C00024','2.3.1.128'),
	('C00024','2.3.1.136'),
	('C00024','2.3.1.1'),
	('C00024','2.3.1.10'),
	('C00024','2.3.1.102'),
	('C00024','2.3.1.105'),
	('C00024','2.3.1.107'),
	('C00024','2.3.1.108'),
	('C00024','2.3.1.11'),
	('C00024','2.3.3.1'),
	('C00024','2.3.3.10'),
	('C00024','2.3.3.13'),
	('C00024','2.3.3.14'),
	('C00024','2.3.3.16'),
	('C00024','2.3.3.3'),
	('C00025','6.3.2.42'),
	('C00025','6.3.2.31'),
	('C00025','6.3.2.32'),
	('C00025','6.3.2.33'),
	('C00025','6.3.2.34'),
	('C00025','6.3.1.6'),
	('C00025','6.3.2.12'),
	('C00025','6.3.2.17'),
	('C00025','6.3.2.18'),
	('C00025','6.3.2.2'),
	('C00025','2.6.1.72'),
	('C00025','2.6.1.75'),
	('C00025','2.6.1.76'),
	('C00025','2.6.1.79'),
	('C00025','2.6.1.8'),
	('C00025','2.6.1.80'),
	('C00025','2.6.1.81'),
	('C00025','2.6.1.82'),
	('C00025','2.6.1.83'),
	('C00025','2.6.1.85'),
	('C00025','2.6.1.86'),
	('C00025','2.6.1.87'),
	('C00025','2.6.1.89'),
	('C00025','2.6.1.9'),
	('C00025','2.6.1.90'),
	('C00025','2.6.1.92'),
	('C00025','2.6.1.93'),
	('C00025','2.6.1.42'),
	('C00025','3.5.1.65'),
	('C00025','3.5.1.68'),
	('C00025','3.5.1.38'),
	('C00025','3.5.1.55'),
	('C00025','3.5.1.2'),
	('C00025','3.5.1.118'),
	('C00025','3.4.17.21'),
	('C00025','3.4.19.13'),
	('C00025','3.4.19.14'),
	('C00025','3.4.19.9'),
	('C00025','2.7.2.11'),
	('C00025','2.7.2.13'),
	('C00025','4.1.1.15'),
	('C00025','3.5.3.8'),
	('C00025','3.5.1.87'),
	('C00025','3.5.1.94'),
	('C00025','3.5.1.96'),
	('C00025','3.5.2.9'),
	('C00025','5.4.3.9'),
	('C00025','5.4.99.1'),
	('C00025','5.1.1.3'),
	('C00025','4.3.3.6'),
	('C00025','4.1.3.27'),
	('C00025','6.3.1.11'),
	('C00025','6.3.1.17'),
	('C00025','6.3.1.18'),
	('C00025','6.3.1.2'),
	('C00025','6.2.1.39'),
	('C00025','6.1.1.17'),
	('C00025','6.1.1.24'),
	('C00025','6.3.5.9'),
	('C00025','6.3.5.1'),
	('C00025','6.3.5.10'),
	('C00025','6.3.5.11'),
	('C00025','6.3.5.2'),
	('C00025','6.3.5.3'),
	('C00025','6.3.5.4'),
	('C00025','6.3.5.5'),
	('C00025','6.3.5.6'),
	('C00025','6.3.5.7'),
	('C00025','6.3.4.2'),
	('C00025','6.3.4.24'),
	('C00025','6.3.4.12'),
	('C00025','6.3.2.41'),
	('C00025','1.2.1.88'),
	('C00025','1.4.1.2'),
	('C00025','1.4.1.13'),
	('C00025','1.4.1.14'),
	('C00025','1.5.1.9'),
	('C00025','1.5.3.18'),
	('C00025','1.5.1.10'),
	('C00025','1.4.7.1'),
	('C00025','1.4.3.11'),
	('C00025','1.4.1.3'),
	('C00025','1.4.1.4'),
	('C00025','1.5.99.5'),
	('C00025','2.1.1.21'),
	('C00025','2.1.2.5'),
	('C00025','2.3.1.14'),
	('C00025','2.3.1.1'),
	('C00025','2.3.2.2'),
	('C00025','2.3.1.35'),
	('C00025','2.6.1.40'),
	('C00025','2.6.1.1'),
	('C00025','2.6.1.102'),
	('C00025','2.6.1.103'),
	('C00025','2.6.1.104'),
	('C00025','2.6.1.106'),
	('C00025','2.6.1.107'),
	('C00025','2.6.1.11'),
	('C00025','2.6.1.110'),
	('C00025','2.6.1.13'),
	('C00025','2.6.1.16'),
	('C00025','2.4.2.14'),
	('C00025','2.6.1.44'),
	('C00025','2.6.1.48'),
	('C00025','2.6.1.49'),
	('C00025','2.6.1.5'),
	('C00025','2.6.1.52'),
	('C00025','2.6.1.55'),
	('C00025','2.6.1.57'),
	('C00025','2.6.1.59'),
	('C00025','2.6.1.6'),
	('C00025','2.6.1.17'),
	('C00025','2.6.1.19'),
	('C00025','2.6.1.2'),
	('C00025','2.6.1.22'),
	('C00025','2.6.1.23'),
	('C00025','2.6.1.24'),
	('C00025','2.6.1.26'),
	('C00025','2.6.1.27'),
	('C00025','2.6.1.29'),
	('C00025','2.6.1.3'),
	('C00025','2.6.1.33'),
	('C00025','2.6.1.34'),
	('C00025','2.6.1.36'),
	('C00025','2.6.1.38'),
	('C00025','2.6.1.39'),
	('C00025','2.6.1.4'),
	('C00025','2.6.1.94'),
	('C00025','2.6.1.95'),
	('C00025','2.6.1.98'),
	('C00025','2.6.1.65'),
	('C00025','2.6.1.67'),
	('C00025','2.6.1.7'),
	('C00026','2.6.1.7'),
	('C00026','2.6.1.72'),
	('C00026','2.6.1.74'),
	('C00026','2.6.1.75'),
	('C00026','2.6.1.76'),
	('C00026','2.6.1.79'),
	('C00026','2.6.1.8'),
	('C00026','2.6.1.80'),
	('C00026','2.6.1.81'),
	('C00026','2.6.1.82'),
	('C00026','2.6.1.83'),
	('C00026','2.6.1.87'),
	('C00026','2.6.1.89'),
	('C00026','2.6.1.9'),
	('C00026','2.6.1.90'),
	('C00026','2.6.1.92'),
	('C00026','2.6.1.93'),
	('C00026','2.6.1.42'),
	('C00026','3.5.1.36'),
	('C00026','3.5.1.3'),
	('C00026','3.5.1.111'),
	('C00026','4.1.1.71'),
	('C00026','6.4.1.7'),
	('C00026','1.2.1.3'),
	('C00026','1.2.1.26'),
	('C00026','1.4.1.2'),
	('C00026','1.4.1.13'),
	('C00026','1.4.1.14'),
	('C00026','1.2.4.2'),
	('C00026','1.5.1.7'),
	('C00026','1.5.1.8'),
	('C00026','1.5.1.19'),
	('C00026','1.4.3.7'),
	('C00026','1.4.7.1'),
	('C00026','1.4.3.11'),
	('C00026','1.4.3.15'),
	('C00026','1.4.1.3'),
	('C00026','1.4.1.4'),
	('C00026','1.8.1.4'),
	('C00026','2.2.1.5'),
	('C00026','2.2.1.9'),
	('C00026','2.3.3.14'),
	('C00026','2.3.3.4'),
	('C00026','2.3.1.61'),
	('C00026','2.6.1.4'),
	('C00026','2.6.1.40'),
	('C00026','2.6.1.1'),
	('C00026','2.6.1.102'),
	('C00026','2.6.1.103'),
	('C00026','2.6.1.104'),
	('C00026','2.6.1.106'),
	('C00026','2.6.1.107'),
	('C00026','2.6.1.11'),
	('C00026','2.6.1.110'),
	('C00026','2.6.1.13'),
	('C00026','2.6.1.44'),
	('C00026','2.6.1.48'),
	('C00026','2.6.1.49'),
	('C00026','2.6.1.5'),
	('C00026','2.6.1.52'),
	('C00026','2.6.1.54'),
	('C00026','2.6.1.55'),
	('C00026','2.6.1.57'),
	('C00026','2.6.1.59'),
	('C00026','2.6.1.6'),
	('C00026','2.6.1.17'),
	('C00026','2.6.1.19'),
	('C00026','2.6.1.2'),
	('C00026','2.6.1.21'),
	('C00026','2.6.1.22'),
	('C00026','2.6.1.23'),
	('C00026','2.6.1.24'),
	('C00026','2.6.1.26'),
	('C00026','2.6.1.27'),
	('C00026','2.6.1.29'),
	('C00026','2.6.1.3'),
	('C00026','2.6.1.33'),
	('C00026','2.6.1.34'),
	('C00026','2.6.1.36'),
	('C00026','2.6.1.38'),
	('C00026','2.6.1.39'),
	('C00026','2.6.1.94'),
	('C00026','2.6.1.95'),
	('C00026','2.6.1.98'),
	('C00026','2.6.1.65'),
	('C00026','2.6.1.67'),
	('C00026','1.1.99.39'),
	('C00026','1.1.1.95'),
	('C00026','1.1.1.399'),
	('C00026','1.1.1.41'),
	('C00026','1.1.1.42'),
	('C00026','1.1.1.286'),
	('C00026','1.14.11.18'),
	('C00026','1.14.11.19'),
	('C00026','1.14.11.2'),
	('C00026','1.14.11.20'),
	('C00026','1.14.11.21'),
	('C00026','1.14.11.22'),
	('C00026','1.14.11.23'),
	('C00026','1.14.11.24'),
	('C00026','1.14.11.1'),
	('C00026','1.14.11.10'),
	('C00026','1.14.11.11'),
	('C00026','1.13.12.19'),
	('C00026','1.1.99.2'),
	('C00026','1.1.99.24'),
	('C00026','1.14.20.3'),
	('C00026','1.14.20.1'),
	('C00026','1.14.20.2'),
	('C00026','1.14.11.8'),
	('C00026','1.14.11.9'),
	('C00026','1.14.11.40'),
	('C00026','1.14.11.41'),
	('C00026','1.14.11.42'),
	('C00026','1.14.11.43'),
	('C00026','1.14.11.44'),
	('C00026','1.14.11.45'),
	('C00026','1.14.11.46'),
	('C00026','1.14.11.48'),
	('C00026','1.14.11.49'),
	('C00026','1.14.11.50'),
	('C00026','1.14.11.51'),
	('C00026','1.14.11.52'),
	('C00026','1.14.11.6'),
	('C00026','1.14.11.7'),
	('C00026','1.14.11.25'),
	('C00026','1.14.11.26'),
	('C00026','1.14.11.27'),
	('C00026','1.14.11.28'),
	('C00026','1.14.11.3'),
	('C00026','1.14.11.31'),
	('C00026','1.14.11.32'),
	('C00026','1.14.11.34'),
	('C00026','1.14.11.35'),
	('C00026','1.14.11.36'),
	('C00026','1.14.11.37'),
	('C00026','1.14.11.38'),
	('C00026','1.14.11.39'),
	('C00026','1.14.11.4'),
	('C00026','1.14.11.12'),
	('C00026','1.14.11.13'),
	('C00026','1.14.11.14'),
	('C00026','1.14.11.15'),
	('C00026','1.14.11.16'),
	('C00026','1.14.11.17'),
	('C00026','1.2.7.11'),
	('C00026','1.2.7.3'),
	('C00026','1.2.1.52'),
	('C00027','1.8.3.6'),
	('C00027','1.7.3.1'),
	('C00027','1.7.3.3'),
	('C00027','1.7.3.5'),
	('C00027','1.6.3.1'),
	('C00027','1.6.3.3'),
	('C00027','1.6.3.5'),
	('C00027','1.5.3.2'),
	('C00027','1.5.3.21'),
	('C00027','1.5.3.4'),
	('C00027','1.5.3.5'),
	('C00027','1.5.3.6'),
	('C00027','1.5.3.7'),
	('C00027','1.2.3.14'),
	('C00027','1.2.3.15'),
	('C00027','1.2.3.3'),
	('C00027','1.2.3.4'),
	('C00027','1.2.3.5'),
	('C00027','1.2.3.6'),
	('C00027','1.2.3.7'),
	('C00027','1.2.3.8'),
	('C00027','1.2.3.9'),
	('C00027','1.17.3.2'),
	('C00027','1.17.3.3'),
	('C00027','1.15.1.1'),
	('C00027','1.15.1.2'),
	('C00027','1.4.3.1'),
	('C00027','1.3.3.4'),
	('C00027','1.3.3.6'),
	('C00027','1.3.3.7'),
	('C00027','1.3.3.8'),
	('C00027','1.3.3.10'),
	('C00027','1.3.3.11'),
	('C00027','1.3.3.12'),
	('C00027','1.3.3.13'),
	('C00027','1.3.3.14'),
	('C00027','1.3.3.15'),
	('C00027','1.21.3.3'),
	('C00027','1.21.3.8'),
	('C00027','1.5.99.6'),
	('C00027','1.5.3.1'),
	('C00027','1.5.3.10'),
	('C00027','1.5.3.12'),
	('C00027','1.5.3.13'),
	('C00027','1.5.3.14'),
	('C00027','1.5.3.15'),
	('C00027','1.5.3.16'),
	('C00027','1.5.3.17'),
	('C00027','1.5.3.18'),
	('C00027','1.5.3.19'),
	('C00027','1.4.3.22'),
	('C00027','1.4.3.23'),
	('C00027','1.4.3.24'),
	('C00027','1.4.3.3'),
	('C00027','1.4.3.4'),
	('C00027','1.4.3.5'),
	('C00027','1.4.3.7'),
	('C00027','1.4.3.8'),
	('C00027','1.4.9.2'),
	('C00027','1.4.3.10'),
	('C00027','1.4.3.11'),
	('C00027','1.4.3.12'),
	('C00027','1.4.3.13'),
	('C00027','1.4.3.14'),
	('C00027','1.4.3.15'),
	('C00027','1.4.3.16'),
	('C00027','1.4.3.19'),
	('C00027','1.4.3.2'),
	('C00027','1.4.3.20'),
	('C00027','1.4.3.21'),
	('C00027','1.8.3.1'),
	('C00027','1.8.3.2'),
	('C00027','1.8.3.3'),
	('C00027','1.8.3.4'),
	('C00027','1.8.3.5'),
	('C00027','1.1.3.27'),
	('C00027','1.1.3.29'),
	('C00027','1.1.3.30'),
	('C00027','1.1.3.37'),
	('C00027','1.1.3.38'),
	('C00027','1.1.3.39'),
	('C00027','1.1.3.4'),
	('C00027','1.1.3.40'),
	('C00027','1.1.3.41'),
	('C00027','1.1.3.42'),
	('C00027','1.1.3.43'),
	('C00027','1.1.3.44'),
	('C00027','1.1.3.45'),
	('C00027','1.1.3.46'),
	('C00027','1.1.3.47'),
	('C00027','1.1.3.49'),
	('C00027','1.1.3.5'),
	('C00027','1.1.3.6'),
	('C00027','1.1.3.7'),
	('C00027','1.1.3.8'),
	('C00027','1.1.3.9'),
	('C00027','1.1.5.4'),
	('C00027','1.1.3.10'),
	('C00027','1.1.3.11'),
	('C00027','1.1.3.12'),
	('C00027','1.1.3.13'),
	('C00027','1.1.3.15'),
	('C00027','1.1.3.16'),
	('C00027','1.1.3.17'),
	('C00027','1.1.3.18'),
	('C00027','1.1.3.19'),
	('C00027','1.1.3.21'),
	('C00027','1.1.3.23'),
	('C00027','1.11.2.5'),
	('C00027','1.11.1.13'),
	('C00027','1.11.1.14'),
	('C00027','1.11.1.16'),
	('C00027','1.11.1.17'),
	('C00027','1.11.1.18'),
	('C00027','1.11.1.19'),
	('C00027','1.11.1.2'),
	('C00027','1.11.1.21'),
	('C00027','1.11.1.23'),
	('C00027','1.11.1.3'),
	('C00027','1.11.1.5'),
	('C00027','1.11.1.6'),
	('C00027','1.11.1.7'),
	('C00027','1.11.1.8'),
	('C00027','1.11.1.9'),
	('C00027','1.11.2.1'),
	('C00027','1.11.2.2'),
	('C00027','1.11.2.4'),
	('C00027','1.1.99.9'),
	('C00027','1.10.3.5'),
	('C00027','1.10.3.6'),
	('C00027','1.11.1.1'),
	('C00027','1.11.1.10'),
	('C00027','1.11.1.11'),
	('C00027','1.1.99.18'),
	('C00027','1.2.2.4'),
	('C00027','1.2.3.1'),
	('C00028','1.6.99.3'),
	('C00028','1.6.5.11'),
	('C00028','1.5.99.12'),
	('C00028','1.5.99.13'),
	('C00028','1.5.99.14'),
	('C00028','1.5.99.15'),
	('C00028','1.5.99.3'),
	('C00028','1.5.99.4'),
	('C00028','1.5.99.5'),
	('C00028','3.2.1.31'),
	('C00028','4.1.99.19'),
	('C00028','4.4.1.16'),
	('C00028','4.3.1.30'),
	('C00028','4.1.99.22'),
	('C00028','1.14.99.4'),
	('C00028','1.14.99.43'),
	('C00028','1.14.99.44'),
	('C00028','1.14.99.45'),
	('C00028','1.14.99.47'),
	('C00028','1.14.99.48'),
	('C00028','1.14.99.49'),
	('C00028','1.14.99.1'),
	('C00028','1.14.99.11'),
	('C00028','1.14.99.12'),
	('C00028','1.3.99.12'),
	('C00028','1.3.99.14'),
	('C00028','1.3.99.16'),
	('C00028','1.3.99.17'),
	('C00028','1.3.99.18'),
	('C00028','1.3.99.19'),
	('C00028','1.3.99.23'),
	('C00028','1.3.99.25'),
	('C00028','1.3.99.26'),
	('C00028','1.3.99.27'),
	('C00028','1.3.99.28'),
	('C00028','1.3.99.29'),
	('C00028','1.3.99.30'),
	('C00028','1.3.99.31'),
	('C00028','1.3.99.32'),
	('C00028','1.3.99.33'),
	('C00028','1.3.99.4'),
	('C00028','1.3.99.5'),
	('C00028','1.3.99.6'),
	('C00028','1.3.99.8'),
	('C00028','1.3.5.5'),
	('C00028','1.3.5.6'),
	('C00028','1.3.7.11'),
	('C00028','1.3.7.8'),
	('C00028','1.3.8.1'),
	('C00028','1.3.8.7'),
	('C00028','1.21.99.1'),
	('C00028','1.21.99.3'),
	('C00028','1.21.99.4'),
	('C00028','1.2.99.5'),
	('C00028','1.2.99.6'),
	('C00028','1.2.99.7'),
	('C00028','1.2.99.8'),
	('C00028','1.20.99.1'),
	('C00028','1.5.99.6'),
	('C00028','1.4.99.5'),
	('C00028','1.4.99.6'),
	('C00028','1.4.9.2'),
	('C00028','1.4.99.2'),
	('C00028','1.8.99.2'),
	('C00028','1.8.99.5'),
	('C00028','1.97.1.1'),
	('C00028','1.97.1.8'),
	('C00028','1.97.1.9'),
	('C00028','1.7.99.1'),
	('C00028','1.7.99.4'),
	('C00028','1.7.2.1'),
	('C00028','1.6.5.3'),
	('C00028','1.6.99.1'),
	('C00028','1.1.99.29'),
	('C00028','1.1.99.3'),
	('C00028','1.1.99.30'),
	('C00028','1.1.99.31'),
	('C00028','1.1.99.32'),
	('C00028','1.1.99.33'),
	('C00028','1.1.99.35'),
	('C00028','1.1.99.39'),
	('C00028','1.1.99.4'),
	('C00028','1.1.99.1'),
	('C00028','1.12.99.6'),
	('C00028','1.11.1.16'),
	('C00028','1.11.1.21'),
	('C00028','1.11.1.7'),
	('C00028','1.1.99.6'),
	('C00028','1.1.99.9'),
	('C00028','1.10.3.4'),
	('C00028','1.1.99.11'),
	('C00028','1.1.99.12'),
	('C00028','1.1.99.13'),
	('C00028','1.1.99.14'),
	('C00028','1.1.99.18'),
	('C00028','1.1.99.2'),
	('C00028','1.1.99.20'),
	('C00028','1.1.99.21'),
	('C00028','1.1.99.22'),
	('C00028','1.1.99.26'),
	('C00028','1.1.99.27'),
	('C00028','1.14.99.14'),
	('C00028','1.14.99.15'),
	('C00028','1.14.99.19'),
	('C00028','1.14.99.2'),
	('C00028','1.14.99.20'),
	('C00028','1.14.99.21'),
	('C00028','1.14.99.22'),
	('C00028','1.14.99.23'),
	('C00028','1.14.99.24'),
	('C00028','1.14.99.26'),
	('C00028','1.14.19.3'),
	('C00028','1.14.19.37'),
	('C00028','1.14.18.1'),
	('C00028','1.14.19.15'),
	('C00028','1.14.14.16'),
	('C00028','1.14.14.17'),
	('C00028','1.14.14.18'),
	('C00028','1.14.14.19'),
	('C00028','1.14.11.38'),
	('C00028','1.17.99.1'),
	('C00028','1.17.99.2'),
	('C00028','1.17.99.3'),
	('C00028','1.17.99.4'),
	('C00028','1.14.99.27'),
	('C00028','1.14.99.29'),
	('C00028','1.14.99.35'),
	('C00028','1.14.99.37'),
	('C00028','1.14.99.38'),
	('C00028','1.14.99.39'),
	('C00029','2.4.1.52'),
	('C00029','2.4.1.53'),
	('C00029','2.4.1.58'),
	('C00029','2.4.1.63'),
	('C00029','2.4.1.66'),
	('C00029','2.4.1.71'),
	('C00029','2.4.1.73'),
	('C00029','2.4.1.78'),
	('C00029','2.4.1.80'),
	('C00029','2.4.1.81'),
	('C00029','2.4.1.85'),
	('C00029','2.4.1.91'),
	('C00029','2.4.1.310'),
	('C00029','2.4.1.314'),
	('C00029','2.4.1.315'),
	('C00029','2.4.1.323'),
	('C00029','2.4.1.324'),
	('C00029','2.4.1.330'),
	('C00029','2.4.1.336'),
	('C00029','2.4.1.337'),
	('C00029','2.4.1.338'),
	('C00029','2.4.1.34'),
	('C00029','2.4.1.35'),
	('C00029','2.4.1.263'),
	('C00029','2.4.1.271'),
	('C00029','2.4.1.276'),
	('C00029','2.4.1.284'),
	('C00029','2.4.1.286'),
	('C00029','2.4.1.295'),
	('C00029','3.13.1.1'),
	('C00029','2.7.7.9'),
	('C00029','2.7.8.19'),
	('C00029','2.7.8.31'),
	('C00029','2.7.7.64'),
	('C00029','2.7.7.12'),
	('C00029','3.6.1.8'),
	('C00029','3.6.1.9'),
	('C00029','3.6.1.45'),
	('C00029','5.1.3.2'),
	('C00029','4.2.1.76'),
	('C00029','1.1.1.22'),
	('C00029','2.4.1.296'),
	('C00029','2.4.1.297'),
	('C00029','2.4.1.298'),
	('C00029','2.4.1.301'),
	('C00029','2.4.1.305'),
	('C00029','2.4.1.215'),
	('C00029','2.4.1.218'),
	('C00029','2.4.1.219'),
	('C00029','2.4.1.220'),
	('C00029','2.4.1.237'),
	('C00029','2.4.1.238'),
	('C00029','2.4.1.239'),
	('C00029','2.4.1.240'),
	('C00029','2.4.1.242'),
	('C00029','2.4.1.245'),
	('C00029','2.4.1.249'),
	('C00029','2.4.1.170'),
	('C00029','2.4.1.171'),
	('C00029','2.4.1.172'),
	('C00029','2.4.1.173'),
	('C00029','2.4.1.176'),
	('C00029','2.4.1.177'),
	('C00029','2.4.1.178'),
	('C00029','2.4.1.181'),
	('C00029','2.4.1.183'),
	('C00029','2.4.1.185'),
	('C00029','2.4.1.186'),
	('C00029','2.4.1.188'),
	('C00029','2.4.1.192'),
	('C00029','2.4.1.193'),
	('C00029','2.4.1.194'),
	('C00029','2.4.1.195'),
	('C00029','2.4.1.196'),
	('C00029','2.4.1.202'),
	('C00029','2.4.1.203'),
	('C00029','2.4.1.208'),
	('C00029','2.4.1.209'),
	('C00029','2.4.1.210'),
	('C00029','2.4.1.136'),
	('C00029','2.4.1.14'),
	('C00029','2.4.1.15'),
	('C00029','2.4.1.158'),
	('C00029','2.4.1.160'),
	('C00029','2.4.1.103'),
	('C00029','2.4.1.104'),
	('C00029','2.4.1.105'),
	('C00029','2.4.1.106'),
	('C00029','2.4.1.11'),
	('C00029','2.4.1.111'),
	('C00029','2.4.1.114'),
	('C00029','2.4.1.115'),
	('C00029','2.4.1.116'),
	('C00029','2.4.1.117'),
	('C00029','2.4.1.118'),
	('C00029','2.4.1.12'),
	('C00029','2.4.1.120'),
	('C00029','2.4.1.121'),
	('C00029','2.4.1.126'),
	('C00029','2.4.1.127'),
	('C00029','2.4.1.128'),
	('C00029','2.4.1.13'),
	('C00030','1.8.99.2'),
	('C00030','1.8.99.5'),
	('C00030','1.97.1.1'),
	('C00030','1.97.1.8'),
	('C00030','1.97.1.9'),
	('C00030','1.7.2.1'),
	('C00030','1.7.99.1'),
	('C00030','1.7.99.4'),
	('C00030','1.6.5.3'),
	('C00030','3.2.1.31'),
	('C00030','4.4.1.16'),
	('C00030','4.3.1.30'),
	('C00030','4.1.99.22'),
	('C00030','4.1.99.19'),
	('C00030','1.14.99.24'),
	('C00030','1.14.99.26'),
	('C00030','1.14.19.3'),
	('C00030','1.14.19.37'),
	('C00030','1.14.18.1'),
	('C00030','1.14.19.15'),
	('C00030','1.14.14.16'),
	('C00030','1.14.14.17'),
	('C00030','1.14.14.18'),
	('C00030','1.14.14.19'),
	('C00030','1.14.11.38'),
	('C00030','1.6.99.1'),
	('C00030','1.6.99.3'),
	('C00030','1.6.5.11'),
	('C00030','1.5.99.12'),
	('C00030','1.5.99.13'),
	('C00030','1.5.99.14'),
	('C00030','1.5.99.15'),
	('C00030','1.5.99.3'),
	('C00030','1.5.99.4'),
	('C00030','1.5.99.5'),
	('C00030','1.5.99.6'),
	('C00030','1.4.99.5'),
	('C00030','1.4.99.6'),
	('C00030','1.4.9.2'),
	('C00030','1.4.99.2'),
	('C00030','1.3.99.8'),
	('C00030','1.3.99.12'),
	('C00030','1.3.99.14'),
	('C00030','1.3.99.16'),
	('C00030','1.3.99.17'),
	('C00030','1.3.99.18'),
	('C00030','1.3.99.19'),
	('C00030','1.3.99.23'),
	('C00030','1.3.99.25'),
	('C00030','1.3.99.26'),
	('C00030','1.3.99.27'),
	('C00030','1.3.99.28'),
	('C00030','1.3.99.29'),
	('C00030','1.3.99.30'),
	('C00030','1.3.99.31'),
	('C00030','1.3.99.32'),
	('C00030','1.3.99.33'),
	('C00030','1.3.99.4'),
	('C00030','1.3.99.5'),
	('C00030','1.3.99.6'),
	('C00030','1.3.5.5'),
	('C00030','1.3.5.6'),
	('C00030','1.3.7.11'),
	('C00030','1.3.7.8'),
	('C00030','1.3.8.1'),
	('C00030','1.3.8.7'),
	('C00030','1.21.99.1'),
	('C00030','1.21.99.3'),
	('C00030','1.21.99.4'),
	('C00030','1.2.99.5'),
	('C00030','1.12.99.6'),
	('C00030','1.11.1.16'),
	('C00030','1.11.1.21'),
	('C00030','1.11.1.7'),
	('C00030','1.1.99.6'),
	('C00030','1.1.99.9'),
	('C00030','1.10.3.4'),
	('C00030','1.1.99.1'),
	('C00030','1.1.99.11'),
	('C00030','1.1.99.12'),
	('C00030','1.1.99.13'),
	('C00030','1.1.99.14'),
	('C00030','1.1.99.18'),
	('C00030','1.1.99.2'),
	('C00030','1.1.99.20'),
	('C00030','1.1.99.21'),
	('C00030','1.1.99.22'),
	('C00030','1.1.99.26'),
	('C00030','1.1.99.27'),
	('C00030','1.1.99.29'),
	('C00030','1.1.99.3'),
	('C00030','1.1.99.30'),
	('C00030','1.1.99.31'),
	('C00030','1.1.99.32'),
	('C00030','1.1.99.33'),
	('C00030','1.1.99.35'),
	('C00030','1.1.99.39'),
	('C00030','1.1.99.4'),
	('C00030','1.2.99.6'),
	('C00030','1.2.99.7'),
	('C00030','1.2.99.8'),
	('C00030','1.20.99.1'),
	('C00030','1.17.99.1'),
	('C00030','1.17.99.2'),
	('C00030','1.17.99.3'),
	('C00030','1.17.99.4'),
	('C00030','1.14.99.27'),
	('C00030','1.14.99.29'),
	('C00030','1.14.99.35'),
	('C00030','1.14.99.37'),
	('C00030','1.14.99.38'),
	('C00030','1.14.99.39'),
	('C00030','1.14.99.4'),
	('C00030','1.14.99.43'),
	('C00030','1.14.99.44'),
	('C00030','1.14.99.45'),
	('C00030','1.14.99.47'),
	('C00030','1.14.99.48'),
	('C00030','1.14.99.49'),
	('C00030','1.14.99.1'),
	('C00030','1.14.99.11'),
	('C00030','1.14.99.12'),
	('C00030','1.14.99.14'),
	('C00030','1.14.99.15'),
	('C00030','1.14.99.19'),
	('C00030','1.14.99.2'),
	('C00030','1.14.99.20'),
	('C00030','1.14.99.21'),
	('C00030','1.14.99.22'),
	('C00030','1.14.99.23'),
	('C00031','3.2.1.84'),
	('C00031','3.2.1.86'),
	('C00031','3.2.1.93'),
	('C00031','3.2.1.186'),
	('C00031','3.2.1.188'),
	('C00031','3.2.1.189'),
	('C00031','3.2.1.20'),
	('C00031','3.2.1.21'),
	('C00031','3.2.1.22'),
	('C00031','3.2.1.23'),
	('C00031','3.2.1.26'),
	('C00031','3.2.1.28'),
	('C00031','3.2.1.3'),
	('C00031','3.2.1.39'),
	('C00031','3.2.1.42'),
	('C00031','3.2.1.45'),
	('C00031','3.2.1.48'),
	('C00031','5.3.1.5'),
	('C00031','4.2.99.22'),
	('C00031','4.2.99.23'),
	('C00031','1.1.99.28'),
	('C00031','1.1.99.35'),
	('C00031','1.1.5.2'),
	('C00031','1.1.5.9'),
	('C00031','1.1.3.10'),
	('C00031','1.1.1.359'),
	('C00031','1.1.1.360'),
	('C00031','1.1.1.118'),
	('C00031','1.1.1.119'),
	('C00031','1.1.1.121'),
	('C00031','2.4.1.279'),
	('C00031','2.4.1.281'),
	('C00031','2.4.1.22'),
	('C00031','2.4.1.230'),
	('C00031','2.4.1.245'),
	('C00031','2.4.1.25'),
	('C00031','2.4.1.20'),
	('C00031','2.4.1.10'),
	('C00031','2.3.1.90'),
	('C00031','2.3.1.91'),
	('C00031','2.3.1.92'),
	('C00031','2.3.1.72'),
	('C00031','2.3.1.152'),
	('C00031','2.3.1.143'),
	('C00031','2.3.1.103'),
	('C00031','2.7.1.61'),
	('C00031','2.7.1.62'),
	('C00031','2.7.1.63'),
	('C00031','2.7.1.41'),
	('C00031','2.7.1.42'),
	('C00031','2.7.1.199'),
	('C00031','2.7.1.2'),
	('C00031','2.7.1.142'),
	('C00031','2.7.1.147'),
	('C00031','2.7.1.1'),
	('C00031','2.4.1.99'),
	('C00031','2.4.1.64'),
	('C00031','2.4.1.8'),
	('C00031','2.4.1.9'),
	('C00031','2.4.1.31'),
	('C00031','3.2.1.58'),
	('C00031','3.2.1.104'),
	('C00031','3.2.1.105'),
	('C00031','3.2.1.106'),
	('C00031','3.2.1.107'),
	('C00031','3.2.1.108'),
	('C00031','3.2.1.117'),
	('C00031','3.2.1.118'),
	('C00031','3.2.1.122'),
	('C00031','3.2.1.125'),
	('C00031','3.2.1.126'),
	('C00031','3.2.1.147'),
	('C00031','3.2.1.175'),
	('C00031','3.1.6.3'),
	('C00031','3.2.1.10'),
	('C00031','3.1.4.48'),
	('C00031','3.1.3.9'),
	('C00031','3.1.3.58'),
	('C00031','3.1.3.10'),
	('C00031','3.1.1.33'),
	('C00031','3.2.1.62'),
	('C00031','3.2.1.74'),
	('C00032','1.14.99.48'),
	('C00032','1.14.14.18'),
	('C00032','4.99.1.1'),
	('C00032','4.4.1.17'),
	('C00033','1.13.11.50'),
	('C00033','1.1.1.318'),
	('C00033','1.1.1.319'),
	('C00033','1.2.99.6'),
	('C00033','1.2.5.1'),
	('C00033','1.2.5.2'),
	('C00033','1.2.1.5'),
	('C00033','1.2.1.3'),
	('C00033','1.2.1.4'),
	('C00033','1.14.14.32'),
	('C00033','1.14.13.54'),
	('C00033','1.13.12.4'),
	('C00033','2.3.1.187'),
	('C00033','2.1.1.152'),
	('C00033','2.7.2.12'),
	('C00033','2.7.2.15'),
	('C00033','2.6.99.3'),
	('C00033','2.5.1.65'),
	('C00033','2.5.1.134'),
	('C00033','2.5.1.47'),
	('C00033','2.5.1.48'),
	('C00033','2.5.1.49'),
	('C00033','2.5.1.50'),
	('C00033','2.5.1.51'),
	('C00033','2.5.1.52'),
	('C00033','2.5.1.53'),
	('C00033','2.5.1.118'),
	('C00033','2.5.1.119'),
	('C00033','3.11.1.2'),
	('C00033','3.1.1.8'),
	('C00033','3.1.1.80'),
	('C00033','3.1.1.94'),
	('C00033','3.1.2.1'),
	('C00033','3.1.2.16'),
	('C00033','3.1.1.33'),
	('C00033','3.1.1.41'),
	('C00033','3.1.1.47'),
	('C00033','3.1.1.53'),
	('C00033','3.1.1.54'),
	('C00033','3.1.1.55'),
	('C00033','3.1.1.56'),
	('C00033','3.1.1.58'),
	('C00033','3.1.1.6'),
	('C00033','3.1.1.66'),
	('C00033','3.1.1.7'),
	('C00033','3.1.1.71'),
	('C00033','2.8.3.19'),
	('C00033','2.8.3.3'),
	('C00033','2.8.3.8'),
	('C00033','3.1.1.2'),
	('C00033','2.8.3.1'),
	('C00033','2.8.3.10'),
	('C00033','2.8.3.11'),
	('C00033','2.8.3.12'),
	('C00033','2.8.3.14'),
	('C00033','2.8.3.18'),
	('C00033','2.7.2.1'),
	('C00033','3.6.1.7'),
	('C00033','3.6.1.20'),
	('C00033','3.5.1.89'),
	('C00033','3.5.1.62'),
	('C00033','3.5.1.63'),
	('C00033','3.5.1.66'),
	('C00033','3.5.1.76'),
	('C00033','3.5.1.85'),
	('C00033','3.5.1.33'),
	('C00033','3.5.1.4'),
	('C00033','3.5.1.41'),
	('C00033','3.5.1.47'),
	('C00033','3.5.1.48'),
	('C00033','3.5.1.51'),
	('C00033','3.5.1.14'),
	('C00033','3.5.1.15'),
	('C00033','3.5.1.16'),
	('C00033','3.5.1.17'),
	('C00033','3.5.1.21'),
	('C00033','3.5.1.25'),
	('C00033','3.5.1.29'),
	('C00033','3.5.1.103'),
	('C00033','3.5.1.104'),
	('C00033','3.5.1.108'),
	('C00033','3.5.1.112'),
	('C00033','3.5.1.113'),
	('C00033','3.5.1.114'),
	('C00033','6.2.1.35'),
	('C00033','6.2.1.22'),
	('C00033','6.2.1.1'),
	('C00033','6.2.1.13'),
	('C00033','4.1.3.22'),
	('C00033','4.1.3.26'),
	('C00033','4.1.3.4'),
	('C00033','4.1.3.6'),
	('C00033','4.1.1.88'),
	('C00033','4.1.1.89'),
	('C00033','3.7.1.1'),
	('C00033','3.7.1.6'),
	('C00035','1.17.4.1'),
	('C00035','2.4.1.269'),
	('C00035','2.4.1.270'),
	('C00035','2.4.1.29'),
	('C00035','2.4.1.217'),
	('C00035','2.4.1.246'),
	('C00035','2.4.1.251'),
	('C00035','2.4.1.132'),
	('C00035','2.4.1.142'),
	('C00035','2.4.1.152'),
	('C00035','2.4.1.110'),
	('C00035','2.7.2.10'),
	('C00035','2.7.1.81'),
	('C00035','2.7.1.48'),
	('C00035','2.7.1.40'),
	('C00035','2.7.1.190'),
	('C00035','2.7.1.156'),
	('C00035','2.4.1.54'),
	('C00035','2.4.1.65'),
	('C00035','2.4.1.69'),
	('C00035','2.4.1.83'),
	('C00035','2.4.1.308'),
	('C00035','2.4.1.32'),
	('C00035','2.4.1.33'),
	('C00035','2.4.1.36'),
	('C00035','2.4.1.48'),
	('C00035','2.4.1.252'),
	('C00035','3.1.7.2'),
	('C00035','2.7.7.88'),
	('C00035','2.7.7.69'),
	('C00035','2.7.7.78'),
	('C00035','2.7.7.8'),
	('C00035','2.7.4.8'),
	('C00035','2.7.7.22'),
	('C00035','2.7.4.6'),
	('C00035','3.6.5.1'),
	('C00035','3.6.5.2'),
	('C00035','3.6.1.42'),
	('C00035','3.6.1.5'),
	('C00035','3.6.1.6'),
	('C00035','3.2.1.42'),
	('C00035','6.3.4.4'),
	('C00035','6.3.2.31'),
	('C00035','6.3.2.34'),
	('C00035','6.2.1.4'),
	('C00035','6.2.1.10'),
	('C00035','4.1.1.32'),
	('C00035','3.6.5.3'),
	('C00035','3.6.5.4'),
	('C00035','3.6.5.5'),
	('C00035','3.6.5.6'),
	('C00036','1.1.99.7'),
	('C00036','1.1.5.4'),
	('C00036','1.1.1.82'),
	('C00036','1.1.1.40'),
	('C00036','1.1.1.38'),
	('C00036','1.1.1.37'),
	('C00036','1.1.1.299'),
	('C00036','1.4.3.15'),
	('C00036','1.4.3.16'),
	('C00036','1.4.3.2'),
	('C00036','1.4.3.1'),
	('C00036','1.4.1.21'),
	('C00036','2.3.3.8'),
	('C00036','2.3.3.1'),
	('C00036','2.3.3.16'),
	('C00036','2.3.3.2'),
	('C00036','2.3.3.3'),
	('C00036','2.3.3.5'),
	('C00036','2.1.3.1'),
	('C00036','2.6.1.70'),
	('C00036','2.6.1.78'),
	('C00036','2.6.1.57'),
	('C00036','2.6.1.21'),
	('C00036','2.6.1.31'),
	('C00036','2.6.1.35'),
	('C00036','2.6.1.1'),
	('C00036','2.6.1.12'),
	('C00036','3.1.1.44'),
	('C00036','3.5.1.3'),
	('C00036','6.4.1.1'),
	('C00036','5.3.2.2'),
	('C00036','4.3.1.16'),
	('C00036','4.3.1.20'),
	('C00036','4.3.1.27'),
	('C00036','4.2.1.81'),
	('C00036','4.2.1.32'),
	('C00036','4.1.3.34'),
	('C00036','4.1.3.6'),
	('C00036','4.1.3.13'),
	('C00036','4.1.3.17'),
	('C00036','4.1.1.3'),
	('C00036','4.1.1.31'),
	('C00036','4.1.1.32'),
	('C00036','4.1.1.38'),
	('C00036','4.1.1.49'),
	('C00036','3.7.1.1'),
	('C00037','1.21.4.2'),
	('C00037','1.13.11.78'),
	('C00037','1.5.8.3'),
	('C00037','1.5.3.1'),
	('C00037','1.5.1.22'),
	('C00037','1.4.99.5'),
	('C00037','1.4.3.3'),
	('C00037','1.4.4.2'),
	('C00037','1.4.3.19'),
	('C00037','1.4.2.1'),
	('C00037','1.4.1.1'),
	('C00037','1.4.1.10'),
	('C00037','2.3.2.15'),
	('C00037','2.3.1.65'),
	('C00037','2.3.1.71'),
	('C00037','2.3.1.29'),
	('C00037','2.3.1.37'),
	('C00037','2.3.1.192'),
	('C00037','2.3.1.13'),
	('C00037','2.1.2.1'),
	('C00037','2.1.2.10'),
	('C00037','2.1.2.4'),
	('C00037','2.1.4.1'),
	('C00037','2.1.1.162'),
	('C00037','2.1.1.20'),
	('C00037','2.1.1.156'),
	('C00037','1.8.1.4'),
	('C00037','2.6.1.96'),
	('C00037','2.6.1.73'),
	('C00037','2.6.1.44'),
	('C00037','2.6.1.45'),
	('C00037','2.6.1.60'),
	('C00037','2.6.1.63'),
	('C00037','2.6.1.35'),
	('C00037','2.6.1.4'),
	('C00037','3.5.3.2'),
	('C00037','3.5.1.71'),
	('C00037','3.5.1.58'),
	('C00037','3.5.1.24'),
	('C00037','3.5.1.32'),
	('C00037','3.4.11.1'),
	('C00037','3.4.11.2'),
	('C00037','3.4.11.23'),
	('C00037','6.3.4.13'),
	('C00037','6.3.2.3'),
	('C00037','6.1.1.14'),
	('C00037','4.1.3.41'),
	('C00037','4.1.2.26'),
	('C00037','4.1.2.42'),
	('C00037','4.1.2.48'),
	('C00037','4.1.2.49'),
	('C00037','4.1.2.5'),
	('C00037','4.1.3.14'),
	('C00039','2.1.1.37'),
	('C00039','2.7.7.7'),
	('C00039','2.7.7.31'),
	('C00039','2.7.7.49'),
	('C00039','6.5.1.7'),
	('C00039','6.5.1.1'),
	('C00039','6.5.1.2'),
	('C00039','6.5.1.6'),
	('C00040','2.3.1.185'),
	('C00040','2.3.1.186'),
	('C00040','2.3.1.198'),
	('C00040','2.3.1.16'),
	('C00040','2.3.1.164'),
	('C00040','2.3.1.111'),
	('C00040','2.3.1.121'),
	('C00040','2.3.1.125'),
	('C00040','2.3.1.13'),
	('C00040','2.3.1.15'),
	('C00040','1.3.3.6'),
	('C00040','1.3.8.7'),
	('C00040','1.3.8.8'),
	('C00040','1.3.1.8'),
	('C00040','1.3.1.44'),
	('C00040','1.3.1.37'),
	('C00040','1.3.1.38'),
	('C00040','1.2.7.11'),
	('C00040','2.3.1.51'),
	('C00040','2.3.1.52'),
	('C00040','2.3.1.62'),
	('C00040','2.3.1.63'),
	('C00040','2.3.1.68'),
	('C00040','2.3.1.75'),
	('C00040','2.3.1.76'),
	('C00040','2.3.1.25'),
	('C00040','2.3.1.26'),
	('C00040','2.3.1.42'),
	('C00040','2.3.1.23'),
	('C00040','2.3.1.24'),
	('C00040','2.3.1.199'),
	('C00040','2.3.1.20'),
	('C00040','2.3.1.22'),
	('C00040','3.1.2.20'),
	('C00040','3.1.2.18'),
	('C00040','3.1.2.19'),
	('C00040','2.8.3.8'),
	('C00040','6.2.1.2'),
	('C00040','6.2.1.3'),
	('C00040','6.2.1.10'),
	('C00041','1.5.1.17'),
	('C00041','1.4.1.1'),
	('C00041','2.6.1.108'),
	('C00041','2.6.1.12'),
	('C00041','2.6.1.15'),
	('C00041','2.3.1.47'),
	('C00041','2.6.1.96'),
	('C00041','2.6.1.99'),
	('C00041','2.6.1.66'),
	('C00041','2.6.1.71'),
	('C00041','2.6.1.77'),
	('C00041','2.6.1.84'),
	('C00041','2.6.1.40'),
	('C00041','2.6.1.41'),
	('C00041','2.6.1.43'),
	('C00041','2.6.1.44'),
	('C00041','2.6.1.46'),
	('C00041','2.6.1.47'),
	('C00041','2.6.1.51'),
	('C00041','2.6.1.56'),
	('C00041','2.6.1.58'),
	('C00041','2.6.1.18'),
	('C00041','2.6.1.2'),
	('C00041','2.6.1.30'),
	('C00041','2.6.1.37'),
	('C00041','3.7.1.3'),
	('C00041','3.5.1.28'),
	('C00041','2.8.1.7'),
	('C00041','6.3.2.49'),
	('C00041','6.3.2.8'),
	('C00041','6.1.1.7'),
	('C00041','5.1.1.1'),
	('C00041','4.4.1.16'),
	('C00041','4.1.1.64'),
	('C00041','4.1.1.12'),
	('C00042','3.5.1.96'),
	('C00042','3.5.1.18'),
	('C00042','3.1.2.3'),
	('C00042','3.1.2.13'),
	('C00042','2.8.3.2'),
	('C00042','2.8.3.20'),
	('C00042','2.8.3.22'),
	('C00042','2.8.3.5'),
	('C00042','2.8.3.6'),
	('C00042','2.8.3.13'),
	('C00042','2.8.3.15'),
	('C00042','2.8.3.18'),
	('C00042','6.2.1.4'),
	('C00042','6.2.1.5'),
	('C00042','4.1.3.30'),
	('C00042','4.1.3.1'),
	('C00042','1.14.11.8'),
	('C00042','1.14.11.9'),
	('C00042','1.14.11.4'),
	('C00042','1.14.11.40'),
	('C00042','1.14.11.41'),
	('C00042','1.14.11.42'),
	('C00042','1.14.11.43'),
	('C00042','1.14.11.44'),
	('C00042','1.14.11.45'),
	('C00042','1.14.11.46'),
	('C00042','1.14.11.48'),
	('C00042','1.14.11.49'),
	('C00042','1.14.11.50'),
	('C00042','1.14.11.51'),
	('C00042','1.14.11.52'),
	('C00042','1.14.11.6'),
	('C00042','1.14.11.7'),
	('C00042','1.14.11.25'),
	('C00042','1.14.11.26'),
	('C00042','1.14.11.27'),
	('C00042','1.14.11.28'),
	('C00042','1.14.11.3'),
	('C00042','1.14.11.31'),
	('C00042','1.14.11.32'),
	('C00042','1.14.11.34'),
	('C00042','1.14.11.35'),
	('C00042','1.14.11.36'),
	('C00042','1.14.11.37'),
	('C00042','1.14.11.38'),
	('C00042','1.14.11.39'),
	('C00042','1.14.11.12'),
	('C00042','1.14.11.13'),
	('C00042','1.14.11.14'),
	('C00042','1.14.11.15'),
	('C00042','1.14.11.16'),
	('C00042','1.14.11.17'),
	('C00042','1.14.11.18'),
	('C00042','1.14.11.19'),
	('C00042','1.14.11.2'),
	('C00042','1.14.11.20'),
	('C00042','1.14.11.21'),
	('C00042','1.14.11.22'),
	('C00042','1.14.11.23'),
	('C00042','1.14.11.24'),
	('C00042','1.14.11.1'),
	('C00042','1.14.11.10'),
	('C00042','1.14.11.11'),
	('C00042','1.3.4.1'),
	('C00042','1.3.5.1'),
	('C00042','1.3.5.4'),
	('C00042','1.3.98.1'),
	('C00042','1.3.1.6'),
	('C00042','1.2.1.79'),
	('C00042','1.2.1.24'),
	('C00042','1.2.1.16'),
	('C00042','1.14.20.2'),
	('C00042','1.14.20.3'),
	('C00042','1.14.20.1'),
	('C00042','2.5.1.48'),
	('C00042','3.7.1.14'),
	('C00043','1.1.1.374'),
	('C00043','1.1.1.136'),
	('C00043','2.3.1.129'),
	('C00043','2.5.1.7'),
	('C00043','2.4.1.94'),
	('C00043','2.4.1.56'),
	('C00043','2.4.1.70'),
	('C00043','2.4.1.312'),
	('C00043','2.4.1.39'),
	('C00043','2.4.1.255'),
	('C00043','2.4.1.283'),
	('C00043','2.4.1.285'),
	('C00043','2.4.1.212'),
	('C00043','2.4.1.223'),
	('C00043','2.4.1.224'),
	('C00043','2.4.1.227'),
	('C00043','2.4.1.250'),
	('C00043','2.4.1.198'),
	('C00043','2.4.1.201'),
	('C00043','2.4.1.206'),
	('C00043','2.4.1.138'),
	('C00043','2.4.1.141'),
	('C00043','2.4.1.143'),
	('C00043','2.4.1.144'),
	('C00043','2.4.1.145'),
	('C00043','2.4.1.146'),
	('C00043','2.4.1.147'),
	('C00043','2.4.1.148'),
	('C00043','2.4.1.149'),
	('C00043','2.4.1.150'),
	('C00043','2.4.1.153'),
	('C00043','2.4.1.155'),
	('C00043','2.4.1.16'),
	('C00043','2.4.1.163'),
	('C00043','2.4.1.164'),
	('C00043','2.4.1.102'),
	('C00043','2.7.7.23'),
	('C00043','2.7.1.176'),
	('C00043','3.2.1.183'),
	('C00043','2.7.8.15'),
	('C00043','2.7.8.17'),
	('C00043','2.7.8.18'),
	('C00043','2.7.8.33'),
	('C00043','2.7.8.35'),
	('C00043','5.1.3.14'),
	('C00043','5.1.3.2'),
	('C00043','5.1.3.7'),
	('C00043','4.2.1.115'),
	('C00043','4.2.1.135'),
	('C00044','1.17.4.2'),
	('C00044','2.7.7.68'),
	('C00044','2.7.7.71'),
	('C00044','2.7.7.86'),
	('C00044','2.7.7.30'),
	('C00044','2.7.7.34'),
	('C00044','2.7.7.45'),
	('C00044','2.7.7.48'),
	('C00044','2.7.7.50'),
	('C00044','2.7.4.6'),
	('C00044','2.7.6.5'),
	('C00044','2.7.7.13'),
	('C00044','2.7.7.28'),
	('C00044','2.7.2.10'),
	('C00044','2.7.1.81'),
	('C00044','2.7.1.48'),
	('C00044','2.7.1.40'),
	('C00044','2.7.1.190'),
	('C00044','2.7.1.156'),
	('C00044','3.6.5.3'),
	('C00044','3.6.5.4'),
	('C00044','3.6.5.5'),
	('C00044','3.6.5.6'),
	('C00044','3.6.5.1'),
	('C00044','3.6.5.2'),
	('C00044','3.6.1.8'),
	('C00044','3.6.1.5'),
	('C00044','3.6.1.17'),
	('C00044','3.5.4.39'),
	('C00044','3.5.4.16'),
	('C00044','3.5.4.25'),
	('C00044','3.5.4.29'),
	('C00044','2.7.7.6'),
	('C00044','2.7.7.62'),
	('C00044','2.7.7.65'),
	('C00044','6.5.1.7'),
	('C00044','6.5.1.5'),
	('C00044','6.3.4.4'),
	('C00044','6.3.2.31'),
	('C00044','6.3.2.34'),
	('C00044','6.2.1.4'),
	('C00044','6.2.1.10'),
	('C00044','4.6.1.1'),
	('C00044','4.6.1.2'),
	('C00044','4.1.99.22'),
	('C00044','4.1.1.32'),
	('C00045','2.6.1.14'),
	('C00045','2.3.2.2'),
	('C00046','2.7.7.8'),
	('C00046','2.7.7.48'),
	('C00046','2.7.7.52'),
	('C00046','2.7.7.19'),
	('C00046','2.7.7.6'),
	('C00046','6.5.1.3'),
	('C00047','1.13.12.2'),
	('C00047','2.1.3.8'),
	('C00047','1.5.3.4'),
	('C00047','1.5.1.7'),
	('C00047','1.5.1.8'),
	('C00047','1.5.1.16'),
	('C00047','1.4.3.14'),
	('C00047','1.4.3.20'),
	('C00047','1.4.1.15'),
	('C00047','1.4.1.18'),
	('C00047','1.14.13.59'),
	('C00047','2.6.1.105'),
	('C00047','2.3.1.32'),
	('C00047','2.6.1.71'),
	('C00047','2.6.1.36'),
	('C00047','4.1.1.18'),
	('C00047','4.1.1.20'),
	('C00047','3.5.2.11'),
	('C00047','3.5.1.17'),
	('C00047','3.5.1.12'),
	('C00047','3.4.13.4'),
	('C00047','3.4.14.13'),
	('C00047','6.3.4.19'),
	('C00047','6.3.2.7'),
	('C00047','6.3.2.20'),
	('C00047','6.3.2.11'),
	('C00047','6.1.1.6'),
	('C00047','5.4.3.2'),
	('C00047','5.4.99.58'),
	('C00047','5.1.1.5'),
	('C00047','5.1.1.9'),
	('C00047','4.3.1.28'),
	('C00048','1.14.12.11'),
	('C00048','1.1.99.14'),
	('C00048','1.1.3.15'),
	('C00048','1.1.1.79'),
	('C00048','1.1.1.29'),
	('C00048','1.1.1.26'),
	('C00048','2.2.1.5'),
	('C00048','1.4.3.3'),
	('C00048','1.4.3.19'),
	('C00048','1.4.2.1'),
	('C00048','1.4.1.1'),
	('C00048','1.4.1.10'),
	('C00048','1.2.3.15'),
	('C00048','1.2.3.5'),
	('C00048','1.2.1.17'),
	('C00048','1.14.14.10'),
	('C00048','2.3.3.9'),
	('C00048','2.3.3.11'),
	('C00048','2.3.3.12'),
	('C00048','2.3.3.7'),
	('C00048','2.6.1.96'),
	('C00048','2.6.1.73'),
	('C00048','2.6.1.44'),
	('C00048','2.6.1.45'),
	('C00048','2.6.1.60'),
	('C00048','2.6.1.63'),
	('C00048','2.6.1.35'),
	('C00048','2.6.1.4'),
	('C00048','3.5.1.116'),
	('C00048','4.3.2.3'),
	('C00048','4.3.2.5'),
	('C00048','4.1.3.24'),
	('C00048','4.1.3.41'),
	('C00048','4.1.3.42'),
	('C00048','4.1.3.1'),
	('C00048','4.1.3.13'),
	('C00048','4.1.3.14'),
	('C00048','4.1.3.16'),
	('C00048','4.1.1.47'),
	('C00049','2.3.1.17'),
	('C00049','2.1.3.2'),
	('C00049','1.4.3.16'),
	('C00049','1.4.3.2'),
	('C00049','1.4.1.21'),
	('C00049','2.6.1.12'),
	('C00049','2.7.2.4'),
	('C00049','2.6.1.70'),
	('C00049','2.6.1.78'),
	('C00049','2.6.1.57'),
	('C00049','2.6.1.31'),
	('C00049','2.6.1.35'),
	('C00049','2.6.1.1'),
	('C00049','4.1.1.15'),
	('C00049','3.5.5.4'),
	('C00049','3.5.3.14'),
	('C00049','3.5.1.7'),
	('C00049','3.5.1.8'),
	('C00049','3.5.1.38'),
	('C00049','3.5.1.15'),
	('C00049','3.5.1.26'),
	('C00049','3.5.1.1'),
	('C00049','6.3.5.4'),
	('C00049','6.3.4.4'),
	('C00049','6.3.4.5'),
	('C00049','6.3.2.6'),
	('C00049','6.3.2.29'),
	('C00049','6.3.1.1'),
	('C00049','6.3.1.4'),
	('C00049','6.1.1.23'),
	('C00049','6.1.1.12'),
	('C00049','5.1.1.13'),
	('C00049','4.3.1.1'),
	('C00049','4.1.1.11'),
	('C00049','4.1.1.12'),
	('C00051','1.8.1.9'),
	('C00051','1.8.3.3'),
	('C00051','1.8.4.1'),
	('C00051','1.8.4.2'),
	('C00051','1.8.4.3'),
	('C00051','1.8.4.4'),
	('C00051','1.8.1.10'),
	('C00051','1.5.4.1'),
	('C00051','1.20.4.2'),
	('C00051','1.13.11.18'),
	('C00051','1.11.1.12'),
	('C00051','1.11.1.9'),
	('C00051','2.5.1.18'),
	('C00051','2.3.2.15'),
	('C00051','2.3.2.2'),
	('C00051','1.8.4.7'),
	('C00051','1.8.4.9'),
	('C00051','1.8.5.1'),
	('C00051','1.8.1.7'),
	('C00051','3.1.2.6'),
	('C00051','3.1.2.7'),
	('C00051','3.1.2.12'),
	('C00051','3.1.2.13'),
	('C00051','2.8.1.3'),
	('C00051','6.3.2.3'),
	('C00051','6.3.1.8'),
	('C00051','6.3.1.9'),
	('C00051','4.4.1.5'),
	('C00051','4.4.1.20'),
	('C00051','4.4.1.22'),
	('C00051','3.5.1.78'),
	('C00051','3.4.19.13'),
	('C00052','2.4.1.96'),
	('C00052','2.4.1.50'),
	('C00052','2.4.1.62'),
	('C00052','2.4.1.74'),
	('C00052','2.4.1.86'),
	('C00052','2.4.1.87'),
	('C00052','2.4.1.90'),
	('C00052','2.4.1.307'),
	('C00052','2.4.1.309'),
	('C00052','2.4.1.37'),
	('C00052','2.4.1.38'),
	('C00052','2.4.1.44'),
	('C00052','2.4.1.45'),
	('C00052','2.4.1.46'),
	('C00052','2.4.1.47'),
	('C00052','2.4.1.272'),
	('C00052','2.4.1.274'),
	('C00052','2.4.1.275'),
	('C00052','2.4.1.294'),
	('C00052','2.4.1.303'),
	('C00052','2.4.1.304'),
	('C00052','2.4.1.22'),
	('C00052','2.4.1.228'),
	('C00052','2.4.1.23'),
	('C00052','2.4.1.234'),
	('C00052','2.4.1.241'),
	('C00052','2.4.1.179'),
	('C00052','2.4.1.205'),
	('C00052','2.4.1.137'),
	('C00052','2.4.1.156'),
	('C00052','2.4.1.167'),
	('C00052','2.4.1.123'),
	('C00052','2.7.8.18'),
	('C00052','2.7.8.6'),
	('C00052','2.7.7.64'),
	('C00052','2.7.7.10'),
	('C00052','2.7.7.12'),
	('C00052','5.1.3.2'),
	('C00052','5.4.99.9'),
	('C00053','2.7.1.25'),
	('C00053','1.8.4.8'),
	('C00053','2.8.2.1'),
	('C00053','2.8.2.10'),
	('C00053','2.8.2.11'),
	('C00053','2.8.2.13'),
	('C00053','2.8.2.14'),
	('C00053','2.8.2.15'),
	('C00053','2.8.2.16'),
	('C00053','2.8.2.17'),
	('C00053','2.8.2.18'),
	('C00053','2.8.2.19'),
	('C00053','2.8.2.2'),
	('C00053','2.8.2.20'),
	('C00053','2.8.2.21'),
	('C00053','2.8.2.23'),
	('C00053','2.8.2.24'),
	('C00053','2.8.2.25'),
	('C00053','3.1.3.7'),
	('C00053','2.8.2.26'),
	('C00053','2.8.2.27'),
	('C00053','2.8.2.28'),
	('C00053','2.8.2.29'),
	('C00053','2.8.2.3'),
	('C00053','2.8.2.30'),
	('C00053','2.8.2.31'),
	('C00053','2.8.2.32'),
	('C00053','2.8.2.33'),
	('C00053','2.8.2.34'),
	('C00053','2.8.2.35'),
	('C00053','2.8.2.36'),
	('C00053','2.8.2.37'),
	('C00053','2.8.2.4'),
	('C00053','2.8.2.5'),
	('C00053','2.8.2.6'),
	('C00053','2.8.2.7'),
	('C00053','2.8.2.8'),
	('C00053','2.8.2.9'),
	('C00053','3.6.2.2'),
	('C00054','1.8.4.8'),
	('C00054','2.8.2.1'),
	('C00054','2.8.2.10'),
	('C00054','2.8.2.11'),
	('C00054','2.8.2.13'),
	('C00054','2.8.2.14'),
	('C00054','2.8.2.15'),
	('C00054','2.8.2.16'),
	('C00054','2.8.2.17'),
	('C00054','2.8.2.18'),
	('C00054','2.8.2.19'),
	('C00054','2.8.2.2'),
	('C00054','2.8.2.20'),
	('C00054','2.8.2.21'),
	('C00054','2.8.2.23'),
	('C00054','2.8.2.24'),
	('C00054','2.7.8.7'),
	('C00054','3.1.3.97'),
	('C00054','3.1.3.7'),
	('C00054','2.8.2.25'),
	('C00054','2.8.2.26'),
	('C00054','2.8.2.27'),
	('C00054','2.8.2.28'),
	('C00054','2.8.2.29'),
	('C00054','2.8.2.3'),
	('C00054','2.8.2.30'),
	('C00054','2.8.2.31'),
	('C00054','2.8.2.32'),
	('C00054','2.8.2.33'),
	('C00054','2.8.2.34'),
	('C00054','2.8.2.35'),
	('C00054','2.8.2.36'),
	('C00054','2.8.2.37'),
	('C00054','2.8.2.4'),
	('C00054','2.8.2.5'),
	('C00054','2.8.2.6'),
	('C00054','2.8.2.7'),
	('C00054','2.8.2.8'),
	('C00054','2.8.2.9'),
	('C00054','3.6.2.2'),
	('C00055','2.7.1.48'),
	('C00055','2.4.99.1'),
	('C00055','2.4.99.10'),
	('C00055','2.4.99.11'),
	('C00055','2.4.99.12'),
	('C00055','2.4.99.13'),
	('C00055','2.4.99.14'),
	('C00055','2.4.99.15'),
	('C00055','2.4.99.2'),
	('C00055','2.4.99.4'),
	('C00055','2.4.99.5'),
	('C00055','2.4.99.6'),
	('C00055','2.4.99.7'),
	('C00055','2.4.99.8'),
	('C00055','2.4.99.9'),
	('C00055','2.4.2.57'),
	('C00055','2.7.8.1'),
	('C00055','2.7.8.10'),
	('C00055','2.7.8.11'),
	('C00055','2.7.8.12'),
	('C00055','2.7.8.14'),
	('C00055','2.7.8.2'),
	('C00055','2.7.8.22'),
	('C00055','2.7.8.24'),
	('C00055','2.7.8.3'),
	('C00055','2.7.8.34'),
	('C00055','2.7.8.38'),
	('C00055','2.7.8.39'),
	('C00055','2.7.8.4'),
	('C00055','2.7.8.41'),
	('C00055','2.7.8.5'),
	('C00055','2.7.8.8'),
	('C00055','2.7.4.14'),
	('C00055','2.7.4.25'),
	('C00055','3.1.4.40'),
	('C00055','3.1.3.91'),
	('C00055','3.1.3.5'),
	('C00055','6.3.2.5'),
	('C00055','4.6.1.12'),
	('C00055','3.6.1.65'),
	('C00055','3.6.1.8'),
	('C00055','3.6.1.9'),
	('C00055','3.6.1.5'),
	('C00055','3.6.1.53'),
	('C00055','3.6.1.16'),
	('C00055','3.6.1.26'),
	('C00055','3.2.2.10'),
	('C00058','1.2.98.1'),
	('C00058','1.2.99.5'),
	('C00058','1.2.99.9'),
	('C00058','1.2.2.1'),
	('C00058','1.2.2.3'),
	('C00058','1.2.1.43'),
	('C00058','1.2.1.46'),
	('C00058','1.2.1.2'),
	('C00058','1.14.99.21'),
	('C00058','1.14.14.14'),
	('C00058','1.14.13.70'),
	('C00058','1.14.12.11'),
	('C00058','1.13.11.72'),
	('C00058','1.13.11.81'),
	('C00058','1.13.11.41'),
	('C00058','1.13.11.53'),
	('C00058','1.13.11.54'),
	('C00058','1.1.99.33'),
	('C00058','1.1.5.6'),
	('C00058','1.1.1.306'),
	('C00058','2.3.1.54'),
	('C00058','2.7.2.6'),
	('C00058','3.1.2.10'),
	('C00058','3.1.2.12'),
	('C00058','2.8.3.16'),
	('C00058','6.3.4.23'),
	('C00058','6.3.4.3'),
	('C00058','6.3.4.17'),
	('C00058','4.1.99.5'),
	('C00058','4.1.99.12'),
	('C00058','4.1.99.17'),
	('C00058','4.1.2.36'),
	('C00058','4.1.2.44'),
	('C00058','4.1.1.2'),
	('C00058','3.7.1.9'),
	('C00058','3.5.4.39'),
	('C00058','3.5.4.16'),
	('C00058','3.5.4.25'),
	('C00058','3.5.1.88'),
	('C00058','3.5.1.9'),
	('C00058','3.5.1.91'),
	('C00058','3.5.1.68'),
	('C00058','3.5.1.8'),
	('C00058','3.5.1.49'),
	('C00058','3.5.1.56'),
	('C00058','3.5.1.15'),
	('C00058','3.5.1.31'),
	('C00058','3.5.1.10'),
	('C00058','3.5.1.102'),
	('C00058','3.5.1.106'),
	('C00059','1.8.2.1'),
	('C00059','1.8.3.1'),
	('C00059','1.8.4.3'),
	('C00059','2.5.1.18'),
	('C00059','2.7.7.4'),
	('C00059','2.7.7.5'),
	('C00059','2.7.7.51'),
	('C00059','2.7.7.53'),
	('C00059','3.12.1.1'),
	('C00059','3.1.6.1'),
	('C00059','3.1.6.10'),
	('C00059','3.1.6.11'),
	('C00059','3.1.6.12'),
	('C00059','3.1.6.13'),
	('C00059','3.1.6.14'),
	('C00059','3.1.6.16'),
	('C00059','3.1.6.17'),
	('C00059','3.1.6.18'),
	('C00059','3.1.6.2'),
	('C00059','4.3.1.10'),
	('C00059','3.6.2.1'),
	('C00059','3.6.2.2'),
	('C00059','3.2.1.147'),
	('C00059','3.1.6.3'),
	('C00059','3.1.6.4'),
	('C00059','3.1.6.6'),
	('C00059','3.1.6.8'),
	('C00059','3.1.6.9'),
	('C00059','3.10.1.1'),
	('C00059','3.10.1.2'),
	('C00060','1.1.1.318'),
	('C00060','3.5.5.1'),
	('C00060','1.2.99.7'),
	('C00060','1.2.5.2'),
	('C00060','1.2.7.5'),
	('C00060','1.2.3.1'),
	('C00060','1.2.1.5'),
	('C00060','1.2.1.3'),
	('C00060','1.2.1.4'),
	('C00060','1.14.14.3'),
	('C00060','3.1.1.26'),
	('C00060','3.1.1.3'),
	('C00060','3.1.1.32'),
	('C00060','2.7.1.61'),
	('C00060','3.5.5.2'),
	('C00060','3.5.5.5'),
	('C00060','3.5.5.7'),
	('C00060','3.5.1.97'),
	('C00060','3.5.1.6'),
	('C00060','3.5.1.81'),
	('C00060','3.5.1.82'),
	('C00060','3.5.1.83'),
	('C00060','3.5.1.35'),
	('C00060','3.5.1.38'),
	('C00060','3.5.1.4'),
	('C00060','3.5.1.42'),
	('C00060','3.5.1.43'),
	('C00060','3.5.1.44'),
	('C00060','3.5.1.5'),
	('C00060','3.5.1.14'),
	('C00060','3.5.1.15'),
	('C00060','3.5.1.17'),
	('C00060','3.5.1.19'),
	('C00060','3.5.1.2'),
	('C00060','3.5.1.20'),
	('C00060','3.5.1.23'),
	('C00060','3.5.1.29'),
	('C00060','3.5.1.3'),
	('C00060','3.5.1.30'),
	('C00060','3.5.1.1'),
	('C00060','3.5.1.11'),
	('C00060','3.5.1.114'),
	('C00060','3.5.1.12'),
	('C00060','3.5.1.13'),
	('C00060','3.1.2.20'),
	('C00060','3.1.2.7'),
	('C00060','3.1.1.79'),
	('C00060','3.1.1.8'),
	('C00060','3.1.2.18'),
	('C00060','3.1.2.19'),
	('C00060','3.1.1.34'),
	('C00060','3.1.1.4'),
	('C00060','3.1.1.5'),
	('C00060','3.1.1.52'),
	('C00060','3.1.1.1'),
	('C00060','6.2.1.2'),
	('C00060','6.2.1.10'),
	('C00060','3.7.1.5'),
	('C00060','3.6.1.7'),
	('C00060','3.6.1.20'),
	('C00060','1.2.99.6'),
	('C00061','1.14.14.5'),
	('C00061','1.14.14.10'),
	('C00061','1.14.14.12'),
	('C00061','1.14.14.13'),
	('C00061','1.14.14.21'),
	('C00061','1.14.14.22'),
	('C00061','1.13.12.16'),
	('C00061','1.1.99.31'),
	('C00061','1.5.1.38'),
	('C00061','1.5.1.39'),
	('C00061','1.5.1.41'),
	('C00061','1.5.1.42'),
	('C00061','1.3.99.24'),
	('C00061','1.16.8.1'),
	('C00061','1.14.99.46'),
	('C00061','1.14.14.3'),
	('C00061','2.7.7.2'),
	('C00061','2.7.1.26'),
	('C00061','2.7.1.42'),
	('C00061','2.7.1.161'),
	('C00061','3.1.3.2'),
	('C00061','3.6.1.9'),
	('C00061','3.6.1.18'),
	('C00062','1.14.13.39'),
	('C00062','1.14.13.165'),
	('C00062','1.14.11.41'),
	('C00062','1.14.11.34'),
	('C00062','1.13.12.1'),
	('C00062','2.3.1.109'),
	('C00062','2.1.4.1'),
	('C00062','2.1.4.2'),
	('C00062','1.5.1.11'),
	('C00062','1.5.1.19'),
	('C00062','2.7.3.3'),
	('C00062','2.6.1.84'),
	('C00062','2.5.1.66'),
	('C00062','3.5.3.6'),
	('C00062','3.5.3.1'),
	('C00062','3.2.2.19'),
	('C00062','6.3.2.48'),
	('C00062','6.3.2.24'),
	('C00062','6.3.2.30'),
	('C00062','6.3.2.11'),
	('C00062','6.1.1.19'),
	('C00062','5.1.1.9'),
	('C00062','4.3.2.1'),
	('C00062','4.1.1.19'),
	('C00063','1.17.4.2'),
	('C00063','2.7.7.93'),
	('C00063','2.7.7.57'),
	('C00063','2.7.7.6'),
	('C00063','2.7.7.60'),
	('C00063','2.7.7.67'),
	('C00063','2.7.7.72'),
	('C00063','2.7.7.74'),
	('C00063','2.7.7.81'),
	('C00063','2.7.7.82'),
	('C00063','2.7.7.33'),
	('C00063','2.7.7.38'),
	('C00063','2.7.7.39'),
	('C00063','2.7.7.40'),
	('C00063','2.7.7.41'),
	('C00063','2.7.7.43'),
	('C00063','2.7.7.48'),
	('C00063','2.7.4.6'),
	('C00063','2.7.7.14'),
	('C00063','2.7.7.15'),
	('C00063','2.7.1.40'),
	('C00063','2.7.1.174'),
	('C00063','2.7.1.182'),
	('C00063','2.7.1.161'),
	('C00063','2.7.1.108'),
	('C00063','2.7.1.11'),
	('C00063','3.5.4.13'),
	('C00063','6.3.4.2'),
	('C00063','6.3.2.5'),
	('C00063','4.6.1.6'),
	('C00063','3.6.1.65'),
	('C00063','3.6.1.8'),
	('C00063','3.6.1.9'),
	('C00063','3.6.1.5'),
	('C00064','2.3.2.1'),
	('C00064','2.3.2.14'),
	('C00064','2.3.1.68'),
	('C00064','2.3.1.14'),
	('C00064','1.4.7.1'),
	('C00064','1.4.1.13'),
	('C00064','1.4.1.14'),
	('C00064','2.6.1.85'),
	('C00064','2.6.1.86'),
	('C00064','2.6.1.50'),
	('C00064','2.6.1.64'),
	('C00064','2.6.1.100'),
	('C00064','2.6.1.101'),
	('C00064','2.6.1.15'),
	('C00064','2.6.1.16'),
	('C00064','2.4.2.14'),
	('C00064','3.5.1.38'),
	('C00064','3.5.1.2'),
	('C00064','6.3.5.9'),
	('C00064','6.3.5.1'),
	('C00064','6.3.5.10'),
	('C00064','6.3.5.11'),
	('C00064','6.3.5.2'),
	('C00064','6.3.5.3'),
	('C00064','6.3.5.4'),
	('C00064','6.3.5.5'),
	('C00064','6.3.5.6'),
	('C00064','6.3.5.7'),
	('C00064','6.3.4.2'),
	('C00064','6.3.1.2'),
	('C00064','6.1.1.18'),
	('C00064','5.1.1.10'),
	('C00064','4.3.3.6'),
	('C00064','4.1.3.27'),
	('C00065','1.1.1.387'),
	('C00065','1.1.1.276'),
	('C00065','2.3.1.50'),
	('C00065','2.3.1.30'),
	('C00065','2.1.2.1'),
	('C00065','1.4.1.7'),
	('C00065','2.8.1.4'),
	('C00065','2.7.8.29'),
	('C00065','2.7.8.38'),
	('C00065','2.7.8.4'),
	('C00065','2.7.8.8'),
	('C00065','2.7.1.80'),
	('C00065','2.6.1.45'),
	('C00065','2.6.1.51'),
	('C00065','3.5.1.61'),
	('C00065','3.1.4.13'),
	('C00065','3.1.3.3'),
	('C00065','6.3.2.14'),
	('C00065','6.1.1.11'),
	('C00065','5.1.1.10'),
	('C00065','5.1.1.18'),
	('C00065','4.3.1.17'),
	('C00065','4.3.1.19'),
	('C00065','4.2.1.50'),
	('C00065','4.2.1.20'),
	('C00065','4.2.1.22'),
	('C00065','4.2.1.122'),
	('C00066','2.3.2.12'),
	('C00066','3.1.1.29'),
	('C00066','2.7.7.56'),
	('C00066','2.5.1.75'),
	('C00067','1.14.14.5'),
	('C00067','1.14.14.1'),
	('C00067','1.14.13.82'),
	('C00067','1.14.13.178'),
	('C00067','1.14.13.179'),
	('C00067','1.14.13.131'),
	('C00067','1.14.13.128'),
	('C00067','1.14.13.111'),
	('C00067','1.14.11.51'),
	('C00067','1.14.11.27'),
	('C00067','1.14.11.31'),
	('C00067','1.14.11.32'),
	('C00067','1.11.1.21'),
	('C00067','1.11.1.6'),
	('C00067','1.11.1.7'),
	('C00067','1.1.99.37'),
	('C00067','1.1.2.7'),
	('C00067','1.1.3.13'),
	('C00067','1.1.1.244'),
	('C00067','2.2.1.3'),
	('C00067','2.1.2.11'),
	('C00067','1.8.3.4'),
	('C00067','1.5.3.2'),
	('C00067','1.5.3.4'),
	('C00067','1.5.8.1'),
	('C00067','1.5.8.2'),
	('C00067','1.5.8.3'),
	('C00067','1.5.8.4'),
	('C00067','1.5.99.5'),
	('C00067','1.5.3.1'),
	('C00067','1.5.3.10'),
	('C00067','1.5.3.19'),
	('C00067','1.4.9.1'),
	('C00067','1.4.3.21'),
	('C00067','1.2.98.1'),
	('C00067','1.2.1.46'),
	('C00067','1.14.99.15'),
	('C00067','4.5.1.3'),
	('C00067','4.4.1.22'),
	('C00067','4.2.1.147'),
	('C00067','4.1.2.12'),
	('C00067','4.1.2.2'),
	('C00067','4.1.2.24'),
	('C00067','4.1.2.32'),
	('C00067','4.1.2.43'),
	('C00067','3.8.1.1'),
	('C00068','2.2.1.1'),
	('C00068','2.2.1.3'),
	('C00068','2.2.1.6'),
	('C00068','1.2.4.1'),
	('C00068','1.2.4.2'),
	('C00068','1.2.4.4'),
	('C00068','2.7.6.2'),
	('C00068','2.7.4.15'),
	('C00068','2.7.4.16'),
	('C00068','2.7.4.3'),
	('C00068','4.1.1.1'),
	('C00068','3.6.1.28'),
	('C00068','3.6.1.15'),
	('C00069','1.11.1.15'),
	('C00069','1.11.2.3'),
	('C00069','1.1.1.71'),
	('C00069','1.1.1.2'),
	('C00069','2.3.1.84'),
	('C00069','2.3.1.152'),
	('C00069','3.1.1.1'),
	('C00069','2.8.2.2'),
	('C00069','3.2.1.85'),
	('C00069','3.2.1.88'),
	('C00069','3.2.1.31'),
	('C00069','3.2.1.51'),
	('C00069','3.2.1.112'),
	('C00069','3.2.1.139'),
	('C00069','3.2.1.149'),
	('C00069','3.1.4.46'),
	('C00069','3.1.3.2'),
	('C00069','3.1.3.1'),
	('C00069','3.1.1.43'),
	('C00069','3.1.1.48'),
	('C00069','3.1.1.6'),
	('C00071','1.1.99.20'),
	('C00071','1.1.9.1'),
	('C00071','1.1.2.7'),
	('C00071','1.1.3.13'),
	('C00071','1.1.1.71'),
	('C00071','1.1.1.2'),
	('C00071','1.1.1.1'),
	('C00071','1.7.3.1'),
	('C00071','1.4.3.4'),
	('C00071','1.4.3.21'),
	('C00071','1.2.99.6'),
	('C00071','1.2.99.7'),
	('C00071','1.2.5.2'),
	('C00071','1.2.7.5'),
	('C00071','1.2.3.1'),
	('C00071','1.2.1.5'),
	('C00071','1.2.1.3'),
	('C00071','1.2.1.4'),
	('C00071','1.14.14.3'),
	('C00071','1.14.14.5'),
	('C00071','4.1.2.10'),
	('C00071','4.1.2.11'),
	('C00071','4.1.2.47'),
	('C00071','4.1.1.1'),
	('C00071','3.3.2.2'),
	('C00072','1.10.3.3'),
	('C00072','1.11.1.11'),
	('C00072','1.1.3.8'),
	('C00072','1.8.5.1'),
	('C00072','1.6.5.4'),
	('C00072','1.3.2.3'),
	('C00072','1.3.3.12'),
	('C00072','1.23.5.1'),
	('C00072','1.16.5.1'),
	('C00072','1.14.17.4'),
	('C00072','1.14.17.1'),
	('C00072','1.14.17.3'),
	('C00072','1.10.2.1'),
	('C00072','2.7.1.194'),
	('C00073','1.1.99.38'),
	('C00073','2.1.1.308'),
	('C00073','2.1.1.5'),
	('C00073','2.1.1.280'),
	('C00073','2.1.1.3'),
	('C00073','2.1.1.14'),
	('C00073','2.1.1.12'),
	('C00073','2.1.1.13'),
	('C00073','1.97.1.4'),
	('C00073','2.1.1.10'),
	('C00073','1.8.4.11'),
	('C00073','1.8.4.13'),
	('C00073','1.8.4.14'),
	('C00073','1.4.3.2'),
	('C00073','1.3.98.3'),
	('C00073','1.21.98.1'),
	('C00073','2.8.1.6'),
	('C00073','2.8.1.8'),
	('C00073','2.6.1.73'),
	('C00073','2.6.1.88'),
	('C00073','2.6.1.5'),
	('C00073','2.6.1.57'),
	('C00073','2.5.1.94'),
	('C00073','2.5.1.6'),
	('C00073','2.5.1.63'),
	('C00073','2.5.1.77'),
	('C00073','2.5.1.49'),
	('C00073','2.5.1.120'),
	('C00073','6.1.1.10'),
	('C00073','5.1.1.2'),
	('C00073','4.4.1.11'),
	('C00073','4.3.1.30'),
	('C00073','4.1.99.22'),
	('C00073','4.1.3.44'),
	('C00073','4.1.99.17'),
	('C00073','4.1.99.19'),
	('C00073','4.1.1.57'),
	('C00073','3.5.1.31'),
	('C00073','3.4.13.12'),
	('C00073','2.8.4.3'),
	('C00073','2.8.4.4'),
	('C00073','2.8.4.5'),
	('C00074','2.7.9.1'),
	('C00074','2.7.3.9'),
	('C00074','2.7.1.40'),
	('C00074','2.7.1.121'),
	('C00074','2.5.1.95'),
	('C00074','2.5.1.97'),
	('C00074','2.5.1.54'),
	('C00074','2.5.1.55'),
	('C00074','2.5.1.56'),
	('C00074','2.5.1.57'),
	('C00074','2.5.1.7'),
	('C00074','2.5.1.19'),
	('C00074','2.5.1.101'),
	('C00074','5.4.2.9'),
	('C00074','4.4.1.19'),
	('C00074','4.2.1.11'),
	('C00074','4.1.1.31'),
	('C00074','4.1.1.32'),
	('C00074','4.1.1.38'),
	('C00074','4.1.1.49'),
	('C00074','3.1.3.60'),
	('C00074','2.7.9.2'),
	('C00075','1.17.4.2'),
	('C00075','2.7.7.9'),
	('C00075','2.7.7.59'),
	('C00075','2.7.7.6'),
	('C00075','2.7.7.64'),
	('C00075','2.7.7.83'),
	('C00075','2.7.7.44'),
	('C00075','2.7.7.48'),
	('C00075','2.7.7.52'),
	('C00075','2.7.4.6'),
	('C00075','2.7.7.10'),
	('C00075','2.7.7.11'),
	('C00075','2.7.7.23'),
	('C00075','2.7.4.10'),
	('C00075','2.7.1.48'),
	('C00075','2.7.1.40'),
	('C00075','2.7.1.11'),
	('C00075','6.3.4.2'),
	('C00075','3.6.1.8'),
	('C00075','3.6.1.9'),
	('C00075','3.6.1.39'),
	('C00075','3.6.1.5'),
	('C00075','3.6.1.17'),
	('C00075','3.5.4.13'),
	('C00077','2.1.4.1'),
	('C00077','1.5.1.24'),
	('C00077','1.14.13.196'),
	('C00077','1.14.13.195'),
	('C00077','2.6.1.13'),
	('C00077','2.3.1.35'),
	('C00077','2.3.1.127'),
	('C00077','2.1.4.2'),
	('C00077','2.1.3.3'),
	('C00077','5.1.1.9'),
	('C00077','5.1.1.10'),
	('C00077','5.1.1.12'),
	('C00077','4.3.1.12'),
	('C00077','4.1.1.17'),
	('C00077','3.5.3.1'),
	('C00077','3.5.3.25'),
	('C00077','3.5.1.14'),
	('C00077','3.5.1.16'),
	('C00077','3.5.1.20'),
	('C00078','2.1.1.106'),
	('C00078','1.4.3.2'),
	('C00078','1.4.1.19'),
	('C00078','1.3.3.10'),
	('C00078','1.14.19.9'),
	('C00078','1.14.16.4'),
	('C00078','1.14.13.125'),
	('C00078','1.13.12.3'),
	('C00078','1.13.99.3'),
	('C00078','1.13.11.52'),
	('C00078','1.13.11.11'),
	('C00078','2.6.1.99'),
	('C00078','2.6.1.27'),
	('C00078','2.6.1.28'),
	('C00078','2.5.1.80'),
	('C00078','2.5.1.34'),
	('C00078','6.1.1.2'),
	('C00078','4.3.1.31'),
	('C00078','4.2.1.20'),
	('C00078','4.2.1.122'),
	('C00078','4.1.99.1'),
	('C00078','4.1.1.28'),
	('C00078','3.5.1.57'),
	('C00079','1.4.3.2'),
	('C00079','1.4.1.20'),
	('C00079','1.14.16.1'),
	('C00079','1.14.16.7'),
	('C00079','1.14.13.124'),
	('C00079','1.13.12.9'),
	('C00079','1.11.1.21'),
	('C00079','2.6.1.70'),
	('C00079','2.6.1.9'),
	('C00079','2.6.1.5'),
	('C00079','2.6.1.57'),
	('C00079','2.6.1.58'),
	('C00079','2.6.1.64'),
	('C00079','2.6.1.28'),
	('C00079','2.6.1.1'),
	('C00079','2.3.1.53'),
	('C00079','6.3.2.40'),
	('C00079','6.1.1.20'),
	('C00079','5.4.3.10'),
	('C00079','5.4.3.11'),
	('C00079','5.1.1.11'),
	('C00079','4.3.1.24'),
	('C00079','4.3.1.25'),
	('C00079','4.2.1.51'),
	('C00079','4.2.1.91'),
	('C00079','4.1.1.53'),
	('C00079','4.1.1.28'),
	('C00079','3.4.17.23'),
	('C00080','1.1.1.141'),
	('C00080','1.1.1.142'),
	('C00080','1.1.1.143'),
	('C00080','1.1.1.144'),
	('C00080','1.1.1.145'),
	('C00080','1.1.1.146'),
	('C00080','1.1.1.147'),
	('C00080','1.1.1.148'),
	('C00080','1.1.1.149'),
	('C00080','1.1.1.15'),
	('C00080','1.1.1.150'),
	('C00080','1.1.1.151'),
	('C00080','1.1.1.152'),
	('C00080','1.1.1.153'),
	('C00080','1.1.1.154'),
	('C00080','1.1.1.156'),
	('C00080','1.1.1.124'),
	('C00080','1.1.1.125'),
	('C00080','1.1.1.126'),
	('C00080','1.1.1.127'),
	('C00080','1.1.1.129'),
	('C00080','1.1.1.13'),
	('C00080','1.1.1.130'),
	('C00080','1.1.1.131'),
	('C00080','1.1.1.132'),
	('C00080','1.1.1.133'),
	('C00080','1.1.1.134'),
	('C00080','1.1.1.135'),
	('C00080','1.1.1.136'),
	('C00080','1.1.1.137'),
	('C00080','1.1.1.138'),
	('C00080','1.1.1.14'),
	('C00080','1.1.1.107'),
	('C00080','1.1.1.108'),
	('C00080','1.1.1.11'),
	('C00080','1.1.1.110'),
	('C00080','1.1.1.111'),
	('C00080','1.1.1.112'),
	('C00080','1.1.1.113'),
	('C00080','1.1.1.114'),
	('C00080','1.1.1.115'),
	('C00080','1.1.1.116'),
	('C00080','1.1.1.117'),
	('C00080','1.1.1.118'),
	('C00080','1.1.1.119'),
	('C00080','1.1.1.12'),
	('C00080','1.1.1.120'),
	('C00080','1.1.1.121'),
	('C00080','1.1.1.122'),
	('C00080','1.1.1.123'),
	('C00080','1.1.1.1'),
	('C00080','1.1.1.10'),
	('C00080','1.1.1.100'),
	('C00080','1.1.1.101'),
	('C00080','1.1.1.102'),
	('C00080','1.1.1.103'),
	('C00080','1.1.1.104'),
	('C00080','1.1.1.105'),
	('C00080','1.1.1.106'),
	('C00080','1.1.1.222'),
	('C00080','1.1.1.223'),
	('C00080','1.1.1.224'),
	('C00080','1.1.1.225'),
	('C00080','1.1.1.226'),
	('C00080','1.1.1.227'),
	('C00080','1.1.1.195'),
	('C00080','1.1.1.196'),
	('C00080','1.1.1.197'),
	('C00080','1.1.1.198'),
	('C00080','1.1.1.199'),
	('C00080','1.1.1.2'),
	('C00080','1.1.1.20'),
	('C00080','1.1.1.200'),
	('C00080','1.1.1.201'),
	('C00080','1.1.1.202'),
	('C00080','1.1.1.203'),
	('C00080','1.1.1.205'),
	('C00080','1.1.1.206'),
	('C00080','1.1.1.207'),
	('C00080','1.1.1.208'),
	('C00080','1.1.1.209'),
	('C00080','1.1.1.21'),
	('C00080','1.1.1.210'),
	('C00080','1.1.1.177'),
	('C00080','1.1.1.178'),
	('C00080','1.1.1.179'),
	('C00080','1.1.1.18'),
	('C00080','1.1.1.181'),
	('C00080','1.1.1.183'),
	('C00080','1.1.1.184'),
	('C00080','1.1.1.185'),
	('C00080','1.1.1.186'),
	('C00080','1.1.1.187'),
	('C00080','1.1.1.188'),
	('C00080','1.1.1.189'),
	('C00080','1.1.1.19'),
	('C00080','1.1.1.190'),
	('C00080','1.1.1.191'),
	('C00080','1.1.1.192'),
	('C00080','1.1.1.193'),
	('C00080','1.1.1.194'),
	('C00080','1.1.1.157'),
	('C00080','1.1.1.159'),
	('C00080','1.1.1.16'),
	('C00080','1.1.1.160'),
	('C00080','1.1.1.162'),
	('C00080','1.1.1.163'),
	('C00080','1.1.1.164'),
	('C00080','1.1.1.165'),
	('C00080','1.1.1.166'),
	('C00080','1.1.1.167'),
	('C00080','1.1.1.168'),
	('C00080','1.1.1.169'),
	('C00080','1.1.1.17'),
	('C00080','1.1.1.170'),
	('C00080','1.1.1.172'),
	('C00080','1.1.1.173'),
	('C00080','1.1.1.174'),
	('C00080','1.1.1.175'),
	('C00080','1.1.1.176'),
	('C00080','1.1.1.140'),
	('C00080','1.1.1.269'),
	('C00080','1.1.1.27'),
	('C00080','1.1.1.270'),
	('C00080','1.1.1.271'),
	('C00080','1.1.1.272'),
	('C00080','1.1.1.273'),
	('C00080','1.1.1.274'),
	('C00080','1.1.1.275'),
	('C00080','1.1.1.276'),
	('C00080','1.1.1.277'),
	('C00080','1.1.1.278'),
	('C00080','1.1.1.279'),
	('C00080','1.1.1.28'),
	('C00080','1.1.1.280'),
	('C00080','1.1.1.281'),
	('C00080','1.1.1.247'),
	('C00080','1.1.1.248'),
	('C00080','1.1.1.25'),
	('C00080','1.1.1.250'),
	('C00080','1.1.1.251'),
	('C00080','1.1.1.252'),
	('C00080','1.1.1.254'),
	('C00080','1.1.1.255'),
	('C00080','1.1.1.256'),
	('C00080','1.1.1.257'),
	('C00080','1.1.1.258'),
	('C00080','1.1.1.259'),
	('C00080','1.1.1.26'),
	('C00080','1.1.1.260'),
	('C00080','1.1.1.261'),
	('C00080','1.1.1.262'),
	('C00080','1.1.1.263'),
	('C00080','1.1.1.264'),
	('C00080','1.1.1.228'),
	('C00080','1.1.1.229'),
	('C00080','1.1.1.23'),
	('C00080','1.1.1.230'),
	('C00080','1.1.1.231'),
	('C00080','1.1.1.232'),
	('C00080','1.1.1.233'),
	('C00080','1.1.1.234'),
	('C00080','1.1.1.235'),
	('C00080','1.1.1.236'),
	('C00080','1.1.1.237'),
	('C00080','1.1.1.238'),
	('C00080','1.1.1.239'),
	('C00080','1.1.1.24'),
	('C00080','1.1.1.240'),
	('C00080','1.1.1.241'),
	('C00080','1.1.1.243'),
	('C00080','1.1.1.244'),
	('C00080','1.1.1.245'),
	('C00080','1.1.1.211'),
	('C00080','1.1.1.212'),
	('C00080','1.1.1.213'),
	('C00080','1.1.1.214'),
	('C00080','1.1.1.215'),
	('C00080','1.1.1.216'),
	('C00080','1.1.1.217'),
	('C00080','1.1.1.218'),
	('C00080','1.1.1.219'),
	('C00080','1.1.1.22'),
	('C00080','1.1.1.220'),
	('C00080','1.1.1.221'),
	('C00080','1.1.1.338'),
	('C00080','1.1.1.339'),
	('C00080','1.1.1.34'),
	('C00080','1.1.1.340'),
	('C00080','1.1.1.341'),
	('C00080','1.1.1.342'),
	('C00080','1.1.1.343'),
	('C00080','1.1.1.344'),
	('C00080','1.1.1.345'),
	('C00080','1.1.1.312'),
	('C00080','1.1.1.313'),
	('C00080','1.1.1.314'),
	('C00080','1.1.1.315'),
	('C00080','1.1.1.316'),
	('C00080','1.1.1.317'),
	('C00080','1.1.1.318'),
	('C00080','1.1.1.319'),
	('C00080','1.1.1.32'),
	('C00080','1.1.1.320'),
	('C00080','1.1.1.321'),
	('C00080','1.1.1.322'),
	('C00080','1.1.1.323'),
	('C00080','1.1.1.324'),
	('C00080','1.1.1.325'),
	('C00080','1.1.1.326'),
	('C00080','1.1.1.327'),
	('C00080','1.1.1.328'),
	('C00080','1.1.1.299'),
	('C00080','1.1.1.3'),
	('C00080','1.1.1.30'),
	('C00080','1.1.1.300'),
	('C00080','1.1.1.301'),
	('C00080','1.1.1.302'),
	('C00080','1.1.1.303'),
	('C00080','1.1.1.304'),
	('C00080','1.1.1.305'),
	('C00080','1.1.1.306'),
	('C00080','1.1.1.307'),
	('C00080','1.1.1.308'),
	('C00080','1.1.1.309'),
	('C00080','1.1.1.31'),
	('C00080','1.1.1.310'),
	('C00080','1.1.1.311'),
	('C00080','1.1.1.282'),
	('C00080','1.1.1.283'),
	('C00080','1.1.1.284'),
	('C00080','1.1.1.285'),
	('C00080','1.1.1.286'),
	('C00080','1.1.1.287'),
	('C00080','1.1.1.288'),
	('C00080','1.1.1.289'),
	('C00080','1.1.1.29'),
	('C00080','1.1.1.290'),
	('C00080','1.1.1.291'),
	('C00080','1.1.1.292'),
	('C00080','1.1.1.294'),
	('C00080','1.1.1.295'),
	('C00080','1.1.1.296'),
	('C00080','1.1.1.297'),
	('C00080','1.1.1.298'),
	('C00080','1.1.1.265'),
	('C00080','1.1.1.266'),
	('C00080','1.1.1.267'),
	('C00080','1.1.1.268'),
	('C00080','1.1.1.43'),
	('C00080','1.1.1.44'),
	('C00080','1.1.1.45'),
	('C00080','1.1.1.378'),
	('C00080','1.1.1.379'),
	('C00080','1.1.1.38'),
	('C00080','1.1.1.380'),
	('C00080','1.1.1.381'),
	('C00080','1.1.1.382'),
	('C00080','1.1.1.383'),
	('C00080','1.1.1.384'),
	('C00080','1.1.1.385'),
	('C00080','1.1.1.386'),
	('C00080','1.1.1.387'),
	('C00080','1.1.1.388'),
	('C00080','1.1.1.389'),
	('C00080','1.1.1.39'),
	('C00080','1.1.1.390'),
	('C00080','1.1.1.391'),
	('C00080','1.1.1.361'),
	('C00080','1.1.1.362'),
	('C00080','1.1.1.363'),
	('C00080','1.1.1.364'),
	('C00080','1.1.1.365'),
	('C00080','1.1.1.366'),
	('C00080','1.1.1.367'),
	('C00080','1.1.1.368'),
	('C00080','1.1.1.369'),
	('C00080','1.1.1.37'),
	('C00080','1.1.1.370'),
	('C00080','1.1.1.371'),
	('C00080','1.1.1.372'),
	('C00080','1.1.1.373'),
	('C00080','1.1.1.374'),
	('C00080','1.1.1.375'),
	('C00080','1.1.1.376'),
	('C00080','1.1.1.377'),
	('C00080','1.1.1.346'),
	('C00080','1.1.1.347'),
	('C00080','1.1.1.348'),
	('C00080','1.1.1.349'),
	('C00080','1.1.1.35'),
	('C00080','1.1.1.350'),
	('C00080','1.1.1.351'),
	('C00080','1.1.1.352'),
	('C00080','1.1.1.353'),
	('C00080','1.1.1.354'),
	('C00080','1.1.1.355'),
	('C00080','1.1.1.356'),
	('C00080','1.1.1.357'),
	('C00080','1.1.1.358'),
	('C00080','1.1.1.359'),
	('C00080','1.1.1.36'),
	('C00080','1.1.1.360'),
	('C00080','1.1.1.329'),
	('C00080','1.1.1.33'),
	('C00080','1.1.1.330'),
	('C00080','1.1.1.331'),
	('C00080','1.1.1.332'),
	('C00080','1.1.1.333'),
	('C00080','1.1.1.334'),
	('C00080','1.1.1.335'),
	('C00080','1.1.1.336'),
	('C00080','1.1.1.337'),
	('C00080','1.1.1.82'),
	('C00080','1.1.1.83'),
	('C00080','1.1.1.84'),
	('C00080','1.1.1.85'),
	('C00080','1.1.1.86'),
	('C00080','1.1.1.87'),
	('C00080','1.1.1.88'),
	('C00080','1.1.1.9'),
	('C00080','1.1.1.90'),
	('C00080','1.1.1.91'),
	('C00080','1.1.1.92'),
	('C00080','1.1.1.93'),
	('C00080','1.1.1.94'),
	('C00080','1.1.1.95'),
	('C00080','1.1.1.96'),
	('C00080','1.1.1.62'),
	('C00080','1.1.1.64'),
	('C00080','1.1.1.65'),
	('C00080','1.1.1.66'),
	('C00080','1.1.1.67'),
	('C00080','1.1.1.69'),
	('C00080','1.1.1.7'),
	('C00080','1.1.1.71'),
	('C00080','1.1.1.72'),
	('C00080','1.1.1.73'),
	('C00080','1.1.1.75'),
	('C00080','1.1.1.76'),
	('C00080','1.1.1.77'),
	('C00080','1.1.1.78'),
	('C00080','1.1.1.79'),
	('C00080','1.1.1.8'),
	('C00080','1.1.1.80'),
	('C00080','1.1.1.46'),
	('C00080','1.1.1.47'),
	('C00080','1.1.1.48'),
	('C00080','1.1.1.49'),
	('C00080','1.1.1.50'),
	('C00080','1.1.1.51'),
	('C00080','1.1.1.52'),
	('C00080','1.1.1.53'),
	('C00080','1.1.1.54'),
	('C00080','1.1.1.55'),
	('C00080','1.1.1.56'),
	('C00080','1.1.1.57'),
	('C00080','1.1.1.58'),
	('C00080','1.1.1.59'),
	('C00080','1.1.1.6'),
	('C00080','1.1.1.60'),
	('C00080','1.1.1.61'),
	('C00080','1.1.1.392'),
	('C00080','1.1.1.393'),
	('C00080','1.1.1.394'),
	('C00080','1.1.1.396'),
	('C00080','1.1.1.397'),
	('C00080','1.1.1.399'),
	('C00080','1.1.1.4'),
	('C00080','1.1.1.40'),
	('C00080','1.1.1.400'),
	('C00080','1.1.1.401'),
	('C00080','1.1.1.402'),
	('C00080','1.1.1.403'),
	('C00080','1.1.1.41'),
	('C00080','1.1.1.42'),
	('C00080','1.14.12.1'),
	('C00080','1.14.12.10'),
	('C00080','1.14.12.11'),
	('C00080','1.14.12.12'),
	('C00080','1.14.12.14'),
	('C00080','1.14.12.15'),
	('C00080','1.14.12.16'),
	('C00080','1.14.11.19'),
	('C00080','1.13.12.17'),
	('C00080','1.13.11.29'),
	('C00080','1.13.11.30'),
	('C00080','1.13.11.55'),
	('C00080','1.12.1.2'),
	('C00080','1.12.1.3'),
	('C00080','1.12.1.4'),
	('C00080','1.12.1.5'),
	('C00080','1.12.2.1'),
	('C00080','1.12.7.2'),
	('C00080','1.12.98.2'),
	('C00080','1.11.1.13'),
	('C00080','1.11.1.2'),
	('C00080','1.11.1.21'),
	('C00080','1.11.1.6'),
	('C00080','1.11.1.8'),
	('C00080','1.11.2.2'),
	('C00080','1.10.1.1'),
	('C00080','1.10.2.1'),
	('C00080','1.10.2.2'),
	('C00080','1.10.3.10'),
	('C00080','1.10.3.13'),
	('C00080','1.10.3.14'),
	('C00080','1.11.1.1'),
	('C00080','1.1.9.1'),
	('C00080','1.1.1.97'),
	('C00080','1.1.1.98'),
	('C00080','1.1.1.99'),
	('C00080','1.1.2.2'),
	('C00080','1.1.2.3'),
	('C00080','1.1.2.4'),
	('C00080','1.1.2.5'),
	('C00080','1.1.2.6'),
	('C00080','1.1.2.7'),
	('C00080','1.1.2.8'),
	('C00080','1.1.2.9'),
	('C00080','1.1.1.81'),
	('C00080','1.14.13.153'),
	('C00080','1.14.13.154'),
	('C00080','1.14.13.156'),
	('C00080','1.14.13.131'),
	('C00080','1.14.13.133'),
	('C00080','1.14.13.134'),
	('C00080','1.14.13.135'),
	('C00080','1.14.13.136'),
	('C00080','1.14.13.137'),
	('C00080','1.14.13.138'),
	('C00080','1.14.13.139'),
	('C00080','1.14.13.14'),
	('C00080','1.14.13.140'),
	('C00080','1.14.13.141'),
	('C00080','1.14.13.142'),
	('C00080','1.14.13.119'),
	('C00080','1.14.13.12'),
	('C00080','1.14.13.120'),
	('C00080','1.14.13.121'),
	('C00080','1.14.13.122'),
	('C00080','1.14.13.123'),
	('C00080','1.14.13.124'),
	('C00080','1.14.13.125'),
	('C00080','1.14.13.127'),
	('C00080','1.14.13.128'),
	('C00080','1.14.13.129'),
	('C00080','1.14.13.130'),
	('C00080','1.14.13.108'),
	('C00080','1.14.13.109'),
	('C00080','1.14.13.11'),
	('C00080','1.14.13.110'),
	('C00080','1.14.13.111'),
	('C00080','1.14.13.112'),
	('C00080','1.14.13.113'),
	('C00080','1.14.13.114'),
	('C00080','1.14.13.115'),
	('C00080','1.14.13.116'),
	('C00080','1.14.13.117'),
	('C00080','1.14.13.118'),
	('C00080','1.14.13.1'),
	('C00080','1.14.13.10'),
	('C00080','1.14.13.101'),
	('C00080','1.14.13.102'),
	('C00080','1.14.13.103'),
	('C00080','1.14.13.104'),
	('C00080','1.14.13.105'),
	('C00080','1.14.13.106'),
	('C00080','1.14.13.107'),
	('C00080','1.14.12.17'),
	('C00080','1.14.12.18'),
	('C00080','1.14.12.19'),
	('C00080','1.14.12.22'),
	('C00080','1.14.12.23'),
	('C00080','1.14.12.24'),
	('C00080','1.14.12.3'),
	('C00080','1.14.12.4'),
	('C00080','1.14.12.5'),
	('C00080','1.14.12.7'),
	('C00080','1.14.12.8'),
	('C00080','1.14.12.9'),
	('C00080','1.14.13.211'),
	('C00080','1.14.13.212'),
	('C00080','1.14.13.213'),
	('C00080','1.14.13.214'),
	('C00080','1.14.13.215'),
	('C00080','1.14.13.216'),
	('C00080','1.14.13.217'),
	('C00080','1.14.13.196'),
	('C00080','1.14.13.197'),
	('C00080','1.14.13.198'),
	('C00080','1.14.13.199'),
	('C00080','1.14.13.2'),
	('C00080','1.14.13.20'),
	('C00080','1.14.13.200'),
	('C00080','1.14.13.201'),
	('C00080','1.14.13.202'),
	('C00080','1.14.13.203'),
	('C00080','1.14.13.204'),
	('C00080','1.14.13.206'),
	('C00080','1.14.13.181'),
	('C00080','1.14.13.182'),
	('C00080','1.14.13.183'),
	('C00080','1.14.13.184'),
	('C00080','1.14.13.185'),
	('C00080','1.14.13.186'),
	('C00080','1.14.13.187'),
	('C00080','1.14.13.188'),
	('C00080','1.14.13.189'),
	('C00080','1.14.13.19'),
	('C00080','1.14.13.190'),
	('C00080','1.14.13.194'),
	('C00080','1.14.13.195'),
	('C00080','1.14.13.172'),
	('C00080','1.14.13.173'),
	('C00080','1.14.13.174'),
	('C00080','1.14.13.175'),
	('C00080','1.14.13.176'),
	('C00080','1.14.13.177'),
	('C00080','1.14.13.178'),
	('C00080','1.14.13.179'),
	('C00080','1.14.13.18'),
	('C00080','1.14.13.180'),
	('C00080','1.14.13.157'),
	('C00080','1.14.13.158'),
	('C00080','1.14.13.16'),
	('C00080','1.14.13.160'),
	('C00080','1.14.13.161'),
	('C00080','1.14.13.162'),
	('C00080','1.14.13.163'),
	('C00080','1.14.13.165'),
	('C00080','1.14.13.167'),
	('C00080','1.14.13.168'),
	('C00080','1.14.13.170'),
	('C00080','1.14.13.171'),
	('C00080','1.14.13.143'),
	('C00080','1.14.13.144'),
	('C00080','1.14.13.145'),
	('C00080','1.14.13.146'),
	('C00080','1.14.13.147'),
	('C00080','1.14.13.148'),
	('C00080','1.14.13.149'),
	('C00080','1.14.13.150'),
	('C00080','1.14.13.151'),
	('C00080','1.14.13.85'),
	('C00080','1.14.13.63'),
	('C00080','1.14.13.64'),
	('C00080','1.14.13.66'),
	('C00080','1.14.13.67'),
	('C00080','1.14.13.68'),
	('C00080','1.14.13.69'),
	('C00080','1.14.13.7'),
	('C00080','1.14.13.70'),
	('C00080','1.14.13.71'),
	('C00080','1.14.13.72'),
	('C00080','1.14.13.73'),
	('C00080','1.14.13.51'),
	('C00080','1.14.13.52'),
	('C00080','1.14.13.53'),
	('C00080','1.14.13.54'),
	('C00080','1.14.13.55'),
	('C00080','1.14.13.56'),
	('C00080','1.14.13.57'),
	('C00080','1.14.13.58'),
	('C00080','1.14.13.59'),
	('C00080','1.14.13.6'),
	('C00080','1.14.13.61'),
	('C00080','1.14.13.62'),
	('C00080','1.14.13.39'),
	('C00080','1.14.13.4'),
	('C00080','1.14.13.40'),
	('C00080','1.14.13.41'),
	('C00080','1.14.13.43'),
	('C00080','1.14.13.44'),
	('C00080','1.14.13.46'),
	('C00080','1.14.13.47'),
	('C00080','1.14.13.48'),
	('C00080','1.14.13.49'),
	('C00080','1.14.13.5'),
	('C00080','1.14.13.50'),
	('C00080','1.14.13.27'),
	('C00080','1.14.13.28'),
	('C00080','1.14.13.29'),
	('C00080','1.14.13.30'),
	('C00080','1.14.13.31'),
	('C00080','1.14.13.32'),
	('C00080','1.14.13.33'),
	('C00080','1.14.13.34'),
	('C00080','1.14.13.35'),
	('C00080','1.14.13.36'),
	('C00080','1.14.13.38'),
	('C00080','1.14.13.219'),
	('C00080','1.14.13.22'),
	('C00080','1.14.13.220'),
	('C00080','1.14.13.221'),
	('C00080','1.14.13.222'),
	('C00080','1.14.13.224'),
	('C00080','1.14.13.226'),
	('C00080','1.14.13.227'),
	('C00080','1.14.13.23'),
	('C00080','1.14.13.24'),
	('C00080','1.14.13.25'),
	('C00080','1.14.13.209'),
	('C00080','1.14.13.21'),
	('C00080','1.14.13.210'),
	('C00080','1.14.18.2'),
	('C00080','1.14.18.4'),
	('C00080','1.14.18.5'),
	('C00080','1.14.18.6'),
	('C00080','1.14.18.7'),
	('C00080','1.14.18.8'),
	('C00080','1.14.19.1'),
	('C00080','1.14.19.10'),
	('C00080','1.14.19.11'),
	('C00080','1.14.19.17'),
	('C00080','1.14.19.18'),
	('C00080','1.14.19.19'),
	('C00080','1.14.15.16'),
	('C00080','1.14.15.17'),
	('C00080','1.14.15.18'),
	('C00080','1.14.15.19'),
	('C00080','1.14.15.3'),
	('C00080','1.14.15.4'),
	('C00080','1.14.15.5'),
	('C00080','1.14.15.6'),
	('C00080','1.14.15.7'),
	('C00080','1.14.14.24'),
	('C00080','1.14.14.25'),
	('C00080','1.14.14.26'),
	('C00080','1.14.14.29'),
	('C00080','1.14.14.9'),
	('C00080','1.14.15.15'),
	('C00080','1.14.14.1'),
	('C00080','1.14.14.16'),
	('C00080','1.14.14.17'),
	('C00080','1.14.14.19'),
	('C00080','1.14.14.23'),
	('C00080','1.14.13.87'),
	('C00080','1.14.13.88'),
	('C00080','1.14.13.89'),
	('C00080','1.14.13.9'),
	('C00080','1.14.13.90'),
	('C00080','1.14.13.91'),
	('C00080','1.14.13.92'),
	('C00080','1.14.13.93'),
	('C00080','1.14.13.94'),
	('C00080','1.14.13.96'),
	('C00080','1.14.13.97'),
	('C00080','1.14.13.74'),
	('C00080','1.14.13.75'),
	('C00080','1.14.13.76'),
	('C00080','1.14.13.77'),
	('C00080','1.14.13.78'),
	('C00080','1.14.13.79'),
	('C00080','1.14.13.8'),
	('C00080','1.14.13.80'),
	('C00080','1.14.13.81'),
	('C00080','1.14.13.82'),
	('C00080','1.14.13.83'),
	('C00080','1.14.13.84'),
	('C00080','1.18.6.1'),
	('C00080','1.2.1.10'),
	('C00080','1.2.1.11'),
	('C00080','1.2.1.12'),
	('C00080','1.2.1.13'),
	('C00080','1.2.1.15'),
	('C00080','1.2.1.16'),
	('C00080','1.17.1.5'),
	('C00080','1.17.1.8'),
	('C00080','1.17.2.1'),
	('C00080','1.17.2.2'),
	('C00080','1.17.7.2'),
	('C00080','1.17.7.4'),
	('C00080','1.18.1.1'),
	('C00080','1.18.1.2'),
	('C00080','1.18.1.3'),
	('C00080','1.18.1.4'),
	('C00080','1.15.1.1'),
	('C00080','1.15.1.2'),
	('C00080','1.16.1.1'),
	('C00080','1.16.1.2'),
	('C00080','1.16.1.3'),
	('C00080','1.16.1.4'),
	('C00080','1.16.1.5'),
	('C00080','1.16.1.7'),
	('C00080','1.16.1.8'),
	('C00080','1.16.1.9'),
	('C00080','1.16.3.1'),
	('C00080','1.16.8.1'),
	('C00080','1.17.1.1'),
	('C00080','1.17.1.3'),
	('C00080','1.17.1.4'),
	('C00080','1.14.99.34'),
	('C00080','1.14.99.2'),
	('C00080','1.14.21.1'),
	('C00080','1.14.21.10'),
	('C00080','1.14.21.11'),
	('C00080','1.14.21.2'),
	('C00080','1.14.21.3'),
	('C00080','1.14.21.4'),
	('C00080','1.14.21.5'),
	('C00080','1.14.21.7'),
	('C00080','1.14.21.8'),
	('C00080','1.14.21.9'),
	('C00080','1.14.19.2'),
	('C00080','1.14.19.20'),
	('C00080','1.14.19.21'),
	('C00080','1.14.19.26'),
	('C00080','1.14.19.29'),
	('C00080','1.14.19.3'),
	('C00080','1.14.19.32'),
	('C00080','1.14.19.39'),
	('C00080','1.14.19.41'),
	('C00080','1.14.19.44'),
	('C00080','1.14.19.6'),
	('C00080','1.14.19.8'),
	('C00080','1.14.19.9'),
	('C00080','1.14.18.1'),
	('C00080','1.2.1.75'),
	('C00080','1.2.1.76'),
	('C00080','1.2.1.77'),
	('C00080','1.2.1.78'),
	('C00080','1.2.1.79'),
	('C00080','1.2.1.8'),
	('C00080','1.2.1.80'),
	('C00080','1.2.1.81'),
	('C00080','1.2.1.82'),
	('C00080','1.2.1.53'),
	('C00080','1.2.1.54'),
	('C00080','1.2.1.57'),
	('C00080','1.2.1.58'),
	('C00080','1.2.1.59'),
	('C00080','1.2.1.60'),
	('C00080','1.2.1.61'),
	('C00080','1.2.1.62'),
	('C00080','1.2.1.63'),
	('C00080','1.2.1.64'),
	('C00080','1.2.1.65'),
	('C00080','1.2.1.67'),
	('C00080','1.2.1.68'),
	('C00080','1.2.1.69'),
	('C00080','1.2.1.41'),
	('C00080','1.2.1.42'),
	('C00080','1.2.1.43'),
	('C00080','1.2.1.44'),
	('C00080','1.2.1.46'),
	('C00080','1.2.1.47'),
	('C00080','1.2.1.48'),
	('C00080','1.2.1.49'),
	('C00080','1.2.1.5'),
	('C00080','1.2.1.50'),
	('C00080','1.2.1.51'),
	('C00080','1.2.1.52'),
	('C00080','1.2.1.28'),
	('C00080','1.2.1.29'),
	('C00080','1.2.1.3'),
	('C00080','1.2.1.30'),
	('C00080','1.2.1.31'),
	('C00080','1.2.1.32'),
	('C00080','1.2.1.33'),
	('C00080','1.2.1.36'),
	('C00080','1.2.1.38'),
	('C00080','1.2.1.39'),
	('C00080','1.2.1.4'),
	('C00080','1.2.1.17'),
	('C00080','1.2.1.18'),
	('C00080','1.2.1.19'),
	('C00080','1.2.1.2'),
	('C00080','1.2.1.20'),
	('C00080','1.2.1.21'),
	('C00080','1.2.1.22'),
	('C00080','1.2.1.23'),
	('C00080','1.2.1.24'),
	('C00080','1.2.1.25'),
	('C00080','1.2.1.26'),
	('C00080','1.2.1.27'),
	('C00080','1.18.1.5'),
	('C00080','1.18.1.6'),
	('C00080','1.3.1.15'),
	('C00080','1.3.1.16'),
	('C00080','1.3.1.17'),
	('C00080','1.3.1.18'),
	('C00080','1.3.1.19'),
	('C00080','1.3.1.2'),
	('C00080','1.3.1.20'),
	('C00080','1.3.1.21'),
	('C00080','1.3.1.22'),
	('C00080','1.21.99.3'),
	('C00080','1.21.99.4'),
	('C00080','1.23.1.1'),
	('C00080','1.23.1.2'),
	('C00080','1.23.1.3'),
	('C00080','1.23.1.4'),
	('C00080','1.3.1.1'),
	('C00080','1.3.1.10'),
	('C00080','1.3.1.101'),
	('C00080','1.3.1.102'),
	('C00080','1.3.1.103'),
	('C00080','1.20.1.1'),
	('C00080','1.20.2.1'),
	('C00080','1.20.9.1'),
	('C00080','1.21.1.2'),
	('C00080','1.2.4.1'),
	('C00080','1.2.4.2'),
	('C00080','1.2.7.1'),
	('C00080','1.2.7.10'),
	('C00080','1.2.7.11'),
	('C00080','1.2.7.3'),
	('C00080','1.2.7.5'),
	('C00080','1.2.7.6'),
	('C00080','1.2.7.7'),
	('C00080','1.2.2.4'),
	('C00080','1.2.3.1'),
	('C00080','1.2.3.9'),
	('C00080','1.2.1.83'),
	('C00080','1.2.1.84'),
	('C00080','1.2.1.85'),
	('C00080','1.2.1.86'),
	('C00080','1.2.1.87'),
	('C00080','1.2.1.88'),
	('C00080','1.2.1.89'),
	('C00080','1.2.1.9'),
	('C00080','1.2.1.90'),
	('C00080','1.2.1.91'),
	('C00080','1.2.1.92'),
	('C00080','1.2.1.96'),
	('C00080','1.2.1.98'),
	('C00080','1.2.2.1'),
	('C00080','1.2.2.3'),
	('C00080','1.2.1.7'),
	('C00080','1.2.1.70'),
	('C00080','1.2.1.71'),
	('C00080','1.2.1.72'),
	('C00080','1.2.1.73'),
	('C00080','1.2.1.74'),
	('C00080','1.3.1.66'),
	('C00080','1.3.1.67'),
	('C00080','1.3.1.68'),
	('C00080','1.3.1.69'),
	('C00080','1.3.1.7'),
	('C00080','1.3.1.70'),
	('C00080','1.3.1.71'),
	('C00080','1.3.1.72'),
	('C00080','1.3.1.73'),
	('C00080','1.3.1.74'),
	('C00080','1.3.1.75'),
	('C00080','1.3.1.76'),
	('C00080','1.3.1.77'),
	('C00080','1.3.1.78'),
	('C00080','1.3.1.79'),
	('C00080','1.3.1.8'),
	('C00080','1.3.1.81'),
	('C00080','1.3.1.44'),
	('C00080','1.3.1.45'),
	('C00080','1.3.1.46'),
	('C00080','1.3.1.47'),
	('C00080','1.3.1.48'),
	('C00080','1.3.1.49'),
	('C00080','1.3.1.5'),
	('C00080','1.3.1.51'),
	('C00080','1.3.1.53'),
	('C00080','1.3.1.54'),
	('C00080','1.3.1.56'),
	('C00080','1.3.1.57'),
	('C00080','1.3.1.58'),
	('C00080','1.3.1.6'),
	('C00080','1.3.1.60'),
	('C00080','1.3.1.62'),
	('C00080','1.3.1.64'),
	('C00080','1.3.1.65'),
	('C00080','1.3.1.24'),
	('C00080','1.3.1.25'),
	('C00080','1.3.1.27'),
	('C00080','1.3.1.28'),
	('C00080','1.3.1.29'),
	('C00080','1.3.1.3'),
	('C00080','1.3.1.31'),
	('C00080','1.3.1.32'),
	('C00080','1.3.1.33'),
	('C00080','1.3.1.34'),
	('C00080','1.3.1.37'),
	('C00080','1.3.1.38'),
	('C00080','1.3.1.39'),
	('C00080','1.3.1.40'),
	('C00080','1.3.1.41'),
	('C00080','1.3.1.42'),
	('C00080','1.3.1.43'),
	('C00080','1.3.1.104'),
	('C00080','1.3.1.105'),
	('C00080','1.3.1.106'),
	('C00080','1.3.1.107'),
	('C00080','1.3.1.11'),
	('C00080','1.3.1.111'),
	('C00080','1.3.1.12'),
	('C00080','1.3.1.13'),
	('C00080','1.3.1.14'),
	('C00080','1.5.1.33'),
	('C00080','1.4.99.5'),
	('C00080','1.5.1.1'),
	('C00080','1.5.1.10'),
	('C00080','1.5.1.11'),
	('C00080','1.5.1.16'),
	('C00080','1.5.1.17'),
	('C00080','1.5.1.18'),
	('C00080','1.5.1.19'),
	('C00080','1.5.1.2'),
	('C00080','1.4.4.2'),
	('C00080','1.4.7.1'),
	('C00080','1.4.9.1'),
	('C00080','1.4.3.21'),
	('C00080','1.4.1.3'),
	('C00080','1.4.1.4'),
	('C00080','1.4.1.5'),
	('C00080','1.4.1.7'),
	('C00080','1.4.1.8'),
	('C00080','1.4.1.9'),
	('C00080','1.4.2.1'),
	('C00080','1.4.1.15'),
	('C00080','1.4.1.16'),
	('C00080','1.4.1.17'),
	('C00080','1.4.1.18'),
	('C00080','1.4.1.19'),
	('C00080','1.4.1.2'),
	('C00080','1.4.1.20'),
	('C00080','1.4.1.21'),
	('C00080','1.4.1.23'),
	('C00080','1.4.1.24'),
	('C00080','1.4.1.1'),
	('C00080','1.4.1.10'),
	('C00080','1.4.1.11'),
	('C00080','1.4.1.12'),
	('C00080','1.4.1.13'),
	('C00080','1.4.1.14'),
	('C00080','1.3.99.6'),
	('C00080','1.3.3.8'),
	('C00080','1.3.3.9'),
	('C00080','1.3.7.12'),
	('C00080','1.3.7.15'),
	('C00080','1.3.8.5'),
	('C00080','1.3.1.82'),
	('C00080','1.3.1.83'),
	('C00080','1.3.1.84'),
	('C00080','1.3.1.85'),
	('C00080','1.3.1.86'),
	('C00080','1.3.1.87'),
	('C00080','1.3.1.9'),
	('C00080','1.3.1.92'),
	('C00080','1.3.1.93'),
	('C00080','1.3.1.95'),
	('C00080','1.3.1.96'),
	('C00080','1.3.1.97'),
	('C00080','1.3.1.98'),
	('C00080','1.3.2.3'),
	('C00080','1.7.1.9'),
	('C00080','1.6.5.12'),
	('C00080','1.6.5.2'),
	('C00080','1.6.5.3'),
	('C00080','1.6.5.4'),
	('C00080','1.6.5.5'),
	('C00080','1.6.5.6'),
	('C00080','1.6.5.7'),
	('C00080','1.6.5.8'),
	('C00080','1.6.5.9'),
	('C00080','1.6.6.9'),
	('C00080','1.6.99.1'),
	('C00080','1.6.99.3'),
	('C00080','1.7.1.1'),
	('C00080','1.7.1.10'),
	('C00080','1.6.2.2'),
	('C00080','1.6.2.4'),
	('C00080','1.6.2.5'),
	('C00080','1.6.2.6'),
	('C00080','1.6.3.1'),
	('C00080','1.6.3.2'),
	('C00080','1.6.3.3'),
	('C00080','1.6.3.4'),
	('C00080','1.6.3.5'),
	('C00080','1.6.5.10'),
	('C00080','1.6.5.11'),
	('C00080','1.5.7.1'),
	('C00080','1.5.7.2'),
	('C00080','1.5.1.50'),
	('C00080','1.5.1.6'),
	('C00080','1.5.1.7'),
	('C00080','1.5.1.8'),
	('C00080','1.5.1.9'),
	('C00080','1.5.3.12'),
	('C00080','1.5.1.34'),
	('C00080','1.5.1.36'),
	('C00080','1.5.1.37'),
	('C00080','1.5.1.38'),
	('C00080','1.5.1.39'),
	('C00080','1.5.1.40'),
	('C00080','1.5.1.41'),
	('C00080','1.5.1.42'),
	('C00080','1.5.1.43'),
	('C00080','1.5.1.44'),
	('C00080','1.5.1.45'),
	('C00080','1.5.1.46'),
	('C00080','1.5.1.47'),
	('C00080','1.5.1.48'),
	('C00080','1.5.1.49'),
	('C00080','1.5.1.20'),
	('C00080','1.5.1.21'),
	('C00080','1.5.1.22'),
	('C00080','1.5.1.23'),
	('C00080','1.5.1.24'),
	('C00080','1.5.1.25'),
	('C00080','1.5.1.26'),
	('C00080','1.5.1.28'),
	('C00080','1.5.1.3'),
	('C00080','1.5.1.30'),
	('C00080','1.5.1.31'),
	('C00080','1.5.1.32'),
	('C00080','1.97.1.8'),
	('C00080','2.1.1.1'),
	('C00080','1.8.1.7'),
	('C00080','1.8.1.8'),
	('C00080','1.8.1.9'),
	('C00080','1.8.2.1'),
	('C00080','1.8.2.3'),
	('C00080','1.8.2.4'),
	('C00080','1.8.1.10'),
	('C00080','1.8.1.11'),
	('C00080','1.8.1.12'),
	('C00080','1.8.1.13'),
	('C00080','1.8.1.14'),
	('C00080','1.8.1.15'),
	('C00080','1.8.1.16'),
	('C00080','1.8.1.17'),
	('C00080','1.8.1.18'),
	('C00080','1.8.1.19'),
	('C00080','1.8.1.2'),
	('C00080','1.8.1.3'),
	('C00080','1.8.1.4'),
	('C00080','1.8.1.5'),
	('C00080','1.8.1.6'),
	('C00080','1.7.2.1'),
	('C00080','1.7.2.2'),
	('C00080','1.7.2.4'),
	('C00080','1.7.2.5'),
	('C00080','1.7.2.6'),
	('C00080','1.7.3.6'),
	('C00080','1.7.7.1'),
	('C00080','1.7.99.1'),
	('C00080','1.7.99.4'),
	('C00080','1.7.1.11'),
	('C00080','1.7.1.12'),
	('C00080','1.7.1.13'),
	('C00080','1.7.1.14'),
	('C00080','1.7.1.15'),
	('C00080','1.7.1.2'),
	('C00080','1.7.1.3'),
	('C00080','1.7.1.4'),
	('C00080','1.7.1.5'),
	('C00080','1.7.1.6'),
	('C00080','1.7.1.7'),
	('C00080','2.3.1.170'),
	('C00080','2.3.1.190'),
	('C00080','2.3.1.161'),
	('C00080','2.3.1.165'),
	('C00080','2.3.1.169'),
	('C00080','2.3.1.111'),
	('C00080','2.3.1.12'),
	('C00080','2.1.1.94'),
	('C00080','2.1.2.10'),
	('C00080','2.1.1.56'),
	('C00080','2.1.1.84'),
	('C00080','2.1.1.308'),
	('C00080','2.1.1.44'),
	('C00080','2.1.1.3'),
	('C00080','2.1.1.235'),
	('C00080','2.1.1.258'),
	('C00080','2.1.1.165'),
	('C00080','2.1.1.130'),
	('C00080','2.1.1.140'),
	('C00080','2.1.1.148'),
	('C00080','2.1.1.114'),
	('C00080','2.1.1.115'),
	('C00080','2.1.1.116'),
	('C00080','2.1.1.119'),
	('C00080','2.1.1.120'),
	('C00080','2.1.1.121'),
	('C00080','2.1.1.128'),
	('C00080','1.8.7.1'),
	('C00080','1.8.7.2'),
	('C00080','1.9.3.1'),
	('C00080','2.5.1.79'),
	('C00080','2.5.1.18'),
	('C00080','2.5.1.21'),
	('C00080','2.5.1.23'),
	('C00080','2.5.1.46'),
	('C00080','2.5.1.47'),
	('C00080','2.5.1.49'),
	('C00080','2.5.1.52'),
	('C00080','2.4.99.20'),
	('C00080','2.5.1.126'),
	('C00080','2.5.1.127'),
	('C00080','2.4.2.1'),
	('C00080','2.4.2.2'),
	('C00080','2.4.2.21'),
	('C00080','2.4.2.30'),
	('C00080','2.4.2.55'),
	('C00080','2.3.1.85'),
	('C00080','2.3.1.86'),
	('C00080','2.3.1.94'),
	('C00080','2.3.1.61'),
	('C00080','2.3.1.240'),
	('C00080','2.3.1.236'),
	('C00080','2.3.1.237'),
	('C00080','2.3.1.239'),
	('C00080','3.8.1.1'),
	('C00080','3.5.4.9'),
	('C00080','3.5.99.2'),
	('C00080','3.5.4.27'),
	('C00080','3.5.1.73'),
	('C00080','3.2.2.10'),
	('C00080','3.2.2.6'),
	('C00080','3.2.2.8'),
	('C00080','3.1.1.92'),
	('C00080','2.8.1.3'),
	('C00080','2.8.1.5'),
	('C00080','2.8.1.6'),
	('C00080','2.7.7.87'),
	('C00080','6.6.1.1'),
	('C00080','6.6.1.2'),
	('C00080','6.4.1.3'),
	('C00080','6.4.1.8'),
	('C00080','6.3.4.21'),
	('C00080','6.3.3.2'),
	('C00080','6.3.1.14'),
	('C00080','5.3.3.1'),
	('C00080','4.99.1.1'),
	('C00080','4.99.1.2'),
	('C00080','4.99.1.3'),
	('C00080','4.99.1.4'),
	('C00080','4.99.1.9'),
	('C00080','4.3.99.2'),
	('C00080','4.3.99.4'),
	('C00080','4.3.1.22'),
	('C00080','4.3.1.4'),
	('C00080','4.2.1.164'),
	('C00080','4.1.99.5'),
	('C00080','4.2.1.1'),
	('C00080','4.2.1.104'),
	('C00080','4.1.1.83'),
	('C00080','4.1.1.85'),
	('C00080','4.1.1.50'),
	('C00080','3.8.1.6'),
	('C00080','3.8.1.7'),
	('C00081','2.7.1.11'),
	('C00081','3.6.1.8'),
	('C00081','3.6.1.5'),
	('C00081','3.6.1.14'),
	('C00081','3.5.4.17'),
	('C00081','3.5.4.18'),
	('C00081','2.7.4.6'),
	('C00081','2.7.1.48'),
	('C00081','2.7.1.40'),
	('C00081','2.7.1.1'),
	('C00081','6.2.1.4'),
	('C00081','4.1.1.32'),
	('C00082','1.11.1.8'),
	('C00082','1.10.3.1'),
	('C00082','1.14.13.41'),
	('C00082','1.14.18.1'),
	('C00082','1.14.16.1'),
	('C00082','1.14.16.2'),
	('C00082','1.21.1.1'),
	('C00082','1.3.1.78'),
	('C00082','1.3.1.79'),
	('C00082','1.3.1.43'),
	('C00082','1.4.3.2'),
	('C00082','1.4.1.20'),
	('C00082','2.1.1.304'),
	('C00082','2.6.1.9'),
	('C00082','2.6.1.5'),
	('C00082','2.6.1.57'),
	('C00082','2.6.1.58'),
	('C00082','2.6.1.1'),
	('C00082','2.6.1.103'),
	('C00082','2.5.1.122'),
	('C00082','4.1.1.25'),
	('C00082','4.1.1.28'),
	('C00082','6.3.2.24'),
	('C00082','6.3.2.25'),
	('C00082','5.4.3.6'),
	('C00082','6.1.1.1'),
	('C00082','4.3.1.23'),
	('C00082','4.3.1.25'),
	('C00082','4.1.99.19'),
	('C00082','4.1.99.2'),
	('C00083','1.2.1.75'),
	('C00083','2.3.1.211'),
	('C00083','2.3.1.212'),
	('C00083','2.3.1.214'),
	('C00083','2.3.1.216'),
	('C00083','2.3.1.218'),
	('C00083','2.3.1.220'),
	('C00083','2.3.1.221'),
	('C00083','2.3.1.170'),
	('C00083','2.3.1.171'),
	('C00083','2.3.1.172'),
	('C00083','2.3.1.177'),
	('C00083','2.3.1.194'),
	('C00083','2.3.1.151'),
	('C00083','2.3.1.156'),
	('C00083','2.3.1.159'),
	('C00083','2.3.1.161'),
	('C00083','2.3.1.165'),
	('C00083','2.3.1.112'),
	('C00083','2.3.1.113'),
	('C00083','2.3.1.114'),
	('C00083','2.3.1.115'),
	('C00083','2.3.1.116'),
	('C00083','2.3.1.146'),
	('C00083','2.1.3.1'),
	('C00083','2.3.1.85'),
	('C00083','2.3.1.86'),
	('C00083','2.3.1.95'),
	('C00083','2.3.1.74'),
	('C00083','2.3.1.240'),
	('C00083','2.3.1.246'),
	('C00083','2.3.1.39'),
	('C00083','2.3.1.226'),
	('C00083','2.3.1.230'),
	('C00083','2.3.1.233'),
	('C00083','2.3.1.235'),
	('C00083','2.3.1.236'),
	('C00083','2.3.1.237'),
	('C00083','2.3.1.239'),
	('C00083','2.3.1.199'),
	('C00083','2.3.1.206'),
	('C00083','2.3.1.208'),
	('C00083','2.8.3.3'),
	('C00083','6.4.1.2'),
	('C00083','4.1.1.9'),
	('C00084','1.1.1.1'),
	('C00084','1.1.1.2'),
	('C00084','1.1.1.71'),
	('C00084','1.13.12.16'),
	('C00084','1.1.99.36'),
	('C00084','1.1.5.5'),
	('C00084','1.1.2.7'),
	('C00084','1.1.2.8'),
	('C00084','1.2.1.10'),
	('C00084','1.14.99.39'),
	('C00084','1.2.1.5'),
	('C00084','1.2.1.3'),
	('C00084','1.2.1.4'),
	('C00084','1.2.99.6'),
	('C00084','1.2.5.2'),
	('C00084','1.7.3.1'),
	('C00084','2.3.1.190'),
	('C00084','2.2.1.4'),
	('C00084','2.2.1.8'),
	('C00084','4.1.1.1'),
	('C00084','3.7.1.12'),
	('C00084','3.11.1.1'),
	('C00084','4.3.99.4'),
	('C00084','4.3.1.7'),
	('C00084','4.2.3.2'),
	('C00084','4.2.1.155'),
	('C00084','4.2.1.112'),
	('C00084','4.1.3.39'),
	('C00084','4.1.2.33'),
	('C00084','4.1.2.36'),
	('C00084','4.1.2.4'),
	('C00084','4.1.2.42'),
	('C00084','4.1.2.48'),
	('C00084','4.1.2.49'),
	('C00084','4.1.2.5'),
	('C00084','4.1.2.50'),
	('C00085','1.1.1.140'),
	('C00085','1.1.1.17'),
	('C00085','2.2.1.1'),
	('C00085','2.2.1.2'),
	('C00085','2.7.1.11'),
	('C00085','2.6.1.16'),
	('C00085','2.4.1.246'),
	('C00085','2.4.1.14'),
	('C00085','3.5.99.6'),
	('C00085','3.1.3.46'),
	('C00085','3.1.3.11'),
	('C00085','2.7.1.90'),
	('C00085','2.7.1.61'),
	('C00085','2.7.1.4'),
	('C00085','2.7.1.146'),
	('C00085','2.7.1.1'),
	('C00085','5.3.1.27'),
	('C00085','5.3.1.8'),
	('C00085','5.3.1.9'),
	('C00085','4.1.2.22'),
	('C00086','3.5.3.1'),
	('C00086','3.5.3.10'),
	('C00086','3.5.3.11'),
	('C00086','3.5.3.14'),
	('C00086','3.5.3.16'),
	('C00086','3.5.3.17'),
	('C00086','3.5.3.2'),
	('C00086','3.5.3.20'),
	('C00086','3.5.3.22'),
	('C00086','3.5.3.24'),
	('C00086','3.5.3.3'),
	('C00086','3.5.3.4'),
	('C00086','3.5.3.7'),
	('C00086','3.5.1.95'),
	('C00086','3.5.2.1'),
	('C00086','3.5.1.84'),
	('C00086','3.5.1.5'),
	('C00086','6.3.4.6'),
	('C00086','4.3.2.3'),
	('C00086','4.2.1.69'),
	('C00087','1.13.11.55'),
	('C00087','1.13.11.18'),
	('C00087','1.14.14.1'),
	('C00087','1.8.2.3'),
	('C00087','1.8.1.18'),
	('C00087','3.2.1.147'),
	('C00088','1.13.12.16'),
	('C00088','1.13.11.64'),
	('C00088','1.14.12.23'),
	('C00088','1.14.12.24'),
	('C00088','1.14.13.167'),
	('C00088','1.14.13.31'),
	('C00088','1.14.13.210'),
	('C00088','1.7.1.1'),
	('C00088','1.7.2.1'),
	('C00088','1.7.2.2'),
	('C00088','1.7.2.6'),
	('C00088','1.7.3.1'),
	('C00088','1.7.3.5'),
	('C00088','1.7.3.6'),
	('C00088','1.7.5.1'),
	('C00088','1.7.6.1'),
	('C00088','1.7.7.1'),
	('C00088','1.7.7.2'),
	('C00088','1.7.99.4'),
	('C00088','1.7.1.15'),
	('C00088','1.7.1.2'),
	('C00088','1.7.1.3'),
	('C00088','1.7.1.4'),
	('C00088','1.9.6.1'),
	('C00088','3.5.99.9'),
	('C00089','1.1.99.13'),
	('C00089','2.4.1.99'),
	('C00089','2.4.1.5'),
	('C00089','2.4.1.7'),
	('C00089','2.4.1.82'),
	('C00089','2.4.1.9'),
	('C00089','2.4.1.4'),
	('C00089','2.4.1.166'),
	('C00089','2.4.1.167'),
	('C00089','2.4.1.10'),
	('C00089','2.4.1.125'),
	('C00089','2.4.1.13'),
	('C00089','3.2.1.20'),
	('C00089','3.2.1.22'),
	('C00089','3.2.1.26'),
	('C00089','3.2.1.48'),
	('C00089','3.2.1.10'),
	('C00089','3.1.3.24'),
	('C00089','2.7.1.211'),
	('C00089','5.4.99.11'),
	('C00090','1.14.18.1'),
	('C00090','1.14.13.7'),
	('C00090','1.14.13.31'),
	('C00090','1.14.13.1'),
	('C00090','1.14.12.23'),
	('C00090','1.14.12.1'),
	('C00090','1.14.12.13'),
	('C00090','1.13.11.1'),
	('C00090','1.13.11.2'),
	('C00090','1.10.3.1'),
	('C00090','1.1.3.14'),
	('C00090','2.1.1.6'),
	('C00090','1.3.1.25'),
	('C00090','1.3.1.19'),
	('C00090','1.3.1.20'),
	('C00090','4.1.1.63'),
	('C00090','4.1.1.46'),
	('C00090','3.7.1.8'),
	('C00091','1.2.1.52'),
	('C00091','2.3.1.61'),
	('C00091','2.3.1.37'),
	('C00091','2.3.1.46'),
	('C00091','2.3.1.174'),
	('C00091','2.3.1.16'),
	('C00091','2.3.1.117'),
	('C00091','2.3.1.109'),
	('C00091','1.8.1.4'),
	('C00091','1.2.4.2'),
	('C00091','1.2.7.11'),
	('C00091','1.2.7.3'),
	('C00091','1.2.1.76'),
	('C00091','3.1.2.3'),
	('C00091','2.8.3.18'),
	('C00091','2.8.3.2'),
	('C00091','2.8.3.20'),
	('C00091','2.8.3.22'),
	('C00091','2.8.3.5'),
	('C00091','2.8.3.6'),
	('C00091','2.8.3.13'),
	('C00091','2.8.3.15'),
	('C00091','6.2.1.4'),
	('C00091','6.2.1.5'),
	('C00091','5.4.99.2'),
	('C00092','1.1.98.2'),
	('C00092','1.1.1.49'),
	('C00092','1.1.1.388'),
	('C00092','1.1.1.361'),
	('C00092','1.1.1.363'),
	('C00092','1.1.1.200'),
	('C00092','2.4.1.36'),
	('C00092','2.4.1.216'),
	('C00092','2.4.1.15'),
	('C00092','3.2.1.122'),
	('C00092','3.1.3.9'),
	('C00092','3.1.3.58'),
	('C00092','2.7.1.61'),
	('C00092','2.7.1.63'),
	('C00092','2.7.1.2'),
	('C00092','2.7.1.142'),
	('C00092','2.7.1.147'),
	('C00092','2.7.1.1'),
	('C00092','5.3.1.9'),
	('C00092','5.4.2.2'),
	('C00092','5.4.2.5'),
	('C00092','5.4.2.6'),
	('C00092','5.5.1.4'),
	('C00092','4.2.3.124'),
	('C00092','3.2.1.86'),
	('C00092','3.2.1.93'),
	('C00092','3.2.1.26'),
	('C00093','1.1.5.3'),
	('C00093','1.1.3.21'),
	('C00093','1.1.1.94'),
	('C00093','1.1.1.8'),
	('C00093','1.1.1.177'),
	('C00093','2.4.1.213'),
	('C00093','2.4.1.137'),
	('C00093','2.3.1.198'),
	('C00093','2.3.1.15'),
	('C00093','3.1.4.2'),
	('C00093','3.1.4.3'),
	('C00093','3.1.4.44'),
	('C00093','3.1.4.46'),
	('C00093','3.1.3.21'),
	('C00093','2.7.8.5'),
	('C00093','2.7.7.39'),
	('C00093','2.7.1.30'),
	('C00093','2.7.1.142'),
	('C00093','2.4.1.96'),
	('C00093','3.6.1.16'),
	('C00094','1.14.14.5'),
	('C00094','1.14.13.111'),
	('C00094','1.14.12.8'),
	('C00094','1.14.11.17'),
	('C00094','1.13.11.18'),
	('C00094','1.13.11.2'),
	('C00094','2.3.3.15'),
	('C00094','1.8.4.8'),
	('C00094','1.8.4.9'),
	('C00094','1.8.7.1'),
	('C00094','1.8.98.3'),
	('C00094','1.8.99.2'),
	('C00094','1.8.99.5'),
	('C00094','1.8.2.1'),
	('C00094','1.8.3.1'),
	('C00094','1.8.4.10'),
	('C00094','1.8.1.2'),
	('C00094','3.13.1.1'),
	('C00094','3.13.1.3'),
	('C00094','3.13.1.4'),
	('C00094','2.8.1.1'),
	('C00094','2.8.1.2'),
	('C00094','2.8.1.3'),
	('C00094','2.8.1.5'),
	('C00094','2.5.1.76'),
	('C00094','2.5.1.47'),
	('C00094','2.5.1.49'),
	('C00094','4.4.1.10'),
	('C00094','4.4.1.19'),
	('C00095','1.1.99.11'),
	('C00095','1.1.99.28'),
	('C00095','1.1.2.2'),
	('C00095','1.1.1.67'),
	('C00095','1.1.1.15'),
	('C00095','1.1.1.124'),
	('C00095','1.1.1.138'),
	('C00095','1.1.1.14'),
	('C00095','1.1.1.11'),
	('C00095','2.4.1.7'),
	('C00095','2.4.1.4'),
	('C00095','2.4.1.125'),
	('C00095','2.4.1.13'),
	('C00095','3.1.3.68'),
	('C00095','2.7.1.61'),
	('C00095','2.7.1.3'),
	('C00095','2.7.1.4'),
	('C00095','2.7.1.202'),
	('C00095','2.7.1.1'),
	('C00095','2.4.1.5'),
	('C00095','5.1.3.30'),
	('C00095','5.1.3.31'),
	('C00095','5.3.1.5'),
	('C00095','5.3.1.7'),
	('C00095','3.2.1.80'),
	('C00095','3.2.1.20'),
	('C00095','3.2.1.26'),
	('C00095','3.2.1.48'),
	('C00095','3.2.1.10'),
	('C00096','1.1.1.132'),
	('C00096','2.4.1.54'),
	('C00096','2.4.1.83'),
	('C00096','2.4.1.32'),
	('C00096','2.4.1.251'),
	('C00096','2.4.1.252'),
	('C00096','2.4.1.269'),
	('C00096','2.4.1.270'),
	('C00096','2.4.1.217'),
	('C00096','2.4.1.246'),
	('C00096','2.4.1.132'),
	('C00096','2.4.1.142'),
	('C00096','2.4.1.110'),
	('C00096','2.7.8.9'),
	('C00096','2.7.7.13'),
	('C00096','2.7.7.22'),
	('C00096','2.4.1.48'),
	('C00096','5.1.3.18'),
	('C00096','4.2.1.47'),
	('C00096','3.6.1.21'),
	('C00097','1.14.99.51'),
	('C00097','1.14.99.52'),
	('C00097','1.13.11.20'),
	('C00097','2.3.2.4'),
	('C00097','1.8.1.9'),
	('C00097','1.8.3.5'),
	('C00097','1.8.3.6'),
	('C00097','1.8.4.3'),
	('C00097','1.8.4.4'),
	('C00097','1.8.1.10'),
	('C00097','1.8.1.6'),
	('C00097','2.8.1.4'),
	('C00097','2.8.1.7'),
	('C00097','2.6.1.3'),
	('C00097','2.6.1.1'),
	('C00097','2.5.1.65'),
	('C00097','2.5.1.47'),
	('C00097','2.5.1.48'),
	('C00097','2.5.1.49'),
	('C00097','6.3.2.5'),
	('C00097','6.3.2.26'),
	('C00097','6.3.2.2'),
	('C00097','6.3.1.13'),
	('C00097','6.1.1.16'),
	('C00097','4.4.1.28'),
	('C00097','4.4.1.8'),
	('C00097','4.4.1.9'),
	('C00097','5.1.1.10'),
	('C00097','4.4.1.1'),
	('C00097','4.4.1.10'),
	('C00097','4.2.1.22'),
	('C00097','3.4.11.1'),
	('C00097','3.4.11.2'),
	('C00097','3.4.11.23'),
	('C00099','1.2.1.3'),
	('C00099','1.2.1.19'),
	('C00099','1.5.1.26'),
	('C00099','1.2.1.5'),
	('C00099','2.6.1.55'),
	('C00099','2.6.1.18'),
	('C00099','2.6.1.19'),
	('C00099','6.3.2.44'),
	('C00099','6.3.2.23'),
	('C00099','6.3.2.36'),
	('C00099','6.3.2.1'),
	('C00099','6.3.2.11'),
	('C00099','4.1.1.11'),
	('C00099','4.1.1.15'),
	('C00099','3.5.3.17'),
	('C00099','3.5.1.6'),
	('C00099','3.5.1.21'),
	('C00099','3.5.1.22'),
	('C00099','3.5.1.100'),
	('C00099','3.4.13.18'),
	('C00099','3.4.13.20'),
	('C00099','3.4.13.4'),
	('C00099','3.4.13.5'),
	('C00100','1.2.1.27'),
	('C00100','1.2.1.87'),
	('C00100','1.2.7.1'),
	('C00100','1.3.1.84'),
	('C00100','1.3.1.95'),
	('C00100','1.3.8.7'),
	('C00100','2.8.3.1'),
	('C00100','3.13.1.4'),
	('C00100','2.1.3.1'),
	('C00100','2.3.1.16'),
	('C00100','2.3.1.168'),
	('C00100','2.3.1.176'),
	('C00100','2.3.1.222'),
	('C00100','2.3.1.54'),
	('C00100','2.3.1.8'),
	('C00100','2.3.1.9'),
	('C00100','2.3.1.94'),
	('C00100','2.3.3.11'),
	('C00100','2.3.3.5'),
	('C00100','6.2.1.1'),
	('C00100','6.2.1.13'),
	('C00100','6.2.1.17'),
	('C00100','6.4.1.3'),
	('C00100','4.1.1.41'),
	('C00100','4.1.1.9'),
	('C00100','4.1.3.24'),
	('C00101','1.8.1.4'),
	('C00101','2.1.1.13'),
	('C00101','2.1.1.148'),
	('C00101','2.1.1.19'),
	('C00101','2.1.1.258'),
	('C00101','2.1.1.269'),
	('C00101','2.1.1.74'),
	('C00101','2.1.2.1'),
	('C00101','2.1.2.10'),
	('C00101','2.1.2.11'),
	('C00101','2.1.2.13'),
	('C00101','2.1.2.2'),
	('C00101','2.1.2.3'),
	('C00101','2.1.2.4'),
	('C00101','2.1.2.5'),
	('C00101','1.4.4.2'),
	('C00101','1.5.1.3'),
	('C00101','1.5.1.6'),
	('C00101','2.1.2.7'),
	('C00101','2.1.2.8'),
	('C00101','2.1.2.9'),
	('C00101','2.3.1.169'),
	('C00101','6.3.2.17'),
	('C00101','6.3.4.3'),
	('C00101','3.4.19.9'),
	('C00101','3.5.1.10'),
	('C00103','2.4.1.30'),
	('C00103','2.4.1.31'),
	('C00103','2.4.1.321'),
	('C00103','2.4.1.329'),
	('C00103','2.4.1.333'),
	('C00103','2.4.1.49'),
	('C00103','2.4.1.7'),
	('C00103','2.4.1.97'),
	('C00103','3.1.3.10'),
	('C00103','3.1.4.51'),
	('C00103','2.7.1.10'),
	('C00103','2.7.1.106'),
	('C00103','2.7.1.41'),
	('C00103','2.7.1.42'),
	('C00103','2.7.1.62'),
	('C00103','2.7.7.12'),
	('C00103','2.7.7.24'),
	('C00103','2.7.7.27'),
	('C00103','2.7.7.33'),
	('C00103','2.7.7.34'),
	('C00103','2.7.7.36'),
	('C00103','2.7.7.64'),
	('C00103','2.4.1.1'),
	('C00103','2.4.1.139'),
	('C00103','2.4.1.20'),
	('C00103','2.4.1.231'),
	('C00103','5.4.2.2'),
	('C00103','5.4.2.5'),
	('C00103','3.6.1.9'),
	('C00103','3.6.1.21'),
	('C00103','3.6.1.45'),
	('C00103','3.6.1.8'),
	('C00103','2.7.7.78'),
	('C00103','2.7.7.9'),
	('C00104','2.7.1.1'),
	('C00104','2.7.1.11'),
	('C00104','2.7.1.40'),
	('C00104','2.7.1.48'),
	('C00104','2.7.4.6'),
	('C00104','6.2.1.4'),
	('C00104','4.1.1.32'),
	('C00104','3.5.4.17'),
	('C00104','3.5.4.7'),
	('C00104','3.6.1.5'),
	('C00104','3.6.1.6'),
	('C00104','3.6.1.64'),
	('C00105','1.14.11.49'),
	('C00105','2.7.8.6'),
	('C00105','3.1.3.5'),
	('C00105','2.7.1.48'),
	('C00105','2.7.4.14'),
	('C00105','2.7.4.22'),
	('C00105','2.7.4.4'),
	('C00105','2.4.2.57'),
	('C00105','2.4.2.9'),
	('C00105','3.6.1.9'),
	('C00105','4.1.1.23'),
	('C00105','3.6.1.17'),
	('C00105','3.6.1.45'),
	('C00105','3.6.1.5'),
	('C00105','3.6.1.54'),
	('C00105','3.6.1.6'),
	('C00105','3.6.1.8'),
	('C00105','2.7.8.13'),
	('C00105','2.7.8.15'),
	('C00105','2.7.8.17'),
	('C00105','2.7.8.18'),
	('C00105','2.7.8.19'),
	('C00105','2.7.8.31'),
	('C00105','2.7.8.32'),
	('C00105','2.7.8.33'),
	('C00105','2.7.8.35'),
	('C00105','2.7.8.36'),
	('C00105','2.7.8.40'),
	('C00106','2.4.2.3'),
	('C00106','2.4.2.9'),
	('C00106','1.17.99.4'),
	('C00106','2.4.2.4'),
	('C00106','2.4.2.57'),
	('C00106','1.14.99.46'),
	('C00106','1.14.11.10'),
	('C00106','3.5.4.1'),
	('C00106','3.2.2.3'),
	('C00106','4.2.1.70'),
	('C00106','4.1.1.66'),
	('C00106','1.3.1.1'),
	('C00106','1.3.1.2'),
	('C00106','1.3.3.7'),
	('C00106','2.4.2.1'),
	('C00106','2.5.1.53'),
	('C00106','2.4.2.2'),
	('C00108','2.4.2.18'),
	('C00108','1.14.12.1'),
	('C00108','1.13.11.23'),
	('C00108','1.14.16.3'),
	('C00108','1.14.14.8'),
	('C00108','1.14.13.35'),
	('C00108','2.1.1.277'),
	('C00108','2.1.1.111'),
	('C00108','3.5.1.9'),
	('C00108','4.1.3.27'),
	('C00108','4.1.1.24'),
	('C00108','3.7.1.3'),
	('C00108','3.7.1.13'),
	('C00108','6.3.2.40'),
	('C00108','6.2.1.32'),
	('C00108','2.3.1.144'),
	('C00108','2.3.1.113'),
	('C00109','4.4.1.1'),
	('C00109','2.6.1.44'),
	('C00109','4.4.1.2'),
	('C00109','3.5.99.10'),
	('C00109','4.1.1.3'),
	('C00109','1.2.7.1'),
	('C00109','3.5.99.7'),
	('C00109','2.3.3.6'),
	('C00109','2.3.1.54'),
	('C00109','4.3.1.19'),
	('C00109','1.2.4.4'),
	('C00109','2.2.1.6'),
	('C00109','1.1.1.27'),
	('C00109','2.5.1.48'),
	('C00109','1.1.1.85'),
	('C00109','2.6.1.42'),
	('C00109','4.4.1.11'),
	('C00110','2.7.4.20'),
	('C00110','2.4.2.32'),
	('C00110','2.4.2.33'),
	('C00110','2.4.1.109'),
	('C00110','2.4.1.117'),
	('C00110','2.4.1.83'),
	('C00110','3.6.1.43'),
	('C00110','3.6.1.44'),
	('C00110','2.7.8.15'),
	('C00110','3.1.3.51'),
	('C00110','3.1.4.48'),
	('C00110','3.1.4.49'),
	('C00110','2.7.1.108'),
	('C00111','2.7.1.29'),
	('C00111','2.5.1.72'),
	('C00111','2.3.1.245'),
	('C00111','2.3.1.42'),
	('C00111','1.1.1.261'),
	('C00111','1.1.1.8'),
	('C00111','1.1.1.94'),
	('C00111','1.1.3.21'),
	('C00111','1.1.5.3'),
	('C00111','4.1.2.13'),
	('C00111','4.1.2.17'),
	('C00111','4.1.2.19'),
	('C00111','4.1.2.2'),
	('C00111','4.1.2.29'),
	('C00111','4.1.2.40'),
	('C00111','4.1.2.56'),
	('C00111','4.1.2.57'),
	('C00111','4.2.3.3'),
	('C00111','5.3.1.1'),
	('C00111','3.1.3.1'),
	('C00111','3.1.3.2'),
	('C00111','2.7.1.121'),
	('C00112','2.7.1.161'),
	('C00112','2.7.1.174'),
	('C00112','2.7.1.182'),
	('C00112','2.7.1.40'),
	('C00112','2.7.4.14'),
	('C00112','2.7.4.25'),
	('C00112','2.7.4.6'),
	('C00112','2.4.1.60'),
	('C00112','1.17.4.1'),
	('C00112','3.6.1.5'),
	('C00112','2.7.7.8'),
	('C00112','2.7.1.108'),
	('C00112','2.7.1.11'),
	('C00113','1.2.5.2'),
	('C00113','1.3.3.11'),
	('C00113','1.1.5.8'),
	('C00114','2.7.1.32'),
	('C00114','2.3.1.6'),
	('C00114','2.3.1.91'),
	('C00114','1.14.15.7'),
	('C00114','1.1.1.1'),
	('C00114','1.1.3.17'),
	('C00114','1.1.99.1'),
	('C00114','4.3.99.4'),
	('C00114','2.7.8.24'),
	('C00114','2.8.2.6'),
	('C00114','3.1.1.49'),
	('C00114','3.1.1.7'),
	('C00114','3.1.1.8'),
	('C00114','3.1.3.75'),
	('C00114','3.1.4.2'),
	('C00114','3.1.4.4'),
	('C00114','3.1.4.41'),
	('C00114','3.1.4.46'),
	('C00114','3.1.6.6'),
	('C00116','2.7.1.30'),
	('C00116','2.7.1.79'),
	('C00116','2.4.1.332'),
	('C00116','1.1.1.156'),
	('C00116','1.1.1.2'),
	('C00116','1.1.1.21'),
	('C00116','1.1.1.372'),
	('C00116','1.1.1.6'),
	('C00116','1.1.1.72'),
	('C00116','1.1.99.22'),
	('C00116','4.2.1.30'),
	('C00116','3.2.1.22'),
	('C00116','3.1.1.23'),
	('C00116','3.1.1.34'),
	('C00116','3.1.1.79'),
	('C00116','3.1.3.19'),
	('C00116','3.1.3.21'),
	('C00116','3.1.4.38'),
	('C00116','3.1.4.43'),
	('C00116','2.7.1.142'),
	('C00117','2.7.1.15'),
	('C00117','3.1.4.57'),
	('C00117','2.7.6.1'),
	('C00117','2.7.7.35'),
	('C00117','2.2.1.1'),
	('C00117','2.2.1.4'),
	('C00117','5.4.2.2'),
	('C00117','5.4.2.7'),
	('C00117','6.3.4.7'),
	('C00117','4.2.1.70'),
	('C00117','4.3.3.6'),
	('C00117','5.3.1.6'),
	('C00117','3.2.2.10'),
	('C00117','3.2.2.12'),
	('C00117','3.2.2.14'),
	('C00117','3.2.2.4'),
	('C00117','3.6.1.13'),
	('C00117','3.6.1.21'),
	('C00117','3.6.1.53'),
	('C00117','2.7.1.18'),
	('C00118','4.1.2.13'),
	('C00118','4.1.2.14'),
	('C00118','4.1.2.21'),
	('C00118','4.1.2.4'),
	('C00118','4.1.2.40'),
	('C00118','4.1.2.55'),
	('C00118','4.1.2.8'),
	('C00118','4.1.2.9'),
	('C00118','4.2.1.20'),
	('C00118','4.2.3.153'),
	('C00118','4.3.3.6'),
	('C00118','5.3.1.1'),
	('C00118','2.7.1.28'),
	('C00118','2.5.1.66'),
	('C00118','2.2.1.1'),
	('C00118','2.2.1.11'),
	('C00118','2.2.1.2'),
	('C00118','2.2.1.3'),
	('C00118','2.2.1.7'),
	('C00118','1.2.1.12'),
	('C00118','1.2.1.13'),
	('C00118','1.2.1.59'),
	('C00118','1.2.1.9'),
	('C00118','1.2.1.90'),
	('C00118','1.2.7.6'),
	('C00118','1.1.1.177'),
	('C00119','6.3.4.21'),
	('C00119','2.4.2.14'),
	('C00119','2.7.4.23'),
	('C00119','2.7.6.1'),
	('C00119','2.4.2.17'),
	('C00119','2.4.2.18'),
	('C00119','2.4.2.19'),
	('C00119','2.4.2.20'),
	('C00119','2.4.2.22'),
	('C00119','2.4.2.45'),
	('C00119','2.4.2.49'),
	('C00119','2.4.2.54'),
	('C00119','2.4.2.7'),
	('C00119','2.4.2.8'),
	('C00119','2.4.2.9'),
	('C00119','2.4.2.10'),
	('C00119','2.4.2.12'),
	('C00119','6.3.4.8'),
	('C00120','6.3.4.11'),
	('C00120','2.8.1.6'),
	('C00120','6.3.4.9'),
	('C00120','6.3.4.15'),
	('C00120','6.2.1.11'),
	('C00120','6.3.4.10'),
	('C00120','3.5.1.12'),
	('C00121','3.2.2.1'),
	('C00121','3.2.2.13'),
	('C00121','3.2.2.2'),
	('C00121','3.2.2.25'),
	('C00121','3.2.2.3'),
	('C00121','3.2.2.7'),
	('C00121','3.2.2.8'),
	('C00121','5.3.1.20'),
	('C00121','2.7.1.15'),
	('C00121','1.1.1.115'),
	('C00122','6.3.2.46'),
	('C00122','1.3.98.1'),
	('C00122','1.3.5.4'),
	('C00122','1.3.5.1'),
	('C00122','1.3.1.6'),
	('C00122','1.3.4.1'),
	('C00122','5.2.1.1'),
	('C00122','4.3.2.2'),
	('C00122','4.3.2.1'),
	('C00122','4.3.1.1'),
	('C00122','4.2.99.12'),
	('C00122','4.2.1.2'),
	('C00122','4.1.99.11'),
	('C00122','3.7.1.5'),
	('C00122','3.7.1.20'),
	('C00122','3.7.1.2'),
	('C00122','3.7.1.14'),
	('C00123','6.1.1.4'),
	('C00123','5.4.3.7'),
	('C00123','2.6.1.42'),
	('C00123','2.6.1.6'),
	('C00123','2.3.1.66'),
	('C00123','6.3.2.47'),
	('C00123','3.5.1.64'),
	('C00123','1.4.1.9'),
	('C00123','2.6.1.67'),
	('C00124','1.1.1.120'),
	('C00124','1.1.1.121'),
	('C00124','1.1.1.21'),
	('C00124','1.1.1.359'),
	('C00124','1.1.1.360'),
	('C00124','3.1.3.94'),
	('C00124','1.1.1.48'),
	('C00124','1.1.3.9'),
	('C00124','3.2.1.62'),
	('C00124','3.2.1.47'),
	('C00124','3.2.1.46'),
	('C00124','3.2.1.23'),
	('C00124','3.2.1.22'),
	('C00124','3.2.1.108'),
	('C00124','2.7.1.204'),
	('C00124','5.1.3.3'),
	('C00125','1.20.2.1'),
	('C00125','1.20.9.1'),
	('C00125','1.3.2.3'),
	('C00125','1.4.2.1'),
	('C00125','1.1.2.2'),
	('C00125','1.1.2.3'),
	('C00125','1.1.2.4'),
	('C00125','1.1.2.6'),
	('C00125','1.1.2.8'),
	('C00125','1.1.2.9'),
	('C00125','1.10.2.2'),
	('C00125','1.11.1.5'),
	('C00125','1.7.2.1'),
	('C00125','1.7.2.2'),
	('C00125','1.7.2.4'),
	('C00125','1.7.2.5'),
	('C00125','1.7.2.6'),
	('C00125','1.7.2.7'),
	('C00125','1.7.2.8'),
	('C00125','1.7.3.6'),
	('C00125','1.7.99.4'),
	('C00125','1.8.2.1'),
	('C00125','1.8.2.2'),
	('C00125','1.8.2.3'),
	('C00125','1.8.99.2'),
	('C00125','1.9.3.1'),
	('C00125','1.9.98.1'),
	('C00125','1.17.2.2'),
	('C00126','1.20.2.1'),
	('C00126','1.20.9.1'),
	('C00126','1.3.2.3'),
	('C00126','1.4.2.1'),
	('C00126','1.1.2.2'),
	('C00126','1.1.2.3'),
	('C00126','1.1.2.4'),
	('C00126','1.1.2.6'),
	('C00126','1.1.2.8'),
	('C00126','1.1.2.9'),
	('C00126','1.10.2.2'),
	('C00126','1.11.1.5'),
	('C00126','1.7.2.1'),
	('C00126','1.7.2.2'),
	('C00126','1.7.2.4'),
	('C00126','1.7.2.5'),
	('C00126','1.7.2.6'),
	('C00126','1.7.2.7'),
	('C00126','1.7.2.8'),
	('C00126','1.7.3.6'),
	('C00126','1.7.99.4'),
	('C00126','1.8.2.1'),
	('C00126','1.8.2.2'),
	('C00126','1.8.2.3'),
	('C00126','1.8.99.2'),
	('C00126','1.9.3.1'),
	('C00126','1.9.98.1'),
	('C00126','1.17.2.2'),
	('C00127','1.20.4.2'),
	('C00127','1.11.1.12'),
	('C00127','1.11.1.9'),
	('C00127','1.5.4.1'),
	('C00127','1.8.1.7'),
	('C00127','1.8.3.3'),
	('C00127','1.8.4.1'),
	('C00127','1.8.4.2'),
	('C00127','1.8.4.3'),
	('C00127','1.8.4.4'),
	('C00127','1.8.4.7'),
	('C00127','1.8.4.9'),
	('C00127','1.8.5.1'),
	('C00127','2.8.1.3'),
	('C00128','1.14.18.2'),
	('C00128','2.7.7.43'),
	('C00128','2.4.99.1'),
	('C00128','2.4.99.10'),
	('C00128','2.4.99.11'),
	('C00128','2.4.99.2'),
	('C00128','2.4.99.4'),
	('C00128','2.4.99.5'),
	('C00128','2.4.99.6'),
	('C00128','2.4.99.7'),
	('C00128','2.4.99.8'),
	('C00128','2.4.99.9'),
	('C00129','2.5.1.10'),
	('C00129','2.5.1.20'),
	('C00129','2.5.1.28'),
	('C00129','2.5.1.29'),
	('C00129','2.5.1.30'),
	('C00129','2.5.1.31'),
	('C00129','2.5.1.68'),
	('C00129','2.5.1.81'),
	('C00129','2.5.1.82'),
	('C00129','2.5.1.83'),
	('C00129','2.5.1.84'),
	('C00129','2.5.1.85'),
	('C00129','2.5.1.86'),
	('C00129','2.5.1.87'),
	('C00129','2.5.1.88'),
	('C00129','2.5.1.89'),
	('C00129','2.5.1.90'),
	('C00129','2.5.1.91'),
	('C00129','2.5.1.92'),
	('C00129','1.17.7.4'),
	('C00129','4.1.1.33'),
	('C00129','5.3.3.2'),
	('C00129','2.7.4.26'),
	('C00129','2.5.1.1'),
	('C00130','2.1.2.3'),
	('C00130','1.1.1.205'),
	('C00130','6.3.4.4'),
	('C00130','3.6.1.8'),
	('C00130','3.2.2.12'),
	('C00130','3.5.4.10'),
	('C00130','3.5.4.17'),
	('C00130','3.5.4.6'),
	('C00130','3.6.1.20'),
	('C00130','3.6.1.5'),
	('C00130','3.6.1.6'),
	('C00130','3.6.1.64'),
	('C00130','3.1.3.5'),
	('C00130','3.1.3.99'),
	('C00130','2.7.1.73'),
	('C00130','2.4.2.8'),
	('C00130','1.7.1.7'),
	('C00131','1.17.4.2'),
	('C00131','2.7.7.7'),
	('C00131','2.6.99.1'),
	('C00131','2.7.1.1'),
	('C00131','2.7.1.40'),
	('C00131','2.7.1.48'),
	('C00131','2.7.4.6'),
	('C00132','2.1.1.246'),
	('C00132','2.1.1.90'),
	('C00132','1.14.13.25'),
	('C00132','1.14.18.3'),
	('C00132','1.2.98.1'),
	('C00132','1.1.1.244'),
	('C00132','1.1.2.7'),
	('C00132','1.1.3.13'),
	('C00132','1.1.99.37'),
	('C00132','1.11.1.21'),
	('C00132','1.11.1.6'),
	('C00132','1.11.1.7'),
	('C00132','1.13.11.8'),
	('C00132','1.14.13.175'),
	('C00132','3.3.2.14'),
	('C00132','3.1.1.11'),
	('C00132','3.1.1.44'),
	('C00132','3.1.1.59'),
	('C00132','3.1.1.61'),
	('C00132','3.1.1.78'),
	('C00132','3.1.1.82'),
	('C00132','3.1.1.85'),
	('C00132','3.1.1.95'),
	('C00132','3.1.1.97'),
	('C00132','3.1.6.16'),
	('C00132','2.3.1.152'),
	('C00132','2.3.1.232'),
	('C00133','1.4.3.19'),
	('C00133','1.4.3.3'),
	('C00133','6.1.1.13'),
	('C00133','6.1.2.1'),
	('C00133','6.3.2.16'),
	('C00133','6.3.2.35'),
	('C00133','6.3.2.4'),
	('C00133','5.1.1.1'),
	('C00133','3.4.13.22'),
	('C00133','3.4.17.8'),
	('C00133','2.6.1.21'),
	('C00133','2.1.2.7'),
	('C00133','2.3.2.14'),
	('C00134','2.1.1.53'),
	('C00134','1.4.3.10'),
	('C00134','1.4.3.22'),
	('C00134','1.5.1.43'),
	('C00134','1.5.3.13'),
	('C00134','6.3.1.11'),
	('C00134','4.1.1.17'),
	('C00134','3.5.1.53'),
	('C00134','3.5.1.62'),
	('C00134','3.5.3.11'),
	('C00134','2.6.1.29'),
	('C00134','2.6.1.82'),
	('C00134','2.5.1.16'),
	('C00134','2.5.1.44'),
	('C00134','2.5.1.45'),
	('C00134','2.1.3.6'),
	('C00134','2.3.1.138'),
	('C00134','2.3.1.57'),
	('C00134','1.5.3.17'),
	('C00135','1.1.1.23'),
	('C00135','1.14.99.52'),
	('C00135','2.1.1.44'),
	('C00135','2.3.1.33'),
	('C00135','2.6.1.38'),
	('C00135','3.4.13.18'),
	('C00135','3.4.13.20'),
	('C00135','4.1.1.22'),
	('C00135','4.1.1.28'),
	('C00135','4.3.1.3'),
	('C00135','6.1.1.21'),
	('C00135','6.3.2.11'),
	('C00136','1.3.3.6'),
	('C00136','1.3.8.7'),
	('C00136','1.3.1.44'),
	('C00136','1.2.1.10'),
	('C00136','1.2.1.87'),
	('C00136','1.2.1.57'),
	('C00136','5.4.99.13'),
	('C00136','6.2.1.2'),
	('C00136','6.4.1.3'),
	('C00136','4.1.1.94'),
	('C00136','2.8.3.8'),
	('C00136','2.8.3.9'),
	('C00136','2.3.1.19'),
	('C00136','2.3.1.9'),
	('C00136','2.3.3.7'),
	('C00136','2.3.1.16'),
	('C00136','1.3.8.1'),
	('C00136','1.3.1.86'),
	('C00137','1.13.99.1'),
	('C00137','1.1.1.18'),
	('C00137','3.1.4.44'),
	('C00137','3.2.1.22'),
	('C00137','2.7.8.11'),
	('C00137','3.1.3.25'),
	('C00137','2.1.1.40'),
	('C00137','2.4.1.67'),
	('C00137','2.4.1.82'),
	('C00137','2.3.1.72'),
	('C00137','2.4.1.123'),
	('C00137','2.1.1.129'),
	('C00137','2.1.1.39'),
	('C00137','2.7.1.64'),
	('C00138','1.2.7.6'),
	('C00138','1.14.15.4'),
	('C00138','1.14.15.11'),
	('C00138','1.14.15.7'),
	('C00138','1.2.7.7'),
	('C00138','1.2.7.8'),
	('C00138','1.3.7.15'),
	('C00138','1.3.7.2'),
	('C00138','1.3.7.3'),
	('C00138','1.3.7.4'),
	('C00138','1.3.7.5'),
	('C00138','1.3.7.6'),
	('C00138','1.3.7.7'),
	('C00138','1.3.7.8'),
	('C00138','1.3.7.9'),
	('C00138','1.14.15.8'),
	('C00138','1.14.15.9'),
	('C00138','1.14.15.13'),
	('C00138','1.14.15.17'),
	('C00138','1.14.19.8'),
	('C00138','1.14.19.11'),
	('C00138','1.14.19.2'),
	('C00138','1.14.19.26'),
	('C00138','1.18.1.2'),
	('C00138','1.18.1.3'),
	('C00138','1.18.6.1'),
	('C00138','1.17.7.1'),
	('C00138','1.17.7.2'),
	('C00138','1.17.7.4'),
	('C00138','1.17.99.1'),
	('C00138','1.12.1.4'),
	('C00138','1.12.7.2'),
	('C00138','4.2.1.164'),
	('C00138','2.3.1.169'),
	('C00138','1.7.7.1'),
	('C00138','1.7.7.2'),
	('C00138','1.97.1.12'),
	('C00138','1.8.7.1'),
	('C00138','1.8.7.2'),
	('C00138','1.3.7.1'),
	('C00138','1.3.7.12'),
	('C00138','1.4.7.1'),
	('C00138','1.5.7.1'),
	('C00138','1.5.7.2'),
	('C00138','1.2.7.1'),
	('C00138','1.2.7.10'),
	('C00138','1.2.7.11'),
	('C00138','1.2.7.3'),
	('C00138','1.2.7.4'),
	('C00138','1.2.7.5'),
	('C00138','1.14.15.19'),
	('C00139','1.14.15.19'),
	('C00139','1.14.15.4'),
	('C00139','1.14.15.11'),
	('C00139','1.14.15.7'),
	('C00139','1.2.7.7'),
	('C00139','1.2.7.8'),
	('C00139','1.3.7.12'),
	('C00139','1.3.7.15'),
	('C00139','1.3.7.2'),
	('C00139','1.3.7.3'),
	('C00139','1.3.7.4'),
	('C00139','1.3.7.5'),
	('C00139','1.3.7.6'),
	('C00139','1.3.7.7'),
	('C00139','1.3.7.8'),
	('C00139','1.14.15.8'),
	('C00139','1.14.15.9'),
	('C00139','1.14.15.13'),
	('C00139','1.14.15.17'),
	('C00139','1.14.19.8'),
	('C00139','1.14.19.11'),
	('C00139','1.14.19.2'),
	('C00139','1.14.19.26'),
	('C00139','1.18.1.2'),
	('C00139','1.18.1.3'),
	('C00139','1.18.6.1'),
	('C00139','1.17.7.1'),
	('C00139','1.17.7.2'),
	('C00139','1.17.7.4'),
	('C00139','1.17.99.1'),
	('C00139','1.12.1.4'),
	('C00139','1.12.7.2'),
	('C00139','4.2.1.164'),
	('C00139','2.3.1.169'),
	('C00139','1.7.7.1'),
	('C00139','1.7.7.2'),
	('C00139','1.97.1.12'),
	('C00139','1.8.7.1'),
	('C00139','1.8.7.2'),
	('C00139','1.3.7.9'),
	('C00139','1.3.7.1'),
	('C00139','1.4.7.1'),
	('C00139','1.5.7.1'),
	('C00139','1.5.7.2'),
	('C00139','1.2.7.1'),
	('C00139','1.2.7.10'),
	('C00139','1.2.7.11'),
	('C00139','1.2.7.3'),
	('C00139','1.2.7.4'),
	('C00139','1.2.7.5'),
	('C00139','1.2.7.6'),
	('C00140','2.4.1.320'),
	('C00140','2.3.1.3'),
	('C00140','2.4.1.280'),
	('C00140','2.4.1.211'),
	('C00140','1.1.3.29'),
	('C00140','5.1.3.8'),
	('C00140','3.2.2.11'),
	('C00140','3.2.1.50'),
	('C00140','3.2.1.52'),
	('C00140','3.5.1.33'),
	('C00140','3.1.4.45'),
	('C00140','3.2.1.169'),
	('C00140','3.2.1.14'),
	('C00140','2.7.1.162'),
	('C00140','2.7.1.59'),
	('C00140','2.7.1.193'),
	('C00140','2.4.1.90'),
	('C00141','2.3.3.13'),
	('C00141','2.6.1.66'),
	('C00141','1.4.1.23'),
	('C00141','1.4.1.8'),
	('C00141','1.4.1.9'),
	('C00141','1.2.7.7'),
	('C00141','1.2.4.4'),
	('C00141','1.2.1.25'),
	('C00141','1.1.1.84'),
	('C00141','4.1.2.12'),
	('C00141','4.2.1.9'),
	('C00141','2.6.1.32'),
	('C00141','2.6.1.42'),
	('C00141','2.6.1.6'),
	('C00141','2.1.2.11'),
	('C00143','1.8.1.4'),
	('C00143','1.5.1.5'),
	('C00143','2.1.1.54'),
	('C00143','2.1.2.1'),
	('C00143','2.1.2.10'),
	('C00143','2.1.2.11'),
	('C00143','2.1.2.7'),
	('C00143','2.1.2.8'),
	('C00143','2.1.1.74'),
	('C00143','2.1.1.45'),
	('C00143','1.5.1.15'),
	('C00143','1.5.1.20'),
	('C00143','1.4.4.2'),
	('C00143','1.5.7.1'),
	('C00143','2.1.1.148'),
	('C00144','2.4.2.22'),
	('C00144','2.7.1.73'),
	('C00144','2.4.2.8'),
	('C00144','1.7.1.7'),
	('C00144','6.5.1.5'),
	('C00144','6.5.1.7'),
	('C00144','6.3.5.2'),
	('C00144','3.6.1.6'),
	('C00144','3.6.1.17'),
	('C00144','3.6.1.21'),
	('C00144','3.6.1.8'),
	('C00144','3.6.1.42'),
	('C00144','3.6.1.5'),
	('C00144','3.1.3.5'),
	('C00144','3.1.4.17'),
	('C00144','3.1.4.35'),
	('C00144','2.7.4.8'),
	('C00144','2.7.8.26'),
	('C00144','2.7.8.28'),
	('C00144','2.7.8.9'),
	('C00144','2.4.2.7'),
	('C00145','2.1.1.9'),
	('C00145','2.8.2.16'),
	('C00145','3.2.1.147'),
	('C00145','3.4.19.12'),
	('C00146','2.4.2.55'),
	('C00146','2.1.1.25'),
	('C00146','3.1.1.2'),
	('C00146','4.1.1.91'),
	('C00146','4.1.1.61'),
	('C00146','4.1.99.2'),
	('C00146','1.14.13.7'),
	('C00147','2.4.2.52'),
	('C00147','2.7.8.37'),
	('C00147','2.4.2.1'),
	('C00147','2.4.2.57'),
	('C00147','2.4.2.7'),
	('C00147','2.4.2.8'),
	('C00147','1.5.99.12'),
	('C00147','3.2.2.1'),
	('C00147','3.2.2.16'),
	('C00147','3.5.4.2'),
	('C00147','3.2.2.30'),
	('C00147','3.2.2.4'),
	('C00147','3.2.2.7'),
	('C00147','3.2.2.8'),
	('C00147','3.2.2.9'),
	('C00147','2.4.2.28'),
	('C00148','1.5.1.1'),
	('C00148','1.5.1.2'),
	('C00148','1.5.1.21'),
	('C00148','1.5.5.2'),
	('C00148','1.5.1.49'),
	('C00148','3.4.11.5'),
	('C00148','1.14.11.28'),
	('C00148','6.1.1.15'),
	('C00148','4.3.1.12'),
	('C00148','5.1.1.4'),
	('C00148','3.5.1.101'),
	('C00148','1.14.11.2'),
	('C00149','2.3.1.92'),
	('C00149','3.1.2.30'),
	('C00149','1.1.5.4'),
	('C00149','1.1.99.7'),
	('C00149','1.1.1.299'),
	('C00149','1.1.1.82'),
	('C00149','1.1.1.38'),
	('C00149','1.1.1.39'),
	('C00149','1.1.1.40'),
	('C00149','1.1.1.37'),
	('C00149','6.2.1.9'),
	('C00149','4.1.1.101'),
	('C00149','4.2.1.2'),
	('C00149','2.8.3.22'),
	('C00149','2.3.3.9'),
	('C00151','1.4.1.5'),
	('C00151','2.6.1.14'),
	('C00151','3.5.1.87'),
	('C00151','2.3.2.4'),
	('C00151','3.5.1.14'),
	('C00151','2.3.2.2'),
	('C00151','5.1.1.10'),
	('C00151','6.3.2.48'),
	('C00151','2.6.1.88'),
	('C00151','1.4.3.2'),
	('C00151','1.5.3.2'),
	('C00151','2.6.1.13'),
	('C00151','2.6.1.12'),
	('C00152','3.5.5.4'),
	('C00152','3.5.1.38'),
	('C00152','3.5.1.1'),
	('C00152','3.2.2.11'),
	('C00152','4.2.1.65'),
	('C00152','6.3.5.4'),
	('C00152','6.3.1.1'),
	('C00152','6.3.1.4'),
	('C00152','6.1.1.22'),
	('C00152','2.3.2.7'),
	('C00152','2.6.1.14'),
	('C00152','1.14.11.39'),
	('C00153','2.4.2.30'),
	('C00153','2.4.2.31'),
	('C00153','2.4.2.1'),
	('C00153','2.4.2.12'),
	('C00153','2.4.99.20'),
	('C00153','2.4.2.36'),
	('C00153','2.4.2.37'),
	('C00153','2.1.1.1'),
	('C00153','3.2.2.1'),
	('C00153','3.2.2.14'),
	('C00153','3.2.2.3'),
	('C00153','3.5.1.19'),
	('C00153','3.2.2.5'),
	('C00153','3.2.2.6'),
	('C00154','1.3.3.6'),
	('C00154','3.1.2.2'),
	('C00154','1.14.19.32'),
	('C00154','1.2.1.42'),
	('C00154','2.3.1.21'),
	('C00154','2.3.1.199'),
	('C00154','2.3.1.50'),
	('C00154','2.3.1.225'),
	('C00154','2.3.1.96'),
	('C00154','2.3.1.86'),
	('C00154','2.3.1.76'),
	('C00154','2.3.1.139'),
	('C00154','2.3.1.142'),
	('C00154','2.3.1.123'),
	('C00154','2.3.1.100'),
	('C00154','1.3.8.8'),
	('C00154','1.3.8.9'),
	('C00154','1.3.8.7'),
	('C00154','1.3.1.38'),
	('C00154','6.2.1.3'),
	('C00154','3.1.2.22'),
	('C00154','1.3.1.8'),
	('C00155','2.5.1.49'),
	('C00155','1.8.4.1'),
	('C00155','2.1.1.13'),
	('C00155','2.1.1.14'),
	('C00155','2.1.1.10'),
	('C00155','2.1.1.5'),
	('C00155','2.1.1.3'),
	('C00155','4.2.1.22'),
	('C00155','4.4.1.2'),
	('C00155','4.4.1.21'),
	('C00155','4.4.1.8'),
	('C00155','3.3.1.1'),
	('C00155','2.5.1.48'),
	('C00155','2.5.1.134'),
	('C00156','3.1.2.23'),
	('C00156','1.2.1.28'),
	('C00156','1.2.1.96'),
	('C00156','1.2.1.64'),
	('C00156','1.2.1.7'),
	('C00156','1.13.11.41'),
	('C00156','1.14.13.12'),
	('C00156','1.14.13.64'),
	('C00156','1.14.13.33'),
	('C00156','1.14.13.2'),
	('C00156','2.4.1.194'),
	('C00156','2.4.2.54'),
	('C00156','2.5.1.39'),
	('C00156','2.5.1.93'),
	('C00156','6.2.1.27'),
	('C00156','4.1.1.61'),
	('C00156','4.1.3.40'),
	('C00156','3.8.1.6'),
	('C00156','1.14.99.15'),
	('C00157','2.3.1.43'),
	('C00157','3.1.1.4'),
	('C00157','2.3.1.83'),
	('C00157','2.3.1.62'),
	('C00157','2.1.1.16'),
	('C00157','2.1.1.71'),
	('C00157','2.3.1.135'),
	('C00157','3.1.4.3'),
	('C00157','3.1.4.4'),
	('C00157','2.7.8.24'),
	('C00157','2.7.8.27'),
	('C00157','2.7.8.2'),
	('C00157','3.1.1.5'),
	('C00157','3.1.1.32'),
	('C00157','2.3.1.23'),
	('C00158','2.3.3.1'),
	('C00158','2.3.3.16'),
	('C00158','2.3.3.3'),
	('C00158','2.3.3.8'),
	('C00158','2.8.3.10'),
	('C00158','6.3.1.17'),
	('C00158','6.2.1.18'),
	('C00158','4.1.3.6'),
	('C00158','4.2.1.3'),
	('C00158','6.3.2.38'),
	('C00159','1.1.1.255'),
	('C00159','3.2.1.137'),
	('C00159','2.7.1.1'),
	('C00159','2.7.1.61'),
	('C00159','2.7.1.191'),
	('C00159','2.7.1.7'),
	('C00159','5.3.1.7'),
	('C00159','3.1.4.49'),
	('C00159','3.2.1.163'),
	('C00159','3.2.1.113'),
	('C00159','3.2.1.114'),
	('C00159','3.2.1.77'),
	('C00159','3.2.1.78'),
	('C00159','3.2.1.24'),
	('C00159','3.2.1.25'),
	('C00159','3.2.1.22'),
	('C00159','1.1.3.40'),
	('C00160','3.8.1.3'),
	('C00160','4.2.99.12'),
	('C00160','3.8.1.2'),
	('C00160','3.1.3.18'),
	('C00160','1.1.99.14'),
	('C00160','1.1.3.15'),
	('C00160','1.1.1.29'),
	('C00160','1.1.1.26'),
	('C00160','1.1.1.79'),
	('C00160','1.2.1.21'),
	('C00161','4.3.1.17'),
	('C00161','4.3.1.18'),
	('C00161','4.3.1.19'),
	('C00161','4.3.1.20'),
	('C00161','4.1.1.1'),
	('C00161','2.6.1.12'),
	('C00161','2.6.1.13'),
	('C00161','2.6.1.14'),
	('C00161','2.6.1.21'),
	('C00161','2.6.1.88'),
	('C00161','1.4.1.19'),
	('C00161','1.4.1.2'),
	('C00161','1.4.1.20'),
	('C00161','1.4.1.3'),
	('C00161','1.4.99.6'),
	('C00161','1.4.3.3'),
	('C00161','1.4.1.4'),
	('C00161','1.4.1.5'),
	('C00161','1.4.1.7'),
	('C00161','1.4.1.8'),
	('C00161','1.4.1.9'),
	('C00161','1.4.3.1'),
	('C00161','1.4.3.11'),
	('C00161','1.4.3.2'),
	('C00161','1.4.3.7'),
	('C00161','1.4.5.1'),
	('C00161','1.2.7.11'),
	('C00161','1.4.1.1'),
	('C00161','1.4.1.10'),
	('C00161','1.4.1.12'),
	('C00161','1.4.1.15'),
	('C00161','1.2.1.23'),
	('C00161','1.2.1.49'),
	('C00161','1.1.99.30'),
	('C00161','1.1.5.10'),
	('C00161','1.1.3.15'),
	('C00161','1.1.1.337'),
	('C00161','1.1.1.272'),
	('C00161','1.1.1.375'),
	('C00161','1.1.1.345'),
	('C00162','2.1.1.15'),
	('C00162','1.2.99.7'),
	('C00162','1.2.5.2'),
	('C00162','1.2.1.5'),
	('C00162','1.2.1.3'),
	('C00162','1.11.2.4'),
	('C00162','1.14.15.3'),
	('C00162','1.14.14.1'),
	('C00162','3.5.1.23'),
	('C00162','3.1.1.90'),
	('C00162','3.1.1.64'),
	('C00162','3.1.1.77'),
	('C00162','3.1.1.5'),
	('C00162','3.1.1.26'),
	('C00162','3.1.1.28'),
	('C00162','3.1.1.3'),
	('C00162','3.1.1.32'),
	('C00162','3.1.1.34'),
	('C00162','3.1.1.4'),
	('C00162','3.1.1.13'),
	('C00162','3.1.1.23'),
	('C00162','1.2.99.6'),
	('C00163','6.2.1.1'),
	('C00163','6.2.1.13'),
	('C00163','6.2.1.17'),
	('C00163','2.7.2.15'),
	('C00163','2.8.3.1'),
	('C00163','2.7.2.1'),
	('C00163','4.1.3.32'),
	('C00164','2.3.1.247'),
	('C00164','1.8.1.5'),
	('C00164','1.1.1.30'),
	('C00164','1.1.99.24'),
	('C00164','6.2.1.16'),
	('C00164','6.4.1.6'),
	('C00164','3.1.2.11'),
	('C00164','4.2.1.27'),
	('C00164','3.7.1.2'),
	('C00164','4.1.1.4'),
	('C00164','2.8.3.5'),
	('C00164','2.8.3.8'),
	('C00164','2.8.3.9'),
	('C00164','4.1.3.4'),
	('C00165','2.3.1.22'),
	('C00165','2.3.1.77'),
	('C00165','3.1.1.34'),
	('C00165','3.1.1.3'),
	('C00165','3.1.1.79'),
	('C00166','2.6.1.28'),
	('C00166','2.1.1.281'),
	('C00166','1.4.1.20'),
	('C00166','1.4.3.2'),
	('C00166','1.4.5.1'),
	('C00166','1.13.11.27'),
	('C00166','1.1.1.237'),
	('C00166','1.1.1.222'),
	('C00166','5.3.2.1'),
	('C00166','4.2.1.51'),
	('C00166','4.2.1.91'),
	('C00166','4.1.1.43'),
	('C00166','2.6.1.5'),
	('C00166','2.6.1.21'),
	('C00166','2.6.1.1'),
	('C00166','2.6.1.9'),
	('C00166','2.6.1.57'),
	('C00166','2.6.1.58'),
	('C00166','2.6.1.64'),
	('C00166','2.6.1.70'),
	('C00167','2.4.1.191'),
	('C00167','2.4.1.17'),
	('C00167','2.4.1.135'),
	('C00167','2.4.1.254'),
	('C00167','2.4.1.262'),
	('C00167','2.4.1.264'),
	('C00167','2.4.1.253'),
	('C00167','2.4.1.212'),
	('C00167','2.4.1.225'),
	('C00167','2.4.1.226'),
	('C00167','1.1.1.22'),
	('C00167','1.1.1.305'),
	('C00167','5.1.3.6'),
	('C00167','5.1.3.12'),
	('C00167','4.1.1.35'),
	('C00167','2.7.7.44'),
	('C00167','2.7.7.64'),
	('C00167','2.4.1.189'),
	('C00167','2.4.1.190'),
	('C00168','1.1.1.29'),
	('C00168','2.6.1.51'),
	('C00168','2.6.1.45'),
	('C00168','4.1.1.40'),
	('C00168','5.3.1.22'),
	('C00168','1.1.1.79'),
	('C00168','1.1.1.81'),
	('C00168','1.1.1.26'),
	('C00168','1.4.1.7'),
	('C00169','2.1.3.8'),
	('C00169','6.3.5.5'),
	('C00169','2.7.2.2'),
	('C00169','6.1.2.2'),
	('C00169','6.3.4.16'),
	('C00169','2.1.3.7'),
	('C00169','2.1.3.9'),
	('C00169','2.1.3.5'),
	('C00169','2.1.3.3'),
	('C00169','2.1.3.2'),
	('C00169','2.1.3.12'),
	('C00169','2.1.3.11'),
	('C00169','2.1.3.6'),
	('C00170','2.3.1.229'),
	('C00170','2.5.1.23'),
	('C00170','2.3.1.184'),
	('C00170','2.5.1.79'),
	('C00170','2.5.1.128'),
	('C00170','2.5.1.127'),
	('C00170','2.5.1.126'),
	('C00170','2.5.1.114'),
	('C00170','4.4.1.14'),
	('C00170','2.5.1.38'),
	('C00170','2.5.1.25'),
	('C00170','3.3.1.2'),
	('C00170','3.2.2.16'),
	('C00170','3.5.4.31'),
	('C00170','3.2.2.9'),
	('C00170','2.5.1.24'),
	('C00170','2.5.1.4'),
	('C00170','2.5.1.43'),
	('C00170','2.4.2.28'),
	('C00170','2.5.1.16'),
	('C00170','2.5.1.104'),
	('C00170','2.5.1.108'),
	('C00170','2.5.1.22'),
	('C00170','2.3.1.228'),
	('C00173','1.3.1.39'),
	('C00173','1.3.1.9'),
	('C00173','1.3.1.104'),
	('C00173','1.3.1.10'),
	('C00173','2.3.1.141'),
	('C00173','2.3.1.40'),
	('C00173','2.3.1.51'),
	('C00173','2.3.1.41'),
	('C00173','2.3.1.15'),
	('C00173','2.3.1.184'),
	('C00175','4.99.1.3'),
	('C00175','6.6.1.2'),
	('C00176','1.5.1.36'),
	('C00177','4.1.2.11'),
	('C00177','4.1.2.46'),
	('C00177','4.1.2.47'),
	('C00177','4.4.1.9'),
	('C00177','2.8.1.1'),
	('C00177','1.4.99.5'),
	('C00177','1.16.1.6'),
	('C00177','1.14.17.4'),
	('C00177','4.1.2.10'),
	('C00178','1.14.11.6'),
	('C00178','3.5.4.1'),
	('C00178','2.4.2.2'),
	('C00178','2.4.2.6'),
	('C00178','2.4.2.4'),
	('C00178','1.3.1.2'),
	('C00178','1.3.1.1'),
	('C00178','1.14.99.46'),
	('C00178','1.17.99.4'),
	('C00179','6.3.4.22'),
	('C00179','4.1.1.19'),
	('C00179','3.5.1.40'),
	('C00179','3.5.3.20'),
	('C00179','2.3.1.64'),
	('C00179','3.5.3.12'),
	('C00179','2.7.3.10'),
	('C00179','2.5.1.104'),
	('C00179','3.5.3.11'),
	('C00180','2.1.1.273'),
	('C00180','3.1.1.1'),
	('C00180','1.2.1.7'),
	('C00180','1.14.13.12'),
	('C00180','1.14.12.10'),
	('C00180','6.2.1.25'),
	('C00180','3.5.1.32'),
	('C00180','3.5.1.4'),
	('C00180','3.5.1.40'),
	('C00180','3.6.1.20'),
	('C00180','3.5.5.1'),
	('C00180','3.7.1.8'),
	('C00180','3.6.1.7'),
	('C00180','3.1.1.84'),
	('C00180','1.2.1.28'),
	('C00181','1.1.1.175'),
	('C00181','1.1.1.121'),
	('C00181','1.1.1.21'),
	('C00181','3.2.1.37'),
	('C00181','1.1.1.307'),
	('C00181','5.3.1.5'),
	('C00181','1.1.1.179'),
	('C00183','1.4.1.23'),
	('C00183','1.4.1.8'),
	('C00183','1.4.1.9'),
	('C00183','1.14.13.117'),
	('C00183','1.14.13.118'),
	('C00183','6.1.1.9'),
	('C00183','2.6.1.66'),
	('C00183','6.3.2.26'),
	('C00183','4.1.1.14'),
	('C00183','2.6.1.32'),
	('C00183','2.6.1.42'),
	('C00183','2.6.1.6'),
	('C00183','6.3.2.47'),
	('C00184','2.2.1.3'),
	('C00184','1.1.1.156'),
	('C00184','1.1.1.6'),
	('C00184','2.7.1.29'),
	('C00184','3.1.3.2'),
	('C00184','3.1.3.1'),
	('C00184','2.7.1.121'),
	('C00184','1.1.99.22'),
	('C00185','2.7.1.85'),
	('C00185','2.4.1.20'),
	('C00185','1.1.99.18'),
	('C00185','5.1.3.11'),
	('C00185','2.7.1.205'),
	('C00185','3.2.1.74'),
	('C00185','3.2.1.4'),
	('C00185','3.2.1.21'),
	('C00185','3.2.1.91'),
	('C00186','1.2.1.22'),
	('C00186','1.1.99.7'),
	('C00186','1.13.12.4'),
	('C00186','1.1.1.27'),
	('C00186','2.8.3.1'),
	('C00186','4.1.1.101'),
	('C00186','4.1.2.36'),
	('C00186','5.1.2.1'),
	('C00186','1.1.2.3'),
	('C00187','2.3.1.73'),
	('C00187','3.1.1.13'),
	('C00187','1.3.1.21'),
	('C00187','1.3.1.72'),
	('C00187','1.14.15.15'),
	('C00187','1.14.99.38'),
	('C00187','1.14.19.21'),
	('C00187','1.1.3.6'),
	('C00187','1.14.14.23'),
	('C00187','1.14.14.25'),
	('C00187','1.14.15.6'),
	('C00187','1.1.1.145'),
	('C00187','5.3.3.1'),
	('C00187','3.2.1.104'),
	('C00187','3.1.6.2'),
	('C00187','2.8.2.14'),
	('C00187','2.8.2.2'),
	('C00187','2.3.1.26'),
	('C00188','2.2.1.8'),
	('C00188','1.1.1.103'),
	('C00188','6.1.1.3'),
	('C00188','4.1.2.48'),
	('C00188','4.1.2.5'),
	('C00188','4.2.3.1'),
	('C00188','4.3.1.19'),
	('C00188','5.1.1.6'),
	('C00188','2.7.7.87'),
	('C00188','2.7.1.177'),
	('C00189','2.7.1.82'),
	('C00189','1.4.3.8'),
	('C00189','4.3.1.7'),
	('C00189','3.5.1.99'),
	('C00189','3.5.1.60'),
	('C00189','3.1.4.4'),
	('C00189','3.1.4.46'),
	('C00189','3.1.4.2'),
	('C00189','3.1.3.75'),
	('C00189','3.1.4.39'),
	('C00189','2.7.8.29'),
	('C00190','2.4.2.35'),
	('C00190','2.4.2.56'),
	('C00190','2.4.2.32'),
	('C00190','2.4.2.24'),
	('C00190','2.4.2.51'),
	('C00190','5.1.3.5'),
	('C00190','2.7.7.11'),
	('C00190','2.4.2.40'),
	('C00190','4.1.1.35'),
	('C00190','2.7.7.64'),
	('C00190','2.7.8.32'),
	('C00190','2.4.2.50'),
	('C00191','2.7.1.43'),
	('C00191','3.1.1.19'),
	('C00191','3.2.1.139'),
	('C00191','3.2.1.31'),
	('C00191','3.2.1.56'),
	('C00191','3.2.1.167'),
	('C00191','3.1.1.93'),
	('C00191','5.3.1.12'),
	('C00191','1.1.1.19'),
	('C00191','1.1.1.203'),
	('C00191','1.1.1.2'),
	('C00191','2.4.1.17'),
	('C00191','1.13.99.1'),
	('C00192','1.7.99.1'),
	('C00192','1.7.1.10'),
	('C00192','1.7.1.5'),
	('C00192','1.7.2.6'),
	('C00192','1.7.3.6'),
	('C00192','1.3.7.8'),
	('C00192','1.14.99.39'),
	('C00192','2.3.2.7'),
	('C00193','1.2.3.9'),
	('C00193','1.2.1.29'),
	('C00193','1.1.1.91'),
	('C00193','1.1.3.7'),
	('C00193','1.1.1.90'),
	('C00193','1.2.1.30'),
	('C00194','3.1.3.73'),
	('C00194','2.5.1.17'),
	('C00194','2.7.8.26'),
	('C00195','1.14.19.17'),
	('C00195','2.3.1.24'),
	('C00195','3.5.1.23'),
	('C00195','3.1.3.4'),
	('C00195','3.1.4.12'),
	('C00195','3.2.1.123'),
	('C00195','3.2.1.62'),
	('C00195','3.2.1.45'),
	('C00195','3.2.1.46'),
	('C00195','2.7.8.27'),
	('C00195','2.7.8.3'),
	('C00195','2.7.1.138'),
	('C00195','2.4.1.80'),
	('C00195','2.4.1.45'),
	('C00195','2.4.1.47'),
	('C00195','1.14.19.18'),
	('C00196','1.3.1.28'),
	('C00196','1.14.99.23'),
	('C00196','1.13.11.14'),
	('C00196','2.7.7.58'),
	('C00196','1.14.13.35'),
	('C00196','6.3.2.14'),
	('C00196','4.1.1.46'),
	('C00196','1.13.11.28'),
	('C00197','2.4.1.266'),
	('C00197','2.7.2.3'),
	('C00197','1.2.7.6'),
	('C00197','1.2.1.9'),
	('C00197','1.2.1.90'),
	('C00197','1.1.1.95'),
	('C00197','5.4.2.12'),
	('C00197','5.4.2.11'),
	('C00197','3.6.1.7'),
	('C00197','4.1.1.39'),
	('C00197','3.1.3.38'),
	('C00197','2.7.1.106'),
	('C00197','2.7.1.31'),
	('C00197','2.7.4.17'),
	('C00197','2.7.2.10'),
	('C00197','2.4.1.217'),
	('C00198','2.3.1.132'),
	('C00198','1.1.3.5'),
	('C00198','1.1.5.2'),
	('C00198','1.1.99.35'),
	('C00198','1.1.1.121'),
	('C00198','1.1.1.118'),
	('C00198','3.1.1.17'),
	('C00198','1.1.1.47'),
	('C00198','1.1.1.359'),
	('C00198','1.1.1.360'),
	('C00198','1.1.3.4'),
	('C00198','1.1.5.9'),
	('C00198','1.1.99.28'),
	('C00198','1.1.1.119'),
	('C00199','1.1.1.137'),
	('C00199','1.1.1.351'),
	('C00199','1.1.1.44'),
	('C00199','1.1.1.343'),
	('C00199','5.3.1.6'),
	('C00199','4.1.2.43'),
	('C00199','2.7.1.47'),
	('C00199','4.3.3.6'),
	('C00199','5.1.3.1'),
	('C00199','5.3.1.13'),
	('C00199','2.7.1.16'),
	('C00199','2.7.1.19'),
	('C00199','4.1.99.12'),
	('C00201','2.7.7.48'),
	('C00201','2.7.7.46'),
	('C00201','2.7.7.28'),
	('C00201','3.6.1.9'),
	('C00201','2.7.4.10'),
	('C00201','3.6.1.15'),
	('C00201','2.7.4.6'),
	('C00201','2.7.1.74'),
	('C00201','2.7.1.40'),
	('C00201','2.7.7.6'),
	('C00201','3.6.1.5'),
	('C00202','3.1.8.2'),
	('C00203','2.4.1.165'),
	('C00203','2.4.1.175'),
	('C00203','2.4.1.92'),
	('C00203','2.4.1.313'),
	('C00203','2.4.1.306'),
	('C00203','2.4.1.41'),
	('C00203','2.4.1.40'),
	('C00203','2.7.8.40'),
	('C00203','2.7.7.83'),
	('C00203','5.1.3.7'),
	('C00203','5.1.3.2'),
	('C00203','2.4.1.290'),
	('C00203','2.4.1.79'),
	('C00203','2.4.1.88'),
	('C00204','1.1.1.125'),
	('C00204','1.1.1.126'),
	('C00204','1.1.1.127'),
	('C00204','4.2.1.7'),
	('C00204','4.2.1.8'),
	('C00204','4.3.1.9'),
	('C00204','4.2.1.140'),
	('C00204','4.1.2.51'),
	('C00204','4.1.2.55'),
	('C00204','4.2.1.39'),
	('C00204','2.7.1.45'),
	('C00204','2.7.1.178'),
	('C00205','1.13.12.5'),
	('C00205','1.13.12.18'),
	('C00205','1.13.12.13'),
	('C00205','1.14.14.3'),
	('C00205','1.14.99.21'),
	('C00205','1.13.12.8'),
	('C00205','1.13.12.7'),
	('C00205','1.10.3.9'),
	('C00205','1.13.12.6'),
	('C00205','1.97.1.12'),
	('C00206','1.17.4.1'),
	('C00206','2.7.1.48'),
	('C00206','2.7.1.40'),
	('C00206','2.7.1.1'),
	('C00206','2.7.4.11'),
	('C00206','2.7.4.3'),
	('C00206','2.7.4.6'),
	('C00207','1.14.13.115'),
	('C00207','1.14.13.102'),
	('C00207','1.1.1.80'),
	('C00207','2.6.3.1'),
	('C00207','1.14.13.226'),
	('C00207','4.1.1.4'),
	('C00207','6.4.1.6'),
	('C00207','4.1.2.46'),
	('C00207','4.1.99.16'),
	('C00207','4.2.3.22'),
	('C00208','3.2.1.133'),
	('C00208','3.2.1.20'),
	('C00208','3.2.1.2'),
	('C00208','3.2.1.1'),
	('C00208','3.1.3.90'),
	('C00208','5.4.99.16'),
	('C00208','2.4.1.139'),
	('C00208','2.4.1.25'),
	('C00208','2.4.1.8'),
	('C00208','2.3.1.79'),
	('C00208','2.7.1.208'),
	('C00208','2.7.1.175'),
	('C00209','2.8.3.16'),
	('C00209','2.8.3.19'),
	('C00209','2.8.3.2'),
	('C00209','1.2.3.5'),
	('C00209','1.2.7.10'),
	('C00209','4.1.1.2'),
	('C00209','2.5.1.77'),
	('C00209','6.2.1.8'),
	('C00209','3.7.1.1'),
	('C00209','1.2.3.4'),
	('C00212','2.7.1.74'),
	('C00212','3.1.3.5'),
	('C00212','3.5.4.4'),
	('C00212','3.2.2.7'),
	('C00212','3.2.2.8'),
	('C00212','3.3.1.1'),
	('C00212','3.2.2.1'),
	('C00212','2.7.1.114'),
	('C00212','2.7.1.20'),
	('C00212','3.1.3.6'),
	('C00212','2.4.2.1'),
	('C00212','1.1.3.39'),
	('C00213','3.5.1.59'),
	('C00213','1.4.3.19'),
	('C00213','2.1.1.162'),
	('C00213','2.1.1.20'),
	('C00213','3.5.3.3'),
	('C00213','1.5.3.1'),
	('C00213','2.1.1.157'),
	('C00213','1.5.8.4'),
	('C00213','1.5.8.3'),
	('C00213','1.21.4.3'),
	('C00213','1.5.3.10'),
	('C00213','2.1.1.156'),
	('C00214','3.1.3.35'),
	('C00214','3.1.3.5'),
	('C00214','2.4.2.4'),
	('C00214','2.4.2.6'),
	('C00214','2.4.2.2'),
	('C00214','2.7.1.21'),
	('C00214','2.7.1.118'),
	('C00214','2.7.1.114'),
	('C00214','3.1.3.89'),
	('C00215','3.6.1.6'),
	('C00215','3.6.1.9'),
	('C00215','3.1.3.31'),
	('C00215','2.7.1.77'),
	('C00216','4.1.2.23'),
	('C00216','2.7.1.54'),
	('C00216','1.1.1.117'),
	('C00216','5.3.1.3'),
	('C00216','1.1.1.116'),
	('C00217','1.4.3.15'),
	('C00217','3.5.1.38'),
	('C00217','3.5.1.35'),
	('C00217','3.5.1.82'),
	('C00217','3.5.1.2'),
	('C00217','1.4.3.7'),
	('C00217','5.1.1.3'),
	('C00217','6.3.2.9'),
	('C00217','2.6.1.74'),
	('C00217','4.2.1.48'),
	('C00217','2.6.1.54'),
	('C00217','2.6.1.21'),
	('C00218','1.4.3.21'),
	('C00218','1.5.3.21'),
	('C00218','1.4.9.1'),
	('C00218','1.5.8.1'),
	('C00218','6.3.4.12'),
	('C00218','4.2.1.88'),
	('C00218','3.5.3.16'),
	('C00218','3.5.1.36'),
	('C00218','3.5.1.39'),
	('C00218','2.1.1.247'),
	('C00218','2.1.1.248'),
	('C00218','2.1.1.249'),
	('C00218','2.1.1.21'),
	('C00218','1.21.4.3'),
	('C00218','1.4.1.17'),
	('C00218','1.4.3.24'),
	('C00218','1.4.3.4'),
	('C00218','1.4.3.19'),
	('C00219','1.14.15.3'),
	('C00219','1.14.14.1'),
	('C00219','1.14.99.1'),
	('C00219','1.13.11.40'),
	('C00219','1.13.11.31'),
	('C00219','3.1.1.4'),
	('C00219','1.13.11.34'),
	('C00219','6.2.1.15'),
	('C00219','3.5.1.99'),
	('C00219','3.1.2.2'),
	('C00219','1.13.11.33'),
	('C00221','1.1.3.5'),
	('C00221','1.1.1.47'),
	('C00221','1.1.3.4'),
	('C00221','4.3.3.5'),
	('C00221','5.1.3.3'),
	('C00221','3.2.1.85'),
	('C00221','2.3.1.213'),
	('C00221','3.2.1.23'),
	('C00221','3.2.1.21'),
	('C00221','2.7.1.2'),
	('C00221','2.7.1.147'),
	('C00221','2.7.1.1'),
	('C00221','2.7.1.63'),
	('C00221','3.1.6.3'),
	('C00222','1.7.3.5'),
	('C00222','2.6.1.55'),
	('C00222','1.2.1.15'),
	('C00222','1.2.1.18'),
	('C00222','1.2.1.75'),
	('C00222','1.1.1.298'),
	('C00222','1.1.1.59'),
	('C00222','4.2.1.27'),
	('C00222','4.2.1.155'),
	('C00222','4.1.2.29'),
	('C00222','2.6.1.18'),
	('C00222','2.6.1.19'),
	('C00222','1.2.1.27'),
	('C00223','2.3.1.249'),
	('C00223','2.3.1.64'),
	('C00223','2.3.1.95'),
	('C00223','2.3.1.74'),
	('C00223','2.3.1.153'),
	('C00223','2.3.1.133'),
	('C00223','1.2.1.44'),
	('C00223','1.14.13.11'),
	('C00223','6.2.1.12'),
	('C00223','2.3.1.211'),
	('C00223','2.3.1.212'),
	('C00223','2.3.1.215'),
	('C00223','2.3.1.218'),
	('C00223','2.3.1.219'),
	('C00223','2.3.1.170'),
	('C00223','2.3.1.173'),
	('C00223','2.3.1.229'),
	('C00224','1.8.4.10'),
	('C00224','1.8.4.9'),
	('C00224','1.8.99.2'),
	('C00224','3.6.2.1'),
	('C00224','2.7.1.25'),
	('C00224','2.7.7.4'),
	('C00224','2.7.7.5'),
	('C00224','2.7.7.51'),
	('C00224','2.7.7.53'),
	('C00224','3.1.3.7'),
	('C00226','1.14.15.3'),
	('C00226','1.2.1.84'),
	('C00226','1.1.99.20'),
	('C00226','1.1.3.13'),
	('C00226','3.8.1.5'),
	('C00226','1.1.1.2'),
	('C00226','1.1.2.7'),
	('C00226','1.1.1.71'),
	('C00226','1.1.9.1'),
	('C00226','1.1.1.1'),
	('C00227','2.3.1.32'),
	('C00227','2.3.1.8'),
	('C00227','2.3.3.15'),
	('C00227','1.2.3.3'),
	('C00227','1.21.4.2'),
	('C00227','1.21.4.3'),
	('C00227','2.7.2.15'),
	('C00227','3.6.1.7'),
	('C00227','4.1.2.22'),
	('C00227','4.1.2.9'),
	('C00227','2.7.2.1'),
	('C00227','2.7.2.12'),
	('C00227','1.21.4.4'),
	('C00229','2.3.1.51'),
	('C00229','2.3.1.241'),
	('C00229','2.3.1.242'),
	('C00229','2.3.1.243'),
	('C00229','2.3.1.38'),
	('C00229','2.3.1.39'),
	('C00229','2.3.1.221'),
	('C00229','2.3.1.235'),
	('C00229','2.3.2.19'),
	('C00229','2.3.1.86'),
	('C00229','2.3.1.85'),
	('C00229','2.3.1.15'),
	('C00229','2.3.1.129'),
	('C00229','2.3.1.141'),
	('C00229','2.3.1.238'),
	('C00229','1.2.1.80'),
	('C00229','6.2.1.35'),
	('C00229','6.2.1.39'),
	('C00229','6.2.1.20'),
	('C00229','3.1.2.31'),
	('C00229','3.1.2.14'),
	('C00229','3.1.2.21'),
	('C00229','3.1.4.14'),
	('C00229','2.7.7.61'),
	('C00229','2.7.7.66'),
	('C00229','2.7.8.7'),
	('C00229','2.3.1.184'),
	('C00229','2.3.1.191'),
	('C00229','2.3.1.199'),
	('C00229','2.3.1.179'),
	('C00229','2.3.1.181'),
	('C00229','2.3.1.161'),
	('C00229','2.3.1.40'),
	('C00229','2.3.1.41'),
	('C00229','2.3.1.47'),
	('C00230','1.3.1.53'),
	('C00230','1.14.13.23'),
	('C00230','1.14.13.33'),
	('C00230','1.14.13.2'),
	('C00230','1.13.11.8'),
	('C00230','1.13.11.3'),
	('C00230','1.14.12.8'),
	('C00230','1.14.13.82'),
	('C00230','4.1.1.55'),
	('C00230','4.1.1.63'),
	('C00230','4.1.1.69'),
	('C00230','4.2.1.118'),
	('C00230','1.14.13.64'),
	('C00231','2.2.1.3'),
	('C00231','2.2.1.1'),
	('C00231','1.1.1.301'),
	('C00231','2.7.1.17'),
	('C00231','5.1.3.4'),
	('C00231','4.1.2.9'),
	('C00231','5.1.3.1'),
	('C00232','1.5.3.21'),
	('C00232','1.14.13.163'),
	('C00232','1.2.1.24'),
	('C00232','1.2.1.16'),
	('C00232','1.2.1.76'),
	('C00232','1.2.1.79'),
	('C00232','2.6.1.96'),
	('C00232','1.1.1.61'),
	('C00232','4.1.1.71'),
	('C00232','4.1.2.52'),
	('C00232','3.5.1.29'),
	('C00232','2.6.1.19'),
	('C00233','1.2.7.7'),
	('C00233','1.2.4.4'),
	('C00233','1.4.1.9'),
	('C00233','2.6.1.67'),
	('C00233','1.1.1.85'),
	('C00233','2.6.1.42'),
	('C00233','2.6.1.6'),
	('C00233','1.2.1.25'),
	('C00234','2.1.2.13'),
	('C00234','2.1.2.2'),
	('C00234','2.1.2.3'),
	('C00234','2.1.2.9'),
	('C00234','3.5.1.10'),
	('C00234','6.3.4.3'),
	('C00234','6.3.2.12'),
	('C00234','6.3.2.17'),
	('C00234','3.5.4.9'),
	('C00234','1.5.1.6'),
	('C00235','1.17.7.4'),
	('C00235','2.5.1.75'),
	('C00235','5.3.3.2'),
	('C00235','2.5.1.80'),
	('C00235','2.5.1.1'),
	('C00235','2.5.1.100'),
	('C00235','2.5.1.106'),
	('C00235','2.5.1.107'),
	('C00235','2.5.1.109'),
	('C00235','2.5.1.110'),
	('C00235','2.5.1.111'),
	('C00235','2.5.1.112'),
	('C00235','2.5.1.27'),
	('C00235','2.5.1.28'),
	('C00235','2.5.1.34'),
	('C00235','2.5.1.35'),
	('C00235','2.5.1.36'),
	('C00235','2.5.1.121'),
	('C00235','2.5.1.122'),
	('C00235','2.5.1.92'),
	('C00235','2.5.1.67'),
	('C00235','2.5.1.69'),
	('C00235','2.5.1.70'),
	('C00235','2.5.1.71'),
	('C00235','4.2.3.27'),
	('C00236','1.2.1.59'),
	('C00236','1.2.1.12'),
	('C00236','1.2.1.13'),
	('C00236','5.4.2.4'),
	('C00236','3.6.1.7'),
	('C00236','2.7.4.17'),
	('C00236','2.7.2.10'),
	('C00236','2.7.2.3'),
	('C00236','2.7.1.106'),
	('C00237','2.1.1.258'),
	('C00237','4.1.99.17'),
	('C00237','4.1.99.5'),
	('C00237','1.13.11.24'),
	('C00237','1.13.11.53'),
	('C00237','1.13.11.48'),
	('C00237','1.13.11.47'),
	('C00237','1.14.99.48'),
	('C00237','1.14.14.18'),
	('C00237','1.2.7.4'),
	('C00237','2.3.1.169'),
	('C00237','1.2.2.4'),
	('C00237','1.2.5.3'),
	('C00239','3.6.1.12'),
	('C00239','3.6.1.65'),
	('C00239','3.5.4.12'),
	('C00239','2.7.1.74'),
	('C00239','2.1.1.54'),
	('C00239','2.7.4.14'),
	('C00239','2.1.2.8'),
	('C00239','3.1.3.89'),
	('C00239','3.1.3.5'),
	('C00239','2.7.4.25'),
	('C00240','2.1.1.171'),
	('C00240','2.1.1.172'),
	('C00240','2.1.1.173'),
	('C00240','2.1.1.187'),
	('C00240','2.1.1.188'),
	('C00240','2.1.1.174'),
	('C00241','3.5.1.20'),
	('C00241','3.5.1.1'),
	('C00241','3.5.1.6'),
	('C00241','3.5.1.29'),
	('C00241','3.5.1.3'),
	('C00241','3.5.1.30'),
	('C00241','3.5.1.35'),
	('C00241','3.5.1.38'),
	('C00241','3.5.1.4'),
	('C00241','3.5.3.5'),
	('C00241','3.5.3.6'),
	('C00241','3.5.3.9'),
	('C00241','3.5.3.12'),
	('C00241','3.5.3.13'),
	('C00241','3.5.1.2'),
	('C00241','3.5.1.19'),
	('C00241','3.5.1.12'),
	('C00241','3.5.1.5'),
	('C00241','3.5.1.44'),
	('C00241','3.5.1.43'),
	('C00241','3.5.1.42'),
	('C00242','2.4.2.15'),
	('C00242','2.4.2.7'),
	('C00242','2.4.2.8'),
	('C00242','2.4.2.4'),
	('C00242','2.4.2.1'),
	('C00242','2.4.2.22'),
	('C00242','3.2.2.8'),
	('C00242','3.5.4.3'),
	('C00242','3.2.2.1'),
	('C00242','2.4.2.29'),
	('C00243','3.2.1.108'),
	('C00243','3.2.1.23'),
	('C00243','3.2.1.140'),
	('C00243','2.7.1.207'),
	('C00243','2.4.1.22'),
	('C00243','1.1.99.13'),
	('C00244','1.7.5.1'),
	('C00244','1.14.12.17'),
	('C00244','1.7.1.3'),
	('C00244','1.7.6.1'),
	('C00244','1.7.1.1'),
	('C00244','1.9.6.1'),
	('C00244','1.7.99.4'),
	('C00244','1.7.1.2'),
	('C00244','1.7.7.2'),
	('C00245','2.6.1.55'),
	('C00245','2.6.1.77'),
	('C00245','2.3.1.65'),
	('C00245','2.3.2.2'),
	('C00245','2.1.4.1'),
	('C00245','3.5.1.24'),
	('C00245','4.1.1.15'),
	('C00245','4.1.1.29'),
	('C00245','1.5.1.23'),
	('C00245','1.4.99.2'),
	('C00245','1.14.11.17'),
	('C00245','3.5.1.74'),
	('C00245','1.8.1.3'),
	('C00246','2.8.3.9'),
	('C00246','3.1.1.51'),
	('C00246','2.8.3.8'),
	('C00246','2.7.2.7'),
	('C00246','3.6.1.20'),
	('C00246','3.7.1.7'),
	('C00246','6.2.1.2'),
	('C00246','1.3.1.31'),
	('C00247','1.1.99.21'),
	('C00247','1.1.1.14'),
	('C00247','1.1.1.123'),
	('C00247','1.1.1.289'),
	('C00247','1.1.3.11'),
	('C00247','1.1.99.12'),
	('C00247','1.1.99.32'),
	('C00247','2.7.1.206'),
	('C00248','1.8.1.4'),
	('C00249','2.3.1.85'),
	('C00249','6.2.1.3'),
	('C00249','1.11.1.3'),
	('C00249','3.1.2.14'),
	('C00249','3.1.2.2'),
	('C00249','3.1.1.63'),
	('C00249','1.2.1.48'),
	('C00249','3.1.2.22'),
	('C00250','1.2.3.1'),
	('C00250','1.2.3.8'),
	('C00250','1.4.3.5'),
	('C00250','1.1.3.12'),
	('C00250','1.1.1.107'),
	('C00250','2.7.1.35'),
	('C00250','3.1.3.74'),
	('C00250','2.6.1.31'),
	('C00250','2.6.1.54'),
	('C00250','2.6.1.30'),
	('C00250','1.1.1.65'),
	('C00251','4.2.1.151'),
	('C00251','4.2.3.5'),
	('C00251','5.4.99.5'),
	('C00251','5.4.4.2'),
	('C00251','2.6.1.86'),
	('C00251','4.1.3.40'),
	('C00251','4.1.3.45'),
	('C00251','3.3.2.13'),
	('C00251','2.6.1.85'),
	('C00251','4.1.3.27'),
	('C00252','3.2.1.11'),
	('C00252','3.2.1.10'),
	('C00253','1.17.1.5'),
	('C00253','1.17.2.1'),
	('C00253','6.3.4.21'),
	('C00253','3.2.2.3'),
	('C00253','3.5.1.19'),
	('C00253','2.1.1.7'),
	('C00253','2.4.2.1'),
	('C00253','2.4.99.20'),
	('C00253','2.4.2.55'),
	('C00253','2.4.1.196'),
	('C00253','2.4.2.21'),
	('C00254','1.3.1.13'),
	('C00254','1.3.1.12'),
	('C00254','4.2.1.51'),
	('C00254','4.2.1.91'),
	('C00254','2.6.1.79'),
	('C00254','4.1.1.100'),
	('C00254','2.6.1.57'),
	('C00254','2.6.1.78'),
	('C00254','5.4.99.5'),
	('C00255','1.5.1.30'),
	('C00255','1.5.1.41'),
	('C00255','3.5.99.1'),
	('C00255','2.5.1.9'),
	('C00255','2.7.1.42'),
	('C00255','2.7.1.161'),
	('C00255','2.7.1.26'),
	('C00255','3.1.3.2'),
	('C00256','1.2.1.23'),
	('C00256','1.1.99.6'),
	('C00256','1.1.1.28'),
	('C00256','1.1.2.4'),
	('C00256','1.1.2.5'),
	('C00256','3.1.6.17'),
	('C00256','6.1.2.1'),
	('C00256','4.2.1.126'),
	('C00256','4.2.1.130'),
	('C00256','3.1.2.6'),
	('C00256','5.1.2.1'),
	('C00257','1.1.99.3'),
	('C00257','1.1.1.215'),
	('C00257','1.1.1.69'),
	('C00257','2.4.1.321'),
	('C00257','4.2.1.39'),
	('C00257','3.1.1.17'),
	('C00257','2.7.1.12'),
	('C00257','4.2.1.140'),
	('C00258','1.2.99.8'),
	('C00258','1.2.1.3'),
	('C00258','1.2.1.89'),
	('C00258','1.1.1.29'),
	('C00258','1.1.1.26'),
	('C00258','1.1.1.81'),
	('C00258','1.1.1.92'),
	('C00258','1.1.1.60'),
	('C00258','1.1.1.79'),
	('C00258','4.1.1.73'),
	('C00258','3.1.3.38'),
	('C00258','3.1.3.20'),
	('C00258','3.2.1.170'),
	('C00258','2.7.1.165'),
	('C00258','2.7.1.31'),
	('C00258','2.4.1.268'),
	('C00258','2.4.1.269'),
	('C00258','1.2.7.5'),
	('C00259','1.1.1.21'),
	('C00259','1.1.1.46'),
	('C00259','1.1.1.376'),
	('C00259','2.7.1.46'),
	('C00259','3.2.1.88'),
	('C00259','3.2.1.55'),
	('C00259','5.3.1.4'),
	('C00261','1.2.1.28'),
	('C00261','1.2.1.7'),
	('C00261','4.1.1.7'),
	('C00261','4.1.2.10'),
	('C00261','4.1.2.38'),
	('C00261','4.1.2.26'),
	('C00261','1.1.1.90'),
	('C00262','1.17.3.2'),
	('C00262','2.4.2.44'),
	('C00262','3.2.2.1'),
	('C00262','2.4.2.4'),
	('C00262','2.4.2.8'),
	('C00262','2.4.2.15'),
	('C00262','2.4.2.1'),
	('C00262','3.2.2.12'),
	('C00262','3.2.2.2'),
	('C00262','3.2.2.26'),
	('C00262','3.5.4.2'),
	('C00262','3.2.2.8'),
	('C00262','1.17.1.4'),
	('C00263','3.3.1.2'),
	('C00263','2.7.1.39'),
	('C00263','2.3.1.46'),
	('C00263','2.3.1.31'),
	('C00263','1.1.1.3'),
	('C00264','1.1.1.211'),
	('C00264','1.1.1.36'),
	('C00264','1.1.1.35'),
	('C00264','2.8.3.5'),
	('C00264','2.3.1.199'),
	('C00264','2.3.1.16'),
	('C00265','1.17.4.4'),
	('C00265','1.17.4.5'),
	('C00266','4.1.2.25'),
	('C00266','4.1.2.19'),
	('C00266','4.1.2.18'),
	('C00266','1.1.1.77'),
	('C00266','4.1.1.40'),
	('C00266','1.13.11.81'),
	('C00266','1.2.1.21'),
	('C00266','4.1.2.28'),
	('C00266','1.4.3.8'),
	('C00267','5.1.3.3'),
	('C00267','5.3.1.5'),
	('C00267','1.1.1.21'),
	('C00267','3.2.1.26'),
	('C00267','2.4.1.231'),
	('C00267','2.7.1.63'),
	('C00267','2.7.1.1'),
	('C00267','2.7.1.147'),
	('C00267','2.7.1.2'),
	('C00267','3.2.1.20'),
	('C00267','3.2.1.33'),
	('C00267','3.2.1.3'),
	('C00267','3.2.1.23'),
	('C00267','3.2.1.58'),
	('C00267','3.1.6.3'),
	('C00267','3.2.1.108'),
	('C00267','3.2.1.10'),
	('C00267','3.1.3.10'),
	('C00267','3.2.1.48'),
	('C00267','3.1.3.9'),
	('C00268','1.14.16.6'),
	('C00268','1.14.16.5'),
	('C00268','1.5.1.34'),
	('C00268','4.2.1.96'),
	('C00268','1.14.16.1'),
	('C00268','1.14.16.2'),
	('C00268','1.14.16.4'),
	('C00268','1.14.16.3'),
	('C00269','2.7.8.41'),
	('C00269','2.7.8.11'),
	('C00269','2.7.8.5'),
	('C00269','2.7.8.8'),
	('C00269','3.6.1.26'),
	('C00269','2.7.8.24'),
	('C00269','2.7.7.41'),
	('C00270','4.1.3.3'),
	('C00270','2.5.1.56'),
	('C00270','1.14.18.2'),
	('C00270','2.3.1.44'),
	('C00270','2.7.7.43'),
	('C00270','3.1.1.53'),
	('C00270','2.3.1.45'),
	('C00270','3.2.1.18'),
	('C00270','3.1.3.29'),
	('C00272','1.1.1.153'),
	('C00272','1.14.16.7'),
	('C00272','1.14.16.1'),
	('C00272','1.14.16.2'),
	('C00272','1.5.1.34'),
	('C00272','1.14.16.4'),
	('C00272','1.14.16.3'),
	('C00272','1.5.1.33'),
	('C00272','1.14.16.5'),
	('C00272','1.14.16.6'),
	('C00273','1.1.3.11'),
	('C00273','1.1.99.12'),
	('C00273','1.1.99.11'),
	('C00273','1.1.1.124'),
	('C00273','1.1.1.123'),
	('C00275','2.7.1.7'),
	('C00275','2.7.1.191'),
	('C00275','2.7.1.61'),
	('C00275','2.7.1.1'),
	('C00275','3.2.1.170'),
	('C00275','5.4.2.8'),
	('C00275','5.3.1.8'),
	('C00275','1.1.1.224'),
	('C00279','2.2.1.2'),
	('C00279','1.13.11.79'),
	('C00279','2.5.1.54'),
	('C00279','4.1.2.22'),
	('C00279','4.1.2.13'),
	('C00279','5.3.1.34'),
	('C00279','2.2.1.1'),
	('C00279','1.2.1.72'),
	('C00280','5.3.3.1'),
	('C00280','1.14.99.12'),
	('C00280','1.3.1.22'),
	('C00280','1.3.99.4'),
	('C00280','1.3.99.5'),
	('C00280','1.14.13.54'),
	('C00280','1.14.15.4'),
	('C00280','1.14.14.32'),
	('C00280','1.14.14.14'),
	('C00280','1.1.1.64'),
	('C00280','1.1.1.51'),
	('C00280','1.1.1.239'),
	('C00280','1.1.1.145'),
	('C00280','1.14.14.1'),
	('C00280','1.3.1.3'),
	('C00282','1.12.98.1'),
	('C00282','1.12.7.2'),
	('C00282','1.12.5.1'),
	('C00282','1.12.2.1'),
	('C00282','1.12.1.5'),
	('C00282','1.12.1.4'),
	('C00282','1.12.1.3'),
	('C00282','1.12.1.2'),
	('C00282','1.12.99.6'),
	('C00282','1.12.98.4'),
	('C00282','1.19.6.1'),
	('C00282','1.12.98.2'),
	('C00282','1.12.98.3'),
	('C00282','1.18.6.1'),
	('C00283','2.8.1.5'),
	('C00283','4.4.1.10'),
	('C00283','2.5.1.65'),
	('C00283','2.5.1.73'),
	('C00283','2.5.1.47'),
	('C00283','2.5.1.48'),
	('C00283','2.5.1.49'),
	('C00283','1.8.3.4'),
	('C00283','1.8.1.18'),
	('C00283','1.8.1.19'),
	('C00283','1.8.1.2'),
	('C00283','1.8.5.4'),
	('C00283','1.8.7.1'),
	('C00283','1.8.98.3'),
	('C00283','1.8.99.5'),
	('C00283','1.8.2.3'),
	('C00283','2.1.1.251'),
	('C00283','2.3.1.10'),
	('C00283','4.4.1.1'),
	('C00283','4.4.1.9'),
	('C00283','4.4.1.8'),
	('C00283','4.4.1.28'),
	('C00283','4.4.1.27'),
	('C00283','4.4.1.2'),
	('C00283','4.4.1.15'),
	('C00283','4.2.1.22'),
	('C00283','1.13.11.55'),
	('C00283','1.12.98.4'),
	('C00283','2.8.1.3'),
	('C00286','1.17.4.2'),
	('C00286','3.1.5.1'),
	('C00286','2.7.1.40'),
	('C00286','2.7.1.48'),
	('C00286','2.7.4.6'),
	('C00286','2.7.7.7'),
	('C00286','2.6.99.1'),
	('C00288','1.13.11.73'),
	('C00288','2.5.1.120'),
	('C00288','6.3.4.18'),
	('C00288','6.3.4.6'),
	('C00288','6.3.5.5'),
	('C00288','6.4.1.1'),
	('C00288','6.4.1.2'),
	('C00288','6.4.1.3'),
	('C00288','6.4.1.4'),
	('C00288','6.4.1.5'),
	('C00288','6.4.1.7'),
	('C00288','6.4.1.8'),
	('C00288','4.1.1.93'),
	('C00288','4.2.1.1'),
	('C00288','4.2.1.104'),
	('C00288','2.7.7.87'),
	('C00288','6.3.4.14'),
	('C00292','3.5.1.13'),
	('C00292','2.8.2.3'),
	('C00292','2.4.1.71'),
	('C00292','1.7.1.6'),
	('C00292','6.3.1.18'),
	('C00292','2.3.1.5'),
	('C00292','4.1.1.24'),
	('C00294','3.2.2.8'),
	('C00294','3.1.3.99'),
	('C00294','3.1.3.5'),
	('C00294','1.1.3.28'),
	('C00294','3.5.4.4'),
	('C00294','3.2.2.2'),
	('C00294','3.2.2.1'),
	('C00294','2.4.2.15'),
	('C00294','2.4.2.1'),
	('C00294','2.7.1.73'),
	('C00295','1.3.98.1'),
	('C00295','1.3.1.14'),
	('C00295','2.4.2.10'),
	('C00295','1.3.5.2'),
	('C00295','1.3.1.15'),
	('C00296','2.3.1.99'),
	('C00296','2.3.1.98'),
	('C00296','3.1.1.42'),
	('C00296','1.1.1.24'),
	('C00296','1.1.1.282'),
	('C00296','1.1.5.8'),
	('C00296','2.3.1.133'),
	('C00299','3.1.3.5'),
	('C00299','3.1.3.6'),
	('C00299','1.14.11.3'),
	('C00299','3.5.4.5'),
	('C00299','2.7.1.48'),
	('C00299','2.4.2.2'),
	('C00299','3.2.2.3'),
	('C00299','2.4.2.3'),
	('C00300','3.9.1.1'),
	('C00300','2.7.3.2'),
	('C00300','3.5.2.10'),
	('C00300','2.1.1.2'),
	('C00300','3.5.3.3'),
	('C00301','3.6.1.21'),
	('C00301','3.6.1.13'),
	('C00301','3.6.1.53'),
	('C00301','3.2.2.24'),
	('C00301','3.2.2.19'),
	('C00301','3.2.2.6'),
	('C00301','3.2.2.5'),
	('C00301','2.7.7.35'),
	('C00302','3.5.5.1'),
	('C00302','2.6.1.1'),
	('C00305','6.6.1.1'),
	('C00307','2.7.7.15'),
	('C00307','3.6.1.53'),
	('C00307','2.7.8.22'),
	('C00307','2.7.8.10'),
	('C00307','2.7.8.2'),
	('C00307','2.7.8.3'),
	('C00309','1.1.1.56'),
	('C00309','1.1.1.250'),
	('C00309','1.1.1.287'),
	('C00309','2.7.1.47'),
	('C00309','2.7.1.16'),
	('C00309','1.1.2.2'),
	('C00309','5.3.1.20'),
	('C00309','5.3.1.3'),
	('C00310','1.1.1.9'),
	('C00310','5.3.1.15'),
	('C00310','5.3.1.5'),
	('C00310','1.1.1.287'),
	('C00310','1.1.1.11'),
	('C00310','1.1.1.14'),
	('C00310','2.7.1.17'),
	('C00311','4.1.3.1'),
	('C00311','4.2.1.3'),
	('C00311','2.3.1.126'),
	('C00311','1.1.1.286'),
	('C00311','1.1.1.41'),
	('C00311','1.1.1.42'),
	('C00312','2.7.1.5'),
	('C00312','2.7.1.53'),
	('C00312','1.1.1.10'),
	('C00312','1.1.1.15'),
	('C00312','4.1.1.34'),
	('C00312','1.1.1.12'),
	('C00313','2.3.1.58'),
	('C00313','1.2.1.17'),
	('C00313','4.1.1.8'),
	('C00313','2.8.3.2'),
	('C00313','2.8.3.19'),
	('C00313','2.8.3.16'),
	('C00313','6.2.1.8'),
	('C00314','1.1.99.9'),
	('C00314','1.1.1.65'),
	('C00314','1.1.3.12'),
	('C00314','1.4.3.5'),
	('C00314','2.4.1.160'),
	('C00314','2.7.1.35'),
	('C00314','3.1.3.74'),
	('C00315','1.5.3.13'),
	('C00315','6.3.1.9'),
	('C00315','3.5.1.78'),
	('C00315','3.5.3.24'),
	('C00315','1.5.99.6'),
	('C00315','4.1.1.96'),
	('C00315','6.3.1.8'),
	('C00315','2.5.1.16'),
	('C00315','2.5.1.22'),
	('C00315','2.5.1.128'),
	('C00315','2.5.1.79'),
	('C00315','2.5.1.44'),
	('C00315','2.5.1.45'),
	('C00315','2.5.1.46'),
	('C00315','1.5.3.17'),
	('C00315','1.5.3.16'),
	('C00315','2.3.1.248'),
	('C00315','2.3.1.249'),
	('C00315','3.5.1.48'),
	('C00315','1.5.3.14'),
	('C00318','2.3.1.137'),
	('C00318','3.1.1.28'),
	('C00318','2.3.1.21'),
	('C00318','3.5.1.73'),
	('C00318','2.8.3.21'),
	('C00319','2.3.1.24'),
	('C00319','2.7.1.91'),
	('C00319','3.5.1.23'),
	('C00319','3.1.3.4'),
	('C00319','2.7.8.10'),
	('C00319','2.4.1.23'),
	('C00320','2.5.1.47'),
	('C00320','1.8.2.2'),
	('C00320','3.12.1.1'),
	('C00320','2.8.1.1'),
	('C00320','2.5.1.49'),
	('C00320','2.8.1.3'),
	('C00320','2.8.1.5'),
	('C00320','1.8.5.2'),
	('C00320','2.8.1.2'),
	('C00322','1.8.1.4'),
	('C00322','1.1.1.172'),
	('C00322','1.1.1.286'),
	('C00322','2.3.1.61'),
	('C00322','1.1.1.87'),
	('C00322','2.6.1.39'),
	('C00322','1.2.4.2'),
	('C00323','2.3.1.133'),
	('C00323','2.3.1.138'),
	('C00323','2.3.1.140'),
	('C00323','2.8.3.23'),
	('C00323','1.2.1.44'),
	('C00323','6.2.1.12'),
	('C00323','2.1.1.104'),
	('C00323','2.3.1.153'),
	('C00323','2.3.1.74'),
	('C00323','2.3.1.99'),
	('C00323','2.3.1.215'),
	('C00323','2.3.1.126'),
	('C00325','2.4.1.152'),
	('C00325','2.4.1.69'),
	('C00325','2.7.7.30'),
	('C00325','1.1.1.271'),
	('C00325','2.4.1.65'),
	('C00325','2.4.1.308'),
	('C00326','2.3.1.96'),
	('C00327','3.5.3.6'),
	('C00327','3.5.3.18'),
	('C00327','3.5.1.20'),
	('C00327','3.5.1.16'),
	('C00327','6.3.4.5'),
	('C00327','1.14.13.165'),
	('C00327','1.14.13.39'),
	('C00327','2.1.3.3'),
	('C00328','2.6.1.7'),
	('C00328','2.6.1.63'),
	('C00328','3.7.1.3'),
	('C00328','1.14.13.9'),
	('C00328','3.5.1.9'),
	('C00329','2.7.1.8'),
	('C00329','3.2.1.165'),
	('C00329','2.7.1.1'),
	('C00329','3.10.1.1'),
	('C00329','2.3.1.3'),
	('C00329','3.5.1.33'),
	('C00330','3.1.3.89'),
	('C00330','2.4.2.4'),
	('C00330','2.4.2.1'),
	('C00330','3.1.5.1'),
	('C00330','3.1.3.5'),
	('C00330','2.7.1.113'),
	('C00331','1.4.3.2'),
	('C00331','2.1.1.47'),
	('C00331','1.14.13.168'),
	('C00331','1.2.7.8'),
	('C00331','1.4.1.19'),
	('C00331','2.6.1.27'),
	('C00331','2.6.1.28'),
	('C00331','2.6.1.99'),
	('C00331','1.1.1.110'),
	('C00331','4.1.1.74'),
	('C00331','4.1.1.43'),
	('C00332','1.1.1.35'),
	('C00332','6.2.1.16'),
	('C00332','2.8.3.5'),
	('C00332','2.8.3.8'),
	('C00332','2.8.3.9'),
	('C00332','3.1.2.11'),
	('C00332','2.3.1.194'),
	('C00332','2.3.1.9'),
	('C00332','2.3.3.10'),
	('C00332','1.1.1.157'),
	('C00332','1.1.1.36'),
	('C00333','5.3.1.12'),
	('C00333','1.1.1.203'),
	('C00333','2.7.1.44'),
	('C00333','3.2.1.15'),
	('C00333','3.2.1.67'),
	('C00333','1.1.1.365'),
	('C00334','1.2.1.3'),
	('C00334','3.5.3.7'),
	('C00334','3.5.1.63'),
	('C00334','1.2.1.19'),
	('C00334','3.5.1.94'),
	('C00334','1.5.3.19'),
	('C00334','6.3.2.11'),
	('C00334','2.6.1.96'),
	('C00334','4.1.1.15'),
	('C00334','2.6.1.19'),
	('C00334','2.1.4.1'),
	('C00334','3.4.13.18'),
	('C00334','3.4.13.20'),
	('C00337','1.3.1.14'),
	('C00337','3.5.2.3'),
	('C00337','1.3.98.1'),
	('C00337','1.3.1.15'),
	('C00337','1.3.5.2'),
	('C00338','2.4.1.58'),
	('C00338','2.4.1.56'),
	('C00338','2.4.1.73'),
	('C00338','2.4.1.44'),
	('C00338','3.2.1.144'),
	('C00339','1.2.1.84'),
	('C00339','2.5.1.26'),
	('C00339','1.1.1.192'),
	('C00339','3.1.1.50'),
	('C00339','2.3.1.75'),
	('C00339','1.1.3.20'),
	('C00340','1.14.15.3'),
	('C00340','1.15.1.2'),
	('C00340','1.18.1.4'),
	('C00340','1.18.1.3'),
	('C00340','1.18.1.1'),
	('C00341','4.2.3.122'),
	('C00341','5.5.1.8'),
	('C00341','5.5.1.22'),
	('C00341','4.2.3.10'),
	('C00341','4.2.3.105'),
	('C00341','4.2.3.106'),
	('C00341','4.2.3.107'),
	('C00341','4.2.3.108'),
	('C00341','4.2.3.109'),
	('C00341','2.5.1.68'),
	('C00341','4.2.3.110'),
	('C00341','4.2.3.111'),
	('C00341','4.2.3.112'),
	('C00341','4.2.3.113'),
	('C00341','4.2.3.114'),
	('C00341','4.2.3.115'),
	('C00341','4.2.3.116'),
	('C00341','4.2.3.117'),
	('C00341','4.2.3.119'),
	('C00341','4.2.3.15'),
	('C00341','4.2.3.16'),
	('C00341','3.1.7.11'),
	('C00341','3.1.7.3'),
	('C00341','2.5.1.1'),
	('C00341','2.5.1.10'),
	('C00341','2.5.1.102'),
	('C00341','2.5.1.123'),
	('C00341','2.5.1.124'),
	('C00341','2.5.1.125'),
	('C00341','2.5.1.84'),
	('C00341','2.5.1.93'),
	('C00341','4.2.3.121'),
	('C00341','4.2.3.120'),
	('C00341','4.2.3.26'),
	('C00341','4.2.3.25'),
	('C00341','4.2.3.20'),
	('C00341','2.1.1.255'),
	('C00341','4.2.3.11'),
	('C00342','1.21.4.4'),
	('C00342','1.8.4.10'),
	('C00342','1.8.4.11'),
	('C00342','1.8.4.12'),
	('C00342','1.8.4.13'),
	('C00342','1.8.4.14'),
	('C00342','1.8.4.8'),
	('C00342','1.8.1.9'),
	('C00342','1.8.7.2'),
	('C00342','1.17.4.1'),
	('C00342','1.17.4.2'),
	('C00342','1.20.4.4'),
	('C00342','1.21.4.2'),
	('C00342','1.21.4.3'),
	('C00342','1.11.1.20'),
	('C00342','2.5.1.47'),
	('C00342','2.5.1.49'),
	('C00343','1.20.4.4'),
	('C00343','1.21.4.3'),
	('C00343','2.5.1.49'),
	('C00343','1.21.4.4'),
	('C00343','1.8.4.10'),
	('C00343','1.8.4.11'),
	('C00343','1.8.4.12'),
	('C00343','1.8.4.13'),
	('C00343','1.8.4.14'),
	('C00343','1.8.4.8'),
	('C00343','1.8.1.9'),
	('C00343','1.11.1.20'),
	('C00343','1.8.7.2'),
	('C00343','2.5.1.47'),
	('C00343','1.17.4.1'),
	('C00343','1.17.4.2'),
	('C00343','1.21.4.2'),
	('C00344','2.3.2.11'),
	('C00344','2.3.2.3'),
	('C00344','3.1.4.3'),
	('C00344','3.1.3.27'),
	('C00344','2.7.8.20'),
	('C00344','2.7.8.41'),
	('C00345','1.1.1.44'),
	('C00345','1.1.1.43'),
	('C00345','3.1.1.31'),
	('C00345','1.1.1.343'),
	('C00345','2.7.1.12'),
	('C00345','4.2.1.12'),
	('C00345','1.1.1.351'),
	('C00346','2.7.1.82'),
	('C00346','2.7.7.14'),
	('C00346','3.1.3.75'),
	('C00346','3.1.4.3'),
	('C00346','2.1.1.103'),
	('C00346','4.1.2.27'),
	('C00346','3.1.4.13'),
	('C00346','4.2.3.2'),
	('C00347','1.2.1.48'),
	('C00347','3.5.1.60'),
	('C00347','3.5.1.55'),
	('C00347','6.2.1.3'),
	('C00347','3.1.1.50'),
	('C00347','1.1.1.192'),
	('C00349','1.2.1.27'),
	('C00349','2.6.1.40'),
	('C00349','1.1.1.31'),
	('C00350','3.1.4.4'),
	('C00350','2.3.1.23'),
	('C00350','2.3.1.40'),
	('C00350','3.1.4.3'),
	('C00350','2.1.1.17'),
	('C00350','3.1.1.4'),
	('C00350','3.1.1.32'),
	('C00350','4.1.1.65'),
	('C00350','2.7.8.29'),
	('C00350','2.7.8.42'),
	('C00350','2.7.8.1'),
	('C00352','2.3.1.4'),
	('C00352','2.6.1.16'),
	('C00352','2.7.1.8'),
	('C00352','2.7.1.1'),
	('C00352','3.5.1.25'),
	('C00352','3.5.99.6'),
	('C00352','5.4.2.10'),
	('C00353','4.2.3.17'),
	('C00353','4.2.3.8'),
	('C00353','5.5.1.16'),
	('C00353','5.5.1.12'),
	('C00353','5.5.1.13'),
	('C00353','5.5.1.14'),
	('C00353','5.5.1.15'),
	('C00353','4.2.1.133'),
	('C00353','4.2.3.144'),
	('C00353','4.2.3.146'),
	('C00353','4.2.3.148'),
	('C00353','4.2.3.149'),
	('C00353','4.2.3.41'),
	('C00353','4.2.3.43'),
	('C00353','4.2.3.150'),
	('C00353','4.2.3.151'),
	('C00353','3.1.7.10'),
	('C00353','3.1.7.5'),
	('C00353','2.5.1.29'),
	('C00353','2.5.1.32'),
	('C00353','2.5.1.116'),
	('C00353','2.5.1.85'),
	('C00353','2.5.1.89'),
	('C00353','2.5.1.99'),
	('C00353','2.5.1.41'),
	('C00353','2.5.1.42'),
	('C00353','2.5.1.81'),
	('C00353','2.5.1.82'),
	('C00353','1.3.1.83'),
	('C00354','3.1.3.11'),
	('C00354','2.7.1.146'),
	('C00354','2.2.1.11'),
	('C00354','2.7.1.11'),
	('C00354','2.7.1.90'),
	('C00354','4.1.2.13'),
	('C00355','4.3.1.22'),
	('C00355','1.13.12.15'),
	('C00355','1.14.18.1'),
	('C00355','1.14.16.2'),
	('C00355','1.13.11.30'),
	('C00355','1.10.3.1'),
	('C00355','1.13.11.29'),
	('C00355','2.6.1.49'),
	('C00355','4.1.1.28'),
	('C00355','4.1.1.25'),
	('C00356','4.1.3.4'),
	('C00356','2.3.3.10'),
	('C00356','1.1.1.88'),
	('C00356','1.1.1.34'),
	('C00356','4.2.1.18'),
	('C00356','2.8.3.13'),
	('C00356','3.1.2.5'),
	('C00357','2.3.1.4'),
	('C00357','2.7.1.193'),
	('C00357','2.7.1.59'),
	('C00357','3.5.1.25'),
	('C00357','4.2.1.126'),
	('C00357','5.4.2.3'),
	('C00357','5.1.3.9'),
	('C00360','3.1.3.5'),
	('C00360','3.1.3.89'),
	('C00360','2.7.4.3'),
	('C00360','2.7.4.11'),
	('C00360','2.7.1.76'),
	('C00361','1.17.4.1'),
	('C00361','2.7.1.40'),
	('C00361','2.7.4.8'),
	('C00361','2.7.4.12'),
	('C00361','2.7.4.6'),
	('C00361','2.7.1.48'),
	('C00362','3.1.3.5'),
	('C00362','2.7.4.8'),
	('C00362','2.7.1.113'),
	('C00362','2.7.4.12'),
	('C00362','3.1.3.89'),
	('C00363','2.4.1.322'),
	('C00363','2.4.1.278'),
	('C00363','2.4.1.326'),
	('C00363','2.4.1.327'),
	('C00363','3.6.1.39'),
	('C00363','3.6.1.5'),
	('C00363','2.7.1.48'),
	('C00363','2.7.4.12'),
	('C00363','2.7.4.6'),
	('C00363','2.7.4.9'),
	('C00363','2.4.1.328'),
	('C00363','2.4.1.331'),
	('C00363','2.4.1.302'),
	('C00363','2.4.1.311'),
	('C00363','2.4.1.316'),
	('C00363','2.4.1.317'),
	('C00363','2.4.1.318'),
	('C00363','2.4.2.27'),
	('C00363','2.4.1.289'),
	('C00363','2.4.1.277'),
	('C00363','2.4.1.325'),
	('C00364','2.1.1.148'),
	('C00364','2.1.1.45'),
	('C00364','3.6.1.9'),
	('C00364','3.6.1.5'),
	('C00364','3.1.3.35'),
	('C00364','2.7.4.9'),
	('C00364','3.1.3.89'),
	('C00364','2.7.1.114'),
	('C00364','2.7.1.118'),
	('C00364','2.7.1.21'),
	('C00364','2.7.4.12'),
	('C00364','3.1.3.5'),
	('C00365','2.1.1.148'),
	('C00365','2.1.1.45'),
	('C00365','3.6.1.23'),
	('C00365','3.5.4.30'),
	('C00365','2.7.4.9'),
	('C00365','3.1.3.5'),
	('C00365','3.1.3.89'),
	('C00365','2.7.1.21'),
	('C00365','2.7.4.4'),
	('C00365','3.5.4.12'),
	('C00366','1.7.3.3'),
	('C00366','1.14.13.113'),
	('C00366','1.14.11.48'),
	('C00366','2.4.2.16'),
	('C00366','1.17.1.4'),
	('C00366','3.5.4.32'),
	('C00366','1.17.3.2'),
	('C00369','2.4.1.19'),
	('C00369','3.2.1.1'),
	('C00369','3.2.1.68'),
	('C00369','3.2.1.3'),
	('C00369','3.2.1.33'),
	('C00369','3.2.1.2'),
	('C00369','3.2.1.133'),
	('C00369','2.4.1.1'),
	('C00369','2.4.1.18'),
	('C00370','2.4.1.173'),
	('C00370','2.3.1.73'),
	('C00370','2.3.1.43'),
	('C00370','3.1.1.13'),
	('C00371','2.4.2.40'),
	('C00371','2.5.1.50'),
	('C00371','2.4.1.203'),
	('C00371','1.3.1.69'),
	('C00372','3.2.1.11'),
	('C00372','2.4.1.5'),
	('C00372','2.4.1.2'),
	('C00372','2.4.1.125'),
	('C00375','1.4.3.21'),
	('C00376','1.2.3.1'),
	('C00376','1.2.1.36'),
	('C00376','1.1.1.105'),
	('C00376','1.13.11.75'),
	('C00376','1.13.11.63'),
	('C00376','1.1.1.1'),
	('C00376','1.1.1.300'),
	('C00377','1.14.14.19'),
	('C00377','1.14.15.4'),
	('C00377','1.14.14.16'),
	('C00378','3.5.99.2'),
	('C00378','1.1.3.23'),
	('C00378','3.1.3.1'),
	('C00378','2.7.6.2'),
	('C00378','3.1.3.2'),
	('C00378','3.1.3.100'),
	('C00378','2.7.1.89'),
	('C00378','2.5.1.2'),
	('C00379','1.1.1.14'),
	('C00379','1.1.1.15'),
	('C00379','1.1.1.21'),
	('C00379','1.1.1.307'),
	('C00379','2.7.1.122'),
	('C00379','1.1.3.41'),
	('C00379','1.1.1.9'),
	('C00379','1.1.1.10'),
	('C00380','3.2.2.8'),
	('C00380','2.4.2.57'),
	('C00380','3.2.2.10'),
	('C00380','3.5.4.1'),
	('C00380','2.4.2.2'),
	('C00381','2.3.1.83'),
	('C00381','2.7.1.108'),
	('C00381','3.1.3.51'),
	('C00381','2.3.1.123'),
	('C00383','2.8.3.3'),
	('C00383','1.2.1.15'),
	('C00383','4.1.1.89'),
	('C00383','4.1.1.88'),
	('C00383','3.5.1.95'),
	('C00383','2.3.1.187'),
	('C00385','3.5.4.3'),
	('C00385','3.2.2.1'),
	('C00385','2.4.2.22'),
	('C00385','1.17.1.4'),
	('C00385','1.17.3.2'),
	('C00385','1.14.13.179'),
	('C00385','1.14.13.178'),
	('C00385','1.14.11.48'),
	('C00385','1.14.13.128'),
	('C00385','2.4.2.8'),
	('C00385','2.4.2.1'),
	('C00386','6.3.2.11'),
	('C00386','3.4.13.20'),
	('C00386','3.4.13.18'),
	('C00386','2.1.1.22'),
	('C00387','3.2.2.8'),
	('C00387','2.7.1.73'),
	('C00387','3.2.2.1'),
	('C00387','3.5.4.15'),
	('C00387','3.1.3.5'),
	('C00387','2.4.2.1'),
	('C00387','2.4.2.15'),
	('C00387','3.1.3.6'),
	('C00388','1.4.3.22'),
	('C00388','6.3.2.18'),
	('C00388','4.1.1.28'),
	('C00388','4.1.1.22'),
	('C00388','2.1.1.8'),
	('C00389','1.14.11.23'),
	('C00389','2.1.1.76'),
	('C00389','1.14.13.88'),
	('C00389','2.8.2.25'),
	('C00389','1.13.11.24'),
	('C00389','2.4.1.237'),
	('C00389','1.14.13.21'),
	('C00389','3.2.1.66'),
	('C00389','2.4.1.91'),
	('C00390','1.6.5.3'),
	('C00390','1.10.3.10'),
	('C00390','1.6.5.9'),
	('C00390','1.5.5.1'),
	('C00390','1.7.99.4'),
	('C00390','1.14.99.39'),
	('C00390','1.17.5.2'),
	('C00390','1.2.5.1'),
	('C00390','1.10.3.11'),
	('C00390','1.10.3.14'),
	('C00390','1.1.5.2'),
	('C00390','1.1.5.3'),
	('C00390','1.1.5.5'),
	('C00390','1.10.2.2'),
	('C00390','1.6.5.8'),
	('C00392','1.1.1.138'),
	('C00392','1.1.1.11'),
	('C00392','1.1.1.255'),
	('C00392','1.1.3.40'),
	('C00392','1.1.2.2'),
	('C00392','1.1.1.67'),
	('C00392','2.7.1.197'),
	('C00392','3.1.3.22'),
	('C00394','3.2.1.42'),
	('C00394','2.7.7.78'),
	('C00394','2.4.1.29'),
	('C00394','2.7.7.34'),
	('C00394','2.4.1.36'),
	('C00395','2.3.1.164'),
	('C00395','3.5.2.6'),
	('C00395','3.5.1.11'),
	('C00396','2.4.2.2'),
	('C00396','3.2.2.8'),
	('C00396','3.2.2.10'),
	('C00397','6.1.2.2'),
	('C00398','4.3.3.2'),
	('C00398','1.4.3.22'),
	('C00398','1.4.3.4'),
	('C00398','2.1.1.49'),
	('C00398','4.1.1.28'),
	('C00399','2.1.1.64'),
	('C00399','1.7.99.4'),
	('C00399','1.5.5.1'),
	('C00399','1.6.5.9'),
	('C00399','1.6.5.8'),
	('C00399','1.6.5.3'),
	('C00399','1.2.5.1'),
	('C00399','1.17.5.2'),
	('C00399','1.14.99.39'),
	('C00399','1.10.3.10'),
	('C00399','1.10.2.2'),
	('C00399','1.1.5.5'),
	('C00399','1.1.5.3'),
	('C00399','1.1.5.2'),
	('C00399','1.10.3.11'),
	('C00399','1.10.3.14'),
	('C00400','1.1.1.207'),
	('C00400','2.3.1.69'),
	('C00400','2.4.1.127'),
	('C00400','1.14.13.46'),
	('C00401','2.8.2.5'),
	('C00401','5.1.3.19'),
	('C00401','2.8.2.17'),
	('C00402','6.3.1.12'),
	('C00402','5.1.1.13'),
	('C00402','1.4.3.15'),
	('C00402','1.4.3.1'),
	('C00402','2.6.1.21'),
	('C00402','3.5.1.83'),
	('C00403','2.4.1.41'),
	('C00404','2.7.4.1'),
	('C00404','3.6.1.11'),
	('C00404','2.7.4.20'),
	('C00404','2.7.1.63'),
	('C00404','3.6.1.10'),
	('C00404','2.7.4.17'),
	('C00405','5.1.1.10'),
	('C00405','3.5.1.77'),
	('C00405','2.6.1.21'),
	('C00405','1.4.3.3'),
	('C00405','1.4.5.1'),
	('C00405','1.4.99.6'),
	('C00405','2.3.1.36'),
	('C00405','3.5.1.81'),
	('C00406','2.3.1.64'),
	('C00406','2.1.1.104'),
	('C00406','1.2.1.44'),
	('C00406','6.2.1.12'),
	('C00406','4.2.1.101'),
	('C00406','2.3.1.74'),
	('C00406','2.3.1.99'),
	('C00406','6.2.1.34'),
	('C00406','2.3.1.110'),
	('C00406','2.3.1.217'),
	('C00406','2.3.1.130'),
	('C00406','2.3.1.188'),
	('C00406','2.3.1.218'),
	('C00407','1.14.13.118'),
	('C00407','2.6.1.42'),
	('C00407','2.6.1.32'),
	('C00407','6.1.1.5'),
	('C00407','1.14.13.117'),
	('C00407','6.3.2.47'),
	('C00407','1.4.3.2'),
	('C00407','1.14.11.45'),
	('C00407','1.4.1.9'),
	('C00407','5.1.1.21'),
	('C00408','1.5.1.21'),
	('C00408','1.5.1.1'),
	('C00408','1.5.99.3'),
	('C00408','1.5.3.7'),
	('C00408','3.5.1.101'),
	('C00408','4.3.1.28'),
	('C00409','1.14.13.131'),
	('C00409','2.1.1.251'),
	('C00409','4.2.1.155'),
	('C00409','2.5.1.49'),
	('C00409','1.8.3.4'),
	('C00409','4.4.1.11'),
	('C00410','1.3.99.6'),
	('C00410','1.1.1.145'),
	('C00410','1.14.15.8'),
	('C00410','1.14.99.14'),
	('C00410','1.14.14.19'),
	('C00410','1.14.99.4'),
	('C00410','1.1.1.149'),
	('C00410','1.14.14.16'),
	('C00410','5.3.3.1'),
	('C00410','1.14.13.54'),
	('C00410','1.3.1.3'),
	('C00410','1.3.1.22'),
	('C00410','1.14.15.4'),
	('C00411','6.2.1.12'),
	('C00411','2.3.1.248'),
	('C00411','2.3.1.132'),
	('C00411','2.3.1.106'),
	('C00411','2.3.1.131'),
	('C00411','2.1.1.104'),
	('C00411','1.2.1.44'),
	('C00412','1.3.1.93'),
	('C00412','1.14.19.1'),
	('C00412','3.1.2.2'),
	('C00412','1.3.1.38'),
	('C00413','2.7.1.72'),
	('C00413','2.7.7.47'),
	('C00413','3.1.3.39'),
	('C00413','2.7.1.87'),
	('C00414','1.3.99.14'),
	('C00414','1.1.1.163'),
	('C00414','4.1.3.35'),
	('C00414','1.4.3.12'),
	('C00414','1.1.1.245'),
	('C00414','1.14.13.22'),
	('C00415','2.1.1.45'),
	('C00415','1.5.1.3'),
	('C00415','6.3.2.17'),
	('C00415','6.3.2.12'),
	('C00415','6.3.4.17'),
	('C00415','2.1.1.54'),
	('C00416','2.3.1.52'),
	('C00416','2.3.1.51'),
	('C00416','2.7.7.41'),
	('C00416','3.6.1.26'),
	('C00416','3.1.4.4'),
	('C00416','3.1.3.4'),
	('C00416','2.7.1.174'),
	('C00416','3.1.3.81'),
	('C00416','3.1.4.50'),
	('C00416','2.7.1.107'),
	('C00417','5.3.3.7'),
	('C00417','4.1.1.6'),
	('C00417','4.2.1.3'),
	('C00418','1.1.1.33'),
	('C00418','1.1.1.34'),
	('C00418','1.1.1.88'),
	('C00418','2.7.1.36'),
	('C00418','1.1.1.32'),
	('C00418','2.7.1.185'),
	('C00419','3.1.3.32'),
	('C00419','3.1.3.33'),
	('C00420','3.1.1.73'),
	('C00422','3.1.1.3'),
	('C00422','3.1.1.34'),
	('C00422','3.1.1.79'),
	('C00422','2.3.1.20'),
	('C00422','2.3.1.158'),
	('C00422','2.3.1.77'),
	('C00423','4.1.1.102'),
	('C00423','4.3.1.25'),
	('C00423','4.3.1.24'),
	('C00423','6.2.1.12'),
	('C00423','1.14.12.19'),
	('C00423','1.14.13.14'),
	('C00423','1.14.13.11'),
	('C00423','1.3.1.31'),
	('C00423','2.4.1.177'),
	('C00423','2.8.3.17'),
	('C00424','1.1.1.6'),
	('C00424','1.1.1.55'),
	('C00424','1.1.1.283'),
	('C00424','1.1.1.77'),
	('C00424','1.2.1.49'),
	('C00424','1.2.1.22'),
	('C00424','4.1.2.19'),
	('C00424','4.1.2.17'),
	('C00424','4.1.2.53'),
	('C00427','1.14.99.1'),
	('C00427','5.3.99.2'),
	('C00427','5.3.99.3'),
	('C00427','1.11.1.20'),
	('C00427','5.3.99.4'),
	('C00427','5.3.99.5'),
	('C00429','3.5.2.2'),
	('C00429','1.3.3.7'),
	('C00429','1.3.1.1'),
	('C00429','2.4.2.20'),
	('C00429','1.3.1.2'),
	('C00430','5.4.3.8'),
	('C00430','4.2.1.24'),
	('C00430','2.3.1.37'),
	('C00430','2.6.1.43'),
	('C00431','3.5.1.63'),
	('C00431','1.21.4.1'),
	('C00431','1.4.1.12'),
	('C00431','2.6.1.48'),
	('C00431','3.5.1.30'),
	('C00433','3.5.4.22'),
	('C00433','4.2.1.43'),
	('C00433','4.2.1.41'),
	('C00433','4.2.1.141'),
	('C00433','1.2.1.3'),
	('C00433','1.2.1.26'),
	('C00435','1.18.1.3'),
	('C00435','1.18.1.4'),
	('C00435','1.15.1.2'),
	('C00435','1.18.1.1'),
	('C00435','1.14.15.3'),
	('C00436','2.1.3.6'),
	('C00436','3.5.3.12'),
	('C00436','3.5.1.53'),
	('C00437','3.5.1.16'),
	('C00437','2.1.3.9'),
	('C00437','2.6.1.11'),
	('C00437','2.3.1.35'),
	('C00437','3.5.1.14'),
	('C00438','3.5.1.7'),
	('C00438','3.5.2.3'),
	('C00438','3.5.2.4'),
	('C00438','2.1.3.2'),
	('C00439','2.1.2.5'),
	('C00439','3.5.3.13'),
	('C00439','3.5.2.7'),
	('C00439','3.5.3.8'),
	('C00440','2.3.1.169'),
	('C00440','1.5.7.1'),
	('C00440','2.1.1.13'),
	('C00440','2.1.1.258'),
	('C00440','2.1.1.269'),
	('C00440','2.1.1.19'),
	('C00440','1.5.1.20'),
	('C00441','2.2.1.10'),
	('C00441','1.2.1.11'),
	('C00441','4.1.2.56'),
	('C00441','1.1.1.3'),
	('C00441','4.3.3.7'),
	('C00441','1.5.1.43'),
	('C00441','2.6.1.46'),
	('C00441','2.6.1.76'),
	('C00445','3.5.4.9'),
	('C00445','4.3.1.4'),
	('C00445','6.3.3.2'),
	('C00445','1.5.1.15'),
	('C00445','2.1.2.2'),
	('C00445','2.1.2.10'),
	('C00445','1.5.1.5'),
	('C00446','2.4.1.211'),
	('C00446','2.7.7.32'),
	('C00446','2.4.1.247'),
	('C00446','2.7.7.12'),
	('C00446','2.7.7.64'),
	('C00446','2.7.7.10'),
	('C00446','2.7.1.6'),
	('C00446','3.1.3.94'),
	('C00447','3.1.3.11'),
	('C00447','2.7.1.11'),
	('C00447','3.1.3.37'),
	('C00447','4.1.2.13'),
	('C00448','4.2.3.78'),
	('C00448','4.2.3.79'),
	('C00448','4.2.3.80'),
	('C00448','4.2.3.81'),
	('C00448','4.2.3.82'),
	('C00448','4.2.3.101'),
	('C00448','4.2.3.102'),
	('C00448','4.2.3.104'),
	('C00448','4.2.3.83'),
	('C00448','4.2.3.84'),
	('C00448','4.2.3.85'),
	('C00448','4.2.3.86'),
	('C00448','4.2.3.87'),
	('C00448','4.2.3.88'),
	('C00448','4.2.3.89'),
	('C00448','4.2.3.9'),
	('C00448','4.2.3.90'),
	('C00448','4.2.3.91'),
	('C00448','4.2.3.92'),
	('C00448','4.2.3.93'),
	('C00448','4.2.3.94'),
	('C00448','4.2.3.95'),
	('C00448','4.2.3.96'),
	('C00448','4.2.3.97'),
	('C00448','4.2.3.39'),
	('C00448','4.2.3.40'),
	('C00448','4.2.3.46'),
	('C00448','4.2.3.47'),
	('C00448','4.2.3.48'),
	('C00448','4.2.3.49'),
	('C00448','4.2.3.55'),
	('C00448','4.2.3.56'),
	('C00448','4.2.3.57'),
	('C00448','4.2.3.58'),
	('C00448','4.2.3.59'),
	('C00448','4.2.3.6'),
	('C00448','4.2.3.60'),
	('C00448','4.2.3.61'),
	('C00448','4.2.3.63'),
	('C00448','4.2.3.64'),
	('C00448','4.2.3.65'),
	('C00448','4.2.3.66'),
	('C00448','4.2.3.67'),
	('C00448','4.2.3.68'),
	('C00448','4.2.3.21'),
	('C00448','4.2.3.22'),
	('C00448','4.2.3.23'),
	('C00448','4.2.3.24'),
	('C00448','4.2.3.37'),
	('C00448','4.2.3.38'),
	('C00448','4.2.3.123'),
	('C00448','4.2.3.98'),
	('C00448','4.2.3.69'),
	('C00448','4.2.3.7'),
	('C00448','4.2.3.70'),
	('C00448','4.2.3.71'),
	('C00448','4.2.3.72'),
	('C00448','4.2.3.73'),
	('C00448','4.2.3.74'),
	('C00448','4.2.3.75'),
	('C00448','4.2.3.76'),
	('C00448','4.2.3.77'),
	('C00448','4.1.99.16'),
	('C00448','4.2.3.125'),
	('C00448','4.2.3.126'),
	('C00448','4.2.3.127'),
	('C00448','4.2.3.128'),
	('C00448','4.2.3.129'),
	('C00448','4.2.3.13'),
	('C00448','4.2.3.133'),
	('C00448','4.2.3.135'),
	('C00448','4.2.3.136'),
	('C00448','4.2.3.137'),
	('C00448','4.2.3.138'),
	('C00448','4.2.3.139'),
	('C00448','4.2.3.143'),
	('C00448','4.2.3.100'),
	('C00448','3.1.7.1'),
	('C00448','3.1.7.6'),
	('C00448','3.1.7.7'),
	('C00448','2.7.4.18'),
	('C00448','2.5.1.10'),
	('C00448','2.5.1.103'),
	('C00448','2.5.1.21'),
	('C00448','2.5.1.29'),
	('C00448','2.5.1.30'),
	('C00448','2.5.1.31'),
	('C00448','2.5.1.83'),
	('C00448','2.5.1.87'),
	('C00448','2.5.1.90'),
	('C00448','2.5.1.91'),
	('C00448','2.5.1.96'),
	('C00448','2.5.1.58'),
	('C00449','1.5.1.7'),
	('C00449','1.5.1.8'),
	('C00449','1.5.1.10'),
	('C00449','1.5.3.18'),
	('C00449','1.5.1.9'),
	('C00450','1.5.99.3'),
	('C00450','1.2.1.31'),
	('C00450','1.4.1.18'),
	('C00450','1.5.3.7'),
	('C00451','5.1.2.6'),
	('C00454','3.6.1.5'),
	('C00454','2.7.4.4'),
	('C00454','2.7.1.40'),
	('C00454','2.7.4.10'),
	('C00454','2.7.7.56'),
	('C00454','2.7.1.74'),
	('C00454','2.7.7.37'),
	('C00454','2.4.1.245'),
	('C00454','2.4.1.242'),
	('C00454','3.6.1.6'),
	('C00454','2.4.1.266'),
	('C00454','3.6.1.15'),
	('C00454','2.4.1.13'),
	('C00454','2.7.7.8'),
	('C00454','2.7.4.6'),
	('C00455','2.7.7.18'),
	('C00455','2.7.1.22'),
	('C00455','3.5.1.42'),
	('C00455','3.2.2.14'),
	('C00455','3.1.3.5'),
	('C00455','3.6.1.9'),
	('C00455','3.6.1.22'),
	('C00455','6.5.1.6'),
	('C00455','6.5.1.2'),
	('C00455','2.4.2.12'),
	('C00455','2.7.7.1'),
	('C00458','2.7.1.48'),
	('C00458','2.7.4.6'),
	('C00458','2.7.7.7'),
	('C00458','3.5.4.30'),
	('C00458','3.5.4.13'),
	('C00458','3.6.1.65'),
	('C00458','3.6.1.12'),
	('C00458','1.17.4.2'),
	('C00459','2.7.7.24'),
	('C00459','3.6.1.5'),
	('C00459','3.6.1.9'),
	('C00459','2.7.1.48'),
	('C00459','2.7.7.7'),
	('C00459','3.6.1.39'),
	('C00459','2.7.4.6'),
	('C00459','2.7.7.32'),
	('C00460','1.17.4.2'),
	('C00460','2.7.4.6'),
	('C00460','2.7.1.48'),
	('C00460','3.5.4.13'),
	('C00460','3.6.1.23'),
	('C00460','3.6.1.39'),
	('C00461','3.2.1.14'),
	('C00461','2.4.1.16'),
	('C00461','3.5.1.41'),
	('C00462','3.8.1.3'),
	('C00462','3.8.1.5'),
	('C00462','3.8.1.9'),
	('C00462','3.8.1.10'),
	('C00462','3.8.1.11'),
	('C00462','3.8.1.2'),
	('C00462','2.5.1.18'),
	('C00463','4.2.1.122'),
	('C00463','1.14.13.137'),
	('C00463','4.1.1.92'),
	('C00463','4.1.99.1'),
	('C00463','1.13.11.17'),
	('C00463','4.2.1.20'),
	('C00463','4.1.2.8'),
	('C00464','3.2.1.137'),
	('C00464','3.2.1.77'),
	('C00466','2.3.1.190'),
	('C00466','2.2.1.4'),
	('C00468','2.4.1.17'),
	('C00468','1.14.14.1'),
	('C00468','2.8.2.4'),
	('C00468','3.1.6.1'),
	('C00468','2.8.2.15'),
	('C00468','1.14.14.14'),
	('C00468','1.1.1.62'),
	('C00468','1.1.1.51'),
	('C00468','1.1.1.148'),
	('C00469','1.1.2.7'),
	('C00469','1.1.2.8'),
	('C00469','3.5.1.75'),
	('C00469','1.1.1.71'),
	('C00469','1.1.5.5'),
	('C00469','2.3.1.152'),
	('C00469','1.1.1.2'),
	('C00469','2.8.1.2'),
	('C00469','1.1.1.1'),
	('C00469','3.1.1.67'),
	('C00469','1.1.99.36'),
	('C00470','2.4.1.43'),
	('C00470','4.2.2.2'),
	('C00470','3.1.1.11'),
	('C00470','3.2.1.67'),
	('C00470','3.2.1.15'),
	('C00470','4.2.2.9'),
	('C00472','1.6.5.6'),
	('C00472','1.17.5.1'),
	('C00472','1.14.18.1'),
	('C00472','1.14.13.167'),
	('C00473','2.3.1.76'),
	('C00473','2.3.1.135'),
	('C00473','1.1.1.105'),
	('C00473','1.1.1.300'),
	('C00473','1.3.99.23'),
	('C00473','1.1.1.1'),
	('C00474','3.5.99.1'),
	('C00474','1.1.2.2'),
	('C00474','1.1.1.56'),
	('C00475','2.4.2.2'),
	('C00475','3.1.3.6'),
	('C00475','3.5.4.5'),
	('C00475','2.7.1.48'),
	('C00475','3.1.3.5'),
	('C00475','3.1.3.91'),
	('C00475','3.2.2.8'),
	('C00476','5.3.1.15'),
	('C00477','1.14.99.22'),
	('C00477','2.3.1.139'),
	('C00477','1.1.3.16'),
	('C00479','1.1.1.202'),
	('C00479','4.1.2.35'),
	('C00479','1.2.1.87'),
	('C00479','4.2.1.28'),
	('C00479','4.1.3.43'),
	('C00481','2.5.1.51'),
	('C00481','4.2.1.50'),
	('C00482','6.2.1.12'),
	('C00482','2.4.1.299'),
	('C00482','2.4.1.126'),
	('C00482','2.4.1.120'),
	('C00482','3.1.1.49'),
	('C00482','2.1.1.68'),
	('C00482','1.2.1.68'),
	('C00483','2.3.1.110'),
	('C00483','2.1.1.27'),
	('C00483','1.14.18.1'),
	('C00483','6.3.4.24'),
	('C00483','1.4.3.4'),
	('C00483','4.1.1.28'),
	('C00483','4.1.1.25'),
	('C00483','1.4.3.21'),
	('C00483','1.4.9.2'),
	('C00486','2.4.1.17'),
	('C00486','2.4.1.95'),
	('C00486','1.3.3.5'),
	('C00486','1.3.1.24'),
	('C00487','1.14.11.1'),
	('C00487','2.3.1.7'),
	('C00487','1.1.1.108'),
	('C00487','4.1.1.42'),
	('C00488','3.5.3.8'),
	('C00488','4.2.1.66'),
	('C00488','3.5.1.49'),
	('C00489','3.5.1.93'),
	('C00489','6.2.1.6'),
	('C00489','1.2.1.20'),
	('C00490','6.2.1.5'),
	('C00490','6.2.1.4'),
	('C00490','4.1.1.6'),
	('C00491','4.4.1.8'),
	('C00491','1.8.4.4'),
	('C00491','4.4.1.1'),
	('C00491','1.8.4.3'),
	('C00491','1.8.1.6'),
	('C00492','3.2.1.22'),
	('C00492','3.2.1.26'),
	('C00492','2.4.1.166'),
	('C00492','2.4.1.82'),
	('C00492','2.4.1.67'),
	('C00493','2.3.1.133'),
	('C00493','1.1.1.25'),
	('C00493','1.1.5.8'),
	('C00493','2.7.1.71'),
	('C00493','1.1.1.282'),
	('C00495','1.21.3.5'),
	('C00495','1.21.3.4'),
	('C00496','3.4.19.12'),
	('C00497','1.1.1.83'),
	('C00497','4.2.1.31'),
	('C00497','2.8.3.20'),
	('C00498','3.6.1.21'),
	('C00498','2.4.1.213'),
	('C00498','2.4.1.21'),
	('C00498','2.4.1.245'),
	('C00498','2.4.1.242'),
	('C00498','2.4.1.268'),
	('C00498','2.4.1.113'),
	('C00498','2.4.1.13'),
	('C00498','2.7.7.27'),
	('C00498','2.7.7.36'),
	('C00499','3.5.3.9'),
	('C00499','3.5.2.5'),
	('C00499','3.5.3.4'),
	('C00500','1.3.7.2'),
	('C00500','1.3.7.6'),
	('C00500','1.3.7.4'),
	('C00500','1.3.7.5'),
	('C00500','1.3.1.24'),
	('C00500','1.3.3.5'),
	('C00500','1.14.14.18'),
	('C00501','2.7.7.33'),
	('C00501','4.2.1.45'),
	('C00502','4.2.1.82'),
	('C00502','3.1.1.68'),
	('C00503','1.1.1.162'),
	('C00503','2.7.1.27'),
	('C00504','1.5.1.3'),
	('C00505','2.7.7.46'),
	('C00506','2.6.1.1'),
	('C00506','4.1.1.15'),
	('C00506','4.1.1.29'),
	('C00506','4.4.1.10'),
	('C00506','4.4.1.25'),
	('C00506','2.5.1.76'),
	('C00507','2.4.1.247'),
	('C00507','3.2.1.190'),
	('C00507','3.2.1.189'),
	('C00507','3.2.1.66'),
	('C00507','5.3.1.14'),
	('C00507','2.4.1.282'),
	('C00507','1.1.1.378'),
	('C00507','1.1.1.377'),
	('C00508','5.3.1.4'),
	('C00508','1.1.1.13'),
	('C00508','2.7.1.16'),
	('C00509','1.14.13.136'),
	('C00509','5.5.1.6'),
	('C00509','2.5.1.70'),
	('C00509','1.1.1.234'),
	('C00509','1.14.11.22'),
	('C00509','2.4.1.185'),
	('C00509','1.14.13.21'),
	('C00509','1.14.11.9'),
	('C00509','2.1.1.232'),
	('C00509','1.14.13.88'),
	('C00510','1.14.13.204'),
	('C00510','3.1.2.2'),
	('C00510','1.14.19.6'),
	('C00510','1.14.19.1'),
	('C00511','3.5.5.7'),
	('C00511','4.4.1.3'),
	('C00511','3.7.1.9'),
	('C00511','3.5.1.4'),
	('C00511','2.8.3.12'),
	('C00512','2.3.1.71'),
	('C00512','1.3.7.8'),
	('C00512','1.3.7.9'),
	('C00512','1.14.13.58'),
	('C00512','6.2.1.25'),
	('C00512','2.3.1.166'),
	('C00512','2.3.1.144'),
	('C00512','1.2.1.58'),
	('C00512','2.3.1.16'),
	('C00512','2.3.1.177'),
	('C00512','2.3.1.151'),
	('C00512','2.3.1.127'),
	('C00512','2.3.1.220'),
	('C00512','2.3.1.196'),
	('C00513','3.6.1.16'),
	('C00513','2.7.7.39'),
	('C00513','2.7.8.12'),
	('C00514','4.2.1.8'),
	('C00514','1.1.1.57'),
	('C00514','1.1.1.131'),
	('C00515','5.4.3.5'),
	('C00515','5.1.1.9'),
	('C00515','1.4.3.3'),
	('C00515','2.6.1.21'),
	('C00515','5.1.1.10'),
	('C00515','5.1.1.12'),
	('C00515','3.5.3.10'),
	('C00517','4.1.2.27'),
	('C00517','1.3.1.27'),
	('C00517','1.2.1.42'),
	('C00517','1.2.1.48'),
	('C00517','1.1.1.164'),
	('C00517','1.1.1.192'),
	('C00518','4.2.2.1'),
	('C00518','2.4.1.212'),
	('C00519','1.13.11.19'),
	('C00519','4.1.1.15'),
	('C00519','4.1.1.29'),
	('C00519','1.8.1.3'),
	('C00521','4.2.3.16'),
	('C00521','1.14.13.49'),
	('C00521','1.14.13.107'),
	('C00521','1.14.13.47'),
	('C00521','1.14.13.48'),
	('C00522','1.1.1.169'),
	('C00522','1.1.1.106'),
	('C00522','3.5.1.22'),
	('C00522','6.3.2.44'),
	('C00522','2.7.1.169'),
	('C00522','6.3.2.1'),
	('C00523','1.1.1.209'),
	('C00523','1.1.1.213'),
	('C00523','1.1.1.50'),
	('C00523','2.4.1.17'),
	('C00524','4.4.1.17'),
	('C00525','2.3.1.112'),
	('C00525','2.3.1.34'),
	('C00525','1.13.11.52'),
	('C00526','1.14.11.3'),
	('C00526','2.4.2.4'),
	('C00526','2.4.2.1'),
	('C00526','2.4.2.2'),
	('C00526','2.7.1.21'),
	('C00526','3.5.4.5'),
	('C00526','3.1.3.89'),
	('C00526','3.1.3.5'),
	('C00526','2.4.2.3'),
	('C00526','1.14.11.10'),
	('C00527','1.3.99.32'),
	('C00527','1.2.4.2'),
	('C00527','2.3.1.61'),
	('C00527','2.3.1.16'),
	('C00527','6.2.1.6'),
	('C00527','1.3.8.6'),
	('C00527','1.8.1.4'),
	('C00530','1.6.5.6'),
	('C00530','1.14.13.64'),
	('C00530','2.4.1.218'),
	('C00530','1.13.11.66'),
	('C00530','3.1.1.2'),
	('C00530','1.14.18.1'),
	('C00530','1.17.5.1'),
	('C00530','3.2.1.86'),
	('C00530','4.1.1.62'),
	('C00531','6.2.1.4'),
	('C00531','6.2.1.5'),
	('C00531','4.2.1.56'),
	('C00532','1.1.1.12'),
	('C00532','1.1.1.13'),
	('C00532','1.1.1.21'),
	('C00533','1.7.2.7'),
	('C00533','1.7.5.2'),
	('C00533','1.7.1.14'),
	('C00533','1.7.6.1'),
	('C00533','1.14.13.165'),
	('C00533','1.14.13.39'),
	('C00533','1.7.2.1'),
	('C00533','1.7.2.5'),
	('C00533','1.7.2.6'),
	('C00533','1.14.12.17'),
	('C00534','2.7.1.35'),
	('C00534','2.6.1.54'),
	('C00534','2.6.1.30'),
	('C00534','3.1.3.74'),
	('C00534','2.6.1.31'),
	('C00534','1.4.3.5'),
	('C00535','1.3.1.22'),
	('C00535','1.3.1.3'),
	('C00535','2.4.1.17'),
	('C00535','5.3.3.1'),
	('C00535','1.1.1.64'),
	('C00535','1.1.1.51'),
	('C00535','1.1.1.239'),
	('C00535','1.1.1.145'),
	('C00535','1.14.14.1'),
	('C00535','1.14.14.14'),
	('C00535','1.14.15.19'),
	('C00536','3.6.1.25'),
	('C00536','2.7.4.1'),
	('C00536','2.5.1.17'),
	('C00536','4.2.3.12'),
	('C00536','3.1.5.1'),
	('C00536','4.1.2.50'),
	('C00536','3.6.1.2'),
	('C00538','1.2.1.49'),
	('C00538','1.2.1.23'),
	('C00539','1.2.3.9'),
	('C00539','1.2.1.30'),
	('C00539','1.2.1.29'),
	('C00540','1.14.13.11'),
	('C00540','1.2.1.44'),
	('C00540','6.2.1.12'),
	('C00540','2.3.1.74'),
	('C00540','2.3.1.146'),
	('C00541','1.16.1.4'),
	('C00541','1.16.1.5'),
	('C00541','1.16.1.3'),
	('C00541','2.1.1.308'),
	('C00542','2.5.1.48'),
	('C00542','4.2.1.22'),
	('C00543','1.4.3.4'),
	('C00543','1.5.8.1'),
	('C00543','2.1.1.250'),
	('C00543','2.1.1.249'),
	('C00543','2.1.1.247'),
	('C00543','4.1.2.32'),
	('C00543','3.5.1.56'),
	('C00543','3.5.3.18'),
	('C00543','1.5.8.2'),
	('C00544','2.5.1.115'),
	('C00544','2.5.1.116'),
	('C00544','2.5.1.117'),
	('C00544','1.14.13.63'),
	('C00544','1.14.13.18'),
	('C00544','1.13.11.5'),
	('C00544','1.13.11.27'),
	('C00545','3.1.1.15'),
	('C00545','4.2.1.25'),
	('C00546','4.4.1.5'),
	('C00546','4.2.3.3'),
	('C00546','4.2.1.130'),
	('C00546','1.4.3.4'),
	('C00546','1.1.1.79'),
	('C00546','1.1.1.78'),
	('C00546','1.1.1.6'),
	('C00546','1.1.1.283'),
	('C00546','2.2.1.11'),
	('C00546','1.2.1.49'),
	('C00546','1.2.3.15'),
	('C00546','1.4.3.21'),
	('C00546','1.13.11.50'),
	('C00546','1.2.1.23'),
	('C00546','1.2.1.22'),
	('C00546','1.1.1.21'),
	('C00547','1.4.3.4'),
	('C00547','1.14.17.1'),
	('C00547','2.1.1.6'),
	('C00547','2.1.1.28'),
	('C00548','3.1.1.2'),
	('C00550','3.1.4.41'),
	('C00550','2.7.8.27'),
	('C00550','3.1.4.12'),
	('C00550','2.7.8.3'),
	('C00550','2.3.1.24'),
	('C00552','5.1.2.5'),
	('C00552','1.1.1.93'),
	('C00552','1.3.1.7'),
	('C00552','3.3.2.4'),
	('C00553','1.1.1.208'),
	('C00553','2.3.1.69'),
	('C00555','1.2.1.3'),
	('C00555','2.6.1.29'),
	('C00555','2.6.1.82'),
	('C00555','1.2.1.19'),
	('C00555','1.4.3.22'),
	('C00555','1.5.99.6'),
	('C00555','1.5.3.14'),
	('C00555','1.4.3.10'),
	('C00556','2.3.1.224'),
	('C00556','2.3.1.196'),
	('C00556','3.5.1.64'),
	('C00556','3.5.1.58'),
	('C00556','3.1.1.70'),
	('C00556','1.1.1.90'),
	('C00557','1.14.13.16'),
	('C00557','1.1.1.163'),
	('C00558','1.1.1.58'),
	('C00558','5.3.1.12'),
	('C00559','3.5.4.4'),
	('C00559','3.1.3.89'),
	('C00559','2.4.2.1'),
	('C00559','3.1.3.5'),
	('C00559','2.7.1.76'),
	('C00561','4.1.2.10'),
	('C00561','3.2.1.21'),
	('C00561','3.2.1.119'),
	('C00561','1.1.3.49'),
	('C00561','3.2.1.118'),
	('C00562','2.7.11.1'),
	('C00562','2.7.11.10'),
	('C00562','2.7.11.11'),
	('C00562','2.7.11.12'),
	('C00562','2.7.11.13'),
	('C00562','2.7.11.17'),
	('C00562','2.7.11.21'),
	('C00562','2.7.11.22'),
	('C00562','2.7.11.24'),
	('C00562','2.7.11.25'),
	('C00562','2.7.11.8'),
	('C00562','2.7.11.9'),
	('C00562','2.7.12.1'),
	('C00562','2.7.12.2'),
	('C00562','2.7.11.30'),
	('C00562','3.1.3.16'),
	('C00565','2.1.1.247'),
	('C00565','2.1.1.252'),
	('C00565','1.5.8.2'),
	('C00565','4.3.99.4'),
	('C00565','1.14.13.148'),
	('C00565','2.1.1.250'),
	('C00565','1.21.4.4'),
	('C00565','1.6.6.9'),
	('C00566','2.8.3.10'),
	('C00566','6.2.1.18'),
	('C00566','4.1.3.34'),
	('C00568','2.4.2.54'),
	('C00568','4.1.1.24'),
	('C00568','4.1.3.38'),
	('C00568','1.14.13.27'),
	('C00568','2.5.1.15'),
	('C00570','2.7.8.1'),
	('C00570','2.7.8.4'),
	('C00570','2.7.7.14'),
	('C00571','3.10.1.2'),
	('C00571','1.4.3.12'),
	('C00573','3.2.1.103'),
	('C00573','2.8.2.21'),
	('C00575','4.6.1.1'),
	('C00575','3.1.4.53'),
	('C00575','3.1.4.17'),
	('C00576','1.2.1.8'),
	('C00576','1.1.1.1'),
	('C00576','1.1.3.17'),
	('C00576','1.14.15.7'),
	('C00576','1.1.99.1'),
	('C00577','1.1.1.72'),
	('C00577','1.1.1.372'),
	('C00577','1.1.1.21'),
	('C00577','1.1.1.2'),
	('C00577','1.2.1.89'),
	('C00577','1.2.1.3'),
	('C00577','1.2.99.8'),
	('C00577','1.2.7.5'),
	('C00577','2.2.1.11'),
	('C00577','2.7.1.28'),
	('C00577','4.1.2.13'),
	('C00577','4.1.2.51'),
	('C00577','4.1.2.55'),
	('C00579','1.8.1.4'),
	('C00580','1.14.13.131'),
	('C00580','2.1.1.19'),
	('C00580','2.1.1.96'),
	('C00580','1.8.5.3'),
	('C00580','1.8.2.4'),
	('C00580','4.4.1.3'),
	('C00581','2.1.1.2'),
	('C00581','2.7.3.1'),
	('C00581','2.1.4.1'),
	('C00581','3.5.3.2'),
	('C00582','2.3.1.13'),
	('C00582','1.17.5.1'),
	('C00582','1.14.13.149'),
	('C00582','6.2.1.30'),
	('C00582','2.3.1.192'),
	('C00582','2.3.1.164'),
	('C00582','2.3.1.14'),
	('C00583','4.2.1.28'),
	('C00583','1.1.1.6'),
	('C00583','1.1.1.77'),
	('C00583','1.1.1.55'),
	('C00583','1.1.1.21'),
	('C00584','5.3.99.3'),
	('C00584','1.1.1.184'),
	('C00584','1.1.1.189'),
	('C00584','1.1.1.141'),
	('C00585','2.8.2.20'),
	('C00585','2.7.10.1'),
	('C00585','2.7.12.1'),
	('C00585','2.7.12.2'),
	('C00585','2.7.10.2'),
	('C00585','3.1.3.48'),
	('C00586','3.2.1.112'),
	('C00586','3.1.3.68'),
	('C00587','6.2.1.37'),
	('C00587','1.2.1.28'),
	('C00587','1.2.1.7'),
	('C00587','1.2.1.64'),
	('C00587','4.1.1.55'),
	('C00587','1.14.99.23'),
	('C00587','4.1.3.45'),
	('C00587','1.14.13.24'),
	('C00587','1.14.13.23'),
	('C00588','3.1.4.3'),
	('C00588','2.1.1.103'),
	('C00588','3.1.4.12'),
	('C00588','2.7.7.15'),
	('C00588','2.7.1.32'),
	('C00588','3.6.1.53'),
	('C00588','3.1.3.75'),
	('C00588','3.1.4.38'),
	('C00590','2.4.1.111'),
	('C00590','1.11.1.7'),
	('C00590','1.1.1.195'),
	('C00590','1.1.1.194'),
	('C00590','1.11.1.21'),
	('C00590','2.1.1.68'),
	('C00590','3.2.1.126'),
	('C00591','3.1.3.29'),
	('C00591','3.1.4.40'),
	('C00591','2.7.7.43'),
	('C00593','2.6.1.55'),
	('C00593','2.6.1.77'),
	('C00593','2.3.3.15'),
	('C00593','1.1.1.313'),
	('C00593','1.4.99.2'),
	('C00593','1.2.1.73'),
	('C00593','1.2.1.81'),
	('C00593','4.1.1.79'),
	('C00596','4.2.1.80'),
	('C00596','3.7.1.14'),
	('C00596','4.1.1.77'),
	('C00596','4.5.1.4'),
	('C00596','3.7.1.8'),
	('C00596','3.7.1.9'),
	('C00596','3.7.1.13'),
	('C00599','1.1.3.6'),
	('C00599','1.1.1.145'),
	('C00599','5.3.3.1'),
	('C00599','1.3.1.3'),
	('C00599','1.14.13.221'),
	('C00599','1.3.1.22'),
	('C00599','1.14.13.141'),
	('C00601','1.4.3.21'),
	('C00601','1.4.9.2'),
	('C00601','1.4.3.4'),
	('C00601','5.3.99.7'),
	('C00601','4.1.1.43'),
	('C00601','1.1.1.90'),
	('C00601','1.2.1.39'),
	('C00601','1.2.1.5'),
	('C00602','2.3.1.18'),
	('C00603','3.5.1.116'),
	('C00603','1.1.1.154'),
	('C00603','1.1.1.350'),
	('C00603','3.5.3.26'),
	('C00603','3.5.3.4'),
	('C00603','4.3.2.3'),
	('C00605','1.3.8.7'),
	('C00605','1.3.1.8'),
	('C00605','2.3.1.15'),
	('C00605','1.3.8.8'),
	('C00605','2.3.1.20'),
	('C00605','2.3.1.22'),
	('C00605','2.3.1.51'),
	('C00606','2.6.1.1'),
	('C00606','4.1.1.12'),
	('C00606','4.1.1.29'),
	('C00606','4.1.1.15'),
	('C00606','1.13.11.20'),
	('C00609','1.2.1.50'),
	('C00609','1.2.1.80'),
	('C00609','4.1.99.5'),
	('C00609','1.1.3.20'),
	('C00609','1.14.14.3'),
	('C00609','1.2.1.48'),
	('C00611','2.4.1.87'),
	('C00611','2.4.1.90'),
	('C00611','2.4.99.1'),
	('C00612','1.5.3.13'),
	('C00612','3.5.1.48'),
	('C00612','1.5.3.17'),
	('C00613','2.4.2.31'),
	('C00613','2.1.1.321'),
	('C00613','2.1.1.320'),
	('C00613','2.1.1.322'),
	('C00613','3.2.2.19'),
	('C00613','2.7.14.1'),
	('C00613','3.5.3.15'),
	('C00613','2.1.1.319'),
	('C00613','3.9.1.2'),
	('C00614','3.5.1.44'),
	('C00614','2.1.1.80'),
	('C00614','3.1.1.61'),
	('C00615','5.4.2.11'),
	('C00615','2.7.1.197'),
	('C00615','2.7.1.198'),
	('C00615','2.7.1.199'),
	('C00615','2.7.1.200'),
	('C00615','2.7.1.201'),
	('C00615','2.1.1.85'),
	('C00615','2.7.13.2'),
	('C00615','2.7.13.1'),
	('C00615','2.7.3.9'),
	('C00615','2.7.1.196'),
	('C00615','2.7.1.195'),
	('C00615','2.7.1.194'),
	('C00615','2.7.1.193'),
	('C00615','2.7.1.192'),
	('C00615','2.7.1.191'),
	('C00615','2.7.1.211'),
	('C00615','2.7.1.208'),
	('C00615','2.7.1.207'),
	('C00615','2.7.1.206'),
	('C00615','2.7.1.205'),
	('C00615','3.9.1.3'),
	('C00615','2.7.1.202'),
	('C00615','2.7.1.204'),
	('C00615','2.7.1.203'),
	('C00616','2.8.2.27'),
	('C00616','2.8.2.25'),
	('C00616','2.8.2.26'),
	('C00617','2.4.1.43'),
	('C00617','5.1.3.6'),
	('C00617','4.1.1.67'),
	('C00618','1.1.1.130'),
	('C00618','4.1.1.34'),
	('C00618','2.7.1.53'),
	('C00618','1.1.1.45'),
	('C00619','1.3.99.6'),
	('C00619','5.3.3.1'),
	('C00619','1.3.99.5'),
	('C00620','5.4.2.2'),
	('C00620','2.4.2.2'),
	('C00620','2.4.2.16'),
	('C00620','5.4.2.7'),
	('C00620','2.4.2.1'),
	('C00620','3.6.1.21'),
	('C00620','2.4.2.3'),
	('C00620','2.4.2.15'),
	('C00621','2.7.4.20'),
	('C00621','2.4.99.18'),
	('C00621','3.6.1.43'),
	('C00623','2.7.1.79'),
	('C00623','2.5.1.41'),
	('C00623','1.1.1.261'),
	('C00623','3.1.3.21'),
	('C00624','2.7.2.8'),
	('C00624','2.3.1.35'),
	('C00624','2.3.1.1'),
	('C00625','5.1.3.8'),
	('C00625','1.1.1.233'),
	('C00625','2.7.1.60'),
	('C00627','2.6.99.2'),
	('C00627','1.4.3.5'),
	('C00627','3.1.3.74'),
	('C00627','2.7.1.35'),
	('C00628','1.14.13.24'),
	('C00628','1.13.11.4'),
	('C00628','1.2.3.1'),
	('C00628','1.2.1.29'),
	('C00628','1.14.13.172'),
	('C00628','4.1.1.62'),
	('C00630','5.4.99.13'),
	('C00630','1.3.99.12'),
	('C00630','1.2.7.7'),
	('C00630','1.3.8.7'),
	('C00630','2.3.1.168'),
	('C00630','1.2.1.25'),
	('C00630','1.3.8.1'),
	('C00631','4.2.1.11'),
	('C00631','5.4.2.11'),
	('C00631','5.4.2.12'),
	('C00631','3.1.3.80'),
	('C00631','2.7.1.165'),
	('C00631','3.1.3.20'),
	('C00632','1.10.3.5'),
	('C00632','1.11.1.6'),
	('C00632','1.11.1.21'),
	('C00632','1.13.11.6'),
	('C00632','1.14.16.3'),
	('C00632','3.7.1.3'),
	('C00632','2.1.1.97'),
	('C00632','1.14.14.8'),
	('C00633','1.1.3.19'),
	('C00633','4.1.2.11'),
	('C00633','4.1.1.7'),
	('C00633','1.17.99.1'),
	('C00633','1.2.1.96'),
	('C00633','1.2.1.64'),
	('C00633','1.2.1.7'),
	('C00633','1.2.1.28'),
	('C00634','4.2.2.5'),
	('C00634','4.2.2.20'),
	('C00634','2.8.2.5'),
	('C00634','2.8.2.33'),
	('C00634','4.2.2.21'),
	('C00635','4.2.2.5'),
	('C00635','2.8.2.17'),
	('C00635','4.2.2.21'),
	('C00635','4.2.2.20'),
	('C00636','5.4.2.8'),
	('C00636','3.6.1.21'),
	('C00636','2.4.1.320'),
	('C00636','2.7.7.22'),
	('C00636','2.4.1.281'),
	('C00636','2.4.1.319'),
	('C00636','2.7.7.13'),
	('C00637','4.1.1.74'),
	('C00637','4.1.1.43'),
	('C00637','1.4.3.22'),
	('C00637','1.4.3.4'),
	('C00637','1.1.1.191'),
	('C00637','1.2.1.3'),
	('C00637','1.2.3.7'),
	('C00637','1.1.1.190'),
	('C00638','6.2.1.19'),
	('C00638','6.2.1.20'),
	('C00638','1.14.14.3'),
	('C00638','3.1.2.2'),
	('C00638','2.3.1.85'),
	('C00638','3.1.1.67'),
	('C00639','1.1.1.196'),
	('C00639','1.1.1.184'),
	('C00639','1.1.1.188'),
	('C00639','1.1.1.189'),
	('C00639','1.11.1.20'),
	('C00639','1.1.1.141'),
	('C00640','4.2.1.17'),
	('C00640','1.1.1.35'),
	('C00640','1.1.1.211'),
	('C00640','4.2.1.74'),
	('C00641','3.1.3.81'),
	('C00641','2.3.1.73'),
	('C00641','4.6.1.13'),
	('C00641','3.1.4.11'),
	('C00641','3.1.3.4'),
	('C00641','4.6.1.14'),
	('C00641','2.7.1.174'),
	('C00641','2.7.1.107'),
	('C00641','2.7.8.27'),
	('C00641','2.7.8.1'),
	('C00641','2.7.8.2'),
	('C00641','2.7.8.20'),
	('C00641','2.7.8.42'),
	('C00641','3.1.1.3'),
	('C00641','2.4.1.184'),
	('C00641','2.4.1.46'),
	('C00641','2.4.1.336'),
	('C00641','2.4.1.337'),
	('C00641','2.4.1.315'),
	('C00641','2.3.1.158'),
	('C00641','2.3.1.22'),
	('C00641','2.3.1.20'),
	('C00641','3.1.4.3'),
	('C00642','1.14.13.18'),
	('C00642','1.2.3.13'),
	('C00642','1.2.1.53'),
	('C00642','1.2.1.29'),
	('C00642','1.2.1.5'),
	('C00642','1.14.14.9'),
	('C00642','4.1.1.83'),
	('C00643','4.1.1.28'),
	('C00643','2.6.1.27'),
	('C00643','1.14.16.4'),
	('C00643','1.13.11.52'),
	('C00644','1.1.1.224'),
	('C00644','1.1.1.17'),
	('C00644','3.1.3.22'),
	('C00644','2.7.1.197'),
	('C00645','2.7.1.60'),
	('C00645','2.5.1.56'),
	('C00645','3.2.1.183'),
	('C00645','5.1.3.8'),
	('C00645','4.1.3.3'),
	('C00645','5.1.3.14'),
	('C00647','2.7.1.35'),
	('C00647','1.4.3.5'),
	('C00647','3.1.3.74'),
	('C00647','2.6.1.54'),
	('C00650','2.4.1.178'),
	('C00651','3.5.1.67'),
	('C00651','6.3.1.7'),
	('C00652','1.1.1.117'),
	('C00652','1.1.3.37'),
	('C00652','3.1.1.30'),
	('C00652','1.1.1.116'),
	('C00653','2.4.1.70'),
	('C00653','2.4.1.53'),
	('C00653','6.1.1.13'),
	('C00653','2.7.8.14'),
	('C00655','2.4.2.8'),
	('C00655','2.4.2.22'),
	('C00655','3.6.1.17'),
	('C00655','3.6.1.66'),
	('C00655','3.1.3.5'),
	('C00655','6.3.5.2'),
	('C00655','1.1.1.205'),
	('C00658','1.3.3.6'),
	('C00658','1.3.1.93'),
	('C00658','1.3.1.38'),
	('C00658','1.3.1.44'),
	('C00658','4.2.1.17'),
	('C00658','4.2.1.119'),
	('C00658','1.3.1.34'),
	('C00658','4.2.1.74'),
	('C00662','1.14.15.5'),
	('C00662','1.14.15.4'),
	('C00662','1.18.1.6'),
	('C00662','1.18.1.2'),
	('C00662','1.14.15.18'),
	('C00662','1.14.15.16'),
	('C00662','1.14.15.15'),
	('C00662','1.14.15.6'),
	('C00663','5.4.2.6'),
	('C00663','2.4.1.64'),
	('C00663','2.4.1.282'),
	('C00663','2.4.1.334'),
	('C00663','2.4.1.332'),
	('C00663','2.4.1.8'),
	('C00663','2.4.1.230'),
	('C00663','2.4.1.216'),
	('C00663','2.4.1.279'),
	('C00664','4.3.1.4'),
	('C00664','2.1.2.5'),
	('C00664','2.1.2.4'),
	('C00665','2.7.1.105'),
	('C00665','3.1.3.54'),
	('C00665','3.1.3.46'),
	('C00666','5.1.1.7'),
	('C00666','2.6.1.83'),
	('C00666','3.5.1.47'),
	('C00666','3.5.1.18'),
	('C00667','1.14.15.4'),
	('C00667','1.14.15.18'),
	('C00667','1.18.1.6'),
	('C00667','1.18.1.2'),
	('C00667','1.14.15.16'),
	('C00667','1.14.15.15'),
	('C00667','1.14.15.6'),
	('C00667','1.14.15.5'),
	('C00668','3.2.1.26'),
	('C00668','2.7.1.63'),
	('C00668','5.4.2.5'),
	('C00668','5.3.1.9'),
	('C00668','2.4.1.15'),
	('C00668','5.4.2.2'),
	('C00668','3.1.3.9'),
	('C00668','5.1.3.15'),
	('C00668','2.7.1.2'),
	('C00668','2.7.1.1'),
	('C00668','2.7.1.147'),
	('C00668','2.7.1.199'),
	('C00669','1.8.1.13'),
	('C00669','2.3.2.4'),
	('C00669','1.14.99.50'),
	('C00669','6.3.2.23'),
	('C00669','6.3.2.2'),
	('C00669','6.3.2.3'),
	('C00670','3.1.4.46'),
	('C00670','3.1.1.5'),
	('C00670','3.3.2.2'),
	('C00670','3.1.4.2'),
	('C00670','3.1.4.38'),
	('C00671','4.2.1.9'),
	('C00671','2.6.1.42'),
	('C00671','2.6.1.32'),
	('C00671','1.4.1.9'),
	('C00671','1.2.1.25'),
	('C00671','1.2.7.7'),
	('C00671','4.1.1.72'),
	('C00671','1.2.4.4'),
	('C00671','1.4.3.2'),
	('C00672','2.4.2.4'),
	('C00672','5.4.2.7'),
	('C00672','2.4.2.2'),
	('C00672','2.4.2.3'),
	('C00672','2.4.2.1'),
	('C00673','2.7.1.15'),
	('C00673','5.4.2.7'),
	('C00673','4.1.2.4'),
	('C00674','1.1.1.50'),
	('C00674','1.1.1.51'),
	('C00674','1.1.1.209'),
	('C00674','1.1.1.213'),
	('C00674','1.3.99.5'),
	('C00674','1.3.1.22'),
	('C00675','3.1.3.34'),
	('C00676','2.7.1.77'),
	('C00676','2.7.1.145'),
	('C00676','3.1.3.89'),
	('C00677','2.7.7.31'),
	('C00677','2.7.7.7'),
	('C00677','2.7.7.49'),
	('C00679','4.2.1.40'),
	('C00679','4.2.1.41'),
	('C00679','4.2.1.42'),
	('C00679','4.2.1.156'),
	('C00679','5.5.1.27'),
	('C00679','4.1.2.20'),
	('C00680','6.3.2.13'),
	('C00680','4.1.1.20'),
	('C00680','1.4.1.16'),
	('C00680','5.1.1.7'),
	('C00681','2.3.1.15'),
	('C00681','2.3.1.51'),
	('C00681','2.7.1.94'),
	('C00681','1.1.1.101'),
	('C00682','3.7.1.9'),
	('C00682','1.2.1.85'),
	('C00682','1.13.11.2'),
	('C00683','2.3.1.240'),
	('C00683','6.4.1.3'),
	('C00683','4.1.1.41'),
	('C00683','5.1.99.1'),
	('C00683','3.1.2.17'),
	('C00683','2.1.3.1'),
	('C00683','2.3.1.239'),
	('C00683','2.3.1.94'),
	('C00684','4.2.1.43'),
	('C00684','4.1.2.18'),
	('C00684','4.2.1.25'),
	('C00685','1.1.1.100'),
	('C00685','2.3.1.41'),
	('C00685','1.1.1.212'),
	('C00686','2.5.1.57'),
	('C00686','2.7.1.60'),
	('C00686','5.1.3.9'),
	('C00688','5.1.3.13'),
	('C00688','1.1.1.344'),
	('C00688','1.1.1.339'),
	('C00688','1.1.1.134'),
	('C00688','1.1.1.133'),
	('C00689','3.1.3.12'),
	('C00689','2.4.1.216'),
	('C00689','3.2.1.93'),
	('C00689','3.2.1.122'),
	('C00689','2.4.1.36'),
	('C00689','2.4.1.15'),
	('C00689','2.7.1.201'),
	('C00691','1.1.1.18'),
	('C00691','1.1.1.371'),
	('C00691','5.3.99.11'),
	('C00691','2.6.1.50'),
	('C00691','4.2.1.44'),
	('C00691','1.1.1.370'),
	('C00692','6.3.2.37'),
	('C00692','6.3.2.13'),
	('C00692','6.3.2.9'),
	('C00692','6.3.2.7'),
	('C00693','4.2.1.59'),
	('C00693','1.3.1.39'),
	('C00693','1.3.1.9'),
	('C00693','1.3.1.104'),
	('C00693','1.3.1.10'),
	('C00694','2.4.1.150'),
	('C00694','2.4.1.149'),
	('C00694','2.4.1.87'),
	('C00695','3.1.2.27'),
	('C00695','1.1.1.159'),
	('C00695','1.1.1.176'),
	('C00695','3.5.1.24'),
	('C00695','6.2.1.7'),
	('C00695','2.8.3.25'),
	('C00696','5.3.99.2'),
	('C00696','1.1.1.196'),
	('C00696','1.1.1.188'),
	('C00697','1.7.2.8'),
	('C00697','1.7.2.4'),
	('C00697','1.18.6.1'),
	('C00697','1.19.6.1'),
	('C00697','1.7.1.14'),
	('C00698','1.14.12.13'),
	('C00698','1.13.11.49'),
	('C00698','1.11.2.2'),
	('C00698','1.3.1.32'),
	('C00698','1.14.19.9'),
	('C00698','1.14.13.50'),
	('C00698','2.5.1.94'),
	('C00698','3.8.1.1'),
	('C00698','3.8.1.7'),
	('C00698','3.8.1.6'),
	('C00698','4.5.1.5'),
	('C00698','4.5.1.4'),
	('C00698','1.97.1.8'),
	('C00700','3.6.1.17'),
	('C00700','3.6.1.66'),
	('C00701','2.4.2.6'),
	('C00701','2.4.2.5'),
	('C00703','4.99.1.2'),
	('C00703','1.16.1.1'),
	('C00704','1.11.1.21'),
	('C00704','1.15.1.1'),
	('C00704','1.15.1.2'),
	('C00704','1.11.1.6'),
	('C00705','2.7.4.25'),
	('C00705','2.7.4.6'),
	('C00705','1.17.4.1'),
	('C00705','3.6.1.12'),
	('C00705','2.7.4.14'),
	('C00705','2.7.1.48'),
	('C00706','2.1.1.49'),
	('C00706','2.8.2.3'),
	('C00706','3.5.1.79'),
	('C00708','1.21.99.4'),
	('C00708','2.1.1.165'),
	('C00708','1.21.99.3'),
	('C00708','1.21.1.1'),
	('C00708','1.11.1.8'),
	('C00712','4.2.1.53'),
	('C00712','3.1.2.2'),
	('C00712','1.11.2.3'),
	('C00712','3.5.1.99'),
	('C00712','1.13.11.77'),
	('C00712','3.1.2.14'),
	('C00714','3.1.1.11'),
	('C00714','2.4.1.43'),
	('C00715','3.5.4.11'),
	('C00715','1.17.3.1'),
	('C00716','4.3.1.15'),
	('C00717','1.1.1.21'),
	('C00718','2.4.99.16'),
	('C00718','3.2.1.33'),
	('C00718','2.4.1.11'),
	('C00718','2.4.1.1'),
	('C00718','2.4.1.242'),
	('C00718','2.4.1.25'),
	('C00718','2.4.1.21'),
	('C00718','2.4.1.18'),
	('C00718','2.4.1.4'),
	('C00718','2.4.1.2'),
	('C00719','1.2.1.8'),
	('C00719','1.21.4.4'),
	('C00719','1.1.3.17'),
	('C00719','2.1.1.161'),
	('C00719','2.1.1.162'),
	('C00719','2.1.1.5'),
	('C00719','2.1.1.157'),
	('C00720','1.11.1.18'),
	('C00721','3.2.1.2'),
	('C00721','3.2.1.1'),
	('C00721','3.2.1.3'),
	('C00721','3.2.1.133'),
	('C00721','3.2.1.10'),
	('C00722','3.3.2.10'),
	('C00722','1.14.13.25'),
	('C00723','1.8.4.2'),
	('C00726','3.5.5.2'),
	('C00726','3.5.5.1'),
	('C00726','2.5.1.18'),
	('C00726','4.99.1.5'),
	('C00726','4.2.1.84'),
	('C00726','3.5.5.5'),
	('C00726','3.5.5.7'),
	('C00727','4.1.1.58'),
	('C00727','1.14.13.6'),
	('C00729','2.3.1.185'),
	('C00729','1.1.1.206'),
	('C00729','3.1.1.10'),
	('C00734','3.5.1.41'),
	('C00734','3.2.1.132'),
	('C00734','3.2.1.165'),
	('C00735','5.3.3.1'),
	('C00735','1.14.15.4'),
	('C00735','1.14.14.16'),
	('C00735','1.1.1.146'),
	('C00735','1.1.1.145'),
	('C00735','2.3.1.27'),
	('C00735','1.3.1.3'),
	('C00735','2.8.2.18'),
	('C00736','4.4.1.9'),
	('C00736','1.8.4.4'),
	('C00737','2.4.1.162'),
	('C00737','1.1.1.121'),
	('C00738','2.7.1.62'),
	('C00738','2.7.1.61'),
	('C00738','2.7.1.1'),
	('C00739','5.1.1.9'),
	('C00739','5.4.3.4'),
	('C00739','2.6.1.21'),
	('C00739','6.3.2.37'),
	('C00739','5.1.1.5'),
	('C00740','4.3.1.18'),
	('C00740','5.1.1.10'),
	('C00740','5.1.1.18'),
	('C00740','6.3.2.35'),
	('C00740','3.1.3.3'),
	('C00741','1.1.1.303'),
	('C00741','1.1.1.304'),
	('C00742','2.5.1.63'),
	('C00744','2.1.1.101'),
	('C00744','2.1.1.102'),
	('C00747','2.1.1.87'),
	('C00747','2.5.1.2'),
	('C00748','4.99.1.4'),
	('C00750','2.5.1.16'),
	('C00750','2.5.1.22'),
	('C00750','1.5.3.16'),
	('C00750','6.3.1.9'),
	('C00750','1.5.3.17'),
	('C00751','2.5.1.21'),
	('C00751','5.4.99.37'),
	('C00751','5.4.99.17'),
	('C00751','4.2.1.129'),
	('C00751','4.2.1.123'),
	('C00751','1.14.14.17'),
	('C00751','2.1.1.262'),
	('C00751','1.3.1.96'),
	('C00755','1.1.3.38'),
	('C00755','1.13.11.43'),
	('C00755','1.2.1.67'),
	('C00755','4.1.2.41'),
	('C00755','1.2.3.9'),
	('C00756','1.14.15.3'),
	('C00756','1.1.1.73'),
	('C00756','1.1.1.1'),
	('C00757','1.3.3.8'),
	('C00757','1.5.1.31'),
	('C00757','1.21.3.2'),
	('C00758','2.1.1.69'),
	('C00759','3.1.3.55'),
	('C00759','2.7.11.17'),
	('C00760','2.4.1.12'),
	('C00760','2.4.1.29'),
	('C00760','3.2.1.4'),
	('C00760','3.2.1.91'),
	('C00760','2.4.1.49'),
	('C00761','2.4.1.111'),
	('C00761','3.2.1.126'),
	('C00762','1.3.1.22'),
	('C00762','1.3.1.3'),
	('C00762','1.1.1.146'),
	('C00763','1.5.99.13'),
	('C00763','1.4.1.12'),
	('C00763','1.21.4.1'),
	('C00763','5.1.1.4'),
	('C00763','1.4.3.3'),
	('C00764','5.1.3.31'),
	('C00764','1.1.1.15'),
	('C00766','1.14.13.88'),
	('C00766','1.14.11.9'),
	('C00766','1.14.11.22'),
	('C00766','5.5.1.6'),
	('C00766','2.4.1.185'),
	('C00770','1.1.1.264'),
	('C00770','1.1.1.215'),
	('C00770','1.1.1.366'),
	('C00772','1.1.1.33'),
	('C00772','1.1.1.32'),
	('C00774','3.7.1.4'),
	('C00777','2.4.1.17'),
	('C00777','1.14.15.3'),
	('C00777','1.14.14.1'),
	('C00777','1.2.1.36'),
	('C00777','1.2.3.1'),
	('C00778','2.7.11.14'),
	('C00779','1.1.1.252'),
	('C00779','4.2.1.94'),
	('C00780','4.1.1.28'),
	('C00780','1.13.11.52'),
	('C00780','2.3.1.87'),
	('C00780','2.1.1.49'),
	('C00780','1.4.3.4'),
	('C00783','1.1.1.236'),
	('C00783','1.1.1.206'),
	('C00785','1.3.99.33'),
	('C00785','4.2.1.49'),
	('C00785','4.3.1.3'),
	('C00786','1.3.1.45'),
	('C00786','1.1.1.348'),
	('C00787','2.3.2.21'),
	('C00787','6.1.1.1'),
	('C00788','2.1.1.28'),
	('C00788','2.1.1.6'),
	('C00788','1.4.3.4'),
	('C00789','2.7.7.40'),
	('C00789','2.7.8.14'),
	('C00791','3.5.4.21'),
	('C00791','3.5.2.10'),
	('C00791','3.5.4.1'),
	('C00792','3.5.3.10'),
	('C00792','2.6.1.21'),
	('C00792','1.4.99.6'),
	('C00792','1.4.3.3'),
	('C00792','5.1.1.9'),
	('C00793','4.4.1.15'),
	('C00793','5.1.1.10'),
	('C00794','2.7.1.1'),
	('C00794','1.1.1.14'),
	('C00794','1.1.1.289'),
	('C00794','1.1.1.21'),
	('C00794','2.7.1.198'),
	('C00794','3.2.1.22'),
	('C00794','1.1.99.21'),
	('C00794','3.1.3.50'),
	('C00794','1.1.1.15'),
	('C00794','1.1.99.28'),
	('C00795','1.1.1.16'),
	('C00795','5.1.3.31'),
	('C00795','2.7.1.101'),
	('C00797','1.4.3.19'),
	('C00797','3.5.1.65'),
	('C00797','3.5.4.43'),
	('C00797','6.3.1.6'),
	('C00798','3.1.2.10'),
	('C00798','4.1.1.8'),
	('C00798','2.8.3.16'),
	('C00799','2.4.1.170'),
	('C00799','1.14.13.89'),
	('C00800','3.1.1.25'),
	('C00800','1.1.1.45'),
	('C00800','1.1.1.19'),
	('C00800','3.1.1.17'),
	('C00800','1.1.1.2'),
	('C00800','1.1.1.380'),
	('C00801','2.7.1.77'),
	('C00801','3.1.3.31'),
	('C00802','2.1.3.5'),
	('C00802','1.1.1.350'),
	('C00802','1.1.1.154'),
	('C00803','3.5.1.50'),
	('C00804','4.2.1.27'),
	('C00804','1.2.1.3'),
	('C00804','1.2.5.2'),
	('C00805','1.14.13.172'),
	('C00805','1.14.13.1'),
	('C00805','4.2.99.21'),
	('C00805','3.7.1.8'),
	('C00805','1.2.1.65'),
	('C00805','2.1.1.274'),
	('C00805','3.1.1.55'),
	('C00805','4.1.1.91'),
	('C00806','2.5.1.34'),
	('C00808','1.14.15.10'),
	('C00808','1.1.1.198'),
	('C00808','1.14.13.161'),
	('C00808','1.14.15.1'),
	('C00809','1.1.1.227'),
	('C00810','1.1.1.303'),
	('C00810','4.1.1.5'),
	('C00810','5.1.2.4'),
	('C00810','1.1.1.4'),
	('C00811','1.14.18.1'),
	('C00811','2.4.1.126'),
	('C00811','4.1.1.102'),
	('C00811','4.3.1.25'),
	('C00811','4.3.1.23'),
	('C00811','1.14.13.11'),
	('C00811','6.2.1.12'),
	('C00812','4.4.1.6'),
	('C00813','1.17.99.4'),
	('C00813','3.5.2.1'),
	('C00814','2.4.1.170'),
	('C00814','1.3.1.46'),
	('C00814','2.1.1.212'),
	('C00814','1.14.13.52'),
	('C00814','1.14.13.89'),
	('C00815','2.8.3.11'),
	('C00817','1.1.1.58'),
	('C00817','4.2.1.7'),
	('C00818','1.2.1.3'),
	('C00818','4.2.1.40'),
	('C00818','2.3.1.131'),
	('C00818','2.3.1.98'),
	('C00819','3.5.1.35'),
	('C00819','5.1.1.10'),
	('C00819','3.5.1.38'),
	('C00819','2.3.2.1'),
	('C00819','3.5.1.2'),
	('C00820','5.1.1.6'),
	('C00820','4.1.2.42'),
	('C00821','1.14.11.51'),
	('C00821','4.3.2.4'),
	('C00821','2.6.99.1'),
	('C00821','2.1.1.72'),
	('C00822','1.14.18.1'),
	('C00822','1.10.3.1'),
	('C00823','1.1.1.192'),
	('C00823','1.1.1.164'),
	('C00825','6.1.2.2'),
	('C00825','1.14.11.37'),
	('C00825','2.3.1.82'),
	('C00825','2.4.1.301'),
	('C00825','2.6.1.94'),
	('C00826','4.2.1.91'),
	('C00826','2.6.1.79'),
	('C00826','2.6.1.78'),
	('C00826','2.6.1.57'),
	('C00826','1.3.1.79'),
	('C00826','4.2.1.51'),
	('C00826','1.3.1.43'),
	('C00826','1.3.1.78'),
	('C00827','2.8.3.1'),
	('C00827','4.2.1.54'),
	('C00828','2.1.1.163'),
	('C00828','1.8.5.3'),
	('C00828','1.17.4.4'),
	('C00828','1.3.5.3'),
	('C00828','1.12.5.1'),
	('C00828','1.7.5.2'),
	('C00828','1.6.5.2'),
	('C00828','1.10.3.12'),
	('C00829','1.14.14.1'),
	('C00829','1.14.12.12'),
	('C00830','2.6.1.47'),
	('C00830','1.1.1.167'),
	('C00831','2.7.1.33'),
	('C00831','2.7.1.34'),
	('C00831','4.1.1.30'),
	('C00831','3.5.1.92'),
	('C00835','1.1.1.325'),
	('C00835','3.5.4.24'),
	('C00835','1.1.1.153'),
	('C00836','1.14.18.5'),
	('C00836','2.3.1.24'),
	('C00836','1.1.1.102'),
	('C00836','2.7.1.91'),
	('C00836','3.5.1.23'),
	('C00836','3.1.3.4'),
	('C00839','2.7.11.28'),
	('C00841','2.1.1.70'),
	('C00842','5.1.3.2'),
	('C00842','4.2.1.46'),
	('C00842','2.7.7.24'),
	('C00843','1.3.1.81'),
	('C00843','1.14.13.105'),
	('C00843','1.1.1.207'),
	('C00843','1.1.1.208'),
	('C00844','3.2.1.21'),
	('C00844','3.2.1.118'),
	('C00844','3.2.1.117'),
	('C00845','6.2.1.31'),
	('C00845','1.3.99.8'),
	('C00846','1.3.1.32'),
	('C00846','3.1.1.24'),
	('C00846','2.8.3.6'),
	('C00847','1.2.3.1'),
	('C00847','1.2.3.8'),
	('C00847','3.1.1.27'),
	('C00848','1.14.13.51'),
	('C00848','1.1.1.241'),
	('C00850','3.1.6.1'),
	('C00850','2.8.2.1'),
	('C00850','2.8.2.22'),
	('C00852','2.3.1.98'),
	('C00852','2.3.1.133'),
	('C00852','1.14.13.36'),
	('C00852','3.1.1.42'),
	('C00852','2.3.1.99'),
	('C00853','1.16.1.4'),
	('C00853','1.16.1.6'),
	('C00853','2.5.1.17'),
	('C00854','1.14.15.3'),
	('C00854','1.1.1.163'),
	('C00854','1.1.1.245'),
	('C00855','2.6.1.41'),
	('C00855','5.1.1.2'),
	('C00856','2.1.1.113'),
	('C00856','2.1.1.37'),
	('C00857','2.7.7.1'),
	('C00857','2.7.7.18'),
	('C00857','3.6.1.9'),
	('C00857','3.6.1.22'),
	('C00857','6.3.5.1'),
	('C00857','6.3.1.5'),
	('C00858','1.14.13.89'),
	('C00858','2.4.1.170'),
	('C00858','4.2.1.105'),
	('C00858','1.14.13.52'),
	('C00858','1.14.13.53'),
	('C00858','2.1.1.212'),
	('C00859','1.14.11.15'),
	('C00859','1.14.11.13'),
	('C00860','1.1.1.23'),
	('C00860','3.1.3.15'),
	('C00861','5.3.1.14'),
	('C00861','2.7.1.5'),
	('C00862','2.3.1.101'),
	('C00862','1.2.99.5'),
	('C00863','2.3.1.69'),
	('C00863','3.1.7.3'),
	('C00864','3.5.1.92'),
	('C00864','3.5.1.22'),
	('C00864','6.3.2.44'),
	('C00864','2.7.1.33'),
	('C00864','6.3.2.1'),
	('C00865','2.3.1.158'),
	('C00868','2.8.1.13'),
	('C00868','2.5.1.25'),
	('C00868','3.5.4.35'),
	('C00868','5.4.99.12'),
	('C00869','1.1.1.98'),
	('C00869','1.1.1.99'),
	('C00870','3.1.3.1'),
	('C00870','3.1.3.41'),
	('C00870','3.1.3.2'),
	('C00870','3.1.8.1'),
	('C00870','1.14.13.29'),
	('C00870','1.14.13.167'),
	('C00872','2.6.1.47'),
	('C00876','1.5.7.2'),
	('C00876','1.5.1.40'),
	('C00876','1.5.3.22'),
	('C00876','1.8.98.3'),
	('C00876','1.5.98.2'),
	('C00876','1.1.98.2'),
	('C00876','1.1.98.4'),
	('C00876','1.1.98.5'),
	('C00876','1.12.98.1'),
	('C00876','6.3.2.34'),
	('C00876','1.2.99.9'),
	('C00876','1.5.98.1'),
	('C00876','6.3.2.32'),
	('C00877','1.3.8.7'),
	('C00877','1.3.8.6'),
	('C00877','1.3.8.1'),
	('C00877','1.3.1.44'),
	('C00877','1.3.1.86'),
	('C00877','1.3.1.85'),
	('C00877','1.3.3.6'),
	('C00877','4.2.1.55'),
	('C00877','4.2.1.120'),
	('C00877','4.1.1.70'),
	('C00877','5.3.3.3'),
	('C00877','4.3.1.14'),
	('C00877','4.2.1.17'),
	('C00878','4.2.1.5'),
	('C00878','3.1.1.30'),
	('C00879','2.3.1.130'),
	('C00879','4.2.1.42'),
	('C00879','4.2.1.158'),
	('C00880','1.1.3.9'),
	('C00880','4.2.1.6'),
	('C00880','4.2.1.140'),
	('C00880','3.1.1.25'),
	('C00881','2.7.1.74'),
	('C00881','3.1.3.5'),
	('C00881','3.5.4.5'),
	('C00881','3.1.3.89'),
	('C00882','2.7.1.24'),
	('C00882','2.7.7.3'),
	('C00882','3.6.1.9'),
	('C00882','2.4.2.52'),
	('C00884','6.3.2.11'),
	('C00884','3.4.13.18'),
	('C00884','3.4.13.20'),
	('C00885','3.3.2.1'),
	('C00885','5.4.4.2'),
	('C00885','4.2.99.21'),
	('C00885','2.2.1.9'),
	('C00886','2.3.2.10'),
	('C00886','6.1.1.7'),
	('C00886','2.3.2.11'),
	('C00887','1.7.1.14'),
	('C00887','1.7.5.2'),
	('C00887','1.7.2.4'),
	('C00887','1.7.2.5'),
	('C00888','2.3.3.12'),
	('C00891','1.1.1.150'),
	('C00891','1.1.1.151'),
	('C00892','1.1.1.151'),
	('C00892','1.1.1.150'),
	('C00894','4.3.1.6'),
	('C00894','4.2.1.17'),
	('C00894','4.2.1.54'),
	('C00894','1.3.8.7'),
	('C00894','1.3.1.95'),
	('C00894','1.3.1.84'),
	('C00894','4.2.1.116'),
	('C00894','2.8.3.12'),
	('C00897','5.1.3.21'),
	('C00898','5.1.2.5'),
	('C00898','4.2.1.32'),
	('C00898','1.1.1.93'),
	('C00898','4.1.1.73'),
	('C00899','1.1.1.315'),
	('C00899','2.3.1.135'),
	('C00899','3.1.1.64'),
	('C00899','3.1.1.63'),
	('C00899','2.3.1.76'),
	('C00900','2.2.1.6'),
	('C00900','1.1.1.86'),
	('C00900','5.4.99.3'),
	('C00902','2.6.1.67'),
	('C00903','1.1.1.195'),
	('C00903','1.2.1.44'),
	('C00904','4.2.1.56'),
	('C00905','5.3.1.12'),
	('C00905','1.1.1.380'),
	('C00905','1.1.1.57'),
	('C00906','1.3.1.1'),
	('C00908','2.3.1.59'),
	('C00909','4.4.1.20'),
	('C00909','3.3.2.6'),
	('C00909','1.13.11.34'),
	('C00911','3.1.3.31'),
	('C00911','3.1.3.6'),
	('C00911','3.1.3.5'),
	('C00916','3.1.1.41'),
	('C00916','1.4.3.3'),
	('C00916','2.3.1.175'),
	('C00916','2.6.1.74'),
	('C00918','2.3.1.28'),
	('C00919','2.8.2.6'),
	('C00919','3.1.6.6'),
	('C00920','1.8.4.3'),
	('C00920','1.8.1.10'),
	('C00921','6.3.2.17'),
	('C00921','2.5.1.15'),
	('C00921','6.3.2.12'),
	('C00922','5.3.3.6'),
	('C00922','4.2.1.85'),
	('C00923','1.17.2.1'),
	('C00923','1.6.2.4'),
	('C00923','1.9.6.1'),
	('C00924','1.6.2.4'),
	('C00924','1.17.2.1'),
	('C00924','1.9.6.1'),
	('C00925','3.2.1.166'),
	('C00927','2.5.1.38'),
	('C00927','5.1.1.14'),
	('C00928','2.8.1.2'),
	('C00931','2.5.1.61'),
	('C00931','4.2.1.24'),
	('C00933','3.1.1.49'),
	('C00933','2.3.1.91'),
	('C00934','3.1.3.23'),
	('C00935','2.7.7.64'),
	('C00935','2.4.2.34'),
	('C00935','5.4.99.30'),
	('C00935','5.4.99.9'),
	('C00935','5.1.3.5'),
	('C00935','4.1.1.67'),
	('C00937','1.2.1.23'),
	('C00937','4.1.2.18'),
	('C00937','1.1.1.77'),
	('C00937','1.1.1.78'),
	('C00937','1.1.1.79'),
	('C00940','3.5.1.111'),
	('C00940','2.6.1.64'),
	('C00940','2.6.1.101'),
	('C00940','2.6.1.100'),
	('C00940','2.6.1.15'),
	('C00940','2.6.1.50'),
	('C00940','3.5.1.3'),
	('C00941','4.6.1.6'),
	('C00942','4.6.1.1'),
	('C00942','3.1.4.35'),
	('C00942','4.6.1.2'),
	('C00942','3.1.4.17'),
	('C00944','1.1.5.8'),
	('C00944','4.2.3.4'),
	('C00944','1.1.1.24'),
	('C00944','1.4.1.24'),
	('C00944','4.2.1.10'),
	('C00944','1.1.1.282'),
	('C00950','2.8.1.5'),
	('C00951','2.8.2.15'),
	('C00951','2.4.1.17'),
	('C00951','1.1.1.51'),
	('C00951','1.14.14.14'),
	('C00951','1.14.14.1'),
	('C00951','1.14.99.11'),
	('C00951','1.1.1.62'),
	('C00954','2.4.1.121'),
	('C00954','6.3.2.20'),
	('C00954','3.5.1.4'),
	('C00954','3.5.5.1'),
	('C00954','1.14.13.168'),
	('C00954','2.1.1.278'),
	('C00954','1.2.3.7'),
	('C00954','1.2.1.3'),
	('C00955','1.1.1.190'),
	('C00955','1.1.1.191'),
	('C00956','2.6.1.39'),
	('C00956','6.3.2.43'),
	('C00956','2.3.1.164'),
	('C00956','1.2.1.31'),
	('C00956','6.3.2.26'),
	('C00957','2.8.1.2'),
	('C00957','2.6.1.1'),
	('C00957','1.1.1.27'),
	('C00957','2.6.1.3'),
	('C00958','3.1.1.4'),
	('C00958','2.7.8.22'),
	('C00958','2.3.1.25'),
	('C00961','2.1.1.109'),
	('C00961','2.1.1.110'),
	('C00963','2.4.1.35'),
	('C00963','3.2.1.21'),
	('C00964','1.1.1.243'),
	('C00964','1.14.13.48'),
	('C00965','2.4.1.97'),
	('C00965','2.4.1.34'),
	('C00965','2.4.1.30'),
	('C00965','3.2.1.58'),
	('C00965','3.2.1.39'),
	('C00966','2.1.2.11'),
	('C00966','1.1.1.169'),
	('C00966','4.1.2.12'),
	('C00969','1.1.1.202'),
	('C00969','4.2.1.30'),
	('C00971','3.1.1.27'),
	('C00971','1.1.1.107'),
	('C00972','2.6.1.57'),
	('C00972','2.6.1.60'),
	('C00973','3.2.1.54'),
	('C00973','2.4.1.19'),
	('C00974','1.14.13.21'),
	('C00974','1.14.13.88'),
	('C00974','1.14.11.9'),
	('C00974','1.1.1.219'),
	('C00974','1.14.11.19'),
	('C00974','1.14.11.23'),
	('C00975','4.1.1.54'),
	('C00975','1.3.1.7'),
	('C00976','1.1.1.132'),
	('C00976','2.4.1.33'),
	('C00977','3.5.1.57'),
	('C00978','2.3.1.87'),
	('C00978','2.1.1.4'),
	('C00979','2.5.1.134'),
	('C00979','2.5.1.119'),
	('C00979','2.5.1.49'),
	('C00979','2.3.1.30'),
	('C00979','2.5.1.47'),
	('C00979','2.6.99.3'),
	('C00979','2.5.1.53'),
	('C00979','2.5.1.52'),
	('C00979','2.5.1.51'),
	('C00979','2.5.1.50'),
	('C00979','2.5.1.65'),
	('C00979','2.5.1.118'),
	('C00980','1.1.3.30'),
	('C00980','1.1.2.6'),
	('C00982','1.13.12.5'),
	('C00982','2.8.2.10'),
	('C00984','2.7.1.6'),
	('C00984','5.1.3.3'),
	('C00986','2.5.1.46'),
	('C00986','2.5.1.45'),
	('C00986','2.5.1.44'),
	('C00986','2.5.1.23'),
	('C00986','4.1.1.86'),
	('C00986','1.5.99.6'),
	('C00986','1.5.1.43'),
	('C00986','1.5.3.15'),
	('C00986','1.5.3.14'),
	('C00986','1.4.3.22'),
	('C00986','1.4.3.21'),
	('C00988','4.1.1.39'),
	('C00988','3.1.3.18'),
	('C00989','1.1.1.61'),
	('C00989','6.2.1.40'),
	('C00990','1.13.12.2'),
	('C00990','3.5.1.30'),
	('C00991','2.7.7.37'),
	('C00991','3.6.1.21'),
	('C00991','3.6.1.45'),
	('C00991','2.7.7.64'),
	('C00991','2.7.7.28'),
	('C00991','2.7.7.36'),
	('C00992','1.16.1.5'),
	('C00992','1.16.1.3'),
	('C00993','6.3.2.10'),
	('C00993','6.3.2.4'),
	('C00993','3.4.13.22'),
	('C00995','1.2.2.1'),
	('C00996','1.14.19.20'),
	('C00996','1.14.19.19'),
	('C00996','1.14.19.18'),
	('C00996','1.14.19.17'),
	('C00996','1.14.19.10'),
	('C00996','1.14.19.1'),
	('C00996','1.14.19.6'),
	('C00996','1.14.19.44'),
	('C00996','1.14.19.39'),
	('C00996','1.14.19.32'),
	('C00996','1.14.18.8'),
	('C00996','1.14.18.7'),
	('C00996','1.14.18.6'),
	('C00996','1.14.18.5'),
	('C00996','1.14.18.4'),
	('C00996','1.14.18.2'),
	('C00996','1.14.19.3'),
	('C00996','1.10.2.1'),
	('C00996','1.6.2.4'),
	('C00996','1.6.2.2'),
	('C00996','1.14.19.29'),
	('C00997','1.7.2.1'),
	('C00997','1.9.3.1'),
	('C00997','1.6.2.5'),
	('C00997','1.8.2.4'),
	('C00998','1.2.2.1'),
	('C00999','1.14.19.39'),
	('C00999','1.14.18.2'),
	('C00999','1.14.18.8'),
	('C00999','1.14.18.4'),
	('C00999','1.14.19.6'),
	('C00999','1.14.19.10'),
	('C00999','1.6.2.4'),
	('C00999','1.14.18.6'),
	('C00999','1.6.2.2'),
	('C00999','1.14.19.32'),
	('C00999','1.14.19.17'),
	('C00999','1.14.19.18'),
	('C00999','1.14.19.19'),
	('C00999','1.14.19.29'),
	('C00999','1.14.18.5'),
	('C00999','1.14.19.3'),
	('C00999','1.14.18.7'),
	('C00999','1.14.19.1'),
	('C00999','1.10.2.1'),
	('C00999','1.14.19.20'),
	('C00999','1.14.19.44'),
	('C01000','1.8.2.4'),
	('C01000','1.9.3.1'),
	('C01000','1.7.2.1'),
	('C01000','1.6.2.5'),
	('C01001','1.2.99.5'),
	('C01001','2.3.1.101'),
	('C01003','3.1.3.53'),
	('C01003','2.7.11.18'),
	('C01004','2.1.1.7'),
	('C01005','3.1.3.3'),
	('C01005','2.7.1.80'),
	('C01005','2.5.1.76'),
	('C01005','2.5.1.65'),
	('C01005','6.1.1.27'),
	('C01005','2.6.1.52'),
	('C01005','2.5.1.113'),
	('C01007','1.5.1.30'),
	('C01007','1.5.1.41'),
	('C01008','2.1.1.19'),
	('C01008','2.1.1.96'),
	('C01010','3.5.1.84'),
	('C01010','3.5.1.54'),
	('C01010','6.3.4.6'),
	('C01011','2.8.3.22'),
	('C01011','2.8.3.11'),
	('C01011','4.2.1.56'),
	('C01011','4.2.1.153'),
	('C01011','4.1.3.25'),
	('C01012','1.1.1.214'),
	('C01012','1.1.99.27'),
	('C01012','1.1.1.358'),
	('C01012','1.1.1.168'),
	('C01013','1.1.1.298'),
	('C01013','3.1.2.4'),
	('C01013','1.1.1.59'),
	('C01013','6.2.1.36'),
	('C01019','5.3.1.25'),
	('C01019','2.7.1.52'),
	('C01019','5.3.1.3'),
	('C01019','3.2.1.63'),
	('C01019','3.2.1.51'),
	('C01019','1.1.1.122'),
	('C01020','1.17.1.5'),
	('C01020','1.17.3.3'),
	('C01020','1.14.13.114'),
	('C01020','1.3.7.1'),
	('C01020','1.17.2.1'),
	('C01021','2.6.1.60'),
	('C01021','2.6.1.57'),
	('C01021','3.5.1.114'),
	('C01022','2.7.11.17'),
	('C01022','3.1.3.55'),
	('C01024','2.5.1.61'),
	('C01024','4.2.1.75'),
	('C01025','1.11.1.12'),
	('C01025','1.11.2.3'),
	('C01026','2.1.1.157'),
	('C01026','2.1.1.161'),
	('C01026','2.1.1.162'),
	('C01026','1.5.8.4'),
	('C01026','2.1.1.156'),
	('C01026','2.1.1.5'),
	('C01026','1.5.3.10'),
	('C01028','2.3.1.102'),
	('C01028','1.14.13.59'),
	('C01029','3.5.1.48'),
	('C01029','1.5.3.15'),
	('C01031','3.1.2.12'),
	('C01031','1.1.1.284'),
	('C01033','1.3.99.12'),
	('C01033','1.3.8.5'),
	('C01034','1.1.1.145'),
	('C01034','5.3.3.1'),
	('C01035','3.5.1.4'),
	('C01035','1.2.1.54'),
	('C01035','3.5.3.7'),
	('C01035','2.1.4.1'),
	('C01036','1.13.11.5'),
	('C01036','5.2.1.2'),
	('C01037','6.3.3.3'),
	('C01037','2.6.1.62'),
	('C01037','2.6.1.105'),
	('C01040','3.1.1.17'),
	('C01040','3.1.1.25'),
	('C01040','1.1.1.20'),
	('C01040','1.1.3.8'),
	('C01041','1.11.1.11'),
	('C01041','1.10.2.1'),
	('C01041','1.6.5.4'),
	('C01041','1.16.5.1'),
	('C01042','6.3.2.42'),
	('C01042','3.5.1.15'),
	('C01042','6.3.2.41'),
	('C01042','3.4.17.21'),
	('C01042','2.3.1.17'),
	('C01043','3.5.2.14'),
	('C01043','3.5.1.59'),
	('C01044','3.5.1.15'),
	('C01044','3.5.3.5'),
	('C01044','3.5.1.8'),
	('C01045','3.5.3.13'),
	('C01045','3.5.1.68'),
	('C01045','2.1.2.5'),
	('C01046','1.5.99.5'),
	('C01046','2.1.1.21'),
	('C01047','6.3.1.6'),
	('C01047','3.5.1.65'),
	('C01048','2.4.1.78'),
	('C01050','1.3.1.98'),
	('C01050','6.3.2.8'),
	('C01050','6.3.2.45'),
	('C01051','4.1.1.37'),
	('C01051','2.1.1.107'),
	('C01051','4.2.1.75'),
	('C01053','1.2.1.33'),
	('C01053','1.1.1.106'),
	('C01054','5.4.99.57'),
	('C01054','5.4.99.7'),
	('C01054','5.4.99.8'),
	('C01054','5.4.99.31'),
	('C01054','5.4.99.32'),
	('C01054','5.4.99.33'),
	('C01054','5.4.99.34'),
	('C01054','5.4.99.35'),
	('C01054','5.4.99.36'),
	('C01054','5.4.99.39'),
	('C01054','5.4.99.40'),
	('C01054','5.4.99.41'),
	('C01054','5.4.99.46'),
	('C01054','5.4.99.47'),
	('C01054','5.4.99.48'),
	('C01054','5.4.99.49'),
	('C01054','5.4.99.50'),
	('C01054','5.4.99.56'),
	('C01054','5.4.99.55'),
	('C01054','5.4.99.54'),
	('C01054','5.4.99.53'),
	('C01054','5.4.99.52'),
	('C01054','4.2.1.128'),
	('C01054','4.2.1.125'),
	('C01054','4.2.1.124'),
	('C01054','5.4.99.51'),
	('C01054','5.4.99.38'),
	('C01054','1.14.14.17'),
	('C01056','1.5.99.4'),
	('C01056','1.5.3.5'),
	('C01058','1.14.15.4'),
	('C01058','1.1.1.146'),
	('C01059','1.14.13.163'),
	('C01059','1.13.11.9'),
	('C01059','1.14.99.26'),
	('C01059','1.14.13.114'),
	('C01060','2.6.1.24'),
	('C01060','1.11.1.8'),
	('C01060','1.21.1.1'),
	('C01061','5.2.1.2'),
	('C01061','3.7.1.2'),
	('C01062','1.1.1.264'),
	('C01062','1.1.1.69'),
	('C01062','1.1.1.366'),
	('C01062','1.1.1.215'),
	('C01063','2.3.1.47'),
	('C01063','6.2.1.14'),
	('C01063','1.3.1.62'),
	('C01064','3.1.4.40'),
	('C01064','2.7.7.43'),
	('C01066','1.1.99.26'),
	('C01066','3.7.1.10'),
	('C01068','1.1.1.137'),
	('C01068','2.7.7.40'),
	('C01069','2.8.2.24'),
	('C01069','2.4.1.195'),
	('C01070','1.1.2.5'),
	('C01070','1.2.2.3'),
	('C01071','1.2.2.3'),
	('C01071','1.1.2.5'),
	('C01073','3.5.1.21'),
	('C01074','3.2.1.35'),
	('C01075','3.1.6.11'),
	('C01075','3.10.1.1'),
	('C01077','2.5.1.49'),
	('C01077','2.5.1.48'),
	('C01077','2.3.1.31'),
	('C01078','1.14.11.7'),
	('C01078','1.14.11.2'),
	('C01079','1.3.3.4'),
	('C01079','1.3.3.3'),
	('C01079','1.3.98.3'),
	('C01079','1.3.5.3'),
	('C01080','1.1.98.4'),
	('C01080','1.5.98.2'),
	('C01080','1.5.3.22'),
	('C01080','1.1.98.2'),
	('C01080','1.5.1.40'),
	('C01080','1.1.98.5'),
	('C01080','1.2.99.9'),
	('C01080','1.5.98.1'),
	('C01080','1.5.7.2'),
	('C01080','1.8.98.3'),
	('C01080','1.12.98.1'),
	('C01081','2.5.1.3'),
	('C01081','3.1.3.1'),
	('C01081','3.1.3.2'),
	('C01081','3.1.3.100'),
	('C01081','3.6.1.15'),
	('C01081','2.7.4.16'),
	('C01081','2.7.1.89'),
	('C01083','2.4.1.245'),
	('C01083','2.4.1.231'),
	('C01083','2.4.1.64'),
	('C01083','2.3.1.122'),
	('C01083','3.2.1.141'),
	('C01083','3.1.3.12'),
	('C01083','2.8.2.37'),
	('C01083','2.7.1.201'),
	('C01083','5.4.99.16'),
	('C01083','3.2.1.28'),
	('C01086','1.1.1.36'),
	('C01086','4.2.1.119'),
	('C01086','4.2.1.17'),
	('C01087','1.1.1.399'),
	('C01087','1.1.99.39'),
	('C01087','1.1.99.24'),
	('C01088','1.1.1.84'),
	('C01088','1.2.1.33'),
	('C01089','3.1.1.22'),
	('C01089','1.1.1.30'),
	('C01090','1.1.1.147'),
	('C01090','5.1.99.2'),
	('C01091','1.14.11.20'),
	('C01091','2.3.1.107'),
	('C01091','2.1.1.94'),
	('C01092','2.3.1.47'),
	('C01092','2.6.1.105'),
	('C01092','2.6.1.62'),
	('C01093','1.1.99.18'),
	('C01094','2.7.1.202'),
	('C01094','2.7.1.3'),
	('C01094','2.7.1.56'),
	('C01094','2.2.1.11'),
	('C01094','3.1.3.68'),
	('C01094','4.1.2.13'),
	('C01094','2.7.1.61'),
	('C01096','2.7.1.198'),
	('C01096','1.1.1.200'),
	('C01096','2.7.1.1'),
	('C01096','1.1.1.140'),
	('C01096','3.1.3.50'),
	('C01097','2.7.1.101'),
	('C01097','2.7.1.144'),
	('C01097','2.7.1.11'),
	('C01097','5.3.1.26'),
	('C01097','2.7.1.56'),
	('C01097','1.1.1.251'),
	('C01099','2.7.1.51'),
	('C01099','4.1.2.17'),
	('C01100','2.6.1.9'),
	('C01100','3.1.3.15'),
	('C01101','2.7.1.16'),
	('C01101','5.1.3.22'),
	('C01101','5.1.3.4'),
	('C01102','4.2.3.1'),
	('C01102','2.7.1.39'),
	('C01103','2.4.2.10'),
	('C01103','4.1.1.23'),
	('C01104','1.6.6.9'),
	('C01104','1.14.13.148'),
	('C01104','4.1.2.32'),
	('C01107','2.7.1.36'),
	('C01107','4.1.1.99'),
	('C01107','2.7.4.2'),
	('C01108','1.97.1.2'),
	('C01108','4.1.1.59'),
	('C01108','1.13.11.35'),
	('C01109','6.3.1.7'),
	('C01109','3.5.1.67'),
	('C01110','2.6.1.8'),
	('C01110','1.4.3.3'),
	('C01110','2.6.1.21'),
	('C01111','1.3.1.18'),
	('C01111','1.13.11.10'),
	('C01112','5.3.1.13'),
	('C01112','2.7.1.54'),
	('C01112','2.5.1.55'),
	('C01113','3.2.1.85'),
	('C01113','5.3.1.26'),
	('C01113','2.7.1.204'),
	('C01114','3.1.1.15'),
	('C01114','1.1.1.376'),
	('C01114','1.1.1.46'),
	('C01115','1.1.1.122'),
	('C01115','1.3.2.3'),
	('C01115','1.3.3.12'),
	('C01115','1.1.1.316'),
	('C01117','3.1.4.17'),
	('C01117','2.7.1.77'),
	('C01117','2.7.6.4'),
	('C01117','3.1.3.97'),
	('C01117','3.6.1.5'),
	('C01118','2.3.1.46'),
	('C01118','2.5.1.48'),
	('C01119','1.17.4.5'),
	('C01119','1.17.4.4'),
	('C01120','3.1.3.4'),
	('C01120','2.7.1.91'),
	('C01120','4.1.2.27'),
	('C01121','2.4.2.27'),
	('C01122','4.2.1.17'),
	('C01122','1.3.1.37'),
	('C01123','1.14.13.47'),
	('C01123','1.1.1.223'),
	('C01124','1.14.15.5'),
	('C01124','1.14.15.4'),
	('C01125','1.1.99.27'),
	('C01125','1.1.1.214'),
	('C01125','1.1.1.168'),
	('C01125','1.1.1.358'),
	('C01126','1.1.1.216'),
	('C01126','3.1.7.6'),
	('C01126','5.2.1.9'),
	('C01126','1.1.1.354'),
	('C01127','2.6.1.23'),
	('C01127','4.1.3.42'),
	('C01127','4.1.3.16'),
	('C01131','2.7.1.5'),
	('C01131','4.1.2.19'),
	('C01132','2.7.1.157'),
	('C01132','2.7.1.162'),
	('C01132','3.2.1.52'),
	('C01132','3.2.1.49'),
	('C01133','1.1.1.240'),
	('C01133','1.1.3.29'),
	('C01134','3.1.4.14'),
	('C01134','2.7.1.33'),
	('C01134','2.7.1.34'),
	('C01134','2.7.7.3'),
	('C01134','4.1.1.36'),
	('C01134','2.3.1.49'),
	('C01134','3.6.1.9'),
	('C01137','2.5.1.128'),
	('C01137','2.5.1.127'),
	('C01137','2.5.1.126'),
	('C01137','2.5.1.16'),
	('C01137','2.5.1.23'),
	('C01137','2.5.1.22'),
	('C01137','2.5.1.79'),
	('C01137','4.1.1.50'),
	('C01137','2.5.1.104'),
	('C01138','3.1.3.39'),
	('C01138','2.7.1.72'),
	('C01139','2.7.11.27'),
	('C01139','3.1.3.44'),
	('C01140','2.4.1.113'),
	('C01141','2.7.11.15'),
	('C01142','5.4.3.3'),
	('C01142','5.4.3.2'),
	('C01143','4.1.1.33'),
	('C01143','2.7.4.2'),
	('C01144','5.3.3.20'),
	('C01144','5.1.2.3'),
	('C01144','4.2.1.17'),
	('C01144','1.1.1.35'),
	('C01144','1.1.1.157'),
	('C01146','5.3.1.22'),
	('C01146','4.1.2.20'),
	('C01146','4.1.1.47'),
	('C01146','4.1.1.54'),
	('C01146','1.1.1.60'),
	('C01147','1.14.13.22'),
	('C01147','1.1.1.174'),
	('C01147','1.14.13.66'),
	('C01149','1.2.1.47'),
	('C01149','1.2.1.3'),
	('C01151','5.3.1.29'),
	('C01151','3.1.4.55'),
	('C01151','2.7.1.18'),
	('C01151','2.7.4.23'),
	('C01151','2.4.2.57'),
	('C01152','3.4.13.5'),
	('C01152','6.3.2.11'),
	('C01152','3.4.13.20'),
	('C01153','3.1.3.1'),
	('C01153','3.1.3.2'),
	('C01155','2.8.2.26'),
	('C01155','2.8.2.28'),
	('C01156','2.8.2.27'),
	('C01156','2.8.2.28'),
	('C01157','5.1.1.8'),
	('C01157','1.14.11.2'),
	('C01157','1.1.1.104'),
	('C01157','1.5.1.2'),
	('C01158','2.4.1.136'),
	('C01158','2.3.1.90'),
	('C01158','2.3.1.143'),
	('C01159','3.1.3.80'),
	('C01159','5.4.2.11'),
	('C01159','5.4.2.4'),
	('C01161','1.13.11.15'),
	('C01161','1.2.1.5'),
	('C01161','1.2.1.29'),
	('C01161','1.14.14.9'),
	('C01161','1.14.12.9'),
	('C01161','2.1.1.6'),
	('C01162','4.2.1.50'),
	('C01162','2.5.1.51'),
	('C01163','5.5.1.5'),
	('C01163','5.5.1.2'),
	('C01163','1.13.11.3'),
	('C01164','1.3.1.21'),
	('C01164','1.14.19.21'),
	('C01164','1.14.19.20'),
	('C01164','1.3.1.72'),
	('C01165','1.2.1.88'),
	('C01165','2.6.1.13'),
	('C01165','1.2.1.41'),
	('C01166','1.1.2.6'),
	('C01166','1.1.3.30'),
	('C01167','2.7.10.2'),
	('C01167','2.7.12.1'),
	('C01167','2.7.10.1'),
	('C01167','3.1.3.48'),
	('C01167','2.7.12.2'),
	('C01168','4.2.1.70'),
	('C01168','2.7.1.83'),
	('C01168','3.1.3.96'),
	('C01170','1.1.1.336'),
	('C01170','2.4.1.187'),
	('C01170','5.1.3.14'),
	('C01171','2.7.7.28'),
	('C01171','2.7.1.62'),
	('C01171','5.4.2.2'),
	('C01172','5.3.1.9'),
	('C01172','5.4.2.6'),
	('C01172','5.1.3.15'),
	('C01172','2.7.1.63'),
	('C01172','1.1.1.363'),
	('C01172','1.1.1.388'),
	('C01172','1.1.1.49'),
	('C01172','2.7.1.1'),
	('C01172','2.7.1.147'),
	('C01172','2.7.1.2'),
	('C01172','3.2.1.86'),
	('C01173','4.2.1.94'),
	('C01173','1.1.1.252'),
	('C01175','2.3.1.91'),
	('C01175','2.4.1.299'),
	('C01175','2.3.1.103'),
	('C01175','2.4.1.120'),
	('C01175','2.4.1.126'),
	('C01175','2.3.1.92'),
	('C01176','5.3.3.1'),
	('C01176','1.14.14.19'),
	('C01176','1.14.14.32'),
	('C01176','1.14.14.16'),
	('C01176','1.1.1.145'),
	('C01176','1.1.1.149'),
	('C01176','1.14.13.54'),
	('C01176','1.14.15.4'),
	('C01177','2.7.1.64'),
	('C01177','3.1.3.25'),
	('C01177','3.1.4.43'),
	('C01177','3.1.4.11'),
	('C01177','3.1.4.3'),
	('C01177','3.1.3.64'),
	('C01177','4.6.1.13'),
	('C01179','2.6.1.9'),
	('C01179','1.4.3.2'),
	('C01179','2.5.1.111'),
	('C01179','1.13.11.46'),
	('C01179','1.1.1.237'),
	('C01179','2.5.1.77'),
	('C01179','2.6.1.103'),
	('C01179','2.6.1.1'),
	('C01179','2.6.1.5'),
	('C01179','4.1.1.80'),
	('C01179','2.6.1.58'),
	('C01179','2.6.1.57'),
	('C01179','1.1.1.222'),
	('C01179','5.3.2.1'),
	('C01179','1.3.1.12'),
	('C01179','1.3.1.13'),
	('C01179','1.2.3.13'),
	('C01179','1.4.1.20'),
	('C01179','1.13.11.27'),
	('C01180','2.6.1.57'),
	('C01180','2.6.1.88'),
	('C01180','2.6.1.41'),
	('C01180','2.6.1.5'),
	('C01180','1.13.11.54'),
	('C01180','1.4.3.2'),
	('C01180','2.6.1.73'),
	('C01181','1.2.1.3'),
	('C01181','2.8.3.21'),
	('C01181','1.2.1.47'),
	('C01181','1.14.11.1'),
	('C01182','5.3.1.29'),
	('C01182','4.1.1.39'),
	('C01182','2.7.1.19'),
	('C01183','4.1.2.24'),
	('C01183','1.14.13.8'),
	('C01185','3.6.1.22'),
	('C01185','3.1.3.5'),
	('C01185','3.5.1.42'),
	('C01185','2.4.2.21'),
	('C01185','2.4.2.19'),
	('C01185','2.4.2.55'),
	('C01185','3.6.1.9'),
	('C01185','2.7.7.18'),
	('C01185','2.7.7.1'),
	('C01185','2.7.1.173'),
	('C01185','6.3.4.21'),
	('C01186','1.4.1.11'),
	('C01186','5.4.3.3'),
	('C01187','2.7.7.38'),
	('C01187','3.2.1.144'),
	('C01187','4.1.2.23'),
	('C01187','3.1.3.45'),
	('C01188','1.1.1.31'),
	('C01188','3.1.2.4'),
	('C01189','5.3.3.5'),
	('C01189','1.1.1.270'),
	('C01189','1.14.13.72'),
	('C01189','1.1.1.170'),
	('C01189','1.3.1.72'),
	('C01189','1.14.19.20'),
	('C01190','3.2.1.62'),
	('C01190','2.4.1.274'),
	('C01190','3.2.1.23'),
	('C01190','3.2.1.45'),
	('C01190','2.4.1.80'),
	('C01191','2.4.2.32'),
	('C01191','2.4.2.33'),
	('C01192','1.1.1.101'),
	('C01194','3.1.4.11'),
	('C01194','3.1.4.3'),
	('C01194','3.1.1.52'),
	('C01194','3.1.3.67'),
	('C01194','3.1.3.64'),
	('C01194','2.7.8.11'),
	('C01194','2.7.1.67'),
	('C01194','4.6.1.13'),
	('C01194','2.4.1.198'),
	('C01194','2.7.1.154'),
	('C01194','2.7.1.150'),
	('C01194','2.7.1.137'),
	('C01197','2.1.1.68'),
	('C01197','6.2.1.12'),
	('C01197','3.1.1.42'),
	('C01197','1.14.18.1'),
	('C01197','2.8.3.23'),
	('C01197','1.13.11.22'),
	('C01197','4.1.1.102'),
	('C01198','3.1.1.35'),
	('C01198','1.3.1.11'),
	('C01198','1.14.13.4'),
	('C01200','3.1.3.29'),
	('C01200','2.5.1.57'),
	('C01201','3.2.2.19'),
	('C01203','3.1.2.14'),
	('C01203','1.14.19.2'),
	('C01204','2.7.4.24'),
	('C01204','2.7.1.158'),
	('C01204','3.1.3.62'),
	('C01204','3.1.3.26'),
	('C01204','3.1.3.72'),
	('C01204','2.7.4.21'),
	('C01204','3.6.1.52'),
	('C01204','3.1.3.8'),
	('C01205','3.5.1.6'),
	('C01205','2.6.1.40'),
	('C01207','1.1.1.237'),
	('C01207','2.3.1.140'),
	('C01209','4.1.1.87'),
	('C01209','2.3.1.187'),
	('C01209','2.3.1.41'),
	('C01209','2.3.1.85'),
	('C01209','2.1.1.197'),
	('C01209','2.1.3.10'),
	('C01209','2.3.1.86'),
	('C01209','2.3.1.180'),
	('C01209','2.3.1.179'),
	('C01209','2.3.1.199'),
	('C01209','2.3.1.39'),
	('C01209','2.3.1.207'),
	('C01210','2.1.1.103'),
	('C01210','2.7.7.57'),
	('C01211','1.14.11.4'),
	('C01211','2.4.1.50'),
	('C01212','6.3.2.8'),
	('C01212','6.3.2.9'),
	('C01213','5.1.99.1'),
	('C01213','5.4.99.2'),
	('C01214','2.6.1.50'),
	('C01214','2.7.1.65'),
	('C01215','1.14.12.4'),
	('C01215','3.5.1.29'),
	('C01216','4.2.1.140'),
	('C01216','4.1.2.51'),
	('C01216','4.1.2.55'),
	('C01216','4.2.1.6'),
	('C01216','2.7.1.58'),
	('C01216','2.7.1.178'),
	('C01217','1.5.99.15'),
	('C01217','4.2.1.147'),
	('C01217','1.5.1.47'),
	('C01217','6.3.2.33'),
	('C01217','2.3.1.101'),
	('C01217','2.1.1.86'),
	('C01217','2.1.2.1'),
	('C01218','1.1.1.43'),
	('C01218','2.7.1.13'),
	('C01219','4.2.1.45'),
	('C01219','1.17.1.1'),
	('C01220','3.1.4.11'),
	('C01220','3.1.3.56'),
	('C01220','3.1.3.57'),
	('C01221','2.7.1.88'),
	('C01222','2.6.1.102'),
	('C01222','1.1.1.135'),
	('C01222','1.1.1.281'),
	('C01222','1.1.1.271'),
	('C01222','4.2.1.47'),
	('C01222','1.1.1.187'),
	('C01225','3.1.4.44'),
	('C01225','3.1.4.43'),
	('C01226','1.3.1.42'),
	('C01226','5.3.99.6'),
	('C01227','1.1.1.51'),
	('C01227','1.1.1.145'),
	('C01227','3.1.6.2'),
	('C01227','2.8.2.2'),
	('C01227','5.3.3.1'),
	('C01227','1.14.14.32'),
	('C01227','1.14.14.1'),
	('C01227','1.14.14.23'),
	('C01228','3.1.7.2'),
	('C01228','3.6.1.40'),
	('C01228','3.6.1.11'),
	('C01229','2.1.1.79'),
	('C01229','2.1.1.16'),
	('C01230','2.5.1.82'),
	('C01230','2.5.1.83'),
	('C01230','2.5.1.39'),
	('C01231','2.7.1.10'),
	('C01231','2.7.1.41'),
	('C01231','2.7.1.106'),
	('C01233','3.1.4.46'),
	('C01233','3.1.4.2'),
	('C01233','3.1.1.5'),
	('C01233','3.3.2.2'),
	('C01234','3.5.99.7'),
	('C01234','4.4.1.14'),
	('C01234','1.14.17.4'),
	('C01235','2.4.1.82'),
	('C01235','2.4.1.67'),
	('C01235','2.4.1.123'),
	('C01235','3.2.1.22'),
	('C01236','1.1.1.49'),
	('C01236','1.1.1.388'),
	('C01236','1.1.1.363'),
	('C01236','1.1.98.2'),
	('C01236','3.1.1.31'),
	('C01239','3.5.1.26'),
	('C01239','3.5.1.52'),
	('C01240','3.1.4.37'),
	('C01240','3.1.4.16'),
	('C01241','2.1.1.16'),
	('C01241','2.1.1.17'),
	('C01241','2.1.1.71'),
	('C01242','2.1.2.10'),
	('C01242','1.4.4.2'),
	('C01243','3.1.3.56'),
	('C01243','3.1.3.66'),
	('C01243','2.7.1.159'),
	('C01243','3.1.3.57'),
	('C01244','1.1.1.96'),
	('C01244','2.6.1.24'),
	('C01245','3.1.3.56'),
	('C01245','3.1.4.11'),
	('C01245','3.1.3.62'),
	('C01245','2.7.1.151'),
	('C01245','2.7.1.127'),
	('C01246','3.1.4.48'),
	('C01246','2.4.1.117'),
	('C01247','3.1.3.44'),
	('C01247','2.7.11.27'),
	('C01249','1.3.1.18'),
	('C01249','1.14.99.2'),
	('C01250','1.2.1.38'),
	('C01250','2.6.1.11'),
	('C01251','4.2.1.114'),
	('C01251','2.3.3.14'),
	('C01252','2.6.1.63'),
	('C01252','2.6.1.7'),
	('C01253','2.4.2.37'),
	('C01253','3.2.2.24'),
	('C01255','3.5.1.117'),
	('C01255','3.5.1.46'),
	('C01255','3.5.2.12'),
	('C01256','3.1.3.43'),
	('C01256','2.7.11.2'),
	('C01259','1.14.11.8'),
	('C01260','2.7.7.53'),
	('C01260','3.6.1.17'),
	('C01260','3.6.1.61'),
	('C01260','3.6.1.41'),
	('C01261','3.6.1.17'),
	('C01261','2.7.7.45'),
	('C01262','6.3.2.11'),
	('C01262','3.4.13.20'),
	('C01262','3.4.13.5'),
	('C01262','2.1.1.22'),
	('C01263','1.14.13.28'),
	('C01263','2.5.1.36'),
	('C01264','3.1.3.59'),
	('C01264','2.3.1.105'),
	('C01265','2.1.1.83'),
	('C01265','2.1.1.82'),
	('C01267','4.2.1.19'),
	('C01267','2.6.1.9'),
	('C01268','1.1.1.193'),
	('C01268','3.5.4.26'),
	('C01269','2.5.1.19'),
	('C01269','4.2.3.5'),
	('C01270','1.14.12.4'),
	('C01270','4.1.1.51'),
	('C01271','4.2.1.59'),
	('C01271','1.1.1.100'),
	('C01271','1.1.1.212'),
	('C01272','3.1.3.62'),
	('C01272','2.7.1.159'),
	('C01272','3.1.3.56'),
	('C01272','2.7.1.151'),
	('C01272','2.7.1.127'),
	('C01273','1.13.11.39'),
	('C01273','3.7.1.8'),
	('C01273','1.3.1.40'),
	('C01274','3.5.4.27'),
	('C01274','2.3.1.101'),
	('C01275','1.13.11.38'),
	('C01275','4.1.2.34'),
	('C01277','3.1.4.11'),
	('C01277','3.1.3.36'),
	('C01277','2.7.1.68'),
	('C01277','2.7.1.67'),
	('C01277','2.7.1.154'),
	('C01277','3.1.3.64'),
	('C01278','4.1.1.44'),
	('C01278','5.5.1.2'),
	('C01279','3.5.99.2'),
	('C01279','2.7.1.49'),
	('C01280','2.7.1.88'),
	('C01281','2.7.7.42'),
	('C01281','2.7.7.89'),
	('C01282','1.14.18.4'),
	('C01283','2.1.4.2'),
	('C01283','2.7.1.65'),
	('C01284','2.7.1.134'),
	('C01284','2.7.1.140'),
	('C01284','2.7.1.151'),
	('C01284','2.7.1.158'),
	('C01286','4.1.2.21'),
	('C01286','4.1.2.55'),
	('C01286','2.7.1.178'),
	('C01286','2.7.1.58'),
	('C01288','3.5.1.89'),
	('C01288','2.4.1.198'),
	('C01289','2.4.1.305'),
	('C01289','5.1.3.26'),
	('C01289','2.4.1.187'),
	('C01289','2.7.8.33'),
	('C01289','2.4.1.188'),
	('C01289','2.4.1.304'),
	('C01289','2.4.1.303'),
	('C01289','2.4.1.180'),
	('C01290','2.4.1.92'),
	('C01290','2.4.99.11'),
	('C01290','3.2.1.23'),
	('C01290','3.2.1.22'),
	('C01290','3.2.1.18'),
	('C01290','3.2.1.52'),
	('C01290','2.4.99.9'),
	('C01290','2.4.1.228'),
	('C01290','2.4.1.274'),
	('C01290','3.2.1.47'),
	('C01290','2.4.1.206'),
	('C01291','6.4.1.5'),
	('C01291','4.2.1.57'),
	('C01292','1.1.1.176'),
	('C01292','1.1.1.238'),
	('C01293','3.1.3.43'),
	('C01293','2.7.11.2'),
	('C01294','3.1.3.40'),
	('C01294','2.1.4.2'),
	('C01295','1.1.1.143'),
	('C01295','1.1.1.142'),
	('C01297','1.5.3.6'),
	('C01297','1.5.99.14'),
	('C01297','1.5.3.5'),
	('C01298','2.6.1.56'),
	('C01299','2.7.7.89'),
	('C01299','2.7.7.42'),
	('C01300','2.7.6.3'),
	('C01300','2.5.1.15'),
	('C01300','4.1.2.25'),
	('C01301','1.14.15.15'),
	('C01302','5.3.1.24'),
	('C01302','4.1.1.48'),
	('C01304','3.5.4.25'),
	('C01304','3.5.4.26'),
	('C01304','3.5.1.102'),
	('C01304','4.2.1.160'),
	('C01304','1.1.1.302'),
	('C01306','2.4.1.148'),
	('C01306','2.4.1.147'),
	('C01308','3.1.3.52'),
	('C01308','2.7.11.4'),
	('C01310','3.1.6.10'),
	('C01310','3.1.6.9'),
	('C01311','2.4.1.152'),
	('C01312','5.3.99.4'),
	('C01312','1.1.1.231'),
	('C01319','1.16.1.1'),
	('C01322','2.5.1.18'),
	('C01324','3.8.1.1'),
	('C01324','1.3.1.32'),
	('C01326','4.2.1.66'),
	('C01326','1.14.13.50'),
	('C01326','4.1.2.11'),
	('C01326','4.1.2.10'),
	('C01326','4.1.2.46'),
	('C01326','4.4.1.9'),
	('C01326','2.8.1.2'),
	('C01326','2.5.1.18'),
	('C01326','1.4.99.5'),
	('C01327','1.11.1.10'),
	('C01327','3.8.1.2'),
	('C01327','5.5.1.11'),
	('C01327','3.8.1.5'),
	('C01327','2.5.1.18'),
	('C01327','5.5.1.1'),
	('C01327','1.14.12.9'),
	('C01327','3.8.1.8'),
	('C01327','4.5.1.3'),
	('C01327','4.5.1.2'),
	('C01327','4.5.1.1'),
	('C01327','3.5.4.43'),
	('C01327','1.14.12.11'),
	('C01327','1.97.1.8'),
	('C01327','3.8.1.3'),
	('C01327','1.14.99.39'),
	('C01327','1.21.1.2'),
	('C01327','1.3.1.32'),
	('C01327','5.5.1.7'),
	('C01328','1.8.99.5'),
	('C01328','3.5.5.8'),
	('C01329','2.7.4.4'),
	('C01334','1.11.1.10'),
	('C01335','2.4.1.17'),
	('C01335','3.2.1.21'),
	('C01335','3.2.1.25'),
	('C01335','2.4.1.35'),
	('C01335','1.14.14.1'),
	('C01335','1.11.2.1'),
	('C01335','1.11.1.15'),
	('C01336','4.4.1.13'),
	('C01343','4.99.1.2'),
	('C01344','3.6.1.64'),
	('C01344','2.7.4.6'),
	('C01345','2.7.4.6'),
	('C01345','3.6.1.66'),
	('C01346','2.7.4.6'),
	('C01346','2.7.4.9'),
	('C01346','3.6.1.39'),
	('C01346','2.7.4.4'),
	('C01346','1.17.4.1'),
	('C01346','2.7.1.48'),
	('C01352','1.1.98.3'),
	('C01352','1.1.99.13'),
	('C01352','1.1.99.2'),
	('C01352','1.1.99.21'),
	('C01352','1.1.99.3'),
	('C01352','1.1.5.3'),
	('C01352','1.1.5.4'),
	('C01352','1.14.19.9'),
	('C01352','1.14.14.8'),
	('C01352','1.14.14.15'),
	('C01352','1.14.14.18'),
	('C01352','1.14.14.27'),
	('C01352','1.14.14.11'),
	('C01352','1.3.8.8'),
	('C01352','1.3.8.9'),
	('C01352','1.3.8.1'),
	('C01352','1.3.8.2'),
	('C01352','1.3.8.4'),
	('C01352','1.3.8.6'),
	('C01352','1.3.8.7'),
	('C01352','1.3.3.6'),
	('C01352','1.8.99.2'),
	('C01352','1.6.6.9'),
	('C01352','1.5.99.3'),
	('C01352','1.5.1.45'),
	('C01352','1.5.1.30'),
	('C01352','1.5.1.37'),
	('C01352','2.1.1.74'),
	('C01353','4.2.1.1'),
	('C01353','3.5.2.15'),
	('C01355','3.2.1.80'),
	('C01356','1.11.1.12'),
	('C01359','1.2.5.2'),
	('C01359','1.1.5.8'),
	('C01367','3.1.3.6'),
	('C01367','3.1.4.16'),
	('C01368','3.1.4.16'),
	('C01368','3.1.3.6'),
	('C01370','1.1.1.21'),
	('C01371','1.11.1.10'),
	('C01371','4.99.1.2'),
	('C01371','4.1.99.5'),
	('C01371','1.11.2.1'),
	('C01371','1.11.1.18'),
	('C01371','1.14.14.1'),
	('C01371','1.14.15.3'),
	('C01372','1.14.13.25'),
	('C01378','1.14.13.21'),
	('C01378','1.14.11.9'),
	('C01378','1.1.1.219'),
	('C01380','1.1.1.77'),
	('C01380','3.3.2.10'),
	('C01382','1.11.1.8'),
	('C01384','3.5.1.107'),
	('C01384','4.2.1.31'),
	('C01384','3.7.1.23'),
	('C01384','5.2.1.1'),
	('C01387','1.14.15.3'),
	('C01389','2.7.1.182'),
	('C01389','3.1.1.14'),
	('C01392','6.3.2.25'),
	('C01394','1.1.3.41'),
	('C01401','3.5.5.1'),
	('C01402','3.5.1.13'),
	('C01403','2.1.1.25'),
	('C01405','3.1.1.55'),
	('C01407','1.14.12.3'),
	('C01408','4.1.2.38'),
	('C01412','1.2.1.57'),
	('C01412','1.2.1.10'),
	('C01412','1.2.1.87'),
	('C01412','1.1.2.9'),
	('C01412','1.1.5.11'),
	('C01414','4.2.3.8'),
	('C01416','3.1.1.84'),
	('C01416','3.1.1.1'),
	('C01417','4.2.1.104'),
	('C01418','2.4.1.171'),
	('C01419','3.4.11.2'),
	('C01419','3.4.11.1'),
	('C01419','3.4.19.13'),
	('C01419','2.3.2.2'),
	('C01419','3.4.11.23'),
	('C01420','1.8.4.4'),
	('C01421','2.4.1.104'),
	('C01424','1.13.11.8'),
	('C01424','2.4.1.136'),
	('C01424','1.13.11.3'),
	('C01424','4.1.1.59'),
	('C01424','3.1.1.20'),
	('C01424','1.13.11.57'),
	('C01433','1.14.13.74'),
	('C01433','1.3.3.9'),
	('C01433','2.1.1.50'),
	('C01438','1.14.18.3'),
	('C01438','1.14.13.25'),
	('C01438','4.7.1.1'),
	('C01438','4.99.1.2'),
	('C01438','2.8.4.1'),
	('C01441','2.4.2.49'),
	('C01441','2.6.1.93'),
	('C01441','2.4.1.301'),
	('C01444','2.1.3.5'),
	('C01448','2.1.1.283'),
	('C01448','1.14.13.43'),
	('C01449','2.4.2.29'),
	('C01450','1.1.98.5'),
	('C01450','1.7.3.1'),
	('C01450','4.1.2.10'),
	('C01450','4.1.2.11'),
	('C01450','1.1.1.1'),
	('C01450','4.1.2.46'),
	('C01450','4.1.2.47'),
	('C01450','1.1.1.184'),
	('C01450','1.1.3.18'),
	('C01451','2.4.1.172'),
	('C01454','1.2.1.7'),
	('C01454','1.2.1.28'),
	('C01455','1.14.12.11'),
	('C01455','4.1.99.11'),
	('C01456','3.1.1.10'),
	('C01457','2.1.1.101'),
	('C01460','2.4.1.105'),
	('C01467','1.14.13.7'),
	('C01467','4.1.1.52'),
	('C01468','1.14.13.7'),
	('C01468','1.17.99.1'),
	('C01468','4.1.1.83'),
	('C01468','4.1.99.19'),
	('C01469','3.6.1.21'),
	('C01470','2.1.1.75'),
	('C01471','1.1.1.54'),
	('C01474','2.4.1.103'),
	('C01477','2.4.1.81'),
	('C01477','2.1.1.75'),
	('C01477','1.14.11.22'),
	('C01477','1.14.13.88'),
	('C01477','1.14.13.21'),
	('C01479','3.1.1.10'),
	('C01485','1.97.1.1'),
	('C01486','1.13.11.49'),
	('C01486','1.97.1.1'),
	('C01487','2.7.1.55'),
	('C01488','1.1.1.114'),
	('C01489','1.1.1.15'),
	('C01490','2.8.2.35'),
	('C01490','5.1.3.19'),
	('C01490','2.8.2.17'),
	('C01493','3.1.7.1'),
	('C01494','3.5.1.71'),
	('C01494','4.1.1.102'),
	('C01494','2.4.1.126'),
	('C01494','6.2.1.34'),
	('C01494','6.2.1.12'),
	('C01494','2.4.1.120'),
	('C01494','2.1.1.68'),
	('C01494','1.2.1.68'),
	('C01494','3.1.1.73'),
	('C01495','2.4.1.91'),
	('C01495','2.4.1.237'),
	('C01495','1.14.11.23'),
	('C01499','1.1.1.183'),
	('C01499','1.2.1.86'),
	('C01499','1.1.1.347'),
	('C01500','1.14.13.152'),
	('C01500','3.1.7.3'),
	('C01500','1.1.1.347'),
	('C01500','3.1.7.11'),
	('C01500','5.4.4.4'),
	('C01500','1.1.1.183'),
	('C01502','2.1.1.6'),
	('C01504','1.1.1.112'),
	('C01506','1.1.1.185'),
	('C01507','1.1.1.14'),
	('C01510','1.1.1.113'),
	('C01512','2.1.1.50'),
	('C01512','1.14.13.74'),
	('C01512','1.3.3.9'),
	('C01513','2.5.1.50'),
	('C01514','1.14.13.21'),
	('C01514','2.1.1.42'),
	('C01514','2.4.1.189'),
	('C01514','1.14.13.88'),
	('C01514','2.4.1.81'),
	('C01514','1.14.11.22'),
	('C01516','2.4.1.17'),
	('C01516','1.14.11.32'),
	('C01516','1.14.14.1'),
	('C01516','1.1.1.218'),
	('C01518','2.4.1.334'),
	('C01518','2.4.1.279'),
	('C01525','1.8.3.2'),
	('C01526','3.5.5.2'),
	('C01527','2.4.1.128'),
	('C01528','2.7.9.3'),
	('C01528','1.8.7.1'),
	('C01528','1.8.1.9'),
	('C01528','2.5.1.47'),
	('C01528','4.4.1.16'),
	('C01530','3.1.2.14'),
	('C01530','3.1.2.2'),
	('C01533','3.2.1.126'),
	('C01533','2.4.1.111'),
	('C01537','3.5.1.75'),
	('C01540','2.7.1.103'),
	('C01545','1.1.1.73'),
	('C01545','1.1.1.1'),
	('C01546','6.2.1.31'),
	('C01547','2.7.7.36'),
	('C01548','1.18.6.1'),
	('C01548','4.2.1.112'),
	('C01550','2.3.2.9'),
	('C01551','3.5.2.5'),
	('C01557','2.1.1.69'),
	('C01561','1.14.14.24'),
	('C01561','1.14.15.16'),
	('C01561','1.14.15.18'),
	('C01562','1.14.21.8'),
	('C01562','1.14.13.52'),
	('C01563','4.2.1.104'),
	('C01563','3.5.1.110'),
	('C01563','6.3.5.5'),
	('C01563','2.7.2.2'),
	('C01564','3.1.1.70'),
	('C01566','4.2.1.69'),
	('C01569','1.1.1.114'),
	('C01571','3.1.2.21'),
	('C01572','3.1.1.20'),
	('C01573','2.1.1.98'),
	('C01573','3.1.1.97'),
	('C01573','6.3.1.14'),
	('C01575','1.5.1.18'),
	('C01579','1.14.13.21'),
	('C01581','2.7.7.28'),
	('C01585','3.5.1.39'),
	('C01586','2.3.1.71'),
	('C01586','3.5.1.32'),
	('C01589','2.3.1.2'),
	('C01590','4.2.1.95'),
	('C01592','2.1.1.65'),
	('C01592','1.14.13.87'),
	('C01593','3.1.1.36'),
	('C01594','3.2.1.21'),
	('C01594','2.4.1.63'),
	('C01595','1.13.11.12'),
	('C01595','3.1.1.4'),
	('C01595','3.1.2.2'),
	('C01595','5.2.1.5'),
	('C01595','1.13.11.77'),
	('C01595','1.13.11.45'),
	('C01595','1.14.14.1'),
	('C01595','1.13.11.33'),
	('C01595','1.13.11.62'),
	('C01595','1.13.11.60'),
	('C01595','1.14.19.3'),
	('C01595','1.14.19.39'),
	('C01595','1.13.11.58'),
	('C01596','3.5.1.107'),
	('C01596','3.5.2.16'),
	('C01596','3.5.1.106'),
	('C01598','2.1.1.4'),
	('C01598','1.13.11.52'),
	('C01598','1.14.14.1'),
	('C01599','2.7.7.37'),
	('C01600','2.7.7.28'),
	('C01602','2.6.1.8'),
	('C01606','1.11.1.19'),
	('C01606','3.5.1.79'),
	('C01606','1.2.1.78'),
	('C01606','1.3.1.19'),
	('C01606','1.14.12.7'),
	('C01607','6.2.1.24'),
	('C01609','2.7.11.1'),
	('C01610','2.1.1.38'),
	('C01612','1.1.1.184'),
	('C01612','1.1.1.1'),
	('C01612','1.1.98.5'),
	('C01612','1.1.3.18'),
	('C01613','3.2.1.22'),
	('C01613','3.2.1.26'),
	('C01613','2.4.1.67'),
	('C01614','2.8.2.3'),
	('C01616','1.5.1.23'),
	('C01617','1.14.13.19'),
	('C01617','1.14.13.21'),
	('C01617','1.14.13.88'),
	('C01617','1.14.11.19'),
	('C01617','1.14.11.9'),
	('C01617','1.1.1.219'),
	('C01617','1.14.11.23'),
	('C01618','3.1.1.37'),
	('C01620','1.1.1.129'),
	('C01623','2.4.2.25'),
	('C01624','1.1.1.252'),
	('C01625','3.2.1.119'),
	('C01626','2.3.1.107'),
	('C01628','1.6.5.2'),
	('C01628','1.17.4.4'),
	('C01629','3.1.1.50'),
	('C01629','2.3.1.20'),
	('C01635','2.3.2.10'),
	('C01635','6.1.1.7'),
	('C01635','2.3.2.11'),
	('C01636','2.3.2.8'),
	('C01636','6.1.1.19'),
	('C01637','6.1.1.23'),
	('C01637','6.1.1.22'),
	('C01638','6.1.1.12'),
	('C01638','6.1.1.23'),
	('C01639','6.1.1.16'),
	('C01639','6.1.1.27'),
	('C01640','6.1.1.24'),
	('C01640','6.1.1.18'),
	('C01641','6.1.1.24'),
	('C01641','1.2.1.70'),
	('C01641','6.1.1.17'),
	('C01642','6.1.1.14'),
	('C01642','2.3.2.16'),
	('C01642','2.3.2.17'),
	('C01642','2.3.2.18'),
	('C01642','2.3.2.10'),
	('C01643','6.1.1.21'),
	('C01644','6.1.1.5'),
	('C01645','6.1.1.4'),
	('C01645','2.3.2.20'),
	('C01645','2.3.2.6'),
	('C01645','2.3.2.22'),
	('C01646','2.3.2.3'),
	('C01646','6.1.1.6'),
	('C01647','6.1.1.10'),
	('C01648','2.3.2.20'),
	('C01648','6.1.1.20'),
	('C01649','6.1.1.15'),
	('C01650','6.1.1.11'),
	('C01651','6.1.1.3'),
	('C01652','6.1.1.2'),
	('C01653','6.1.1.9'),
	('C01656','2.8.3.5'),
	('C01659','4.2.1.84'),
	('C01659','3.5.1.4'),
	('C01661','1.14.13.181'),
	('C01664','2.3.2.13'),
	('C01672','2.5.1.16'),
	('C01672','1.4.3.21'),
	('C01672','4.1.1.18'),
	('C01673','1.14.15.16'),
	('C01673','1.14.15.18'),
	('C01674','2.7.1.196'),
	('C01674','3.2.1.52'),
	('C01674','3.2.1.14'),
	('C01674','2.4.1.280'),
	('C01677','1.1.1.235'),
	('C01678','1.13.11.19'),
	('C01678','2.3.1.11'),
	('C01678','3.5.1.92'),
	('C01680','4.2.1.67'),
	('C01682','1.5.1.19'),
	('C01685','1.1.1.115'),
	('C01693','5.3.3.12'),
	('C01694','1.3.1.71'),
	('C01694','4.2.1.62'),
	('C01697','1.1.1.21'),
	('C01697','1.1.1.16'),
	('C01697','2.7.1.200'),
	('C01698','2.4.1.205'),
	('C01699','2.4.1.176'),
	('C01701','1.14.13.85'),
	('C01702','2.4.1.186'),
	('C01708','1.14.14.18'),
	('C01709','2.4.1.185'),
	('C01709','3.2.1.168'),
	('C01710','1.1.1.112'),
	('C01711','3.2.1.134'),
	('C01714','2.4.1.106'),
	('C01717','1.14.99.2'),
	('C01717','1.3.99.18'),
	('C01719','1.1.1.15'),
	('C01720','4.2.1.68'),
	('C01721','2.7.1.51'),
	('C01721','5.3.1.3'),
	('C01721','5.3.1.25'),
	('C01722','1.1.1.15'),
	('C01724','1.3.1.72'),
	('C01724','1.14.13.70'),
	('C01724','5.4.99.7'),
	('C01725','3.2.1.64'),
	('C01725','3.2.1.65'),
	('C01726','2.7.3.5'),
	('C01727','3.5.99.1'),
	('C01728','3.2.1.163'),
	('C01732','4.2.1.34'),
	('C01732','4.3.1.2'),
	('C01735','1.14.11.31'),
	('C01735','1.1.1.218'),
	('C01736','2.4.2.1'),
	('C01739','2.5.1.38'),
	('C01742','5.4.99.11'),
	('C01743','3.5.1.112'),
	('C01743','2.4.1.301'),
	('C01743','1.1.3.43'),
	('C01744','3.7.1.4'),
	('C01745','2.3.1.146'),
	('C01746','2.3.1.145'),
	('C01747','2.4.1.23'),
	('C01747','2.8.2.13'),
	('C01748','1.14.13.218'),
	('C01750','3.2.1.66'),
	('C01751','1.14.13.219'),
	('C01751','1.14.13.220'),
	('C01751','1.14.14.27'),
	('C01751','4.1.1.103'),
	('C01752','2.4.1.128'),
	('C01753','1.14.19.41'),
	('C01755','3.5.5.8'),
	('C01755','2.8.1.2'),
	('C01755','2.8.1.1'),
	('C01756','2.1.1.67'),
	('C01757','3.1.1.38'),
	('C01759','3.1.3.88'),
	('C01759','2.3.2.19'),
	('C01759','2.4.1.285'),
	('C01760','1.1.1.221'),
	('C01761','1.5.1.32'),
	('C01761','3.2.1.125'),
	('C01761','1.14.13.75'),
	('C01761','2.4.1.219'),
	('C01762','2.1.1.158'),
	('C01762','3.5.4.15'),
	('C01762','3.1.3.5'),
	('C01762','2.4.2.1'),
	('C01762','3.2.2.1'),
	('C01764','2.1.1.35'),
	('C01764','2.1.1.74'),
	('C01765','1.1.1.198'),
	('C01765','3.1.7.3'),
	('C01765','2.3.1.69'),
	('C01766','1.1.1.227'),
	('C01767','1.1.1.243'),
	('C01767','1.3.99.25'),
	('C01768','4.2.2.11'),
	('C01768','2.4.1.33'),
	('C01768','5.1.3.37'),
	('C01768','4.2.2.3'),
	('C01769','5.1.2.4'),
	('C01769','1.1.1.304'),
	('C01769','1.1.1.76'),
	('C01770','3.1.1.25'),
	('C01771','1.3.1.31'),
	('C01772','2.4.1.114'),
	('C01772','1.14.13.14'),
	('C01772','1.3.1.11'),
	('C01775','3.1.1.39'),
	('C01777','3.1.1.8'),
	('C01779','1.14.13.32'),
	('C01780','1.3.1.3'),
	('C01780','1.14.15.4'),
	('C01780','1.14.15.5'),
	('C01785','1.10.3.2'),
	('C01788','1.1.1.341'),
	('C01788','2.4.1.60'),
	('C01792','1.1.1.225'),
	('C01794','2.3.1.65'),
	('C01794','3.1.2.27'),
	('C01794','6.2.1.7'),
	('C01794','2.3.1.176'),
	('C01794','2.8.3.25'),
	('C01795','2.1.1.118'),
	('C01795','1.3.3.8'),
	('C01795','1.21.3.2'),
	('C01801','2.7.1.15'),
	('C01802','1.3.1.72'),
	('C01802','4.1.2.33'),
	('C01804','2.5.1.24'),
	('C01810','2.4.1.32'),
	('C01812','3.8.1.3'),
	('C01816','4.1.99.5'),
	('C01817','1.8.4.1'),
	('C01818','1.7.1.5'),
	('C01821','2.1.1.78'),
	('C01822','2.4.1.301'),
	('C01822','2.6.1.94'),
	('C01822','2.7.1.95'),
	('C01822','1.1.1.355'),
	('C01822','6.1.2.2'),
	('C01823','2.4.1.301'),
	('C01825','1.1.1.316'),
	('C01825','3.1.3.93'),
	('C01825','1.1.1.122'),
	('C01826','1.5.1.28'),
	('C01829','1.11.1.8'),
	('C01829','1.21.99.3'),
	('C01829','1.21.99.4'),
	('C01832','2.3.1.16'),
	('C01832','2.3.3.2'),
	('C01832','2.3.3.4'),
	('C01832','1.3.8.8'),
	('C01832','1.3.1.38'),
	('C01832','1.3.1.8'),
	('C01832','1.3.3.6'),
	('C01832','1.3.8.7'),
	('C01837','1.7.3.1'),
	('C01838','4.1.99.5'),
	('C01839','4.1.1.58'),
	('C01839','3.1.1.40'),
	('C01841','1.14.13.133'),
	('C01841','4.2.3.7'),
	('C01842','3.5.1.50'),
	('C01845','1.1.1.80'),
	('C01845','1.14.13.227'),
	('C01847','1.13.11.79'),
	('C01847','1.13.12.16'),
	('C01847','1.1.99.31'),
	('C01847','2.5.1.129'),
	('C01847','1.14.14.3'),
	('C01847','1.5.1.41'),
	('C01847','1.5.1.42'),
	('C01847','1.14.14.5'),
	('C01847','1.14.14.21'),
	('C01847','1.14.14.22'),
	('C01847','1.14.14.10'),
	('C01847','1.14.14.12'),
	('C01847','1.14.14.13'),
	('C01847','1.16.8.1'),
	('C01847','1.14.99.46'),
	('C01847','1.3.99.24'),
	('C01847','1.5.1.38'),
	('C01847','1.5.1.39'),
	('C01848','1.10.3.6'),
	('C01849','1.10.3.6'),
	('C01850','2.3.1.140'),
	('C01851','1.14.11.14'),
	('C01852','4.3.3.2'),
	('C01852','1.3.3.9'),
	('C01852','4.3.3.4'),
	('C01852','2.1.1.50'),
	('C01852','4.3.3.3'),
	('C01853','4.1.1.60'),
	('C01855','2.4.1.178'),
	('C01857','2.3.1.10'),
	('C01860','4.2.3.6'),
	('C01861','3.12.1.1'),
	('C01861','1.8.99.5'),
	('C01863','4.2.1.73'),
	('C01864','2.1.1.70'),
	('C01866','3.5.2.6'),
	('C01867','2.7.11.26'),
	('C01868','1.1.1.228'),
	('C01869','4.2.1.88'),
	('C01870','3.2.1.119'),
	('C01872','3.8.1.5'),
	('C01874','2.1.1.26'),
	('C01875','4.1.1.56'),
	('C01876','1.3.99.4'),
	('C01876','1.1.1.357'),
	('C01876','1.1.1.50'),
	('C01876','1.1.1.213'),
	('C01877','1.1.1.104'),
	('C01879','3.5.2.9'),
	('C01879','2.3.2.4'),
	('C01879','4.3.2.6'),
	('C01880','3.1.1.17'),
	('C01880','1.14.13.22'),
	('C01880','3.1.1.83'),
	('C01881','1.1.1.201'),
	('C01883','2.3.1.84'),
	('C01883','3.1.1.6'),
	('C01884','2.3.1.83'),
	('C01885','2.3.1.22'),
	('C01885','2.7.1.94'),
	('C01885','3.1.1.23'),
	('C01885','3.1.1.79'),
	('C01885','2.3.1.73'),
	('C01885','3.1.1.3'),
	('C01888','1.4.3.21'),
	('C01888','1.4.3.4'),
	('C01888','1.1.1.75'),
	('C01888','1.1.1.381'),
	('C01890','3.5.1.76'),
	('C01892','1.8.1.11'),
	('C01893','3.5.1.12'),
	('C01894','6.2.1.11'),
	('C01898','3.2.1.21'),
	('C01898','3.2.1.4'),
	('C01898','3.2.1.74'),
	('C01898','3.2.1.91'),
	('C01902','2.1.1.142'),
	('C01902','5.4.99.8'),
	('C01902','2.1.1.41'),
	('C01904','1.1.1.287'),
	('C01904','1.1.1.250'),
	('C01904','1.1.1.11'),
	('C01906','2.7.1.102'),
	('C01907','2.1.1.292'),
	('C01907','1.14.13.181'),
	('C01909','2.8.1.6'),
	('C01909','6.3.3.3'),
	('C01912','1.14.13.154'),
	('C01912','2.1.1.254'),
	('C01917','2.7.7.46'),
	('C01918','2.3.1.81'),
	('C01918','2.3.1.60'),
	('C01918','2.7.1.190'),
	('C01920','6.4.1.5'),
	('C01921','2.3.1.65'),
	('C01921','3.5.1.24'),
	('C01923','2.4.1.48'),
	('C01925','2.7.1.163'),
	('C01925','2.7.1.119'),
	('C01929','1.1.1.23'),
	('C01931','2.3.2.3'),
	('C01931','6.1.1.6'),
	('C01933','2.6.1.67'),
	('C01934','3.1.1.65'),
	('C01934','4.2.1.90'),
	('C01935','5.4.99.15'),
	('C01935','3.2.1.2'),
	('C01935','3.2.1.133'),
	('C01935','3.2.1.54'),
	('C01935','3.2.1.68'),
	('C01935','3.2.1.141'),
	('C01935','3.2.1.1'),
	('C01941','5.1.1.14'),
	('C01943','5.5.1.9'),
	('C01943','1.14.13.70'),
	('C01944','2.3.1.207'),
	('C01944','2.3.1.16'),
	('C01944','2.3.1.137'),
	('C01944','1.3.3.6'),
	('C01944','1.3.1.38'),
	('C01944','1.3.8.8'),
	('C01944','1.3.8.7'),
	('C01944','1.3.1.8'),
	('C01946','2.7.1.136'),
	('C01948','1.11.1.3'),
	('C01949','3.7.1.7'),
	('C01951','5.3.3.11'),
	('C01953','2.8.2.14'),
	('C01953','2.8.2.2'),
	('C01953','5.3.3.1'),
	('C01953','1.14.14.29'),
	('C01953','3.1.6.2'),
	('C01953','1.14.14.16'),
	('C01953','1.14.14.19'),
	('C01953','1.1.1.145'),
	('C01953','1.14.15.6'),
	('C01957','2.1.1.50'),
	('C01957','1.3.3.9'),
	('C01958','3.1.1.13'),
	('C01958','2.3.1.43'),
	('C01958','2.3.1.73'),
	('C01959','2.1.4.1'),
	('C01959','2.7.3.4'),
	('C01962','4.4.1.8'),
	('C01962','4.4.1.1'),
	('C01967','2.1.1.64'),
	('C01969','1.3.1.41'),
	('C01971','5.1.3.21'),
	('C01972','2.1.1.62'),
	('C01977','2.4.2.29'),
	('C01977','2.1.1.228'),
	('C01977','2.1.1.34'),
	('C01977','2.1.1.33'),
	('C01978','2.4.2.29'),
	('C01983','1.1.1.379'),
	('C01983','3.5.1.86'),
	('C01983','5.1.2.2'),
	('C01984','1.1.99.31'),
	('C01984','5.1.2.2'),
	('C01984','1.14.16.6'),
	('C01985','1.1.1.146'),
	('C01986','1.1.1.147'),
	('C01987','1.10.3.4'),
	('C01987','1.13.11.74'),
	('C01987','5.4.4.1'),
	('C01988','1.14.13.31'),
	('C01989','2.3.3.7'),
	('C01990','4.1.3.13'),
	('C01991','3.1.1.25'),
	('C01993','1.1.3.28'),
	('C01995','2.6.3.1'),
	('C01996','3.1.1.7'),
	('C01996','2.3.1.6'),
	('C01996','3.1.1.8'),
	('C01997','2.3.1.48'),
	('C01998','3.5.5.7'),
	('C01998','4.2.1.84'),
	('C02000','2.8.2.2'),
	('C02001','1.1.1.54'),
	('C02003','1.3.1.77'),
	('C02003','2.4.1.115'),
	('C02004','4.2.3.9'),
	('C02006','2.5.1.35'),
	('C02008','2.5.1.35'),
	('C02010','3.5.4.23'),
	('C02013','3.2.1.74'),
	('C02015','1.8.1.14'),
	('C02020','1.1.1.163'),
	('C02022','1.1.1.162'),
	('C02022','1.1.1.403'),
	('C02024','1.1.1.131'),
	('C02027','3.1.1.46'),
	('C02028','3.5.1.3'),
	('C02029','1.3.1.69'),
	('C02031','2.7.7.88'),
	('C02031','2.7.7.50'),
	('C02031','2.1.1.56'),
	('C02034','1.14.11.12'),
	('C02035','1.14.11.12'),
	('C02035','1.14.11.13'),
	('C02035','1.14.11.15'),
	('C02037','3.5.2.13'),
	('C02038','2.3.1.97'),
	('C02041','3.1.2.2'),
	('C02041','1.14.19.10'),
	('C02043','1.1.1.110'),
	('C02046','1.14.11.11'),
	('C02047','2.3.2.20'),
	('C02047','2.3.2.22'),
	('C02047','2.3.2.6'),
	('C02047','6.1.1.4'),
	('C02048','2.4.1.31'),
	('C02050','3.1.2.2'),
	('C02050','1.14.13.204'),
	('C02050','1.14.19.3'),
	('C02050','1.14.19.6'),
	('C02051','1.4.4.2'),
	('C02051','1.8.1.4'),
	('C02055','2.3.1.13'),
	('C02056','2.3.2.12'),
	('C02059','1.17.4.4'),
	('C02059','2.1.1.163'),
	('C02059','1.6.5.2'),
	('C02059','1.14.13.194'),
	('C02059','1.14.99.20'),
	('C02060','1.14.11.18'),
	('C02060','6.2.1.24'),
	('C02061','1.10.3.9'),
	('C02061','1.3.5.5'),
	('C02061','1.10.9.1'),
	('C02066','2.3.1.186'),
	('C02066','1.1.1.236'),
	('C02067','2.7.1.83'),
	('C02067','3.1.3.96'),
	('C02069','1.14.15.1'),
	('C02069','1.14.15.10'),
	('C02069','1.18.1.5'),
	('C02073','6.5.1.3'),
	('C02074','2.4.1.219'),
	('C02074','3.2.1.125'),
	('C02075','3.1.1.90'),
	('C02075','3.1.1.64'),
	('C02075','2.3.1.135'),
	('C02075','2.3.1.76'),
	('C02076','2.7.1.3'),
	('C02076','2.7.1.14'),
	('C02079','2.1.1.139'),
	('C02080','4.1.1.60'),
	('C02083','5.3.99.7'),
	('C02084','1.8.2.2'),
	('C02084','1.8.5.2'),
	('C02085','3.2.1.147'),
	('C02086','4.5.1.5'),
	('C02089','2.3.1.185'),
	('C02090','1.11.1.15'),
	('C02090','1.17.4.1'),
	('C02090','1.8.1.12'),
	('C02090','6.3.1.9'),
	('C02091','3.5.3.9'),
	('C02091','3.5.3.26'),
	('C02094','5.5.1.19'),
	('C02094','1.13.11.71'),
	('C02094','5.2.1.14'),
	('C02094','1.13.11.63'),
	('C02094','1.14.13.129'),
	('C02097','2.7.7.32'),
	('C02097','1.1.1.186'),
	('C02097','5.1.3.2'),
	('C02099','1.1.1.234'),
	('C02100','2.7.7.50'),
	('C02101','2.4.1.32'),
	('C02103','3.8.1.10'),
	('C02103','3.8.1.11'),
	('C02103','3.8.1.2'),
	('C02105','2.1.1.116'),
	('C02105','2.1.1.115'),
	('C02105','2.1.1.291'),
	('C02105','1.21.3.3'),
	('C02106','2.1.1.117'),
	('C02106','1.21.3.3'),
	('C02106','1.14.21.2'),
	('C02107','4.2.1.81'),
	('C02110','1.1.1.315'),
	('C02112','2.7.1.94'),
	('C02112','2.3.1.22'),
	('C02112','3.1.1.23'),
	('C02112','3.1.1.3'),
	('C02115','2.1.2.7'),
	('C02117','1.1.3.27'),
	('C02119','3.7.1.5'),
	('C02123','2.3.3.12'),
	('C02124','1.14.13.20'),
	('C02126','3.5.1.72'),
	('C02126','4.3.3.1'),
	('C02128','6.5.1.7'),
	('C02128','6.5.1.6'),
	('C02128','6.5.1.2'),
	('C02128','2.7.1.78'),
	('C02128','6.5.1.1'),
	('C02129','3.7.1.10'),
	('C02130','2.3.1.79'),
	('C02132','3.7.1.6'),
	('C02133','2.7.1.61'),
	('C02133','3.6.1.7'),
	('C02134','1.14.13.37'),
	('C02135','3.4.17.23'),
	('C02137','1.1.1.379'),
	('C02137','1.2.1.58'),
	('C02137','1.1.99.31'),
	('C02137','4.1.1.7'),
	('C02137','3.1.2.25'),
	('C02139','3.1.1.14'),
	('C02139','1.3.1.33'),
	('C02139','1.3.1.75'),
	('C02139','1.3.7.7'),
	('C02139','1.3.7.15'),
	('C02139','1.14.13.122'),
	('C02139','2.5.1.62'),
	('C02139','4.2.1.165'),
	('C02140','1.14.15.4'),
	('C02140','1.3.1.3'),
	('C02140','1.14.14.16'),
	('C02140','1.14.15.5'),
	('C02140','1.1.1.146'),
	('C02141','1.14.13.72'),
	('C02141','5.5.1.9'),
	('C02142','2.4.2.5'),
	('C02143','1.1.1.122'),
	('C02146','4.1.1.64'),
	('C02151','1.3.1.36'),
	('C02153','2.8.2.24'),
	('C02161','1.10.3.4'),
	('C02162','2.1.1.69'),
	('C02163','2.3.2.8'),
	('C02163','6.1.1.19'),
	('C02165','3.3.2.6'),
	('C02165','1.14.13.30'),
	('C02166','4.4.1.20'),
	('C02166','2.3.2.2'),
	('C02166','3.4.19.14'),
	('C02167','1.13.11.4'),
	('C02167','5.2.1.4'),
	('C02167','3.7.1.23'),
	('C02167','3.1.1.91'),
	('C02167','5.2.1.2'),
	('C02170','3.1.2.17'),
	('C02170','3.5.2.1'),
	('C02170','1.2.1.3'),
	('C02170','1.2.3.1'),
	('C02170','3.5.1.95'),
	('C02172','1.7.3.2'),
	('C02174','3.6.1.10'),
	('C02179','4.3.2.5'),
	('C02183','1.3.1.57'),
	('C02183','1.97.1.2'),
	('C02183','3.7.1.4'),
	('C02188','1.14.11.4'),
	('C02188','2.1.1.43'),
	('C02188','2.1.1.60'),
	('C02188','1.14.11.27'),
	('C02188','6.3.1.19'),
	('C02188','2.1.1.59'),
	('C02188','3.5.1.119'),
	('C02189','2.4.1.221'),
	('C02189','2.4.1.109'),
	('C02189','3.2.1.169'),
	('C02189','3.2.1.97'),
	('C02189','2.4.2.26'),
	('C02189','2.4.2.33'),
	('C02189','2.4.1.41'),
	('C02189','2.4.1.255'),
	('C02191','6.6.1.1'),
	('C02191','1.3.5.3'),
	('C02191','1.3.3.4'),
	('C02191','4.99.1.1'),
	('C02193','2.6.3.1'),
	('C02198','5.3.99.5'),
	('C02199','2.4.1.159'),
	('C02199','2.4.1.236'),
	('C02199','2.4.1.273'),
	('C02200','5.1.3.16'),
	('C02201','1.11.1.14'),
	('C02206','1.3.1.47'),
	('C02207','1.5.1.26'),
	('C02211','2.7.7.72'),
	('C02213','1.1.1.228'),
	('C02213','1.14.13.153'),
	('C02214','2.8.3.12'),
	('C02216','3.2.2.13'),
	('C02217','1.1.1.66'),
	('C02218','4.3.1.17'),
	('C02218','4.4.1.4'),
	('C02218','1.11.1.8'),
	('C02220','3.5.99.5'),
	('C02220','1.2.1.32'),
	('C02222','3.1.1.92'),
	('C02222','1.13.11.37'),
	('C02222','3.1.1.45'),
	('C02222','1.2.1.61'),
	('C02222','1.3.1.32'),
	('C02223','4.1.1.72'),
	('C02224','4.1.1.42'),
	('C02225','4.2.1.117'),
	('C02225','2.3.3.5'),
	('C02225','4.2.1.79'),
	('C02226','4.2.1.35'),
	('C02231','1.3.1.16'),
	('C02232','1.1.1.157'),
	('C02232','1.1.1.35'),
	('C02232','2.3.1.174'),
	('C02232','2.8.3.6'),
	('C02232','2.3.1.16'),
	('C02235','1.14.13.29'),
	('C02236','1.2.1.62'),
	('C02236','1.14.12.8'),
	('C02237','4.2.1.48'),
	('C02240','1.14.13.16'),
	('C02243','1.1.1.235'),
	('C02244','4.2.1.84'),
	('C02245','4.4.1.4'),
	('C02247','1.14.13.40'),
	('C02247','2.3.1.232'),
	('C02247','2.3.1.230'),
	('C02247','6.2.1.32'),
	('C02248','4.4.1.17'),
	('C02249','6.2.1.15'),
	('C02249','3.1.2.2'),
	('C02249','1.14.19.44'),
	('C02253','3.5.1.40'),
	('C02265','2.6.1.21'),
	('C02265','5.1.1.11'),
	('C02265','2.3.1.36'),
	('C02265','1.4.5.1'),
	('C02266','1.1.1.175'),
	('C02266','3.1.1.68'),
	('C02266','1.1.1.179'),
	('C02266','1.1.1.121'),
	('C02269','3.1.3.34'),
	('C02269','3.1.3.89'),
	('C02269','2.7.1.145'),
	('C02269','2.7.1.77'),
	('C02269','2.4.2.6'),
	('C02270','2.6.99.1'),
	('C02271','4.5.1.3'),
	('C02273','3.2.1.67'),
	('C02273','3.2.1.15'),
	('C02274','3.1.1.35'),
	('C02280','5.1.3.18'),
	('C02280','2.7.7.69'),
	('C02282','6.1.1.18'),
	('C02282','6.3.5.7'),
	('C02283','1.14.13.173'),
	('C02283','3.2.1.128'),
	('C02284','3.2.1.128'),
	('C02287','2.3.1.106'),
	('C02287','1.1.1.167'),
	('C02288','1.8.4.2'),
	('C02289','5.3.3.11'),
	('C02290','3.5.1.73'),
	('C02291','4.4.1.1'),
	('C02291','2.5.1.134'),
	('C02291','4.2.1.22'),
	('C02291','2.5.1.48'),
	('C02291','4.4.1.8'),
	('C02293','1.14.99.21'),
	('C02294','3.5.3.16'),
	('C02295','5.4.99.4'),
	('C02295','5.3.3.6'),
	('C02297','2.3.1.57'),
	('C02298','1.7.3.2'),
	('C02299','4.1.2.24'),
	('C02301','3.1.1.28'),
	('C02303','1.14.17.3'),
	('C02305','2.7.3.2'),
	('C02305','3.9.1.1'),
	('C02306','2.7.3.8'),
	('C02306','2.7.1.62'),
	('C02307','3.1.3.17'),
	('C02307','2.7.11.19'),
	('C02308','2.7.11.19'),
	('C02308','3.1.3.17'),
	('C02315','1.8.1.8'),
	('C02315','1.17.7.1'),
	('C02315','1.8.4.2'),
	('C02318','1.8.3.2'),
	('C02320','2.5.1.18'),
	('C02320','2.3.2.2'),
	('C02321','2.5.1.20'),
	('C02323','2.4.1.172'),
	('C02323','3.2.1.86'),
	('C02325','1.1.1.195'),
	('C02325','1.11.1.7'),
	('C02325','3.2.1.126'),
	('C02325','2.1.1.68'),
	('C02325','2.4.1.111'),
	('C02325','1.11.1.21'),
	('C02330','5.1.3.12'),
	('C02331','5.3.3.3'),
	('C02333','3.5.4.24'),
	('C02335','4.3.1.6'),
	('C02336','3.2.1.48'),
	('C02336','3.2.1.20'),
	('C02336','3.2.1.26'),
	('C02336','2.7.1.1'),
	('C02336','2.7.1.4'),
	('C02338','5.1.3.32'),
	('C02339','3.6.1.62'),
	('C02339','2.1.1.56'),
	('C02339','2.1.1.57'),
	('C02341','5.3.3.7'),
	('C02341','2.1.1.145'),
	('C02341','2.1.1.144'),
	('C02342','2.8.1.4'),
	('C02344','4.2.3.10'),
	('C02344','1.1.1.322'),
	('C02345','1.1.1.234'),
	('C02347','2.7.8.9'),
	('C02348','5.1.99.3'),
	('C02350','3.5.2.5'),
	('C02350','4.1.1.97'),
	('C02350','5.1.99.3'),
	('C02351','1.10.3.1'),
	('C02351','1.14.18.1'),
	('C02352','3.2.1.37'),
	('C02352','2.4.2.24'),
	('C02353','3.1.4.16'),
	('C02354','3.1.4.16'),
	('C02355','3.1.4.16'),
	('C02356','2.6.1.44'),
	('C02356','2.6.1.42'),
	('C02356','6.3.2.2'),
	('C02357','1.14.12.13'),
	('C02359','1.14.12.10'),
	('C02360','1.1.1.172'),
	('C02362','2.6.1.14'),
	('C02362','3.5.1.3'),
	('C02364','1.14.12.10'),
	('C02366','1.3.1.17'),
	('C02367','4.1.1.56'),
	('C02370','3.8.1.6'),
	('C02370','6.2.1.33'),
	('C02370','3.7.1.8'),
	('C02371','6.2.1.33'),
	('C02371','1.14.12.10'),
	('C02372','1.14.13.27'),
	('C02373','1.14.15.6'),
	('C02374','2.7.1.78'),
	('C02375','1.13.11.2'),
	('C02375','1.13.11.1'),
	('C02375','1.14.13.20'),
	('C02376','3.5.4.1'),
	('C02378','3.5.1.46'),
	('C02379','2.1.1.108'),
	('C02380','1.17.3.2'),
	('C02380','2.1.1.67'),
	('C02380','2.4.2.8'),
	('C02381','2.1.1.108'),
	('C02385','3.4.13.4'),
	('C02390','2.4.1.171'),
	('C02391','3.1.1.1'),
	('C02394','1.1.1.195'),
	('C02394','2.3.1.224'),
	('C02395','1.3.99.14'),
	('C02399','2.4.2.33'),
	('C02400','2.4.1.318'),
	('C02400','2.1.1.102'),
	('C02403','2.8.3.8'),
	('C02405','2.7.2.6'),
	('C02411','2.8.3.12'),
	('C02411','4.1.1.70'),
	('C02411','1.3.8.6'),
	('C02411','1.3.99.32'),
	('C02412','6.1.1.14'),
	('C02412','2.3.2.17'),
	('C02412','2.3.2.16'),
	('C02412','2.3.2.10'),
	('C02412','2.3.2.18'),
	('C02415','2.3.1.48'),
	('C02415','2.1.1.43'),
	('C02419','2.7.3.6'),
	('C02426','4.1.2.54'),
	('C02426','1.1.1.372'),
	('C02427','2.1.3.8'),
	('C02429','2.3.2.6'),
	('C02430','6.1.1.10'),
	('C02430','2.1.2.9'),
	('C02431','1.1.1.173'),
	('C02434','2.3.1.75'),
	('C02436','2.1.1.49'),
	('C02442','2.1.1.27'),
	('C02444','3.5.1.17'),
	('C02445','3.7.1.7'),
	('C02446','2.7.1.84'),
	('C02452','1.14.13.49'),
	('C02452','1.1.1.144'),
	('C02453','2.8.2.15'),
	('C02456','2.7.11.14'),
	('C02457','1.1.1.202'),
	('C02462','4.2.3.11'),
	('C02463','2.1.1.107'),
	('C02463','2.1.1.130'),
	('C02463','1.3.1.76'),
	('C02465','2.6.1.26'),
	('C02465','1.21.99.4'),
	('C02465','1.11.1.8'),
	('C02466','3.6.1.2'),
	('C02467','5.1.3.16'),
	('C02469','2.1.1.107'),
	('C02471','2.3.2.15'),
	('C02474','3.2.1.55'),
	('C02475','3.2.1.51'),
	('C02476','5.1.3.32'),
	('C02477','2.1.1.95'),
	('C02478','3.2.1.25'),
	('C02480','1.13.11.1'),
	('C02480','5.5.1.1'),
	('C02483','2.1.1.95'),
	('C02483','5.5.1.24'),
	('C02485','1.1.1.223'),
	('C02485','1.3.1.82'),
	('C02486','1.4.1.9'),
	('C02486','5.4.3.7'),
	('C02488','2.3.3.6'),
	('C02489','3.8.1.2'),
	('C02489','1.1.99.30'),
	('C02489','1.1.5.10'),
	('C02489','1.1.1.345'),
	('C02489','1.1.1.272'),
	('C02489','3.8.1.10'),
	('C02489','3.8.1.11'),
	('C02490','2.4.1.333'),
	('C02492','3.2.1.78'),
	('C02492','3.2.1.25'),
	('C02494','3.2.2.13'),
	('C02495','1.14.13.89'),
	('C02495','1.3.1.51'),
	('C02496','3.3.2.14'),
	('C02497','1.1.1.165'),
	('C02498','3.1.1.60'),
	('C02499','1.14.13.44'),
	('C02499','3.13.1.3'),
	('C02501','3.7.1.8'),
	('C02501','5.3.2.6'),
	('C02501','1.13.11.2'),
	('C02501','1.2.1.85'),
	('C02502','1.14.99.26'),
	('C02504','2.3.3.13'),
	('C02504','4.2.1.33'),
	('C02505','1.11.1.21'),
	('C02505','3.5.1.4'),
	('C02505','1.13.12.9'),
	('C02505','4.2.1.84'),
	('C02506','1.14.14.16'),
	('C02508','3.1.3.6'),
	('C02508','3.1.3.31'),
	('C02509','3.1.3.28'),
	('C02512','4.2.1.65'),
	('C02512','3.5.5.4'),
	('C02512','4.4.1.9'),
	('C02512','2.3.2.2'),
	('C02513','1.1.3.16'),
	('C02514','5.2.1.2'),
	('C02514','5.2.1.4'),
	('C02514','3.7.1.5'),
	('C02514','3.7.1.20'),
	('C02515','1.21.1.1'),
	('C02515','1.11.1.8'),
	('C02519','1.14.99.15'),
	('C02520','3.1.3.5'),
	('C02520','3.1.3.31'),
	('C02526','1.13.11.39'),
	('C02526','1.3.1.56'),
	('C02526','1.14.13.44'),
	('C02527','2.3.1.19'),
	('C02527','2.7.2.7'),
	('C02528','6.2.1.7'),
	('C02528','3.5.1.74'),
	('C02528','3.5.1.24'),
	('C02528','3.1.2.27'),
	('C02530','2.3.1.26'),
	('C02530','3.1.1.13'),
	('C02530','2.3.1.73'),
	('C02532','3.1.3.3'),
	('C02533','1.1.1.221'),
	('C02534','3.1.8.1'),
	('C02535','2.1.1.96'),
	('C02536','2.3.1.123'),
	('C02537','1.1.1.148'),
	('C02538','2.8.2.15'),
	('C02538','3.1.6.1'),
	('C02538','2.8.2.4'),
	('C02545','2.4.1.74'),
	('C02549','4.2.1.95'),
	('C02553','6.1.1.11'),
	('C02554','6.1.1.9'),
	('C02555','2.8.2.10'),
	('C02557','4.1.1.9'),
	('C02557','2.3.1.111'),
	('C02560','2.3.1.2'),
	('C02564','3.5.1.71'),
	('C02565','3.5.4.1'),
	('C02565','3.5.2.14'),
	('C02565','3.5.4.21'),
	('C02567','1.5.3.17'),
	('C02567','1.5.3.13'),
	('C02569','4.2.3.51'),
	('C02569','2.5.1.28'),
	('C02571','2.3.1.7'),
	('C02572','2.3.1.99'),
	('C02574','2.7.1.103'),
	('C02575','1.14.13.50'),
	('C02576','1.2.1.3'),
	('C02576','1.1.1.144'),
	('C02582','1.8.4.2'),
	('C02582','1.8.1.8'),
	('C02582','1.17.7.1'),
	('C02583','2.1.1.297'),
	('C02583','3.5.1.44'),
	('C02583','2.1.1.298'),
	('C02583','2.3.2.13'),
	('C02587','1.5.4.1'),
	('C02588','2.3.1.76'),
	('C02589','3.1.2.7'),
	('C02590','2.8.2.15'),
	('C02591','2.4.1.329'),
	('C02591','3.1.3.24'),
	('C02591','2.4.1.14'),
	('C02592','2.8.2.14'),
	('C02593','1.3.8.9'),
	('C02593','1.3.8.8'),
	('C02593','1.3.8.7'),
	('C02593','1.3.3.6'),
	('C02593','1.3.1.8'),
	('C02593','2.3.1.155'),
	('C02593','2.3.1.97'),
	('C02593','1.3.1.38'),
	('C02593','2.3.1.16'),
	('C02601','3.1.3.49'),
	('C02611','2.3.1.145'),
	('C02612','2.8.3.20'),
	('C02612','4.2.1.35'),
	('C02612','2.3.1.182'),
	('C02614','4.2.1.34'),
	('C02614','2.8.3.11'),
	('C02614','4.1.3.22'),
	('C02614','2.8.3.22'),
	('C02616','2.4.1.334'),
	('C02616','2.4.1.183'),
	('C02621','2.3.1.93'),
	('C02623','4.1.1.64'),
	('C02625','1.14.11.43'),
	('C02625','1.14.13.20'),
	('C02625','1.14.11.44'),
	('C02627','2.4.1.284'),
	('C02627','2.4.1.283'),
	('C02627','2.6.1.101'),
	('C02630','1.1.1.95'),
	('C02630','1.1.99.2'),
	('C02630','2.3.3.11'),
	('C02630','2.8.3.12'),
	('C02631','4.2.1.33'),
	('C02632','2.7.2.14'),
	('C02633','1.14.99.22'),
	('C02634','4.5.1.2'),
	('C02635','4.5.1.5'),
	('C02636','1.1.1.108'),
	('C02636','1.1.1.254'),
	('C02637','4.2.1.118'),
	('C02637','1.1.5.8'),
	('C02637','1.1.1.282'),
	('C02637','1.1.1.25'),
	('C02637','4.2.1.10'),
	('C02642','3.5.1.6'),
	('C02642','3.5.2.2'),
	('C02646','3.2.1.126'),
	('C02646','1.1.1.195'),
	('C02646','1.11.1.7'),
	('C02646','1.11.1.21'),
	('C02646','2.4.1.111'),
	('C02647','1.2.1.54'),
	('C02647','4.1.1.75'),
	('C02648','1.1.1.165'),
	('C02652','1.1.1.25'),
	('C02655','3.1.1.33'),
	('C02656','6.2.1.14'),
	('C02657','2.3.1.165'),
	('C02657','4.1.1.52'),
	('C02658','4.99.1.5'),
	('C02659','3.2.1.21'),
	('C02659','2.4.1.63'),
	('C02659','4.1.2.46'),
	('C02660','5.99.1.1'),
	('C02661','3.8.1.1'),
	('C02666','2.1.1.68'),
	('C02666','1.1.1.194'),
	('C02666','1.1.1.195'),
	('C02666','1.2.1.44'),
	('C02666','1.2.1.68'),
	('C02669','1.1.1.359'),
	('C02669','1.1.1.120'),
	('C02669','1.1.1.48'),
	('C02669','1.1.1.121'),
	('C02669','1.1.1.360'),
	('C02670','1.1.1.20'),
	('C02670','3.1.1.19'),
	('C02670','1.2.1.3'),
	('C02671','2.3.2.1'),
	('C02672','2.7.1.61'),
	('C02673','2.1.1.99'),
	('C02673','1.14.11.20'),
	('C02674','1.14.11.10'),
	('C02675','1.3.1.46'),
	('C02679','1.14.13.206'),
	('C02679','3.1.2.21'),
	('C02679','3.1.2.14'),
	('C02681','2.3.1.139'),
	('C02682','1.12.2.1'),
	('C02683','1.6.2.6'),
	('C02684','1.12.2.1'),
	('C02685','1.6.2.6'),
	('C02686','2.4.1.47'),
	('C02686','3.2.1.46'),
	('C02686','3.2.1.18'),
	('C02686','3.2.1.22'),
	('C02686','3.1.6.1'),
	('C02686','3.1.6.8'),
	('C02686','3.2.1.62'),
	('C02686','2.4.1.45'),
	('C02686','2.8.2.11'),
	('C02687','2.4.1.186'),
	('C02691','2.5.1.2'),
	('C02693','3.5.1.4'),
	('C02693','1.13.12.3'),
	('C02693','4.2.1.84'),
	('C02700','1.13.11.52'),
	('C02700','1.13.11.11'),
	('C02700','3.7.1.3'),
	('C02700','3.5.1.9'),
	('C02702','6.1.1.15'),
	('C02703','4.3.1.10'),
	('C02704','3.1.6.16'),
	('C02705','2.3.1.142'),
	('C02706','2.3.1.100'),
	('C02707','2.7.11.7'),
	('C02709','2.3.1.118'),
	('C02710','2.3.1.66'),
	('C02713','3.5.1.28'),
	('C02713','2.7.1.192'),
	('C02714','3.5.1.62'),
	('C02714','1.4.3.4'),
	('C02714','2.3.1.57'),
	('C02715','3.5.1.15'),
	('C02716','2.3.1.68'),
	('C02717','2.3.1.110'),
	('C02718','2.1.2.4'),
	('C02720','2.3.1.118'),
	('C02720','5.4.4.1'),
	('C02721','1.4.1.17'),
	('C02722','3.5.1.39'),
	('C02723','1.4.3.21'),
	('C02723','2.1.1.53'),
	('C02724','2.1.1.87'),
	('C02726','2.7.3.10'),
	('C02727','3.5.1.17'),
	('C02727','2.3.1.32'),
	('C02727','2.6.1.65'),
	('C02728','1.5.3.4'),
	('C02729','2.7.11.1'),
	('C02730','4.2.1.113'),
	('C02730','6.2.1.26'),
	('C02732','1.13.11.26'),
	('C02735','2.1.1.28'),
	('C02737','2.7.8.29'),
	('C02737','2.7.8.8'),
	('C02737','4.1.1.65'),
	('C02737','3.1.1.32'),
	('C02739','3.6.1.31'),
	('C02739','2.4.2.17'),
	('C02740','1.13.12.7'),
	('C02741','3.5.4.19'),
	('C02741','3.6.1.31'),
	('C02743','6.2.1.19'),
	('C02743','3.1.2.22'),
	('C02743','2.3.1.225'),
	('C02743','1.2.1.50'),
	('C02743','2.1.1.63'),
	('C02744','2.8.2.13'),
	('C02745','1.14.15.12'),
	('C02745','1.17.7.3'),
	('C02745','1.19.6.1'),
	('C02749','3.5.1.114'),
	('C02749','4.4.1.6'),
	('C02750','2.3.1.106'),
	('C02752','3.1.1.38'),
	('C02753','3.1.1.68'),
	('C02755','2.3.2.15'),
	('C02756','1.8.4.7'),
	('C02759','5.5.1.10'),
	('C02761','3.2.1.88'),
	('C02763','5.3.2.1'),
	('C02764','5.4.99.12'),
	('C02768','2.7.8.12'),
	('C02768','2.4.1.52'),
	('C02771','1.3.1.47'),
	('C02773','3.1.1.71'),
	('C02773','1.14.16.5'),
	('C02773','2.7.1.93'),
	('C02774','1.1.1.66'),
	('C02775','1.13.11.23'),
	('C02777','3.5.2.13'),
	('C02778','1.7.1.12'),
	('C02779','1.1.3.10'),
	('C02780','1.1.1.346'),
	('C02780','1.1.99.4'),
	('C02780','1.1.1.274'),
	('C02780','1.1.1.215'),
	('C02782','1.1.1.125'),
	('C02785','1.17.4.5'),
	('C02787','4.1.1.14'),
	('C02790','1.14.13.21'),
	('C02791','2.3.1.114'),
	('C02793','1.17.4.5'),
	('C02796','1.3.1.17'),
	('C02797','1.3.99.6'),
	('C02798','4.1.1.82'),
	('C02798','3.11.1.3'),
	('C02798','5.4.2.9'),
	('C02800','2.6.1.43'),
	('C02801','3.5.1.51'),
	('C02802','6.2.1.33'),
	('C02802','3.8.1.7'),
	('C02804','2.8.3.14'),
	('C02805','2.3.2.5'),
	('C02807','1.10.1.1'),
	('C02809','1.14.13.32'),
	('C02811','1.14.13.38'),
	('C02814','1.14.13.220'),
	('C02814','1.14.13.64'),
	('C02814','1.14.13.219'),
	('C02814','1.13.11.37'),
	('C02814','1.6.5.7'),
	('C02814','1.14.14.27'),
	('C02816','2.1.1.60'),
	('C02817','1.1.1.225'),
	('C02821','2.3.1.27'),
	('C02822','2.8.2.18'),
	('C02823','1.16.1.6'),
	('C02824','3.10.1.2'),
	('C02825','1.13.12.6'),
	('C02827','3.1.6.3'),
	('C02835','1.14.13.5'),
	('C02835','6.3.4.8'),
	('C02835','1.2.1.3'),
	('C02837','3.5.2.11'),
	('C02837','5.1.1.15'),
	('C02838','2.3.1.137'),
	('C02839','6.1.1.1'),
	('C02839','2.3.2.21'),
	('C02843','3.1.2.2'),
	('C02843','2.3.1.20'),
	('C02843','2.3.1.86'),
	('C02843','1.2.1.84'),
	('C02843','1.2.1.50'),
	('C02843','1.3.1.93'),
	('C02845','4.1.2.46'),
	('C02846','1.14.13.8'),
	('C02850','3.5.1.14'),
	('C02855','2.7.3.5'),
	('C02858','3.1.1.48'),
	('C02860','2.4.1.118'),
	('C02863','2.4.1.109'),
	('C02864','2.1.1.38'),
	('C02866','2.3.1.131'),
	('C02868','3.1.1.40'),
	('C02869','1.17.7.3'),
	('C02869','1.19.6.1'),
	('C02869','1.14.15.12'),
	('C02871','1.14.11.16'),
	('C02871','3.5.1.52'),
	('C02872','2.4.2.36'),
	('C02872','6.3.1.14'),
	('C02876','2.7.2.15'),
	('C02876','2.3.1.8'),
	('C02876','2.3.1.222'),
	('C02876','2.7.2.1'),
	('C02879','4.2.1.73'),
	('C02880','1.3.1.33'),
	('C02880','1.3.1.75'),
	('C02880','1.3.7.7'),
	('C02882','4.4.1.13'),
	('C02885','2.8.2.16'),
	('C02887','2.3.1.92'),
	('C02888','2.7.1.206'),
	('C02890','2.1.1.89'),
	('C02890','1.3.3.8'),
	('C02892','1.1.3.23'),
	('C02894','1.13.12.8'),
	('C02895','2.7.1.122'),
	('C02896','2.6.1.29'),
	('C02899','1.21.99.1'),
	('C02900','2.4.1.69'),
	('C02903','2.6.1.29'),
	('C02904','1.14.13.46'),
	('C02905','2.4.1.110'),
	('C02906','1.1.1.219'),
	('C02906','1.14.11.23'),
	('C02906','1.14.13.88'),
	('C02906','1.14.11.9'),
	('C02909','1.14.12.12'),
	('C02909','1.1.1.1'),
	('C02912','1.1.1.77'),
	('C02915','1.14.13.37'),
	('C02915','2.1.1.122'),
	('C02916','2.1.1.128'),
	('C02916','4.2.1.78'),
	('C02917','1.1.1.77'),
	('C02918','1.2.3.1'),
	('C02918','2.1.1.1'),
	('C02919','2.4.1.126'),
	('C02920','1.14.13.89'),
	('C02920','1.14.13.53'),
	('C02920','1.3.1.45'),
	('C02921','1.14.13.89'),
	('C02922','2.1.1.65'),
	('C02923','1.3.1.68'),
	('C02923','1.14.13.7'),
	('C02923','1.14.13.1'),
	('C02923','1.13.11.2'),
	('C02923','1.3.1.19'),
	('C02926','2.5.1.4'),
	('C02927','2.3.1.126'),
	('C02929','3.1.2.6'),
	('C02930','5.4.99.4'),
	('C02932','2.5.1.52'),
	('C02933','1.14.13.20'),
	('C02934','2.3.1.50'),
	('C02934','1.1.1.102'),
	('C02937','4.99.1.6'),
	('C02937','1.14.13.125'),
	('C02938','3.5.5.1'),
	('C02938','4.99.1.6'),
	('C02938','3.2.1.147'),
	('C02938','4.2.1.84'),
	('C02939','1.3.8.4'),
	('C02939','1.2.7.7'),
	('C02939','2.3.1.228'),
	('C02939','2.3.1.168'),
	('C02939','1.3.8.7'),
	('C02939','1.2.1.25'),
	('C02939','2.3.1.156'),
	('C02940','1.3.99.5'),
	('C02941','1.3.99.4'),
	('C02943','1.1.1.230'),
	('C02944','5.3.3.8'),
	('C02945','2.3.1.77'),
	('C02946','3.5.1.63'),
	('C02946','1.2.1.3'),
	('C02947','2.3.1.133'),
	('C02947','1.14.13.36'),
	('C02948','4.1.2.35'),
	('C02949','3.8.1.7'),
	('C02949','6.2.1.27'),
	('C02949','1.3.7.9'),
	('C02949','3.1.2.23'),
	('C02951','2.1.1.69'),
	('C02952','1.14.13.162'),
	('C02953','1.1.1.153'),
	('C02954','3.5.1.11'),
	('C02956','1.1.1.201'),
	('C02960','3.1.4.41'),
	('C02960','2.7.1.138'),
	('C02960','3.1.3.4'),
	('C02962','2.7.1.55'),
	('C02962','5.3.1.6'),
	('C02964','5.1.3.11'),
	('C02965','2.7.1.1'),
	('C02967','2.1.1.37'),
	('C02970','2.4.1.199'),
	('C02970','2.4.2.45'),
	('C02970','2.7.8.35'),
	('C02972','1.8.1.4'),
	('C02972','2.1.2.10'),
	('C02975','1.1.1.280'),
	('C02975','1.1.1.279'),
	('C02977','1.1.1.187'),
	('C02977','1.1.1.135'),
	('C02979','3.1.3.19'),
	('C02980','2.4.1.181'),
	('C02982','1.1.3.27'),
	('C02984','6.1.1.23'),
	('C02984','6.1.1.12'),
	('C02985','2.7.1.52'),
	('C02985','2.7.7.30'),
	('C02986','2.3.2.5'),
	('C02987','6.1.1.17'),
	('C02987','6.1.1.24'),
	('C02987','1.2.1.70'),
	('C02988','6.1.1.21'),
	('C02989','1.8.4.14'),
	('C02989','1.8.4.13'),
	('C02990','2.3.1.21'),
	('C02991','1.1.1.378'),
	('C02991','1.1.1.377'),
	('C02991','1.1.1.173'),
	('C02991','3.1.1.65'),
	('C02992','6.1.1.3'),
	('C02993','6.3.2.24'),
	('C02994','1.1.1.113'),
	('C02995','3.2.1.122'),
	('C02995','3.1.3.90'),
	('C02995','2.7.1.208'),
	('C02997','2.3.1.33'),
	('C02998','3.5.1.76'),
	('C02999','3.5.1.28'),
	('C03000','5.1.3.8'),
	('C03001','3.5.1.72'),
	('C03002','2.3.1.138'),
	('C03003','2.4.1.196'),
	('C03004','1.14.13.41'),
	('C03005','2.1.1.111'),
	('C03005','6.2.1.32'),
	('C03011','2.3.1.88'),
	('C03012','1.3.1.29'),
	('C03012','1.14.13.1'),
	('C03012','1.14.13.135'),
	('C03012','1.13.11.56'),
	('C03012','1.3.1.20'),
	('C03015','4.3.1.13'),
	('C03016','2.7.11.28'),
	('C03018','3.2.1.123'),
	('C03019','3.1.1.51'),
	('C03021','2.4.1.94'),
	('C03021','2.4.99.18'),
	('C03022','3.5.3.15'),
	('C03023','1.8.4.11'),
	('C03023','1.8.4.12'),
	('C03024','1.14.13.152'),
	('C03024','1.14.14.1'),
	('C03024','1.14.14.14'),
	('C03024','1.14.14.29'),
	('C03024','1.14.14.23'),
	('C03024','1.14.14.32'),
	('C03024','1.14.15.3'),
	('C03024','1.14.14.31'),
	('C03024','1.6.2.4'),
	('C03025','1.97.1.12'),
	('C03025','1.10.9.1'),
	('C03027','1.14.13.54'),
	('C03027','1.14.99.4'),
	('C03028','2.7.4.15'),
	('C03028','2.7.4.3'),
	('C03028','3.6.1.28'),
	('C03029','1.16.1.2'),
	('C03030','4.1.1.66'),
	('C03030','1.14.11.6'),
	('C03032','1.21.99.1'),
	('C03033','2.4.1.17'),
	('C03033','3.2.1.31'),
	('C03034','1.1.1.186'),
	('C03035','1.14.19.3'),
	('C03035','3.1.2.2'),
	('C03036','1.21.3.4'),
	('C03037','1.14.13.162'),
	('C03037','1.1.1.327'),
	('C03040','1.21.3.5'),
	('C03042','1.1.1.98'),
	('C03043','1.5.3.6'),
	('C03043','1.5.99.4'),
	('C03044','1.1.1.4'),
	('C03045','1.1.1.99'),
	('C03046','1.1.1.76'),
	('C03047','3.5.3.20'),
	('C03049','2.4.1.158'),
	('C03050','5.1.99.2'),
	('C03052','1.14.13.19'),
	('C03056','1.14.13.10'),
	('C03056','3.7.1.19'),
	('C03057','4.1.2.34'),
	('C03057','1.2.1.78'),
	('C03058','2.8.3.12'),
	('C03062','2.3.1.98'),
	('C03063','4.1.1.68'),
	('C03064','1.1.1.129'),
	('C03065','3.5.3.17'),
	('C03066','4.1.1.16'),
	('C03067','1.2.1.7'),
	('C03067','1.2.1.28'),
	('C03067','1.2.1.64'),
	('C03067','1.1.1.97'),
	('C03069','2.3.1.16'),
	('C03069','4.2.1.17'),
	('C03069','6.4.1.4'),
	('C03069','1.3.8.4'),
	('C03069','1.3.8.7'),
	('C03070','1.1.1.392'),
	('C03070','1.1.1.393'),
	('C03070','1.1.1.391'),
	('C03070','1.1.1.52'),
	('C03071','1.7.3.5'),
	('C03072','1.1.1.213'),
	('C03072','1.1.1.357'),
	('C03072','1.1.1.50'),
	('C03077','1.14.12.9'),
	('C03077','3.5.5.5'),
	('C03078','1.13.12.1'),
	('C03078','3.5.1.4'),
	('C03079','2.6.1.23'),
	('C03081','3.1.1.56'),
	('C03082','1.2.1.11'),
	('C03082','2.7.2.4'),
	('C03087','3.5.1.63'),
	('C03088','1.14.11.6'),
	('C03089','3.2.2.9'),
	('C03089','2.7.1.100'),
	('C03089','3.2.2.16'),
	('C03090','6.3.4.13'),
	('C03090','6.3.4.7'),
	('C03090','2.4.2.14'),
	('C03091','1.3.1.3'),
	('C03092','1.1.1.241'),
	('C03092','1.14.13.156'),
	('C03093','2.4.1.104'),
	('C03097','2.4.1.35'),
	('C03098','5.99.1.1'),
	('C03103','4.1.99.3'),
	('C03105','2.1.1.59'),
	('C03106','3.1.1.58'),
	('C03107','1.1.1.119'),
	('C03110','2.1.1.113'),
	('C03112','2.1.3.7'),
	('C03112','1.14.11.26'),
	('C03112','3.1.1.41'),
	('C03112','2.3.1.175'),
	('C03113','3.1.8.2'),
	('C03114','1.13.11.79'),
	('C03114','2.4.2.21'),
	('C03115','2.7.4.18'),
	('C03117','1.1.1.281'),
	('C03117','1.1.1.187'),
	('C03120','3.1.4.46'),
	('C03121','3.1.4.50'),
	('C03124','2.3.2.7'),
	('C03125','2.5.1.73'),
	('C03125','6.1.1.16'),
	('C03127','6.1.1.5'),
	('C03129','2.5.1.26'),
	('C03134','3.5.1.56'),
	('C03135','2.3.1.36'),
	('C03136','2.7.1.162'),
	('C03137','2.3.1.34'),
	('C03139','3.5.3.14'),
	('C03141','2.3.1.144'),
	('C03142','2.4.1.71'),
	('C03145','3.5.1.31'),
	('C03147','2.3.1.113'),
	('C03148','1.5.3.2'),
	('C03149','2.7.3.4'),
	('C03150','3.2.2.3'),
	('C03150','3.2.2.1'),
	('C03150','2.4.2.1'),
	('C03150','1.10.5.1'),
	('C03150','2.7.1.22'),
	('C03150','3.1.3.5'),
	('C03153','6.3.4.12'),
	('C03154','2.3.1.82'),
	('C03156','2.3.1.130'),
	('C03157','2.7.11.26'),
	('C03160','6.2.1.26'),
	('C03160','4.1.3.36'),
	('C03161','1.14.14.1'),
	('C03161','1.14.13.152'),
	('C03161','1.14.14.14'),
	('C03161','1.14.14.23'),
	('C03161','1.14.14.32'),
	('C03161','1.14.14.31'),
	('C03161','1.14.14.29'),
	('C03161','1.14.15.3'),
	('C03161','1.6.2.4'),
	('C03162','1.10.9.1'),
	('C03162','1.97.1.12'),
	('C03164','1.3.1.49'),
	('C03166','2.7.3.1'),
	('C03167','1.1.1.309'),
	('C03167','4.1.1.82'),
	('C03167','3.11.1.1'),
	('C03167','2.6.1.37'),
	('C03169','3.2.2.8'),
	('C03169','2.4.2.2'),
	('C03170','1.17.4.1'),
	('C03170','1.8.1.12'),
	('C03170','1.11.1.15'),
	('C03172','2.1.1.12'),
	('C03172','2.1.1.10'),
	('C03172','2.1.1.280'),
	('C03173','2.1.1.3'),
	('C03174','3.1.2.13'),
	('C03175','2.7.1.71'),
	('C03175','2.5.1.19'),
	('C03178','5.5.1.3'),
	('C03179','1.16.1.2'),
	('C03185','3.1.3.42'),
	('C03186','3.1.3.42'),
	('C03187','1.1.1.344'),
	('C03187','1.1.1.134'),
	('C03187','1.1.1.339'),
	('C03187','5.1.3.25'),
	('C03188','6.2.1.23'),
	('C03189','3.1.4.42'),
	('C03189','3.1.3.21'),
	('C03190','3.1.7.3'),
	('C03190','5.5.1.8'),
	('C03193','2.3.2.2'),
	('C03194','1.1.1.75'),
	('C03194','3.5.1.90'),
	('C03194','6.3.1.10'),
	('C03195','4.2.1.53'),
	('C03196','1.1.99.2'),
	('C03197','1.1.99.24'),
	('C03198','1.1.3.19'),
	('C03198','5.1.2.2'),
	('C03198','1.13.11.46'),
	('C03198','1.14.16.6'),
	('C03198','1.1.3.46'),
	('C03198','1.1.99.31'),
	('C03201','2.4.1.45'),
	('C03201','2.7.8.2'),
	('C03201','2.7.8.1'),
	('C03201','3.1.3.4'),
	('C03203','1.13.11.38'),
	('C03203','1.14.13.135'),
	('C03203','1.14.13.1'),
	('C03204','6.3.4.17'),
	('C03205','1.1.1.145'),
	('C03205','1.14.14.16'),
	('C03205','1.14.15.4'),
	('C03205','5.3.3.1'),
	('C03205','5.3.1.21'),
	('C03205','1.3.1.22'),
	('C03206','1.14.13.38'),
	('C03207','4.2.1.98'),
	('C03210','1.5.1.17'),
	('C03212','3.5.4.11'),
	('C03215','3.1.3.63'),
	('C03217','2.2.1.5'),
	('C03219','1.14.13.117'),
	('C03219','2.1.1.91'),
	('C03219','1.14.13.118'),
	('C03220','5.2.1.9'),
	('C03221','1.3.1.38'),
	('C03221','4.2.1.17'),
	('C03221','1.3.1.8'),
	('C03221','5.3.3.8'),
	('C03221','4.2.1.74'),
	('C03221','1.3.3.6'),
	('C03221','1.3.8.7'),
	('C03221','1.3.8.8'),
	('C03223','4.1.1.69'),
	('C03226','2.1.1.64'),
	('C03227','1.14.13.9'),
	('C03227','3.7.1.3'),
	('C03227','2.6.1.7'),
	('C03228','1.1.99.26'),
	('C03230','1.13.99.3'),
	('C03231','6.4.1.4'),
	('C03231','4.2.1.18'),
	('C03232','2.6.1.52'),
	('C03232','1.1.1.95'),
	('C03233','1.3.1.64'),
	('C03233','4.1.1.55'),
	('C03237','2.8.3.14'),
	('C03238','1.3.1.22'),
	('C03239','1.4.3.14'),
	('C03239','3.5.1.17'),
	('C03239','2.6.1.21'),
	('C03240','2.3.1.94'),
	('C03240','1.14.13.188'),
	('C03241','1.14.13.66'),
	('C03242','3.1.2.2'),
	('C03245','2.4.2.30'),
	('C03248','4.1.1.78'),
	('C03254','3.1.8.1'),
	('C03256','3.1.1.70'),
	('C03263','4.1.1.37'),
	('C03263','1.3.3.15'),
	('C03263','1.3.98.3'),
	('C03263','1.3.3.3'),
	('C03267','3.1.3.54'),
	('C03268','2.7.8.19'),
	('C03268','3.1.4.51'),
	('C03269','1.1.3.9'),
	('C03272','3.2.1.49'),
	('C03272','3.2.1.52'),
	('C03272','2.4.1.88'),
	('C03272','2.4.1.79'),
	('C03273','1.2.1.20'),
	('C03273','2.6.1.48'),
	('C03277','2.6.1.38'),
	('C03277','1.1.1.111'),
	('C03281','2.7.1.95'),
	('C03283','2.3.1.178'),
	('C03283','4.1.1.86'),
	('C03283','2.6.1.76'),
	('C03283','2.6.1.46'),
	('C03284','2.6.1.22'),
	('C03284','2.6.1.18'),
	('C03287','2.7.2.11'),
	('C03287','1.2.1.41'),
	('C03289','1.1.3.8'),
	('C03290','4.1.2.26'),
	('C03291','2.7.1.53'),
	('C03291','4.1.1.85'),
	('C03291','5.1.3.22'),
	('C03294','2.1.2.9'),
	('C03296','3.5.3.23'),
	('C03296','2.3.1.109'),
	('C03297','2.3.1.60'),
	('C03297','2.3.1.81'),
	('C03298','2.1.1.44'),
	('C03300','2.4.2.40'),
	('C03302','1.14.15.1'),
	('C03302','1.14.15.10'),
	('C03302','1.18.1.5'),
	('C03303','1.14.17.3'),
	('C03303','4.3.2.5'),
	('C03306','2.1.1.77'),
	('C03309','3.2.1.105'),
	('C03312','2.4.2.16'),
	('C03313','1.6.5.2'),
	('C03313','4.1.1.90'),
	('C03314','5.5.1.3'),
	('C03315','2.4.2.37'),
	('C03315','3.2.2.24'),
	('C03317','3.1.1.43'),
	('C03318','2.3.1.108'),
	('C03319','2.4.1.331'),
	('C03319','5.1.3.25'),
	('C03319','2.4.1.289'),
	('C03319','1.1.1.133'),
	('C03323','2.4.1.9'),
	('C03323','2.4.1.100'),
	('C03325','1.14.11.14'),
	('C03325','1.14.11.11'),
	('C03329','1.14.21.5'),
	('C03329','2.1.1.122'),
	('C03329','1.3.3.8'),
	('C03336','1.14.14.19'),
	('C03338','1.14.13.6'),
	('C03341','1.4.1.12'),
	('C03343','3.1.1.60'),
	('C03344','2.3.1.16'),
	('C03344','1.1.1.178'),
	('C03344','2.3.1.9'),
	('C03344','1.1.1.35'),
	('C03345','2.3.1.93'),
	('C03345','1.3.8.1'),
	('C03345','1.3.8.5'),
	('C03345','1.3.8.7'),
	('C03345','1.3.99.12'),
	('C03345','4.2.1.17'),
	('C03351','1.1.1.97'),
	('C03354','4.1.1.57'),
	('C03356','4.2.1.11'),
	('C03357','3.5.1.51'),
	('C03359','1.14.11.43'),
	('C03359','1.14.11.44'),
	('C03360','3.1.3.2'),
	('C03360','3.1.3.41'),
	('C03360','3.1.3.1'),
	('C03361','3.6.1.20'),
	('C03363','2.3.2.2'),
	('C03365','1.1.1.143'),
	('C03366','4.2.3.134'),
	('C03366','2.7.1.81'),
	('C03368','2.7.1.119'),
	('C03371','1.2.1.50'),
	('C03371','6.2.1.19'),
	('C03372','2.3.1.42'),
	('C03372','2.5.1.26'),
	('C03372','1.1.1.101'),
	('C03373','6.3.3.1'),
	('C03373','4.1.99.17'),
	('C03373','6.3.4.18'),
	('C03373','4.1.1.21'),
	('C03374','2.4.1.95'),
	('C03375','2.5.1.23'),
	('C03375','4.1.1.96'),
	('C03375','2.5.1.126'),
	('C03383','1.1.1.120'),
	('C03383','1.1.1.48'),
	('C03383','3.1.1.25'),
	('C03387','3.1.1.19'),
	('C03391','2.1.1.72'),
	('C03391','1.14.11.51'),
	('C03392','2.1.1.3'),
	('C03393','1.1.1.290'),
	('C03393','1.2.1.72'),
	('C03394','5.3.1.33'),
	('C03394','4.1.2.2'),
	('C03394','5.1.3.38'),
	('C03395','2.1.1.15'),
	('C03401','6.3.2.46'),
	('C03401','2.3.1.58'),
	('C03402','6.1.1.22'),
	('C03402','6.3.5.6'),
	('C03404','2.8.2.9'),
	('C03406','4.3.2.1'),
	('C03406','6.3.4.5'),
	('C03409','3.5.3.5'),
	('C03410','2.7.7.43'),
	('C03410','1.14.18.2'),
	('C03412','2.3.1.96'),
	('C03414','2.3.1.112'),
	('C03415','3.5.3.23'),
	('C03415','2.6.1.81'),
	('C03415','2.1.3.11'),
	('C03418','3.1.4.37'),
	('C03419','3.1.4.16'),
	('C03419','2.7.1.77'),
	('C03422','2.3.1.142'),
	('C03423','2.4.1.203'),
	('C03427','2.5.1.99'),
	('C03427','2.5.1.32'),
	('C03428','2.5.1.103'),
	('C03428','1.3.1.97'),
	('C03428','1.3.1.96'),
	('C03428','2.5.1.21'),
	('C03428','2.5.1.96'),
	('C03431','3.5.4.28'),
	('C03434','1.14.13.50'),
	('C03440','5.1.1.8'),
	('C03440','1.4.3.3'),
	('C03442','2.4.2.27'),
	('C03446','2.1.1.35'),
	('C03446','2.1.1.74'),
	('C03448','1.1.1.327'),
	('C03448','1.14.15.1'),
	('C03451','4.4.1.5'),
	('C03451','3.1.2.6'),
	('C03453','3.5.99.5'),
	('C03453','5.3.2.6'),
	('C03453','4.1.1.77'),
	('C03453','1.13.11.35'),
	('C03454','2.7.8.1'),
	('C03454','2.7.8.22'),
	('C03454','3.1.4.3'),
	('C03455','2.3.1.135'),
	('C03455','2.3.1.76'),
	('C03455','3.1.1.63'),
	('C03458','1.14.13.10'),
	('C03459','1.1.1.93'),
	('C03459','1.1.1.92'),
	('C03460','1.3.99.12'),
	('C03460','1.3.8.7'),
	('C03460','1.3.8.1'),
	('C03460','4.2.1.17'),
	('C03461','1.1.1.216'),
	('C03461','1.1.1.354'),
	('C03461','1.8.3.6'),
	('C03461','1.8.3.5'),
	('C03462','2.7.7.47'),
	('C03463','3.1.3.32'),
	('C03467','1.4.1.9'),
	('C03470','3.2.1.105'),
	('C03470','4.3.3.2'),
	('C03474','1.7.1.9'),
	('C03475','3.1.3.33'),
	('C03476','1.3.1.41'),
	('C03479','6.3.3.2'),
	('C03479','2.1.2.5'),
	('C03479','2.1.2.10'),
	('C03483','3.6.1.60'),
	('C03483','3.6.1.14'),
	('C03485','1.1.1.90'),
	('C03485','1.1.1.91'),
	('C03485','1.1.3.7'),
	('C03486','2.7.7.57'),
	('C03491','1.1.5.7'),
	('C03492','2.7.1.33'),
	('C03492','6.3.2.36'),
	('C03492','6.3.2.5'),
	('C03493','2.6.1.72'),
	('C03494','2.7.1.27'),
	('C03495','2.7.4.19'),
	('C03495','2.1.1.54'),
	('C03503','2.4.1.181'),
	('C03505','1.1.1.7'),
	('C03506','4.1.1.48'),
	('C03506','4.2.1.20'),
	('C03506','4.1.2.8'),
	('C03508','2.3.1.29'),
	('C03508','1.1.1.381'),
	('C03508','1.1.1.103'),
	('C03511','2.3.2.20'),
	('C03511','6.1.1.20'),
	('C03512','6.1.1.2'),
	('C03514','2.4.1.210'),
	('C03514','3.1.1.36'),
	('C03515','2.4.1.190'),
	('C03515','2.4.1.189'),
	('C03516','6.6.1.1'),
	('C03516','2.1.1.11'),
	('C03517','3.1.7.3'),
	('C03519','2.3.1.53'),
	('C03523','3.1.1.29'),
	('C03524','2.3.1.59'),
	('C03526','2.3.1.132'),
	('C03527','1.14.99.21'),
	('C03529','1.13.11.26'),
	('C03530','1.4.3.13'),
	('C03531','1.4.3.13'),
	('C03536','3.2.2.10'),
	('C03537','2.3.1.11'),
	('C03539','3.2.2.9'),
	('C03539','4.4.1.21'),
	('C03541','3.4.19.9'),
	('C03541','6.3.2.17'),
	('C03544','1.8.4.7'),
	('C03546','3.1.3.57'),
	('C03546','3.1.3.25'),
	('C03547','1.14.15.3'),
	('C03548','3.3.2.4'),
	('C03557','2.6.1.37'),
	('C03557','1.14.11.46'),
	('C03557','2.7.7.14'),
	('C03561','1.1.1.36'),
	('C03561','4.2.1.55'),
	('C03561','5.1.2.3'),
	('C03564','4.2.1.77'),
	('C03564','1.5.1.1'),
	('C03564','1.5.1.49'),
	('C03564','1.5.99.13'),
	('C03564','1.4.3.3'),
	('C03564','1.5.1.21'),
	('C03565','2.7.7.46'),
	('C03567','1.3.1.51'),
	('C03572','5.5.1.7'),
	('C03573','3.2.1.112'),
	('C03574','1.13.11.17'),
	('C03575','2.1.1.26'),
	('C03576','1.3.4.1'),
	('C03576','2.1.1.253'),
	('C03576','2.1.1.251'),
	('C03576','1.8.1.5'),
	('C03576','1.8.98.1'),
	('C03576','2.1.1.90'),
	('C03576','2.1.1.86'),
	('C03576','2.1.1.250'),
	('C03576','2.1.1.249'),
	('C03576','2.1.1.248'),
	('C03576','2.1.1.247'),
	('C03576','2.1.1.246'),
	('C03576','4.4.1.23'),
	('C03577','1.14.13.34'),
	('C03579','1.14.11.13'),
	('C03582','2.3.1.95'),
	('C03582','2.1.1.240'),
	('C03584','2.5.1.53'),
	('C03585','1.13.11.1'),
	('C03585','5.5.1.7'),
	('C03585','5.5.1.1'),
	('C03586','3.1.1.24'),
	('C03586','4.1.1.44'),
	('C03586','5.3.3.4'),
	('C03587','2.3.1.77'),
	('C03588','1.3.1.22'),
	('C03589','4.1.3.39'),
	('C03589','4.2.1.80'),
	('C03590','2.6.1.72'),
	('C03590','2.6.1.103'),
	('C03590','4.1.1.7'),
	('C03590','1.1.3.46'),
	('C03590','1.1.99.31'),
	('C03594','1.1.1.181'),
	('C03594','1.14.14.23'),
	('C03595','1.14.19.44'),
	('C03595','3.1.2.2'),
	('C03597','3.1.1.39'),
	('C03598','1.1.1.342'),
	('C03598','5.1.3.10'),
	('C03599','5.1.3.10'),
	('C03600','4.2.99.12'),
	('C03601','2.3.1.28'),
	('C03604','5.3.1.34'),
	('C03604','5.1.3.39'),
	('C03604','5.3.1.33'),
	('C03606','2.7.1.102'),
	('C03607','2.7.4.13'),
	('C03614','3.6.1.14'),
	('C03617','3.5.1.88'),
	('C03618','5.4.99.1'),
	('C03618','4.3.1.2'),
	('C03619','3.2.1.63'),
	('C03620','3.5.1.4'),
	('C03620','4.2.1.84'),
	('C03621','2.3.1.56'),
	('C03622','2.3.1.56'),
	('C03623','3.5.1.36'),
	('C03624','2.7.3.6'),
	('C03625','3.1.1.48'),
	('C03626','3.5.3.18'),
	('C03632','3.6.1.44'),
	('C03633','5.2.1.8'),
	('C03634','3.1.1.51'),
	('C03636','2.3.2.13'),
	('C03638','6.5.1.5'),
	('C03638','6.5.1.4'),
	('C03640','2.3.1.24'),
	('C03640','2.7.8.10'),
	('C03641','2.4.1.173'),
	('C03642','2.8.2.14'),
	('C03643','2.7.11.6'),
	('C03646','1.8.1.13'),
	('C03648','1.1.1.219'),
	('C03648','1.14.11.19'),
	('C03648','1.17.1.3'),
	('C03649','2.3.2.9'),
	('C03652','4.1.3.32'),
	('C03652','4.2.1.85'),
	('C03656','2.3.1.247'),
	('C03656','1.4.1.11'),
	('C03657','4.1.3.36'),
	('C03657','3.1.2.28'),
	('C03657','2.5.1.74'),
	('C03658','1.14.16.5'),
	('C03659','2.1.1.40'),
	('C03660','2.1.1.39'),
	('C03661','2.4.1.99'),
	('C03666','1.13.11.28'),
	('C03667','1.1.1.185'),
	('C03671','1.1.1.312'),
	('C03671','3.1.1.57'),
	('C03671','1.13.11.8'),
	('C03671','1.13.11.3'),
	('C03672','1.1.1.237'),
	('C03672','1.1.1.222'),
	('C03673','3.1.3.28'),
	('C03674','2.1.3.7'),
	('C03676','1.13.11.37'),
	('C03677','1.3.1.36'),
	('C03678','4.1.1.16'),
	('C03679','3.5.5.5'),
	('C03680','1.17.3.2'),
	('C03680','4.2.1.49'),
	('C03680','3.5.2.7'),
	('C03681','1.1.1.149'),
	('C03681','1.3.1.22'),
	('C03681','1.1.1.278'),
	('C03681','1.1.1.213'),
	('C03682','2.6.1.65'),
	('C03683','2.1.1.109'),
	('C03684','1.5.4.1'),
	('C03684','1.1.1.220'),
	('C03684','4.2.3.12'),
	('C03684','1.1.1.153'),
	('C03684','1.1.1.325'),
	('C03686','2.1.1.110'),
	('C03686','1.14.13.175'),
	('C03687','2.3.1.57'),
	('C03688','2.7.8.7'),
	('C03688','2.7.7.66'),
	('C03688','2.7.7.61'),
	('C03688','3.1.4.14'),
	('C03690','3.1.1.60'),
	('C03691','2.7.7.43'),
	('C03691','1.14.18.2'),
	('C03692','5.1.3.34'),
	('C03692','3.2.1.22'),
	('C03692','2.4.1.46'),
	('C03692','2.3.1.134'),
	('C03692','2.3.1.141'),
	('C03692','2.4.99.5'),
	('C03692','2.4.1.241'),
	('C03692','2.4.1.184'),
	('C03692','3.1.1.26'),
	('C03701','3.2.1.62'),
	('C03702','2.1.1.43'),
	('C03703','3.5.2.4'),
	('C03706','2.7.8.17'),
	('C03707','2.3.1.69'),
	('C03708','3.1.1.53'),
	('C03710','3.5.1.58'),
	('C03711','2.1.1.28'),
	('C03712','2.3.1.127'),
	('C03715','1.1.1.101'),
	('C03715','2.5.1.26'),
	('C03715','2.7.1.84'),
	('C03716','3.1.1.44'),
	('C03717','1.13.12.5'),
	('C03719','2.4.1.195'),
	('C03721','2.8.2.20'),
	('C03722','2.5.1.72'),
	('C03722','2.4.2.19'),
	('C03723','1.17.4.1'),
	('C03724','1.3.99.8'),
	('C03725','2.3.1.49'),
	('C03726','4.4.1.4'),
	('C03727','4.5.1.5'),
	('C03731','2.7.1.87'),
	('C03733','5.4.99.9'),
	('C03735','5.4.2.2'),
	('C03737','2.7.7.64'),
	('C03737','2.7.7.11'),
	('C03738','2.3.2.14'),
	('C03739','1.1.1.174'),
	('C03740','2.3.2.4'),
	('C03740','2.3.2.2'),
	('C03741','1.2.1.70'),
	('C03741','5.4.3.8'),
	('C03742','4.1.2.11'),
	('C03742','3.2.1.21'),
	('C03742','2.4.1.85'),
	('C03742','1.14.13.68'),
	('C03743','1.97.1.2'),
	('C03747','1.14.99.14'),
	('C03748','4.2.1.98'),
	('C03750','1.3.1.40'),
	('C03752','2.7.1.203'),
	('C03752','4.3.1.9'),
	('C03754','2.7.2.14'),
	('C03758','4.3.3.4'),
	('C03758','4.3.3.3'),
	('C03758','4.1.1.25'),
	('C03758','4.1.1.28'),
	('C03758','4.2.1.78'),
	('C03758','1.14.18.1'),
	('C03758','1.14.17.1'),
	('C03758','1.4.3.4'),
	('C03758','1.4.3.21'),
	('C03758','2.1.1.6'),
	('C03758','1.4.9.2'),
	('C03761','3.1.2.5'),
	('C03761','2.8.3.13'),
	('C03764','1.7.1.11'),
	('C03764','1.7.1.6'),
	('C03765','1.2.1.53'),
	('C03765','1.1.1.90'),
	('C03765','1.2.1.29'),
	('C03765','1.2.1.5'),
	('C03765','1.4.3.4'),
	('C03765','1.4.9.2'),
	('C03765','1.4.3.21'),
	('C03765','4.2.1.78'),
	('C03765','4.2.1.87'),
	('C03765','4.2.1.88'),
	('C03765','4.1.1.80'),
	('C03766','1.14.13.68'),
	('C03767','1.1.1.226'),
	('C03771','2.6.1.84'),
	('C03771','4.1.1.75'),
	('C03771','1.4.99.6'),
	('C03771','1.4.3.3'),
	('C03771','2.6.1.21'),
	('C03771','2.1.1.243'),
	('C03772','1.1.1.152'),
	('C03772','1.3.1.3'),
	('C03772','1.1.1.50'),
	('C03773','2.3.1.18'),
	('C03785','4.1.2.40'),
	('C03785','2.7.1.56'),
	('C03785','2.7.1.11'),
	('C03785','2.7.1.144'),
	('C03786','2.7.4.13'),
	('C03788','2.7.99.1'),
	('C03789','3.1.6.11'),
	('C03789','3.2.1.56'),
	('C03790','1.5.1.22'),
	('C03792','1.1.1.233'),
	('C03793','1.14.11.8'),
	('C03794','6.3.4.4'),
	('C03794','4.3.2.2'),
	('C03796','2.7.1.136'),
	('C03797','1.13.12.7'),
	('C03798','5.2.1.8'),
	('C03799','2.4.1.78'),
	('C03800','2.1.1.63'),
	('C03802','1.17.4.2'),
	('C03803','2.3.1.128'),
	('C03804','3.1.3.14'),
	('C03806','3.5.2.6'),
	('C03808','3.1.3.49'),
	('C03817','1.1.1.111'),
	('C03819','3.1.1.52'),
	('C03820','2.7.8.2'),
	('C03820','3.1.3.59'),
	('C03820','3.1.1.71'),
	('C03820','2.3.1.125'),
	('C03823','2.4.1.45'),
	('C03824','1.13.11.74'),
	('C03824','4.1.1.45'),
	('C03824','1.2.1.32'),
	('C03826','4.2.1.82'),
	('C03826','4.2.1.141'),
	('C03826','4.1.2.28'),
	('C03826','4.2.1.5'),
	('C03827','4.2.1.68'),
	('C03832','2.6.1.26'),
	('C03836','1.1.1.145'),
	('C03837','3.1.1.56'),
	('C03838','6.3.4.13'),
	('C03838','2.1.2.2'),
	('C03840','1.14.99.27'),
	('C03844','1.1.1.142'),
	('C03845','5.3.3.5'),
	('C03845','1.3.1.72'),
	('C03846','2.6.1.65'),
	('C03847','3.2.1.85'),
	('C03848','2.4.1.167'),
	('C03849','2.7.1.94'),
	('C03851','2.7.7.51'),
	('C03852','1.1.1.50'),
	('C03852','1.1.1.53'),
	('C03855','3.2.1.104'),
	('C03859','2.4.1.58'),
	('C03860','3.5.4.23'),
	('C03861','1.10.3.1'),
	('C03861','1.1.3.14'),
	('C03862','3.1.4.49'),
	('C03862','2.4.1.83'),
	('C03862','2.4.1.109'),
	('C03864','1.1.1.279'),
	('C03865','1.1.1.280'),
	('C03866','2.1.1.112'),
	('C03868','2.3.1.72'),
	('C03868','2.4.1.156'),
	('C03868','2.4.2.34'),
	('C03871','1.4.1.16'),
	('C03872','3.1.4.13'),
	('C03872','2.7.8.4'),
	('C03874','2.7.11.7'),
	('C03875','2.7.11.18'),
	('C03875','3.1.3.53'),
	('C03880','3.1.1.29'),
	('C03881','2.3.1.97'),
	('C03882','2.3.1.145'),
	('C03885','2.5.1.39'),
	('C03887','1.13.12.6'),
	('C03888','1.13.12.8'),
	('C03889','2.3.1.135'),
	('C03889','2.3.1.251'),
	('C03892','3.1.3.27'),
	('C03892','2.7.8.5'),
	('C03894','1.1.1.7'),
	('C03895','1.8.4.11'),
	('C03897','2.8.2.28'),
	('C03898','2.8.2.28'),
	('C03899','3.1.2.6'),
	('C03900','2.6.1.75'),
	('C03901','1.5.1.25'),
	('C03904','3.5.1.43'),
	('C03905','3.5.1.43'),
	('C03906','2.7.7.64'),
	('C03906','2.7.1.46'),
	('C03910','4.1.2.33'),
	('C03912','1.14.11.34'),
	('C03912','1.2.1.88'),
	('C03912','1.5.5.2'),
	('C03912','2.3.1.226'),
	('C03912','1.5.1.2'),
	('C03914','2.1.1.47'),
	('C03917','1.1.1.210'),
	('C03917','1.1.1.53'),
	('C03917','1.1.1.50'),
	('C03917','1.3.1.22'),
	('C03918','5.5.1.11'),
	('C03920','2.1.1.248'),
	('C03920','2.1.1.249'),
	('C03920','2.1.1.86'),
	('C03920','2.1.1.90'),
	('C03920','2.1.1.250'),
	('C03920','2.1.1.251'),
	('C03920','2.1.1.253'),
	('C03920','2.8.4.1'),
	('C03920','2.1.1.246'),
	('C03920','2.1.1.247'),
	('C03921','4.1.2.20'),
	('C03921','4.2.1.40'),
	('C03922','2.3.1.81'),
	('C03925','3.5.5.6'),
	('C03926','1.1.1.125'),
	('C03927','3.5.1.61'),
	('C03930','1.1.1.230'),
	('C03933','2.3.2.1'),
	('C03935','1.14.99.11'),
	('C03939','4.1.1.87'),
	('C03939','2.3.1.38'),
	('C03939','2.3.1.187'),
	('C03939','2.3.1.41'),
	('C03939','2.3.1.86'),
	('C03939','2.3.1.85'),
	('C03939','6.2.1.35'),
	('C03939','2.1.3.10'),
	('C03939','2.3.1.179'),
	('C03941','2.1.1.60'),
	('C03942','2.4.1.74'),
	('C03943','5.4.3.5'),
	('C03943','1.4.1.12'),
	('C03944','1.14.13.175'),
	('C03944','2.1.1.110'),
	('C03946','2.3.1.116'),
	('C03946','2.4.1.159'),
	('C03946','2.4.1.239'),
	('C03946','2.4.1.91'),
	('C03947','3.1.4.42'),
	('C03951','2.4.1.81'),
	('C03951','2.4.1.236'),
	('C03954','1.7.1.12'),
	('C03955','6.3.2.38'),
	('C03955','2.3.1.102'),
	('C03955','6.3.2.39'),
	('C03956','3.2.1.123'),
	('C03957','1.14.11.16'),
	('C03959','2.7.11.23'),
	('C03961','4.3.1.20'),
	('C03961','4.1.3.14'),
	('C03962','2.4.1.127'),
	('C03963','2.4.1.193'),
	('C03964','1.1.1.222'),
	('C03968','1.1.1.101'),
	('C03968','3.1.4.39'),
	('C03968','2.7.1.93'),
	('C03968','2.3.1.105'),
	('C03972','2.6.1.83'),
	('C03972','2.3.1.117'),
	('C03972','2.3.1.89'),
	('C03972','1.17.1.8'),
	('C03974','2.7.1.94'),
	('C03974','2.3.1.198'),
	('C03974','2.3.1.52'),
	('C03975','1.17.3.1'),
	('C03979','4.1.2.53'),
	('C03979','1.1.1.401'),
	('C03979','4.2.1.90'),
	('C03981','5.3.2.2'),
	('C03981','4.1.1.78'),
	('C03982','2.1.1.91'),
	('C03985','1.14.13.151'),
	('C03986','2.1.1.97'),
	('C03989','2.4.1.166'),
	('C03990','1.14.13.94'),
	('C03990','1.14.13.97'),
	('C03990','1.1.1.52'),
	('C03990','1.1.1.392'),
	('C03993','2.4.1.194'),
	('C03994','2.3.2.9'),
	('C03995','4.3.3.1'),
	('C03996','2.4.1.160'),
	('C03997','2.7.4.12'),
	('C03997','2.1.2.8'),
	('C03998','3.1.3.91'),
	('C03998','3.6.1.59'),
	('C03999','6.3.2.16'),
	('C04000','1.1.1.217'),
	('C04002','4.2.1.114'),
	('C04002','4.2.1.36'),
	('C04006','2.7.1.64'),
	('C04006','2.7.7.74'),
	('C04006','2.4.1.250'),
	('C04006','5.5.1.4'),
	('C04006','3.1.3.25'),
	('C04006','3.1.3.66'),
	('C04006','2.7.8.34'),
	('C04006','2.7.8.39'),
	('C04007','2.4.1.185'),
	('C04007','2.4.1.236'),
	('C04010','3.1.4.45'),
	('C04013','2.3.1.111'),
	('C04015','2.3.1.44'),
	('C04015','3.1.1.53'),
	('C04016','2.3.1.45'),
	('C04017','3.1.1.53'),
	('C04017','2.3.1.45'),
	('C04018','3.1.1.58'),
	('C04020','1.5.1.16'),
	('C04022','2.1.1.269'),
	('C04022','4.4.1.3'),
	('C04024','2.4.1.105'),
	('C04025','6.2.1.23'),
	('C04030','2.7.7.58'),
	('C04033','1.1.1.252'),
	('C04033','2.3.1.233'),
	('C04034','2.4.1.205'),
	('C04036','1.1.1.101'),
	('C04037','2.7.1.44'),
	('C04039','1.1.1.86'),
	('C04039','4.2.1.9'),
	('C04042','1.1.1.149'),
	('C04043','1.4.9.2'),
	('C04043','4.2.1.78'),
	('C04043','1.2.1.5'),
	('C04043','1.2.1.29'),
	('C04043','1.4.3.21'),
	('C04043','1.4.3.4'),
	('C04044','1.14.13.4'),
	('C04044','1.13.11.16'),
	('C04044','1.3.1.87'),
	('C04044','1.14.13.127'),
	('C04045','1.1.1.237'),
	('C04045','1.13.12.15'),
	('C04045','2.6.1.49'),
	('C04046','5.1.3.34'),
	('C04046','2.4.1.336'),
	('C04046','2.4.1.315'),
	('C04047','3.1.2.4'),
	('C04050','1.7.1.9'),
	('C04051','2.4.2.7'),
	('C04052','5.3.3.10'),
	('C04052','4.1.1.68'),
	('C04053','3.2.1.180'),
	('C04053','5.3.1.17'),
	('C04053','3.2.1.179'),
	('C04053','4.2.2.6'),
	('C04056','5.2.1.5'),
	('C04058','3.6.1.61'),
	('C04058','3.6.1.60'),
	('C04061','2.1.1.59'),
	('C04062','3.1.3.64'),
	('C04062','3.1.3.66'),
	('C04063','3.1.3.66'),
	('C04063','3.1.3.57'),
	('C04067','1.1.1.229'),
	('C04069','2.4.2.35'),
	('C04070','2.4.1.176'),
	('C04071','2.7.3.7'),
	('C04073','5.1.3.17'),
	('C04074','2.4.1.170'),
	('C04075','4.5.1.4'),
	('C04076','1.5.3.18'),
	('C04076','1.5.1.10'),
	('C04076','1.2.1.31'),
	('C04076','2.6.1.36'),
	('C04076','1.4.1.18'),
	('C04076','1.5.1.9'),
	('C04076','1.4.3.20'),
	('C04076','4.2.3.134'),
	('C04076','2.6.1.71'),
	('C04076','2.6.1.105'),
	('C04079','2.7.1.33'),
	('C04079','4.1.1.30'),
	('C04080','3.5.1.60'),
	('C04081','2.3.1.56'),
	('C04083','2.5.1.24'),
	('C04083','1.5.99.12'),
	('C04084','1.14.99.24'),
	('C04087','2.1.1.85'),
	('C04088','1.3.1.9'),
	('C04088','1.14.19.2'),
	('C04088','3.1.2.14'),
	('C04089','4.2.1.76'),
	('C04090','3.4.19.12'),
	('C04091','1.3.1.19'),
	('C04091','1.14.12.3'),
	('C04092','1.4.1.15'),
	('C04092','1.5.1.21'),
	('C04092','1.5.1.1'),
	('C04093','2.5.1.20'),
	('C04097','2.4.1.48'),
	('C04098','2.4.1.48'),
	('C04099','2.1.1.18'),
	('C04101','2.3.1.90'),
	('C04103','2.4.1.158'),
	('C04105','5.5.1.1'),
	('C04105','5.3.3.4'),
	('C04106','3.5.1.66'),
	('C04108','5.3.1.21'),
	('C04109','2.1.1.88'),
	('C04110','1.14.99.27'),
	('C04112','1.13.11.1'),
	('C04112','5.5.1.1'),
	('C04114','2.8.3.21'),
	('C04115','4.2.1.83'),
	('C04115','4.2.1.80'),
	('C04115','4.1.3.17'),
	('C04118','1.14.21.5'),
	('C04118','1.3.3.8'),
	('C04118','2.1.1.89'),
	('C04118','2.1.1.117'),
	('C04121','2.4.99.12'),
	('C04121','2.4.99.13'),
	('C04121','2.7.7.38'),
	('C04121','2.4.99.14'),
	('C04121','2.4.99.15'),
	('C04122','4.1.1.81'),
	('C04122','6.3.1.10'),
	('C04125','2.7.11.5'),
	('C04128','2.7.11.29'),
	('C04131','3.5.1.3'),
	('C04132','3.2.1.52'),
	('C04133','1.2.1.38'),
	('C04133','2.7.2.8'),
	('C04136','5.1.3.9'),
	('C04137','1.5.1.11'),
	('C04138','6.3.2.18'),
	('C04141','2.7.11.15'),
	('C04142','3.1.1.61'),
	('C04142','2.1.1.80'),
	('C04143','2.1.1.321'),
	('C04143','2.1.1.319'),
	('C04143','2.1.1.320'),
	('C04144','2.1.1.13'),
	('C04144','2.1.1.14'),
	('C04145','2.5.1.84'),
	('C04145','2.5.1.85'),
	('C04145','2.5.1.117'),
	('C04145','2.5.1.39'),
	('C04146','2.5.1.84'),
	('C04146','2.5.1.90'),
	('C04146','2.5.1.85'),
	('C04146','2.5.1.39'),
	('C04146','2.5.1.74'),
	('C04148','2.3.1.14'),
	('C04149','2.3.1.108'),
	('C04150','2.4.1.199'),
	('C04152','2.1.1.187'),
	('C04152','2.1.1.188'),
	('C04153','2.1.1.171'),
	('C04153','2.1.1.173'),
	('C04153','2.1.1.174'),
	('C04153','2.1.1.172'),
	('C04154','2.1.1.181'),
	('C04155','2.1.1.204'),
	('C04155','2.1.1.202'),
	('C04155','2.1.1.203'),
	('C04157','2.1.1.228'),
	('C04159','2.1.1.55'),
	('C04160','2.1.1.33'),
	('C04161','2.8.1.4'),
	('C04164','2.3.1.152'),
	('C04164','2.4.1.177'),
	('C04167','1.10.1.1'),
	('C04170','2.3.1.93'),
	('C04171','3.3.2.1'),
	('C04171','1.3.1.28'),
	('C04178','1.14.13.50'),
	('C04178','4.2.1.84'),
	('C04178','3.5.5.6'),
	('C04180','5.3.3.14'),
	('C04181','1.1.1.86'),
	('C04181','5.4.99.3'),
	('C04185','5.3.3.12'),
	('C04186','1.2.1.60'),
	('C04186','5.3.3.10'),
	('C04186','1.1.1.312'),
	('C04187','2.7.4.19'),
	('C04188','5.3.1.23'),
	('C04188','2.7.1.100'),
	('C04188','2.4.2.44'),
	('C04188','2.4.2.28'),
	('C04194','2.4.1.159'),
	('C04195','3.1.4.50'),
	('C04196','5.1.3.17'),
	('C04197','2.3.1.72'),
	('C04197','2.4.1.121'),
	('C04199','2.4.1.106'),
	('C04201','2.8.2.9'),
	('C04202','3.1.1.67'),
	('C04203','1.7.1.6'),
	('C04204','6.3.2.14'),
	('C04205','2.3.1.114'),
	('C04207','2.1.1.105'),
	('C04208','2.1.1.105'),
	('C04209','2.3.1.58'),
	('C04210','1.5.1.24'),
	('C04211','6.3.2.20'),
	('C04212','3.1.4.17'),
	('C04213','3.6.1.44'),
	('C04213','2.4.99.18'),
	('C04214','2.7.11.6'),
	('C04215','2.1.1.16'),
	('C04216','4.2.3.130'),
	('C04216','2.5.1.30'),
	('C04217','4.2.3.145'),
	('C04217','2.5.1.81'),
	('C04218','2.3.1.122'),
	('C04219','2.4.1.162'),
	('C04221','1.3.1.20'),
	('C04225','4.2.1.79'),
	('C04225','4.2.1.99'),
	('C04226','1.3.7.1'),
	('C04226','3.5.2.18'),
	('C04227','4.2.1.87'),
	('C04230','2.3.1.83'),
	('C04230','3.1.1.5'),
	('C04230','3.1.1.4'),
	('C04230','5.4.1.1'),
	('C04230','2.3.1.43'),
	('C04230','2.3.1.23'),
	('C04232','1.17.4.1'),
	('C04233','3.1.1.32'),
	('C04233','5.4.1.1'),
	('C04233','3.1.1.5'),
	('C04233','2.3.1.62'),
	('C04233','2.3.1.251'),
	('C04233','2.3.1.135'),
	('C04234','3.1.3.63'),
	('C04236','1.1.1.85'),
	('C04242','2.7.1.21'),
	('C04244','1.1.1.220'),
	('C04244','1.1.1.153'),
	('C04246','1.3.1.9'),
	('C04246','1.3.1.39'),
	('C04246','1.3.1.10'),
	('C04246','1.3.1.104'),
	('C04246','4.2.1.59'),
	('C04246','2.3.1.86'),
	('C04246','2.3.1.85'),
	('C04247','2.4.1.179'),
	('C04248','3.5.1.89'),
	('C04248','4.6.1.14'),
	('C04248','3.1.4.50'),
	('C04250','2.1.1.63'),
	('C04251','3.1.1.46'),
	('C04253','1.5.8.3'),
	('C04253','1.3.8.3'),
	('C04253','1.3.8.4'),
	('C04253','1.3.8.5'),
	('C04253','1.3.8.6'),
	('C04253','1.3.8.1'),
	('C04253','1.3.8.10'),
	('C04253','1.3.8.11'),
	('C04253','1.5.8.4'),
	('C04253','1.5.8.2'),
	('C04253','1.3.8.12'),
	('C04253','1.3.8.7'),
	('C04253','1.3.8.8'),
	('C04253','1.5.5.1'),
	('C04253','1.5.8.1'),
	('C04255','3.2.1.180'),
	('C04257','5.1.3.9'),
	('C04257','2.5.1.57'),
	('C04257','2.5.1.56'),
	('C04257','2.7.1.60'),
	('C04258','3.5.1.88'),
	('C04259','2.1.1.44'),
	('C04260','6.1.1.13'),
	('C04261','2.7.1.202'),
	('C04261','2.7.1.203'),
	('C04261','2.7.1.204'),
	('C04261','2.7.1.205'),
	('C04261','2.7.1.206'),
	('C04261','2.7.1.207'),
	('C04261','2.7.1.208'),
	('C04261','2.7.1.211'),
	('C04261','3.9.1.3'),
	('C04261','2.7.3.9'),
	('C04261','2.7.13.1'),
	('C04261','2.7.1.191'),
	('C04261','2.7.1.192'),
	('C04261','2.7.1.193'),
	('C04261','2.7.1.194'),
	('C04261','2.7.1.195'),
	('C04261','2.7.1.196'),
	('C04261','2.7.1.197'),
	('C04261','2.7.1.198'),
	('C04261','2.7.1.199'),
	('C04261','2.7.1.200'),
	('C04261','2.7.1.201'),
	('C04262','5.4.2.11'),
	('C04262','2.7.13.2'),
	('C04262','3.9.1.3'),
	('C04264','2.6.1.75'),
	('C04266','2.4.1.73'),
	('C04268','4.3.1.30'),
	('C04268','2.6.1.33'),
	('C04268','2.3.1.209'),
	('C04271','1.14.13.28'),
	('C04272','1.1.1.86'),
	('C04272','1.1.1.383'),
	('C04272','1.1.1.382'),
	('C04272','4.2.1.9'),
	('C04275','2.3.1.103'),
	('C04276','2.4.1.199'),
	('C04277','3.5.2.12'),
	('C04280','3.1.3.40'),
	('C04281','1.2.1.88'),
	('C04281','1.5.1.2'),
	('C04282','3.5.4.22'),
	('C04282','1.4.3.3'),
	('C04283','1.17.4.2'),
	('C04287','3.7.1.22'),
	('C04287','4.2.1.44'),
	('C04290','2.5.1.34'),
	('C04290','2.1.1.261'),
	('C04291','1.7.1.11'),
	('C04292','2.7.6.4'),
	('C04293','2.1.1.42'),
	('C04294','2.5.1.2'),
	('C04294','3.5.99.2'),
	('C04294','2.7.1.50'),
	('C04295','5.3.3.1'),
	('C04295','1.1.1.145'),
	('C04295','1.1.1.51'),
	('C04297','1.1.1.341'),
	('C04297','1.1.1.342'),
	('C04297','1.17.1.1'),
	('C04298','6.2.1.22'),
	('C04298','3.1.2.16'),
	('C04299','3.1.4.43'),
	('C04299','4.6.1.13'),
	('C04300','2.4.1.39'),
	('C04302','5.3.1.24'),
	('C04302','2.4.2.18'),
	('C04303','3.5.1.72'),
	('C04305','3.5.1.55'),
	('C04307','3.6.1.29'),
	('C04308','2.1.1.16'),
	('C04308','2.1.1.71'),
	('C04309','4.2.1.11'),
	('C04311','2.1.1.77'),
	('C04312','6.5.1.4'),
	('C04312','6.5.1.5'),
	('C04314','1.3.1.29'),
	('C04314','1.14.12.12'),
	('C04315','2.3.1.141'),
	('C04315','2.3.1.134'),
	('C04316','4.1.3.35'),
	('C04317','2.3.1.23'),
	('C04317','2.3.1.63'),
	('C04317','2.3.1.67'),
	('C04317','2.3.1.149'),
	('C04317','2.3.1.148'),
	('C04317','2.3.1.147'),
	('C04317','3.1.1.47'),
	('C04317','3.1.1.4'),
	('C04318','2.1.1.94'),
	('C04322','2.6.1.13'),
	('C04324','5.3.2.8'),
	('C04324','1.13.11.57'),
	('C04324','1.13.11.8'),
	('C04324','5.3.3.10'),
	('C04327','2.7.1.50'),
	('C04327','2.5.1.3'),
	('C04330','1.5.98.1'),
	('C04330','1.12.98.2'),
	('C04330','3.5.4.27'),
	('C04332','2.5.1.78'),
	('C04332','2.5.1.9'),
	('C04333','3.2.1.134'),
	('C04334','3.1.2.16'),
	('C04334','6.2.1.22'),
	('C04335','3.5.1.64'),
	('C04339','2.4.2.36'),
	('C04340','2.1.1.79'),
	('C04341','2.3.1.128'),
	('C04342','4.6.1.14'),
	('C04346','2.3.1.210'),
	('C04346','2.6.1.59'),
	('C04348','4.1.3.24'),
	('C04348','6.2.1.9'),
	('C04348','3.1.2.30'),
	('C04348','2.8.3.22'),
	('C04349','5.3.1.17'),
	('C04349','1.1.1.389'),
	('C04349','1.1.1.125'),
	('C04349','1.1.1.127'),
	('C04350','1.14.13.41'),
	('C04351','1.5.1.18'),
	('C04352','2.7.1.33'),
	('C04352','4.1.1.36'),
	('C04352','6.3.2.5'),
	('C04353','1.14.13.41'),
	('C04353','1.14.13.68'),
	('C04354','3.2.1.128'),
	('C04359','2.2.1.4'),
	('C04361','2.3.1.125'),
	('C04366','1.13.11.22'),
	('C04367','1.1.1.96'),
	('C04368','5.4.3.6'),
	('C04371','1.8.1.11'),
	('C04372','2.3.2.11'),
	('C04373','1.1.1.50'),
	('C04373','2.4.1.17'),
	('C04373','1.1.1.152'),
	('C04375','3.5.1.52'),
	('C04375','2.4.1.94'),
	('C04376','6.3.5.3'),
	('C04376','2.1.2.2'),
	('C04377','2.1.2.1'),
	('C04377','4.2.1.147'),
	('C04377','1.5.98.1'),
	('C04377','1.5.98.2'),
	('C04377','1.12.98.2'),
	('C04379','1.14.99.24'),
	('C04381','4.3.2.4'),
	('C04384','2.8.2.29'),
	('C04384','2.3.1.78'),
	('C04384','2.8.2.30'),
	('C04384','2.8.2.23'),
	('C04385','2.3.1.116'),
	('C04386','2.3.1.100'),
	('C04387','2.4.1.147'),
	('C04387','2.4.1.41'),
	('C04390','3.5.1.47'),
	('C04391','2.7.99.1'),
	('C04392','3.6.1.17'),
	('C04394','3.5.1.104'),
	('C04395','2.7.11.23'),
	('C04397','1.14.11.7'),
	('C04398','1.14.11.2'),
	('C04399','3.1.3.14'),
	('C04404','1.1.1.226'),
	('C04405','1.1.1.178'),
	('C04405','4.2.1.17'),
	('C04405','1.1.1.35'),
	('C04409','4.1.1.45'),
	('C04409','1.13.11.6'),
	('C04411','1.1.1.85'),
	('C04411','4.2.1.33'),
	('C04415','2.4.1.126'),
	('C04416','4.2.1.62'),
	('C04419','6.4.1.2'),
	('C04419','6.3.4.14'),
	('C04421','3.5.1.18'),
	('C04421','2.6.1.17'),
	('C04422','2.4.1.118'),
	('C04425','2.6.1.62'),
	('C04426','2.8.2.7'),
	('C04429','2.4.1.53'),
	('C04431','3.1.1.45'),
	('C04431','5.5.1.7'),
	('C04432','2.5.1.75'),
	('C04432','2.8.4.3'),
	('C04433','1.14.13.151'),
	('C04434','5.3.2.8'),
	('C04434','3.1.1.57'),
	('C04434','1.13.11.57'),
	('C04434','4.2.1.83'),
	('C04434','1.13.11.8'),
	('C04435','5.5.1.10'),
	('C04437','6.3.4.8'),
	('C04438','3.1.1.4'),
	('C04438','2.3.1.23'),
	('C04438','3.1.1.5'),
	('C04441','2.5.1.108'),
	('C04441','2.1.1.314'),
	('C04441','2.1.1.98'),
	('C04442','4.3.1.29'),
	('C04442','2.7.1.178'),
	('C04442','4.2.1.12'),
	('C04442','4.1.2.14'),
	('C04442','2.7.1.45'),
	('C04442','4.1.2.55'),
	('C04443','2.1.1.76'),
	('C04443','2.1.1.82'),
	('C04444','2.1.1.83'),
	('C04445','1.5.1.25'),
	('C04446','2.5.1.52'),
	('C04447','3.5.5.2'),
	('C04448','2.1.3.7'),
	('C04453','1.1.1.170'),
	('C04453','1.1.1.270'),
	('C04454','3.1.3.104'),
	('C04454','1.1.1.193'),
	('C04457','6.3.2.16'),
	('C04459','2.1.1.112'),
	('C04462','2.6.1.17'),
	('C04462','2.3.1.117'),
	('C04465','2.3.1.122'),
	('C04466','2.3.1.136'),
	('C04468','1.3.1.49'),
	('C04471','1.1.1.126'),
	('C04473','2.4.1.44'),
	('C04475','1.14.99.19'),
	('C04475','2.7.8.1'),
	('C04475','2.3.1.148'),
	('C04476','3.1.4.39'),
	('C04477','2.7.1.159'),
	('C04477','2.7.1.140'),
	('C04478','2.5.1.55'),
	('C04478','3.1.3.45'),
	('C04479','3.7.1.14'),
	('C04479','1.13.11.16'),
	('C04480','1.13.11.14'),
	('C04482','2.3.2.3'),
	('C04483','3.5.1.24'),
	('C04483','2.8.3.25'),
	('C04484','1.13.11.8'),
	('C04485','3.1.1.54'),
	('C04486','3.1.1.54'),
	('C04487','2.4.1.50'),
	('C04487','2.4.1.66'),
	('C04488','1.5.98.2'),
	('C04488','2.1.1.86'),
	('C04489','2.1.1.14'),
	('C04489','2.1.1.13'),
	('C04494','3.6.1.40'),
	('C04494','3.6.1.11'),
	('C04494','2.7.6.5'),
	('C04498','2.3.1.64'),
	('C04500','2.4.1.141'),
	('C04500','2.7.8.15'),
	('C04501','2.4.1.280'),
	('C04501','2.7.1.162'),
	('C04501','2.7.7.23'),
	('C04501','5.4.2.3'),
	('C04501','2.3.1.157'),
	('C04502','2.4.1.38'),
	('C04503','2.7.3.7'),
	('C04504','2.3.1.81'),
	('C04505','2.3.1.136'),
	('C04506','3.4.24.84'),
	('C04506','2.1.1.100'),
	('C04507','2.7.8.6'),
	('C04508','2.4.1.52'),
	('C04510','2.5.1.25'),
	('C04511','2.4.1.110'),
	('C04512','1.3.1.34'),
	('C04514','1.14.12.12'),
	('C04516','2.3.1.143'),
	('C04517','3.3.2.2'),
	('C04517','3.1.1.4'),
	('C04517','2.3.1.25'),
	('C04518','1.1.1.149'),
	('C04520','2.7.1.134'),
	('C04522','5.5.1.7'),
	('C04524','1.13.11.24'),
	('C04525','2.1.1.41'),
	('C04527','2.1.1.88'),
	('C04529','2.3.3.4'),
	('C04530','1.14.13.72'),
	('C04534','2.7.1.85'),
	('C04534','3.2.1.86'),
	('C04534','2.7.1.205'),
	('C04536','2.1.1.11'),
	('C04536','1.14.13.81'),
	('C04537','2.4.1.141'),
	('C04537','2.4.1.142'),
	('C04539','2.4.1.56'),
	('C04540','3.5.1.26'),
	('C04540','3.2.2.11'),
	('C04542','3.2.1.107'),
	('C04544','6.3.2.23'),
	('C04545','2.1.1.34'),
	('C04546','3.1.1.22'),
	('C04546','3.1.1.75'),
	('C04547','1.13.11.43'),
	('C04549','2.7.1.150'),
	('C04549','3.1.3.64'),
	('C04549','3.1.3.66'),
	('C04549','3.1.3.67'),
	('C04549','2.7.1.137'),
	('C04549','2.7.1.154'),
	('C04552','2.1.1.84'),
	('C04553','5.5.1.5'),
	('C04554','1.14.15.15'),
	('C04554','1.2.1.3'),
	('C04554','6.2.1.7'),
	('C04554','6.2.1.28'),
	('C04555','2.8.2.2'),
	('C04555','3.1.6.2'),
	('C04556','2.7.1.49'),
	('C04556','2.7.4.7'),
	('C04556','4.1.99.17'),
	('C04558','5.5.1.1'),
	('C04558','5.4.99.14'),
	('C04559','5.4.99.14'),
	('C04559','5.5.1.1'),
	('C04561','1.1.1.217'),
	('C04563','3.1.3.8'),
	('C04563','3.1.3.62'),
	('C04564','2.7.11.5'),
	('C04565','2.7.11.29'),
	('C04566','2.7.8.20'),
	('C04570','1.5.8.1'),
	('C04570','1.3.8.4'),
	('C04570','1.3.8.3'),
	('C04570','1.3.8.6'),
	('C04570','1.3.8.7'),
	('C04570','1.3.8.8'),
	('C04570','1.5.8.4'),
	('C04570','1.5.5.1'),
	('C04570','1.3.8.5'),
	('C04570','1.5.8.2'),
	('C04570','1.5.8.3'),
	('C04570','1.3.8.1'),
	('C04570','1.3.8.10'),
	('C04570','1.3.8.11'),
	('C04570','1.3.8.12'),
	('C04573','1.1.1.136'),
	('C04573','1.1.1.335'),
	('C04574','3.6.1.27'),
	('C04574','2.4.1.129'),
	('C04574','2.7.4.29'),
	('C04574','2.5.1.31'),
	('C04575','1.1.1.130'),
	('C04575','3.1.1.17'),
	('C04576','2.3.1.143'),
	('C04577','1.1.1.232'),
	('C04578','2.1.1.99'),
	('C04579','3.1.3.26'),
	('C04579','3.1.3.62'),
	('C04581','2.1.1.84'),
	('C04582','4.2.1.109'),
	('C04582','5.3.1.23'),
	('C04584','1.10.3.5'),
	('C04586','1.1.1.229'),
	('C04589','2.8.2.7'),
	('C04590','2.5.1.41'),
	('C04590','2.5.1.42'),
	('C04592','1.3.1.19'),
	('C04592','1.14.12.11'),
	('C04593','4.1.3.30'),
	('C04593','4.2.1.99'),
	('C04596','4.5.1.1'),
	('C04597','1.11.1.14'),
	('C04598','2.3.1.149'),
	('C04598','2.7.8.2'),
	('C04598','3.1.1.47'),
	('C04598','2.3.1.67'),
	('C04599','1.14.13.8'),
	('C04604','4.1.1.51'),
	('C04606','3.1.1.66'),
	('C04608','2.4.1.236'),
	('C04608','2.4.1.81'),
	('C04608','2.4.2.25'),
	('C04608','2.3.1.115'),
	('C04611','2.4.2.34'),
	('C04613','2.6.1.34'),
	('C04613','4.2.1.135'),
	('C04617','5.1.2.6'),
	('C04618','2.3.1.86'),
	('C04618','4.2.1.59'),
	('C04618','2.3.1.85'),
	('C04618','1.1.1.100'),
	('C04619','4.2.1.59'),
	('C04619','2.3.1.86'),
	('C04619','2.3.1.85'),
	('C04619','1.1.1.100'),
	('C04620','2.3.1.85'),
	('C04620','1.1.1.100'),
	('C04620','2.3.1.86'),
	('C04620','4.2.1.59'),
	('C04621','5.2.1.6'),
	('C04622','5.2.1.6'),
	('C04623','4.5.1.1'),
	('C04625','5.5.1.11'),
	('C04628','2.8.4.1'),
	('C04628','1.8.98.1'),
	('C04628','1.3.4.1'),
	('C04630','2.6.1.34'),
	('C04630','2.3.1.203'),
	('C04631','2.5.1.7'),
	('C04631','1.3.1.98'),
	('C04632','3.1.3.47'),
	('C04632','2.7.11.31'),
	('C04633','1.1.1.100'),
	('C04633','2.3.1.86'),
	('C04633','2.3.1.85'),
	('C04633','4.2.1.59'),
	('C04634','1.14.12.10'),
	('C04634','1.3.1.25'),
	('C04635','3.1.1.4'),
	('C04635','2.3.1.121'),
	('C04635','3.1.4.39'),
	('C04635','3.3.2.2'),
	('C04637','3.1.3.67'),
	('C04637','3.1.3.36'),
	('C04637','2.7.1.68'),
	('C04637','2.7.1.153'),
	('C04637','2.7.1.149'),
	('C04637','3.1.3.78'),
	('C04637','3.1.4.11'),
	('C04638','2.7.7.67'),
	('C04638','1.3.1.101'),
	('C04638','1.3.7.11'),
	('C04638','2.5.1.42'),
	('C04639','2.4.2.20'),
	('C04640','6.3.5.3'),
	('C04640','6.3.3.1'),
	('C04641','2.4.1.137'),
	('C04642','1.2.1.60'),
	('C04642','1.1.1.312'),
	('C04642','1.13.11.15'),
	('C04643','1.1.1.159'),
	('C04644','6.2.1.7'),
	('C04644','6.2.1.28'),
	('C04645','3.1.4.51'),
	('C04645','2.7.8.19'),
	('C04646','1.1.1.205'),
	('C04646','2.4.2.8'),
	('C04646','2.1.1.67'),
	('C04648','2.4.1.69'),
	('C04648','2.4.1.37'),
	('C04648','2.4.1.40'),
	('C04649','2.3.1.78'),
	('C04652','2.3.1.191'),
	('C04652','2.4.1.182'),
	('C04652','3.6.1.54'),
	('C04654','1.1.1.197'),
	('C04655','2.3.3.2'),
	('C04656','2.4.1.65'),
	('C04657','2.4.1.152'),
	('C04661','1.1.1.238'),
	('C04666','4.2.1.19'),
	('C04667','2.4.1.70'),
	('C04670','1.1.1.166'),
	('C04671','1.3.1.48'),
	('C04672','5.3.99.6'),
	('C04672','4.2.1.92'),
	('C04673','2.6.1.56'),
	('C04674','3.2.1.56'),
	('C04675','4.1.3.4'),
	('C04675','4.2.1.57'),
	('C04675','4.1.3.26'),
	('C04676','3.1.1.37'),
	('C04676','1.14.99.12'),
	('C04676','1.14.13.54'),
	('C04677','2.4.2.7'),
	('C04677','6.3.4.23'),
	('C04677','4.3.2.2'),
	('C04677','2.1.2.3'),
	('C04678','2.4.1.335'),
	('C04678','2.4.1.153'),
	('C04679','1.14.99.29'),
	('C04680','2.3.1.135'),
	('C04681','6.3.4.15'),
	('C04682','6.3.4.9'),
	('C04683','2.4.99.8'),
	('C04685','5.3.3.9'),
	('C04686','5.3.3.9'),
	('C04687','1.1.1.166'),
	('C04688','4.2.1.59'),
	('C04688','1.1.1.100'),
	('C04688','2.3.1.86'),
	('C04688','2.3.1.85'),
	('C04688','2.3.1.129'),
	('C04688','2.3.1.191'),
	('C04690','1.14.12.5'),
	('C04690','3.5.1.66'),
	('C04691','2.5.1.54'),
	('C04691','4.2.3.4'),
	('C04692','2.1.1.98'),
	('C04695','2.4.1.156'),
	('C04696','3.6.1.59'),
	('C04698','3.2.1.63'),
	('C04700','6.3.2.10'),
	('C04700','6.3.2.7'),
	('C04702','6.3.2.10'),
	('C04702','2.3.2.10'),
	('C04702','2.7.8.13'),
	('C04702','3.4.17.8'),
	('C04703','2.4.1.96'),
	('C04706','3.1.1.45'),
	('C04706','5.2.1.10'),
	('C04707','1.3.1.48'),
	('C04707','1.1.1.141'),
	('C04708','2.4.1.45'),
	('C04711','3.1.1.66'),
	('C04712','2.6.1.74'),
	('C04712','1.4.3.3'),
	('C04713','2.5.1.27'),
	('C04715','2.4.1.192'),
	('C04717','1.13.11.12'),
	('C04717','1.13.11.33'),
	('C04718','1.14.13.51'),
	('C04719','2.4.1.103'),
	('C04720','2.4.1.202'),
	('C04722','1.14.15.15'),
	('C04722','6.2.1.7'),
	('C04724','2.4.1.60'),
	('C04725','2.1.1.18'),
	('C04726','3.1.3.52'),
	('C04726','2.7.11.4'),
	('C04727','6.3.4.10'),
	('C04728','2.1.1.61'),
	('C04729','5.5.1.7'),
	('C04729','5.5.1.11'),
	('C04729','5.2.1.10'),
	('C04730','2.4.99.9'),
	('C04730','2.4.1.165'),
	('C04730','3.2.1.18'),
	('C04730','3.2.1.52'),
	('C04730','2.4.99.8'),
	('C04730','2.4.1.92'),
	('C04731','1.14.13.8'),
	('C04732','2.5.1.9'),
	('C04732','2.5.1.78'),
	('C04732','3.1.3.104'),
	('C04732','2.5.1.77'),
	('C04734','6.3.4.23'),
	('C04734','2.1.2.3'),
	('C04734','3.5.4.10'),
	('C04735','6.3.4.15'),
	('C04736','6.3.4.9'),
	('C04737','2.4.1.228'),
	('C04737','3.2.1.47'),
	('C04737','3.2.1.52'),
	('C04737','3.2.1.22'),
	('C04737','2.4.1.79'),
	('C04738','2.3.1.129'),
	('C04738','3.5.1.108'),
	('C04739','2.7.8.18'),
	('C04740','2.4.99.11'),
	('C04741','1.1.1.197'),
	('C04742','1.11.1.9'),
	('C04742','1.1.1.232'),
	('C04747','2.3.1.49'),
	('C04748','2.1.1.100'),
	('C04749','2.7.11.3'),
	('C04750','2.4.1.102'),
	('C04750','2.4.99.4'),
	('C04751','5.4.99.18'),
	('C04751','6.3.2.6'),
	('C04751','4.1.1.21'),
	('C04752','2.7.4.7'),
	('C04752','2.5.1.3'),
	('C04755','3.1.4.45'),
	('C04756','2.7.8.1'),
	('C04756','3.1.4.4'),
	('C04756','3.1.4.3'),
	('C04756','3.1.1.4'),
	('C04756','2.3.1.121'),
	('C04756','1.14.99.19'),
	('C04758','1.1.1.196'),
	('C04759','2.4.1.66'),
	('C04760','6.2.1.7'),
	('C04763','6.3.4.10'),
	('C04767','2.4.2.27'),
	('C04768','3.1.3.47'),
	('C04768','2.7.11.31'),
	('C04771','3.5.1.61'),
	('C04772','2.4.1.199'),
	('C04773','1.14.12.5'),
	('C04775','2.4.1.179'),
	('C04776','3.2.1.97'),
	('C04778','2.7.8.26'),
	('C04778','2.4.2.21'),
	('C04778','3.1.3.73'),
	('C04780','1.3.1.42'),
	('C04783','1.3.1.64'),
	('C04783','1.14.12.7'),
	('C04785','1.13.11.12'),
	('C04785','4.2.1.92'),
	('C04789','2.7.8.17'),
	('C04791','2.4.99.1'),
	('C04791','2.4.99.6'),
	('C04793','1.13.11.25'),
	('C04793','1.14.14.12'),
	('C04794','4.2.2.1'),
	('C04796','1.13.11.29'),
	('C04797','1.13.11.30'),
	('C04798','1.13.11.36'),
	('C04800','2.4.1.175'),
	('C04801','6.3.4.11'),
	('C04802','2.1.1.57'),
	('C04802','2.1.1.296'),
	('C04804','3.4.17.8'),
	('C04805','1.11.1.9'),
	('C04806','2.4.1.39'),
	('C04807','2.5.1.15'),
	('C04807','2.7.6.3'),
	('C04807','2.5.1.105'),
	('C04808','2.4.1.60'),
	('C04809','2.7.8.20'),
	('C04810','4.2.2.2'),
	('C04814','1.14.13.72'),
	('C04815','4.3.3.1'),
	('C04816','2.7.11.3'),
	('C04817','3.2.1.107'),
	('C04818','2.4.1.38'),
	('C04819','2.4.1.87'),
	('C04822','1.13.11.40'),
	('C04823','6.3.2.6'),
	('C04823','4.3.2.2'),
	('C04824','2.4.1.182'),
	('C04824','3.6.1.54'),
	('C04825','2.4.1.135'),
	('C04827','6.3.4.11'),
	('C04829','2.3.1.49'),
	('C04830','2.4.1.188'),
	('C04831','2.4.1.202'),
	('C04831','2.1.1.241'),
	('C04832','1.8.98.1'),
	('C04832','1.3.4.1'),
	('C04832','2.8.4.1'),
	('C04833','2.1.1.62'),
	('C04834','3.1.1.59'),
	('C04835','1.1.1.231'),
	('C04840','1.14.13.72'),
	('C04840','1.1.1.170'),
	('C04843','3.3.2.7'),
	('C04844','1.13.11.25'),
	('C04844','3.7.1.17'),
	('C04845','2.4.1.206'),
	('C04845','2.4.1.275'),
	('C04845','2.4.1.86'),
	('C04847','2.4.1.87'),
	('C04848','4.6.1.14'),
	('C04849','3.3.2.7'),
	('C04850','2.4.1.65'),
	('C04851','2.4.1.227'),
	('C04851','2.7.8.13'),
	('C04853','1.14.13.30'),
	('C04855','2.4.1.87'),
	('C04856','5.1.99.6'),
	('C04856','4.2.1.136'),
	('C04856','4.2.1.93'),
	('C04858','2.4.2.25'),
	('C04858','2.3.1.115'),
	('C04859','2.4.1.192'),
	('C04861','2.4.1.138'),
	('C04864','3.1.6.9'),
	('C04864','4.2.2.19'),
	('C04864','4.2.2.20'),
	('C04864','4.2.2.5'),
	('C04864','4.2.2.21'),
	('C04865','4.2.2.20'),
	('C04865','4.2.2.21'),
	('C04865','3.1.6.10'),
	('C04865','4.2.2.5'),
	('C04865','3.2.1.180'),
	('C04866','2.4.1.37'),
	('C04867','3.1.1.59'),
	('C04872','2.4.99.5'),
	('C04874','4.1.2.25'),
	('C04874','3.1.3.1'),
	('C04874','1.13.11.81'),
	('C04874','5.1.99.8'),
	('C04875','1.1.1.160'),
	('C04877','6.3.2.10'),
	('C04877','6.3.2.13'),
	('C04877','6.3.2.45'),
	('C04880','2.4.1.145'),
	('C04881','2.4.1.187'),
	('C04882','3.4.17.8'),
	('C04882','2.7.8.13'),
	('C04882','6.3.2.10'),
	('C04883','1.1.1.160'),
	('C04884','3.2.1.23'),
	('C04884','3.2.1.52'),
	('C04884','3.2.1.18'),
	('C04884','2.4.99.9'),
	('C04884','2.4.1.62'),
	('C04884','2.4.1.92'),
	('C04884','2.4.99.8'),
	('C04885','2.4.99.7'),
	('C04886','2.4.99.1'),
	('C04887','2.4.99.8'),
	('C04890','2.4.1.149'),
	('C04891','2.4.1.150'),
	('C04894','2.3.2.10'),
	('C04895','3.5.4.16'),
	('C04895','4.2.3.12'),
	('C04895','3.6.1.67'),
	('C04895','4.1.2.50'),
	('C04895','3.1.3.1'),
	('C04895','5.1.99.7'),
	('C04896','3.5.4.19'),
	('C04896','5.3.1.16'),
	('C04899','4.2.1.136'),
	('C04899','4.2.1.93'),
	('C04899','5.1.99.6'),
	('C04900','2.4.1.191'),
	('C04900','3.2.1.31'),
	('C04901','2.4.99.4'),
	('C04902','2.4.1.102'),
	('C04902','2.4.1.146'),
	('C04903','2.4.1.135'),
	('C04903','2.4.1.223'),
	('C04905','3.5.4.20'),
	('C04906','2.4.1.201'),
	('C04907','2.4.99.6'),
	('C04908','3.5.4.20'),
	('C04909','2.8.2.19'),
	('C04910','2.4.1.86'),
	('C04911','2.4.99.4'),
	('C04911','2.4.99.8'),
	('C04911','3.2.1.23'),
	('C04911','2.4.99.2'),
	('C04911','3.2.1.18'),
	('C04911','2.4.1.62'),
	('C04911','2.4.99.9'),
	('C04913','2.4.1.175'),
	('C04914','2.4.1.143'),
	('C04916','5.3.1.16'),
	('C04917','2.4.1.148'),
	('C04919','2.7.1.130'),
	('C04919','2.4.99.12'),
	('C04919','2.4.2.43'),
	('C04920','2.8.2.19'),
	('C04922','2.4.99.10'),
	('C04922','2.4.1.164'),
	('C04922','2.4.1.163'),
	('C04922','2.4.1.275'),
	('C04922','2.4.1.149'),
	('C04923','2.4.1.138'),
	('C04924','2.4.1.165'),
	('C04925','2.4.1.88'),
	('C04925','3.2.1.49'),
	('C04926','2.4.99.7'),
	('C04927','2.4.99.2'),
	('C04927','3.2.1.18'),
	('C04927','2.4.99.8'),
	('C04927','2.4.99.4'),
	('C04930','2.4.1.146'),
	('C04932','2.4.1.182'),
	('C04932','2.7.1.130'),
	('C04934','2.4.1.201'),
	('C04936','2.4.99.10'),
	('C04937','2.4.1.143'),
	('C04938','2.4.1.149'),
	('C04938','2.4.1.163'),
	('C04939','2.4.1.163'),
	('C04939','2.4.1.164'),
	('C04942','2.4.1.144'),
	('C04943','2.4.1.145'),
	('C04944','2.4.1.155'),
	('C04944','2.4.1.143'),
	('C05011','1.14.14.1'),
	('C05042','2.3.1.183'),
	('C05067','4.2.1.17'),
	('C05080','2.1.3.12'),
	('C05102','1.14.14.1'),
	('C05102','1.11.2.4'),
	('C05103','1.1.1.270'),
	('C05107','1.3.1.72'),
	('C05108','1.3.1.72'),
	('C05108','1.14.13.72'),
	('C05108','1.3.1.70'),
	('C05109','1.3.1.72'),
	('C05110','5.3.3.5'),
	('C05111','1.1.1.170'),
	('C05111','1.14.13.72'),
	('C05111','5.3.3.5'),
	('C05111','1.1.1.270'),
	('C05116','4.2.1.17'),
	('C05116','1.1.1.157'),
	('C05122','2.3.1.65'),
	('C05122','3.5.1.24'),
	('C05123','1.1.1.313'),
	('C05125','4.1.1.1'),
	('C05125','1.2.4.1'),
	('C05125','2.2.1.6'),
	('C05127','1.4.3.22'),
	('C05127','2.1.1.8'),
	('C05127','1.4.3.4'),
	('C05130','1.2.1.3'),
	('C05130','1.4.3.22'),
	('C05133','1.14.13.5'),
	('C05138','1.14.14.32'),
	('C05138','1.14.14.16'),
	('C05138','1.14.14.19'),
	('C05138','1.14.15.6'),
	('C05138','1.1.1.145'),
	('C05138','5.3.3.1'),
	('C05139','5.3.3.1'),
	('C05139','1.1.1.145'),
	('C05139','1.14.14.1'),
	('C05140','5.3.3.1'),
	('C05140','1.1.1.145'),
	('C05141','1.1.1.62'),
	('C05141','1.14.14.1'),
	('C05141','2.4.1.17'),
	('C05143','2.4.1.85'),
	('C05143','3.2.1.21'),
	('C05144','2.4.1.33'),
	('C05144','5.1.3.37'),
	('C05147','4.2.1.77'),
	('C05155','1.13.11.36'),
	('C05156','2.3.2.12'),
	('C05157','2.3.2.12'),
	('C05158','2.4.1.114'),
	('C05159','2.4.1.155'),
	('C05161','5.4.3.4'),
	('C05161','1.4.1.12'),
	('C05165','1.14.13.40'),
	('C05167','1.4.1.15'),
	('C05167','1.4.3.7'),
	('C05167','1.4.99.6'),
	('C05167','4.3.1.10'),
	('C05167','4.3.1.17'),
	('C05167','4.3.1.18'),
	('C05167','4.3.1.19'),
	('C05167','4.3.1.20'),
	('C05167','4.3.1.23'),
	('C05167','4.3.1.24'),
	('C05167','4.3.1.25'),
	('C05167','4.3.1.3'),
	('C05167','4.3.1.6'),
	('C05167','4.3.1.7'),
	('C05167','4.3.1.9'),
	('C05167','3.1.1.43'),
	('C05167','1.4.1.19'),
	('C05167','1.4.1.2'),
	('C05167','1.4.1.20'),
	('C05167','1.4.1.3'),
	('C05167','1.4.3.3'),
	('C05167','1.4.1.4'),
	('C05167','1.4.1.5'),
	('C05167','1.4.1.7'),
	('C05167','1.4.1.8'),
	('C05167','1.4.1.9'),
	('C05167','1.4.3.1'),
	('C05167','1.4.3.11'),
	('C05167','1.4.3.2'),
	('C05167','1.4.1.1'),
	('C05167','1.4.1.10'),
	('C05167','1.4.1.12'),
	('C05172','2.7.9.3'),
	('C05172','2.9.1.2'),
	('C05172','2.9.1.1'),
	('C05174','1.14.21.2'),
	('C05174','1.14.21.1'),
	('C05175','2.1.1.122'),
	('C05175','1.14.21.1'),
	('C05176','2.1.1.115'),
	('C05176','2.1.1.140'),
	('C05176','1.14.13.71'),
	('C05176','1.14.18.1'),
	('C05176','1.14.21.3'),
	('C05177','1.14.21.3'),
	('C05178','1.14.21.4'),
	('C05178','2.1.1.115'),
	('C05178','2.1.1.291'),
	('C05178','1.5.1.27'),
	('C05179','1.1.1.248'),
	('C05179','1.14.21.4'),
	('C05183','1.2.2.4'),
	('C05189','1.14.13.37'),
	('C05189','1.14.13.55'),
	('C05190','1.14.13.55'),
	('C05191','1.3.1.107'),
	('C05191','1.14.13.56'),
	('C05191','1.5.3.12'),
	('C05193','1.14.13.57'),
	('C05193','2.1.1.120'),
	('C05194','1.5.3.12'),
	('C05194','1.3.1.107'),
	('C05194','1.14.13.57'),
	('C05194','2.1.1.119'),
	('C05195','2.3.1.151'),
	('C05195','6.2.1.37'),
	('C05195','1.14.13.58'),
	('C05196','1.97.1.4'),
	('C05197','1.97.1.4'),
	('C05198','1.97.1.4'),
	('C05198','2.1.1.308'),
	('C05198','1.3.98.3'),
	('C05198','3.5.4.41'),
	('C05198','2.8.4.5'),
	('C05198','2.8.4.4'),
	('C05198','1.21.98.1'),
	('C05198','2.8.4.3'),
	('C05198','2.8.1.8'),
	('C05198','2.8.1.6'),
	('C05198','1.1.99.38'),
	('C05198','2.5.1.77'),
	('C05198','4.3.1.30'),
	('C05198','4.1.99.22'),
	('C05198','4.1.99.19'),
	('C05198','4.1.99.17'),
	('C05198','4.1.3.44'),
	('C05199','1.97.1.4'),
	('C05200','2.1.1.114'),
	('C05201','2.1.1.115'),
	('C05202','2.1.1.115'),
	('C05202','2.1.1.116'),
	('C05202','1.14.18.1'),
	('C05202','1.14.13.71'),
	('C05203','2.1.1.128'),
	('C05203','2.1.1.121'),
	('C05204','2.1.1.122'),
	('C05205','2.1.1.123'),
	('C05208','2.3.1.147'),
	('C05209','2.3.1.147'),
	('C05209','2.3.1.148'),
	('C05210','2.3.1.147'),
	('C05212','2.3.1.148'),
	('C05212','3.1.1.4'),
	('C05212','2.3.1.23'),
	('C05212','2.3.1.63'),
	('C05212','2.7.8.2'),
	('C05217','2.3.1.149'),
	('C05218','2.3.1.149'),
	('C05220','2.3.1.150'),
	('C05220','1.1.1.248'),
	('C05223','2.3.1.179'),
	('C05223','1.3.1.9'),
	('C05223','3.1.2.14'),
	('C05223','1.3.1.104'),
	('C05223','3.1.2.21'),
	('C05223','2.3.1.41'),
	('C05223','2.3.1.241'),
	('C05223','2.3.1.86'),
	('C05223','2.3.1.85'),
	('C05223','1.3.1.39'),
	('C05223','1.3.1.10'),
	('C05226','3.5.1.77'),
	('C05227','3.6.1.45'),
	('C05227','2.7.7.64'),
	('C05229','4.2.1.97'),
	('C05230','4.2.1.97'),
	('C05231','4.3.1.14'),
	('C05231','2.3.1.247'),
	('C05232','5.1.99.4'),
	('C05234','6.3.2.25'),
	('C05235','1.1.1.6'),
	('C05239','3.5.4.8'),
	('C05243','1.14.21.3'),
	('C05247','2.1.1.119'),
	('C05247','1.14.13.56'),
	('C05250','2.7.7.59'),
	('C05258','4.2.1.74'),
	('C05258','4.2.1.17'),
	('C05258','1.1.1.35'),
	('C05258','1.1.1.211'),
	('C05259','2.3.1.16'),
	('C05259','1.1.1.35'),
	('C05259','1.1.1.211'),
	('C05259','2.3.1.155'),
	('C05260','1.1.1.35'),
	('C05260','4.2.1.17'),
	('C05260','4.2.1.74'),
	('C05260','1.1.1.211'),
	('C05261','1.1.1.211'),
	('C05261','1.1.1.35'),
	('C05261','2.3.1.16'),
	('C05262','1.1.1.211'),
	('C05262','1.1.1.35'),
	('C05262','4.2.1.74'),
	('C05262','4.2.1.17'),
	('C05263','2.3.1.16'),
	('C05263','1.1.1.211'),
	('C05263','1.1.1.35'),
	('C05264','1.1.1.35'),
	('C05264','1.1.1.211'),
	('C05264','4.2.1.17'),
	('C05264','4.2.1.74'),
	('C05265','1.1.1.35'),
	('C05265','1.1.1.211'),
	('C05265','2.3.1.16'),
	('C05266','1.1.1.35'),
	('C05266','1.1.1.211'),
	('C05266','5.1.2.3'),
	('C05266','4.2.1.74'),
	('C05266','4.2.1.17'),
	('C05267','2.3.1.16'),
	('C05267','1.1.1.211'),
	('C05267','1.1.1.35'),
	('C05268','4.2.1.17'),
	('C05268','4.2.1.74'),
	('C05268','1.1.1.35'),
	('C05268','1.1.1.211'),
	('C05269','2.3.1.9'),
	('C05269','1.1.1.35'),
	('C05269','2.3.1.16'),
	('C05269','1.1.1.211'),
	('C05270','1.3.3.6'),
	('C05270','2.3.1.206'),
	('C05270','1.3.8.1'),
	('C05270','1.3.1.38'),
	('C05270','2.3.1.16'),
	('C05270','1.3.8.8'),
	('C05270','1.3.8.7'),
	('C05270','1.3.1.8'),
	('C05271','4.2.1.74'),
	('C05271','4.2.1.17'),
	('C05271','1.3.1.38'),
	('C05271','1.3.8.8'),
	('C05271','1.3.8.7'),
	('C05271','1.3.3.6'),
	('C05271','1.3.8.1'),
	('C05271','1.3.1.8'),
	('C05272','1.3.1.38'),
	('C05272','1.3.1.8'),
	('C05272','1.3.3.6'),
	('C05272','1.3.8.7'),
	('C05272','1.3.8.8'),
	('C05272','1.3.8.9'),
	('C05272','4.2.1.17'),
	('C05272','4.2.1.74'),
	('C05273','1.3.1.38'),
	('C05273','4.2.1.17'),
	('C05273','1.3.8.7'),
	('C05273','4.2.1.74'),
	('C05273','1.3.1.8'),
	('C05273','1.3.8.9'),
	('C05273','1.3.8.8'),
	('C05273','1.3.3.6'),
	('C05274','1.3.8.7'),
	('C05274','1.3.8.8'),
	('C05274','2.3.1.16'),
	('C05274','1.3.1.38'),
	('C05274','1.3.1.8'),
	('C05274','1.3.3.6'),
	('C05275','1.3.1.38'),
	('C05275','1.3.8.8'),
	('C05275','4.2.1.17'),
	('C05275','1.3.1.8'),
	('C05275','1.3.3.6'),
	('C05275','4.2.1.74'),
	('C05275','1.3.8.7'),
	('C05276','1.3.1.8'),
	('C05276','1.3.3.6'),
	('C05276','1.3.1.38'),
	('C05276','1.3.8.7'),
	('C05276','4.2.1.17'),
	('C05276','4.2.1.74'),
	('C05276','1.3.8.8'),
	('C05278','5.1.2.3'),
	('C05279','5.3.3.8'),
	('C05280','5.3.3.8'),
	('C05281','1.17.99.4'),
	('C05281','3.5.2.1'),
	('C05284','1.1.1.62'),
	('C05284','1.1.1.146'),
	('C05284','1.14.15.4'),
	('C05285','1.1.1.146'),
	('C05290','1.14.14.14'),
	('C05291','1.14.14.1'),
	('C05293','1.3.1.3'),
	('C05294','1.14.14.14'),
	('C05295','1.14.14.14'),
	('C05296','1.14.14.1'),
	('C05297','1.14.14.14'),
	('C05298','2.1.1.6'),
	('C05298','1.14.14.1'),
	('C05299','2.4.1.17'),
	('C05299','2.8.2.15'),
	('C05299','2.1.1.6'),
	('C05300','1.1.1.62'),
	('C05300','1.14.14.1'),
	('C05301','2.1.1.6'),
	('C05301','1.14.14.1'),
	('C05302','2.1.1.6'),
	('C05302','2.4.1.17'),
	('C05302','2.8.2.15'),
	('C05305','1.2.2.4'),
	('C05306','2.5.1.62'),
	('C05306','3.1.1.14'),
	('C05306','1.17.7.2'),
	('C05307','1.1.1.294'),
	('C05307','2.5.1.62'),
	('C05307','3.1.1.14'),
	('C05309','1.6.5.5'),
	('C05309','1.10.3.2'),
	('C05312','1.97.1.4'),
	('C05313','2.1.1.114'),
	('C05314','2.1.1.115'),
	('C05315','2.1.1.147'),
	('C05315','1.3.3.8'),
	('C05315','2.1.1.118'),
	('C05316','1.5.3.12'),
	('C05316','2.1.1.120'),
	('C05317','2.1.1.121'),
	('C05318','2.1.1.122'),
	('C05319','2.1.1.123'),
	('C05322','2.3.1.150'),
	('C05324','2.6.1.80'),
	('C05324','2.5.1.43'),
	('C05325','2.7.1.143'),
	('C05326','2.7.7.59'),
	('C05328','5.1.1.15'),
	('C05329','5.1.99.4'),
	('C05330','1.8.4.1'),
	('C05332','3.5.1.85'),
	('C05332','1.4.9.2'),
	('C05332','1.4.3.4'),
	('C05332','1.4.3.21'),
	('C05332','4.1.1.53'),
	('C05332','4.1.1.28'),
	('C05335','4.4.1.1'),
	('C05335','6.1.1.10'),
	('C05335','2.5.1.6'),
	('C05335','2.1.1.14'),
	('C05335','2.1.1.13'),
	('C05335','2.1.1.12'),
	('C05335','4.4.1.11'),
	('C05336','6.1.1.10'),
	('C05337','2.3.1.176'),
	('C05337','3.1.2.27'),
	('C05337','6.2.1.7'),
	('C05337','2.3.1.65'),
	('C05338','2.3.1.14'),
	('C05340','6.3.2.11'),
	('C05340','3.4.13.4'),
	('C05341','6.3.2.11'),
	('C05341','3.4.13.4'),
	('C05343','5.1.2.2'),
	('C05345','1.1.1.17'),
	('C05345','1.1.1.140'),
	('C05345','2.2.1.2'),
	('C05345','2.2.1.1'),
	('C05345','2.4.1.329'),
	('C05345','2.7.1.105'),
	('C05345','2.7.1.11'),
	('C05345','2.7.1.4'),
	('C05345','2.7.1.146'),
	('C05345','2.7.1.1'),
	('C05345','2.7.1.90'),
	('C05345','3.1.3.46'),
	('C05345','3.1.3.11'),
	('C05345','5.3.1.8'),
	('C05345','5.3.1.9'),
	('C05345','5.3.1.27'),
	('C05350','5.3.2.1'),
	('C05356','1.11.1.9'),
	('C05356','1.13.11.34'),
	('C05357','1.1.9.1'),
	('C05357','1.20.9.1'),
	('C05357','1.7.2.1'),
	('C05358','1.1.9.1'),
	('C05358','1.20.9.1'),
	('C05358','1.7.2.1'),
	('C05359','2.1.1.308'),
	('C05359','2.8.1.6'),
	('C05359','1.18.6.1'),
	('C05360','1.18.6.1'),
	('C05361','1.7.2.8'),
	('C05361','1.18.6.1'),
	('C05361','1.7.2.7'),
	('C05364','4.2.1.80'),
	('C05364','5.3.3.10'),
	('C05366','1.23.1.1'),
	('C05375','1.1.1.312'),
	('C05376','2.3.1.115'),
	('C05376','2.4.1.170'),
	('C05378','3.1.3.11'),
	('C05378','2.7.1.56'),
	('C05378','2.7.1.90'),
	('C05378','2.7.1.146'),
	('C05378','4.1.2.13'),
	('C05378','2.7.1.11'),
	('C05379','6.4.1.7'),
	('C05379','1.1.1.42'),
	('C05381','1.2.4.2'),
	('C05382','3.1.3.37'),
	('C05382','3.1.3.11'),
	('C05382','2.2.1.2'),
	('C05382','2.2.1.1'),
	('C05382','2.7.1.11'),
	('C05382','4.2.3.154'),
	('C05382','4.2.3.155'),
	('C05382','5.3.1.28'),
	('C05382','2.7.1.14'),
	('C05385','2.7.1.43'),
	('C05385','2.7.7.64'),
	('C05385','2.7.7.44'),
	('C05392','4.2.2.3'),
	('C05392','4.2.2.11'),
	('C05394','3.2.1.23'),
	('C05396','3.2.1.23'),
	('C05396','2.7.1.207'),
	('C05396','3.2.1.85'),
	('C05399','3.2.1.22'),
	('C05400','3.2.1.22'),
	('C05401','3.2.1.22'),
	('C05401','3.1.1.26'),
	('C05402','3.2.1.22'),
	('C05402','3.2.1.26'),
	('C05403','1.1.99.13'),
	('C05403','3.2.1.23'),
	('C05404','3.2.1.26'),
	('C05404','3.2.1.22'),
	('C05413','2.5.1.32'),
	('C05413','2.5.1.99'),
	('C05413','1.3.5.5'),
	('C05414','1.3.99.31'),
	('C05414','1.3.99.30'),
	('C05414','1.3.99.29'),
	('C05414','1.3.99.28'),
	('C05414','1.3.5.5'),
	('C05418','3.3.2.11'),
	('C05421','2.5.1.32'),
	('C05421','1.3.99.31'),
	('C05421','1.3.99.30'),
	('C05421','1.3.5.5'),
	('C05421','1.3.99.28'),
	('C05421','1.3.99.29'),
	('C05422','1.23.5.1'),
	('C05422','1.3.2.3'),
	('C05422','1.8.5.1'),
	('C05422','1.10.3.3'),
	('C05422','1.11.1.11'),
	('C05422','3.1.1.17'),
	('C05422','1.14.17.4'),
	('C05422','1.14.17.3'),
	('C05422','1.14.17.1'),
	('C05425','3.3.2.11'),
	('C05427','2.5.1.62'),
	('C05427','2.5.1.115'),
	('C05427','1.3.1.83'),
	('C05430','1.3.5.5'),
	('C05430','1.3.5.6'),
	('C05430','1.3.99.31'),
	('C05430','1.3.99.30'),
	('C05430','1.3.99.29'),
	('C05430','1.3.99.28'),
	('C05430','1.3.99.26'),
	('C05431','1.3.99.28'),
	('C05431','1.3.5.6'),
	('C05431','1.3.99.26'),
	('C05431','4.2.1.131'),
	('C05431','1.3.99.31'),
	('C05431','5.5.1.19'),
	('C05431','1.3.99.30'),
	('C05431','5.5.1.18'),
	('C05432','1.3.99.31'),
	('C05432','4.2.1.131'),
	('C05432','1.3.99.26'),
	('C05432','5.5.1.19'),
	('C05432','5.5.1.18'),
	('C05432','5.2.1.13'),
	('C05432','1.3.5.6'),
	('C05432','1.3.99.30'),
	('C05433','5.5.1.19'),
	('C05433','1.14.13.129'),
	('C05433','1.14.99.45'),
	('C05434','5.5.1.19'),
	('C05435','4.2.1.131'),
	('C05435','5.5.1.19'),
	('C05437','2.1.1.41'),
	('C05437','1.3.1.72'),
	('C05437','5.3.3.5'),
	('C05439','1.3.1.72'),
	('C05439','5.3.3.5'),
	('C05440','1.3.1.71'),
	('C05440','1.14.19.41'),
	('C05442','1.14.19.41'),
	('C05443','1.14.14.24'),
	('C05444','1.14.15.15'),
	('C05444','1.1.1.1'),
	('C05445','1.14.15.15'),
	('C05445','1.1.1.1'),
	('C05445','1.2.1.3'),
	('C05446','1.14.15.15'),
	('C05447','4.2.1.107'),
	('C05447','1.17.99.3'),
	('C05448','4.2.1.107'),
	('C05448','1.1.1.35'),
	('C05449','2.3.1.176'),
	('C05449','1.1.1.35'),
	('C05450','1.1.1.35'),
	('C05450','4.2.1.107'),
	('C05451','1.3.1.3'),
	('C05451','1.1.1.50'),
	('C05452','1.1.1.50'),
	('C05452','1.14.15.15'),
	('C05452','1.14.13.96'),
	('C05453','1.1.1.50'),
	('C05453','1.3.1.3'),
	('C05454','1.14.13.96'),
	('C05454','1.1.1.50'),
	('C05454','1.14.15.15'),
	('C05455','1.1.1.181'),
	('C05455','1.3.1.3'),
	('C05455','1.14.18.8'),
	('C05458','1.3.99.5'),
	('C05460','4.2.1.107'),
	('C05460','1.17.99.3'),
	('C05463','3.5.1.24'),
	('C05464','3.5.1.24'),
	('C05465','3.5.1.24'),
	('C05465','3.5.1.74'),
	('C05465','2.3.1.65'),
	('C05465','1.14.13.97'),
	('C05466','3.5.1.24'),
	('C05466','2.3.1.65'),
	('C05466','2.8.2.34'),
	('C05467','2.3.1.176'),
	('C05467','1.1.1.35'),
	('C05469','1.3.1.3'),
	('C05469','1.1.1.50'),
	('C05470','1.1.1.53'),
	('C05470','1.1.1.50'),
	('C05471','1.1.1.50'),
	('C05471','1.3.1.3'),
	('C05472','1.1.1.53'),
	('C05472','1.1.1.50'),
	('C05473','1.1.1.50'),
	('C05473','1.3.1.3'),
	('C05474','1.1.1.50'),
	('C05475','1.3.1.3'),
	('C05475','1.1.1.50'),
	('C05476','1.1.1.50'),
	('C05476','1.1.1.146'),
	('C05477','1.1.1.50'),
	('C05478','1.1.1.146'),
	('C05478','1.1.1.50'),
	('C05478','1.1.1.53'),
	('C05479','1.1.1.277'),
	('C05479','1.3.99.6'),
	('C05479','1.3.1.3'),
	('C05479','1.1.1.50'),
	('C05480','1.1.1.50'),
	('C05480','1.1.1.53'),
	('C05481','1.1.1.53'),
	('C05482','1.1.1.53'),
	('C05483','1.1.1.53'),
	('C05484','1.1.1.53'),
	('C05485','1.14.14.16'),
	('C05485','5.3.3.1'),
	('C05485','1.1.1.145'),
	('C05487','1.1.1.145'),
	('C05487','1.14.14.16'),
	('C05487','5.3.3.1'),
	('C05487','1.14.15.4'),
	('C05488','5.3.3.1'),
	('C05488','1.14.15.4'),
	('C05488','1.14.14.16'),
	('C05488','1.1.1.145'),
	('C05489','1.14.15.4'),
	('C05489','5.3.3.1'),
	('C05489','1.1.1.145'),
	('C05490','1.1.1.146'),
	('C05497','1.14.14.19'),
	('C05497','1.14.14.16'),
	('C05497','1.14.15.4'),
	('C05498','1.14.15.4'),
	('C05498','1.14.14.16'),
	('C05498','1.14.14.19'),
	('C05499','1.14.15.6'),
	('C05499','1.14.14.19'),
	('C05500','1.14.15.6'),
	('C05500','1.14.14.19'),
	('C05501','1.14.15.6'),
	('C05502','1.14.15.6'),
	('C05503','2.4.1.17'),
	('C05504','2.4.1.17'),
	('C05512','2.4.2.1'),
	('C05512','2.4.2.4'),
	('C05512','3.5.4.4'),
	('C05513','2.4.2.16'),
	('C05519','4.1.2.49'),
	('C05519','4.1.2.48'),
	('C05519','1.1.1.381'),
	('C05520','2.3.1.37'),
	('C05524','3.4.13.12'),
	('C05526','1.8.1.10'),
	('C05526','1.8.1.9'),
	('C05526','1.8.4.3'),
	('C05527','2.6.1.1'),
	('C05528','1.1.1.338'),
	('C05528','4.1.1.79'),
	('C05528','1.1.1.310'),
	('C05528','1.1.1.37'),
	('C05528','1.1.1.337'),
	('C05528','2.6.1.1'),
	('C05533','1.1.1.286'),
	('C05533','1.1.1.87'),
	('C05535','1.2.1.31'),
	('C05539','2.3.1.89'),
	('C05544','2.1.1.60'),
	('C05544','2.1.1.59'),
	('C05544','2.1.1.43'),
	('C05544','1.14.11.27'),
	('C05545','2.1.1.59'),
	('C05545','2.1.1.60'),
	('C05545','1.14.11.27'),
	('C05545','2.1.1.43'),
	('C05546','2.1.1.60'),
	('C05546','2.1.1.43'),
	('C05546','2.1.1.59'),
	('C05548','2.6.1.65'),
	('C05548','3.5.1.17'),
	('C05551','3.5.1.11'),
	('C05551','2.3.1.164'),
	('C05551','3.5.2.6'),
	('C05552','3.5.1.12'),
	('C05554','6.3.2.39'),
	('C05556','6.3.2.26'),
	('C05556','1.21.3.1'),
	('C05557','2.3.1.164'),
	('C05557','5.1.1.17'),
	('C05557','1.21.3.1'),
	('C05560','1.2.1.31'),
	('C05565','1.17.3.2'),
	('C05574','5.4.3.9'),
	('C05575','2.1.1.44'),
	('C05575','1.14.99.51'),
	('C05575','1.14.99.50'),
	('C05576','2.1.1.6'),
	('C05576','1.1.1.1'),
	('C05577','1.1.1.1'),
	('C05577','1.2.1.5'),
	('C05577','1.4.3.4'),
	('C05578','4.1.1.84'),
	('C05578','1.14.18.1'),
	('C05579','1.14.18.1'),
	('C05580','2.1.1.6'),
	('C05580','1.2.1.5'),
	('C05581','1.2.1.5'),
	('C05581','1.4.3.4'),
	('C05582','2.1.1.6'),
	('C05582','1.2.1.5'),
	('C05583','1.2.1.5'),
	('C05583','1.4.3.4'),
	('C05584','2.1.1.6'),
	('C05584','1.2.1.5'),
	('C05585','1.2.3.1'),
	('C05585','1.2.1.29'),
	('C05587','1.4.3.4'),
	('C05587','2.1.1.6'),
	('C05588','2.1.1.6'),
	('C05588','1.4.3.4'),
	('C05589','2.1.1.6'),
	('C05589','1.4.3.4'),
	('C05590','1.11.1.8'),
	('C05593','1.14.13.63'),
	('C05593','1.14.14.9'),
	('C05594','2.1.1.6'),
	('C05595','2.3.1.14'),
	('C05598','2.3.1.13'),
	('C05598','2.3.1.192'),
	('C05600','4.1.1.68'),
	('C05601','4.1.2.52'),
	('C05607','1.1.1.237'),
	('C05607','1.1.1.222'),
	('C05607','2.8.3.17'),
	('C05608','1.2.1.44'),
	('C05608','1.1.1.195'),
	('C05610','2.1.1.68'),
	('C05610','1.2.1.68'),
	('C05610','1.2.1.44'),
	('C05610','1.1.1.195'),
	('C05616','1.13.11.8'),
	('C05618','1.3.1.19'),
	('C05618','1.13.11.39'),
	('C05619','2.1.1.68'),
	('C05619','6.2.1.12'),
	('C05620','2.3.1.36'),
	('C05622','2.3.1.115'),
	('C05623','2.4.1.239'),
	('C05623','2.3.1.116'),
	('C05623','2.4.2.35'),
	('C05623','2.4.1.91'),
	('C05623','2.4.1.159'),
	('C05625','2.4.1.159'),
	('C05625','2.4.2.35'),
	('C05627','4.1.1.102'),
	('C05629','1.14.12.19'),
	('C05629','1.3.1.31'),
	('C05631','1.14.13.88'),
	('C05631','1.14.13.21'),
	('C05631','1.14.11.22'),
	('C05631','1.1.1.234'),
	('C05631','1.14.11.9'),
	('C05634','1.2.1.3'),
	('C05634','1.2.3.1'),
	('C05634','1.4.3.4'),
	('C05635','1.2.1.3'),
	('C05635','1.2.3.1'),
	('C05635','2.1.1.4'),
	('C05636','1.4.3.4'),
	('C05637','1.4.3.4'),
	('C05638','1.4.3.4'),
	('C05638','4.1.1.28'),
	('C05639','1.4.3.4'),
	('C05640','1.11.1.6'),
	('C05640','1.11.1.21'),
	('C05641','1.13.11.10'),
	('C05642','1.13.11.52'),
	('C05643','1.14.14.1'),
	('C05644','2.1.1.47'),
	('C05645','2.6.1.7'),
	('C05646','2.6.1.27'),
	('C05647','1.13.11.52'),
	('C05648','3.5.1.9'),
	('C05648','1.13.11.52'),
	('C05649','1.5.1.34'),
	('C05650','1.5.1.34'),
	('C05651','3.5.1.9'),
	('C05651','4.1.1.28'),
	('C05653','3.7.1.3'),
	('C05653','3.5.1.9'),
	('C05653','1.13.11.47'),
	('C05658','2.4.1.220'),
	('C05660','2.1.1.4'),
	('C05662','1.1.1.87'),
	('C05662','1.1.1.286'),
	('C05662','4.2.1.114'),
	('C05662','4.2.1.36'),
	('C05665','1.2.1.3'),
	('C05665','1.2.1.5'),
	('C05665','1.2.1.19'),
	('C05665','1.4.3.22'),
	('C05665','1.4.3.21'),
	('C05665','1.5.3.17'),
	('C05665','1.5.3.16'),
	('C05668','3.1.2.4'),
	('C05668','4.2.1.17'),
	('C05668','6.2.1.36'),
	('C05668','4.2.1.116'),
	('C05669','1.3.1.16'),
	('C05670','2.3.2.2'),
	('C05673','2.7.8.1'),
	('C05673','2.7.7.14'),
	('C05674','2.7.7.15'),
	('C05674','2.7.8.2'),
	('C05675','2.7.8.1'),
	('C05676','2.7.8.2'),
	('C05678','1.13.11.78'),
	('C05678','1.14.11.46'),
	('C05682','3.11.1.2'),
	('C05684','1.8.99.2'),
	('C05684','1.8.1.9'),
	('C05684','1.97.1.9'),
	('C05684','1.8.7.1'),
	('C05686','1.8.99.2'),
	('C05686','2.7.7.4'),
	('C05686','2.7.1.25'),
	('C05688','4.4.1.1'),
	('C05688','2.1.1.9'),
	('C05688','2.5.1.48'),
	('C05688','2.1.1.280'),
	('C05688','2.5.1.47'),
	('C05688','4.4.1.16'),
	('C05689','2.1.1.9'),
	('C05689','2.1.1.280'),
	('C05689','2.3.2.2'),
	('C05689','4.4.1.1'),
	('C05689','4.4.1.13'),
	('C05690','2.1.1.12'),
	('C05691','2.5.1.6'),
	('C05692','3.3.1.1'),
	('C05695','2.3.2.2'),
	('C05696','2.7.1.25'),
	('C05697','2.7.7.4'),
	('C05697','1.97.1.9'),
	('C05698','4.4.1.8'),
	('C05698','4.2.1.22'),
	('C05698','2.1.1.14'),
	('C05698','2.1.1.13'),
	('C05698','3.3.1.1'),
	('C05699','4.4.1.8'),
	('C05699','4.2.1.22'),
	('C05699','2.5.1.48'),
	('C05699','4.4.1.1'),
	('C05702','2.5.1.48'),
	('C05703','4.4.1.11'),
	('C05703','4.4.1.13'),
	('C05703','1.8.1.9'),
	('C05703','4.4.1.1'),
	('C05711','2.3.2.2'),
	('C05712','2.4.1.63'),
	('C05712','2.4.1.85'),
	('C05712','2.4.1.178'),
	('C05712','3.2.1.21'),
	('C05712','4.1.2.47'),
	('C05712','4.1.2.46'),
	('C05712','4.1.2.10'),
	('C05712','4.1.2.11'),
	('C05713','3.2.1.21'),
	('C05713','2.4.1.178'),
	('C05713','2.4.1.85'),
	('C05713','2.4.1.63'),
	('C05714','3.5.5.1'),
	('C05715','3.5.5.1'),
	('C05726','3.4.11.1'),
	('C05726','3.4.11.2'),
	('C05726','2.3.1.80'),
	('C05726','3.5.1.114'),
	('C05726','3.5.1.14'),
	('C05726','3.4.11.23'),
	('C05727','3.5.1.115'),
	('C05727','3.5.1.114'),
	('C05727','3.5.1.14'),
	('C05727','2.3.1.80'),
	('C05729','3.4.11.1'),
	('C05729','3.4.11.23'),
	('C05729','3.4.11.2'),
	('C05729','2.3.2.2'),
	('C05730','6.3.1.9'),
	('C05730','6.3.1.8'),
	('C05730','3.5.1.78'),
	('C05731','1.1.99.13'),
	('C05744','2.3.1.41'),
	('C05744','2.3.1.85'),
	('C05744','2.3.1.86'),
	('C05744','2.3.1.179'),
	('C05744','2.3.1.180'),
	('C05744','1.1.1.100'),
	('C05745','2.3.1.184'),
	('C05745','2.3.1.85'),
	('C05745','2.3.1.86'),
	('C05745','1.3.1.104'),
	('C05745','1.3.1.10'),
	('C05745','2.3.1.179'),
	('C05745','1.3.1.39'),
	('C05745','1.3.1.9'),
	('C05745','2.3.1.41'),
	('C05746','1.1.1.100'),
	('C05746','2.3.1.179'),
	('C05746','2.3.1.41'),
	('C05746','2.3.1.85'),
	('C05746','2.3.1.86'),
	('C05747','2.3.1.86'),
	('C05747','1.1.1.100'),
	('C05747','4.2.1.59'),
	('C05747','2.3.1.85'),
	('C05748','2.3.1.86'),
	('C05748','1.3.1.10'),
	('C05748','1.3.1.9'),
	('C05748','1.3.1.39'),
	('C05748','4.2.1.59'),
	('C05748','1.3.1.104'),
	('C05748','2.3.1.85'),
	('C05749','1.3.1.9'),
	('C05749','2.3.1.179'),
	('C05749','2.3.1.41'),
	('C05749','2.3.1.86'),
	('C05749','1.3.1.39'),
	('C05749','1.3.1.104'),
	('C05749','2.3.1.85'),
	('C05749','1.3.1.10'),
	('C05749','2.3.1.221'),
	('C05750','1.1.1.100'),
	('C05750','2.3.1.41'),
	('C05750','2.3.1.85'),
	('C05750','2.3.1.179'),
	('C05750','2.3.1.86'),
	('C05751','1.3.1.10'),
	('C05751','2.3.1.85'),
	('C05751','1.3.1.9'),
	('C05751','1.3.1.39'),
	('C05751','1.3.1.104'),
	('C05751','4.2.1.59'),
	('C05751','2.3.1.86'),
	('C05752','2.8.1.8'),
	('C05752','2.3.1.181'),
	('C05752','2.3.1.179'),
	('C05752','2.3.1.86'),
	('C05752','1.3.1.10'),
	('C05752','1.3.1.9'),
	('C05752','2.3.1.41'),
	('C05752','2.3.1.85'),
	('C05752','1.3.1.39'),
	('C05752','3.1.2.21'),
	('C05752','1.3.1.104'),
	('C05753','1.1.1.100'),
	('C05753','2.3.1.85'),
	('C05753','2.3.1.41'),
	('C05753','2.3.1.86'),
	('C05753','2.3.1.179'),
	('C05753','2.3.1.207'),
	('C05754','1.3.1.39'),
	('C05754','4.2.1.59'),
	('C05754','2.3.1.85'),
	('C05754','1.3.1.9'),
	('C05754','5.3.3.14'),
	('C05754','2.3.1.86'),
	('C05754','1.3.1.10'),
	('C05754','1.3.1.104'),
	('C05755','2.3.1.41'),
	('C05755','2.3.1.85'),
	('C05755','1.3.1.39'),
	('C05755','3.1.2.21'),
	('C05755','1.3.1.104'),
	('C05755','2.3.1.179'),
	('C05755','2.3.1.86'),
	('C05755','1.3.1.10'),
	('C05755','1.3.1.9'),
	('C05756','1.1.1.100'),
	('C05756','2.3.1.179'),
	('C05756','2.3.1.41'),
	('C05756','2.3.1.85'),
	('C05756','2.3.1.86'),
	('C05757','1.1.1.100'),
	('C05757','2.3.1.85'),
	('C05757','4.2.1.59'),
	('C05757','2.3.1.86'),
	('C05758','2.3.1.86'),
	('C05758','1.3.1.9'),
	('C05758','1.3.1.104'),
	('C05758','2.3.1.85'),
	('C05758','4.2.1.59'),
	('C05758','1.3.1.39'),
	('C05758','1.3.1.10'),
	('C05759','2.3.1.179'),
	('C05759','2.3.1.85'),
	('C05759','2.3.1.86'),
	('C05759','2.3.1.41'),
	('C05759','1.1.1.100'),
	('C05760','4.2.1.59'),
	('C05760','1.3.1.39'),
	('C05760','2.3.1.85'),
	('C05760','2.3.1.86'),
	('C05760','1.3.1.104'),
	('C05760','1.3.1.10'),
	('C05760','1.3.1.9'),
	('C05761','1.3.1.39'),
	('C05761','1.3.1.104'),
	('C05761','1.3.1.10'),
	('C05761','3.1.2.14'),
	('C05761','2.3.1.243'),
	('C05761','2.3.1.179'),
	('C05761','2.3.1.85'),
	('C05761','2.3.1.86'),
	('C05761','1.3.1.9'),
	('C05761','2.3.1.41'),
	('C05762','2.3.1.86'),
	('C05762','1.1.1.100'),
	('C05762','2.3.1.85'),
	('C05762','2.3.1.41'),
	('C05762','2.3.1.179'),
	('C05763','1.3.1.10'),
	('C05763','1.3.1.104'),
	('C05763','2.3.1.85'),
	('C05763','1.3.1.39'),
	('C05763','1.3.1.9'),
	('C05763','2.3.1.86'),
	('C05763','4.2.1.59'),
	('C05764','2.3.1.41'),
	('C05764','2.3.1.179'),
	('C05764','2.3.1.85'),
	('C05764','2.3.1.86'),
	('C05764','1.3.1.10'),
	('C05764','1.3.1.9'),
	('C05764','3.1.2.14'),
	('C05764','1.3.1.104'),
	('C05764','2.3.1.199'),
	('C05764','1.3.1.39'),
	('C05764','1.14.19.11'),
	('C05764','1.14.19.26'),
	('C05764','1.14.19.2'),
	('C05765','2.7.2.13'),
	('C05766','4.1.1.37'),
	('C05768','4.1.1.37'),
	('C05770','4.99.1.9'),
	('C05770','1.3.3.15'),
	('C05772','1.14.13.83'),
	('C05772','2.1.1.130'),
	('C05773','6.3.5.11'),
	('C05773','5.4.99.60'),
	('C05774','2.5.1.17'),
	('C05775','3.1.3.73'),
	('C05775','2.7.8.26'),
	('C05778','4.99.1.3'),
	('C05778','4.99.1.4'),
	('C05778','1.3.1.76'),
	('C05778','2.1.1.107'),
	('C05786','1.3.7.5'),
	('C05787','2.4.1.95'),
	('C05787','2.4.1.17'),
	('C05787','3.2.1.31'),
	('C05791','3.2.1.31'),
	('C05796','3.2.1.23'),
	('C05803','2.1.1.201'),
	('C05804','2.1.1.201'),
	('C05805','2.1.1.64'),
	('C05807','4.1.1.98'),
	('C05809','4.1.1.98'),
	('C05809','2.5.1.39'),
	('C05810','4.1.1.98'),
	('C05811','2.1.1.222'),
	('C05812','2.1.1.222'),
	('C05813','2.1.1.201'),
	('C05814','2.1.1.201'),
	('C05815','2.1.1.64'),
	('C05817','4.2.1.113'),
	('C05817','4.2.99.20'),
	('C05818','2.5.1.74'),
	('C05818','2.1.1.163'),
	('C05819','1.6.5.2'),
	('C05819','1.8.5.3'),
	('C05819','1.3.5.3'),
	('C05819','1.10.3.12'),
	('C05819','1.12.5.1'),
	('C05819','4.1.1.90'),
	('C05819','2.1.1.163'),
	('C05819','1.7.5.2'),
	('C05821','6.3.2.14'),
	('C05822','3.1.4.16'),
	('C05822','3.1.3.6'),
	('C05823','1.1.1.27'),
	('C05824','1.8.4.3'),
	('C05824','2.5.1.47'),
	('C05825','1.4.1.12'),
	('C05827','1.2.1.5'),
	('C05827','1.4.3.22'),
	('C05827','1.4.3.4'),
	('C05828','1.2.1.5'),
	('C05829','3.5.1.87'),
	('C05837','3.2.1.147'),
	('C05838','3.2.1.21'),
	('C05839','3.2.1.21'),
	('C05840','1.4.1.21'),
	('C05840','1.4.3.16'),
	('C05840','2.5.1.72'),
	('C05841','2.4.2.1'),
	('C05841','3.1.3.5'),
	('C05841','2.7.1.173'),
	('C05841','3.2.2.3'),
	('C05842','1.2.3.1'),
	('C05843','1.2.3.1'),
	('C05844','2.3.2.2'),
	('C05847','2.5.1.39'),
	('C05847','2.5.1.74'),
	('C05848','4.1.1.98'),
	('C05848','2.5.1.39'),
	('C05849','1.14.99.20'),
	('C05849','4.1.1.90'),
	('C05849','1.17.4.4'),
	('C05849','1.17.4.5'),
	('C05850','1.6.5.2'),
	('C05852','1.13.11.27'),
	('C05853','1.1.1.90'),
	('C05855','3.2.1.126'),
	('C05855','2.4.1.111'),
	('C05856','1.1.3.23'),
	('C05859','2.5.1.87'),
	('C05860','2.4.1.132'),
	('C05860','2.4.1.142'),
	('C05861','2.4.1.132'),
	('C05892','6.3.2.10'),
	('C05892','6.3.2.7'),
	('C05893','2.4.1.129'),
	('C05893','2.3.2.10'),
	('C05893','2.4.1.227'),
	('C05894','2.3.2.10'),
	('C05894','2.3.2.16'),
	('C05895','2.3.2.10'),
	('C05895','2.3.2.18'),
	('C05897','2.7.8.13'),
	('C05897','2.4.1.227'),
	('C05898','2.4.1.129'),
	('C05898','2.4.1.227'),
	('C05902','2.1.1.76'),
	('C05903','2.1.1.76'),
	('C05903','2.1.1.155'),
	('C05903','2.4.2.56'),
	('C05903','2.4.1.91'),
	('C05903','2.4.1.234'),
	('C05903','1.14.11.23'),
	('C05903','1.14.13.88'),
	('C05903','1.14.13.21'),
	('C05904','1.14.11.19'),
	('C05904','1.3.1.77'),
	('C05904','2.4.1.115'),
	('C05905','2.4.1.115'),
	('C05905','2.4.1.294'),
	('C05905','1.3.1.77'),
	('C05905','1.14.11.19'),
	('C05906','1.17.1.3'),
	('C05906','1.14.11.19'),
	('C05906','1.1.1.219'),
	('C05907','1.1.1.234'),
	('C05908','1.14.11.19'),
	('C05908','2.4.1.115'),
	('C05908','1.3.1.77'),
	('C05909','1.1.1.219'),
	('C05909','1.14.11.19'),
	('C05909','1.17.1.3'),
	('C05911','1.14.11.9'),
	('C05911','1.14.13.88'),
	('C05911','1.14.11.22'),
	('C05912','1.3.7.3'),
	('C05912','1.3.7.6'),
	('C05913','1.3.7.4'),
	('C05921','6.3.4.11'),
	('C05921','6.3.4.10'),
	('C05921','6.2.1.11'),
	('C05921','6.3.4.9'),
	('C05921','6.3.4.15'),
	('C05922','3.5.4.16'),
	('C05923','3.5.4.16'),
	('C05924','2.8.1.12'),
	('C05924','2.7.7.75'),
	('C05925','4.2.1.160'),
	('C05925','3.6.1.67'),
	('C05925','3.1.4.56'),
	('C05927','1.5.99.15'),
	('C05927','1.5.1.47'),
	('C05928','6.3.2.17'),
	('C05928','6.3.2.12'),
	('C05929','6.3.2.17'),
	('C05931','1.2.1.71'),
	('C05931','3.5.1.96'),
	('C05932','1.2.1.71'),
	('C05932','2.6.1.81'),
	('C05933','3.5.3.25'),
	('C05933','1.14.13.39'),
	('C05933','1.14.13.165'),
	('C05936','1.4.3.4'),
	('C05936','1.5.3.15'),
	('C05936','1.2.1.3'),
	('C05938','1.2.1.88'),
	('C05942','4.1.1.93'),
	('C05942','1.14.13.130'),
	('C05945','2.7.3.3'),
	('C05946','2.6.1.21'),
	('C05946','2.6.1.1'),
	('C05946','4.1.3.16'),
	('C05946','2.6.1.23'),
	('C05947','2.6.1.1'),
	('C05947','2.6.1.21'),
	('C05947','1.2.1.88'),
	('C05947','2.6.1.23'),
	('C05951','3.4.19.14'),
	('C05951','2.3.2.2'),
	('C05952','1.14.13.34'),
	('C05956','1.14.99.1'),
	('C05959','1.1.1.188'),
	('C05960','1.1.1.196'),
	('C05960','1.1.1.141'),
	('C05965','1.13.11.31'),
	('C05966','1.11.1.9'),
	('C05966','1.14.14.1'),
	('C05966','1.13.11.33'),
	('C05973','2.3.1.40'),
	('C05973','3.1.1.5'),
	('C05973','3.1.1.32'),
	('C05974','3.1.1.32'),
	('C05977','3.1.3.4'),
	('C05979','1.1.1.202'),
	('C05979','2.3.1.152'),
	('C05980','2.7.8.41'),
	('C05981','3.1.3.36'),
	('C05981','3.1.3.86'),
	('C05981','2.7.1.153'),
	('C05981','3.1.3.67'),
	('C05983','6.2.1.1'),
	('C05983','6.2.1.17'),
	('C05984','1.1.1.27'),
	('C05985','1.1.2.8'),
	('C05985','1.2.5.2'),
	('C05985','1.2.1.3'),
	('C05986','1.1.2.8'),
	('C05989','4.2.1.155'),
	('C05990','2.1.1.78'),
	('C05993','6.2.1.1'),
	('C05993','3.6.1.20'),
	('C05998','4.2.1.17'),
	('C05999','4.2.1.30'),
	('C05999','1.1.1.21'),
	('C06000','3.1.2.4'),
	('C06000','4.2.1.17'),
	('C06001','3.1.2.4'),
	('C06001','1.1.1.31'),
	('C06001','1.1.1.35'),
	('C06002','1.2.1.3'),
	('C06002','1.2.1.27'),
	('C06002','1.2.3.1'),
	('C06002','1.1.1.35'),
	('C06002','2.6.1.22'),
	('C06002','1.1.1.31'),
	('C06002','2.6.1.18'),
	('C06006','1.1.1.86'),
	('C06006','2.2.1.6'),
	('C06006','5.4.99.3'),
	('C06007','1.1.1.86'),
	('C06007','4.2.1.9'),
	('C06010','2.2.1.6'),
	('C06010','1.1.1.86'),
	('C06010','4.1.1.5'),
	('C06010','5.4.99.3'),
	('C06010','1.1.1.383'),
	('C06010','1.1.1.382'),
	('C06011','2.8.2.3'),
	('C06018','2.3.1.209'),
	('C06018','2.6.1.33'),
	('C06019','4.1.2.43'),
	('C06019','5.3.1.27'),
	('C06020','2.1.1.248'),
	('C06020','2.1.1.246'),
	('C06020','2.1.1.249'),
	('C06020','2.1.1.245'),
	('C06020','2.1.1.250'),
	('C06020','2.1.1.258'),
	('C06020','2.3.1.169'),
	('C06020','2.1.1.253'),
	('C06020','2.1.1.247'),
	('C06020','2.1.1.251'),
	('C06020','1.2.7.4'),
	('C06020','2.1.1.252'),
	('C06020','2.1.1.90'),
	('C06021','2.1.1.246'),
	('C06021','2.1.1.245'),
	('C06021','2.1.1.258'),
	('C06021','2.1.1.253'),
	('C06021','2.1.1.252'),
	('C06021','2.1.1.251'),
	('C06021','2.3.1.169'),
	('C06021','2.1.1.250'),
	('C06021','1.2.7.4'),
	('C06021','2.1.1.90'),
	('C06021','2.1.1.249'),
	('C06021','2.1.1.248'),
	('C06021','2.1.1.247'),
	('C06022','2.3.1.191'),
	('C06022','3.5.1.108'),
	('C06023','3.2.1.132'),
	('C06023','3.2.1.165'),
	('C06024','2.4.99.13'),
	('C06024','2.4.99.12'),
	('C06024','2.7.1.166'),
	('C06025','2.4.2.43'),
	('C06025','2.3.1.241'),
	('C06025','2.3.1.242'),
	('C06025','2.4.99.13'),
	('C06025','2.4.99.14'),
	('C06025','2.7.8.42'),
	('C06026','2.7.4.29'),
	('C06026','2.3.1.243'),
	('C06026','2.7.8.42'),
	('C06026','2.4.2.43'),
	('C06027','4.2.1.148'),
	('C06027','4.1.3.24'),
	('C06028','4.2.1.148'),
	('C06028','5.4.1.3'),
	('C06028','1.3.8.12'),
	('C06030','4.1.1.3'),
	('C06032','4.2.1.35'),
	('C06032','1.1.1.85'),
	('C06033','4.1.3.17'),
	('C06037','2.4.1.241'),
	('C06037','3.2.1.22'),
	('C06038','2.3.1.134'),
	('C06040','2.7.8.20'),
	('C06040','2.4.1.315'),
	('C06041','2.7.8.20'),
	('C06044','1.1.1.90'),
	('C06047','1.13.11.29'),
	('C06048','1.13.11.30'),
	('C06051','1.1.99.9'),
	('C06054','2.6.1.52'),
	('C06054','1.1.1.290'),
	('C06055','2.6.1.52'),
	('C06055','4.2.3.1'),
	('C06055','1.1.1.262'),
	('C06056','4.2.3.1'),
	('C06058','1.7.3.1'),
	('C06060','3.5.3.12'),
	('C06060','3.5.3.6'),
	('C06060','3.5.3.13'),
	('C06060','3.5.3.5'),
	('C06060','3.5.3.9'),
	('C06067','2.5.1.34'),
	('C06071','2.4.1.324'),
	('C06071','1.14.13.74'),
	('C06074','4.2.3.15'),
	('C06074','4.2.1.127'),
	('C06074','1.14.14.31'),
	('C06075','4.2.3.113'),
	('C06082','2.4.1.263'),
	('C06082','1.14.13.93'),
	('C06082','1.2.3.14'),
	('C06082','3.2.1.175'),
	('C06083','4.2.1.123'),
	('C06086','4.2.3.147'),
	('C06087','1.2.1.74'),
	('C06089','4.2.3.28'),
	('C06089','4.2.3.31'),
	('C06089','4.2.3.30'),
	('C06089','4.2.3.29'),
	('C06089','4.2.3.103'),
	('C06089','5.5.1.13'),
	('C06089','4.2.3.19'),
	('C06090','4.2.3.19'),
	('C06090','1.14.13.78'),
	('C06093','1.14.13.79'),
	('C06094','1.14.11.12'),
	('C06095','1.14.11.12'),
	('C06096','1.14.11.13'),
	('C06098','2.4.1.276'),
	('C06098','1.14.13.129'),
	('C06098','1.14.99.42'),
	('C06098','1.14.13.90'),
	('C06098','1.23.5.1'),
	('C06098','1.13.11.65'),
	('C06099','4.2.3.20'),
	('C06099','1.14.13.80'),
	('C06099','1.14.13.107'),
	('C06102','1.2.1.63'),
	('C06102','3.7.1.11'),
	('C06102','1.1.1.258'),
	('C06102','1.1.1.2'),
	('C06102','1.2.1.4'),
	('C06103','1.1.1.258'),
	('C06103','3.1.1.83'),
	('C06103','1.1.1.2'),
	('C06103','3.1.1.17'),
	('C06104','1.2.1.4'),
	('C06104','1.2.1.63'),
	('C06105','3.7.1.11'),
	('C06105','1.1.1.174'),
	('C06108','1.2.1.69'),
	('C06108','3.8.1.3'),
	('C06108','3.1.2.29'),
	('C06109','1.6.2.4'),
	('C06110','1.6.2.4'),
	('C06112','6.3.5.7'),
	('C06112','6.1.1.24'),
	('C06113','6.1.1.23'),
	('C06113','6.3.5.6'),
	('C06114','2.3.2.2'),
	('C06118','4.2.2.6'),
	('C06118','4.2.2.9'),
	('C06118','4.2.2.2'),
	('C06123','4.1.2.27'),
	('C06123','1.3.1.27'),
	('C06124','4.1.2.27'),
	('C06124','2.7.1.91'),
	('C06124','3.1.3.4'),
	('C06125','3.1.6.8'),
	('C06125','3.1.6.1'),
	('C06125','2.8.2.11'),
	('C06126','2.8.2.11'),
	('C06126','3.2.1.22'),
	('C06127','2.8.2.11'),
	('C06128','3.2.1.18'),
	('C06133','2.4.99.8'),
	('C06133','2.4.1.92'),
	('C06134','2.4.99.8'),
	('C06134','2.4.1.62'),
	('C06134','2.4.1.92'),
	('C06135','3.2.1.18'),
	('C06135','2.4.99.9'),
	('C06135','3.2.1.52'),
	('C06135','2.4.1.62'),
	('C06135','2.4.1.92'),
	('C06135','3.2.1.23'),
	('C06136','3.2.1.23'),
	('C06136','2.4.1.62'),
	('C06136','2.4.99.9'),
	('C06138','2.4.99.8'),
	('C06139','2.4.99.8'),
	('C06139','3.2.1.18'),
	('C06140','3.2.1.18'),
	('C06140','2.4.99.8'),
	('C06140','2.4.99.4'),
	('C06141','3.2.1.18'),
	('C06141','2.4.1.62'),
	('C06141','2.4.99.8'),
	('C06141','2.4.99.4'),
	('C06142','1.1.5.11'),
	('C06142','1.1.2.9'),
	('C06143','3.1.1.75'),
	('C06144','4.2.1.27'),
	('C06148','3.5.4.16'),
	('C06153','1.1.1.370'),
	('C06153','1.1.1.371'),
	('C06156','2.3.1.157'),
	('C06156','5.4.2.10'),
	('C06157','2.3.1.61'),
	('C06157','1.2.4.2'),
	('C06159','4.1.2.18'),
	('C06159','4.2.1.67'),
	('C06160','4.2.1.78'),
	('C06160','2.1.1.128'),
	('C06161','2.1.1.140'),
	('C06161','2.1.1.128'),
	('C06161','2.1.1.115'),
	('C06161','1.14.21.3'),
	('C06162','1.5.3.12'),
	('C06162','1.3.1.107'),
	('C06163','2.1.1.122'),
	('C06163','1.14.13.37'),
	('C06165','1.5.3.12'),
	('C06167','1.5.1.27'),
	('C06171','1.1.1.247'),
	('C06172','1.14.11.31'),
	('C06173','1.14.11.31'),
	('C06173','1.14.11.32'),
	('C06174','2.4.1.17'),
	('C06174','1.14.11.32'),
	('C06174','1.1.1.247'),
	('C06174','1.14.14.1'),
	('C06175','1.14.11.31'),
	('C06175','1.14.11.32'),
	('C06176','1.14.13.101'),
	('C06178','1.4.3.21'),
	('C06186','2.4.1.218'),
	('C06187','3.2.1.86'),
	('C06188','3.2.1.86'),
	('C06192','3.6.1.21'),
	('C06193','3.1.3.6'),
	('C06193','3.1.4.16'),
	('C06194','3.1.4.16'),
	('C06195','3.5.4.8'),
	('C06196','3.6.1.66'),
	('C06196','3.6.1.64'),
	('C06197','3.6.1.29'),
	('C06198','3.6.1.17'),
	('C06201','4.1.2.52'),
	('C06202','1.2.1.65'),
	('C06202','4.1.2.45'),
	('C06203','4.1.2.45'),
	('C06203','5.99.1.4'),
	('C06204','1.13.11.56'),
	('C06204','5.99.1.4'),
	('C06205','1.3.1.20'),
	('C06205','3.3.2.9'),
	('C06206','3.6.1.7'),
	('C06210','1.13.11.2'),
	('C06212','2.1.1.49'),
	('C06213','2.1.1.49'),
	('C06215','3.2.1.64'),
	('C06215','2.4.1.10'),
	('C06215','3.2.1.65'),
	('C06216','3.2.1.74'),
	('C06217','3.2.1.74'),
	('C06218','3.2.1.74'),
	('C06219','3.2.1.74'),
	('C06222','2.7.1.3'),
	('C06224','4.1.1.102'),
	('C06231','4.2.1.108'),
	('C06232','2.10.1.1'),
	('C06240','1.1.1.336'),
	('C06240','2.4.1.180'),
	('C06241','3.1.3.29'),
	('C06241','2.5.1.56'),
	('C06241','2.5.1.57'),
	('C06244','3.5.1.4'),
	('C06246','4.1.1.90'),
	('C06247','4.1.1.90'),
	('C06249','6.3.4.15'),
	('C06249','6.3.4.10'),
	('C06249','6.3.4.11'),
	('C06249','6.3.4.9'),
	('C06250','6.3.4.9'),
	('C06250','6.4.1.2'),
	('C06250','6.3.4.10'),
	('C06250','6.3.4.15'),
	('C06250','6.3.4.11'),
	('C06250','6.3.4.14'),
	('C06251','2.3.1.241'),
	('C06251','2.3.1.243'),
	('C06254','2.3.1.158'),
	('C06258','1.14.14.18'),
	('C06259','1.9.6.1'),
	('C06260','1.9.6.1'),
	('C06304','4.2.3.116'),
	('C06305','4.2.3.117'),
	('C06306','4.2.3.121'),
	('C06307','4.2.3.120'),
	('C06308','4.2.3.119'),
	('C06309','4.2.1.129'),
	('C06310','5.4.99.17'),
	('C06311','1.1.1.251'),
	('C06311','2.7.1.200'),
	('C06312','1.1.1.251'),
	('C06313','1.5.1.33'),
	('C06316','1.1.3.37'),
	('C06317','1.1.3.38'),
	('C06318','1.14.12.15'),
	('C06318','1.3.1.53'),
	('C06319','1.3.1.54'),
	('C06319','2.1.1.132'),
	('C06320','1.3.1.54'),
	('C06320','2.1.1.152'),
	('C06321','1.3.1.25'),
	('C06321','1.14.12.10'),
	('C06322','1.3.7.8'),
	('C06322','1.3.8.10'),
	('C06322','4.2.1.100'),
	('C06323','1.3.99.16'),
	('C06324','1.3.99.16'),
	('C06325','1.3.99.18'),
	('C06326','1.5.1.28'),
	('C06327','1.3.1.107'),
	('C06327','1.5.3.12'),
	('C06329','3.1.1.45'),
	('C06329','1.3.1.32'),
	('C06330','1.13.11.47'),
	('C06330','1.14.13.62'),
	('C06331','1.13.11.48'),
	('C06332','1.13.11.48'),
	('C06333','1.14.12.14'),
	('C06336','1.14.12.14'),
	('C06336','1.13.11.2'),
	('C06337','1.14.12.15'),
	('C06338','1.14.12.16'),
	('C06338','1.14.13.61'),
	('C06339','1.14.12.16'),
	('C06341','1.14.14.23'),
	('C06341','1.14.14.29'),
	('C06341','1.1.1.181'),
	('C06342','1.14.13.61'),
	('C06343','1.14.13.62'),
	('C06346','2.1.1.128'),
	('C06348','2.1.1.128'),
	('C06350','2.1.1.128'),
	('C06352','2.1.1.129'),
	('C06353','2.1.1.129'),
	('C06355','2.3.1.151'),
	('C06356','2.3.1.151'),
	('C06356','2.3.1.220'),
	('C06357','2.3.1.152'),
	('C06358','2.3.1.152'),
	('C06359','2.3.1.152'),
	('C06360','2.3.1.152'),
	('C06361','2.3.1.153'),
	('C06361','2.4.1.298'),
	('C06362','2.3.1.153'),
	('C06363','2.3.1.153'),
	('C06364','2.4.1.337'),
	('C06364','2.4.1.208'),
	('C06365','2.4.1.208'),
	('C06365','2.7.8.20'),
	('C06366','2.5.1.45'),
	('C06366','2.5.1.44'),
	('C06367','2.7.8.23'),
	('C06368','2.7.8.23'),
	('C06369','3.1.3.68'),
	('C06370','3.2.1.139'),
	('C06371','3.2.1.140'),
	('C06372','3.2.1.140'),
	('C06372','2.4.1.211'),
	('C06374','3.5.1.79'),
	('C06376','3.5.1.25'),
	('C06377','3.5.1.25'),
	('C06378','3.5.1.81'),
	('C06379','3.5.1.82'),
	('C06380','3.5.1.83'),
	('C06381','3.5.3.21'),
	('C06382','3.5.3.21'),
	('C06383','3.5.3.21'),
	('C06384','3.5.3.21'),
	('C06387','1.21.1.2'),
	('C06387','3.8.1.7'),
	('C06387','6.2.1.33'),
	('C06388','4.1.1.76'),
	('C06389','4.1.1.76'),
	('C06390','4.2.1.98'),
	('C06392','4.2.1.98'),
	('C06393','4.3.1.15'),
	('C06394','4.2.3.13'),
	('C06395','5.1.1.16'),
	('C06396','5.1.1.16'),
	('C06397','5.1.3.20'),
	('C06397','2.7.7.70'),
	('C06398','5.1.3.20'),
	('C06399','6.3.5.9'),
	('C06399','5.4.99.61'),
	('C06400','5.4.99.15'),
	('C06400','3.2.1.141'),
	('C06403','2.1.1.127'),
	('C06404','2.1.1.127'),
	('C06406','2.1.1.131'),
	('C06406','1.14.13.83'),
	('C06407','2.1.1.133'),
	('C06407','2.1.1.131'),
	('C06408','5.4.99.61'),
	('C06408','2.1.1.132'),
	('C06409','1.16.1.8'),
	('C06410','1.16.1.8'),
	('C06412','3.1.2.22'),
	('C06413','1.3.99.17'),
	('C06414','1.3.99.19'),
	('C06415','1.3.99.17'),
	('C06416','2.1.1.152'),
	('C06416','2.1.1.133'),
	('C06423','3.1.2.21'),
	('C06424','3.1.2.14'),
	('C06425','3.1.2.2'),
	('C06426','1.14.19.3'),
	('C06426','3.1.2.2'),
	('C06427','3.1.1.32'),
	('C06427','3.1.1.4'),
	('C06427','3.1.2.2'),
	('C06427','1.13.11.12'),
	('C06427','1.13.11.77'),
	('C06427','1.13.11.61'),
	('C06428','3.1.2.2'),
	('C06428','5.3.3.13'),
	('C06429','3.1.2.2'),
	('C06429','1.14.13.199'),
	('C06432','3.4.17.8'),
	('C06433','3.6.1.20'),
	('C06435','3.6.1.20'),
	('C06441','4.1.2.19'),
	('C06441','2.7.1.5'),
	('C06442','4.2.1.108'),
	('C06442','2.3.1.178'),
	('C06451','2.1.1.308'),
	('C06451','1.1.1.309'),
	('C06451','1.13.11.73'),
	('C06451','1.13.11.72'),
	('C06452','1.11.1.23'),
	('C06452','2.1.1.308'),
	('C06453','2.1.1.308'),
	('C06454','1.11.1.23'),
	('C06455','1.13.11.72'),
	('C06456','2.7.7.93'),
	('C06459','2.7.7.15'),
	('C06468','5.1.3.31'),
	('C06468','5.1.3.30'),
	('C06472','3.2.1.76'),
	('C06473','2.7.1.13'),
	('C06473','1.1.99.4'),
	('C06473','1.1.99.3'),
	('C06473','1.1.1.274'),
	('C06473','1.1.1.215'),
	('C06479','1.14.13.54'),
	('C06481','2.7.1.164'),
	('C06481','2.9.1.1'),
	('C06481','6.1.1.11'),
	('C06482','2.9.1.1'),
	('C06482','2.9.1.2'),
	('C06483','2.4.1.40'),
	('C06484','2.8.1.5'),
	('C06485','4.2.1.111'),
	('C06485','1.1.1.292'),
	('C06485','1.1.1.263'),
	('C06485','4.2.1.110'),
	('C06503','6.6.1.2'),
	('C06503','6.3.5.9'),
	('C06504','6.6.1.2'),
	('C06504','1.16.8.1'),
	('C06504','6.3.5.11'),
	('C06505','1.16.8.1'),
	('C06505','2.5.1.17'),
	('C06506','6.3.5.10'),
	('C06506','2.5.1.17'),
	('C06507','6.3.1.10'),
	('C06507','6.3.5.10'),
	('C06507','3.5.1.90'),
	('C06508','6.3.1.10'),
	('C06508','2.5.1.17'),
	('C06508','2.7.1.156'),
	('C06508','3.5.1.90'),
	('C06509','6.3.1.10'),
	('C06509','2.7.1.156'),
	('C06509','2.7.7.62'),
	('C06510','2.7.7.62'),
	('C06510','2.7.8.26'),
	('C06511','1.14.21.3'),
	('C06512','1.14.21.3'),
	('C06516','2.1.1.115'),
	('C06517','2.1.1.121'),
	('C06517','2.1.1.128'),
	('C06517','2.1.1.115'),
	('C06517','2.1.1.116'),
	('C06518','2.1.1.121'),
	('C06520','2.1.1.116'),
	('C06520','2.1.1.115'),
	('C06526','1.14.13.67'),
	('C06542','3.1.1.80'),
	('C06547','1.14.17.4'),
	('C06547','1.18.6.1'),
	('C06547','1.14.13.69'),
	('C06547','1.13.12.19'),
	('C06548','1.14.13.69'),
	('C06548','3.3.2.10'),
	('C06551','3.8.1.8'),
	('C06552','3.5.4.43'),
	('C06552','3.8.1.8'),
	('C06553','3.5.4.43'),
	('C06553','3.5.4.42'),
	('C06554','3.5.2.15'),
	('C06554','3.5.4.42'),
	('C06555','3.5.2.15'),
	('C06555','3.5.1.84'),
	('C06560','3.8.1.8'),
	('C06561','1.21.3.6'),
	('C06561','5.5.1.6'),
	('C06561','2.4.1.286'),
	('C06561','2.3.1.74'),
	('C06562','1.17.1.3'),
	('C06563','2.1.1.150'),
	('C06563','1.14.13.89'),
	('C06563','2.1.1.212'),
	('C06563','4.2.1.105'),
	('C06563','2.4.1.170'),
	('C06564','1.14.20.1'),
	('C06564','5.1.1.17'),
	('C06565','1.14.11.26'),
	('C06565','1.14.20.1'),
	('C06567','3.5.2.6'),
	('C06568','2.1.3.7'),
	('C06577','1.2.1.29'),
	('C06578','1.2.1.29'),
	('C06579','1.3.1.58'),
	('C06580','1.3.1.58'),
	('C06584','1.14.12.18'),
	('C06585','1.3.1.56'),
	('C06585','1.14.12.18'),
	('C06586','1.3.1.56'),
	('C06586','1.13.11.39'),
	('C06587','1.13.11.39'),
	('C06587','3.7.1.8'),
	('C06588','1.14.12.18'),
	('C06589','1.3.1.56'),
	('C06589','1.14.12.18'),
	('C06597','3.8.1.5'),
	('C06598','3.8.1.5'),
	('C06599','3.8.1.5'),
	('C06603','1.2.1.61'),
	('C06603','1.13.11.66'),
	('C06604','1.14.14.1'),
	('C06604','3.1.8.1'),
	('C06606','1.14.14.1'),
	('C06606','3.1.8.1'),
	('C06607','3.1.8.1'),
	('C06608','3.1.8.1'),
	('C06609','3.8.1.5'),
	('C06610','3.8.1.5'),
	('C06611','1.1.1.1'),
	('C06611','3.8.1.5'),
	('C06612','1.1.1.1'),
	('C06612','3.8.1.5'),
	('C06613','1.1.1.1'),
	('C06613','1.2.1.3'),
	('C06614','1.2.1.3'),
	('C06615','1.2.1.3'),
	('C06616','2.1.1.254'),
	('C06616','1.14.13.154'),
	('C06620','1.1.1.384'),
	('C06620','4.2.1.159'),
	('C06630','2.4.1.278'),
	('C06630','2.4.1.328'),
	('C06633','1.14.13.154'),
	('C06633','2.4.1.278'),
	('C06633','2.1.1.254'),
	('C06635','1.14.13.188'),
	('C06635','2.4.1.328'),
	('C06653','1.14.13.154'),
	('C06653','2.1.1.254'),
	('C06655','6.3.3.4'),
	('C06655','2.5.1.66'),
	('C06656','6.3.3.4'),
	('C06656','1.14.11.21'),
	('C06657','1.14.11.21'),
	('C06657','3.5.3.22'),
	('C06658','1.14.11.21'),
	('C06658','3.5.3.22'),
	('C06659','1.14.11.21'),
	('C06660','1.14.11.21'),
	('C06669','1.14.20.3'),
	('C06671','1.21.1.2'),
	('C06672','2.4.1.300'),
	('C06672','1.2.1.67'),
	('C06672','1.2.3.9'),
	('C06672','1.14.13.82'),
	('C06676','3.1.1.92'),
	('C06678','1.1.1.257'),
	('C06679','1.1.1.257'),
	('C06679','1.2.1.62'),
	('C06680','4.1.1.55'),
	('C06688','1.14.13.211'),
	('C06689','2.4.1.322'),
	('C06697','1.20.9.1'),
	('C06697','2.1.1.137'),
	('C06697','1.20.4.4'),
	('C06697','1.20.99.1'),
	('C06697','1.20.2.1'),
	('C06697','1.20.4.1'),
	('C06701','1.20.1.1'),
	('C06711','1.1.1.256'),
	('C06711','1.14.12.12'),
	('C06712','1.1.1.256'),
	('C06714','1.1.1.35'),
	('C06714','3.7.1.21'),
	('C06714','1.1.1.259'),
	('C06715','2.3.1.16'),
	('C06715','1.1.1.35'),
	('C06715','1.1.1.259'),
	('C06717','2.3.1.189'),
	('C06717','1.8.1.15'),
	('C06717','1.1.1.306'),
	('C06718','1.1.1.306'),
	('C06719','1.3.1.57'),
	('C06721','1.3.1.60'),
	('C06722','1.3.1.60'),
	('C06723','1.3.1.62'),
	('C06725','1.3.1.65'),
	('C06726','1.3.1.65'),
	('C06727','1.3.1.66'),
	('C06728','1.3.1.66'),
	('C06729','1.3.1.67'),
	('C06730','1.13.11.2'),
	('C06730','1.13.11.1'),
	('C06730','1.14.13.1'),
	('C06730','1.14.13.7'),
	('C06730','1.3.1.67'),
	('C06731','1.3.1.68'),
	('C06732','1.3.3.10'),
	('C06733','1.13.11.67'),
	('C06734','1.13.11.67'),
	('C06735','1.1.1.276'),
	('C06735','1.1.1.387'),
	('C06735','1.14.11.17'),
	('C06738','2.4.1.209'),
	('C06739','2.4.1.209'),
	('C06740','2.4.1.210'),
	('C06741','3.1.1.73'),
	('C06742','3.13.1.3'),
	('C06742','1.14.14.22'),
	('C06744','3.2.1.144'),
	('C06746','3.5.1.85'),
	('C06748','3.5.4.42'),
	('C06749','4.2.1.100'),
	('C06749','1.1.1.368'),
	('C06751','1.8.3.5'),
	('C06752','3.8.1.5'),
	('C06753','1.1.2.7'),
	('C06753','1.1.2.8'),
	('C06753','3.8.1.5'),
	('C06754','1.14.14.1'),
	('C06754','1.2.1.3'),
	('C06754','1.1.2.7'),
	('C06754','1.1.2.8'),
	('C06755','1.2.1.3'),
	('C06755','3.8.1.3'),
	('C06755','3.8.1.2'),
	('C06757','1.1.1.90'),
	('C06758','1.1.1.90'),
	('C06758','1.2.1.7'),
	('C06758','1.2.1.28'),
	('C06760','1.13.11.2'),
	('C06760','3.7.1.9'),
	('C06760','1.2.1.85'),
	('C06761','4.2.1.80'),
	('C06761','3.7.1.9'),
	('C06762','4.1.3.43'),
	('C06762','4.2.1.80'),
	('C06762','4.2.1.132'),
	('C06789','1.97.1.8'),
	('C06790','2.5.1.18'),
	('C06790','1.14.12.11'),
	('C06790','1.14.14.1'),
	('C06790','1.97.1.8'),
	('C06790','1.14.13.25'),
	('C06791','1.97.1.8'),
	('C06792','1.97.1.8'),
	('C06800','1.14.13.175'),
	('C06800','1.14.14.1'),
	('C06801','1.14.13.200'),
	('C06802','2.7.1.187'),
	('C06809','1.10.3.15'),
	('C06813','1.14.12.23'),
	('C06868','1.14.14.1'),
	('C06892','2.7.1.92'),
	('C06892','5.3.1.30'),
	('C06893','2.7.1.92'),
	('C06893','4.1.2.29'),
	('C06899','1.1.1.1'),
	('C06899','1.2.1.5'),
	('C06988','3.8.1.5'),
	('C07031','2.1.1.38'),
	('C07032','2.1.1.38'),
	('C07044','3.5.3.25'),
	('C07044','2.6.99.3'),
	('C07047','1.14.14.1'),
	('C07054','2.3.1.5'),
	('C07073','3.1.1.1'),
	('C07073','1.14.14.1'),
	('C07083','1.14.14.11'),
	('C07083','4.1.1.102'),
	('C07083','1.14.12.12'),
	('C07084','1.3.1.19'),
	('C07085','1.3.1.19'),
	('C07085','1.13.11.2'),
	('C07086','1.2.1.5'),
	('C07086','3.5.1.4'),
	('C07086','3.5.1.11'),
	('C07086','3.5.5.1'),
	('C07086','1.2.1.39'),
	('C07086','6.2.1.30'),
	('C07087','3.7.1.9'),
	('C07087','1.13.11.2'),
	('C07089','1.13.11.2'),
	('C07090','5.5.1.1'),
	('C07090','3.1.1.45'),
	('C07091','3.1.1.45'),
	('C07095','5.5.1.7'),
	('C07098','2.1.1.136'),
	('C07103','1.6.5.7'),
	('C07108','1.14.13.8'),
	('C07108','1.14.14.1'),
	('C07111','1.17.99.2'),
	('C07111','1.14.12.12'),
	('C07113','1.14.12.12'),
	('C07113','1.1.1.311'),
	('C07113','6.4.1.8'),
	('C07114','6.4.1.8'),
	('C07118','2.3.1.16'),
	('C07130','1.14.13.179'),
	('C07130','1.14.13.178'),
	('C07160','1.14.13.160'),
	('C07160','6.2.1.38'),
	('C07189','1.14.12.12'),
	('C07209','1.2.1.7'),
	('C07209','1.2.1.28'),
	('C07209','1.1.1.90'),
	('C07211','1.2.1.28'),
	('C07211','1.2.1.7'),
	('C07213','1.1.1.90'),
	('C07214','1.2.1.28'),
	('C07214','1.1.1.90'),
	('C07214','1.2.1.7'),
	('C07215','1.2.1.28'),
	('C07215','1.2.1.7'),
	('C07216','1.1.1.90'),
	('C07271','1.14.13.107'),
	('C07271','3.3.2.8'),
	('C07272','3.5.2.16'),
	('C07276','3.3.2.8'),
	('C07276','1.1.1.297'),
	('C07277','5.4.99.59'),
	('C07277','1.1.1.266'),
	('C07278','3.2.1.97'),
	('C07281','2.5.1.46'),
	('C07282','2.5.1.46'),
	('C07282','1.14.99.29'),
	('C07287','1.1.1.260'),
	('C07288','1.1.1.260'),
	('C07289','1.14.19.39'),
	('C07290','1.14.99.34'),
	('C07291','1.14.99.34'),
	('C07292','1.20.4.1'),
	('C07293','1.20.4.1'),
	('C07294','2.1.1.137'),
	('C07294','1.20.4.2'),
	('C07295','2.1.1.137'),
	('C07295','1.20.4.2'),
	('C07296','2.3.1.176'),
	('C07297','2.3.1.176'),
	('C07299','3.1.1.74'),
	('C07300','3.1.1.74'),
	('C07301','3.5.1.86'),
	('C07303','4.1.2.41'),
	('C07303','4.2.1.101'),
	('C07304','4.3.3.3'),
	('C07305','6.2.1.34'),
	('C07305','6.3.2.18'),
	('C07307','4.3.3.4'),
	('C07308','2.1.1.137'),
	('C07326','1.1.1.263'),
	('C07328','1.1.1.265'),
	('C07329','1.1.1.265'),
	('C07330','1.5.99.12'),
	('C07330','1.13.11.59'),
	('C07331','3.5.5.8'),
	('C07331','4.4.1.27'),
	('C07335','1.1.1.262'),
	('C07338','1.13.11.45'),
	('C07343','1.14.11.18'),
	('C07344','1.14.13.67'),
	('C07345','1.14.15.7'),
	('C07347','1.14.99.35'),
	('C07348','1.14.99.35'),
	('C07349','2.1.1.139'),
	('C07350','2.3.1.156'),
	('C07354','5.4.4.6'),
	('C07447','2.3.1.5'),
	('C07478','1.2.1.85'),
	('C07478','5.3.2.6'),
	('C07479','4.1.1.77'),
	('C07479','5.3.2.6'),
	('C07480','1.17.3.2'),
	('C07480','1.14.13.179'),
	('C07480','1.14.13.178'),
	('C07480','2.1.1.160'),
	('C07480','2.1.1.159'),
	('C07481','1.14.13.178'),
	('C07481','2.1.1.160'),
	('C07481','1.14.13.179'),
	('C07481','1.17.5.2'),
	('C07481','1.14.14.1'),
	('C07490','1.14.13.25'),
	('C07490','2.4.1.17'),
	('C07490','1.1.1.1'),
	('C07496','1.14.14.1'),
	('C07535','1.14.14.1'),
	('C07535','1.14.12.12'),
	('C07565','2.3.1.5'),
	('C07572','1.14.14.1'),
	('C07572','1.4.3.4'),
	('C07585','2.3.1.5'),
	('C07635','1.1.1.51'),
	('C07639','1.21.99.3'),
	('C07645','1.2.1.5'),
	('C07645','1.1.1.1'),
	('C07645','2.5.1.18'),
	('C07646','1.2.1.5'),
	('C07648','2.4.2.8'),
	('C07649','2.4.2.10'),
	('C07649','2.4.2.3'),
	('C07649','1.3.1.2'),
	('C07649','2.4.2.4'),
	('C07712','1.14.15.18'),
	('C07712','1.14.15.16'),
	('C07715','1.14.12.12'),
	('C07721','1.14.12.12'),
	('C07731','3.7.1.8'),
	('C07734','3.7.1.8'),
	('C07756','3.5.1.93'),
	('C07836','5.3.1.28'),
	('C07836','2.7.1.167'),
	('C07838','2.7.7.70'),
	('C07838','3.1.3.82'),
	('C08057','6.3.3.5'),
	('C08060','1.14.12.22'),
	('C08061','1.14.12.22'),
	('C08062','3.7.1.13'),
	('C08242','2.4.1.166'),
	('C08247','3.2.1.168'),
	('C08249','4.1.99.3'),
	('C08250','2.4.1.333'),
	('C08276','6.2.1.44'),
	('C08276','1.13.11.53'),
	('C08276','2.1.1.269'),
	('C08299','2.1.1.49'),
	('C08325','3.2.1.117'),
	('C08325','3.2.1.21'),
	('C08334','2.4.1.63'),
	('C08334','3.2.1.21'),
	('C08353','5.4.99.62'),
	('C08357','2.8.2.15'),
	('C08358','2.8.2.15'),
	('C08359','2.8.2.15'),
	('C08362','3.1.2.14'),
	('C08362','3.1.1.98'),
	('C08481','2.4.1.220'),
	('C08491','2.1.1.141'),
	('C08492','2.3.1.195'),
	('C08492','1.1.1.1'),
	('C08576','1.21.3.6'),
	('C08577','1.21.3.6'),
	('C08578','5.5.1.6'),
	('C08579','1.14.13.90'),
	('C08579','5.3.99.8'),
	('C08579','1.23.5.1'),
	('C08580','1.14.13.129'),
	('C08583','1.14.13.129'),
	('C08584','5.3.99.8'),
	('C08585','5.3.99.8'),
	('C08586','5.5.1.18'),
	('C08586','5.5.1.19'),
	('C08588','2.4.1.271'),
	('C08589','2.4.1.330'),
	('C08590','1.14.13.129'),
	('C08590','1.14.99.45'),
	('C08591','1.14.13.129'),
	('C08592','1.14.13.129'),
	('C08601','1.14.13.129'),
	('C08601','1.14.99.45'),
	('C08604','2.4.1.299'),
	('C08604','2.4.1.300'),
	('C08604','2.4.1.254'),
	('C08604','2.4.1.297'),
	('C08604','2.4.2.51'),
	('C08604','2.4.1.298'),
	('C08604','2.4.1.115'),
	('C08604','2.3.1.171'),
	('C08604','2.3.1.215'),
	('C08606','5.3.99.9'),
	('C08607','1.2.1.82'),
	('C08612','2.3.1.213'),
	('C08613','5.5.1.19'),
	('C08613','1.13.11.59'),
	('C08614','5.3.99.9'),
	('C08614','5.3.99.8'),
	('C08614','1.14.13.90'),
	('C08614','1.23.5.1'),
	('C08615','5.4.99.40'),
	('C08616','1.14.99.43'),
	('C08616','1.14.13.134'),
	('C08616','5.4.99.39'),
	('C08616','1.14.13.201'),
	('C08620','2.4.1.116'),
	('C08626','5.4.99.50'),
	('C08628','5.4.99.41'),
	('C08637','5.4.99.35'),
	('C08639','2.4.1.298'),
	('C08639','2.3.1.153'),
	('C08639','2.3.1.215'),
	('C08639','2.4.1.299'),
	('C08647','2.4.1.294'),
	('C08647','2.4.2.50'),
	('C08650','2.3.1.170'),
	('C08650','2.1.1.154'),
	('C08650','5.5.1.6'),
	('C08721','2.3.1.136'),
	('C08725','2.4.1.299'),
	('C08725','2.4.1.298'),
	('C08725','2.3.1.215'),
	('C08725','2.3.1.153'),
	('C08733','3.8.1.8'),
	('C08734','3.5.4.42'),
	('C08734','3.5.4.43'),
	('C08735','3.8.1.8'),
	('C08735','3.5.4.43'),
	('C08737','3.8.1.8'),
	('C08794','1.3.1.5'),
	('C08813','1.14.19.41'),
	('C08821','1.3.1.21'),
	('C08825','1.1.1.270'),
	('C08830','1.14.13.72'),
	('C08830','2.1.1.41'),
	('C08886','2.4.1.193'),
	('C08888','3.2.1.188'),
	('C08897','3.2.1.189'),
	('C08897','3.2.1.190'),
	('C08898','3.2.1.189'),
	('C08907','3.2.1.186'),
	('C08980','2.4.1.262'),
	('C08980','1.14.99.43'),
	('C08983','2.4.1.273'),
	('C09023','1.5.1.46'),
	('C09060','1.14.13.115'),
	('C09092','1.14.13.190'),
	('C09094','3.1.7.5'),
	('C09094','1.14.13.110'),
	('C09099','2.4.1.236'),
	('C09099','2.4.1.185'),
	('C09126','2.3.1.115'),
	('C09126','2.4.1.170'),
	('C09131','1.1.1.332'),
	('C09140','4.2.3.150'),
	('C09183','4.2.3.141'),
	('C09239','1.14.13.91'),
	('C09244','1.14.13.73'),
	('C09276','1.14.13.102'),
	('C09305','1.14.13.102'),
	('C09306','4.1.1.12'),
	('C09320','1.17.1.3'),
	('C09321','5.5.1.6'),
	('C09332','6.3.2.17'),
	('C09382','1.14.13.120'),
	('C09555','2.1.1.291'),
	('C09614','5.5.1.6'),
	('C09614','1.14.13.21'),
	('C09614','1.14.11.9'),
	('C09627','1.14.13.119'),
	('C09629','4.2.3.57'),
	('C09639','4.2.3.133'),
	('C09648','4.2.3.128'),
	('C09663','4.2.3.85'),
	('C09664','4.2.3.68'),
	('C09665','4.2.3.46'),
	('C09666','4.2.3.47'),
	('C09672','4.2.3.71'),
	('C09684','4.2.3.104'),
	('C09684','1.14.13.150'),
	('C09694','1.14.13.202'),
	('C09694','3.1.1.59'),
	('C09694','2.1.1.325'),
	('C09699','4.2.3.58'),
	('C09704','4.2.3.48'),
	('C09718','4.2.3.83'),
	('C09723','4.2.3.66'),
	('C09727','1.3.1.77'),
	('C09736','1.1.1.219'),
	('C09737','1.14.13.121'),
	('C09750','4.2.3.65'),
	('C09751','1.14.11.9'),
	('C09751','1.1.1.219'),
	('C09751','1.14.13.21'),
	('C09755','3.2.1.168'),
	('C09762','5.5.1.6'),
	('C09762','1.14.13.21'),
	('C09762','1.14.13.136'),
	('C09762','1.14.13.87'),
	('C09762','1.14.11.9'),
	('C09789','2.4.1.236'),
	('C09806','2.4.1.236'),
	('C09811','1.3.8.10'),
	('C09811','1.3.8.11'),
	('C09814','4.2.1.84'),
	('C09814','3.5.5.1'),
	('C09815','3.5.1.4'),
	('C09815','4.2.1.84'),
	('C09816','4.1.99.11'),
	('C09816','2.8.3.15'),
	('C09817','2.8.3.15'),
	('C09817','1.3.8.3'),
	('C09818','1.3.8.3'),
	('C09819','1.1.1.35'),
	('C09820','1.1.1.35'),
	('C09821','3.7.1.21'),
	('C09821','1.1.1.368'),
	('C09823','1.3.8.11'),
	('C09825','3.7.1.21'),
	('C09826','1.14.11.9'),
	('C09826','1.14.11.23'),
	('C09827','1.14.11.22'),
	('C09827','5.5.1.6'),
	('C09827','1.14.11.9'),
	('C09833','2.1.1.232'),
	('C09844','1.14.13.157'),
	('C09844','1.14.13.156'),
	('C09844','4.2.3.108'),
	('C09847','1.1.1.183'),
	('C09848','1.1.1.183'),
	('C09849','1.1.1.183'),
	('C09870','2.3.1.69'),
	('C09871','1.1.1.183'),
	('C09873','4.2.3.106'),
	('C09893','1.14.13.104'),
	('C09893','1.3.1.81'),
	('C09898','4.2.3.115'),
	('C09900','4.2.3.114'),
	('C09902','4.2.3.112'),
	('C10020','2.3.1.115'),
	('C10023','2.4.1.253'),
	('C10023','3.2.1.167'),
	('C10025','2.4.1.253'),
	('C10025','3.2.1.167'),
	('C10028','1.14.11.22'),
	('C10044','1.14.11.23'),
	('C10098','2.1.1.155'),
	('C10101','1.1.1.199'),
	('C10107','1.14.11.23'),
	('C10107','1.14.13.88'),
	('C10107','2.1.1.267'),
	('C10175','2.4.2.35'),
	('C10192','1.14.11.22'),
	('C10192','1.14.13.88'),
	('C10192','2.1.1.175'),
	('C10192','2.1.1.169'),
	('C10193','2.1.1.175'),
	('C10193','2.1.1.169'),
	('C10208','4.2.1.105'),
	('C10208','2.1.1.212'),
	('C10208','1.14.13.89'),
	('C10208','2.4.1.170'),
	('C10208','2.1.1.150'),
	('C10216','2.4.1.170'),
	('C10216','2.3.1.115'),
	('C10287','2.1.1.240'),
	('C10343','2.1.1.283'),
	('C10385','1.10.9.1'),
	('C10419','1.3.1.45'),
	('C10422','1.14.13.85'),
	('C10428','2.1.1.279'),
	('C10434','1.14.13.36'),
	('C10434','2.3.1.133'),
	('C10443','2.3.1.217'),
	('C10447','2.8.3.23'),
	('C10447','4.3.1.22'),
	('C10452','2.1.1.146'),
	('C10453','2.1.1.146'),
	('C10453','1.1.1.318'),
	('C10454','2.1.1.146'),
	('C10469','1.1.1.319'),
	('C10469','2.1.1.146'),
	('C10469','2.1.1.279'),
	('C10478','2.1.1.279'),
	('C10478','2.1.1.146'),
	('C10502','2.4.1.170'),
	('C10503','2.4.1.170'),
	('C10503','4.2.1.139'),
	('C10509','2.4.1.170'),
	('C10509','2.3.1.115'),
	('C10516','2.1.1.270'),
	('C10517','3.1.3.69'),
	('C10517','2.4.1.213'),
	('C10520','1.14.21.8'),
	('C10520','1.14.13.52'),
	('C10521','2.1.1.150'),
	('C10522','1.14.21.8'),
	('C10522','1.14.13.89'),
	('C10538','2.4.1.170'),
	('C10538','2.3.1.115'),
	('C10552','1.14.13.214'),
	('C10556','1.14.11.50'),
	('C10557','1.14.11.50'),
	('C10646','1.23.1.1'),
	('C10646','1.23.1.2'),
	('C10682','1.1.1.331'),
	('C10682','1.14.21.11'),
	('C10700','1.14.13.84'),
	('C10772','1.17.2.2'),
	('C10784','1.21.3.8'),
	('C10793','1.14.13.116'),
	('C10906','1.1.1.124'),
	('C10906','2.4.1.13'),
	('C10945','1.2.1.44'),
	('C10945','2.1.1.68'),
	('C10945','1.1.1.195'),
	('C10974','1.4.3.21'),
	('C11004','3.1.1.1'),
	('C11006','1.14.12.24'),
	('C11038','2.7.4.6'),
	('C11038','2.7.4.12'),
	('C11039','2.7.4.6'),
	('C11039','2.7.7.7'),
	('C11061','2.4.1.17'),
	('C11062','4.2.1.120'),
	('C11062','6.2.1.40'),
	('C11088','2.5.1.18'),
	('C11101','1.1.3.47'),
	('C11129','3.5.2.20'),
	('C11130','1.14.13.139'),
	('C11130','1.14.13.138'),
	('C11131','2.4.1.17'),
	('C11132','2.4.1.17'),
	('C11133','2.4.1.17'),
	('C11134','2.4.1.17'),
	('C11135','2.4.1.17'),
	('C11136','2.4.1.17'),
	('C11142','1.8.1.17'),
	('C11143','1.8.2.4'),
	('C11143','1.8.5.3'),
	('C11143','1.8.1.17'),
	('C11145','1.14.13.111'),
	('C11145','1.14.14.5'),
	('C11148','1.14.14.1'),
	('C11148','1.14.13.25'),
	('C11150','1.2.1.5'),
	('C11173','2.4.1.17'),
	('C11173','3.2.1.31'),
	('C11173','3.1.1.1'),
	('C11174','2.7.4.21'),
	('C11174','2.7.4.24'),
	('C11215','1.20.2.1'),
	('C11215','1.20.4.1'),
	('C11215','1.20.99.1'),
	('C11215','1.20.9.1'),
	('C11215','1.20.4.4'),
	('C11242','1.3.1.111'),
	('C11249','1.14.15.3'),
	('C11278','2.5.1.18'),
	('C11301','2.8.2.14'),
	('C11338','2.3.1.69'),
	('C11348','1.1.1.311'),
	('C11348','1.17.99.2'),
	('C11348','1.14.12.12'),
	('C11354','4.2.1.132'),
	('C11354','3.7.1.9'),
	('C11354','4.1.1.77'),
	('C11355','4.1.3.38'),
	('C11355','2.6.1.85'),
	('C11376','2.4.1.17'),
	('C11376','3.2.1.31'),
	('C11377','2.4.99.1'),
	('C11382','4.2.3.107'),
	('C11383','1.3.99.25'),
	('C11383','1.1.1.275'),
	('C11384','1.1.1.183'),
	('C11386','1.1.1.183'),
	('C11387','1.1.1.322'),
	('C11388','4.2.3.26'),
	('C11388','1.14.13.151'),
	('C11389','4.2.1.127'),
	('C11389','5.4.4.4'),
	('C11389','4.2.3.25'),
	('C11389','1.14.13.151'),
	('C11393','4.2.3.108'),
	('C11393','4.2.3.111'),
	('C11396','1.1.1.296'),
	('C11397','1.1.1.296'),
	('C11398','1.3.99.25'),
	('C11398','1.1.1.296'),
	('C11398','1.14.13.105'),
	('C11399','1.1.1.296'),
	('C11400','1.1.1.296'),
	('C11401','1.1.1.296'),
	('C11401','1.14.13.105'),
	('C11402','1.14.13.105'),
	('C11402','3.1.1.83'),
	('C11403','1.14.13.105'),
	('C11403','3.1.1.83'),
	('C11404','3.1.1.83'),
	('C11405','1.14.13.105'),
	('C11406','3.1.1.83'),
	('C11409','1.14.13.80'),
	('C11409','1.1.1.275'),
	('C11410','1.1.1.296'),
	('C11411','1.1.1.296'),
	('C11412','1.14.13.105'),
	('C11412','1.3.99.25'),
	('C11412','1.1.1.296'),
	('C11413','1.1.1.296'),
	('C11414','1.14.13.105'),
	('C11414','3.1.1.83'),
	('C11415','1.14.13.105'),
	('C11415','1.1.1.296'),
	('C11416','1.1.1.296'),
	('C11417','3.1.1.83'),
	('C11418','3.1.1.83'),
	('C11418','1.14.13.105'),
	('C11419','1.14.13.105'),
	('C11420','3.1.1.83'),
	('C11434','2.7.7.60'),
	('C11434','1.1.1.267'),
	('C11435','2.7.1.148'),
	('C11435','2.7.7.60'),
	('C11436','4.6.1.12'),
	('C11436','2.7.1.148'),
	('C11437','2.6.99.2'),
	('C11437','1.1.1.267'),
	('C11437','2.2.1.7'),
	('C11437','2.8.1.10'),
	('C11439','3.5.1.88'),
	('C11440','3.5.1.88'),
	('C11449','1.14.14.15'),
	('C11453','1.17.7.1'),
	('C11453','4.6.1.12'),
	('C11453','1.17.7.3'),
	('C11455','1.14.13.70'),
	('C11455','1.3.1.70'),
	('C11457','1.14.13.127'),
	('C11472','3.1.3.82'),
	('C11472','2.7.1.167'),
	('C11475','2.1.1.63'),
	('C11475','4.3.2.4'),
	('C11475','2.6.99.1'),
	('C11476','3.2.1.55'),
	('C11477','3.1.3.23'),
	('C11477','3.2.1.62'),
	('C11477','3.2.1.147'),
	('C11478','2.1.1.61'),
	('C11480','1.13.11.67'),
	('C11481','4.4.1.25'),
	('C11481','4.4.1.24'),
	('C11481','1.13.11.55'),
	('C11481','3.1.1.92'),
	('C11481','1.8.99.5'),
	('C11482','1.2.1.31'),
	('C11496','1.1.1.268'),
	('C11496','4.4.1.23'),
	('C11497','1.1.1.269'),
	('C11497','1.1.1.268'),
	('C11497','1.8.1.5'),
	('C11498','1.1.1.269'),
	('C11498','4.4.1.23'),
	('C11499','1.1.1.310'),
	('C11500','1.1.3.39'),
	('C11501','1.1.3.39'),
	('C11502','1.8.1.15'),
	('C11503','1.13.11.47'),
	('C11504','1.13.11.48'),
	('C11505','1.14.13.69'),
	('C11506','4.4.1.23'),
	('C11506','1.14.13.69'),
	('C11507','4.4.1.23'),
	('C11507','1.14.13.69'),
	('C11508','1.14.13.70'),
	('C11508','1.3.1.70'),
	('C11509','1.14.13.72'),
	('C11510','2.1.1.136'),
	('C11511','4.3.1.16'),
	('C11512','2.1.1.141'),
	('C11513','2.1.1.142'),
	('C11514','2.1.1.144'),
	('C11515','2.1.1.145'),
	('C11516','3.1.3.70'),
	('C11516','2.4.1.217'),
	('C11519','4.2.1.103'),
	('C11520','4.2.1.103'),
	('C11521','3.13.1.1'),
	('C11522','2.1.1.143'),
	('C11522','5.3.3.5'),
	('C11522','1.14.13.72'),
	('C11523','2.1.1.143'),
	('C11523','1.14.13.72'),
	('C11524','3.6.1.52'),
	('C11525','3.6.1.52'),
	('C11526','2.7.4.24'),
	('C11526','2.7.4.21'),
	('C11526','3.6.1.52'),
	('C11527','1.13.11.46'),
	('C11529','3.5.1.87'),
	('C11531','3.2.1.149'),
	('C11535','3.2.1.149'),
	('C11536','3.1.3.71'),
	('C11536','4.4.1.19'),
	('C11537','1.1.1.338'),
	('C11537','1.1.1.337'),
	('C11537','1.1.1.37'),
	('C11537','1.1.1.308'),
	('C11537','3.1.3.71'),
	('C11538','4.99.1.3'),
	('C11538','2.1.1.151'),
	('C11539','2.1.1.131'),
	('C11540','2.1.1.131'),
	('C11540','2.1.1.271'),
	('C11542','1.3.1.106'),
	('C11542','2.1.1.195'),
	('C11543','1.3.1.106'),
	('C11543','2.1.1.196'),
	('C11544','3.1.3.70'),
	('C11544','2.4.1.269'),
	('C11544','2.7.1.195'),
	('C11545','5.4.99.60'),
	('C11545','2.1.1.289'),
	('C11546','3.1.3.69'),
	('C11546','2.4.1.332'),
	('C11547','3.1.1.77'),
	('C11548','3.1.1.77'),
	('C11549','3.1.1.76'),
	('C11550','3.1.1.76'),
	('C11551','3.1.1.75'),
	('C11552','3.1.1.75'),
	('C11553','2.8.2.30'),
	('C11553','2.8.2.23'),
	('C11553','2.8.2.29'),
	('C11554','3.1.3.64'),
	('C11554','3.1.3.66'),
	('C11554','3.1.3.36'),
	('C11554','3.1.3.86'),
	('C11554','2.7.1.154'),
	('C11555','2.7.1.151'),
	('C11556','2.7.1.150'),
	('C11556','3.1.3.95'),
	('C11557','2.7.1.150'),
	('C11557','3.1.3.95'),
	('C11557','2.7.1.149'),
	('C11557','3.1.3.78'),
	('C11572','2.4.99.18'),
	('C11583','2.5.1.18'),
	('C11588','1.3.1.87'),
	('C11588','1.14.12.19'),
	('C11620','2.1.1.267'),
	('C11630','1.3.7.3'),
	('C11630','1.3.7.2'),
	('C11631','1.1.3.28'),
	('C11632','3.1.1.78'),
	('C11633','3.1.1.78'),
	('C11633','2.3.1.160'),
	('C11634','1.1.1.273'),
	('C11635','1.14.13.91'),
	('C11635','1.1.1.273'),
	('C11636','2.4.1.323'),
	('C11636','1.14.13.74'),
	('C11638','1.1.1.262'),
	('C11638','2.6.99.2'),
	('C11643','2.1.1.94'),
	('C11643','1.14.13.73'),
	('C11675','2.1.1.94'),
	('C11695','3.5.1.99'),
	('C11700','2.3.1.166'),
	('C11700','2.3.1.167'),
	('C11735','1.4.3.19'),
	('C11735','3.1.1.1'),
	('C11736','2.7.1.21'),
	('C11736','2.4.2.4'),
	('C11785','1.14.14.1'),
	('C11807','1.14.13.75'),
	('C11807','2.3.1.160'),
	('C11808','1.5.1.32'),
	('C11808','1.3.1.73'),
	('C11809','3.1.1.80'),
	('C11809','1.3.1.73'),
	('C11810','3.1.1.80'),
	('C11811','1.17.7.4'),
	('C11811','1.17.7.1'),
	('C11811','1.17.7.3'),
	('C11818','1.5.1.31'),
	('C11821','3.5.2.17'),
	('C11821','1.7.3.3'),
	('C11821','1.14.13.113'),
	('C11822','1.1.1.276'),
	('C11822','1.1.1.387'),
	('C11823','4.3.1.10'),
	('C11823','4.3.1.23'),
	('C11823','4.3.1.24'),
	('C11823','4.3.1.25'),
	('C11823','4.3.1.3'),
	('C11823','4.3.1.6'),
	('C11823','4.3.1.7'),
	('C11823','4.3.1.9'),
	('C11825','1.1.1.277'),
	('C11826','2.4.1.129'),
	('C11827','2.4.1.129'),
	('C11829','1.14.13.81'),
	('C11830','1.14.13.81'),
	('C11831','1.3.1.75'),
	('C11831','1.3.1.33'),
	('C11831','1.14.13.81'),
	('C11832','1.3.1.75'),
	('C11832','1.3.1.33'),
	('C11837','2.3.1.184'),
	('C11838','4.4.1.21'),
	('C11838','2.7.1.189'),
	('C11848','1.14.13.182'),
	('C11854','1.14.11.13'),
	('C11855','1.14.11.13'),
	('C11857','1.14.11.12'),
	('C11857','1.14.13.79'),
	('C11860','1.14.11.12'),
	('C11861','1.14.11.12'),
	('C11863','2.1.1.275'),
	('C11863','1.14.11.13'),
	('C11863','1.14.11.15'),
	('C11863','1.14.11.12'),
	('C11864','1.14.11.15'),
	('C11864','2.1.1.276'),
	('C11864','1.14.11.13'),
	('C11865','1.14.11.13'),
	('C11868','1.14.11.13'),
	('C11869','1.14.11.13'),
	('C11870','1.14.11.13'),
	('C11872','1.14.13.78'),
	('C11873','1.14.13.78'),
	('C11874','1.14.13.79'),
	('C11874','1.14.13.78'),
	('C11875','1.14.13.79'),
	('C11876','1.14.13.79'),
	('C11877','4.2.3.29'),
	('C11878','4.2.3.18'),
	('C11878','1.14.13.108'),
	('C11879','4.2.3.32'),
	('C11880','4.2.3.132'),
	('C11881','4.2.3.32'),
	('C11882','1.14.13.108'),
	('C11882','1.14.13.109'),
	('C11887','1.14.13.109'),
	('C11887','1.2.1.74'),
	('C11890','4.2.3.42'),
	('C11894','1.14.99.37'),
	('C11894','4.2.3.17'),
	('C11895','1.14.99.37'),
	('C11895','2.3.1.162'),
	('C11895','1.14.13.77'),
	('C11896','1.14.13.76'),
	('C11896','2.3.1.162'),
	('C11897','1.14.13.77'),
	('C11898','1.14.13.76'),
	('C11898','1.14.13.146'),
	('C11899','2.3.1.166'),
	('C11900','2.3.1.167'),
	('C11901','4.2.3.45'),
	('C11901','4.2.3.147'),
	('C11901','4.2.3.132'),
	('C11901','4.2.3.131'),
	('C11901','4.2.3.32'),
	('C11901','4.2.3.18'),
	('C11901','5.5.1.12'),
	('C11901','4.2.3.44'),
	('C11902','5.5.1.14'),
	('C11902','4.2.3.99'),
	('C11902','4.2.3.33'),
	('C11902','4.2.3.42'),
	('C11902','4.2.3.35'),
	('C11902','4.2.3.34'),
	('C11903','1.8.98.1'),
	('C11903','1.12.98.3'),
	('C11904','1.8.98.1'),
	('C11904','1.12.98.3'),
	('C11907','4.2.1.159'),
	('C11907','4.2.1.46'),
	('C11907','1.1.1.266'),
	('C11907','5.3.2.4'),
	('C11907','5.3.2.3'),
	('C11907','5.1.3.13'),
	('C11907','5.1.3.27'),
	('C11907','2.6.1.33'),
	('C11907','2.6.1.59'),
	('C11908','5.3.2.4'),
	('C11908','2.6.1.89'),
	('C11909','4.3.1.30'),
	('C11909','2.6.1.106'),
	('C11910','2.1.1.234'),
	('C11910','2.6.1.106'),
	('C11911','2.4.1.277'),
	('C11911','2.1.1.234'),
	('C11911','2.4.1.278'),
	('C11912','1.1.1.364'),
	('C11912','2.4.1.317'),
	('C11916','2.4.1.318'),
	('C11916','2.4.1.328'),
	('C11922','1.1.1.384'),
	('C11922','4.2.1.164'),
	('C11924','1.2.1.3'),
	('C11925','2.6.1.89'),
	('C11925','2.1.1.235'),
	('C11926','1.1.1.364'),
	('C11926','5.1.3.27'),
	('C11930','4.2.1.159'),
	('C11933','2.1.1.235'),
	('C11933','2.4.1.316'),
	('C11937','1.14.13.105'),
	('C11937','1.1.1.297'),
	('C11945','4.2.1.17'),
	('C11946','4.2.1.17'),
	('C11947','4.2.1.17'),
	('C11951','1.3.1.82'),
	('C11952','1.3.1.81'),
	('C11991','2.1.1.239'),
	('C11992','2.1.1.239'),
	('C11993','2.3.1.239'),
	('C11993','2.4.1.277'),
	('C11994','1.14.13.185'),
	('C11994','2.4.1.277'),
	('C11995','1.14.13.185'),
	('C11996','1.14.13.185'),
	('C11997','2.4.1.277'),
	('C11997','2.3.1.240'),
	('C11998','2.4.1.277'),
	('C11998','1.14.13.185'),
	('C11999','1.14.13.185'),
	('C12000','2.4.1.316'),
	('C12001','2.4.1.316'),
	('C12002','1.14.13.186'),
	('C12002','2.4.1.317'),
	('C12003','2.4.1.317'),
	('C12003','2.4.1.318'),
	('C12016','2.8.2.36'),
	('C12026','2.6.1.103'),
	('C12044','2.1.1.315'),
	('C12083','5.3.3.13'),
	('C12088','2.3.1.212'),
	('C12092','6.2.1.32'),
	('C12092','2.3.1.159'),
	('C12093','2.3.1.159'),
	('C12095','2.4.1.298'),
	('C12095','2.3.1.215'),
	('C12096','2.3.1.215'),
	('C12096','2.4.1.298'),
	('C12096','2.3.1.172'),
	('C12107','4.2.1.144'),
	('C12108','4.2.1.144'),
	('C12112','1.14.11.52'),
	('C12112','2.4.1.338'),
	('C12115','1.10.3.15'),
	('C12115','4.1.99.20'),
	('C12124','1.1.1.234'),
	('C12125','2.1.1.150'),
	('C12126','1.14.18.5'),
	('C12126','1.14.19.17'),
	('C12126','1.14.18.7'),
	('C12126','3.5.1.23'),
	('C12126','2.3.1.24'),
	('C12127','1.17.1.3'),
	('C12128','1.3.1.77'),
	('C12134','1.14.13.89'),
	('C12135','1.14.13.89'),
	('C12135','1.3.1.45'),
	('C12136','1.3.1.77'),
	('C12137','2.4.1.299'),
	('C12137','2.4.1.300'),
	('C12137','2.4.2.51'),
	('C12137','2.4.1.297'),
	('C12137','2.4.1.298'),
	('C12137','2.4.1.115'),
	('C12137','2.3.1.171'),
	('C12137','2.3.1.215'),
	('C12138','2.4.1.300'),
	('C12138','2.3.1.171'),
	('C12138','2.4.1.115'),
	('C12138','2.4.1.298'),
	('C12138','2.4.1.297'),
	('C12138','2.4.2.51'),
	('C12138','2.4.1.299'),
	('C12138','2.3.1.215'),
	('C12142','4.2.3.21'),
	('C12142','1.14.13.121'),
	('C12144','2.3.1.24'),
	('C12144','3.5.1.23'),
	('C12144','1.14.18.5'),
	('C12145','3.5.1.23'),
	('C12145','2.3.1.24'),
	('C12145','1.14.18.6'),
	('C12145','1.14.18.5'),
	('C12145','1.14.19.29'),
	('C12146','2.3.1.24'),
	('C12147','2.7.1.177'),
	('C12147','4.1.1.81'),
	('C12203','1.2.1.44'),
	('C12203','2.1.1.104'),
	('C12203','6.2.1.12'),
	('C12204','1.2.1.44'),
	('C12204','1.1.1.195'),
	('C12204','2.1.1.68'),
	('C12205','2.1.1.68'),
	('C12205','1.11.1.7'),
	('C12205','1.11.1.21'),
	('C12205','1.1.1.195'),
	('C12206','1.1.1.195'),
	('C12206','2.1.1.68'),
	('C12208','2.3.1.133'),
	('C12208','1.14.13.36'),
	('C12211','2.4.1.301'),
	('C12212','2.7.1.179'),
	('C12212','3.1.3.92'),
	('C12213','2.7.1.179'),
	('C12213','2.6.1.104'),
	('C12213','3.1.3.92'),
	('C12214','2.2.1.1'),
	('C12215','2.2.1.1'),
	('C12248','4.1.1.97'),
	('C12248','3.5.2.17'),
	('C12249','2.4.1.91'),
	('C12249','2.4.1.239'),
	('C12270','6.3.2.41'),
	('C12270','3.4.17.21'),
	('C12270','6.3.2.42'),
	('C12287','1.13.11.68'),
	('C12287','1.13.11.71'),
	('C12299','2.3.1.224'),
	('C12305','2.1.1.274'),
	('C12308','1.14.11.12'),
	('C12312','1.14.13.138'),
	('C12312','1.14.13.137'),
	('C12313','1.1.1.174'),
	('C12314','1.14.13.22'),
	('C12316','1.14.11.19'),
	('C12317','4.1.2.42'),
	('C12321','2.4.1.311'),
	('C12322','2.4.1.322'),
	('C12323','2.6.1.103'),
	('C12324','1.13.11.80'),
	('C12324','2.3.1.246'),
	('C12325','2.6.1.103'),
	('C12325','1.13.11.80'),
	('C12347','2.6.99.1'),
	('C12354','2.3.1.235'),
	('C12366','4.2.1.154'),
	('C12366','2.3.1.235'),
	('C12367','4.2.1.154'),
	('C12367','1.13.12.21'),
	('C12368','1.13.12.21'),
	('C12371','1.14.13.200'),
	('C12378','1.14.13.200'),
	('C12379','2.4.1.331'),
	('C12379','1.14.13.200'),
	('C12415','5.5.1.23'),
	('C12415','5.5.1.26'),
	('C12416','1.13.12.22'),
	('C12417','5.5.1.23'),
	('C12417','1.1.1.362'),
	('C12419','1.1.1.362'),
	('C12421','2.1.1.288'),
	('C12422','2.1.1.288'),
	('C12422','5.5.1.23'),
	('C12423','5.5.1.23'),
	('C12423','1.1.1.362'),
	('C12424','2.4.1.326'),
	('C12424','1.1.1.362'),
	('C12424','1.14.13.180'),
	('C12425','1.14.13.180'),
	('C12428','1.14.13.181'),
	('C12428','2.1.1.292'),
	('C12429','2.1.1.292'),
	('C12429','1.14.13.181'),
	('C12430','1.14.13.181'),
	('C12431','1.14.13.181'),
	('C12432','1.14.13.181'),
	('C12432','2.1.1.292'),
	('C12448','3.1.1.1'),
	('C12448','1.1.1.334'),
	('C12448','3.1.1.84'),
	('C12452','2.3.1.185'),
	('C12453','2.3.1.186'),
	('C12455','1.4.3.21'),
	('C12456','2.5.1.111'),
	('C12458','6.3.1.15'),
	('C12468','6.3.1.15'),
	('C12474','2.4.1.302'),
	('C12474','2.1.1.284'),
	('C12475','2.4.1.302'),
	('C12475','2.1.1.285'),
	('C12476','2.1.1.285'),
	('C12476','2.1.3.12'),
	('C12481','2.4.1.302'),
	('C12525','1.1.1.210'),
	('C12537','2.3.1.196'),
	('C12621','1.14.13.127'),
	('C12622','1.3.1.87'),
	('C12622','1.14.12.19'),
	('C12623','1.3.1.87'),
	('C12623','1.14.13.127'),
	('C12623','1.13.11.16'),
	('C12624','1.13.11.16'),
	('C12624','3.7.1.14'),
	('C12625','2.3.1.115'),
	('C12626','2.4.1.234'),
	('C12627','2.4.1.236'),
	('C12628','2.1.1.153'),
	('C12629','2.1.1.153'),
	('C12630','2.4.1.236'),
	('C12631','4.2.1.105'),
	('C12631','1.14.13.136'),
	('C12632','3.2.1.31'),
	('C12632','2.4.1.191'),
	('C12632','2.4.1.190'),
	('C12633','2.1.1.267'),
	('C12634','2.4.1.240'),
	('C12634','2.4.1.239'),
	('C12635','2.4.1.240'),
	('C12635','2.3.1.173'),
	('C12636','2.3.1.173'),
	('C12637','2.4.2.35'),
	('C12638','2.3.1.116'),
	('C12639','2.4.1.237'),
	('C12640','2.3.1.215'),
	('C12640','2.3.1.172'),
	('C12641','2.3.1.172'),
	('C12641','2.3.1.214'),
	('C12642','2.3.1.171'),
	('C12643','2.4.1.254'),
	('C12643','2.3.1.171'),
	('C12644','2.4.1.116'),
	('C12645','2.4.1.116'),
	('C12646','2.4.1.116'),
	('C12647','2.3.1.214'),
	('C12650','3.1.1.1'),
	('C12667','2.4.1.239'),
	('C12667','2.4.1.240'),
	('C12668','2.4.1.240'),
	('C12739','2.4.2.4'),
	('C12739','3.5.4.5'),
	('C12833','5.5.1.7'),
	('C12834','5.5.1.7'),
	('C12834','3.1.1.45'),
	('C12835','3.1.1.45'),
	('C12835','1.3.1.32'),
	('C12836','1.3.1.32'),
	('C12837','1.3.1.19'),
	('C12838','5.5.1.7'),
	('C12838','3.1.1.45'),
	('C13050','3.2.2.6'),
	('C13051','2.4.99.20'),
	('C13273','1.14.13.110'),
	('C13309','1.6.5.12'),
	('C13309','2.1.1.163'),
	('C13378','2.2.1.1'),
	('C13378','2.2.1.3'),
	('C13425','2.5.1.39'),
	('C13431','1.13.11.51'),
	('C13431','5.3.99.9'),
	('C13433','5.3.99.9'),
	('C13433','1.13.11.51'),
	('C13453','1.1.1.288'),
	('C13453','1.13.11.51'),
	('C13455','1.2.3.14'),
	('C13455','1.1.1.288'),
	('C13482','2.1.1.103'),
	('C13550','1.14.14.25'),
	('C13550','1.14.14.26'),
	('C13635','1.13.11.41'),
	('C13636','1.14.13.84'),
	('C13636','3.1.1.2'),
	('C13645','2.5.1.18'),
	('C13645','1.11.1.18'),
	('C13712','1.1.1.149'),
	('C13712','1.1.1.213'),
	('C13713','1.1.1.213'),
	('C13747','1.17.3.2'),
	('C13747','2.3.1.5'),
	('C13747','2.1.1.160'),
	('C13747','1.14.13.178'),
	('C13747','1.14.13.179'),
	('C13747','1.14.14.1'),
	('C14040','1.14.14.1'),
	('C14044','1.13.11.51'),
	('C14045','1.13.11.51'),
	('C14082','1.14.12.12'),
	('C14083','1.14.12.12'),
	('C14083','1.3.1.29'),
	('C14084','1.3.1.29'),
	('C14088','1.14.13.1'),
	('C14089','1.1.1.1'),
	('C14090','1.1.1.1'),
	('C14098','1.14.12.12'),
	('C14099','1.1.1.1'),
	('C14102','1.14.12.12'),
	('C14103','1.14.13.1'),
	('C14104','1.14.12.12'),
	('C14104','1.3.1.29'),
	('C14105','1.3.1.29'),
	('C14109','1.14.13.1'),
	('C14110','1.14.13.1'),
	('C14144','4.2.1.17'),
	('C14144','2.3.1.223'),
	('C14145','1.1.1.35'),
	('C14145','1.1.1.157'),
	('C14145','4.2.1.17'),
	('C14146','5.5.1.18'),
	('C14151','2.1.1.95'),
	('C14151','5.5.1.24'),
	('C14152','2.1.1.95'),
	('C14153','2.1.1.95'),
	('C14154','2.1.1.95'),
	('C14155','5.5.1.24'),
	('C14155','2.1.1.95'),
	('C14156','2.1.1.95'),
	('C14156','5.5.1.24'),
	('C14177','2.7.3.5'),
	('C14178','2.7.3.5'),
	('C14179','1.2.1.73'),
	('C14180','4.4.1.22'),
	('C14180','1.1.1.284'),
	('C14315','1.14.12.12'),
	('C14448','1.2.3.15'),
	('C14463','5.4.99.3'),
	('C14463','1.1.1.86'),
	('C14531','3.5.99.9'),
	('C14536','2.4.1.170'),
	('C14556','1.14.14.1'),
	('C14582','1.17.99.1'),
	('C14602','5.4.4.3'),
	('C14604','5.4.4.3'),
	('C14610','5.5.1.1'),
	('C14610','5.3.3.4'),
	('C14695','1.14.14.10'),
	('C14727','2.1.1.315'),
	('C14748','1.14.15.3'),
	('C14749','1.14.15.3'),
	('C14749','1.14.14.1'),
	('C14768','3.3.2.10'),
	('C14768','1.14.14.1'),
	('C14769','1.14.14.1'),
	('C14769','3.3.2.10'),
	('C14770','3.3.2.10'),
	('C14770','1.14.14.1'),
	('C14771','1.14.14.1'),
	('C14771','3.3.2.10'),
	('C14772','3.3.2.10'),
	('C14773','3.3.2.10'),
	('C14774','3.3.2.10'),
	('C14775','3.3.2.10'),
	('C14778','1.14.14.1'),
	('C14781','1.14.14.1'),
	('C14782','1.14.14.1'),
	('C14786','2.5.1.18'),
	('C14786','3.3.2.9'),
	('C14786','1.14.14.1'),
	('C14787','2.5.1.18'),
	('C14787','1.14.14.1'),
	('C14787','3.3.2.9'),
	('C14791','2.5.1.18'),
	('C14792','2.5.1.18'),
	('C14793','2.5.1.18'),
	('C14800','1.14.14.1'),
	('C14800','3.3.2.9'),
	('C14800','2.5.1.18'),
	('C14801','3.3.2.9'),
	('C14802','1.14.14.1'),
	('C14802','2.5.1.18'),
	('C14803','2.5.1.18'),
	('C14804','2.5.1.18'),
	('C14805','2.5.1.18'),
	('C14806','2.5.1.18'),
	('C14808','3.3.2.7'),
	('C14809','3.3.2.7'),
	('C14813','1.14.14.1'),
	('C14814','1.14.14.1'),
	('C14818','1.14.14.18'),
	('C14818','1.9.98.1'),
	('C14818','4.99.1.1'),
	('C14818','4.99.1.4'),
	('C14818','4.99.1.9'),
	('C14818','1.14.99.48'),
	('C14818','1.16.5.1'),
	('C14818','1.16.3.1'),
	('C14818','1.16.1.9'),
	('C14818','1.16.1.7'),
	('C14819','1.16.3.1'),
	('C14819','1.9.98.1'),
	('C14819','1.16.5.1'),
	('C14819','1.16.1.7'),
	('C14819','1.14.14.18'),
	('C14819','1.16.1.9'),
	('C14825','1.14.14.1'),
	('C14826','1.14.14.1'),
	('C14827','4.2.1.121'),
	('C14827','1.13.11.58'),
	('C14830','1.1.1.271'),
	('C14831','1.13.11.60'),
	('C14831','5.4.4.5'),
	('C14831','5.4.4.6'),
	('C14839','2.5.1.18'),
	('C14839','3.3.2.9'),
	('C14840','2.5.1.18'),
	('C14840','3.3.2.9'),
	('C14842','3.3.2.9'),
	('C14844','3.3.2.9'),
	('C14847','2.5.1.18'),
	('C14848','2.5.1.18'),
	('C14849','1.14.14.1'),
	('C14850','3.3.2.9'),
	('C14850','1.14.14.1'),
	('C14851','1.14.14.1'),
	('C14851','2.5.1.18'),
	('C14852','3.3.2.9'),
	('C14852','1.14.14.1'),
	('C14852','2.5.1.18'),
	('C14853','1.14.14.1'),
	('C14854','1.14.14.1'),
	('C14855','2.5.1.18'),
	('C14856','2.5.1.18'),
	('C14857','2.5.1.18'),
	('C14858','2.5.1.18'),
	('C14859','2.5.1.18'),
	('C14861','2.5.1.18'),
	('C14863','2.5.1.18'),
	('C14864','2.5.1.18'),
	('C14865','2.5.1.18'),
	('C14866','1.14.14.1'),
	('C14868','2.5.1.18'),
	('C14869','2.4.1.17'),
	('C14870','2.5.1.18'),
	('C14871','2.5.1.18'),
	('C14874','2.5.1.18'),
	('C14899','4.1.1.85'),
	('C14899','2.7.1.53'),
	('C14909','1.14.13.142'),
	('C15025','1.1.1.254'),
	('C15037','1.13.12.13'),
	('C15038','1.13.12.13'),
	('C15204','1.14.13.88'),
	('C15484','1.1.1.278'),
	('C15485','1.14.11.25'),
	('C15485','1.1.1.285'),
	('C15485','1.14.11.24'),
	('C15486','1.1.1.285'),
	('C15486','2.6.1.80'),
	('C15488','2.2.1.8'),
	('C15488','1.2.1.69'),
	('C15489','1.2.7.8'),
	('C15492','1.3.99.23'),
	('C15493','1.2.3.1'),
	('C15493','1.2.1.36'),
	('C15494','1.8.5.2'),
	('C15495','1.8.5.2'),
	('C15496','1.11.1.15'),
	('C15497','1.10.5.1'),
	('C15498','1.11.1.15'),
	('C15499','1.13.11.50'),
	('C15500','1.14.11.24'),
	('C15500','1.14.11.25'),
	('C15501','1.14.11.25'),
	('C15502','1.14.11.25'),
	('C15503','1.14.13.41'),
	('C15504','1.14.13.43'),
	('C15505','1.14.13.50'),
	('C15506','1.14.13.54'),
	('C15507','1.14.13.54'),
	('C15508','1.14.13.69'),
	('C15509','2.5.1.36'),
	('C15509','1.14.13.85'),
	('C15510','2.5.1.36'),
	('C15510','1.14.13.85'),
	('C15511','1.14.13.85'),
	('C15512','1.14.13.92'),
	('C15513','1.14.13.92'),
	('C15513','2.3.1.224'),
	('C15514','1.14.13.93'),
	('C15515','1.14.13.94'),
	('C15516','1.14.13.97'),
	('C15517','1.14.13.97'),
	('C15518','1.1.1.181'),
	('C15518','1.14.14.26'),
	('C15519','1.14.14.29'),
	('C15519','1.14.99.38'),
	('C15520','1.1.1.181'),
	('C15520','1.14.14.29'),
	('C15521','1.14.14.5'),
	('C15522','1.14.16.1'),
	('C15522','4.2.1.96'),
	('C15522','1.14.16.7'),
	('C15522','1.14.16.2'),
	('C15522','1.14.16.4'),
	('C15523','1.17.3.3'),
	('C15524','3.1.2.25'),
	('C15524','1.17.5.1'),
	('C15525','2.4.1.286'),
	('C15525','2.3.1.74'),
	('C15525','1.21.3.6'),
	('C15527','2.1.1.107'),
	('C15530','2.1.1.147'),
	('C15531','2.1.1.154'),
	('C15532','3.5.1.16'),
	('C15532','2.1.3.9'),
	('C15533','2.2.1.8'),
	('C15534','2.3.1.87'),
	('C15535','2.3.1.87'),
	('C15537','2.3.1.163'),
	('C15538','2.3.1.163'),
	('C15539','2.3.1.215'),
	('C15539','2.3.1.171'),
	('C15539','2.4.1.115'),
	('C15539','2.4.1.297'),
	('C15539','2.4.1.298'),
	('C15539','2.4.2.51'),
	('C15540','2.3.1.171'),
	('C15541','2.4.1.266'),
	('C15541','2.4.1.13'),
	('C15541','2.4.1.242'),
	('C15541','2.4.1.245'),
	('C15542','2.4.1.54'),
	('C15543','2.4.1.143'),
	('C15544','2.4.1.144'),
	('C15545','2.4.1.215'),
	('C15546','2.4.1.215'),
	('C15547','3.1.2.28'),
	('C15547','4.1.3.36'),
	('C15548','2.4.1.230'),
	('C15549','2.4.1.238'),
	('C15550','2.4.1.238'),
	('C15555','2.4.2.35'),
	('C15556','4.1.99.12'),
	('C15556','2.5.1.78'),
	('C15557','2.8.2.14'),
	('C15558','2.8.2.17'),
	('C15559','2.8.2.34'),
	('C15560','2.8.3.25'),
	('C15561','3.5.1.91'),
	('C15562','3.5.1.91'),
	('C15563','3.5.1.102'),
	('C15563','3.5.4.29'),
	('C15564','3.8.1.11'),
	('C15564','3.8.1.10'),
	('C15564','3.8.1.9'),
	('C15565','3.8.1.11'),
	('C15565','3.8.1.9'),
	('C15565','1.1.1.337'),
	('C15565','1.1.1.375'),
	('C15565','3.8.1.10'),
	('C15565','1.1.3.15'),
	('C15566','4.1.1.84'),
	('C15567','2.1.1.212'),
	('C15567','4.2.1.105'),
	('C15567','1.14.13.136'),
	('C15568','4.2.1.106'),
	('C15569','4.2.1.106'),
	('C15570','1.14.11.23'),
	('C15570','1.14.11.9'),
	('C15571','2.1.1.6'),
	('C15572','2.1.1.6'),
	('C15573','2.4.1.224'),
	('C15574','2.4.1.224'),
	('C15575','2.4.1.225'),
	('C15576','2.4.1.225'),
	('C15577','2.4.1.226'),
	('C15578','2.4.1.226'),
	('C15579','2.4.1.236'),
	('C15580','2.4.1.237'),
	('C15581','2.4.1.240'),
	('C15581','2.4.1.239'),
	('C15582','2.4.1.240'),
	('C15583','3.1.1.2'),
	('C15584','3.1.8.1'),
	('C15584','3.1.6.1'),
	('C15584','2.8.2.22'),
	('C15584','2.8.2.1'),
	('C15584','3.1.1.2'),
	('C15584','2.4.1.35'),
	('C15585','3.1.3.25'),
	('C15586','2.4.2.1'),
	('C15586','2.7.1.143'),
	('C15586','3.2.2.1'),
	('C15587','2.4.2.1'),
	('C15587','3.2.2.1'),
	('C15588','3.3.2.10'),
	('C15589','5.5.1.6'),
	('C15590','2.7.1.94'),
	('C15591','1.1.1.199'),
	('C15592','1.1.99.29'),
	('C15593','1.1.99.29'),
	('C15594','1.1.99.29'),
	('C15595','1.1.99.29'),
	('C15596','1.3.1.74'),
	('C15596','1.14.15.12'),
	('C15596','1.3.1.102'),
	('C15597','1.3.1.74'),
	('C15597','1.3.1.102'),
	('C15598','1.3.1.77'),
	('C15599','1.3.3.11'),
	('C15601','1.14.13.85'),
	('C15602','1.5.5.2'),
	('C15602','1.3.5.1'),
	('C15602','1.1.5.11'),
	('C15602','1.6.5.10'),
	('C15602','1.1.5.10'),
	('C15602','1.10.5.1'),
	('C15602','1.1.99.18'),
	('C15602','1.7.5.1'),
	('C15602','1.1.98.4'),
	('C15602','1.1.5.4'),
	('C15602','1.1.5.9'),
	('C15602','1.3.5.6'),
	('C15602','1.1.5.8'),
	('C15602','1.3.5.4'),
	('C15602','1.1.5.7'),
	('C15602','1.2.5.2'),
	('C15602','1.1.5.6'),
	('C15602','1.4.5.1'),
	('C15602','1.2.5.3'),
	('C15602','1.8.5.4'),
	('C15602','1.6.5.5'),
	('C15602','1.14.18.3'),
	('C15602','1.3.5.2'),
	('C15602','1.6.5.2'),
	('C15602','1.1.5.3'),
	('C15603','1.1.5.3'),
	('C15603','1.1.5.11'),
	('C15603','1.1.5.10'),
	('C15603','1.1.99.18'),
	('C15603','1.1.98.4'),
	('C15603','1.1.5.9'),
	('C15603','1.1.5.8'),
	('C15603','1.1.5.7'),
	('C15603','1.1.5.6'),
	('C15603','1.2.5.3'),
	('C15603','1.2.5.2'),
	('C15603','1.14.18.3'),
	('C15603','1.6.5.2'),
	('C15603','1.6.5.10'),
	('C15603','1.7.5.1'),
	('C15603','1.3.5.4'),
	('C15603','1.4.5.1'),
	('C15603','1.3.5.2'),
	('C15603','1.3.5.1'),
	('C15603','1.3.5.6'),
	('C15603','1.8.5.4'),
	('C15603','1.5.5.2'),
	('C15603','1.10.5.1'),
	('C15603','1.1.5.4'),
	('C15604','1.8.3.5'),
	('C15605','1.13.11.52'),
	('C15606','3.1.3.77'),
	('C15606','3.1.3.87'),
	('C15606','1.13.11.53'),
	('C15606','1.13.11.54'),
	('C15607','3.5.1.95'),
	('C15607','3.5.2.1'),
	('C15608','1.14.11.22'),
	('C15609','1.14.13.88'),
	('C15610','1.14.14.23'),
	('C15610','1.14.15.15'),
	('C15610','1.14.14.29'),
	('C15612','1.14.13.101'),
	('C15613','1.17.99.3'),
	('C15613','5.1.99.4'),
	('C15613','6.2.1.7'),
	('C15614','1.17.99.3'),
	('C15615','2.1.1.150'),
	('C15616','2.1.1.150'),
	('C15646','3.1.4.39'),
	('C15647','3.1.4.4'),
	('C15650','3.1.3.77'),
	('C15650','5.3.2.5'),
	('C15650','4.2.1.109'),
	('C15651','3.1.3.87'),
	('C15651','5.3.2.5'),
	('C15651','3.1.3.77'),
	('C15652','2.6.1.95'),
	('C15653','1.8.4.12'),
	('C15656','2.4.1.223'),
	('C15658','3.1.4.50'),
	('C15666','3.5.1.93'),
	('C15667','6.3.4.18'),
	('C15667','5.4.99.18'),
	('C15668','2.6.1.82'),
	('C15673','1.1.1.346'),
	('C15673','1.1.1.215'),
	('C15673','1.1.1.274'),
	('C15681','2.1.1.238'),
	('C15681','2.1.1.237'),
	('C15682','2.1.1.238'),
	('C15699','6.3.1.11'),
	('C15767','3.5.1.94'),
	('C15769','1.14.13.140'),
	('C15769','1.14.13.139'),
	('C15770','2.4.1.202'),
	('C15770','1.14.13.140'),
	('C15772','2.4.1.202'),
	('C15772','1.14.20.2'),
	('C15776','5.3.3.5'),
	('C15776','1.3.1.70'),
	('C15777','1.14.13.72'),
	('C15777','1.14.19.20'),
	('C15778','1.14.19.20'),
	('C15778','1.14.19.41'),
	('C15780','1.3.1.21'),
	('C15780','1.14.19.20'),
	('C15781','1.3.1.21'),
	('C15782','1.14.19.20'),
	('C15782','1.14.13.72'),
	('C15783','1.3.1.21'),
	('C15783','1.14.19.20'),
	('C15785','1.3.1.22'),
	('C15786','1.3.1.22'),
	('C15795','1.14.13.112'),
	('C15796','1.14.13.112'),
	('C15796','1.3.1.22'),
	('C15797','1.14.13.112'),
	('C15797','1.3.1.22'),
	('C15800','1.14.13.112'),
	('C15801','1.14.13.112'),
	('C15804','1.11.1.7'),
	('C15804','1.11.1.21'),
	('C15805','1.11.1.7'),
	('C15805','1.11.1.21'),
	('C15806','1.11.1.21'),
	('C15806','1.11.1.7'),
	('C15807','1.11.1.21'),
	('C15807','1.11.1.7'),
	('C15808','1.1.1.170'),
	('C15808','1.14.13.72'),
	('C15809','1.4.3.19'),
	('C15809','4.1.99.19'),
	('C15809','2.8.1.10'),
	('C15810','2.8.1.10'),
	('C15810','2.7.7.73'),
	('C15811','2.8.1.7'),
	('C15811','2.8.1.13'),
	('C15812','2.8.1.7'),
	('C15812','2.8.1.13'),
	('C15813','2.7.7.73'),
	('C15814','2.8.1.10'),
	('C15816','1.1.1.170'),
	('C15816','1.1.1.270'),
	('C15850','3.4.17.23'),
	('C15853','2.5.1.46'),
	('C15854','2.5.1.46'),
	('C15857','1.3.5.6'),
	('C15857','5.2.1.12'),
	('C15858','1.3.5.6'),
	('C15858','5.2.1.13'),
	('C15859','4.2.1.131'),
	('C15867','1.3.99.30'),
	('C15867','5.5.1.19'),
	('C15874','1.3.99.27'),
	('C15874','2.1.1.210'),
	('C15877','4.2.1.131'),
	('C15877','2.1.1.210'),
	('C15878','4.2.1.131'),
	('C15878','1.3.99.27'),
	('C15879','2.1.1.210'),
	('C15879','1.3.99.27'),
	('C15881','2.1.1.210'),
	('C15881','1.14.15.9'),
	('C15882','5.5.1.24'),
	('C15882','2.1.1.295'),
	('C15882','2.5.1.115'),
	('C15883','2.1.1.295'),
	('C15883','5.5.1.24'),
	('C15884','1.14.15.9'),
	('C15885','1.14.15.9'),
	('C15886','2.1.1.210'),
	('C15886','4.2.1.131'),
	('C15887','4.2.1.131'),
	('C15887','2.1.1.210'),
	('C15888','2.1.1.210'),
	('C15892','4.2.1.131'),
	('C15892','2.1.1.210'),
	('C15892','1.3.99.27'),
	('C15895','2.1.1.210'),
	('C15898','2.1.1.210'),
	('C15898','1.3.99.27'),
	('C15900','2.1.1.210'),
	('C15900','4.2.1.131'),
	('C15900','1.14.15.9'),
	('C15902','1.14.15.9'),
	('C15902','4.2.1.131'),
	('C15903','1.14.15.9'),
	('C15903','4.2.1.131'),
	('C15905','1.14.15.9'),
	('C15905','4.2.1.131'),
	('C15908','4.2.1.131'),
	('C15911','4.2.1.131'),
	('C15915','1.3.1.72'),
	('C15925','5.1.3.18'),
	('C15926','2.7.7.69'),
	('C15926','3.1.3.93'),
	('C15930','4.2.1.146'),
	('C15930','1.1.1.365'),
	('C15965','1.14.13.129'),
	('C15966','1.14.13.129'),
	('C15967','1.14.13.129'),
	('C15968','1.14.13.129'),
	('C15969','2.4.1.276'),
	('C15970','3.2.1.175'),
	('C15970','2.4.1.263'),
	('C15972','1.8.1.4'),
	('C15972','1.2.4.1'),
	('C15972','1.2.4.2'),
	('C15972','1.2.4.4'),
	('C15973','2.3.1.168'),
	('C15973','1.8.1.4'),
	('C15973','2.3.1.12'),
	('C15973','2.3.1.61'),
	('C15974','1.2.4.4'),
	('C15975','1.2.4.4'),
	('C15975','2.3.1.168'),
	('C15976','1.2.4.4'),
	('C15977','1.2.4.4'),
	('C15977','2.3.1.168'),
	('C15978','1.2.4.4'),
	('C15979','1.2.4.4'),
	('C15979','2.3.1.168'),
	('C15980','2.3.1.168'),
	('C15980','1.2.7.7'),
	('C15980','1.2.1.25'),
	('C15980','1.3.8.1'),
	('C15980','1.3.8.7'),
	('C15980','1.3.99.12'),
	('C15981','1.14.99.45'),
	('C15981','1.14.13.129'),
	('C15985','3.1.1.80'),
	('C15986','3.7.1.19'),
	('C15986','1.5.99.14'),
	('C15987','1.5.3.19'),
	('C15987','1.5.3.21'),
	('C15987','3.7.1.19'),
	('C15988','3.1.3.76'),
	('C15989','3.1.3.76'),
	('C15990','3.1.3.62'),
	('C15990','3.1.3.72'),
	('C15991','3.1.3.62'),
	('C15992','3.3.2.11'),
	('C15996','6.3.4.20'),
	('C15996','1.7.1.13'),
	('C15998','1.8.4.14'),
	('C15999','1.8.4.13'),
	('C15999','1.8.4.11'),
	('C16001','1.11.1.16'),
	('C16002','1.11.1.16'),
	('C16011','2.4.2.31'),
	('C16011','3.2.2.19'),
	('C16014','3.3.2.9'),
	('C16015','3.3.2.9'),
	('C16028','4.2.3.24'),
	('C16028','1.14.13.158'),
	('C16069','4.4.1.24'),
	('C16070','4.6.1.14'),
	('C16071','4.6.1.15'),
	('C16074','3.5.5.1'),
	('C16074','4.99.1.7'),
	('C16074','4.2.1.84'),
	('C16075','1.14.13.124'),
	('C16075','4.99.1.7'),
	('C16138','6.1.1.26'),
	('C16139','6.1.1.26'),
	('C16141','1.14.13.123'),
	('C16141','4.2.3.23'),
	('C16142','4.2.3.75'),
	('C16143','4.2.3.22'),
	('C16143','4.1.99.16'),
	('C16144','2.5.1.96'),
	('C16144','1.3.8.2'),
	('C16145','1.14.99.44'),
	('C16145','1.3.8.2'),
	('C16146','1.14.99.44'),
	('C16149','4.1.2.34'),
	('C16149','1.13.11.38'),
	('C16150','1.5.99.4'),
	('C16152','1.1.1.328'),
	('C16153','2.6.1.87'),
	('C16153','2.1.2.13'),
	('C16154','2.4.2.53'),
	('C16154','2.1.2.13'),
	('C16155','1.1.1.305'),
	('C16155','2.6.1.87'),
	('C16156','2.4.2.53'),
	('C16157','2.4.2.43'),
	('C16159','1.1.1.291'),
	('C16159','3.5.2.18'),
	('C16162','3.1.2.2'),
	('C16162','1.14.19.3'),
	('C16163','1.14.19.3'),
	('C16164','1.14.19.44'),
	('C16165','3.1.2.2'),
	('C16165','1.14.19.44'),
	('C16167','1.14.19.3'),
	('C16168','1.3.3.6'),
	('C16168','1.14.19.3'),
	('C16169','2.3.1.16'),
	('C16169','3.1.2.2'),
	('C16171','1.14.19.3'),
	('C16172','1.3.3.6'),
	('C16172','1.14.19.3'),
	('C16173','2.3.1.16'),
	('C16179','1.14.19.37'),
	('C16180','1.14.19.37'),
	('C16181','3.8.1.5'),
	('C16182','3.8.1.5'),
	('C16186','2.7.1.194'),
	('C16187','4.2.1.139'),
	('C16187','1.1.1.348'),
	('C16190','2.1.1.212'),
	('C16190','4.2.1.105'),
	('C16191','2.3.1.115'),
	('C16192','2.3.1.115'),
	('C16195','2.3.1.115'),
	('C16195','2.4.1.170'),
	('C16197','2.3.1.115'),
	('C16203','1.3.1.29'),
	('C16203','1.14.12.12'),
	('C16204','1.3.1.29'),
	('C16215','1.3.1.19'),
	('C16216','1.1.1.330'),
	('C16216','2.3.1.199'),
	('C16217','4.2.1.134'),
	('C16217','1.1.1.330'),
	('C16218','4.2.1.134'),
	('C16218','1.3.1.38'),
	('C16218','1.3.1.93'),
	('C16219','2.3.1.41'),
	('C16219','2.3.1.199'),
	('C16219','2.3.1.179'),
	('C16219','1.1.1.100'),
	('C16220','1.1.1.100'),
	('C16221','1.3.1.9'),
	('C16222','2.3.1.115'),
	('C16223','2.4.1.170'),
	('C16223','2.3.1.115'),
	('C16224','2.3.1.115'),
	('C16226','1.3.1.45'),
	('C16226','1.14.13.89'),
	('C16227','1.3.1.45'),
	('C16228','1.3.1.45'),
	('C16230','2.1.1.270'),
	('C16231','2.3.1.115'),
	('C16232','1.14.13.136'),
	('C16233','1.14.13.136'),
	('C16236','2.8.1.8'),
	('C16236','2.3.1.181'),
	('C16237','1.8.1.4'),
	('C16237','2.3.1.181'),
	('C16237','6.3.1.20'),
	('C16237','2.8.1.8'),
	('C16238','6.3.1.20'),
	('C16239','2.8.1.8'),
	('C16239','2.3.1.181'),
	('C16240','6.3.1.20'),
	('C16240','2.3.1.181'),
	('C16241','6.3.1.20'),
	('C16242','3.7.1.12'),
	('C16242','2.1.1.271'),
	('C16243','3.7.1.12'),
	('C16243','2.1.1.195'),
	('C16244','2.1.1.196'),
	('C16244','2.1.1.289'),
	('C16246','4.2.1.84'),
	('C16248','1.14.13.50'),
	('C16249','1.3.1.32'),
	('C16251','1.14.13.112'),
	('C16252','1.14.13.112'),
	('C16253','1.14.13.112'),
	('C16254','1.2.4.2'),
	('C16254','2.3.1.61'),
	('C16255','1.2.4.1'),
	('C16255','2.3.1.12'),
	('C16256','2.8.3.17'),
	('C16257','2.8.3.17'),
	('C16258','2.8.2.31'),
	('C16259','2.8.2.31'),
	('C16260','2.8.2.32'),
	('C16261','2.8.2.32'),
	('C16265','3.2.1.35'),
	('C16266','1.13.11.39'),
	('C16269','4.2.3.37'),
	('C16269','1.14.13.106'),
	('C16272','2.8.3.8'),
	('C16273','2.8.3.8'),
	('C16276','5.5.1.18'),
	('C16286','4.2.3.22'),
	('C16286','4.1.99.16'),
	('C16291','5.5.1.19'),
	('C16297','2.3.1.215'),
	('C16299','2.3.1.172'),
	('C16301','2.4.1.249'),
	('C16301','2.3.1.171'),
	('C16301','2.4.1.238'),
	('C16303','2.4.1.249'),
	('C16304','2.4.1.249'),
	('C16304','2.4.1.238'),
	('C16305','2.4.1.297'),
	('C16306','2.4.1.297'),
	('C16307','2.4.1.297'),
	('C16310','1.1.1.1'),
	('C16312','2.4.1.298'),
	('C16312','2.3.1.153'),
	('C16312','2.4.1.299'),
	('C16312','2.4.1.238'),
	('C16313','2.3.1.153'),
	('C16313','2.4.1.238'),
	('C16314','2.4.1.238'),
	('C16320','4.2.1.121'),
	('C16321','4.2.1.121'),
	('C16321','4.2.1.92'),
	('C16321','1.13.11.12'),
	('C16324','4.2.1.92'),
	('C16327','1.3.3.6'),
	('C16328','4.2.1.74'),
	('C16328','1.3.3.6'),
	('C16328','4.2.1.17'),
	('C16329','4.2.1.74'),
	('C16329','4.2.1.17'),
	('C16329','1.1.1.211'),
	('C16329','1.1.1.35'),
	('C16330','1.1.1.35'),
	('C16330','2.3.1.16'),
	('C16330','1.1.1.211'),
	('C16331','2.3.1.16'),
	('C16331','1.3.3.6'),
	('C16332','4.2.1.17'),
	('C16332','4.2.1.74'),
	('C16332','1.3.3.6'),
	('C16333','1.1.1.35'),
	('C16333','4.2.1.17'),
	('C16333','4.2.1.74'),
	('C16333','1.1.1.211'),
	('C16334','1.1.1.211'),
	('C16334','2.3.1.16'),
	('C16334','1.1.1.35'),
	('C16335','1.3.3.6'),
	('C16335','2.3.1.16'),
	('C16336','4.2.1.74'),
	('C16336','4.2.1.17'),
	('C16336','1.3.3.6'),
	('C16337','4.2.1.17'),
	('C16337','1.1.1.35'),
	('C16337','4.2.1.74'),
	('C16337','1.1.1.211'),
	('C16338','2.3.1.16'),
	('C16338','1.1.1.35'),
	('C16338','1.1.1.211'),
	('C16339','2.3.1.16'),
	('C16348','1.1.1.1'),
	('C16348','1.2.1.3'),
	('C16349','2.3.1.153'),
	('C16350','2.3.1.153'),
	('C16351','2.3.1.153'),
	('C16352','3.2.2.25'),
	('C16352','2.1.1.158'),
	('C16353','1.17.3.2'),
	('C16353','2.1.1.160'),
	('C16353','2.1.1.159'),
	('C16353','3.2.2.25'),
	('C16353','1.14.13.178'),
	('C16353','1.14.13.179'),
	('C16353','1.14.13.128'),
	('C16354','2.4.1.238'),
	('C16355','1.17.3.2'),
	('C16356','1.17.3.2'),
	('C16356','1.14.14.1'),
	('C16357','1.14.13.178'),
	('C16357','1.14.13.179'),
	('C16358','1.14.14.1'),
	('C16358','1.14.13.178'),
	('C16358','1.14.13.179'),
	('C16358','1.17.3.2'),
	('C16359','1.17.3.2'),
	('C16360','1.17.3.2'),
	('C16361','1.14.13.212'),
	('C16361','1.17.5.2'),
	('C16361','1.7.3.3'),
	('C16362','1.7.3.3'),
	('C16365','2.3.1.5'),
	('C16367','2.3.1.215'),
	('C16368','2.3.1.215'),
	('C16369','2.3.1.215'),
	('C16370','2.3.1.215'),
	('C16371','2.3.1.153'),
	('C16372','2.3.1.153'),
	('C16373','2.4.1.254'),
	('C16374','1.3.3.6'),
	('C16375','1.1.1.211'),
	('C16376','2.3.1.16'),
	('C16376','1.1.1.211'),
	('C16387','1.3.3.6'),
	('C16388','1.1.1.211'),
	('C16389','1.1.1.211'),
	('C16389','2.3.1.16'),
	('C16390','1.1.1.291'),
	('C16396','1.2.7.4'),
	('C16396','1.12.99.6'),
	('C16396','1.2.7.1'),
	('C16396','2.3.1.5'),
	('C16399','1.12.99.6'),
	('C16399','1.2.7.1'),
	('C16399','1.8.99.5'),
	('C16399','1.2.7.4'),
	('C16400','1.8.99.5'),
	('C16404','2.3.1.74'),
	('C16404','5.5.1.6'),
	('C16405','2.3.1.74'),
	('C16407','2.4.1.286'),
	('C16407','1.21.3.6'),
	('C16408','1.21.3.6'),
	('C16408','2.4.1.286'),
	('C16409','1.21.3.6'),
	('C16410','1.21.3.6'),
	('C16415','1.1.1.219'),
	('C16420','2.3.1.5'),
	('C16422','2.4.1.185'),
	('C16422','2.4.1.236'),
	('C16424','2.5.1.112'),
	('C16426','2.5.1.112'),
	('C16453','1.1.1.146'),
	('C16453','1.1.1.184'),
	('C16453','1.14.14.1'),
	('C16453','1.3.1.20'),
	('C16461','1.2.1.86'),
	('C16463','3.1.4.52'),
	('C16463','2.7.7.65'),
	('C16466','4.1.3.4'),
	('C16466','4.1.3.26'),
	('C16466','2.3.1.16'),
	('C16468','4.2.1.17'),
	('C16469','1.1.1.35'),
	('C16469','4.2.1.17'),
	('C16470','2.3.1.16'),
	('C16471','1.1.1.35'),
	('C16471','2.3.1.16'),
	('C16472','1.3.1.25'),
	('C16472','1.13.11.1'),
	('C16473','1.13.11.1'),
	('C16473','1.3.1.25'),
	('C16474','1.13.11.1'),
	('C16474','5.5.1.1'),
	('C16475','5.5.1.7'),
	('C16475','1.13.11.1'),
	('C16476','5.5.1.1'),
	('C16476','3.1.1.45'),
	('C16477','5.5.1.7'),
	('C16477','3.1.1.45'),
	('C16478','1.14.12.10'),
	('C16478','1.3.1.25'),
	('C16479','1.3.1.25'),
	('C16479','1.14.12.10'),
	('C16480','1.3.1.25'),
	('C16480','1.14.12.10'),
	('C16481','1.14.12.10'),
	('C16482','1.14.12.10'),
	('C16487','3.1.8.2'),
	('C16487','3.8.1.7'),
	('C16487','3.8.1.3'),
	('C16487','3.1.1.45'),
	('C16502','2.1.1.325'),
	('C16502','1.14.13.203'),
	('C16503','1.14.13.202'),
	('C16503','2.1.1.325'),
	('C16504','1.14.13.203'),
	('C16504','3.1.1.59'),
	('C16504','2.1.1.325'),
	('C16505','3.1.1.59'),
	('C16506','3.1.1.59'),
	('C16516','2.4.1.195'),
	('C16517','2.4.1.195'),
	('C16519','2.2.1.9'),
	('C16519','4.2.99.20'),
	('C16520','3.1.2.14'),
	('C16520','2.3.1.242'),
	('C16520','1.14.19.2'),
	('C16521','4.2.3.27'),
	('C16538','1.1.1.292'),
	('C16540','1.14.13.122'),
	('C16540','1.1.1.294'),
	('C16541','2.5.1.62'),
	('C16541','1.1.1.294'),
	('C16541','3.1.1.14'),
	('C16541','1.14.13.122'),
	('C16543','3.1.1.1'),
	('C16545','1.14.13.8'),
	('C16546','1.14.14.1'),
	('C16547','1.14.14.1'),
	('C16550','1.14.14.1'),
	('C16551','1.1.1.1'),
	('C16555','1.14.14.1'),
	('C16560','1.14.14.1'),
	('C16561','3.1.1.1'),
	('C16561','1.14.14.1'),
	('C16562','6.3.1.9'),
	('C16563','6.3.1.9'),
	('C16563','1.8.1.12'),
	('C16564','1.8.1.12'),
	('C16565','6.3.1.9'),
	('C16565','2.5.1.16'),
	('C16566','6.3.1.9'),
	('C16567','6.3.1.9'),
	('C16567','1.8.1.12'),
	('C16568','1.8.1.12'),
	('C16577','2.4.1.17'),
	('C16578','2.4.1.17'),
	('C16581','1.1.1.122'),
	('C16583','4.2.1.114'),
	('C16586','1.1.1.1'),
	('C16587','1.2.1.5'),
	('C16587','1.1.1.1'),
	('C16591','1.2.1.5'),
	('C16595','1.1.1.1'),
	('C16596','1.1.1.1'),
	('C16597','4.2.1.114'),
	('C16598','4.2.1.114'),
	('C16600','4.2.1.114'),
	('C16607','1.14.14.1'),
	('C16608','1.14.14.1'),
	('C16608','1.4.3.4'),
	('C16609','1.4.3.4'),
	('C16609','1.14.14.1'),
	('C16610','1.2.3.1'),
	('C16612','1.2.3.1'),
	('C16612','1.4.3.4'),
	('C16613','1.17.3.2'),
	('C16614','2.1.1.67'),
	('C16614','2.4.2.8'),
	('C16615','2.4.2.8'),
	('C16615','2.1.1.67'),
	('C16618','6.3.5.2'),
	('C16618','1.1.1.205'),
	('C16619','2.1.1.67'),
	('C16619','2.4.2.8'),
	('C16619','6.3.5.2'),
	('C16620','2.1.1.67'),
	('C16622','2.3.1.5'),
	('C16630','3.5.2.2'),
	('C16630','1.3.1.2'),
	('C16631','3.5.2.2'),
	('C16631','3.5.1.6'),
	('C16632','3.5.1.6'),
	('C16633','2.4.2.3'),
	('C16633','2.7.1.48'),
	('C16634','2.7.1.48'),
	('C16634','2.4.2.10'),
	('C16635','3.5.4.5'),
	('C16635','3.1.1.1'),
	('C16636','6.1.1.11'),
	('C16637','2.4.2.4'),
	('C16638','2.7.1.164'),
	('C16638','2.9.1.2'),
	('C16639','5.4.99.62'),
	('C16641','3.1.1.1'),
	('C16643','2.4.1.17'),
	('C16644','1.11.1.14'),
	('C16647','3.1.1.1'),
	('C16663','1.11.1.15'),
	('C16663','1.17.4.1'),
	('C16664','1.11.1.15'),
	('C16664','1.17.4.1'),
	('C16667','4.6.1.14'),
	('C16669','3.6.1.59'),
	('C16672','3.5.2.6'),
	('C16675','2.4.2.29'),
	('C16675','1.7.1.13'),
	('C16676','2.4.1.118'),
	('C16677','1.14.14.1'),
	('C16679','1.14.15.3'),
	('C16679','1.14.14.1'),
	('C16680','1.14.14.1'),
	('C16681','1.2.3.1'),
	('C16681','1.1.1.315'),
	('C16681','1.2.1.36'),
	('C16682','1.1.1.315'),
	('C16684','2.3.1.118'),
	('C16685','2.3.1.118'),
	('C16687','2.7.8.9'),
	('C16688','3.2.1.26'),
	('C16688','2.7.1.211'),
	('C16689','2.5.1.20'),
	('C16690','2.3.2.1'),
	('C16691','4.3.2.4'),
	('C16693','1.10.9.1'),
	('C16693','1.3.5.5'),
	('C16693','1.10.3.9'),
	('C16695','1.10.9.1'),
	('C16695','2.1.1.295'),
	('C16698','2.7.1.192'),
	('C16698','4.2.1.126'),
	('C16699','3.2.1.170'),
	('C16699','2.7.1.195'),
	('C16711','1.17.4.4'),
	('C16715','1.3.99.19'),
	('C16716','2.3.1.230'),
	('C16717','3.1.1.36'),
	('C16718','3.1.1.36'),
	('C16718','2.4.1.210'),
	('C16720','2.1.1.98'),
	('C16722','2.3.2.9'),
	('C16729','1.11.1.8'),
	('C16730','1.11.1.8'),
	('C16731','1.11.1.8'),
	('C16732','1.11.1.8'),
	('C16733','1.11.1.8'),
	('C16734','1.11.1.8'),
	('C16736','1.11.1.15'),
	('C16737','5.3.1.30'),
	('C16737','3.7.1.22'),
	('C16738','2.5.1.18'),
	('C16739','2.3.2.8'),
	('C16741','2.7.1.81'),
	('C16753','1.14.13.175'),
	('C16756','1.14.14.1'),
	('C16776','4.2.3.123'),
	('C16814','4.2.3.40'),
	('C16818','4.2.3.145'),
	('C16825','2.3.1.69'),
	('C16826','2.5.1.88'),
	('C16826','2.5.1.68'),
	('C16826','2.5.1.86'),
	('C16826','4.2.3.62'),
	('C16827','2.3.1.213'),
	('C16827','2.4.1.126'),
	('C16828','1.14.18.1'),
	('C16829','4.2.3.56'),
	('C16830','1.1.1.121'),
	('C16831','2.1.1.106'),
	('C16832','1.8.1.4'),
	('C16834','3.1.1.1'),
	('C16836','3.1.1.1'),
	('C16837','3.1.1.1'),
	('C16848','2.2.1.10'),
	('C16848','2.2.1.11'),
	('C16849','2.2.1.10'),
	('C16850','2.2.1.10'),
	('C16850','1.4.1.24'),
	('C16884','1.1.1.162'),
	('C16884','1.1.1.403'),
	('C16930','1.1.1.318'),
	('C16930','2.1.1.146'),
	('C16999','3.2.2.26'),
	('C16999','3.5.4.40'),
	('C17010','3.2.2.26'),
	('C17010','3.2.2.30'),
	('C17010','1.21.98.1'),
	('C17017','1.21.98.1'),
	('C17022','2.5.1.73'),
	('C17022','6.1.1.27'),
	('C17023','2.8.4.5'),
	('C17023','2.8.1.12'),
	('C17023','2.8.1.6'),
	('C17023','2.8.1.8'),
	('C17023','2.8.4.3'),
	('C17023','2.8.4.4'),
	('C17027','6.1.1.26'),
	('C17141','2.8.2.8'),
	('C17142','2.8.2.8'),
	('C17148','1.14.13.201'),
	('C17202','3.1.2.22'),
	('C17202','2.3.1.225'),
	('C17205','3.1.6.17'),
	('C17206','1.14.11.6'),
	('C17207','2.4.1.319'),
	('C17207','3.2.1.78'),
	('C17207','3.2.1.25'),
	('C17209','4.2.3.124'),
	('C17209','2.6.1.100'),
	('C17234','4.4.1.1'),
	('C17234','4.4.1.2'),
	('C17234','4.4.1.11'),
	('C17239','2.4.1.195'),
	('C17240','2.4.1.195'),
	('C17243','2.4.1.195'),
	('C17244','2.4.1.195'),
	('C17259','2.4.1.195'),
	('C17261','2.4.1.195'),
	('C17267','1.13.11.18'),
	('C17276','2.3.1.135'),
	('C17277','4.2.3.73'),
	('C17322','2.8.1.13'),
	('C17324','2.3.1.234'),
	('C17324','3.5.4.33'),
	('C17324','2.1.1.55'),
	('C17325','2.1.1.203'),
	('C17325','3.5.4.35'),
	('C17325','2.1.1.204'),
	('C17325','2.1.1.202'),
	('C17331','1.1.1.181'),
	('C17332','1.1.1.181'),
	('C17333','1.14.14.29'),
	('C17335','1.14.14.29'),
	('C17335','1.1.1.181'),
	('C17336','1.1.1.181'),
	('C17337','1.1.1.181'),
	('C17339','1.14.18.8'),
	('C17339','1.3.99.5'),
	('C17339','1.3.1.3'),
	('C17343','1.17.99.3'),
	('C17343','5.1.99.4'),
	('C17345','6.2.1.7'),
	('C17345','5.1.99.4'),
	('C17346','5.1.99.4'),
	('C17346','1.17.99.3'),
	('C17349','1.14.11.34'),
	('C17351','5.1.1.14'),
	('C17352','2.5.1.38'),
	('C17352','5.1.1.14'),
	('C17355','2.5.1.38'),
	('C17366','2.3.1.226'),
	('C17366','6.3.3.6'),
	('C17367','1.14.20.3'),
	('C17367','6.3.3.6'),
	('C17378','2.3.1.186'),
	('C17401','2.1.1.151'),
	('C17432','2.5.1.91'),
	('C17500','1.10.3.4'),
	('C17509','4.1.99.3'),
	('C17510','4.1.99.3'),
	('C17513','2.4.1.330'),
	('C17513','2.4.1.271'),
	('C17530','1.14.13.226'),
	('C17541','2.3.2.16'),
	('C17541','2.3.2.17'),
	('C17542','2.3.2.17'),
	('C17542','2.3.2.18'),
	('C17550','2.3.2.10'),
	('C17551','2.1.1.222'),
	('C17552','2.1.1.222'),
	('C17554','2.1.1.114'),
	('C17556','2.7.8.6'),
	('C17556','2.4.1.54'),
	('C17556','2.7.8.40'),
	('C17556','2.7.8.13'),
	('C17556','2.7.8.31'),
	('C17556','2.7.8.33'),
	('C17556','2.4.2.53'),
	('C17556','2.4.2.43'),
	('C17556','3.6.1.27'),
	('C17556','2.7.4.29'),
	('C17556','2.7.1.66'),
	('C17558','2.7.1.66'),
	('C17559','2.1.1.114'),
	('C17560','2.1.1.201'),
	('C17561','2.1.1.201'),
	('C17562','2.1.1.64'),
	('C17568','2.1.1.64'),
	('C17569','2.1.1.64'),
	('C17570','2.5.1.117'),
	('C17570','2.1.1.295'),
	('C17580','1.1.1.329'),
	('C17580','1.1.99.38'),
	('C17580','2.6.1.100'),
	('C17581','2.6.1.101'),
	('C17581','1.1.99.38'),
	('C17581','1.1.1.329'),
	('C17582','3.5.1.112'),
	('C17582','2.4.1.283'),
	('C17583','1.1.3.43'),
	('C17583','2.6.1.93'),
	('C17586','4.3.2.6'),
	('C17587','2.4.1.285'),
	('C17587','3.5.1.113'),
	('C17588','3.5.1.113'),
	('C17588','1.1.3.44'),
	('C17589','1.1.3.44'),
	('C17589','2.6.1.95'),
	('C17592','2.1.1.291'),
	('C17621','1.1.1.324'),
	('C17621','1.14.13.152'),
	('C17622','1.1.1.324'),
	('C17627','3.1.7.1'),
	('C17628','3.1.7.1'),
	('C17658','1.1.1.391'),
	('C17658','1.1.1.393'),
	('C17691','2.7.1.188'),
	('C17691','4.2.3.152'),
	('C17691','5.1.3.33'),
	('C17692','5.1.3.35'),
	('C17692','2.7.1.188'),
	('C17693','5.1.3.35'),
	('C17694','5.1.3.33'),
	('C17700','2.4.1.338'),
	('C17700','3.1.3.101'),
	('C17740','2.3.1.219'),
	('C17740','2.3.1.218'),
	('C17740','2.3.1.217'),
	('C17741','2.3.1.219'),
	('C17741','2.3.1.217'),
	('C17741','2.3.1.218'),
	('C17742','2.3.1.217'),
	('C17742','2.3.1.219'),
	('C17743','2.3.1.211'),
	('C17743','2.3.1.219'),
	('C17759','2.4.1.126'),
	('C17759','2.4.1.120'),
	('C17883','4.1.1.102'),
	('C17945','2.7.7.93'),
	('C17946','2.7.8.23'),
	('C17952','2.3.1.183'),
	('C17953','1.14.13.106'),
	('C17954','1.14.13.106'),
	('C17955','1.14.13.106'),
	('C17966','5.4.99.46'),
	('C18000','6.1.2.2'),
	('C18001','6.1.2.2'),
	('C18004','2.4.2.49'),
	('C18004','3.1.3.88'),
	('C18005','4.3.2.6'),
	('C18005','2.3.2.19'),
	('C18006','6.2.1.39'),
	('C18006','4.1.1.95'),
	('C18007','4.1.1.95'),
	('C18007','6.2.1.39'),
	('C18008','1.14.14.13'),
	('C18008','6.2.1.39'),
	('C18009','1.14.14.13'),
	('C18009','2.3.2.19'),
	('C18011','1.13.11.67'),
	('C18012','1.14.21.7'),
	('C18012','2.5.1.123'),
	('C18013','1.14.21.7'),
	('C18014','1.14.21.7'),
	('C18015','1.1.1.295'),
	('C18016','1.1.1.295'),
	('C18017','1.1.1.296'),
	('C18018','1.1.1.296'),
	('C18019','1.1.1.297'),
	('C18020','1.1.1.297'),
	('C18021','3.1.1.82'),
	('C18021','1.14.15.17'),
	('C18022','1.3.7.12'),
	('C18022','1.14.15.17'),
	('C18023','1.14.13.103'),
	('C18023','2.5.1.70'),
	('C18024','1.14.13.103'),
	('C18024','2.5.1.71'),
	('C18025','1.14.13.104'),
	('C18026','6.4.1.3'),
	('C18026','5.1.99.1'),
	('C18026','1.3.1.85'),
	('C18026','4.1.1.94'),
	('C18027','1.14.13.105'),
	('C18028','1.1.1.122'),
	('C18032','2.6.1.110'),
	('C18032','4.2.1.164'),
	('C18033','2.1.1.324'),
	('C18033','2.6.1.110'),
	('C18034','2.1.1.324'),
	('C18038','1.14.14.29'),
	('C18040','1.1.1.213'),
	('C18040','1.3.1.22'),
	('C18041','1.1.1.149'),
	('C18041','1.1.1.213'),
	('C18042','1.1.1.149'),
	('C18042','1.1.1.213'),
	('C18043','2.8.2.14'),
	('C18043','3.1.6.2'),
	('C18043','2.8.2.2'),
	('C18044','2.8.2.2'),
	('C18044','3.1.6.2'),
	('C18044','2.8.2.14'),
	('C18045','1.14.14.23'),
	('C18046','2.1.3.10'),
	('C18046','4.3.99.2'),
	('C18047','4.3.99.2'),
	('C18047','2.1.3.10'),
	('C18048','2.1.3.11'),
	('C18049','2.3.1.184'),
	('C18049','3.5.1.97'),
	('C18049','3.1.1.81'),
	('C18050','2.4.1.246'),
	('C18050','3.1.3.79'),
	('C18051','2.5.1.67'),
	('C18052','2.5.1.69'),
	('C18053','2.5.1.71'),
	('C18054','1.3.99.24'),
	('C18054','2.6.1.86'),
	('C18055','2.7.1.162'),
	('C18059','2.7.8.38'),
	('C18059','2.7.7.67'),
	('C18060','2.7.1.162'),
	('C18060','2.7.1.157'),
	('C18060','2.7.7.83'),
	('C18061','3.1.1.81'),
	('C18062','1.14.20.2'),
	('C18062','2.1.1.241'),
	('C18063','3.1.1.82'),
	('C18064','3.1.1.82'),
	('C18066','3.1.1.83'),
	('C18067','3.1.1.83'),
	('C18068','3.1.3.79'),
	('C18075','1.1.1.62'),
	('C18076','3.1.4.52'),
	('C18091','1.13.12.16'),
	('C18094','5.4.99.9'),
	('C18094','5.4.99.30'),
	('C18096','5.3.1.6'),
	('C18098','1.3.7.12'),
	('C18131','2.5.1.93'),
	('C18132','1.14.13.116'),
	('C18136','2.7.7.46'),
	('C18151','1.17.7.2'),
	('C18151','1.1.1.294'),
	('C18152','1.3.7.15'),
	('C18152','4.2.1.165'),
	('C18153','4.2.1.165'),
	('C18153','1.1.1.396'),
	('C18153','1.3.7.15'),
	('C18154','4.2.1.165'),
	('C18154','1.3.7.15'),
	('C18155','1.1.1.396'),
	('C18167','1.1.1.331'),
	('C18167','1.23.1.2'),
	('C18170','1.5.3.13'),
	('C18170','1.5.3.17'),
	('C18172','4.1.1.96'),
	('C18172','1.5.1.43'),
	('C18174','1.5.1.43'),
	('C18174','4.1.1.96'),
	('C18195','1.13.11.65'),
	('C18196','1.13.11.65'),
	('C18211','4.2.3.44'),
	('C18217','2.3.1.188'),
	('C18218','2.3.1.188'),
	('C18223','4.2.3.33'),
	('C18224','1.14.13.144'),
	('C18224','4.2.3.34'),
	('C18225','1.14.13.144'),
	('C18225','4.2.3.35'),
	('C18226','4.2.3.28'),
	('C18226','1.14.13.145'),
	('C18228','4.2.3.30'),
	('C18229','4.2.3.43'),
	('C18231','1.14.15.18'),
	('C18231','1.14.15.16'),
	('C18232','1.13.11.9'),
	('C18232','3.5.1.106'),
	('C18233','1.1.2.7'),
	('C18234','1.1.2.7'),
	('C18235','1.1.1.306'),
	('C18237','2.10.1.1'),
	('C18239','4.6.1.17'),
	('C18239','2.8.1.12'),
	('C18240','1.13.11.1'),
	('C18241','1.13.11.1'),
	('C18241','5.5.1.7'),
	('C18242','5.5.1.7'),
	('C18242','3.1.1.45'),
	('C18243','3.1.1.45'),
	('C18243','1.3.1.32'),
	('C18244','1.3.1.32'),
	('C18245','4.2.3.39'),
	('C18246','1.14.13.25'),
	('C18248','1.14.99.39'),
	('C18249','1.3.1.29'),
	('C18250','1.3.1.29'),
	('C18276','1.14.12.12'),
	('C18276','1.3.1.29'),
	('C18278','1.3.1.29'),
	('C18297','1.14.13.38'),
	('C18298','1.14.13.38'),
	('C18303','5.5.1.7'),
	('C18304','5.5.1.7'),
	('C18304','3.1.1.45'),
	('C18305','1.3.1.32'),
	('C18305','3.1.1.45'),
	('C18306','1.3.1.32'),
	('C18307','1.3.1.32'),
	('C18308','5.5.1.7'),
	('C18309','5.5.1.7'),
	('C18309','3.1.1.45'),
	('C18310','3.1.1.45'),
	('C18315','1.14.13.210'),
	('C18315','1.14.12.24'),
	('C18316','1.14.13.210'),
	('C18321','2.5.1.86'),
	('C18323','5.4.1.3'),
	('C18323','4.2.1.153'),
	('C18324','5.4.99.63'),
	('C18324','1.3.8.12'),
	('C18325','2.3.1.64'),
	('C18337','2.3.1.235'),
	('C18345','1.13.11.8'),
	('C18351','5.4.4.3'),
	('C18448','2.1.1.165'),
	('C18472','4.2.1.145'),
	('C18473','1.14.11.41'),
	('C18473','4.2.1.145'),
	('C18608','1.14.11.44'),
	('C18629','1.13.12.22'),
	('C18630','5.5.1.26'),
	('C18634','3.1.1.95'),
	('C18634','2.4.1.327'),
	('C18634','2.4.1.326'),
	('C18635','2.4.1.327'),
	('C18636','2.4.1.327'),
	('C18637','1.1.3.45'),
	('C18638','1.1.3.45'),
	('C18638','1.3.3.14'),
	('C18639','1.3.3.14'),
	('C18640','3.1.1.95'),
	('C18641','3.1.1.95'),
	('C18643','2.4.1.326'),
	('C18672','4.99.1.2'),
	('C18796','2.4.1.63'),
	('C18796','4.1.2.46'),
	('C18796','3.2.1.21'),
	('C18797','4.1.2.47'),
	('C18799','2.1.1.245'),
	('C18802','6.3.2.33'),
	('C18802','2.1.1.245'),
	('C18846','2.1.1.237'),
	('C18872','2.1.1.96'),
	('C18902','1.8.1.9'),
	('C18910','1.1.1.302'),
	('C18911','6.3.2.36'),
	('C18911','2.7.1.169'),
	('C19033','4.4.1.27'),
	('C19078','2.7.7.72'),
	('C19079','1.14.13.105'),
	('C19080','2.7.7.72'),
	('C19081','1.14.13.107'),
	('C19081','3.3.2.8'),
	('C19082','3.3.2.8'),
	('C19082','1.1.1.297'),
	('C19083','1.14.13.105'),
	('C19083','1.1.1.297'),
	('C19084','1.14.13.105'),
	('C19085','2.7.7.72'),
	('C19151','6.3.2.32'),
	('C19152','6.3.2.34'),
	('C19152','6.3.2.31'),
	('C19153','6.3.2.31'),
	('C19153','2.7.8.28'),
	('C19154','2.7.8.28'),
	('C19154','2.5.1.77'),
	('C19155','2.7.8.28'),
	('C19155','2.7.7.68'),
	('C19156','2.7.7.68'),
	('C19241','3.1.1.87'),
	('C19418','1.11.2.3'),
	('C19488','1.14.14.1'),
	('C19489','3.3.2.9'),
	('C19489','1.14.14.1'),
	('C19490','1.14.14.1'),
	('C19490','3.3.2.9'),
	('C19491','1.14.13.118'),
	('C19491','1.14.13.117'),
	('C19559','1.14.14.1'),
	('C19561','2.8.2.14'),
	('C19562','2.8.2.14'),
	('C19563','1.14.14.1'),
	('C19566','1.14.14.1'),
	('C19567','1.4.3.24'),
	('C19567','1.2.1.83'),
	('C19569','1.2.1.83'),
	('C19574','2.4.1.17'),
	('C19574','1.3.1.20'),
	('C19574','1.1.1.184'),
	('C19574','1.1.1.146'),
	('C19574','1.14.14.1'),
	('C19577','1.14.14.1'),
	('C19580','1.14.14.1'),
	('C19585','1.14.14.1'),
	('C19586','1.14.14.1'),
	('C19586','2.5.1.18'),
	('C19586','3.3.2.9'),
	('C19588','3.3.2.9'),
	('C19594','1.14.14.1'),
	('C19595','1.14.14.1'),
	('C19604','3.3.2.9'),
	('C19604','1.14.14.1'),
	('C19605','2.4.1.17'),
	('C19606','2.4.1.17'),
	('C19607','3.3.2.9'),
	('C19610','1.11.1.13'),
	('C19611','1.11.1.13'),
	('C19613','3.1.1.59'),
	('C19616','1.11.2.3'),
	('C19619','4.2.3.77'),
	('C19620','1.11.2.3'),
	('C19631','1.14.13.163'),
	('C19645','2.4.1.17'),
	('C19646','2.4.1.17'),
	('C19669','2.5.1.79'),
	('C19670','3.5.1.99'),
	('C19671','1.4.9.1'),
	('C19672','1.4.9.1'),
	('C19673','2.3.1.41'),
	('C19673','2.3.1.179'),
	('C19673','2.1.1.197'),
	('C19674','1.1.1.301'),
	('C19675','1.1.1.308'),
	('C19676','1.14.13.123'),
	('C19676','1.1.1.314'),
	('C19677','1.1.1.314'),
	('C19678','1.1.1.314'),
	('C19678','1.14.13.120'),
	('C19679','1.1.99.32'),
	('C19680','1.1.99.36'),
	('C19680','1.1.99.37'),
	('C19681','1.1.99.36'),
	('C19681','1.1.99.37'),
	('C19682','1.2.1.77'),
	('C19683','4.1.2.44'),
	('C19683','1.2.1.77'),
	('C19684','4.1.2.44'),
	('C19685','1.2.1.81'),
	('C19686','1.3.99.24'),
	('C19687','1.4.3.23'),
	('C19687','1.14.19.9'),
	('C19688','1.21.98.2'),
	('C19688','1.4.3.23'),
	('C19689','1.8.1.16'),
	('C19689','1.11.1.17'),
	('C19690','1.8.1.16'),
	('C19690','1.11.1.17'),
	('C19691','1.8.3.6'),
	('C19691','1.8.3.5'),
	('C19692','1.12.98.4'),
	('C19692','1.8.1.19'),
	('C19692','1.8.5.4'),
	('C19693','1.11.1.19'),
	('C19694','6.1.2.1'),
	('C19695','6.3.1.12'),
	('C19696','6.3.1.12'),
	('C19697','1.11.2.2'),
	('C19698','1.21.98.2'),
	('C19698','1.13.12.17'),
	('C19699','1.13.12.17'),
	('C19699','4.3.3.5'),
	('C19700','4.3.3.5'),
	('C19700','2.1.1.164'),
	('C19701','2.1.1.164'),
	('C19702','6.3.1.13'),
	('C19702','3.5.1.115'),
	('C19702','3.5.1.103'),
	('C19703','6.3.1.13'),
	('C19703','2.3.1.189'),
	('C19704','1.13.12.18'),
	('C19705','1.13.12.18'),
	('C19706','1.14.11.28'),
	('C19707','1.14.13.115'),
	('C19708','4.2.3.61'),
	('C19708','1.14.13.119'),
	('C19709','3.4.15.6'),
	('C19709','6.3.2.29'),
	('C19710','6.3.2.29'),
	('C19710','6.3.2.30'),
	('C19711','1.14.13.121'),
	('C19712','1.14.13.124'),
	('C19713','3.4.15.6'),
	('C19713','6.3.2.30'),
	('C19714','1.14.13.124'),
	('C19715','1.14.13.124'),
	('C19716','1.14.13.125'),
	('C19717','1.14.13.125'),
	('C19719','6.3.2.35'),
	('C19720','6.3.2.37'),
	('C19721','1.14.13.130'),
	('C19722','6.3.4.22'),
	('C19722','6.3.4.19'),
	('C19723','6.3.4.19'),
	('C19724','6.3.5.11'),
	('C19725','2.4.1.335'),
	('C19725','5.1.3.23'),
	('C19725','2.3.1.201'),
	('C19726','1.14.15.8'),
	('C19727','1.14.21.8'),
	('C19728','1.13.11.75'),
	('C19728','1.13.11.82'),
	('C19729','1.13.11.75'),
	('C19730','1.14.99.42'),
	('C19731','1.14.99.42'),
	('C19732','1.14.99.43'),
	('C19733','1.14.99.43'),
	('C19734','4.2.3.72'),
	('C19735','4.2.3.54'),
	('C19736','4.2.3.82'),
	('C19736','4.2.3.50'),
	('C19737','4.2.3.53'),
	('C19738','4.2.3.62'),
	('C19739','2.1.1.169'),
	('C19739','2.1.1.175'),
	('C19740','4.2.3.69'),
	('C19741','4.2.3.63'),
	('C19742','4.2.3.76'),
	('C19743','3.1.7.7'),
	('C19744','4.2.3.64'),
	('C19745','5.1.3.23'),
	('C19746','4.2.3.49'),
	('C19747','4.2.3.60'),
	('C19748','4.2.3.59'),
	('C19749','4.2.3.38'),
	('C19750','2.3.1.177'),
	('C19751','5.5.1.17'),
	('C19751','4.2.3.55'),
	('C19752','5.5.1.17'),
	('C19753','4.2.3.67'),
	('C19754','4.2.3.67'),
	('C19755','4.2.3.70'),
	('C19756','4.2.3.74'),
	('C19757','2.3.1.195'),
	('C19758','2.4.1.247'),
	('C19759','1.3.5.6'),
	('C19760','4.2.3.50'),
	('C19760','4.2.3.54'),
	('C19760','4.2.3.142'),
	('C19760','4.2.3.53'),
	('C19760','2.5.1.92'),
	('C19761','2.4.1.250'),
	('C19762','2.4.1.254'),
	('C19763','2.4.1.262'),
	('C19763','2.4.1.272'),
	('C19764','1.3.5.5'),
	('C19764','5.2.1.12'),
	('C19765','1.3.5.5'),
	('C19766','2.5.1.63'),
	('C19767','2.5.1.80'),
	('C19768','2.5.1.94'),
	('C19769','2.7.1.170'),
	('C19770','2.7.1.170'),
	('C19771','2.7.7.66'),
	('C19771','2.7.7.61'),
	('C19771','2.4.2.52'),
	('C19772','2.7.8.31'),
	('C19773','2.7.8.32'),
	('C19774','2.7.8.32'),
	('C19775','3.1.2.29'),
	('C19776','3.1.3.81'),
	('C19777','3.5.1.97'),
	('C19778','3.5.1.100'),
	('C19779','3.5.1.100'),
	('C19780','3.5.1.100'),
	('C19781','3.5.1.101'),
	('C19782','3.5.1.101'),
	('C19783','3.5.1.101'),
	('C19784','3.5.1.103'),
	('C19785','3.5.2.19'),
	('C19786','3.5.2.19'),
	('C19787','3.5.4.31'),
	('C19787','2.4.2.44'),
	('C19788','3.5.99.8'),
	('C19789','1.13.11.64'),
	('C19789','3.5.99.8'),
	('C19790','1.5.1.36'),
	('C19791','2.4.1.270'),
	('C19791','2.4.1.266'),
	('C19791','3.1.3.85'),
	('C19792','2.4.1.268'),
	('C19792','3.1.3.85'),
	('C19793','2.4.1.270'),
	('C19794','2.7.7.74'),
	('C19794','2.7.8.34'),
	('C19795','2.1.1.210'),
	('C19795','1.3.99.27'),
	('C19795','4.2.1.131'),
	('C19797','1.3.8.2'),
	('C19797','1.14.99.44'),
	('C19798','1.14.99.44'),
	('C19799','2.7.8.34'),
	('C19800','3.1.1.88'),
	('C19801','5.4.99.36'),
	('C19802','2.4.1.255'),
	('C19802','3.2.1.169'),
	('C19803','2.4.1.255'),
	('C19803','2.7.1.180'),
	('C19803','3.2.1.169'),
	('C19804','2.4.1.255'),
	('C19804','3.2.1.169'),
	('C19805','3.1.1.87'),
	('C19806','3.1.1.87'),
	('C19807','2.1.1.169'),
	('C19809','3.5.1.101'),
	('C19810','4.2.3.31'),
	('C19811','1.13.11.51'),
	('C19812','1.13.11.51'),
	('C19813','4.3.1.27'),
	('C19813','4.1.3.41'),
	('C19814','4.2.3.36'),
	('C19815','5.5.1.15'),
	('C19815','4.2.3.36'),
	('C19816','4.2.3.41'),
	('C19817','4.2.3.45'),
	('C19818','4.2.3.51'),
	('C19819','5.4.99.33'),
	('C19820','5.4.99.32'),
	('C19821','4.2.1.110'),
	('C19822','5.3.2.7'),
	('C19822','4.2.1.111'),
	('C19822','4.2.1.110'),
	('C19823','4.2.1.115'),
	('C19823','2.6.1.92'),
	('C19823','1.1.1.367'),
	('C19824','5.1.99.5'),
	('C19825','5.1.99.5'),
	('C19826','5.3.2.7'),
	('C19827','4.2.1.121'),
	('C19828','4.2.1.124'),
	('C19829','4.2.1.125'),
	('C19829','1.14.13.183'),
	('C19830','5.3.3.17'),
	('C19831','5.3.3.17'),
	('C19832','5.4.99.31'),
	('C19833','5.4.99.34'),
	('C19834','5.4.99.37'),
	('C19835','5.4.99.38'),
	('C19836','3.1.7.9'),
	('C19836','5.5.1.16'),
	('C19836','3.1.7.8'),
	('C19837','4.1.1.92'),
	('C19838','4.1.3.41'),
	('C19839','1.14.99.44'),
	('C19840','1.3.8.2'),
	('C19841','1.3.8.2'),
	('C19842','3.5.1.104'),
	('C19843','3.4.15.6'),
	('C19844','3.1.1.88'),
	('C19845','2.3.1.47'),
	('C19845','3.1.1.85'),
	('C19845','1.14.15.12'),
	('C19846','3.1.1.85'),
	('C19846','1.3.1.10'),
	('C19847','2.5.1.74'),
	('C19847','2.1.1.163'),
	('C19848','2.7.7.75'),
	('C19848','2.10.1.1'),
	('C19850','2.7.1.163'),
	('C19852','2.5.1.89'),
	('C19853','2.5.1.88'),
	('C19854','2.4.1.251'),
	('C19854','2.4.1.264'),
	('C19855','2.4.1.252'),
	('C19855','2.4.1.264'),
	('C19856','2.4.1.252'),
	('C19857','2.5.1.95'),
	('C19857','2.4.1.251'),
	('C19858','2.1.1.201'),
	('C19859','2.1.1.201'),
	('C19861','1.11.2.4'),
	('C19862','1.1.5.7'),
	('C19863','4.2.1.128'),
	('C19864','3.1.1.88'),
	('C19865','2.4.1.272'),
	('C19865','2.4.1.273'),
	('C19867','2.4.1.330'),
	('C19867','2.4.1.271'),
	('C19868','2.4.1.330'),
	('C19868','2.4.1.271'),
	('C19869','2.4.1.271'),
	('C19869','2.4.1.330'),
	('C19870','2.5.1.95'),
	('C19875','2.4.99.14'),
	('C19875','2.4.99.15'),
	('C19876','2.4.99.15'),
	('C19877','2.7.1.166'),
	('C19878','5.3.1.28'),
	('C19878','2.7.1.168'),
	('C19879','3.1.3.83'),
	('C19879','2.7.1.168'),
	('C19880','3.1.3.83'),
	('C19880','2.7.7.71'),
	('C19881','2.7.7.71'),
	('C19882','5.3.1.28'),
	('C19883','2.4.2.43'),
	('C19884','2.4.2.43'),
	('C19885','6.3.2.43'),
	('C19886','6.3.2.43'),
	('C19890','2.4.2.43'),
	('C19891','1.1.1.369'),
	('C19892','1.13.11.59'),
	('C19892','1.2.1.82'),
	('C19893','4.2.3.84'),
	('C19894','4.2.1.131'),
	('C19895','2.1.1.231'),
	('C19896','2.1.1.231'),
	('C19907','4.1.1.93'),
	('C19908','4.2.3.78'),
	('C19909','5.1.3.24'),
	('C19910','5.1.3.24'),
	('C19911','1.14.14.10'),
	('C19918','5.4.99.47'),
	('C19931','1.1.1.317'),
	('C19932','1.1.1.317'),
	('C19933','1.1.3.42'),
	('C19934','5.5.1.20'),
	('C19934','1.1.3.42'),
	('C19935','1.7.1.14'),
	('C19936','1.13.11.61'),
	('C19937','1.13.11.62'),
	('C19938','1.14.13.133'),
	('C19939','1.14.13.133'),
	('C19942','1.14.13.134'),
	('C19943','1.14.13.173'),
	('C19943','1.14.13.134'),
	('C19944','1.14.14.12'),
	('C19945','1.2.1.91'),
	('C19945','2.3.1.223'),
	('C19946','3.3.2.12'),
	('C19946','1.2.1.91'),
	('C19947','2.3.1.197'),
	('C19947','2.1.1.236'),
	('C19947','2.6.1.90'),
	('C19948','2.1.1.236'),
	('C19960','2.6.1.90'),
	('C19960','5.3.2.3'),
	('C19961','2.6.1.92'),
	('C19961','2.3.1.202'),
	('C19962','3.1.1.90'),
	('C19963','3.1.7.8'),
	('C19964','3.1.7.9'),
	('C19965','3.2.1.179'),
	('C19966','3.2.1.179'),
	('C19967','3.6.1.55'),
	('C19968','3.6.1.58'),
	('C19968','3.6.1.55'),
	('C19969','3.6.1.56'),
	('C19970','3.6.1.56'),
	('C19971','2.3.1.202'),
	('C19971','3.6.1.57'),
	('C19972','2.5.1.97'),
	('C19972','3.6.1.57'),
	('C19973','4.2.1.138'),
	('C19973','4.2.3.89'),
	('C19974','4.2.1.138'),
	('C19975','5.3.3.18'),
	('C19975','3.3.2.12'),
	('C20045','1.14.11.38'),
	('C20045','2.5.1.107'),
	('C20062','5.3.3.18'),
	('C20062','1.14.13.149'),
	('C20082','2.5.1.97'),
	('C20082','2.7.7.81'),
	('C20083','2.7.7.81'),
	('C20119','2.5.1.58'),
	('C20120','3.4.24.84'),
	('C20120','2.5.1.58'),
	('C20125','1.14.14.21'),
	('C20143','1.14.13.141'),
	('C20144','1.3.99.4'),
	('C20144','1.14.13.142'),
	('C20145','1.14.13.143'),
	('C20145','4.2.3.103'),
	('C20146','1.14.13.143'),
	('C20147','1.14.13.144'),
	('C20148','1.14.13.144'),
	('C20149','1.14.13.144'),
	('C20150','1.14.13.145'),
	('C20151','1.14.13.146'),
	('C20152','1.14.13.147'),
	('C20153','1.14.13.147'),
	('C20154','2.1.1.240'),
	('C20155','3.5.4.32'),
	('C20156','2.3.1.197'),
	('C20158','3.1.7.10'),
	('C20159','4.2.3.86'),
	('C20161','4.2.3.87'),
	('C20162','4.2.3.88'),
	('C20163','4.2.3.90'),
	('C20172','4.2.3.91'),
	('C20173','4.2.3.92'),
	('C20174','4.2.3.93'),
	('C20175','4.2.3.100'),
	('C20176','3.6.1.58'),
	('C20177','4.2.3.101'),
	('C20178','4.2.3.102'),
	('C20179','4.2.3.94'),
	('C20180','4.2.3.95'),
	('C20181','4.2.3.96'),
	('C20182','4.2.3.97'),
	('C20183','3.6.1.62'),
	('C20183','3.1.3.91'),
	('C20184','4.2.3.98'),
	('C20185','4.2.3.99'),
	('C20186','5.4.4.5'),
	('C20187','5.4.99.48'),
	('C20188','5.4.99.49'),
	('C20189','5.4.99.51'),
	('C20190','3.6.1.61'),
	('C20190','3.6.1.60'),
	('C20191','5.4.99.52'),
	('C20192','5.4.99.53'),
	('C20193','5.4.99.54'),
	('C20194','5.4.99.55'),
	('C20195','5.4.99.56'),
	('C20198','3.6.1.60'),
	('C20199','3.7.1.17'),
	('C20199','6.2.1.41'),
	('C20200','5.4.99.57'),
	('C20201','5.5.1.20'),
	('C20208','1.14.13.144'),
	('C20221','1.14.13.151'),
	('C20222','1.1.1.324'),
	('C20223','1.1.1.324'),
	('C20224','1.1.1.318'),
	('C20225','1.1.1.319'),
	('C20225','1.1.1.318'),
	('C20226','1.1.1.321'),
	('C20226','1.1.1.320'),
	('C20227','1.1.1.320'),
	('C20228','1.1.1.321'),
	('C20229','1.1.1.326'),
	('C20229','1.14.13.150'),
	('C20230','4.2.3.110'),
	('C20230','1.14.13.153'),
	('C20231','1.14.99.46'),
	('C20231','3.5.1.110'),
	('C20232','1.14.99.46'),
	('C20232','3.5.1.110'),
	('C20233','1.17.2.2'),
	('C20234','2.1.1.243'),
	('C20235','2.1.1.255'),
	('C20235','4.2.3.118'),
	('C20236','5.1.3.11'),
	('C20236','2.4.1.281'),
	('C20237','2.7.1.175'),
	('C20237','2.4.99.16'),
	('C20238','5.1.99.1'),
	('C20238','5.4.99.63'),
	('C20239','4.1.2.50'),
	('C20239','4.3.99.3'),
	('C20240','3.7.1.17'),
	('C20240','4.2.1.132'),
	('C20241','4.2.3.105'),
	('C20242','4.2.3.109'),
	('C20243','4.2.3.118'),
	('C20244','4.2.3.122'),
	('C20245','2.7.1.176'),
	('C20246','2.8.1.10'),
	('C20246','5.3.99.10'),
	('C20246','2.5.1.3'),
	('C20247','2.5.1.3'),
	('C20247','5.3.99.10'),
	('C20248','6.3.4.20'),
	('C20248','4.3.99.3'),
	('C20249','3.5.1.110'),
	('C20250','3.5.1.110'),
	('C20251','5.3.99.11'),
	('C20251','1.1.1.369'),
	('C20252','1.1.1.51'),
	('C20252','5.3.3.1'),
	('C20253','3.5.1.110'),
	('C20254','3.5.1.110'),
	('C20258','4.3.3.7'),
	('C20258','1.17.1.8'),
	('C20260','1.1.1.323'),
	('C20261','1.1.1.323'),
	('C20262','1.1.1.326'),
	('C20263','1.1.1.325'),
	('C20264','1.1.1.325'),
	('C20265','4.1.1.90'),
	('C20265','1.17.4.4'),
	('C20267','3.5.99.2'),
	('C20270','4.2.3.141'),
	('C20270','4.2.1.133'),
	('C20270','4.2.3.140'),
	('C20271','6.2.1.38'),
	('C20272','4.2.3.125'),
	('C20273','4.2.3.126'),
	('C20274','4.2.3.127'),
	('C20275','4.2.3.129'),
	('C20276','4.2.3.130'),
	('C20276','4.2.1.137'),
	('C20277','5.4.99.58'),
	('C20292','2.1.1.252'),
	('C20307','1.14.13.158'),
	('C20308','1.3.1.92'),
	('C20308','1.14.13.158'),
	('C20309','1.14.13.158'),
	('C20310','1.14.13.118'),
	('C20310','1.14.13.117'),
	('C20311','1.14.13.118'),
	('C20311','1.14.13.117'),
	('C20313','1.14.13.117'),
	('C20313','1.14.13.118'),
	('C20314','1.14.13.117'),
	('C20314','1.14.13.118'),
	('C20320','3.7.1.18'),
	('C20321','1.14.13.160'),
	('C20322','1.14.13.161'),
	('C20323','1.14.15.10'),
	('C20324','3.7.1.18'),
	('C20325','1.3.1.92'),
	('C20326','1.14.13.157'),
	('C20328','1.1.1.240'),
	('C20329','1.14.13.109'),
	('C20330','1.14.11.34'),
	('C20333','6.3.2.39'),
	('C20333','6.3.2.38'),
	('C20345','4.1.1.99'),
	('C20345','2.7.4.26'),
	('C20350','2.6.1.94'),
	('C20350','2.4.1.301'),
	('C20351','2.6.1.94'),
	('C20352','2.4.2.45'),
	('C20353','2.4.1.301'),
	('C20353','2.4.1.284'),
	('C20354','2.4.1.282'),
	('C20357','2.3.1.203'),
	('C20357','2.7.8.36'),
	('C20357','3.2.1.184'),
	('C20359','2.3.1.201'),
	('C20359','2.6.1.98'),
	('C20361','1.4.3.24'),
	('C20366','3.1.1.91'),
	('C20366','1.13.11.64'),
	('C20367','1.13.11.64'),
	('C20368','1.1.98.3'),
	('C20369','1.1.1.333'),
	('C20369','1.1.98.3'),
	('C20370','1.1.1.333'),
	('C20371','1.1.1.334'),
	('C20372','2.3.1.179'),
	('C20372','2.3.1.41'),
	('C20372','1.1.1.100'),
	('C20373','1.1.1.100'),
	('C20373','4.2.1.59'),
	('C20374','1.3.1.10'),
	('C20374','4.2.1.59'),
	('C20375','2.3.1.41'),
	('C20375','1.3.1.10'),
	('C20375','2.3.1.179'),
	('C20376','1.1.1.100'),
	('C20376','2.3.1.41'),
	('C20376','2.3.1.179'),
	('C20377','1.1.1.100'),
	('C20377','4.2.1.59'),
	('C20378','4.2.1.59'),
	('C20378','1.3.1.10'),
	('C20379','1.1.1.332'),
	('C20380','3.1.1.93'),
	('C20381','1.1.1.328'),
	('C20382','3.5.99.9'),
	('C20383','3.1.1.93'),
	('C20390','2.7.8.35'),
	('C20390','2.4.1.289'),
	('C20394','1.14.13.209'),
	('C20394','2.3.1.208'),
	('C20395','1.1.1.335'),
	('C20395','2.6.1.98'),
	('C20396','1.13.11.73'),
	('C20396','2.7.8.37'),
	('C20397','1.14.11.36'),
	('C20397','1.14.19.8'),
	('C20398','1.14.11.36'),
	('C20399','1.14.13.170'),
	('C20399','1.14.11.36'),
	('C20400','1.14.13.171'),
	('C20400','1.14.13.170'),
	('C20400','1.1.1.340'),
	('C20402','1.14.13.171'),
	('C20403','1.14.11.35'),
	('C20403','1.1.1.340'),
	('C20404','1.14.11.35'),
	('C20404','1.14.15.11'),
	('C20405','1.14.15.11'),
	('C20406','1.21.3.8'),
	('C20406','2.5.1.102'),
	('C20407','1.14.19.8'),
	('C20408','1.5.1.44'),
	('C20409','1.5.1.44'),
	('C20410','2.1.1.261'),
	('C20411','2.1.1.262'),
	('C20412','2.1.1.262'),
	('C20413','2.3.1.206'),
	('C20413','4.4.1.26'),
	('C20414','2.3.1.208'),
	('C20415','2.3.1.210'),
	('C20415','2.4.1.325'),
	('C20416','2.4.1.289'),
	('C20417','2.5.1.102'),
	('C20417','4.4.1.26'),
	('C20418','2.7.7.82'),
	('C20418','2.5.1.101'),
	('C20419','2.7.7.82'),
	('C20420','2.7.8.36'),
	('C20421','2.7.8.36'),
	('C20421','2.4.1.290'),
	('C20422','2.7.8.37'),
	('C20422','3.6.1.63'),
	('C20423','4.7.1.1'),
	('C20423','3.6.1.63'),
	('C20424','2.5.1.101'),
	('C20424','3.2.1.184'),
	('C20427','2.4.1.290'),
	('C20430','1.14.99.47'),
	('C20431','1.14.99.47'),
	('C20432','2.1.1.263'),
	('C20432','1.3.1.97'),
	('C20433','2.1.1.263'),
	('C20434','2.1.1.263'),
	('C20435','2.1.1.263'),
	('C20436','2.3.1.205'),
	('C20436','2.5.1.100'),
	('C20437','2.3.1.205'),
	('C20438','2.5.1.100'),
	('C20440','4.7.1.1'),
	('C20440','3.1.4.55'),
	('C20440','3.1.4.57'),
	('C20444','2.1.1.109'),
	('C20445','2.1.1.110'),
	('C20445','2.1.1.109'),
	('C20446','2.4.2.29'),
	('C20449','1.1.3.47'),
	('C20450','1.1.3.47'),
	('C20451','3.5.4.33'),
	('C20452','1.1.1.349'),
	('C20452','1.13.12.20'),
	('C20453','2.3.1.221'),
	('C20453','1.13.12.20'),
	('C20454','1.23.1.3'),
	('C20454','1.23.1.4'),
	('C20455','1.23.1.3'),
	('C20456','1.23.1.4'),
	('C20457','1.5.1.46'),
	('C20458','3.5.4.34'),
	('C20459','3.5.4.34'),
	('C20460','2.3.1.213'),
	('C20461','2.3.1.215'),
	('C20462','2.3.1.216'),
	('C20463','2.4.2.1'),
	('C20464','1.1.1.319'),
	('C20464','2.1.1.279'),
	('C20465','1.1.1.319'),
	('C20465','1.1.1.318'),
	('C20466','2.7.8.38'),
	('C20467','2.4.1.295'),
	('C20467','2.4.2.51'),
	('C20468','2.4.2.50'),
	('C20469','2.4.1.300'),
	('C20470','2.4.1.300'),
	('C20471','2.4.1.297'),
	('C20472','2.4.1.296'),
	('C20473','2.4.1.296'),
	('C20474','2.4.1.295'),
	('C20475','4.2.1.137'),
	('C20476','4.2.3.135'),
	('C20477','4.2.3.136'),
	('C20478','4.2.3.137'),
	('C20479','4.2.3.138'),
	('C20480','4.2.3.139'),
	('C20481','4.2.3.140'),
	('C20482','5.1.99.6'),
	('C20483','5.1.99.6'),
	('C20484','1.13.11.68'),
	('C20484','5.2.1.14'),
	('C20485','4.1.3.16'),
	('C20485','4.1.3.42'),
	('C20486','4.2.3.142'),
	('C20487','5.4.3.10'),
	('C20488','5.4.3.11'),
	('C20489','2.4.1.295'),
	('C20489','2.4.2.51'),
	('C20490','2.4.2.51'),
	('C20490','2.4.1.295'),
	('C20491','2.4.1.295'),
	('C20491','2.4.2.51'),
	('C20492','2.4.1.295'),
	('C20493','2.4.1.295'),
	('C20494','2.4.1.295'),
	('C20495','2.4.1.300'),
	('C20496','2.4.1.300'),
	('C20497','2.4.1.180'),
	('C20497','2.4.1.325'),
	('C20498','2.4.1.325'),
	('C20499','1.1.1.349'),
	('C20499','1.14.13.174'),
	('C20500','1.1.1.352'),
	('C20500','1.14.13.174'),
	('C20501','1.14.13.174'),
	('C20501','1.1.1.352'),
	('C20502','1.1.1.352'),
	('C20502','4.2.1.142'),
	('C20503','1.1.1.353'),
	('C20504','1.1.1.353'),
	('C20505','3.1.1.94'),
	('C20505','1.1.1.353'),
	('C20506','1.1.1.353'),
	('C20506','3.1.1.94'),
	('C20507','1.1.1.353'),
	('C20507','4.2.1.143'),
	('C20507','3.1.1.94'),
	('C20508','1.1.1.353'),
	('C20508','3.1.1.94'),
	('C20509','1.14.11.37'),
	('C20509','1.1.1.355'),
	('C20510','1.14.13.173'),
	('C20511','1.14.13.173'),
	('C20512','2.5.1.106'),
	('C20512','1.14.13.176'),
	('C20513','1.14.13.176'),
	('C20513','2.1.1.293'),
	('C20514','1.14.15.13'),
	('C20514','2.3.2.22'),
	('C20515','1.14.15.13'),
	('C20516','1.14.21.9'),
	('C20516','2.3.2.21'),
	('C20517','1.14.21.9'),
	('C20518','1.3.7.11'),
	('C20518','1.3.1.101'),
	('C20519','1.3.3.13'),
	('C20519','2.3.2.20'),
	('C20520','1.3.3.13'),
	('C20521','1.3.3.13'),
	('C20522','1.3.99.33'),
	('C20559','2.5.1.105'),
	('C20559','2.4.2.54'),
	('C20560','2.5.1.104'),
	('C20560','3.5.3.24'),
	('C20562','2.5.1.105'),
	('C20563','2.5.1.106'),
	('C20563','2.5.1.109'),
	('C20564','2.5.1.107'),
	('C20565','2.7.7.85'),
	('C20566','3.1.4.56'),
	('C20567','3.1.4.56'),
	('C20567','3.5.4.39'),
	('C20568','3.2.1.185'),
	('C20568','3.2.1.187'),
	('C20569','3.2.1.185'),
	('C20574','4.2.1.142'),
	('C20575','4.2.1.143'),
	('C20576','4.2.3.143'),
	('C20577','4.2.99.22'),
	('C20578','4.2.99.22'),
	('C20579','6.3.2.40'),
	('C20580','6.3.4.22'),
	('C20581','4.2.1.114'),
	('C20582','4.2.1.114'),
	('C20589','4.3.1.29'),
	('C20589','2.7.1.203'),
	('C20602','1.14.11.40'),
	('C20603','1.14.11.40'),
	('C20604','1.14.13.177'),
	('C20604','1.14.21.10'),
	('C20605','2.5.1.110'),
	('C20605','1.14.13.177'),
	('C20607','1.14.21.10'),
	('C20607','2.1.1.293'),
	('C20608','1.3.1.103'),
	('C20609','1.3.1.103'),
	('C20612','1.1.1.356'),
	('C20613','1.1.1.356'),
	('C20614','2.4.1.301'),
	('C20616','1.1.1.359'),
	('C20617','2.4.1.303'),
	('C20618','2.4.1.304'),
	('C20619','2.4.1.305'),
	('C20620','2.4.1.306'),
	('C20620','2.7.8.40'),
	('C20620','5.1.3.26'),
	('C20621','2.4.1.306'),
	('C20621','2.4.1.307'),
	('C20622','2.4.1.307'),
	('C20622','2.4.1.308'),
	('C20623','1.10.3.13'),
	('C20624','1.10.3.13'),
	('C20625','2.4.1.309'),
	('C20625','2.4.1.308'),
	('C20626','2.4.1.309'),
	('C20627','2.7.8.38'),
	('C20627','2.7.8.39'),
	('C20628','2.7.8.38'),
	('C20629','2.1.1.284'),
	('C20629','6.3.1.15'),
	('C20630','1.14.11.38'),
	('C20630','2.5.1.110'),
	('C20631','1.14.11.39'),
	('C20632','2.1.1.275'),
	('C20633','2.1.1.276'),
	('C20634','2.3.1.232'),
	('C20634','2.1.1.277'),
	('C20635','2.1.1.278'),
	('C20636','2.5.1.109'),
	('C20638','2.6.1.102'),
	('C20638','2.3.1.227'),
	('C20639','5.1.1.19'),
	('C20639','2.6.99.3'),
	('C20640','2.7.7.86'),
	('C20641','2.3.1.234'),
	('C20641','2.7.7.87'),
	('C20642','2.7.8.39'),
	('C20643','1.14.13.182'),
	('C20643','2.3.1.230'),
	('C20644','4.1.2.56'),
	('C20644','4.1.99.20'),
	('C20645','2.1.1.273'),
	('C20646','2.6.1.107'),
	('C20646','2.6.1.57'),
	('C20646','2.1.1.281'),
	('C20647','2.1.1.286'),
	('C20647','2.1.1.287'),
	('C20648','2.1.1.181'),
	('C20648','2.1.1.184'),
	('C20648','2.1.1.183'),
	('C20648','2.1.1.182'),
	('C20648','2.1.1.286'),
	('C20648','2.1.1.287'),
	('C20649','1.14.11.42'),
	('C20649','2.1.1.282'),
	('C20649','2.1.1.290'),
	('C20651','6.3.3.5'),
	('C20651','5.1.1.19'),
	('C20652','2.5.1.114'),
	('C20652','2.1.1.282'),
	('C20655','1.1.1.359'),
	('C20659','2.1.1.290'),
	('C20659','2.3.1.231'),
	('C20660','2.3.1.231'),
	('C20661','1.14.11.42'),
	('C20663','2.5.1.108'),
	('C20664','5.5.1.22'),
	('C20666','1.14.99.48'),
	('C20667','1.14.99.48'),
	('C20668','1.1.1.361'),
	('C20668','2.6.1.104'),
	('C20669','1.13.11.76'),
	('C20670','1.13.11.76'),
	('C20672','2.3.1.227'),
	('C20673','2.3.1.228'),
	('C20674','3.1.3.91'),
	('C20675','1.3.8.1'),
	('C20676','1.3.8.1'),
	('C20677','2.3.1.229'),
	('C20678','3.2.1.186'),
	('C20679','3.6.3.55'),
	('C20680','4.2.1.146'),
	('C20680','4.1.2.54'),
	('C20680','1.1.1.389'),
	('C20680','5.5.1.25'),
	('C20681','4.2.3.144'),
	('C20682','5.4.99.59'),
	('C20683','6.2.1.20'),
	('C20683','1.2.1.80'),
	('C20683','1.14.15.12'),
	('C20684','6.1.2.2'),
	('C20685','1.14.11.44'),
	('C20686','1.14.11.43'),
	('C20687','1.14.11.43'),
	('C20688','4.1.3.44'),
	('C20689','3.1.1.95'),
	('C20690','2.7.4.21'),
	('C20690','2.7.4.24'),
	('C20691','4.1.3.44'),
	('C20691','2.5.1.114'),
	('C20692','1.13.11.69'),
	('C20692','1.13.11.68'),
	('C20693','1.13.11.69'),
	('C20694','1.13.11.69'),
	('C20695','1.13.11.70'),
	('C20695','1.13.11.71'),
	('C20696','1.13.11.82'),
	('C20696','1.13.11.70'),
	('C20697','1.13.11.70'),
	('C20699','6.1.2.2'),
	('C20702','1.13.11.77'),
	('C20703','1.13.11.77'),
	('C20704','1.13.11.77'),
	('C20705','3.2.1.187'),
	('C20706','3.2.1.187'),
	('C20707','3.2.1.188'),
	('C20709','3.2.1.190'),
	('C20710','3.3.2.13'),
	('C20711','4.2.3.131'),
	('C20711','1.14.13.190'),
	('C20712','2.1.1.291'),
	('C20713','2.4.1.314'),
	('C20714','2.3.1.230'),
	('C20715','1.14.13.184'),
	('C20715','1.14.13.183'),
	('C20716','1.14.13.184'),
	('C20717','1.3.1.105'),
	('C20718','1.3.1.105'),
	('C20719','2.4.1.310'),
	('C20720','2.4.1.311'),
	('C20720','2.4.1.310'),
	('C20720','2.4.1.322'),
	('C20721','2.4.1.311'),
	('C20722','2.4.1.312'),
	('C20723','2.4.1.313'),
	('C20723','2.4.1.312'),
	('C20724','4.2.3.79'),
	('C20725','2.4.1.314'),
	('C20726','2.4.2.55'),
	('C20727','2.4.2.56'),
	('C20728','2.5.1.113'),
	('C20729','2.5.1.113'),
	('C20730','2.7.1.180'),
	('C20732','3.5.1.115'),
	('C20734','2.4.1.313'),
	('C20735','3.5.1.114'),
	('C20737','2.5.1.116'),
	('C20737','2.1.1.295'),
	('C20737','5.5.1.24'),
	('C20738','2.1.1.295'),
	('C20738','5.5.1.24'),
	('C20739','1.14.13.185'),
	('C20740','1.14.13.185'),
	('C20741','1.14.13.185'),
	('C20742','2.4.99.20'),
	('C20744','1.6.3.5'),
	('C20745','1.6.3.5'),
	('C20746','4.1.3.46'),
	('C20746','2.8.3.20'),
	('C20747','2.8.3.20'),
	('C20748','2.8.3.21'),
	('C20748','4.2.1.149'),
	('C20749','2.8.3.21'),
	('C20750','4.2.1.149'),
	('C20750','2.8.3.21'),
	('C20751','2.3.1.234'),
	('C20751','2.8.4.5'),
	('C20752','2.8.4.5'),
	('C20753','2.8.4.3'),
	('C20754','2.8.4.5'),
	('C20755','2.8.4.3'),
	('C20756','2.8.4.4'),
	('C20757','2.8.4.4'),
	('C20758','2.8.4.4'),
	('C20759','2.8.2.36'),
	('C20760','1.14.13.186'),
	('C20761','2.7.1.181'),
	('C20762','2.1.1.294'),
	('C20762','2.7.1.181'),
	('C20763','2.1.1.294'),
	('C20764','2.7.1.182'),
	('C20765','1.14.13.187'),
	('C20766','1.14.13.187'),
	('C20767','1.14.13.187'),
	('C20768','1.1.1.367'),
	('C20768','5.1.3.28'),
	('C20770','2.1.1.300'),
	('C20771','2.1.1.300'),
	('C20772','4.2.1.151'),
	('C20772','2.5.1.120'),
	('C20773','2.5.1.120'),
	('C20773','3.2.2.30'),
	('C20773','3.5.4.40'),
	('C20774','5.1.3.28'),
	('C20775','6.3.1.17'),
	('C20776','3.4.17.21'),
	('C20776','6.3.2.42'),
	('C20781','1.1.1.401'),
	('C20782','1.14.14.11'),
	('C20782','5.3.99.7'),
	('C20783','1.14.13.227'),
	('C20787','1.3.1.5'),
	('C20788','1.8.4.1'),
	('C20789','2.4.1.323'),
	('C20790','2.4.1.324'),
	('C20791','2.1.1.9'),
	('C20796','2.1.1.182'),
	('C20796','2.1.1.183'),
	('C20796','2.1.1.184'),
	('C20797','1.1.1.373'),
	('C20798','4.1.2.57'),
	('C20798','1.1.1.373'),
	('C20799','1.10.3.15'),
	('C20800','2.1.1.304'),
	('C20800','1.11.2.5'),
	('C20801','1.11.2.5'),
	('C20802','1.14.11.45'),
	('C20803','2.3.1.236'),
	('C20803','1.14.13.189'),
	('C20804','4.2.3.80'),
	('C20805','1.14.13.189'),
	('C20805','2.1.1.302'),
	('C20806','1.14.13.194'),
	('C20807','1.14.16.7'),
	('C20808','1.5.1.48'),
	('C20809','1.5.1.48'),
	('C20810','1.14.14.15'),
	('C20811','4.2.3.81'),
	('C20825','2.8.2.11'),
	('C20829','5.3.1.31'),
	('C20829','1.1.1.390'),
	('C20830','5.3.1.31'),
	('C20830','2.7.1.184'),
	('C20831','4.1.2.57'),
	('C20831','2.7.1.184'),
	('C20832','4.2.1.152'),
	('C20832','5.4.4.7'),
	('C20833','4.2.1.152'),
	('C20834','4.2.3.146'),
	('C20835','5.1.3.29'),
	('C20836','5.1.3.29'),
	('C20837','5.4.4.7'),
	('C20838','6.2.1.41'),
	('C20839','1.14.13.221'),
	('C20840','6.2.1.42'),
	('C20841','6.2.1.43'),
	('C20841','2.1.1.303'),
	('C20842','6.2.1.43'),
	('C20843','6.3.1.18'),
	('C20844','4.3.1.9'),
	('C20845','4.3.1.9'),
	('C20846','3.5.2.1'),
	('C20846','3.5.1.95'),
	('C20847','2.7.1.185'),
	('C20847','2.7.1.186'),
	('C20848','2.7.1.186'),
	('C20849','1.1.1.374'),
	('C20850','1.14.13.195'),
	('C20850','1.14.13.196'),
	('C20851','3.1.2.31'),
	('C20851','1.14.13.197'),
	('C20852','1.14.13.197'),
	('C20853','1.14.13.197'),
	('C20853','1.14.13.198'),
	('C20854','2.3.1.238'),
	('C20854','1.14.13.198'),
	('C20855','1.14.13.199'),
	('C20856','2.3.1.237'),
	('C20856','1.14.99.49'),
	('C20857','2.1.1.303'),
	('C20857','1.14.99.49'),
	('C20858','2.1.1.297'),
	('C20858','2.1.1.298'),
	('C20859','2.8.2.11'),
	('C20859','2.4.1.45'),
	('C20860','2.4.1.315'),
	('C20861','5.1.3.11'),
	('C20861','2.4.1.319'),
	('C20862','2.1.1.296'),
	('C20863','3.6.1.62'),
	('C20864','2.7.7.88'),
	('C20864','2.7.7.6'),
	('C20870','6.2.1.44'),
	('C20871','2.1.1.42'),
	('C20872','2.1.1.42'),
	('C20876','2.3.1.199'),
	('C20876','1.3.1.93'),
	('C20877','1.1.1.330'),
	('C20877','2.3.1.199'),
	('C20878','1.1.1.330'),
	('C20878','4.2.1.134'),
	('C20879','1.3.1.93'),
	('C20879','4.2.1.134'),
	('C20887','2.4.1.320'),
	('C20888','2.4.1.321'),
	('C20889','5.4.1.4'),
	('C20889','1.1.1.203'),
	('C20890','1.1.1.203'),
	('C20891','2.5.1.119'),
	('C20891','2.5.1.118'),
	('C20892','2.5.1.118'),
	('C20893','2.5.1.119'),
	('C20894','1.14.99.42'),
	('C20895','2.6.1.107'),
	('C20895','2.6.1.57'),
	('C20896','5.4.1.4'),
	('C20896','5.5.1.27'),
	('C20897','2.7.8.20'),
	('C20899','1.1.3.47'),
	('C20900','1.1.3.47'),
	('C20901','1.1.3.47'),
	('C20902','1.2.1.92'),
	('C20903','5.5.1.25'),
	('C20903','1.2.1.92'),
	('C20904','3.5.99.10'),
	('C20905','3.5.99.10'),
	('C20907','2.8.2.33'),
	('C20908','2.8.2.35'),
	('C20908','4.2.2.20'),
	('C20908','4.2.2.19'),
	('C20908','4.2.2.21'),
	('C20908','2.8.2.33'),
	('C20909','2.8.2.33'),
	('C20922','4.2.3.148'),
	('C20923','4.2.3.149'),
	('C20924','4.2.3.151'),
	('C20925','6.3.2.45'),
	('C20926','2.5.1.131'),
	('C20926','6.3.4.24'),
	('C20933','2.3.1.242'),
	('C20935','2.7.7.84'),
	('C20936','2.7.7.84'),
	('C20937','1.7.3.6'),
	('C20938','1.11.1.19'),
	('C20939','1.11.1.19'),
	('C20940','1.1.1.385'),
	('C20941','6.3.2.49'),
	('C20941','1.1.1.385'),
	('C20942','6.3.2.49'),
	('C20943','1.14.14.31'),
	('C20943','1.1.1.386'),
	('C20944','1.1.1.386'),
	('C20945','1.14.13.201'),
	('C20946','1.14.13.201'),
	('C20947','1.14.19.10'),
	('C20953','5.3.3.19'),
	('C20953','4.1.1.100'),
	('C20954','2.6.1.108'),
	('C20954','4.2.3.153'),
	('C20955','4.2.1.155'),
	('C20956','4.2.3.152'),
	('C20957','5.1.1.20'),
	('C20957','3.4.14.13'),
	('C20958','5.1.1.20'),
	('C20959','2.7.1.189'),
	('C20959','5.3.1.32'),
	('C20960','2.3.1.245'),
	('C20960','5.3.1.32'),
	('C20961','6.3.2.46'),
	('C20962','6.3.2.47'),
	('C20963','6.3.2.47'),
	('C20964','6.3.2.47'),
	('C20965','6.3.2.47'),
	('C20966','6.3.2.47'),
	('C20967','6.3.2.47'),
	('C20968','4.2.1.155'),
	('C20969','6.3.5.5'),
	('C20974','2.1.1.305'),
	('C20974','2.4.1.331'),
	('C20975','2.1.1.305'),
	('C20975','2.1.1.306'),
	('C20976','2.1.1.307'),
	('C20976','2.1.1.306'),
	('C20977','2.1.1.307'),
	('C20980','2.1.1.302'),
	('C20981','2.5.1.121'),
	('C20982','2.5.1.121'),
	('C20983','2.5.1.122'),
	('C20984','2.5.1.123'),
	('C20985','2.8.2.37'),
	('C20986','3.1.4.57'),
	('C20987','3.13.1.4'),
	('C20988','3.5.1.46'),
	('C20988','3.5.1.117'),
	('C20990','3.5.1.117'),
	('C20991','2.4.1.184'),
	('C20992','3.1.1.59'),
	('C20993','1.14.99.52'),
	('C20994','1.14.99.51'),
	('C20994','3.5.1.118'),
	('C20995','1.14.99.50'),
	('C20995','3.5.1.118'),
	('C20996','1.14.19.32'),
	('C20997','1.14.19.32'),
	('C20998','1.14.19.15'),
	('C20999','1.14.19.15'),
	('C21000','1.14.19.6'),
	('C21001','2.5.1.125'),
	('C21001','2.5.1.124'),
	('C21002','2.5.1.124'),
	('C21003','2.5.1.125'),
	('C21004','2.5.1.127'),
	('C21004','2.5.1.126'),
	('C21005','1.14.13.204'),
	('C21006','1.14.13.204'),
	('C21007','1.5.1.50'),
	('C21008','1.5.1.50'),
	('C21008','5.1.99.8'),
	('C21009','2.5.1.128'),
	('C21010','2.5.1.128'),
	('C21015','6.3.2.3'),
	('C21015','6.3.2.2'),
	('C21016','6.3.2.3'),
	('C21017','1.2.4.4'),
	('C21018','1.2.4.4'),
	('C21018','2.3.1.168'),
	('C21019','1.14.18.4'),
	('C21020','1.14.18.6'),
	('C21021','1.14.18.7'),
	('C21022','2.1.1.317'),
	('C21022','1.14.19.18'),
	('C21022','1.14.19.19'),
	('C21023','1.14.19.19'),
	('C21024','1.14.19.29'),
	('C21025','1.14.19.29'),
	('C21026','1.4.99.6'),
	('C21028','1.3.1.2'),
	('C21028','1.3.1.1'),
	('C21028','3.5.2.2'),
	('C21029','3.5.1.6'),
	('C21029','3.5.2.2'),
	('C21030','2.6.1.40'),
	('C21031','2.7.7.7'),
	('C21064','1.1.1.390'),
	('C21064','3.1.1.99'),
	('C21065','1.13.11.81'),
	('C21068','2.6.1.108'),
	('C21068','2.7.4.31'),
	('C21069','2.5.1.131'),
	('C21069','2.7.4.31'),
	('C21070','2.5.1.131'),
	('C21072','2.3.1.250'),
	('C21072','1.14.19.6'),
	('C21075','1.5.3.5'),
	('C21075','1.5.3.6'),
	('C21076','1.14.13.141'),
	('C21076','6.2.1.42'),
	('C21078','1.13.11.82'),
	('C21079','1.14.11.49'),
	('C21080','1.14.13.206'),
	('C21081','1.14.13.209'),
	('C21082','1.14.19.37'),
	('C21083','1.14.19.37'),
	('C21084','1.6.5.12'),
	('C21085','5.3.3.19'),
	('C21088','4.2.1.156'),
	('C21089','4.2.1.157'),
	('C21090','4.2.1.157'),
	('C21091','4.2.1.158'),
	('C21092','5.1.1.21'),
	('C21094','5.1.99.7'),
	('C21095','5.5.1.27'),
	('C21096','6.2.1.46'),
	('C21097','6.2.1.46'),
	('C21097','2.3.2.28'),
	('C21098','2.3.2.28'),
	('C21098','6.2.1.46'),
	('C21099','6.3.2.48'),
	('C21100','2.5.1.127'),
	('C21101','2.7.14.1'),
	('C21101','3.9.1.2'),
	('C21102','3.5.4.41'),
	('C21106','1.14.19.41'),
	('C21107','2.4.2.54'),
	('C21108','3.1.2.31'),
	('C21108','2.3.1.161'),
	('C21113','3.6.1.22'),
	('C21114','1.14.19.11'),
	('C21115','1.14.19.26'),
	('C21129','2.3.1.238'),
	('C21130','2.3.1.238'),
	('C21131','1.14.13.224'),
	('C21131','1.14.13.217'),
	('C21132','1.14.13.224'),
	('C21134','1.14.13.217'),
	('C21134','1.14.13.224'),
	('C21135','1.14.13.224'),
	('C21138','2.2.1.12'),
	('C21139','2.2.1.12'),
	('C21140','1.1.1.394'),
	('C21141','1.1.1.394'),
	('C21141','1.14.13.222'),
	('C21142','1.1.1.394'),
	('C21143','1.14.13.211'),
	('C21144','1.14.13.212'),
	('C21145','1.14.13.215'),
	('C21146','1.14.13.215'),
	('C21147','1.14.13.216'),
	('C21148','1.14.13.216'),
	('C21149','1.14.14.21'),
	('C21150','1.14.14.22'),
	('C21150','1.14.14.21'),
	('C21151','3.1.1.97'),
	('C21151','2.1.1.314'),
	('C21152','2.7.1.196'),
	('C21153','2.7.8.26'),
	('C21153','3.1.3.73'),
	('C21155','3.5.2.20'),
	('C21156','2.7.1.187'),
	('C21157','2.7.4.29'),
	('C21158','3.1.3.97'),
	('C21159','3.3.2.14'),
	('C21160','3.4.14.13'),
	('C21161','2.1.1.316'),
	('C21162','2.1.1.316'),
	('C21163','2.1.1.316'),
	('C21164','2.1.1.316'),
	('C21165','2.1.1.317'),
	('C21166','1.17.99.1'),
	('C21166','1.2.1.96'),
	('C21167','1.2.1.96'),
	('C21169','2.3.1.249'),
	('C21170','2.3.1.248'),
	('C21171','2.3.1.250'),
	('C21171','3.1.1.98'),
	('C21172','2.3.1.250'),
	('C21172','3.1.1.98'),
	('C21173','2.7.8.42'),
	('C21174','2.7.8.42'),
	('C21175','2.8.3.23'),
	('C21177','3.5.1.119'),
	('C21177','6.3.1.19'),
	('C21178','3.5.1.119'),
	('C21178','6.3.1.19'),
	('C21179','3.5.1.119'),
	('C21180','4.1.2.58'),
	('C21180','4.2.1.162'),
	('C21181','4.1.2.58'),
	('C21182','3.1.1.99'),
	('C21182','4.2.1.162'),
	('C21183','1.14.13.213'),
	('C21183','2.1.1.323'),
	('C21184','1.14.13.213'),
	('C21185','1.14.13.214'),
	('C21186','4.2.99.23'),
	('C21187','4.2.99.23'),
	('C21188','2.1.1.319'),
	('C21189','2.1.1.320'),
	('C21190','2.1.1.322'),
	('C21191','2.1.1.323'),
	('C21191','1.14.21.11'),
	('C21192','1.14.15.17'),
	('C21193','2.3.1.251'),
	('C21194','2.3.1.251'),
	('C21212','2.4.1.153'),
	('C21213','2.4.1.335'),
	('C21214','2.5.1.129'),
	('C21215','2.5.1.129'),
	('C21217','1.3.1.111'),
	('C21219','3.1.3.101'),
	('C21240','2.7.1.190'),
	('C21250','4.2.1.117'),
	('C21251','2.6.1.94'),
	('C21252','2.6.1.94'),
	('C21253','2.4.1.301'),
	('C21254','2.4.1.301'),
	('C21281','4.2.3.154'),
	('C21282','4.2.3.155'),
	('C21283','4.3.1.31'),
	('C21284','4.99.1.9'),
	('C21285','1.1.1.402'),
	('C21285','5.1.3.38'),
	('C21286','5.1.3.39'),
	('C21287','5.3.3.20'),
	('C21288','1.1.1.397'),
	('C21289','1.1.1.397'),
	('C21290','1.1.1.400'),
	('C21291','1.1.1.400'),
	('C21291','1.2.1.98'),
	('C21293','1.14.11.52'),
	('C21294','1.1.1.402'),
	('C21295','1.14.13.218'),
	('C21296','1.14.15.19'),
	('C21297','1.2.1.98'),
	('C21298','4.1.1.103'),
	('C21299','1.4.3.4'),
	('C21300','1.4.3.4'),
	('C21303','1.14.13.221'),
	('C21304','1.14.13.141'),
	('C21305','1.14.13.221'),
	('C21310','4.1.99.22'),
	('C21310','4.6.1.17'),
	('C21329','1.1.3.49'),
	('C21330','1.14.13.222'),
	('C21331','1.14.13.222')]

def get_arguments():
	parser = argparse.ArgumentParser(
		formatter_class=argparse.RawTextHelpFormatter,
		usage=argparse.SUPPRESS,
		description="""Description: 
Query MIDAS output results by KEGG compound identifier
For more info on compounds, see: http://www.genome.jp/kegg/compound/

Workflow:
1) Identify enzymes linked to KEGG compound
2) Identify genes linked to enzymes
3) Scan over MIDAS output results 
4) Return abundances of identified genes per sample and species

Usage: query_by_compound.py [options]""",
		epilog="""Examples:
1) Query MIDAS results for compound C00312 (L-Xylulose):
query_by_compound.py -i midas_out -t dir -c C00312

2) Store results in text file:
query_by_compound.py -i midas_out -t dir -c C00312 > midas_C00312.txt

3) Specify path to individual sample directories:
query_by_compound.py -i midas_out/sample_1,midas_out/sample_2 -t list -c C00312""")
	parser.add_argument('-i', type=str, dest='input', required=True,
		help="""Input to sample directories output by run_midas.py
Can be a list of directories, a directory containing all samples, or a file with paths
See '-t' for details""")
	parser.add_argument('-t', choices=['list','file','dir'], dest='intype', required=True,
		help="""list: -i is a comma-separated list (ex: /path/to/samples/sample_1,/path/to/samples/sample_2)
 dir: -i is a directory containing all samples (ex: /path/to/samples)
file: -i is a file containing paths to sample directories (ex: /path/to/sample_paths.txt)
""")
	parser.add_argument('-o', type=str, dest='out', default='/dev/stdout',
		help="""Path to output file (/dev/stdout)""")
	parser.add_argument('-d', type=str, dest='db', default=os.environ['MIDAS_DB'] if 'MIDAS_DB' in os.environ else None,
		help="""Path to MIDAS reference database
By default, the MIDAS_DB environmental variable is used""")
	parser.add_argument('-c', type=str, dest='compound', required=True,
		help="""KEGG Compound identifier""")
	args = vars(parser.parse_args())
	return args

def check_database(args):
	if args['db'] is None:
		error = "\nError: No reference database specified\n"
		error += "Use the flag -d to specify a database,\n"
		error += "Or set the MIDAS_DB environmental variable: export MIDAS_DB=/path/to/midas/db\n"
		sys.exit(error)
	if not os.path.isdir(args['db']):
		error = "\nError: Specified reference database does not exist: %s\n" % args['db']
		error += "\nCheck that you've entered the path correctly and the database exists"
		error += "\nTo download the default database, run: MIDAS/scripts/download_ref_db.py"
		error += "\nTo build a custom database, run: MIDAS/scripts/build_midas_db.py\n"
		sys.exit(error)
	for dir in ['marker_genes', 'pan_genomes', 'rep_genomes']:
		path = '%s/%s' % (args['db'], dir)
		if not os.path.isdir(path):
			error = "\nError: Could not locate required database directory: %s\n" % path
			sys.exit(error)
	for file in ['species_info.txt']:
		path = '%s/%s' % (args['db'], file)
		if not os.path.exists(path):
			error = "\nError: Could not locate required database file: %s\n" % path
			sys.exit(error)

def fetch_genes(compound, species_id, db):
	genes = {}
	path = '%s/pan_genomes/%s/centroid_functions.txt.gz' % (db, species_id)
	for r in csv.DictReader(gzip.open(path), delimiter='\t'):
		if r['ontology'] == 'ec' and r['function_id'] in compound.enzymes:
			gene = Gene(r['gene_id'])
			gene.enzyme_id = r['function_id']
			genes[r['gene_id']] = gene
	return genes

def fetch_indirs(args):
	indirs = []
	error = "\nError: specified input %s does not exist: %s\n"
	if args['intype'] == 'dir':
		if not os.path.isdir(args['input']):
			sys.exit(error % (args['intype'], os.path.abspath(args['input'])))
		else:
			for dir in os.listdir(args['input']):
				indirs.append(os.path.join(args['input'], dir))
	elif args['intype'] == 'file':
		if not os.path.isfile(args['input']):
			sys.exit(error % (args['intype'], os.path.abspath(args['input'])))
		else:
			for line in open(args['input']):
				dir = line.rstrip().rstrip('/')
				if not os.path.isdir(dir): sys.exit(error % ('dir', dir))
				else: indirs.append(dir)
	elif args['intype'] == 'list':
		for dir in args['input'].split(','):
			if not os.path.isdir(dir): sys.exit(error % ('dir', dir))
			else: indirs.append(dir)
	return indirs

def fetch_samples(args):
	samples = {}
	# list samples
	for dir in fetch_indirs(args):
		if os.path.isdir(dir):
			id = os.path.basename(dir)
			samples[id] = Sample(id, dir)
		else:
			sys.stderr.write("Warning: specified sample dir does not exist: %s\n" % dir)
	# list species with gene content
	for sample in samples.values():
		ids = [_.rstrip() for _ in open('%s/genes/species.txt' % sample.dir)]
		sample.species_ids = ids
	# fetch species abundance
	for sample in samples.values():
		sample.species_profile = {}
		path = '%s/species/species_profile.txt' % sample.dir
		if not os.path.exists(path):
			sys.exit("Error: could not locate species profile for sample '%s'\n" % sample.id)
		for r in csv.DictReader(open(path), delimiter='\t'):
			sample.species_profile[r['species_id']] = r
	return samples

def fetch_species(compound, samples):
	species = {}
	for sample in samples.values():
		for species_id in sample.species_ids:
			if species_id not in species:
				species[species_id] = Species(species_id)
				species[species_id].genes = fetch_genes(compound, species_id, args['db'])
	return species

def write_output(compound, samples, species, outfile):
	out = open(outfile, 'w')
	fields = ['sample_id', 'species_id', 'species_abund', 'gene_id', 'enzyme_id', 'count_reads', 'read_depth', 'copy_number']
	out.write('\t'.join(fields)+'\n')
	for sample in samples.values():
		for species_id in sample.species_ids:
			sp = species[species_id]
			species_abun = sample.species_profile[species_id]['relative_abundance']
			path = '%s/genes/output/%s.genes.gz' % (sample.dir, species_id)
			fields = ['gene_id', 'count_reads', 'coverage', 'copy_number']
			for r in csv.DictReader(gzip.open(path), delimiter='\t'):
				if r['gene_id'] in sp.genes:
					gene = sp.genes[r['gene_id']]
					values = [sample.id, sp.id, species_abun, gene.id, gene.enzyme_id, r['count_reads'], r['coverage'], r['copy_number']]
					out.write('\t'.join([str(_) for _ in values])+'\n')
	out.close()

class Gene:
	def __init__(self, id):
		self.id = id

class Compound:

	def __init__(self, id):
		self.id = id
		self.enzymes = self.fetch_enzymes()

	def fetch_enzymes(self):
		enzymes = []
		for cpd, enzyme in cpd_to_enzyme:
			if self.id == cpd:
				enzymes.append(enzyme)
		if len(enzymes) == 0:
			sys.exit("Error: no enzymes matched compound id '%s'" % self.id)
		return enzymes

class Sample:
	""" Base class for samples """
	def __init__(self, id, dir):
		self.id = id
		self.dir = dir
		self.paths = self.init_paths()

	def init_paths(self):
		paths = {}
		species = '/'.join([self.dir, 'species/species_profile.txt'])
		if os.path.isfile(species): paths['species'] = species
		else: paths['species'] = None
		snps = '/'.join([self.dir, 'snps/summary.txt'])
		if os.path.isfile(snps): paths['snps'] = snps
		else: paths['snps'] = None
		genes = '/'.join([self.dir, 'genes/summary.txt'])
		if os.path.isfile(genes): paths['genes'] = genes
		else: paths['genes'] = None
		return paths

class Species:
	""" Base class for species """
	def __init__(self, id):
		self.id = id

if __name__ == '__main__':

	args = get_arguments()
	check_database(args)
	compound = Compound(id=args['compound'])
	samples = fetch_samples(args)
	species = fetch_species(compound, samples)
	write_output(compound, samples, species, args['out'])




