import sys
import gzip

filename = sys.argv[1]

barcode_file = gzip.GzipFile(filename,"r")
barcode_file.readline() # header

left_right_map = {}
right_barcodes = set()

num_processed = 0
for line in barcode_file:
    items = line.split("\t")
    barcode = items[1].strip()
    
    barcode_items = barcode.split(",")
    if len(barcode_items)>1:
        left_barcode = barcode_items[0]
        right_barcode = barcode_items[1]
    else:
        left_barcode = barcode_str
        right_barcode = ""
        
    if left_barcode not in left_right_map:
        left_right_map[left_barcode] = set()
        
    left_right_map[left_barcode].add(right_barcode)
    right_barcodes.add(right_barcode)
    
    num_processed+=1
    
    if num_processed%1000000==0:
        sys.stderr.write("%dM processed!\n" % (num_processed/1000000))
        
barcode_file.close()

print num_processed, "total entries!"

print len(right_barcodes), "right barcodes!"
num_conflicts=0
num_left = 0
for left_barcode, specific_right_barcodes in left_right_map.iteritems():
   num_left += 1
   if len(specific_right_barcodes) > 1:
       num_conflicts += 1
       
print num_left, "unique left barcodes!"
print num_conflicts, "doubled left barcodes!"    