## Single-nucleotide-polymorphism prediction
This script will map metagenomic reads to bacterial reference genomes and call SNPs in these genomes. You can either target one or more specific species, or provide this script a species abundance file  

The pipeline can be broken down into three main steps:  
  1) build a database of genome sequences for abundant bacterial species  
  2) map metagenomic reads to the database  
  3) use mapped reads to call SNPs  


## Usage
```
Usage: run_midas.py snps outdir [options]

positional arguments:
  outdir                Path to directory to store results. Name should correspond to sample identifier.

optional arguments:
  -h, --help            show this help message and exit
  --remove_temp         Remove intermediate files generated by MIDAS.
                        Useful to reduce disk space of MIDAS output

Pipeline options (choose one or more; default=all):
  --build_db            Build bowtie2 database of pangenomes
  --align               Align reads to pangenome database
  --call_snps           Run samtools mpileup and call SNPs

Database options (if using --build_db):
  -d DB                 Path to reference database
                        By default, the MIDAS_DB environmental variable is used
  --species_cov FLOAT   Include species with >X coverage (3.0)
  --species_topn INT    Include top N most abundant species
  --species_id CHAR     Include specified species. Separate ids with a comma

Read alignment options (if using --align):
  -1 M1                 FASTA/FASTQ file containing 1st mate if using paired-end reads.
                        Otherwise FASTA/FASTQ containing unpaired reads.
                        Can be gzip'ed (extension: .gz) or bzip2'ed (extension: .bz2)
  -2 M2                 FASTA/FASTQ file containing 2nd mate if using paired-end reads.
                        Can be gzip'ed (extension: .gz) or bzip2'ed (extension: .bz2)
  -s {very-fast,fast,sensitive,very-sensitive}
                        Bowtie2 alignment speed/sensitivity (very-sensitive)
  -n MAX_READS          # reads to use from input file(s) (use all)
  -t THREADS            Number of threads to use

SNP calling options (if using --call_snps):
  --mapid FLOAT         Discard reads with alignment identity < MAPID (94.0)
  --mapq INT            Discard reads with mapping quality < MAPQ (20)
  --baseq INT           Discard bases with quality < BASEQ (30)
  --readq INT           Discard reads with mean quality < READQ (20)
  --trim INT            Trim N base-pairs from read-tails (0)
  --discard             Discard discordant read-pairs
  --baq                 Enable BAQ (per-base alignment quality)
  --adjust_mq           Adjust MAPQ
```

## Examples

1) run entire pipeline using defaults:  
`run_midas.py snps /path/to/outdir -1 /path/to/reads_1.fq.gz -2 /path/to/reads_2.fq.gz`
			
2) run entire pipeline for a specific species:  
`run_midas.py snps /path/to/outdir --species_id Bacteroides_vulgatus_57955 -1 /path/to/reads_1.fq.gz -2 /path/to/reads_2.fq.gz`

3) just align reads, use faster alignment, only use the first 10M reads, use 4 CPUs:  
`run_midas.py snps /path/to/outdir --align -1 /path/to/reads_1.fq.gz -s very-fast -n 10000000 -t 4`

4) just call SNPs, keep reads with >=95% alignment identity and keep bases with quality-scores >=35:  
`run_midas.py snps /path/to/outdir --call_snps --mapid 95 --baseq 35`

## Output

The output of this script contains the following: 
 
* **output/**: per-species output files. are tab-delimited and gzip-compressed. named with the convention {SPECIES_ID}.snps.gz  
* **temp/**: intermediate files. use `--remove_temp` to remove these files   
* **summary.txt**: tab-delimited file summarizing alignments  
* **log.txt**: log file containing parameters used    

output file format (per species):  

* ref_id: scaffold id  
* ref_pos: position on scaffold  
* ref_allele: reference allele  
* alt_allele: alternate allele  
* cons_allele: consensus allele  
* count_alleles: number of distinct alleles observed  
* count_ref: count reference alleles observed  
* count_alt: count alternate alleles observed  
* depth: count total reads at ref_pos  
* ref_freq: frequency (0.0 to 1.0) of reference allele 

summary.txt file format: 

* species_id: species identifer      
* genome_length: length of reference genome used for read-mapping   
* covered_bases: number of genomic positions covered   
* fraction_covered: fraction of genomic positions with non-zero coverage        
* mean_coverage: mean read-depth at covered genomic positions

## Memory usage  
* Memory usage will depend on the number of species you search and the number of reference genomes sequenced per species.
* In practice, peak memory usage should not exceed 3.5 Gb for most samples

## Speed
* Speed will depend on the number of species you search and the number of sequenced reference genomes per species.
* For a single species with 1 reference genome, expect ~16,000 reads/second
* Use `-n` and `-t` to increase throughput

## Next step
[Merge results across samples] (merge_snvs.md)