#script to separate read identifier and isoform id in odd reads file from sam file
#to run script: Split.Reads.Sam.Alignments.py <odd read file> <output file>

import sys

#read in odd reads file
#returns list of of read and isoforms ids
def read_file():
    odd_reads_file = sys.argv[1]
    identifier_list = []
    with open(odd_reads_file, 'r') as odd_reads:
        for line in odd_reads:
            new_line = line.split(" ")
            identifier = new_line[0]
            identifier_full = identifier.split()
            read_iden = identifier_full[0]
            isoform_id = identifier_full[1]
            list_value = [read_iden, isoform_id]
            identifier_list.append(list_value)
    return identifier_list

#write new file
def write():
    identifiers = read_file()
    output = sys.argv[2]
    with open(output, 'a') as out:
        for iden in identifiers:
            single_read = iden[0]
            isoform_id = iden[1]
            final = "%s\t%s\n" % (str(single_read), str(isoform_id))
            out.write(final)


write()
