#pulling out isoform ids

import sys

#read in gtf
def read_gtf():
    gtf_file = sys.argv[1]
    isoform_list = []
    with open(gtf_file, 'r') as gtf:
        for line in gtf:
            new_line = line.split("\t")
            gene_info = new_line[8].split("; ")
            for val in gene_info:
                if val.startswith("transcript_id"):
                    val_split = val.split(" ")
                    transcript_id_full = val_split[1].strip("\"")
                    transcript_id = transcript_id_full.strip("PB.")
                    isoform_list.append(transcript_id)
    set_isoform_list = list(set(isoform_list))
    sorted_list = sorted(set_isoform_list, key=float)
    return sorted_list


#write isoforms
def write():
    isoform_list = read_gtf()
    output = sys.argv[2]
    with open(output, 'a') as out:
        for iso in isoform_list:
            final = "PB.%s;\n" % str(iso)
            out.write(final)

write()
