#fixing CDS positions for GTF
#minus strand CDS: need to flip start/stop positions
#to run script: python3 FlipCDSMinusStrandPos.py <gtf file> <output gtf file>
#Author: Alice Naftaly, Nov 2020

import sys

#read in gtf
def flip_pos_gtf():
    gtf_file = sys.argv[1]
    output = sys.argv[2]
    with open(gtf_file, 'r') as gtf, open(output, 'a') as out:
        for line in gtf:
            new_line = line.split("\t")
            if len(new_line) == 1:
                continue
            else:
                pos_1 = int(new_line[3])
                pos_2 = int(new_line[4])
                if pos_1 > pos_2:
                    corrected_line = "%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s" % (new_line[0], new_line[1], new_line[2], str(pos_2), str(pos_1), new_line[5], new_line[6], new_line[7], new_line[8])
                elif pos_1 < pos_2:
                    corrected_line = "%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s" % (new_line[0], new_line[1], new_line[2], str(pos_1), str(pos_2), new_line[5], new_line[6], new_line[7], new_line[8])
                out.write(corrected_line)


flip_pos_gtf()
