library(ggplot2)
library(hexbin)
library(MASS)
library(gridExtra)


library(RColorBrewer)
rf <- colorRampPalette(rev(brewer.pal(11,'Spectral')))
r <- rf(32)

path_c<-""
path_g<-""

####################### Read in sequence files where each C "1" and A,T,G is "0" 
####################### and each G "1" and A,T,C is "0"
t_a<-read.table(path_c)
t_t<-read.table(path_g)

t_a<-t_a[, rev(colnames(t_a))]
t_t<-t_t[, rev(colnames(t_t))]

s<-t_a+t_t
ii<-which(s==1, arr.ind=TRUE)

xx<-ii[,1]
yy<-ii[,2]
df <- data.frame(yy,xx)

############Calculate normalization constants so that the lowest displayed GC value is 0.18 and the highest is 0.6
max_Norm<-2577
min_Norm<-773

hexbinplot(yy~xx, data=df, colramp=rf,xlab="bp",maxcnt=max_Norm,mincnt=min_Norm,ylab="center",xbin=100)



