##################################################################################################
############This script outputs sequences from genomic coordinates in provided bed file
##################################################################################################

path_genome_sequence<-""
path_bed_file<-""
path_output<-""

####### Read in genome sequence file
ss<-readLines(path_genome_sequence)
####### Read in .bed file with genomic coordinates
t<-read.table(path_bed_file)

###provide length of line in your sequence file
fasta_line_length<-50
sss<-array(0)
for(i in 1:nrow(t)){if(t[i,1]=="CHROMOSOME_I") chrom_start<-1

#####Provide indexes of where new chromosome starts
if(t[i,1]=="CHROMOSOME_II") chrom_start<-301451
if(t[i,1]=="CHROMOSOME_III") chrom_start<-607039
if(t[i,1]=="CHROMOSOME_IV") chrom_start<-882714
if(t[i,1]=="CHROMOSOME_V") chrom_start<-1232591
if(t[i,1]=="CHROMOSOME_X") chrom_start<-1651075

b<-t[i,2]
e<-t[i,3]
lb<-b%/%fasta_line_length+chrom_start+1

cb<-b%%fasta_line_length
if(cb==0){cb<-fasta_line_length
          lb<-lb-1}

le<-e%/%fasta_line_length+chrom_start+1

ce<-e%%fasta_line_length
sequence=""
if(lb==le){sequence<-substr(ss[lb],cb,ce)}
if(le-lb==1){sequence<-paste(substr(ss[lb],cb,fasta_line_length),substr(ss[le],1,ce),sep="",collapse="")}
if(le-lb>1){sequence<-paste(substr(ss[lb],cb,fasta_line_length),paste(ss[(lb+1):(le-1)],sep="",collapse=""),substr(ss[le],1,ce),sep="",collapse="")}
sss[i]<-sequence
}

writeLines(sss,path_output)

