%% DESCRIPTIONS of THIS CODE (only used for intrachromosome)
% author: X.Z.
% reference Dixon et al. 2012
% (STEP 3)This code was used to calculate FDR. (See methods)
%input files:
%		1.files from last step
%output files:
%		1.FDR (pos is 1-based; # bin)


%note: we have mark the positions where we need to set again using "##**##".
%note: very very important!!! you need to check the distributions of P values for background and foreground. If background is equal or smaller than foreground, it means that you might have bad reproducibility for replicates.


data = load(strcat('./G_DS.dynamics')); %##**##
size1 = size(data,1);
data_f1 = data(abs(data(:,4))>abs(data(:,5)) & abs(data(:,4))>abs(data(:,6)),:);
data_f2 = data_f1(abs(data_f1(:,4))>=-1*log10(0.05),:);

bg = data(abs(data(:,5))>=-1*log10(0.05) | abs(data(:,6))>=-1*log10(0.05),:);
re = data_f2;
re(:,2) = re(:,2)+1; %converted to 1-based
re(:,3) = re(:,3)+1; %converted to 1-based
for i = 1:size(data_f2,1)
    if floor(i/2000)*2000 == i
        i
    end
    re(i,5) = sum(abs(data_f2(i,4))<= abs(bg(:,5)))/size1;
    re(i,6) = sum(abs(data_f2(i,4))<= abs(bg(:,6)))/size1;
end
dlmwrite(strcat('./G_DS_20k.FDR'),re,'delimiter','\t',...
   'precision',5);
[val1,~] = sort(abs(data(:,4)),'descend');
[val2,~] = sort(abs(data(:,5)),'descend');
[val3,~] = sort(abs(data(:,6)),'descend');
tmp =1:size(val1,1);%y7
figure(1);plot(repmat(tmp',1,3),[val1,val2,val3]);xlim([0,1e5]);