%% DESCRIPTIONS of THIS CODE (only used for interchromosome)
% author: X.Z.
% reference Dixon et al. 2012
% This code was used to calculate FDR. (See methods)
%input files:
%		1.whole genome interactions matirx (N*N)
%		2.a vector(N*1) telling the bin belong to which chromosome. it is important to find out which elements in contact matrix is intra or inter
%output files:
%		1.FDR (pos is 1-based; # bin)


%note: we have mark the positions where we need to set again using "##**##".
%note: very very important!!! you need to check the distributions of P values for background and foreground. If background is equal or smaller than foreground, it means that you might have bad reproducibility for replicates.




path = {'G1_1000000_dense.matrix',...
    'G2_1000000_dense.matrix',...
    'DS1_1000000_dense.matrix',...
    'DS2_1000000_dense.matrix'}; %%##**## chromosome interaction matrix
chrom = 23;
label0 = load('./pos.txt'); % tell the chromosome pos for whole genome interaction matrix
f = label0(:,1)<=chrom;
label = label0(f,:);

sign = ones(sum(f));
for i = 1:chrom
    sign(label(:,1)==i,label(:,1)==i) = 0;
end
for i = 1:4
    data0 = load(char(path(i)));
    data = data0(f==1,f==1);
    if i == 1
        data1 = data;
    elseif i == 2
        data2 = data;
    elseif i == 3
        data3 = data;
    elseif i == 4
        data4 = data;
    end
    zrow = (sum(data,1)==0);
    sign(zrow==1,:) = 0;
    sign(:,zrow==1) = 0;
end

%% counts
counts = [data1(sign==1),data2(sign==1),data3(sign==1),data4(sign==1)];
sumc = sum(counts,1);
p1 = (sumc(1)+sumc(2))/sum(sumc);
p2 = (sumc(1)+sumc(3))/sum(sumc);
p3 = (sumc(1)+sumc(4))/sum(sumc);
pval = zeros(size(counts,1),6);
for i = 1:size(counts,1)
    val = floor(counts(i,:));
    trails = sum(val);
    if floor(i/10000)*10000==i
        i
    end
    if trails>10
        if sum(val([1,2]))-1>=p1*trails
            pval1 = log10(binocdf(sum(val([1,2]))-1,trails,p1,'upper')+1e-5);
        else
            pval1 = -1*log10(binocdf(sum(val([1,2])),trails,p1)+1e-5);
        end
        if sum(val([1,3]))-1>=p2*trails
            pval2 = log10(binocdf(sum(val([1,3]))-1,trails,p2,'upper')+1e-5);
        else
            pval2 = -1*log10(binocdf(sum(val([1,3])),trails,p2)+1e-5);
        end                    
        if sum(val([1,4]))-1>=p3*trails
            pval3 = log10(binocdf(sum(val([1,4]))-1,trails,p3,'upper')+1e-5);
        else
            pval3 = -1*log10(binocdf(sum(val([1,4])),trails,p3)+1e-5);
        end
        pval(i,1:6) = [pval1,pval2,pval3,sum(val([1,2])),trails,p1];
    end
end

threshold = 0.05;
f1 = (abs(pval(:,1))>abs(log10(threshold))) & (abs(pval(:,1))>abs(pval(:,2))) & (abs(pval(:,1))>abs(pval(:,3)));
f2 = (abs(pval(:,2))>abs(log10(threshold)));
use2 = pval(f2==1,2);
f3 = (abs(pval(:,3))>abs(log10(threshold)));
use3 = pval(f3==1,3);

size1 = size(counts,1);
fdr = ones(size1,6);

for i = 1:size(counts,1)
    if floor(i/10000)*10000 == i
        i
    end
    if f1(i) == 1
        fdr(i,1) = ((pval(i,1)>0)-(pval(i,1)<0))*(sum(abs(pval(i,1))<= abs(use2))/size1+1/size1);
        fdr(i,2) = ((pval(i,1)>0)-(pval(i,1)<0))*(sum(abs(pval(i,1))<= abs(use3))/size1+1/size1);
        fdr(i,3) = -1*((pval(i,1)>0)-(pval(i,1)<0))*log10(mean(abs(fdr(i,1:2))));
        fdr(i,4:6) = pval(i,4:6);
    end
end

figure(1);subplot(1,2,1);histogram(abs(fdr(:,1)),100);
subplot(1,2,2);histogram(abs(fdr(:,2)),100);

fdr(fdr(:,3)==1,3) = 0;

fdrmat = zeros(size(sign));

ids = 1;
for i = 1:size(sign,1)
    for j = 1:size(sign,1)
        if sign(j,i) == 1
            fdrmat(j,i) = fdr(ids,3);
            ids = ids+1;
        end
    end
end
if ids == size(fdr,1)+1
    Error = 0
else
    Error = 1
end

ids = 1;
fdmat = zeros(size(sign));
for i = 1:size(sign,1)
    for j = 1:size(sign,1)
        if sign(j,i) == 1
            fdmat(j,i) = log2((1-(fdr(ids,4)/fdr(ids,5)))/(1-fdr(ids,6)));%% make sure DS - G
            ids = ids+1;
        end
    end
end
if ids == size(fdmat,1)+1
    Error2 = 0
else
    Error2 = 1
end

figure(2);imagesc(fdrmat);
figure(3);imagesc(fdmat.*(abs(fdrmat)>2));
dlmwrite('./G_DS_1M_log10fdr.txt',fdrmat,'delimiter','\t','precision',3);
dlmwrite('./G_DS_1M_log10fd.txt',fdmat,'delimiter','\t','precision',3);

