### circos plot 
library(circlize)
circos.clear()
factors = 1:24
pdf(file="circos.pdf", width=10.5, height=8)
## The values are pre-computed by looking at clusters of introns in different cell types.
track_margin_matrix = matrix(c(0,34069,0,5223,0,846,0,166,0,33950,0,5345,0,853,0,156,0,35239,0,4250,0,627,0,188,0,188,0,627,0,4250,0,35239,0,156,0,853,0,5345,0,33950,0,166,0,846,0,5223,0,34069), ncol = 2, byrow = TRUE)
grid.col = c('#386cb0','#ef3b2c','#7fc97f','#fdb462','#386cb0','#ef3b2c','#7fc97f','#fdb462','#386cb0','#ef3b2c','#7fc97f','#fdb462','#fdb462','#7fc97f','#ef3b2c','#386cb0','#fdb462','#7fc97f','#ef3b2c','#386cb0','#fdb462','#7fc97f','#ef3b2c','#386cb0')
circos.par(start.degree = 75,gap.after = c(1,1,1,5,1,1,1,5,1,1,1,30,1,1,1,5,1,1,1,5,1,1,1,30), cell.padding = c(0.02, 0, 0.02, 0))
circos.initialize(factors, xlim = track_margin_matrix)
circos.track(ylim = c(0, 1), track.height = 0.05,
             bg.border = NA)
highlight.sector(c(1,2,3,4), track.index = 1, col = "white", 
                 text = "ESC", cex = 1.2, text.col = "black", niceFacing = TRUE)
highlight.sector(c(5,6,7,8), track.index = 1, col = "white", 
                 text = "NPC", cex = 1.2, text.col = "black", niceFacing = TRUE)
highlight.sector(c(9,10,11,12), track.index = 1, col = "white", 
                 text = "Ctx", cex = 1.2, text.col = "black", niceFacing = TRUE)
circos.track(ylim = c(0, 1), track.height = 0.05,
             bg.border = NA)
highlight.sector(c(13,14,15,16), track.index = 1, col = "white", 
                 text = "Ctx", cex = 1.2, text.col = "black", niceFacing = TRUE)
highlight.sector(c(17,18,19,20), track.index = 1, col = "white", 
                 text = "NPC", cex = 1.2, text.col = "black", niceFacing = TRUE)
highlight.sector(c(21,22,23,24), track.index = 1, col = "white", 
                 text = "ESC", cex = 1.2, text.col = "black", niceFacing = TRUE)
circos.track(ylim = c(0, 1), track.height = 0.05,
             bg.border = NA, bg.col = grid.col)
circos.link(25 - 1, c(1, 32299), 25 - 5, c(1, 32299), col = '#386cb066')
circos.link(25 - 1, c(629, 33481), 25 - 9, c(1, 32852), col = '#386cb066')
circos.link(25 - 5, c(629, 33521), 25 - 9, c(1182, 34074), col = '#386cb066')
circos.link(25 - 2, c(1, 3300), 25 - 6, c(1, 3300), col = '#ef3b2c66')
circos.link(25 - 2, c(1244, 3926), 25 - 10, c(1, 2682), col = '#ef3b2c66')
circos.link(25 - 6, c(1244, 4067), 25 - 10, c(626, 3449), col = '#ef3b2c66')
circos.link(25 - 3, c(1, 518), 25 - 7, c(1, 518), col = '#7fc97f66')
circos.link(25 - 3, c(193, 578), 25 - 11, c(1, 385), col = '#7fc97f66')
circos.link(25 - 7, c(193, 609), 25 - 11, c(60, 476), col = '#7fc97f66')
circos.link(25 - 4, c(1, 148), 25 - 8, c(1, 148), col = '#fdb46266')
circos.link(25 - 4, c(6, 152), 25 - 12, c(1, 146), col = '#fdb46266')
circos.link(25 - 8, c(6, 156), 25 - 12, c(4, 154), col = '#fdb46266')
circos.link(1, c(1, 619), 10, c(3449, 4067), col = '#386cb066')
circos.link(5, c(1, 619), 10, c(3449, 4067), col = '#386cb066')
circos.link(1, c(619, 629), 11, c(476, 486), col = '#386cb066')
circos.link(5, c(619, 629), 11, c(476, 486), col = '#386cb066')
circos.link(1, c(629, 630), 12, c(154, 155), col = '#386cb066')
circos.link(5, c(629, 630), 12, c(154, 155), col = '#386cb066')
circos.link(9, c(1, 1178), 6, c(4067, 5244), col = '#386cb066')
circos.link(9, c(1178, 1183), 7, c(609, 614), col = '#386cb066')
circos.link(9, c(1183, 1183), 8, c(156, 156), col = '#386cb066')
circos.link(1, c(32299, 32299), 6, c(5244, 5244), col = '#386cb066')
circos.link(1, c(32299, 32299), 7, c(614, 614), col = '#386cb066')
circos.link(1, c(32299, 32299), 8, c(156, 156), col = '#386cb066')
circos.link(5, c(32299, 32299), 2, c(3926, 3926), col = '#386cb066')
circos.link(5, c(32299, 32299), 3, c(578, 578), col = '#386cb066')
circos.link(5, c(32299, 32299), 4, c(152, 152), col = '#386cb066')
circos.link(9, c(32852, 32852), 6, c(5244, 5244), col = '#386cb066')
circos.link(9, c(32852, 32852), 7, c(614, 614), col = '#386cb066')
circos.link(9, c(32852, 32852), 8, c(156, 156), col = '#386cb066')
circos.link(2, c(1, 1123), 9, c(34074, 35196), col = '#ef3b2c66')
circos.link(6, c(1, 1123), 9, c(34074, 35196), col = '#ef3b2c66')
circos.link(2, c(1123, 1241), 11, c(486, 604), col = '#ef3b2c66')
circos.link(6, c(1123, 1241), 11, c(486, 604), col = '#ef3b2c66')
circos.link(2, c(1241, 1245), 12, c(155, 159), col = '#ef3b2c66')
circos.link(6, c(1241, 1245), 12, c(155, 159), col = '#ef3b2c66')
circos.link(10, c(1, 419), 5, c(33521, 33939), col = '#ef3b2c66')
circos.link(10, c(419, 627), 7, c(614, 822), col = '#ef3b2c66')
circos.link(10, c(627, 627), 8, c(156, 156), col = '#ef3b2c66')
circos.link(2, c(3300, 3300), 5, c(33939, 33939), col = '#ef3b2c66')
circos.link(2, c(3300, 3300), 7, c(822, 822), col = '#ef3b2c66')
circos.link(2, c(3300, 3300), 8, c(156, 156), col = '#ef3b2c66')
circos.link(6, c(3300, 3300), 1, c(33481, 33481), col = '#ef3b2c66')
circos.link(6, c(3300, 3300), 3, c(578, 578), col = '#ef3b2c66')
circos.link(6, c(3300, 3300), 4, c(152, 152), col = '#ef3b2c66')
circos.link(10, c(2682, 2682), 5, c(33939, 33939), col = '#ef3b2c66')
circos.link(10, c(2682, 2682), 7, c(822, 822), col = '#ef3b2c66')
circos.link(10, c(2682, 2682), 8, c(156, 156), col = '#ef3b2c66')
circos.link(3, c(1, 5), 9, c(35196, 35200), col = '#7fc97f66')
circos.link(7, c(1, 5), 9, c(35196, 35200), col = '#7fc97f66')
circos.link(3, c(5, 171), 10, c(4067, 4233), col = '#7fc97f66')
circos.link(7, c(5, 171), 10, c(4067, 4233), col = '#7fc97f66')
circos.link(3, c(171, 194), 12, c(159, 182), col = '#7fc97f66')
circos.link(7, c(171, 194), 12, c(159, 182), col = '#7fc97f66')
circos.link(11, c(1, 2), 5, c(33939, 33940), col = '#7fc97f66')
circos.link(11, c(2, 61), 6, c(5244, 5303), col = '#7fc97f66')
circos.link(11, c(61, 61), 8, c(156, 156), col = '#7fc97f66')
circos.link(3, c(518, 518), 5, c(33940, 33940), col = '#7fc97f66')
circos.link(3, c(518, 518), 6, c(5303, 5303), col = '#7fc97f66')
circos.link(3, c(518, 518), 8, c(156, 156), col = '#7fc97f66')
circos.link(7, c(518, 518), 1, c(33481, 33481), col = '#7fc97f66')
circos.link(7, c(518, 518), 2, c(3926, 3926), col = '#7fc97f66')
circos.link(7, c(518, 518), 4, c(152, 152), col = '#7fc97f66')
circos.link(11, c(385, 385), 5, c(33940, 33940), col = '#7fc97f66')
circos.link(11, c(385, 385), 6, c(5303, 5303), col = '#7fc97f66')
circos.link(11, c(385, 385), 8, c(156, 156), col = '#7fc97f66')
circos.link(4, c(1, 1), 9, c(35200, 35200), col = '#fdb46266')
circos.link(8, c(1, 1), 9, c(35200, 35200), col = '#fdb46266')
circos.link(4, c(1, 1), 10, c(4233, 4233), col = '#fdb46266')
circos.link(8, c(1, 1), 10, c(4233, 4233), col = '#fdb46266')
circos.link(4, c(1, 7), 11, c(604, 610), col = '#fdb46266')
circos.link(8, c(1, 7), 11, c(604, 610), col = '#fdb46266')
circos.link(12, c(1, 1), 5, c(33940, 33940), col = '#fdb46266')
circos.link(12, c(1, 1), 6, c(5303, 5303), col = '#fdb46266')
circos.link(12, c(1, 5), 7, c(822, 826), col = '#fdb46266')
circos.link(4, c(148, 148), 5, c(33940, 33940), col = '#fdb46266')
circos.link(4, c(148, 148), 6, c(5303, 5303), col = '#fdb46266')
circos.link(4, c(148, 148), 7, c(826, 826), col = '#fdb46266')
circos.link(8, c(148, 148), 1, c(33481, 33481), col = '#fdb46266')
circos.link(8, c(148, 148), 2, c(3926, 3926), col = '#fdb46266')
circos.link(8, c(148, 148), 3, c(578, 578), col = '#fdb46266')
circos.link(12, c(146, 146), 5, c(33940, 33940), col = '#fdb46266')
circos.link(12, c(146, 146), 6, c(5303, 5303), col = '#fdb46266')
circos.link(12, c(146, 146), 7, c(826, 826), col = '#fdb46266')
legend('right', ncol=1, legend=c('A', 'B', 'C', 'D'),
       fill=c('#386cb0','#ef3b2c','#7fc97f','#fdb462'), border=FALSE, bty='n', y.intersp = 1.2, cex=1.2)
dev.off()