hpf <- read.table("stage_hpf.txt",header=T)

N10 <- c(0,0,0,0,0,0,0,0,0,0,0)

for (i in 1:11) {
	st <- hpf[i,1]

	Mergeddomain <- read.table(paste0("./MergedDomains/",st,"_combined_30_contact_domains_5000_10_bed_sort_merged"),header=T)
	TotalDomainCovered <- sum(Mergeddomain[,3]-Mergeddomain[,2])
	domain <- read.table(paste0("./ContactDomains/",st,"_combined_30_contact_domains_5000_10_bed"),header=T)
	size <- domain[,3]-domain[,2]
	domain2 <- cbind(domain,size)
	domain3 <- domain2[order(domain2[,4],decreasing=TRUE),]
	cumsum <- cumsum(domain3[,4])

	x <- domain3[cumsum>=TotalDomainCovered/10,]
	N10[i] <- x[1,4]
}

options(scipen=1)
write.table(cbind(hpf,N10),"./ContactDomainN10.txt",sep="\t",append=F,quote=F,row.name=F,col.name=T)