#!/usr/bin/perl

use strict;
use warnings;

print STDERR "Enter name of bed file:\n";
my $bedfile = <STDIN>;
chomp $bedfile;
open (BED, "$bedfile") || die "Could not open .bed file: $bedfile\n";

print STDERR "Enter name of matching nucleotide sequence file:\n";
my $nucfile = <STDIN>;
chomp $nucfile;
open (NUC, "$nucfile") || die "Could not open .fa file: $nucfile\n";

my $head = "";
my $nucseq = "";
my $match_flag = 1;
while( my $line = <BED> )
{
	my @field = split /\t/, $line;
	if ( $match_flag )
	{	
		$head = <NUC>;
		chomp $head;
		$nucseq = <NUC>;
		chomp $nucseq;
		$head =~ s/^>//;
	}
	if ( $head eq $field[3] )
	{
		$match_flag = 1;
		if ( $nucseq =~ /G/ )
		{
			print $line;
		}
	}
	else
	{
		print STDERR "Error: sequence read names didn't match: $field[3] and $head\n";
		$match_flag = 0;
	}
}
