#!/bin/bash

#Code adapted from code on Taylor lab github site

export NA=$1
mkdir ${NA}
cd ${NA}
ln -s ../${NA}.fastq

# initial alignment and processing of files
OUTPUT="$(bowtie2 -x /Users/johnwyrick/bin/bowtie2-2.2.6/saccer3 -U ${NA}.fastq -S ${NA}.sam)"
echo "${OUTPUT}"
samtools view -b -S ${NA}.sam >${NA}.bam
bamToBed -i ${NA}.bam >${NA}.bed

# get damage coordinate and sequence of damage
perl ../MMS_finddamagecoord.pl <${NA}.bed >${NA}_damage.bed
fastaFromBed -s -name -fi ../saccer3_genome.fa -bed ${NA}_damage.bed -fo ${NA}_damage.fa

# count damage nucleotides
perl ../count_nucleotides_MMS.pl <${NA}_damage.fa >${NA}_nucount.txt

# extract G reads
printf "${NA}_damage.bed\n${NA}_damage.fa\n" | perl ../extract_G_reads.pl >${NA}_Greads.bed

# sort G reads
cat ${NA}_Greads.bed | sort -k1,1 -k2,2n -k 6 >${NA}_Greads_sorted.bed

# split strands
printf "${NA}_Greads_sorted.bed\n" | perl ../split_strands.pl 

# rest of processing should be done mannually --> count function of IGV tools, withi window size 1, zoom 10, to generate .wig files
# then run perl set_background.pl >[bkgd set wig file]

# extract A reads
printf "${NA}_damage.bed\n${NA}_damage.fa\n" | perl ../extract_A_reads.pl >${NA}_Areads.bed

# sort A reads
cat ${NA}_Areads.bed | sort -k1,1 -k2,2n -k 6 >${NA}_Areads_sorted.bed

# split strands
printf "${NA}_Areads_sorted.bed\n" | perl ../split_strands.pl

# rest of processing should be done mannually --> count function of IGV tools, withi window size 1, zoom 10, to generate .wig files
# then run perl set_background.pl >[bkgd set wig file]
