#!/usr/bin/perl

use strict;
use warnings;

my %genome;
my $chr = "";
while ( <STDIN> )
{
	chomp $_;
	if ( $_ =~ /(chr[XIVM]+)/ )
	{
		print $_ . "\n";
		$chr = $1;
	}
	else
	{
		$genome{$chr} .= $_;
	}

}

open ( PLUS, ">initial_plus_G.wig" );
open ( MINUS, ">initial_minus_G.wig" );
# find G's in plus strand
foreach my $chrom (sort keys %genome )
{
	print "Processing $chrom\n";
	print PLUS "variableStep chrom=$chrom span=1\n";
        print MINUS "variableStep chrom=$chrom span=1\n";

	my $prev_plus_dipy_flag = 0;
	my $prev_minus_dipy_flag = 0;
	my $seq = $genome{$chrom};
	# fixed loop - should be < length($seq) --> not, -1
	for ( my $i = 0; $i < length($seq); $i++ )
	{
		my $subseq = substr( $seq, $i, 1 );
		if ( $subseq =~ /G/ )
		{
			my $j = $i + 1;
			print PLUS "$j\t0.0\n";
		}
                if ( $subseq =~ /C/ )
                {
			my $j = $i + 1;
                        print MINUS "$j\t0.0\n";
                }

	}

} 
close (PLUS);
close (MINUS);
