#!/usr/bin/perl

use strict;
use warnings;

use lib '../';

use OrientedNucCoord;
use CPDNucReads;
use GeneCoord;

my $nucwindow = 90;

# ask for probe filename to analyze

print STDERR "Enter filename of plus strand reads\n";
my $plusfile = <STDIN>;
chomp($plusfile);

print STDERR "Enter filename of minus strand reads\n";
my $minusfile = <STDIN>;
chomp($minusfile);

#get list of genes used in NAR PAPER
my %genelist;
my $genes = GeneCoord->new();
my %chromosomes = $genes->get_chromosomes();
foreach my $chr (sort keys %chromosomes)
{
        foreach my $acc ( @{$chromosomes{$chr}} )
        {
                $genelist{$acc} = 1;
        }
}
# add filename here for probe values 
#my $filename = "h2bwtdata.txt";

print STDERR "Loading nucleosome coordinates\n";
my $nucs = OrientedNucCoord->new();
print STDERR "Loading Probe Values\n";
my $reads = CPDNucReads->new($plusfile, $minusfile);

my $nuc_filename = $nucs->get_nuc_filename();
#print header
print "Oriented Nucleosome positioning data from: $nuc_filename\nSequencing data from file: $plusfile\t$minusfile\n";

my %alldyad = $nucs->get_category_dyad();
my %dyadstrand = $nucs->get_dyad_strand();
my %dyadacc = $nucs->get_dyad_acc();

for ( my $d = 1; $d < 4; $d++ )
{
	my @pluscpdval = ();
	my @pluscpdcount = ();
	my @minuscpdval = ();
	my @minuscpdcount = ();

	my %chrdyad = %{$alldyad{$d}};		
	foreach my $chr (sort keys %chrdyad)
	{
		print STDERR "Starting $chr\n";
		my %plusreads = $reads->get_plus_reads_for_chromosome($chr);
		my $num_plusreads = scalar keys %plusreads;
		my %minusreads = $reads->get_minus_reads_for_chromosome($chr);
		my $num_minusreads = scalar keys %minusreads;
		print STDERR "$chr reads: $num_plusreads plus reads and $num_minusreads minus reads\n";

		foreach my $dyad ( @{$chrdyad{$chr}} )
		{
			my $acc = $dyadacc{$chr}{$dyad};

			if ( exists $genelist{$acc} && $genelist{$acc} == 1 )
			{
				;
			}
			else
			{
				#print STDERR "Skipped Acc: $acc\n";
				next;
			}

			my $start = $dyad - $nucwindow;
			my $end = $dyad + $nucwindow;
			my $strand = $dyadstrand{$chr}{$dyad};

			if ( $strand eq "+" )
			{
				for ( my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
				{	
					my $pos = $dyad + $i;
					my $j = $i + $nucwindow;
					if ( exists $plusreads{$pos} )
					{
						$pluscpdval[$j] += $plusreads{$pos};
						$pluscpdcount[$j]++;
					}
				
	        	                if ( exists $minusreads{$pos} )
	                	        {
	                        	        $minuscpdval[$j] += $minusreads{$pos};
	                                	$minuscpdcount[$j]++;
	                        	}
				}
			}
			elsif ( $strand eq "-" )
			{
                                for ( my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
                                {
                                        my $pos = $dyad + $i;
                                        my $j = $nucwindow - $i; # opposite direction because - strand
                                        if ( exists $plusreads{$pos} )
                                        {
						# switch strand because minus strand
                                                $minuscpdval[$j] += $plusreads{$pos};
                                                $minuscpdcount[$j]++;
                                        }

                                        if ( exists $minusreads{$pos} )
                                        {
						# switch strand because minus strand
                                                $pluscpdval[$j] += $minusreads{$pos};
                                                $pluscpdcount[$j]++;
                                        }
                                }


			}
			else
			{
				die "No strand info for nucleosome: $chr\t$dyad\n";
			}
		}
	
	}

	print "Data for +${d} nucleosomes:\n";	
	print "Position relative to dyad:";
	for ( my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
	{
        	print "\t$i";
	}
	print "\n";
	print "Plus strand";
	for (my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
	{
		my $j = $i + $nucwindow;
		my $mean = 1.0 * $pluscpdval[$j] / $pluscpdcount[$j];
		print "\t$mean";
	}
	print "\nMinus strand";
	for (my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
	{
		my $j = $i + $nucwindow;
	        my $mean = 1.0 * $minuscpdval[$j] / $minuscpdcount[$j];
	        print "\t$mean";
	}
	print "\nPlus strand\n";
	print "CPDs:";
	for (my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
	{
	        my $j = $i + $nucwindow;
	        print "\t$pluscpdval[$j]";
	}
	print "\nDipyrimidines:";
	for (my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
	{
	        my $j = $i + $nucwindow;
	        print "\t$pluscpdcount[$j]";
	}
	print "\nMinus strand\n";
	print "CPDs:";
	for (my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
	{
	        my $j = $i + $nucwindow;
	        print "\t$minuscpdval[$j]";
	}
	print "\nDipyrimidines:";
	for (my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
	{
	        my $j = $i + $nucwindow;
	        print "\t$minuscpdcount[$j]";
	} 
	
	print "\n\n";
	print "Average of both strands:";
	print "\nAverage";
	for (my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
	{
	        my $j = $i + $nucwindow;
		my $total_val = $pluscpdval[$j] + $minuscpdval[$j];
		my $total_count = $pluscpdcount[$j] + $minuscpdcount[$j];
	        my $mean = 1.0 * $total_val / $total_count;
	        print "\t$mean";
	}
	print "\n\n";
}
