#!/usr/bin/perl

use strict;
use warnings;

print STDERR "Please enter filename for data matrix\n";
my $filename = <STDIN>;
chomp $filename;
my $fileout = $filename;
$fileout =~ s/\.txt/_diffsort\.txt/ || die "filename of data matrix is wrong type!\n";

open ( OUT, ">$fileout") || die "couldn't open file\n";

open( FILE, $filename ) || die "Couldn't open file: $filename\n";

if ( $filename =~ /_centered/ || $filename =~ /_center/ || $filename =~ /_norm/ )
{
	;
}
else
{
	# remove top header because (normally removed by logtransform_center.pl program)
	my $topline = <FILE>;
}

my $header = <FILE>;
my %matrix;
my %codingval; 
my $offset = 3;	# due to flanking bins
my $columns = 13;
while ( my $line = <FILE> )
{
	chomp $line;
	my @fields = split /\t/, $line, -1;
	$matrix{$fields[0]} = $line;
	if ( scalar @fields != $columns )
	{
		die "Weird number of columns for line $line\n";
	}
	# coding starts at position = 4 (YORF + 3 Promoter bins)
	my $flag = 0;
	my $sum;
	my $bins;
	for ( my $i = $offset + 1; $i < ( scalar @fields - $offset ); $i++ )
	{
		if ( $fields[$i] ne "" )
		{
			$sum += $fields[$i] * 1.0;
			$bins++;
			$flag = 1;
		}
	}
	if ( $flag )
	{
		my $avg = 1.0 * $sum / $bins;
		$codingval{$fields[0]} = $avg;
	}
}

#print less list
print OUT $header;
foreach my $acc ( sort {$codingval{$b} <=> $codingval{$a}} keys %codingval )
{
        if ( exists $matrix{$acc} )
        {
		print OUT $matrix{$acc} . "\n";
	}
}

