#!/usr/bin/perl 

use strict;
use warnings;

my %data = ();
my @order = ();

print STDERR "Enter name of No UV dinucount file\n";
my $nofile = <STDIN>;
chomp $nofile;
$nofile .= "/${nofile}_nucount.txt";
open ( NO, "$nofile" ) || die "couldn't open file\n";
my $othercount = 0;
while ( my $line = <NO> )
{
	chomp $line;
	my @fields = split /\t/, $line;
	
	if ( $fields[0] =~ /[CT][CT]/ )
	{
		$data{$nofile}{$fields[0]} = $fields[1];
	}
	elsif ( $fields[0] =~ /[ACGT][ACGT]/ )
	{
		$data{$nofile}{"Other"} += $fields[1];
		$othercount++;
	}
	else
	{
		die "Weird field: $line\n";
	}
}
$order[0] = $nofile;
close ( NO );

$data{$nofile}{"Other"} = 1.0 * $data{$nofile}{"Other"} / $othercount;
$othercount = 0;

print STDERR "Enter name of 0hr UV dinucount file\n";
my $zerofile = <STDIN>;
chomp $zerofile;
$zerofile .= "/${zerofile}_nucount.txt";
open ( ZERO, "$zerofile" ) || die "couldn't open file\n";
while ( my $line = <ZERO> )
{
        chomp $line;
        my @fields = split /\t/, $line;
        if ( $fields[0] =~ /[CT][CT]/ )
        {
                $data{$zerofile}{$fields[0]} = $fields[1];
        }
        elsif ( $fields[0] =~ /[ACGT][ACGT]/ )
        {
                $data{$zerofile}{"Other"} += $fields[1];
		$othercount++;
        }
        else
        {
                die "Weird field: $line\n";
        }
}
$order[1] = $zerofile;
close ( ZERO );

$data{$zerofile}{"Other"} = 1.0 * $data{$zerofile}{"Other"} / $othercount;
$othercount = 0;

print STDERR "Enter name of 2hr UV dinucount file\n";
my $twofile = <STDIN>;
chomp $twofile;
$twofile .= "/${twofile}_nucount.txt";
open ( TWO, "$twofile" ) || die "couldn't open file\n";
while ( my $line = <TWO> )
{
        chomp $line;
        my @fields = split /\t/, $line;
        if ( $fields[0] =~ /[CT][CT]/ )
        {
                $data{$twofile}{$fields[0]} = $fields[1];
        }
        elsif ( $fields[0] =~ /[ACGT][ACGT]/ )
        {
                $data{$twofile}{"Other"} += $fields[1];
		$othercount++;
        }
        else
        {
                die "Weird field: $line\n";
        }
}
$order[2] = $twofile;
close ( TWO );

$data{$twofile}{"Other"} = 1.0 * $data{$twofile}{"Other"} / $othercount;
$othercount = 0;

print "Dinucleotide";

foreach my $cat ( @order )
{
	print "\t$cat";
}
print "\n";
foreach my $dinuc ( sort { $data{$zerofile}{$b} <=> $data{$zerofile}{$a} } keys %{$data{$zerofile}} )
{
	print "$dinuc";
	foreach my $cat ( @order )
	{
		my $val = $data{$cat}{$dinuc} / 1000000.0;
		print "\t$val";
	}
	print "\n";
}
