#!/usr/bin/perl

use strict;
use warnings;

print "Enter name of mutant cluster file\n";
my $mutclusterfile = <STDIN>;
chomp $mutclusterfile;

my $diffclusterout = $mutclusterfile;

print "Enter name of WT cluster file\n";
my $wtclusterfile = <STDIN>;
chomp $wtclusterfile;

open ( MUT, "$mutclusterfile" ) || die "Couldn't open file $mutclusterfile\n";
open ( WT, "$wtclusterfile" ) || die "Couldn't open file $wtclusterfile\n";

if ( $mutclusterfile =~ /_centered/ || $mutclusterfile =~ /_center/ || $mutclusterfile =~ /_norm/ )
{
        ;
}
else
{
        # remove top header because (normally removed by logtransform_center.pl program)
        my $topline = <MUT>;
}

if ( $wtclusterfile =~ /_centered/ || $wtclusterfile =~ /_center/ || $wtclusterfile =~ /_norm/ )
{
        ;
}
else
{
        # remove top header because (normally removed by logtransform_center.pl program)
        my $top = <WT>;
}

my $header = <MUT>;
my $otherhead = <WT>;
if ( $header eq $otherhead )
{
	print $header;
}
else
{
	die "mismatched headers\n";
}
my %muthash;
my %wthash;
while ( my $line = <MUT> )
{
	chomp $line;
        my @mutvals = split /\t/, $line, -1;
	$muthash{$mutvals[0]} = $line;
}
my $matches  = 0;
my $mismatch = 0;
while ( my $line = <WT>)
{
	chomp $line;
        my @wtvals = split /\t/, $line, -1;
	if ( $line eq $muthash{$wtvals[0]} )
	{
		$matches++;
	}
	else
	{
		$mismatch++;
	}
}

print "Matches: $matches\nMismatches: $mismatch\n";
