#!/usr/bin/perl 

use strict;
use warnings;

my %data = ();

print STDERR "Enter name of first dinucount directory\n";
my $nofile = <STDIN>;
chomp $nofile;
$nofile .= "/${nofile}_nucount.txt";
open ( NO, "$nofile" ) || die "couldn't open file\n";
while ( my $line = <NO> )
{
	chomp $line;
	my @fields = split /\t/, $line;
	$data{$fields[0]} += $fields[1];
}
close ( NO );

print STDERR "Enter name of second dinucount directory\n";
my $zerofile = <STDIN>;
chomp $zerofile;
$zerofile .= "/${zerofile}_nucount.txt";
open ( ZERO, "$zerofile" ) || die "couldn't open file\n";
while ( my $line = <ZERO> )
{
        chomp $line;
        my @fields = split /\t/, $line;
        $data{$fields[0]} += $fields[1];
}
close ( ZERO );

foreach my $dinuc ( sort keys %data )
{
	print "$dinuc\t$data{$dinuc}\n";
}
