#!/usr/bin/perl

use strict;
use warnings;

package Oriented_RSCNucCoord;

my %chrlookup = ( "chr1" => "chrI", "chr2" => "chrII", "chr3" => "chrIII", "chr4" => "chrIV", "chr5" => "chrV", "chr6" => "chrVI", "chr7" => "chrVII", "chr8" => "chrVIII", "chr9" => "chrIX", "chr10" => "chrX", "chr11" => "chrXI", "chr12" => "chrXII", "chr13" => "chrXIII", "chr14" => "chrXIV", "chr15" => "chrXV", "chr16" => "chrXVI", "chrM" => "chrM");

sub new
{
	my ($class) = @_;
	
	my $self = bless {}, $class;

	my $nuc_file_name = "../nucs_111R_hi_trim_min8_sort_annotate.bed";
        #my $nuc_file_name = "../nucs_111V_hi_trim_min8_sort_annotate.bed";

	# open file with gene positions
	open( GENE, $nuc_file_name) || die "Couldn't open file\n";
	my $header = <GENE>;
	
	my %chromdyad;
	my %dyadscore;
	my %dyadstrand;
	my %dyadacc;
	my %categorydyads;
	
	while( my $line = <GENE> )
	{
		chomp($line);

		my @fields = split /\t/, $line;
		my $chr = $fields[0];

		if ( $chr =~ /chr[XIVM]+/ )
		{	;	}
		else
		{	die "Misformatted line: $line\n";	}

		my $pos = $fields[2]; #1-based dyad end position
		push @{$chromdyad{$chr}}, $pos;		# assuming this is 1-based
		$dyadscore{$chr}{$pos} = $fields[3];	# setting coverage as the score
		
		$dyadacc{$chr}{$pos} = $fields[4];

		my $strand = "";
		if ( $fields[4] ne "NA" )
		{
			$strand = $fields[5];
		}
		$dyadstrand{$chr}{$pos} = $strand;

		if ( $strand eq "+" || $strand eq "-" )
		{
	                push @{$categorydyads{$chr}}, $pos;
		}
	}

	close ( GENE );
	$self->{'chromdyad'} = \%chromdyad;
        $self->{'dyadscore'} = \%dyadscore;
        $self->{'dyadstrand'} = \%dyadstrand;
	$self->{'dyadacc'} = \%dyadacc;
	$self->{'nuc_file_name'} = $nuc_file_name;
	$self->{'categorydyads'} = \%categorydyads;
	return $self;	
}

sub get_category_dyad
{
        my ($self) = @_;

        return %{$self->{'categorydyads'}};
}

sub get_chr_dyad
{
	my ($self) = @_;

	return %{$self->{'chromdyad'}};

}

sub get_dyad_score
{
        my ($self) = @_;

        return %{$self->{'dyadscore'}};

}

sub get_dyad_strand
{
        my ($self) = @_;

        return %{$self->{'dyadstrand'}};

}

sub get_dyad_acc
{
        my ($self) = @_;

        return %{$self->{'dyadacc'}};
}

sub get_nuc_filename
{
        my ($self) = @_;

        return $self->{'nuc_file_name'};
}

1;	
