#!/usr/bin/perl

use strict;
use warnings;

package OrientedNucCoord;

my %chrlookup = ( "chr1" => "chrI", "chr2" => "chrII", "chr3" => "chrIII", "chr4" => "chrIV", "chr5" => "chrV", "chr6" => "chrVI", "chr7" => "chrVII", "chr8" => "chrVIII", "chr9" => "chrIX", "chr10" => "chrX", "chr11" => "chrXI", "chr12" => "chrXII", "chr13" => "chrXIII", "chr14" => "chrXIV", "chr15" => "chrXV", "chr16" => "chrXVI", "chrM" => "chrM");

sub new
{
	my ($class) = @_;
	
	my $self = bless {}, $class;

	my $nuc_file_name = "../RandoNucleosomemap_mmc3.txt";

	# open file with gene positions
	open( GENE, $nuc_file_name) || die "Couldn't open file\n";
	my $header = <GENE>;
	
	my %chromdyad;
	my %dyadscore;
	my %dyadcategory;
	my %dyadstrand;
	my %dyadacc;
	my %categorydyads;
	
	while( my $line = <GENE> )
	{
		chomp($line);

		my @fields = split /\t/, $line;
		my $temp = "chr" . $fields[1];
		my $chr = $chrlookup{$temp};

		if ( $chr =~ /chr[XIVM]+/ )
		{	;	}
		else
		{	die "Misformatted line: $line\n";	}

		my $pos = $fields[2];
		push @{$chromdyad{$chr}}, $pos;		# assuming this is 1-based
		$dyadscore{$chr}{$pos} = $fields[3];	# setting coverage as the score
		
		my $str = "";
		my $acc = $fields[5];
		if ( $acc =~ /^Y[A-P][LR][0-9]{3}W/ )
		{
			$str = "+";
		}
		elsif ( $acc =~ /^Y[A-P][LR][0-9]{3}C/ )
		{
			$str = "-";
		}
		else
		{
			next;	# skip accession because not in gene
		}

		$dyadacc{$chr}{$pos} = $acc;
		$dyadstrand{$chr}{$pos} = $str;

		my $nucategory = $fields[6];
		#$nucategory =~ s/\s//g;

		if ($nucategory =~ /^[-]?[0-9]+$/ )
		{
	                $dyadcategory{$chr}{$pos} = $nucategory;
	                push @{$categorydyads{$nucategory}{$chr}}, $pos;
		}
		else
		{
                        die "Error with nuc category: $nucategory for line $line\n";
		}
	}

	close ( GENE );
	$self->{'chromdyad'} = \%chromdyad;
        $self->{'dyadscore'} = \%dyadscore;
        $self->{'dyadstrand'} = \%dyadstrand;
        $self->{'dyadcategory'} = \%dyadcategory;
	$self->{'dyadacc'} = \%dyadacc;
	$self->{'nuc_file_name'} = $nuc_file_name;
	$self->{'categorydyads'} = \%categorydyads;
	return $self;	
}

sub get_category_dyad
{
        my ($self) = @_;

        return %{$self->{'categorydyads'}};
}

sub get_chr_dyad
{
	my ($self) = @_;

	return %{$self->{'chromdyad'}};

}

sub get_dyad_score
{
        my ($self) = @_;

        return %{$self->{'dyadscore'}};

}

sub get_dyad_strand
{
        my ($self) = @_;

        return %{$self->{'dyadstrand'}};

}

sub get_dyad_category
{
        my ($self) = @_;

        return %{$self->{'dyadcategory'}};

}
sub get_dyad_acc
{
        my ($self) = @_;

        return %{$self->{'dyadacc'}};
}

sub get_nuc_filename
{
        my ($self) = @_;

        return $self->{'nuc_file_name'};
}

1;	
