#!/usr/bin/perl

use strict;
use warnings;

package ArbitraryCoord;

sub new
{
	my ($class) = @_;
	
	my $self = bless {}, $class;

my %chrlookup = ( "1" => "chrI", "2" => "chrII", "3" => "chrIII", "4" => "chrIV", "5" => "chrV", "6" => "chrVI", "7" => "chrVII", "8" => "chrVIII", "9" => "chrIX", "10" => "chrX", "11" => "chrXI", "12" => "chrXII", "13" => "chrXIII", "14" => "chrXIV", "15" => "chrXV", "16" => "chrXVI", "M" => "chrM");

	my $arb_file_name = "HML.txt";
	#my $arb_file_name = "telomere_left_arm_1kb.txt";
	# open file with gene positions
	open( GENE, $arb_file_name) || die "Couldn't open file\n";
	my $header = <GENE>;
	
	my %arb;
	
	while( my $line = <GENE> )
	{
		chomp($line);
		if ( $line eq "" )
		{	next;	}

		my @fields = split /\t/, $line;
		push @{$arb{$chrlookup{$fields[0]}}}, [$fields[1], $fields[2]];
	}

	close ( GENE );
	$self->{'arb'} = \%arb;
	$self->{'arb_file_name'} = $arb_file_name;
	return $self;	
}

sub get_arb_boundaries
{
	my ($self) = @_;

	return %{$self->{'arb'}};

}

sub get_arb_filename
{
        my ($self) = @_;

        return $self->{'arb_file_name'};
}

1;	
