#!/bin/bash

#we use an environment module to manage R versioning and packages; load a module with R 3.6.1 and rtracklayer v1.44.3 and all dependencies

module load <MODULE> #module for R and rtracklayer

#paths that need to be set to local system directories:
bin_dir=#path to where these scripts are placed

frag_bed_file=$1 #a fragment bed created by process_STARR_pair_fqs_to_frag_beds.sh
ref_GR_obj=$2 #an R save file containing ONLY a GenomicRanges object to map read counts to; for example bins spanning the HTT locus (HTT_loc_tiled_GR.Rvar)
out_overlap_obj=$3 #name for R save file containg the output GenomicRanges object of stranded counts for each interval in ref_GR_obj

cat ${bin_dir}/get_frag_bed_to_ref_GR_overlap_cnts.R | R --vanilla $frag_bed_file $ref_GR_obj $out_overlap_obj