#!/bin/bash

#paths that need to be set to local system directories:
bwt2_ex_dir=#path to bowtie2 2.2.5 install
bin_dir=#path to where these scripts are placed
samtools_dir=#path to samtools 1.8 install


max_insert_size=1000
min_insert_size=105

fq1=$1 #first input is FASTQ for pair 1 (can be gzipped)
fq2=$2 #second input is FASTQ for pair 2 (can be gzipped)
bwt2_ref=$3 #bowtie2 reference (i.e. HTT locus + E.coli genome in /HTT_locus_and Ecoli_bowtie2_ref)
out_bam=$4 #filename for aligned and read sorted BAM
out_bed_gz=$5 #filename for fragment BED file
num_cores=$6 #number of parallel processes for bowtie2

${bwt2_ex_dir}/bowtie2 -x $bwt2_ref -1 $fq1 -2 $fq2 --phred33 -p $num_cores --no-unal --maxins $max_insert_size | ${samtools_dir}/samtools sort -n - > $out_bam

${samtools_dir}/samtools view $out_bam | ${bin_dir}/create_fragment_bed_from_PE_bam.pl $min_insert_size $max_insert_size | gzip -c > $out_bed_gz
