#!/usr/bin/perl -w
use strict;

if (@ARGV < 4) {print STDERR "$0 <repeats> <class_or_family> <name> <max_millidiv>\n";exit;}

my $MILLIDIV = 2;
my $CHROM = 5;
my $START = 6;
my $STOP = 7;
my $STRAND = 9; 
my $NAME = 10;
my $CLASS = 11;
my $FAMILY = 12;
my $REPSTART = 13;
my $REPEND = 14;
my $REPLEFT = 15;

my $MAX_MILLIDIV = $ARGV[3];

my $TARGET_RPT_GROUP_FIELD = 0;
my $TARGET_RPT_NAME = $ARGV[2];
if ($ARGV[1] =~ /class/i){$TARGET_RPT_GROUP_FIELD = $CLASS;}
elsif ($ARGV[1] =~ /family/i) {$TARGET_RPT_GROUP_FIELD = $FAMILY;}
else {$TARGET_RPT_GROUP_FIELD = $NAME;}

my $linecount = 0;
open (RPT,$ARGV[0]) || die "ERROR opening $ARGV[0]\n";
while (<RPT>)
{
	chomp;
	unless (/^#/)
	{
		my @line = split /\t/,$_;
		if ($line[$TARGET_RPT_GROUP_FIELD] eq $TARGET_RPT_NAME && $line[$MILLIDIV] < $MAX_MILLIDIV)
		{
			my $rpt_start_coord = -1; my $rpt_stop_coord = -1;
			if ($line[$STRAND] eq "+")
			{
				$rpt_start_coord = $line[$REPSTART];
				$rpt_stop_coord = $line[$REPEND];
				my $genomecoord = $line[$START];
				my $genomechr = $line[$CHROM];
				my $divergence = $line[$MILLIDIV]/1000;
				
				for (my $i=$rpt_start_coord; $i<=$rpt_stop_coord; $i++)
				{
					my $tempcoord = $genomecoord + $i - $rpt_start_coord;
					my $tempplusone = $tempcoord + 1;
					print "$genomechr\t$tempcoord\t$tempplusone\t$i\t+\t$divergence\n";
				}
			}
			else
			{
				$rpt_start_coord = $line[$REPLEFT];
				$rpt_stop_coord = $line[$REPEND];			
				my $genomecoord = $line[$START];
				my $genomechr = $line[$CHROM];
				my $divergence = $line[$MILLIDIV]/1000;
				
				for (my $i=$rpt_stop_coord; $i>=$rpt_start_coord; $i--)
				{
					my $tempcoord = $genomecoord + $rpt_stop_coord - $i;
					my $tempplusone = $tempcoord + 1;
					print "$genomechr\t$tempcoord\t$tempplusone\t$i\t-\t$divergence\n";
				}
			}	
		}
	}
	$linecount++;
	if ($linecount % 100000 == 0) {print STDERR "parsed $linecount repeats\n";}
}

#print STDERR "loaded RPTs\n";



