import os
import math
import numpy as np
import sys
import multiprocessing
import pyBigWig

def setGlobalVariables(args):
	
	### input bigwig files
	setInputFiles(args.ctrlbw, args.expbw)
	setOutputDirectory(args.o)
	setBiasFiles(args)
	setFragLen(args.l)
	setAnlaysisRegion(args.r, args.bl)
	setFilterCriteria(args.mi)
	setBinSize(args.binSize)
	setNumProcess(args.p)
	setNormalization(args.norm, args.generateNormBW)

	return


def setInputFiles(ctrlbwFiles, expbwFiles):
	global CTRLBW_NAMES
	global EXPBW_NAMES
	
	global CTRLBW_NUM
	global EXPBW_NUM
	global SAMPLE_NUM

	global COEFCTRL
	global COEFEXP
	global COEFCTRL_HIGHRC
	global COEFEXP_HIGHRC

	global HIGHRC


	CTRLBW_NUM = len(ctrlbwFiles)
	EXPBW_NUM = len(expbwFiles)
	SAMPLE_NUM = int(CTRLBW_NUM + EXPBW_NUM)

	CTRLBW_NAMES = [0] * CTRLBW_NUM
	for i in range(CTRLBW_NUM):
		CTRLBW_NAMES[i] = ctrlbwFiles[i]
	
	EXPBW_NAMES = [0] * EXPBW_NUM
	for i in range(EXPBW_NUM):
		EXPBW_NAMES[i] = expbwFiles[i]


	return


def setOutputDirectory(outputDir):
	global OUTPUT_DIR 

	if(outputDir == None):
		outputDir = os.getcwd() + "/CRADLE_correctionResult"
	
	if(outputDir[-1] == "/"):
		outputDir = outputDir[:-1]

	OUTPUT_DIR = outputDir

	dirExist = os.path.isdir(OUTPUT_DIR)
	if(dirExist == False):
		os.makedirs(OUTPUT_DIR)

	return


def setBiasFiles(args):
	global SHEAR   # indicator variable whether each type of bias will be corrected.
	global PCR
	global MAP
	global GQUAD
	global COVARI_NUM
	global FA
	global COVARI_ORDER

	SHEAR = 0
	PCR = 0
	MAP = 0
	GQUAD = 0

	FA = args.faFile

	COVARI_NUM = 0

	COVARI_ORDER = ['Intercept']

	biasType = [x.lower() for x in args.biasType]

	for i in range(len(biasType)):
		if( (biasType[i] != 'shear') and (biasType[i] != 'pcr') and (biasType[i] != 'map') and (biasType[i] != 'gquad')):
			print("Error! Wrong value in -biasType. Only 'shear', 'pcr', 'map', 'gquad' are allowed")
			sys.exit()


	if('shear' in biasType):
		SHEAR = 1
		COVARI_NUM = COVARI_NUM + 2

		COVARI_ORDER.extend(["MGW_shear", "ProT_shear"])

		global MGW
		global PROT
		global N_MGW
		global N_PROT

		#######  MGW
		MGW = [ ['AAAAA', -1.76850260706379], ['AAAAC', -1.00063188030791], ['AAAAG', -1.351608803132], ['AAAAT', -1.41010500981361],
			['AAACA', -0.608589792531882], ['AAACC', -0.992663710658729], ['AAACG', -0.735195416803445], ['AAACT', -1.17498526745268],
			['AAAGA', -1.02492457287695], ['AAAGC', -1.01676126223779], ['AAAGG', -1.00063188030791], ['AAAGT', -1.82161243237774],
			['AAATA', -1.23382576747562], ['AAATC', -0.946143695023836], ['AAATG', -1.18455471846883], ['AAATT', -4.2195077051761],
			['AACAA', -0.449048264069748], ['AACAC', -0.412845215405787], ['AACAG', -0.458307589482544], ['AACAT', -0.818310323513951],
			['AACCA', -0.798507696217772], ['AACCC', -1.01676126223779], ['AACCG', -0.77908961036067], ['AACCT', -1.39812881876689],
			['AACGA', -0.530628251062171], ['AACGC', -0.614009860001222], ['AACGG', -0.624938930533412], ['AACGT', -0.880185727232039],
			['AACTA', -0.859132318034206], ['AACTC', -1.08401348924696], ['AACTG', -0.699046902687133], ['AACTT', -1.83996157104593],
			['AAGAA', -0.530628251062171], ['AAGAC', -0.608589792531882], ['AAGAG', -0.592503654780258], ['AAGAT', -1.12846525181779],
			['AAGCA', -0.630448586344381], ['AAGCC', -0.908964691782082], ['AAGCG', -0.619459464768786], ['AAGCT', -0.931105817659296],
			['AAGGA', -0.811665780795283], ['AAGGC', -0.687282061107547], ['AAGGG', -0.741349282377823], ['AAGGT', -1.27506872600967],
			['AAGTA', -1.01676126223779], ['AAGTC', -1.2856508353402], ['AAGTG', -0.931105817659296], ['AAGTT', -1.83996157104593],
			['AATAA', -0.219473822425247], ['AATAC', -0.307484699747961], ['AATAG', -0.608589792531882], ['AATAT', -0.530628251062171],
			['AATCA', -0.716957829253664], ['AATCC', -0.894471684479515], ['AATCG', -0.658461622572055], ['AATCT', -1.27506872600967],
			['AATGA', -0.716957829253664], ['AATGC', -0.486611365645396], ['AATGG', -0.399599988655766], ['AATGT', -0.838513030831471],
			['AATTA', -0.77908961036067], ['AATTC', -1.27506872600967], ['AATTG', -0.859132318034206], ['AATTT', -4.2195077051761],
			['ACAAA', -0.344148684119552], ['ACAAC', -0.20132450391957], ['ACAAG', -0.352482065678696], ['ACAAT', -0.421773846150088],
			['ACACA', -0.230523658611832], ['ACACC', -0.303492678478423], ['ACACG', -0.241696959209958], ['ACACT', -0.390866308687012],
			['ACAGA', -0.295556128882687], ['ACAGC', -0.303492678478423], ['ACAGG', -0.3114927211455], ['ACAGT', -0.348306694268216],
			['ACATA', -0.373624502252506], ['ACATC', -0.520677920209002], ['ACATG', -0.439873887793706], ['ACATT', -0.838513030831471],
			['ACCAA', -0.399599988655766], ['ACCAC', -0.27598603268859], ['ACCAG', -0.352482065678696], ['ACCAT', -0.449048264069748],
			['ACCCA', -0.603198943897006], ['ACCCC', -0.647162067318122], ['ACCCG', -0.581921545449721], ['ACCCT', -0.824999311664748],
			['ACCGA', -0.426268235737928], ['ACCGC', -0.399599988655766], ['ACCGG', -0.365113812584597], ['ACCGT', -0.566255428705321],
			['ACCTA', -0.592503654780258], ['ACCTC', -0.772699812261899], ['ACCTG', -0.669890318395678], ['ACCTT', -1.27506872600967],
			['ACGAA', -0.344148684119552], ['ACGAC', -0.291611350591671], ['ACGAG', -0.377907164044507], ['ACGAT', -0.530628251062171],
			['ACGCA', -0.31955728098223], ['ACGCC', -0.399599988655766], ['ACGCG', -0.348306694268216], ['ACGCT', -0.501069448820626],
			['ACGGA', -0.408410618337921], ['ACGGC', -0.399599988655766], ['ACGGG', -0.472359342938195], ['ACGGT', -0.566255428705321],
			['ACGTA', -0.510825623765991], ['ACGTC', -0.581921545449721], ['ACGTG', -0.505935638471799], ['ACGTT', -0.880185727232039],
			['ACTAA', -0.14877300859314], ['ACTAC', -0.187038546672093], ['ACTAG', -0.377907164044507], ['ACTAT', -0.501069448820626],
			['ACTCA', -0.486611365645396], ['ACTCC', -0.566255428705321], ['ACTCG', -0.467653451900782], ['ACTCT', -0.501069448820626],
			['ACTGA', -0.23795863709935], ['ACTGC', -0.268263986594679], ['ACTGG', -0.299516530098784], ['ACTGT', -0.348306694268216],
			['ACTTA', -0.704981638206948], ['ACTTC', -0.811665780795283], ['ACTTG', -0.681451140796754], ['ACTTT', -1.82161243237774],
			['AGAAA', -0.561087458546879], ['AGAAC', -0.505935638471799], ['AGAAG', -0.693147180559945], ['AGAAT', -0.735195416803445],
			['AGACA', -0.439873887793706], ['AGACC', -0.566255428705321], ['AGACG', -0.51573963856842], ['AGACT', -0.652795885036378],
			['AGAGA', -0.435318071257845], ['AGAGC', -0.417299565755167], ['AGAGG', -0.449048264069748], ['AGAGT', -0.501069448820626],
			['AGATA', -0.571450245582426], ['AGATC', -0.77908961036067], ['AGATG', -0.603198943897006], ['AGATT', -1.27506872600967],
			['AGCAA', -0.399599988655766], ['AGCAC', -0.256791585432443], ['AGCAG', -0.365113812584597], ['AGCAT', -0.335884174269658],
			['AGCCA', -0.675654023112428], ['AGCCC', -0.630448586344381], ['AGCCG', -0.51573963856842], ['AGCCT', -0.798507696217772],
			['AGCGA', -0.352482065678696], ['AGCGC', -0.356674943938733], ['AGCGG', -0.369360103466048], ['AGCGT', -0.501069448820626],
			['AGCTA', -0.491407537908889], ['AGCTC', -0.619459464768786], ['AGCTG', -0.530628251062171], ['AGCTT', -0.931105817659296],
			['AGGAA', -0.55083095837969], ['AGGAC', -0.525640709551132], ['AGGAG', -0.619459464768786], ['AGGAT', -0.687282061107547],
			['AGGCA', -0.520677920209002], ['AGGCC', -0.571450245582426], ['AGGCG', -0.545741888872219], ['AGGCT', -0.798507696217772],
			['AGGGA', -0.592503654780258], ['AGGGC', -0.566255428705321], ['AGGGG', -0.624938930533412], ['AGGGT', -0.824999311664748],
			['AGGTA', -0.798507696217772], ['AGGTC', -0.901691932453002], ['AGGTG', -0.741349282377823], ['AGGTT', -1.39812881876689],
			['AGTAA', -0.279869532714987], ['AGTAC', -0.215817511222137], ['AGTAG', -0.348306694268216], ['AGTAT', -0.279869532714987],
			['AGTCA', -0.486611365645396], ['AGTCC', -0.687282061107547], ['AGTCG', -0.641559811769452], ['AGTCT', -0.652795885036378],
			['AGTGA', -0.340007891453521], ['AGTGC', -0.307484699747961], ['AGTGG', -0.303492678478423], ['AGTGT', -0.390866308687012],
			['AGTTA', -0.597837000755621], ['AGTTC', -0.852211875189633], ['AGTTG', -0.76635058458324], ['AGTTT', -1.17498526745268],
			['ATAAA', -0.172953806790354], ['ATAAC', -0.187038546672093], ['ATAAG', -0.23795863709935], ['ATAAT', -0.315516871445225],
			['ATACA', -0.118518600235337], ['ATACC', -0.245449308828508], ['ATACG', -0.219473822425247], ['ATACT', -0.279869532714987],
			['ATAGA', -0.162518929497775], ['ATAGC', -0.279869532714987], ['ATAGG', -0.194156014440958], ['ATAGT', -0.501069448820626],
			['ATATA', -0.138586163286147], ['ATATC', -0.268263986594679], ['ATATG', -0.299516530098784], ['ATATT', -0.530628251062171],
			['ATCAA', -0.22314355131421], ['ATCAC', -0.287682072451781], ['ATCAG', -0.291611350591671], ['ATCAT', -0.535640792885715],
			['ATCCA', -0.462969602588355], ['ATCCC', -0.525640709551132], ['ATCCG', -0.710951805193452], ['ATCCT', -0.687282061107547],
			['ATCGA', -0.335884174269658], ['ATCGC', -0.315516871445225], ['ATCGG', -0.32768740706548], ['ATCGT', -0.530628251062171],
			['ATCTA', -0.561087458546879], ['ATCTC', -0.561087458546879], ['ATCTG', -0.444450554821118], ['ATCTT', -1.12846525181779],
			['ATGAA', -0.230523658611832], ['ATGAC', -0.249215791623985], ['ATGAG', -0.335884174269658], ['ATGAT', -0.535640792885715],
			['ATGCA', -0.212174519943636], ['ATGCC', -0.295556128882687], ['ATGCG', -0.194156014440958], ['ATGCT', -0.335884174269658],
			['ATGGA', -0.291611350591671], ['ATGGC', -0.335884174269658], ['ATGGG', -0.352482065678696], ['ATGGT', -0.449048264069748],
			['ATGTA', -0.31955728098223], ['ATGTC', -0.426268235737928], ['ATGTG', -0.369360103466048], ['ATGTT', -0.818310323513951],
			['ATTAA', -0.20132450391957], ['ATTAC', -0.252996514463891], ['ATTAG', -0.204928111422868], ['ATTAT', -0.315516871445225],
			['ATTCA', -0.340007891453521], ['ATTCC', -0.587198602550564], ['ATTCG', -0.491407537908889], ['ATTCT', -0.735195416803445],
			['ATTGA', -0.245449308828508], ['ATTGC', -0.369360103466048], ['ATTGG', -0.307484699747961], ['ATTGT', -0.421773846150088],
			['ATTTA', -0.55594605904646], ['ATTTC', -0.838513030831471], ['ATTTG', -0.946143695023836], ['ATTTT', -1.41010500981361],
			['CAAAA', -0.55083095837969], ['CAAAC', -0.458307589482544], ['CAAAG', -0.681451140796754], ['CAAAT', -0.946143695023836],
			['CAACA', -0.331777392317005], ['CAACC', -0.520677920209002], ['CAACG', -0.444450554821118], ['CAACT', -0.76635058458324],
			['CAAGA', -0.472359342938195], ['CAAGC', -0.462969602588355], ['CAAGG', -0.608589792531882], ['CAAGT', -0.681451140796754],
			['CAATA', -0.426268235737928], ['CAATC', -0.525640709551132], ['CAATG', -0.587198602550564], ['CAATT', -0.859132318034206],
			['CACAA', -0.348306694268216], ['CACAC', -0.14877300859314], ['CACAG', -0.299516530098784], ['CACAT', -0.369360103466048],
			['CACCA', -0.510825623765991], ['CACCC', -0.545741888872219], ['CACCG', -0.472359342938195], ['CACCT', -0.741349282377823],
			['CACGA', -0.3114927211455], ['CACGC', -0.32768740706548], ['CACGG', -0.390866308687012], ['CACGT', -0.505935638471799],
			['CACTA', -0.386527907088414], ['CACTC', -0.540678586915672], ['CACTG', -0.444450554821118], ['CACTT', -0.931105817659296],
			['CAGAA', -0.373624502252506], ['CAGAC', -0.340007891453521], ['CAGAG', -0.373624502252506], ['CAGAT', -0.444450554821118],
			['CAGCA', -0.31955728098223], ['CAGCC', -0.458307589482544], ['CAGCG', -0.377907164044507], ['CAGCT', -0.530628251062171],
			['CAGGA', -0.472359342938195], ['CAGGC', -0.462969602588355], ['CAGGG', -0.505935638471799], ['CAGGT', -0.669890318395678],
			['CAGTA', -0.377907164044507], ['CAGTC', -0.435318071257845], ['CAGTG', -0.444450554821118], ['CAGTT', -0.699046902687133],
			['CATAA', -0.0543940720657989], ['CATAC', -0.082742427070054], ['CATAG', -0.219473822425247], ['CATAT', -0.299516530098784],
			['CATCA', -0.340007891453521], ['CATCC', -0.510825623765991], ['CATCG', -0.462969602588355], ['CATCT', -0.603198943897006],
			['CATGA', -0.31955728098223], ['CATGC', -0.230523658611832], ['CATGG', -0.291611350591671], ['CATGT', -0.439873887793706],
			['CATTA', -0.481838086892738], ['CATTC', -0.760041415389976], ['CATTG', -0.587198602550564], ['CATTT', -1.18455471846883],
			['CCAAA', -0.26060111384911], ['CCAAC', -0.26060111384911], ['CCAAG', -0.303492678478423], ['CCAAT', -0.307484699747961],
			['CCACA', -0.125163142954006], ['CCACC', -0.208544751893057], ['CCACG', -0.179971379449001], ['CCACT', -0.303492678478423],
			['CCAGA', -0.208544751893057], ['CCAGC', -0.219473822425247], ['CCAGG', -0.268263986594679], ['CCAGT', -0.299516530098784],
			['CCATA', -0.0988458346366327], ['CCATC', -0.219473822425247], ['CCATG', -0.291611350591671], ['CCATT', -0.399599988655766],
			['CCCAA', -0.252996514463891], ['CCCAC', -0.264425210287514], ['CCCAG', -0.27211755591067], ['CCCAT', -0.352482065678696],
			['CCCCA', -0.486611365645396], ['CCCCC', -0.55594605904646], ['CCCCG', -0.462969602588355], ['CCCCT', -0.624938930533412],
			['CCCGA', -0.340007891453521], ['CCCGC', -0.307484699747961], ['CCCGG', -0.352482065678696], ['CCCGT', -0.472359342938195],
			['CCCTA', -0.439873887793706], ['CCCTC', -0.540678586915672], ['CCCTG', -0.505935638471799], ['CCCTT', -0.741349282377823],
			['CCGAA', -0.27598603268859], ['CCGAC', -0.215817511222137], ['CCGAG', -0.176456437341557], ['CCGAT', -0.32768740706548],
			['CCGCA', -0.197733835788841], ['CCGCC', -0.3114927211455], ['CCGCG', -0.226826796730506], ['CCGCT', -0.369360103466048],
			['CCGGA', -0.27211755591067], ['CCGGC', -0.283768173130644], ['CCGGG', -0.352482065678696], ['CCGGT', -0.365113812584597],
			['CCGTA', -0.295556128882687], ['CCGTC', -0.390866308687012], ['CCGTG', -0.390866308687012], ['CCGTT', -0.624938930533412],
			['CCTAA', -0.073203404023295], ['CCTAC', -0.138586163286147], ['CCTAG', -0.162518929497775], ['CCTAT', -0.194156014440958],
			['CCTCA', -0.307484699747961], ['CCTCC', -0.467653451900782], ['CCTCG', -0.356674943938733], ['CCTCT', -0.449048264069748],
			['CCTGA', -0.241696959209958], ['CCTGC', -0.22314355131421], ['CCTGG', -0.268263986594679], ['CCTGT', -0.3114927211455],
			['CCTTA', -0.525640709551132], ['CCTTC', -0.619459464768786], ['CCTTG', -0.608589792531882], ['CCTTT', -1.00063188030791],
			['CGAAA', -0.444450554821118], ['CGAAC', -0.390866308687012], ['CGAAG', -0.472359342938195], ['CGAAT', -0.491407537908889],
			['CGACA', -0.315516871445225], ['CGACC', -0.520677920209002], ['CGACG', -0.352482065678696], ['CGACT', -0.641559811769452],
			['CGAGA', -0.360885476475076], ['CGAGC', -0.348306694268216], ['CGAGG', -0.356674943938733], ['CGAGT', -0.467653451900782],
			['CGATA', -0.299516530098784], ['CGATC', -0.453667209926042], ['CGATG', -0.462969602588355], ['CGATT', -0.658461622572055],
			['CGCAA', -0.121835352861332], ['CGCAC', -0.0988458346366327], ['CGCAG', -0.169463401850586], ['CGCAT', -0.194156014440958],
			['CGCCA', -0.408410618337921], ['CGCCC', -0.453667209926042], ['CGCCG', -0.395223614055968], ['CGCCT', -0.545741888872219],
			['CGCGA', -0.26060111384911], ['CGCGC', -0.215817511222137], ['CGCGG', -0.226826796730506], ['CGCGT', -0.348306694268216],
			['CGCTA', -0.340007891453521], ['CGCTC', -0.426268235737928], ['CGCTG', -0.377907164044507], ['CGCTT', -0.619459464768786],
			['CGGAA', -0.395223614055968], ['CGGAC', -0.399599988655766], ['CGGAG', -0.430782916092454], ['CGGAT', -0.710951805193452],
			['CGGCA', -0.360885476475076], ['CGGCC', -0.453667209926042], ['CGGCG', -0.395223614055968], ['CGGCT', -0.51573963856842],
			['CGGGA', -0.458307589482544], ['CGGGC', -0.458307589482544], ['CGGGG', -0.462969602588355], ['CGGGT', -0.581921545449721],
			['CGGTA', -0.453667209926042], ['CGGTC', -0.587198602550564], ['CGGTG', -0.472359342938195], ['CGGTT', -0.77908961036067],
			['CGTAA', -0.0268272422331441], ['CGTAC', -0.082742427070054], ['CGTAG', -0.135213478807508], ['CGTAT', -0.219473822425247],
			['CGTCA', -0.27211755591067], ['CGTCC', -0.426268235737928], ['CGTCG', -0.352482065678696], ['CGTCT', -0.51573963856842],
			['CGTGA', -0.155622350438715], ['CGTGC', -0.145365850271525], ['CGTGG', -0.179971379449001], ['CGTGT', -0.241696959209958],
			['CGTTA', -0.369360103466048], ['CGTTC', -0.561087458546879], ['CGTTG', -0.444450554821118], ['CGTTT', -0.735195416803445],
			['CTAAA', -0.118518600235337], ['CTAAC', -0.125163142954006], ['CTAAG', -0.234234238008368], ['CTAAT', -0.204928111422868],
			['CTACA', -0.145365850271525], ['CTACC', -0.212174519943636], ['CTACG', -0.135213478807508], ['CTACT', -0.348306694268216],
			['CTAGA', -0.111917916203985], ['CTAGC', -0.169463401850586], ['CTAGG', -0.162518929497775], ['CTAGT', -0.377907164044507],
			['CTATA', -0.128502044219521], ['CTATC', -0.215817511222137], ['CTATG', -0.219473822425247], ['CTATT', -0.608589792531882],
			['CTCAA', -0.092373320131015], ['CTCAC', -0.125163142954006], ['CTCAG', -0.208544751893057], ['CTCAT', -0.335884174269658],
			['CTCCA', -0.426268235737928], ['CTCCC', -0.505935638471799], ['CTCCG', -0.430782916092454], ['CTCCT', -0.619459464768786],
			['CTCGA', -0.26060111384911], ['CTCGC', -0.245449308828508], ['CTCGG', -0.176456437341557], ['CTCGT', -0.377907164044507],
			['CTCTA', -0.264425210287514], ['CTCTC', -0.467653451900782], ['CTCTG', -0.373624502252506], ['CTCTT', -0.592503654780258],
			['CTGAA', -0.082742427070054], ['CTGAC', -0.169463401850586], ['CTGAG', -0.208544751893057], ['CTGAT', -0.291611350591671],
			['CTGCA', -0.128502044219521], ['CTGCC', -0.264425210287514], ['CTGCG', -0.169463401850586], ['CTGCT', -0.365113812584597],
			['CTGGA', -0.303492678478423], ['CTGGC', -0.256791585432443], ['CTGGG', -0.27211755591067], ['CTGGT', -0.352482065678696],
			['CTGTA', -0.264425210287514], ['CTGTC', -0.323614081677844], ['CTGTG', -0.299516530098784], ['CTGTT', -0.458307589482544],
			['CTTAA', -0.20132450391957], ['CTTAC', -0.187038546672093], ['CTTAG', -0.234234238008368], ['CTTAT', -0.23795863709935],
			['CTTCA', -0.369360103466048], ['CTTCC', -0.619459464768786], ['CTTCG', -0.472359342938195], ['CTTCT', -0.693147180559945],
			['CTTGA', -0.268263986594679], ['CTTGC', -0.249215791623985], ['CTTGG', -0.303492678478423], ['CTTGT', -0.352482065678696],
			['CTTTA', -0.581921545449721], ['CTTTC', -0.77908961036067], ['CTTTG', -0.681451140796754], ['CTTTT', -1.351608803132],
			['GAAAA', -0.785520500690961], ['GAAAC', -0.561087458546879], ['GAAAG', -0.77908961036067], ['GAAAT', -0.838513030831471],
			['GAACA', -0.505935638471799], ['GAACC', -0.716957829253664], ['GAACG', -0.561087458546879], ['GAACT', -0.852211875189633],
			['GAAGA', -0.681451140796754], ['GAAGC', -0.520677920209002], ['GAAGG', -0.619459464768786], ['GAAGT', -0.811665780795283],
			['GAATA', -0.687282061107547], ['GAATC', -0.77908961036067], ['GAATG', -0.760041415389976], ['GAATT', -1.27506872600967],
			['GACAA', -0.204928111422868], ['GACAC', -0.234234238008368], ['GACAG', -0.323614081677844], ['GACAT', -0.426268235737928],
			['GACCA', -0.510825623765991], ['GACCC', -0.723000143709626], ['GACCG', -0.587198602550564], ['GACCT', -0.901691932453002],
			['GACGA', -0.365113812584597], ['GACGC', -0.395223614055968], ['GACGG', -0.390866308687012], ['GACGT', -0.581921545449721],
			['GACTA', -0.399599988655766], ['GACTC', -0.675654023112428], ['GACTG', -0.435318071257845], ['GACTT', -1.2856508353402],
			['GAGAA', -0.597837000755621], ['GAGAC', -0.417299565755167], ['GAGAG', -0.467653451900782], ['GAGAT', -0.561087458546879],
			['GAGCA', -0.390866308687012], ['GAGCC', -0.597837000755621], ['GAGCG', -0.426268235737928], ['GAGCT', -0.619459464768786],
			['GAGGA', -0.530628251062171], ['GAGGC', -0.505935638471799], ['GAGGG', -0.540678586915672], ['GAGGT', -0.772699812261899],
			['GAGTA', -0.587198602550564], ['GAGTC', -0.675654023112428], ['GAGTG', -0.540678586915672], ['GAGTT', -1.08401348924696],
			['GATAA', -0.0956043407124617], ['GATAC', -0.176456437341557], ['GATAG', -0.215817511222137], ['GATAT', -0.268263986594679],
			['GATCA', -0.545741888872219], ['GATCC', -0.619459464768786], ['GATCG', -0.453667209926042], ['GATCT', -0.77908961036067],
			['GATGA', -0.399599988655766], ['GATGC', -0.27598603268859], ['GATGG', -0.219473822425247], ['GATGT', -0.520677920209002],
			['GATTA', -0.525640709551132], ['GATTC', -0.77908961036067], ['GATTG', -0.525640709551132], ['GATTT', -0.946143695023836],
			['GCAAA', -0.264425210287514], ['GCAAC', -0.159064694629687], ['GCAAG', -0.249215791623985], ['GCAAT', -0.369360103466048],
			['GCACA', -0.0795526317019536], ['GCACC', -0.208544751893057], ['GCACG', -0.145365850271525], ['GCACT', -0.307484699747961],
			['GCAGA', -0.141970261270387], ['GCAGC', -0.169463401850586], ['GCAGG', -0.22314355131421], ['GCAGT', -0.268263986594679],
			['GCATA', -0.138586163286147], ['GCATC', -0.27598603268859], ['GCATG', -0.230523658611832], ['GCATT', -0.486611365645396],
			['GCCAA', -0.208544751893057], ['GCCAC', -0.245449308828508], ['GCCAG', -0.256791585432443], ['GCCAT', -0.335884174269658],
			['GCCCA', -0.453667209926042], ['GCCCC', -0.520677920209002], ['GCCCG', -0.458307589482544], ['GCCCT', -0.566255428705321],
			['GCCGA', -0.256791585432443], ['GCCGC', -0.279869532714987], ['GCCGG', -0.283768173130644], ['GCCGT', -0.399599988655766],
			['GCCTA', -0.449048264069748], ['GCCTC', -0.505935638471799], ['GCCTG', -0.462969602588355], ['GCCTT', -0.687282061107547],
			['GCGAA', -0.219473822425247], ['GCGAC', -0.208544751893057], ['GCGAG', -0.245449308828508], ['GCGAT', -0.315516871445225],
			['GCGCA', -0.155622350438715], ['GCGCC', -0.264425210287514], ['GCGCG', -0.215817511222137], ['GCGCT', -0.356674943938733],
			['GCGGA', -0.31955728098223], ['GCGGC', -0.279869532714987], ['GCGGG', -0.307484699747961], ['GCGGT', -0.399599988655766],
			['GCGTA', -0.299516530098784], ['GCGTC', -0.395223614055968], ['GCGTG', -0.32768740706548], ['GCGTT', -0.614009860001222],
			['GCTAA', -0.118518600235337], ['GCTAC', -0.0988458346366327], ['GCTAG', -0.169463401850586], ['GCTAT', -0.279869532714987],
			['GCTCA', -0.268263986594679], ['GCTCC', -0.412845215405787], ['GCTCG', -0.348306694268216], ['GCTCT', -0.417299565755167],
			['GCTGA', -0.145365850271525], ['GCTGC', -0.169463401850586], ['GCTGG', -0.219473822425247], ['GCTGT', -0.303492678478423],
			['GCTTA', -0.430782916092454], ['GCTTC', -0.520677920209002], ['GCTTG', -0.462969602588355], ['GCTTT', -1.01676126223779],
			['GGAAA', -0.619459464768786], ['GGAAC', -0.510825623765991], ['GGAAG', -0.619459464768786], ['GGAAT', -0.587198602550564],
			['GGACA', -0.426268235737928], ['GGACC', -0.530628251062171], ['GGACG', -0.426268235737928], ['GGACT', -0.687282061107547],
			['GGAGA', -0.472359342938195], ['GGAGC', -0.412845215405787], ['GGAGG', -0.467653451900782], ['GGAGT', -0.566255428705321],
			['GGATA', -0.444450554821118], ['GGATC', -0.619459464768786], ['GGATG', -0.510825623765991], ['GGATT', -0.894471684479515],
			['GGCAA', -0.307484699747961], ['GGCAC', -0.172953806790354], ['GGCAG', -0.264425210287514], ['GGCAT', -0.295556128882687],
			['GGCCA', -0.467653451900782], ['GGCCC', -0.545741888872219], ['GGCCG', -0.453667209926042], ['GGCCT', -0.571450245582426],
			['GGCGA', -0.268263986594679], ['GGCGC', -0.264425210287514], ['GGCGG', -0.3114927211455], ['GGCGT', -0.399599988655766],
			['GGCTA', -0.435318071257845], ['GGCTC', -0.597837000755621], ['GGCTG', -0.458307589482544], ['GGCTT', -0.908964691782082],
			['GGGAA', -0.566255428705321], ['GGGAC', -0.481838086892738], ['GGGAG', -0.505935638471799], ['GGGAT', -0.525640709551132],
			['GGGCA', -0.426268235737928], ['GGGCC', -0.545741888872219], ['GGGCG', -0.453667209926042], ['GGGCT', -0.630448586344381],
			['GGGGA', -0.55083095837969], ['GGGGC', -0.520677920209002], ['GGGGG', -0.55594605904646], ['GGGGT', -0.647162067318122],
			['GGGTA', -0.576672189563577], ['GGGTC', -0.723000143709626], ['GGGTG', -0.545741888872219], ['GGGTT', -1.01676126223779],
			['GGTAA', -0.256791585432443], ['GGTAC', -0.111917916203985], ['GGTAG', -0.212174519943636], ['GGTAT', -0.245449308828508],
			['GGTCA', -0.462969602588355], ['GGTCC', -0.530628251062171], ['GGTCG', -0.520677920209002], ['GGTCT', -0.566255428705321],
			['GGTGA', -0.268263986594679], ['GGTGC', -0.208544751893057], ['GGTGG', -0.208544751893057], ['GGTGT', -0.303492678478423],
			['GGTTA', -0.496226824344838], ['GGTTC', -0.716957829253664], ['GGTTG', -0.520677920209002], ['GGTTT', -0.992663710658729],
			['GTAAA', -0.089152705430973], ['GTAAC', -0.105360515657826], ['GTAAG', -0.187038546672093], ['GTAAT', -0.252996514463891],
			['GTACA', 0.0], ['GTACC', -0.111917916203985], ['GTACG', -0.082742427070054], ['GTACT', -0.215817511222137],
			['GTAGA', -0.138586163286147], ['GTAGC', -0.0988458346366327], ['GTAGG', -0.138586163286147], ['GTAGT', -0.187038546672093],
			['GTATA', -0.0575044944801913], ['GTATC', -0.176456437341557], ['GTATG', -0.082742427070054], ['GTATT', -0.307484699747961],
			['GTCAA', -0.089152705430973], ['GTCAC', -0.0575044944801913], ['GTCAG', -0.169463401850586], ['GTCAT', -0.249215791623985],
			['GTCCA', -0.352482065678696], ['GTCCC', -0.481838086892738], ['GTCCG', -0.399599988655766], ['GTCCT', -0.525640709551132],
			['GTCGA', -0.179971379449001], ['GTCGC', -0.208544751893057], ['GTCGG', -0.215817511222137], ['GTCGT', -0.291611350591671],
			['GTCTA', -0.299516530098784], ['GTCTC', -0.417299565755167], ['GTCTG', -0.340007891453521], ['GTCTT', -0.608589792531882],
			['GTGAA', -0.0795526317019536], ['GTGAC', -0.0575044944801913], ['GTGAG', -0.125163142954006], ['GTGAT', -0.287682072451781],
			['GTGCA', -0.0795526317019536], ['GTGCC', -0.172953806790354], ['GTGCG', -0.0988458346366327], ['GTGCT', -0.256791585432443],
			['GTGGA', -0.20132450391957], ['GTGGC', -0.245449308828508], ['GTGGG', -0.264425210287514], ['GTGGT', -0.27598603268859],
			['GTGTA', -0.145365850271525], ['GTGTC', -0.234234238008368], ['GTGTG', -0.14877300859314], ['GTGTT', -0.412845215405787],
			['GTTAA', -0.108633841002796], ['GTTAC', -0.105360515657826], ['GTTAG', -0.125163142954006], ['GTTAT', -0.187038546672093],
			['GTTCA', -0.287682072451781], ['GTTCC', -0.510825623765991], ['GTTCG', -0.390866308687012], ['GTTCT', -0.505935638471799],
			['GTTGA', -0.176456437341557], ['GTTGC', -0.159064694629687], ['GTTGG', -0.26060111384911], ['GTTGT', -0.20132450391957],
			['GTTTA', -0.390866308687012], ['GTTTC', -0.561087458546879], ['GTTTG', -0.458307589482544], ['GTTTT', -1.00063188030791],
			['TAAAA', -0.486611365645396], ['TAAAC', -0.390866308687012], ['TAAAG', -0.581921545449721], ['TAAAT', -0.55594605904646],
			['TAACA', -0.360885476475076], ['TAACC', -0.496226824344838], ['TAACG', -0.369360103466048], ['TAACT', -0.597837000755621],
			['TAAGA', -0.467653451900782], ['TAAGC', -0.430782916092454], ['TAAGG', -0.525640709551132], ['TAAGT', -0.704981638206948],
			['TAATA', -0.386527907088414], ['TAATC', -0.525640709551132], ['TAATG', -0.481838086892738], ['TAATT', -0.77908961036067],
			['TACAA', -0.0956043407124617], ['TACAC', -0.145365850271525], ['TACAG', -0.264425210287514], ['TACAT', -0.31955728098223],
			['TACCA', -0.377907164044507], ['TACCC', -0.576672189563577], ['TACCG', -0.453667209926042], ['TACCT', -0.798507696217772],
			['TACGA', -0.190590948276461], ['TACGC', -0.299516530098784], ['TACGG', -0.295556128882687], ['TACGT', -0.510825623765991],
			['TACTA', -0.295556128882687], ['TACTC', -0.587198602550564], ['TACTG', -0.377907164044507], ['TACTT', -1.01676126223779],
			['TAGAA', -0.295556128882687], ['TAGAC', -0.299516530098784], ['TAGAG', -0.264425210287514], ['TAGAT', -0.561087458546879],
			['TAGCA', -0.283768173130644], ['TAGCC', -0.435318071257845], ['TAGCG', -0.340007891453521], ['TAGCT', -0.491407537908889],
			['TAGGA', -0.444450554821118], ['TAGGC', -0.449048264069748], ['TAGGG', -0.439873887793706], ['TAGGT', -0.592503654780258],
			['TAGTA', -0.295556128882687], ['TAGTC', -0.399599988655766], ['TAGTG', -0.386527907088414], ['TAGTT', -0.859132318034206],
			['TATAA', -0.0389854467129537], ['TATAC', -0.0575044944801913], ['TATAG', -0.128502044219521], ['TATAT', -0.138586163286147],
			['TATCA', -0.27598603268859], ['TATCC', -0.444450554821118], ['TATCG', -0.299516530098784], ['TATCT', -0.571450245582426],
			['TATGA', -0.111917916203985], ['TATGC', -0.138586163286147], ['TATGG', -0.0988458346366327], ['TATGT', -0.373624502252506],
			['TATTA', -0.386527907088414], ['TATTC', -0.687282061107547], ['TATTG', -0.426268235737928], ['TATTT', -1.23382576747562],
			['TCAAA', -0.194156014440958], ['TCAAC', -0.176456437341557], ['TCAAG', -0.268263986594679], ['TCAAT', -0.245449308828508],
			['TCACA', -0.111917916203985], ['TCACC', -0.268263986594679], ['TCACG', -0.155622350438715], ['TCACT', -0.340007891453521],
			['TCAGA', -0.241696959209958], ['TCAGC', -0.145365850271525], ['TCAGG', -0.241696959209958], ['TCAGT', -0.23795863709935],
			['TCATA', -0.111917916203985], ['TCATC', -0.399599988655766], ['TCATG', -0.31955728098223], ['TCATT', -0.716957829253664],
			['TCCAA', -0.26060111384911], ['TCCAC', -0.20132450391957], ['TCCAG', -0.303492678478423], ['TCCAT', -0.291611350591671],
			['TCCCA', -0.467653451900782], ['TCCCC', -0.55083095837969], ['TCCCG', -0.458307589482544], ['TCCCT', -0.592503654780258],
			['TCCGA', -0.283768173130644], ['TCCGC', -0.31955728098223], ['TCCGG', -0.27211755591067], ['TCCGT', -0.408410618337921],
			['TCCTA', -0.444450554821118], ['TCCTC', -0.530628251062171], ['TCCTG', -0.472359342938195], ['TCCTT', -0.811665780795283],
			['TCGAA', -0.141970261270387], ['TCGAC', -0.179971379449001], ['TCGAG', -0.26060111384911], ['TCGAT', -0.335884174269658],
			['TCGCA', -0.165985137474261], ['TCGCC', -0.268263986594679], ['TCGCG', -0.26060111384911], ['TCGCT', -0.352482065678696],
			['TCGGA', -0.283768173130644], ['TCGGC', -0.256791585432443], ['TCGGG', -0.340007891453521], ['TCGGT', -0.426268235737928],
			['TCGTA', -0.190590948276461], ['TCGTC', -0.365113812584597], ['TCGTG', -0.3114927211455], ['TCGTT', -0.530628251062171],
			['TCTAA', -0.0606246218164349], ['TCTAC', -0.138586163286147], ['TCTAG', -0.111917916203985], ['TCTAT', -0.162518929497775],
			['TCTCA', -0.3114927211455], ['TCTCC', -0.472359342938195], ['TCTCG', -0.360885476475076], ['TCTCT', -0.435318071257845],
			['TCTGA', -0.241696959209958], ['TCTGC', -0.141970261270387], ['TCTGG', -0.208544751893057], ['TCTGT', -0.295556128882687],
			['TCTTA', -0.467653451900782], ['TCTTC', -0.681451140796754], ['TCTTG', -0.472359342938195], ['TCTTT', -1.02492457287695],
			['TGAAA', -0.268263986594679], ['TGAAC', -0.287682072451781], ['TGAAG', -0.369360103466048], ['TGAAT', -0.340007891453521],
			['TGACA', -0.256791585432443], ['TGACC', -0.462969602588355], ['TGACG', -0.27211755591067], ['TGACT', -0.486611365645396],
			['TGAGA', -0.3114927211455], ['TGAGC', -0.268263986594679], ['TGAGG', -0.307484699747961], ['TGAGT', -0.486611365645396],
			['TGATA', -0.27598603268859], ['TGATC', -0.545741888872219], ['TGATG', -0.340007891453521], ['TGATT', -0.716957829253664],
			['TGCAA', -0.131852131104803], ['TGCAC', -0.0795526317019536], ['TGCAG', -0.128502044219521], ['TGCAT', -0.212174519943636],
			['TGCCA', -0.331777392317005], ['TGCCC', -0.426268235737928], ['TGCCG', -0.360885476475076], ['TGCCT', -0.520677920209002],
			['TGCGA', -0.165985137474261], ['TGCGC', -0.155622350438715], ['TGCGG', -0.197733835788841], ['TGCGT', -0.31955728098223],
			['TGCTA', -0.283768173130644], ['TGCTC', -0.390866308687012], ['TGCTG', -0.31955728098223], ['TGCTT', -0.630448586344381],
			['TGGAA', -0.449048264069748], ['TGGAC', -0.352482065678696], ['TGGAG', -0.426268235737928], ['TGGAT', -0.462969602588355],
			['TGGCA', -0.331777392317005], ['TGGCC', -0.467653451900782], ['TGGCG', -0.408410618337921], ['TGGCT', -0.675654023112428],
			['TGGGA', -0.467653451900782], ['TGGGC', -0.453667209926042], ['TGGGG', -0.486611365645396], ['TGGGT', -0.603198943897006],
			['TGGTA', -0.377907164044507], ['TGGTC', -0.510825623765991], ['TGGTG', -0.510825623765991], ['TGGTT', -0.798507696217772],
			['TGTAA', -0.0637545148253625], ['TGTAC', 0.0], ['TGTAG', -0.145365850271525], ['TGTAT', -0.118518600235337],
			['TGTCA', -0.256791585432443], ['TGTCC', -0.426268235737928], ['TGTCG', -0.315516871445225], ['TGTCT', -0.439873887793706],
			['TGTGA', -0.111917916203985], ['TGTGC', -0.0795526317019536], ['TGTGG', -0.125163142954006], ['TGTGT', -0.230523658611832],
			['TGTTA', -0.360885476475076], ['TGTTC', -0.505935638471799], ['TGTTG', -0.331777392317005], ['TGTTT', -0.608589792531882],
			['TTAAA', -0.14877300859314], ['TTAAC', -0.108633841002796], ['TTAAG', -0.20132450391957], ['TTAAT', -0.20132450391957],
			['TTACA', -0.0637545148253625], ['TTACC', -0.256791585432443], ['TTACG', -0.0268272422331441], ['TTACT', -0.279869532714987],
			['TTAGA', -0.0606246218164349], ['TTAGC', -0.118518600235337], ['TTAGG', -0.073203404023295], ['TTAGT', -0.14877300859314],
			['TTATA', -0.0389854467129537], ['TTATC', -0.0956043407124617], ['TTATG', -0.0543940720657989], ['TTATT', -0.219473822425247],
			['TTCAA', -0.0606246218164349], ['TTCAC', -0.0795526317019536], ['TTCAG', -0.082742427070054], ['TTCAT', -0.230523658611832],
			['TTCCA', -0.449048264069748], ['TTCCC', -0.566255428705321], ['TTCCG', -0.395223614055968], ['TTCCT', -0.55083095837969],
			['TTCGA', -0.141970261270387], ['TTCGC', -0.219473822425247], ['TTCGG', -0.27598603268859], ['TTCGT', -0.344148684119552],
			['TTCTA', -0.295556128882687], ['TTCTC', -0.597837000755621], ['TTCTG', -0.373624502252506], ['TTCTT', -0.530628251062171],
			['TTGAA', -0.0606246218164349], ['TTGAC', -0.089152705430973], ['TTGAG', -0.092373320131015], ['TTGAT', -0.22314355131421],
			['TTGCA', -0.131852131104803], ['TTGCC', -0.307484699747961], ['TTGCG', -0.121835352861332], ['TTGCT', -0.399599988655766],
			['TTGGA', -0.26060111384911], ['TTGGC', -0.208544751893057], ['TTGGG', -0.252996514463891], ['TTGGT', -0.399599988655766],
			['TTGTA', -0.0956043407124617], ['TTGTC', -0.204928111422868], ['TTGTG', -0.348306694268216], ['TTGTT', -0.449048264069748],
			['TTTAA', -0.14877300859314], ['TTTAC', -0.089152705430973], ['TTTAG', -0.118518600235337], ['TTTAT', -0.172953806790354],
			['TTTCA', -0.268263986594679], ['TTTCC', -0.619459464768786], ['TTTCG', -0.444450554821118], ['TTTCT', -0.561087458546879],
			['TTTGA', -0.194156014440958], ['TTTGC', -0.264425210287514], ['TTTGG', -0.26060111384911], ['TTTGT', -0.344148684119552],
			['TTTTA', -0.486611365645396], ['TTTTC', -0.785520500690961], ['TTTTG', -0.55083095837969], ['TTTTT', -1.76850260706379]]
		
		temp = np.array(MGW)
		N_MGW = temp[:,1].astype(float).min()

		#######  ProT
		PROT = [['AAAAA', -7.4079243225598], ['AAAAC', -2.08491434342119], ['AAAAG', -2.19298856495061], ['AAAAT', -2.31417412175284],
			['AAACA', -1.55859954261274], ['AAACC', -1.38933110806336], ['AAACG', -1.58784139220724], ['AAACT', -1.48366852514507],
			['AAAGA', -1.04317356570769], ['AAAGC', -1.02104500319695], ['AAAGG', -0.81351086280982], ['AAAGT', -1.22583941584297],
			['AAATA', -1.44434497894115], ['AAATC', -1.35583515363518], ['AAATG', -1.24250646832818], ['AAATT', -2.35167851721129],
			['AACAA', -0.954299323666907], ['AACAC', -0.839846411147623], ['AACAG', -0.820374307734803], ['AACAT', -0.962204503174021],
			['AACCA', -0.766742152819007], ['AACCC', -0.623467259921955], ['AACCG', -0.656822853622839], ['AACCT', -0.678100252070124],
			['AACGA', -0.871232724968294], ['AACGC', -0.914170482707913], ['AACGG', -0.934033626207324], ['AACGT', -0.989559386623388],
			['AACTA', -0.456152158160688], ['AACTC', -0.378836758409937], ['AACTG', -0.395809028253219], ['AACTT', -0.474501296828884],
			['AAGAA', -0.233200012723223], ['AAGAC', -0.261152143106962], ['AAGAG', -0.214990101343799], ['AAGAT', -0.240115138243155],
			['AAGCA', -0.0913761453766228], ['AAGCC', -0.0967059381399706], ['AAGCG', -0.121047910808899], ['AAGCT', -0.0973741640251764],
			['AAGGA', -0.082116819963826], ['AAGGC', -0.0933714902355187], ['AAGGG', -0.00669305814658414], ['AAGGT', -0.0920408180498138],
			['AAGTA', -0.296412206063442], ['AAGTC', -0.281033513660791], ['AAGTG', -0.314519696690832], ['AAGTT', -0.474501296828884],
			['AATAA', -0.875590030337249], ['AATAC', -0.999395531500101], ['AATAG', -1.21148019476508], ['AATAT', -0.996106054849702],
			['AATCA', -0.914170482707913], ['AATCC', -0.878505484297374], ['AATCG', -0.855416435525009], ['AATCT', -0.97659324062612],
			['AATGA', -0.787851116029243], ['AATGC', -0.866894323369696], ['AATGG', -0.782531954551643], ['AATGT', -1.062287961731],
			['AATTA', -1.33949873431549], ['AATTC', -1.1275284835994], ['AATTG', -1.27887411249905], ['AATTT', -2.35167851721129],
			['ACAAA', -1.30090143481734], ['ACAAC', -1.229980208509], ['ACAAG', -1.04489621901913], ['ACAAT', -1.28105513844541],
			['ACACA', -0.830062964838552], ['ACACC', -0.729582207905267], ['ACACG', -0.844068796027471], ['ACACT', -0.718325053380633],
			['ACAGA', -0.549359287768234], ['ACAGC', -0.585726931939108], ['ACAGG', -0.526513018917064], ['ACAGT', -0.674522430722239],
			['ACATA', -0.723312594891672], ['ACATC', -0.739696074142196], ['ACATG', -0.951154666987436], ['ACATT', -1.062287961731],
			['ACCAA', -0.332115458581212], ['ACCAC', -0.358669481303762], ['ACCAG', -0.311202944064839], ['ACCAT', -0.302138193078327],
			['ACCCA', -0.227093123515043], ['ACCCC', -0.153039512482261], ['ACCCG', -0.238574305888999], ['ACCCT', -0.170865296434861],
			['ACCGA', -0.298862186872426], ['ACCGC', -0.320350617001626], ['ACCGG', -0.361277044710843], ['ACCGT', -0.340604473906123],
			['ACCTA', -0.096038158482434], ['ACCTC', -0.0529224014543424], ['ACCTG', -0.105427898832273], ['ACCTT', -0.0920408180498138],
			['ACGAA', -0.514267967956964], ['ACGAC', -0.509209788229611], ['ACGAG', -0.498171040914789], ['ACGAT', -0.533725827106305],
			['ACGCA', -0.295596877848687], ['ACGCC', -0.246302319620411], ['ACGCG', -0.335502422022228], ['ACGCT', -0.269851288515252],
			['ACGGA', -0.225572210674336], ['ACGGC', -0.273033470993715], ['ACGGG', -0.184628642997284], ['ACGGT', -0.340604473906123],
			['ACGTA', -0.650991933312045], ['ACGTC', -0.650991933312045], ['ACGTG', -0.756352448969872], ['ACGTT', -0.989559386623388],
			['ACTAA', -0.672144308317272], ['ACTAC', -0.679295709474897], ['ACTAG', -0.596679943958306], ['ACTAT', -0.691329549038621],
			['ACTCA', -0.603309802496975], ['ACTCC', -0.523437670516816], ['ACTCG', -0.634843946904063], ['ACTCT', -0.640581197294207],
			['ACTGA', -0.559919047983236], ['ACTGC', -0.635988766719996], ['ACTGG', -0.574892589773398], ['ACTGT', -0.674522430722239],
			['ACTTA', -0.92176353361551], ['ACTTC', -0.762833353053955], ['ACTTG', -0.960618460018386], ['ACTTT', -1.22583941584297],
			['AGAAA', -1.016007209167], ['AGAAC', -1.02272992356187], ['AGAAG', -0.974984229820419], ['AGAAT', -0.951154666987436],
			['AGACA', -0.719569608612837], ['AGACC', -0.665043686767696], ['AGACG', -0.760235948996269], ['AGACT', -0.638282345707096],
			['AGAGA', -0.510219379430963], ['AGAGC', -0.498171040914789], ['AGAGG', -0.48626613840847], ['AGAGT', -0.640581197294207],
			['AGATA', -0.687704167424304], ['AGATC', -0.687704167424304], ['AGATG', -0.642885345779057], ['AGATT', -0.97659324062612],
			['AGCAA', -0.225572210674336], ['AGCAC', -0.258792724002192], ['AGCAG', -0.243977638217052], ['AGCAT', -0.250188838309692],
			['AGCCA', -0.18098830406631], ['AGCCC', -0.160843737973842], ['AGCCG', -0.201547031087346], ['AGCCT', -0.150921615467526],
			['AGCGA', -0.240886445647379], ['AGCGC', -0.265096921397978], ['AGCGG', -0.25800748642749], ['AGCGT', -0.269851288515252],
			['AGCTA', -0.0801437841379677], ['AGCTC', -0.0497305698265662], ['AGCTG', -0.0854138885622047], ['AGCTT', -0.0973741640251764],
			['AGGAA', -0.348306694268216], ['AGGAC', -0.393109971284054], ['AGGAG', -0.342310958961881], ['AGGAT', -0.384165367821156],
			['AGGCA', -0.153746476103081], ['AGGCC', -0.141096975039008], ['AGGCG', -0.185358303737428], ['AGGCT', -0.150921615467526],
			['AGGGA', -0.110833317399181], ['AGGGC', -0.118996628038342], ['AGGGG', -0.0814587087192768], ['AGGGT', -0.170865296434861],
			['AGGTA', -0.396710335209232], ['AGGTC', -0.418589056585039], ['AGGTG', -0.512241624811731], ['AGGTT', -0.678100252070124],
			['AGTAA', -0.608868460500803], ['AGTAC', -0.679295709474897], ['AGTAG', -0.679295709474897], ['AGTAT', -0.685294527704151],
			['AGTCA', -0.673332662586651], ['AGTCC', -0.585726931939108], ['AGTCG', -0.678100252070124], ['AGTCT', -0.638282345707096],
			['AGTGA', -0.559919047983236], ['AGTGC', -0.623467259921955], ['AGTGG', -0.592284332485267], ['AGTGT', -0.718325053380633],
			['AGTTA', -1.04835045388722], ['AGTTC', -0.999395531500101], ['AGTTG', -1.14834285849468], ['AGTTT', -1.48366852514507],
			['ATAAA', -1.3796458023289], ['ATAAC', -1.00932938802439], ['ATAAG', -1.01433356860897], ['ATAAT', -1.14452605996797],
			['ATACA', -0.775922545163969], ['ATACC', -0.703509967595492], ['ATACG', -0.791859137426782], ['ATACT', -0.685294527704151],
			['ATAGA', -0.552515523949671], ['ATAGC', -0.532692235283022], ['ATAGG', -0.535796221220613], ['ATAGT', -0.691329549038621],
			['ATATA', -0.77856106912215], ['ATATC', -0.696183927503419], ['ATATG', -0.699840238706529], ['ATATT', -0.996106054849702],
			['ATCAA', -0.562044447295549], ['ATCAC', -0.501169543911045], ['ATCAG', -0.503173552597761], ['ATCAT', -0.463837114330072],
			['ATCCA', -0.421357863153172], ['ATCCC', -0.350887340861707], ['ATCCG', -0.31535060658492], ['ATCCT', -0.384165367821156],
			['ATCGA', -0.557798156414098], ['ATCGC', -0.545166409508198], ['ATCGG', -0.565241040321177], ['ATCGT', -0.533725827106305],
			['ATCTA', -0.213487471459264], ['ATCTC', -0.182442849777304], ['ATCTG', -0.176637318231984], ['ATCTT', -0.240115138243155],
			['ATGAA', -0.456152158160688], ['ATGAC', -0.485280431083711], ['ATGAG', -0.454240111689062], ['ATGAT', -0.463837114330072],
			['ATGCA', -0.254090520980756], ['ATGCC', -0.207499429614642], ['ATGCG', -0.277825812434021], ['ATGCT', -0.250188838309692],
			['ATGGA', -0.226332377947734], ['ATGGC', -0.207499429614642], ['ATGGG', -0.153039512482261], ['ATGGT', -0.302138193078327],
			['ATGTA', -0.592284332485267], ['ATGTC', -0.559919047983236], ['ATGTG', -0.762833353053955], ['ATGTT', -0.962204503174021],
			['ATTAA', -1.15409551098413], ['ATTAC', -1.15794908030012], ['ATTAG', -1.20538880537168], ['ATTAT', -1.14452605996797],
			['ATTCA', -1.06404388843327], ['ATTCC', -0.869784498791929], ['ATTCG', -1.01768365549425], ['ATTCT', -0.951154666987436],
			['ATTGA', -1.0799875388304], ['ATTGC', -1.02441768767559], ['ATTGG', -1.04489621901913], ['ATTGT', -1.28105513844541],
			['ATTTA', -1.82819449657338], ['ATTTC', -1.31435455251446], ['ATTTG', -1.65218210897269], ['ATTTT', -2.31417412175284],
			['CAAAA', -1.79845252737464], ['CAAAC', -1.57311358549699], ['CAAAG', -1.50256247450503], ['CAAAT', -1.65218210897269],
			['CAACA', -1.22790766890703], ['CAACC', -0.286671869315058], ['CAACG', -1.23205705245384], ['CAACT', -1.14834285849468],
			['CAAGA', -0.801274136361383], ['CAAGC', -0.737158001713725], ['CAAGG', -0.806694203830723], ['CAAGT', -0.960618460018386],
			['CAATA', -0.882894664716137], ['CAATC', -0.979819049875003], ['CAATG', -0.994465365392242], ['CAATT', -1.27887411249905],
			['CACAA', -0.687704167424304], ['CACAC', -0.679295709474897], ['CACAG', -0.674522430722239], ['CACAT', -0.762833353053955],
			['CACCA', -0.549359287768234], ['CACCC', -0.439073944217651], ['CACCG', -0.504177064975001], ['CACCT', -0.512241624811731],
			['CACGA', -0.654486403961819], ['CACGC', -0.657993128771029], ['CACGG', -0.715840580052971], ['CACGT', -0.756352448969872],
			['CACTA', -0.294782213852511], ['CACTC', -0.221780018037274], ['CACTG', -0.317847486783507], ['CACTT', -0.314519696690832],
			['CAGAA', -0.237804779109971], ['CAGAC', -0.273033470993715], ['CAGAG', -0.203031812354926], ['CAGAT', -0.176637318231984],
			['CAGCA', -0.108126955801438], ['CAGCC', -0.0735949722590621], ['CAGCG', -0.108126955801438], ['CAGCT', -0.0854138885622047],
			['CAGGA', -0.0542019921599675], ['CAGGC', -0.0788305863130073], ['CAGGG', -0.00669305814658414], ['CAGGT', -0.105427898832273],
			['CAGTA', -0.291530178466134], ['CAGTC', -0.272236975531455], ['CAGTG', -0.317847486783507], ['CAGTT', -0.395809028253219],
			['CATAA', -0.667404962953376], ['CATAC', -0.710890074893114], ['CATAG', -0.68409188173839], ['CATAT', -0.699840238706529],
			['CATCA', -0.675713616092393], ['CATCC', -0.620079340250019], ['CATCG', -0.6986199823013], ['CATCT', -0.642885345779057],
			['CATGA', -0.820374307734803], ['CATGC', -0.844068796027471], ['CATGG', -0.786518670795464], ['CATGT', -0.951154666987436],
			['CATTA', -1.01099466734345], ['CATTC', -0.844068796027471], ['CATTG', -0.994465365392242], ['CATTT', -1.24250646832818],
			['CCAAA', -0.828673110549498], ['CCAAC', -0.897665982036449], ['CCAAG', -0.884362016410087], ['CCAAT', -1.04489621901913],
			['CCACA', -0.584638200203912], ['CCACC', -0.560981182974219], ['CCACG', -0.64519481562772], ['CCACT', -0.592284332485267],
			['CCAGA', -0.458067867558826], ['CCAGC', -0.437194244416074], ['CCAGG', -0.406678700490123], ['CCAGT', -0.574892589773398],
			['CCATA', -0.517315202412432], ['CCATC', -0.601094962167422], ['CCATG', -0.786518670795464], ['CCATT', -0.782531954551643],
			['CCCAA', -0.232434608935377], ['CCCAC', -0.194156014440957], ['CCCAG', -0.160131740791753], ['CCCAT', -0.153039512482261],
			['CCCCA', -0.128605487144979], ['CCCCC', -0.0625594821427302], ['CCCCG', -0.123789516364394], ['CCCCT', -0.0814587087192768],
			['CCCGA', -0.192684343829501], ['CCCGC', -0.180261823830944], ['CCCGG', -0.218002151813791], ['CCCGT', -0.184628642997284],
			['CCCTA', -0.0326685445498448], ['CCCTC', 0.0], ['CCCTG', -0.00669305814658414], ['CCCTT', -0.00669305814658414],
			['CCGAA', -0.457109554117015], ['CCGAC', -0.522414652524782], ['CCGAG', -0.460948330424181], ['CCGAT', -0.565241040321177],
			['CCGCA', -0.285864440930456], ['CCGCC', -0.208245976868426], ['CCGCG', -0.295596877848687], ['CCGCT', -0.25800748642749],
			['CCGGA', -0.21273700238089], ['CCGGC', -0.242430847498753], ['CCGGG', -0.218002151813791], ['CCGGT', -0.361277044710843],
			['CCGTA', -0.518333014205133], ['CCGTC', -0.565241040321177], ['CCGTG', -0.715840580052971], ['CCGTT', -0.934033626207324],
			['CCTAA', -0.427848381997836], ['CCTAC', -0.46770185343996], ['CCTAG', -0.499169543244378], ['CCTAT', -0.535796221220613],
			['CCTCA', -0.484295694421172], ['CCTCC', -0.42598964540321], ['CCTCG', -0.480366416281282], ['CCTCT', -0.48626613840847],
			['CCTGA', -0.385947899487439], ['CCTGC', -0.441900135453486], ['CCTGG', -0.406678700490123], ['CCTGT', -0.526513018917064],
			['CCTTA', -0.675713616092393], ['CCTTC', -0.590093751105449], ['CCTTG', -0.806694203830723], ['CCTTT', -0.81351086280982],
			['CGAAA', -1.02104500319695], ['CGAAC', -1.00435012462478], ['CGAAG', -0.897665982036449], ['CGAAT', -1.01768365549425],
			['CGACA', -0.690119627535908], ['CGACC', -0.670957364557743], ['CGACG', -0.719569608612837], ['CGACT', -0.678100252070124],
			['CGAGA', -0.52856851809916], ['CGAGC', -0.526513018917064], ['CGAGG', -0.480366416281282], ['CGAGT', -0.634843946904063],
			['CGATA', -0.617827087045694], ['CGATC', -0.635988766719996], ['CGATG', -0.6986199823013], ['CGATT', -0.855416435525009],
			['CGCAA', -0.286671869315058], ['CGCAC', -0.285864440930456], ['CGCAG', -0.26351714223846], ['CGCAT', -0.277825812434021],
			['CGCCA', -0.197105869087379], ['CGCCC', -0.190480890863066], ['CGCCG', -0.211237751725249], ['CGCCT', -0.185358303737428],
			['CGCGA', -0.297228199580772], ['CGCGC', -0.293154874193136], ['CGCGG', -0.295596877848687], ['CGCGT', -0.335502422022228],
			['CGCTA', -0.10206428987559], ['CGCTC', -0.0814587087192768], ['CGCTG', -0.108126955801438], ['CGCTT', -0.121047910808899],
			['CGGAA', -0.390418179618343], ['CGGAC', -0.456152158160688], ['CGGAG', -0.364764406571259], ['CGGAT', -0.31535060658492],
			['CGGCA', -0.20675343927792], ['CGGCC', -0.178085544408349], ['CGGCG', -0.211237751725249], ['CGGCT', -0.201547031087346],
			['CGGGA', -0.166558039237281], ['CGGGC', -0.178810444766297], ['CGGGG', -0.123789516364394], ['CGGGT', -0.238574305888999],
			['CGGTA', -0.448525810425623], ['CGGTC', -0.448525810425623], ['CGGTG', -0.504177064975001], ['CGGTT', -0.656822853622839],
			['CGTAA', -0.626866696623419], ['CGTAC', -0.764134589411927], ['CGTAG', -0.712125405501107], ['CGTAT', -0.791859137426782],
			['CGTCA', -0.717082045141036], ['CGTCC', -0.673332662586651], ['CGTCG', -0.719569608612837], ['CGTCT', -0.760235948996269],
			['CGTGA', -0.669771827963642], ['CGTGC', -0.708423982397921], ['CGTGG', -0.64519481562772], ['CGTGT', -0.844068796027471],
			['CGTTA', -1.15217428080623], ['CGTTC', -1.10530534681469], ['CGTTG', -1.23205705245384], ['CGTTT', -1.58784139220724],
			['CTAAA', -1.1275284835994], ['CTAAC', -1.0328995027315], ['CTAAG', -0.97659324062612], ['CTAAT', -1.20538880537168],
			['CTACA', -0.733362930745173], ['CTACC', -0.668587695202425], ['CTACG', -0.712125405501107], ['CTACT', -0.679295709474897],
			['CTAGA', -0.547260651111312], ['CTAGC', -0.502171046248135], ['CTAGG', -0.499169543244378], ['CTAGT', -0.596679943958306],
			['CTATA', -0.624599121955639], ['CTATC', -0.769356533393079], ['CTATG', -0.68409188173839], ['CTATT', -1.21148019476508],
			['CTCAA', -0.484295694421172], ['CTCAC', -0.498171040914789], ['CTCAG', -0.457109554117015], ['CTCAT', -0.454240111689062],
			['CTCCA', -0.398515389850962], ['CTCCC', -0.324536474934304], ['CTCCG', -0.364764406571259], ['CTCCT', -0.342310958961881],
			['CTCGA', -0.520371750894981], ['CTCGC', -0.479386504394933], ['CTCGG', -0.460948330424181], ['CTCGT', -0.498171040914789],
			['CTCTA', -0.214990101343799], ['CTCTC', -0.165126399765843], ['CTCTG', -0.203031812354926], ['CTCTT', -0.214990101343799],
			['CTGAA', -0.444734336689361], ['CTGAC', -0.49120930220599], ['CTGAG', -0.457109554117015], ['CTGAT', -0.503173552597761],
			['CTGCA', -0.250188838309692], ['CTGCC', -0.213487471459264], ['CTGCG', -0.26351714223846], ['CTGCT', -0.243977638217052],
			['CTGGA', -0.197105869087379], ['CTGGC', -0.224053607497146], ['CTGGG', -0.160131740791753], ['CTGGT', -0.311202944064839],
			['CTGTA', -0.497173534597663], ['CTGTC', -0.536833027949053], ['CTGTG', -0.674522430722239], ['CTGTT', -0.820374307734803],
			['CTTAA', -0.864012476994807], ['CTTAC', -0.97659324062612], ['CTTAG', -0.97659324062612], ['CTTAT', -1.01433356860897],
			['CTTCA', -0.9653841560914], ['CTTCC', -0.845480228865879], ['CTTCG', -0.897665982036449], ['CTTCT', -0.974984229820419],
			['CTTGA', -0.9248169711024], ['CTTGC', -0.912658766622591], ['CTTGG', -0.884362016410087], ['CTTGT', -1.04489621901913],
			['CTTTA', -1.50256247450503], ['CTTTC', -1.27887411249905], ['CTTTG', -1.50256247450503], ['CTTTT', -2.19298856495061],
			['GAAAA', -1.59081316259639], ['GAAAC', -1.4783351791697], ['GAAAG', -1.27887411249905], ['GAAAT', -1.31435455251446],
			['GAACA', -1.0782034170369], ['GAACC', -0.940225596455245], ['GAACG', -1.10530534681469], ['GAACT', -0.999395531500101],
			['GAAGA', -0.681690920200852], ['GAAGC', -0.661512193986225], ['GAAGG', -0.590093751105449], ['GAAGT', -0.762833353053955],
			['GAATA', -0.92941468035103], ['GAATC', -0.848309085066357], ['GAATG', -0.844068796027471], ['GAATT', -1.1275284835994],
			['GACAA', -0.601094962167422], ['GACAC', -0.575970756993744], ['GACAG', -0.536833027949053], ['GACAT', -0.559919047983236],
			['GACCA', -0.465767616860129], ['GACCC', -0.387733614247674], ['GACCG', -0.448525810425623], ['GACCT', -0.418589056585039],
			['GACGA', -0.560981182974219], ['GACGC', -0.590093751105449], ['GACGG', -0.565241040321177], ['GACGT', -0.650991933312045],
			['GACTA', -0.26747127945844], ['GACTC', -0.20675343927792], ['GACTG', -0.272236975531455], ['GACTT', -0.281033513660791],
			['GAGAA', -0.155161904506411], ['GAGAC', -0.233200012723223], ['GAGAG', -0.165126399765843], ['GAGAT', -0.182442849777304],
			['GAGCA', -0.0567660961289052], ['GAGCC', -0.0307906097256446], ['GAGCG', -0.0814587087192768], ['GAGCT', -0.0497305698265662],
			['GAGGA', -0.0251778728206872], ['GAGGC', -0.0414791742319996], ['GAGGG', 0.0], ['GAGGT', -0.0529224014543424],
			['GAGTA', -0.202289146149235], ['GAGTC', -0.20675343927792], ['GAGTG', -0.221780018037274], ['GAGTT', -0.378836758409937],
			['GATAA', -0.621207371954518], ['GATAC', -0.667404962953376], ['GATAG', -0.769356533393079], ['GATAT', -0.696183927503419],
			['GATCA', -0.638282345707096], ['GATCC', -0.609983909584668], ['GATCG', -0.635988766719996], ['GATCT', -0.687704167424304],
			['GATGA', -0.589000257284078], ['GATGC', -0.614458189979589], ['GATGG', -0.601094962167422], ['GATGT', -0.739696074142196],
			['GATTA', -0.966977781926678], ['GATTC', -0.848309085066357], ['GATTG', -0.979819049875003], ['GATTT', -1.35583515363518],
			['GCAAA', -1.07287007106154], ['GCAAC', -1.0500820560515], ['GCAAG', -0.912658766622591], ['GCAAT', -1.02441768767559],
			['GCACA', -0.696183927503419], ['GCACC', -0.647509631476171], ['GCACG', -0.708423982397921], ['GCACT', -0.623467259921955],
			['GCAGA', -0.517315202412432], ['GCAGC', -0.524461736146506], ['GCAGG', -0.441900135453486], ['GCAGT', -0.635988766719996],
			['GCATA', -0.673332662586651], ['GCATC', -0.614458189979589], ['GCATG', -0.844068796027471], ['GCATT', -0.866894323369696],
			['GCCAA', -0.26351714223846], ['GCCAC', -0.277825812434021], ['GCCAG', -0.224053607497146], ['GCCAT', -0.207499429614642],
			['GCCCA', -0.181715312458927], ['GCCCC', -0.136220615672231], ['GCCCG', -0.178810444766297], ['GCCCT', -0.118996628038342],
			['GCCGA', -0.228616353055564], ['GCCGC', -0.254090520980756], ['GCCGG', -0.242430847498753], ['GCCGT', -0.273033470993715],
			['GCCTA', -0.0755551166305366], ['GCCTC', -0.0414791742319996], ['GCCTG', -0.0788305863130073], ['GCCTT', -0.0933714902355187],
			['GCGAA', -0.457109554117015], ['GCGAC', -0.538909871893892], ['GCGAG', -0.479386504394933], ['GCGAT', -0.545166409508198],
			['GCGCA', -0.270645885299213], ['GCGCC', -0.227854448256803], ['GCGCG', -0.293154874193136], ['GCGCT', -0.265096921397978],
			['GCGGA', -0.209740745457656], ['GCGGC', -0.254090520980756], ['GCGGG', -0.180261823830944], ['GCGGT', -0.320350617001626],
			['GCGTA', -0.572739736412297], ['GCGTC', -0.590093751105449], ['GCGTG', -0.657993128771029], ['GCGTT', -0.914170482707913],
			['GCTAA', -0.460948330424181], ['GCTAC', -0.545166409508198], ['GCTAG', -0.502171046248135], ['GCTAT', -0.532692235283022],
			['GCTCA', -0.523437670516816], ['GCTCC', -0.456152158160688], ['GCTCG', -0.526513018917064], ['GCTCT', -0.498171040914789],
			['GCTGA', -0.484295694421172], ['GCTGC', -0.524461736146506], ['GCTGG', -0.437194244416074], ['GCTGT', -0.585726931939108],
			['GCTTA', -0.774605889279222], ['GCTTC', -0.661512193986225], ['GCTTG', -0.737158001713725], ['GCTTT', -1.02104500319695],
			['GGAAA', -0.94177959832198], ['GGAAC', -0.914170482707913], ['GGAAG', -0.845480228865879], ['GGAAT', -0.869784498791929],
			['GGACA', -0.626866696623419], ['GGACC', -0.608868460500803], ['GGACG', -0.673332662586651], ['GGACT', -0.585726931939108],
			['GGAGA', -0.459027100246287], ['GGAGC', -0.456152158160688], ['GGAGG', -0.42598964540321], ['GGAGT', -0.523437670516816],
			['GGATA', -0.599989378859673], ['GGATC', -0.609983909584668], ['GGATG', -0.620079340250019], ['GGATT', -0.878505484297374],
			['GGCAA', -0.208993081871425], ['GGCAC', -0.229378838795899], ['GGCAG', -0.213487471459264], ['GGCAT', -0.207499429614642],
			['GGCCA', -0.165126399765843], ['GGCCC', -0.122417774036813], ['GGCCG', -0.178085544408349], ['GGCCT', -0.141096975039008],
			['GGCGA', -0.197844694388811], ['GGCGC', -0.227854448256803], ['GGCGG', -0.208245976868426], ['GGCGT', -0.246302319620411],
			['GGCTA', -0.0749013081731177], ['GGCTC', -0.0307906097256446], ['GGCTG', -0.0735949722590621], ['GGCTT', -0.0967059381399706],
			['GGGAA', -0.307072413615549], ['GGGAC', -0.383275292105963], ['GGGAG', -0.324536474934304], ['GGGAT', -0.350887340861707],
			['GGGCA', -0.163696806956249], ['GGGCC', -0.122417774036813], ['GGGCG', -0.190480890863066], ['GGGCT', -0.160843737973842],
			['GGGGA', -0.0893847739916974], ['GGGGC', -0.136220615672231], ['GGGGG', -0.0625594821427302], ['GGGGT', -0.153039512482261],
			['GGGTA', -0.359537913837716], ['GGGTC', -0.387733614247674], ['GGGTG', -0.439073944217651], ['GGGTT', -0.623467259921955],
			['GGTAA', -0.571665045282532], ['GGTAC', -0.674522430722239], ['GGTAG', -0.668587695202425], ['GGTAT', -0.703509967595492],
			['GGTCA', -0.655653946417857], ['GGTCC', -0.608868460500803], ['GGTCG', -0.670957364557743], ['GGTCT', -0.665043686767696],
			['GGTGA', -0.553569820304577], ['GGTGC', -0.647509631476171], ['GGTGG', -0.560981182974219], ['GGTGT', -0.729582207905267],
			['GGTTA', -1.06404388843327], ['GGTTC', -0.940225596455245], ['GGTTG', -0.286671869315058], ['GGTTT', -1.38933110806336],
			['GTAAA', -1.27019726847337], ['GTAAC', -1.06404388843327], ['GTAAG', -0.97659324062612], ['GTAAT', -1.15794908030012],
			['GTACA', -0.660337795730283], ['GTACC', -0.674522430722239], ['GTACG', -0.764134589411927], ['GTACT', -0.679295709474897],
			['GTAGA', -0.48626613840847], ['GTAGC', -0.545166409508198], ['GTAGG', -0.46770185343996], ['GTAGT', -0.679295709474897],
			['GTATA', -0.646351553755543], ['GTATC', -0.667404962953376], ['GTATG', -0.710890074893114], ['GTATT', -0.999395531500101],
			['GTCAA', -0.556739395065856], ['GTCAC', -0.53062825106217], ['GTCAG', -0.49120930220599], ['GTCAT', -0.485280431083711],
			['GTCCA', -0.428779047490789], ['GTCCC', -0.383275292105963], ['GTCCG', -0.456152158160688], ['GTCCT', -0.393109971284054],
			['GTCGA', -0.516298425507345], ['GTCGC', -0.538909871893892], ['GTCGG', -0.522414652524782], ['GTCGT', -0.509209788229611],
			['GTCTA', -0.245526825203881], ['GTCTC', -0.233200012723223], ['GTCTG', -0.273033470993715], ['GTCTT', -0.261152143106962],
			['GTGAA', -0.469639838542639], ['GTGAC', -0.53062825106217], ['GTGAG', -0.498171040914789], ['GTGAT', -0.501169543911045],
			['GTGCA', -0.254872687622119], ['GTGCC', -0.229378838795899], ['GTGCG', -0.285864440930456], ['GTGCT', -0.258792724002192],
			['GTGGA', -0.234732580073001], ['GTGGC', -0.277825812434021], ['GTGGG', -0.194156014440957], ['GTGGT', -0.358669481303762],
			['GTGTA', -0.506187115903025], ['GTGTC', -0.575970756993744], ['GTGTG', -0.679295709474897], ['GTGTT', -0.839846411147623],
			['GTTAA', -0.997749440593432], ['GTTAC', -1.06404388843327], ['GTTAG', -1.0328995027315], ['GTTAT', -1.00932938802439],
			['GTTCA', -0.987929394412457], ['GTTCC', -0.914170482707913], ['GTTCG', -1.00435012462478], ['GTTCT', -1.02272992356187],
			['GTTGA', -0.962204503174021], ['GTTGC', -1.0500820560515], ['GTTGG', -0.897665982036449], ['GTTGT', -1.229980208509],
			['GTTTA', -1.71083083605419], ['GTTTC', -1.4783351791697], ['GTTTG', -1.57311358549699], ['GTTTT', -2.08491434342119],
			['TAAAA', -1.63027199933694], ['TAAAC', -1.71083083605419], ['TAAAG', -1.50256247450503], ['TAAAT', -1.82819449657338],
			['TAACA', -1.15988144805117], ['TAACC', -1.06404388843327], ['TAACG', -1.15217428080623], ['TAACT', -1.04835045388722],
			['TAAGA', -0.72206337549124], ['TAAGC', -0.774605889279222], ['TAAGG', -0.675713616092393], ['TAAGT', -0.92176353361551],
			['TAATA', -0.9248169711024], ['TAATC', -0.966977781926678], ['TAATG', -1.01099466734345], ['TAATT', -1.33949873431549],
			['TACAA', -0.567377793270912], ['TACAC', -0.506187115903025], ['TACAG', -0.497173534597663], ['TACAT', -0.592284332485267],
			['TACCA', -0.445680858293392], ['TACCC', -0.359537913837716], ['TACCG', -0.448525810425623], ['TACCT', -0.396710335209232],
			['TACGA', -0.496177022307924], ['TACGC', -0.572739736412297], ['TACGG', -0.518333014205133], ['TACGT', -0.650991933312045],
			['TACTA', -0.273033470993715], ['TACTC', -0.202289146149235], ['TACTG', -0.291530178466134], ['TACTT', -0.296412206063442],
			['TAGAA', -0.254090520980756], ['TAGAC', -0.245526825203881], ['TAGAG', -0.214990101343799], ['TAGAT', -0.213487471459264],
			['TAGCA', -0.100051541795893], ['TAGCC', -0.0749013081731177], ['TAGCG', -0.10206428987559], ['TAGCT', -0.0801437841379677],
			['TAGGA', -0.0860746087712429], ['TAGGC', -0.0755551166305366], ['TAGGG', -0.0326685445498448], ['TAGGT', -0.096038158482434],
			['TAGTA', -0.273033470993715], ['TAGTC', -0.26747127945844], ['TAGTG', -0.294782213852511], ['TAGTT', -0.456152158160688],
			['TATAA', -0.564174373553374], ['TATAC', -0.646351553755543], ['TATAG', -0.624599121955639], ['TATAT', -0.77856106912215],
			['TATCA', -0.583550652516513], ['TATCC', -0.599989378859673], ['TATCG', -0.617827087045694], ['TATCT', -0.687704167424304],
			['TATGA', -0.549359287768234], ['TATGC', -0.673332662586651], ['TATGG', -0.517315202412432], ['TATGT', -0.723312594891672],
			['TATTA', -0.9248169711024], ['TATTC', -0.92941468035103], ['TATTG', -0.882894664716137], ['TATTT', -1.44434497894115],
			['TCAAA', -0.971773954190171], ['TCAAC', -0.962204503174021], ['TCAAG', -0.9248169711024], ['TCAAT', -1.0799875388304],
			['TCACA', -0.639431110910969], ['TCACC', -0.553569820304577], ['TCACG', -0.669771827963642], ['TCACT', -0.559919047983236],
			['TCAGA', -0.480366416281282], ['TCAGC', -0.484295694421172], ['TCAGG', -0.385947899487439], ['TCAGT', -0.559919047983236],
			['TCATA', -0.549359287768234], ['TCATC', -0.589000257284078], ['TCATG', -0.820374307734803], ['TCATT', -0.787851116029243],
			['TCCAA', -0.179535870985995], ['TCCAC', -0.234732580073001], ['TCCAG', -0.197105869087379], ['TCCAT', -0.226332377947734],
			['TCCCA', -0.156579339187385], ['TCCCC', -0.0893847739916974], ['TCCCG', -0.166558039237281], ['TCCCT', -0.110833317399181],
			['TCCGA', -0.201547031087346], ['TCCGC', -0.209740745457656], ['TCCGG', -0.21273700238089], ['TCCGT', -0.225572210674336],
			['TCCTA', -0.0860746087712429], ['TCCTC', -0.0251778728206872], ['TCCTG', -0.0542019921599675], ['TCCTT', -0.082116819963826],
			['TCGAA', -0.448525810425623], ['TCGAC', -0.516298425507345], ['TCGAG', -0.520371750894981], ['TCGAT', -0.557798156414098],
			['TCGCA', -0.260365051370145], ['TCGCC', -0.197844694388811], ['TCGCG', -0.297228199580772], ['TCGCT', -0.240886445647379],
			['TCGGA', -0.201547031087346], ['TCGGC', -0.228616353055564], ['TCGGG', -0.192684343829501], ['TCGGT', -0.298862186872426],
			['TCGTA', -0.496177022307924], ['TCGTC', -0.560981182974219], ['TCGTG', -0.654486403961819], ['TCGTT', -0.871232724968294],
			['TCTAA', -0.509209788229611], ['TCTAC', -0.48626613840847], ['TCTAG', -0.547260651111312], ['TCTAT', -0.552515523949671],
			['TCTCA', -0.510219379430963], ['TCTCC', -0.459027100246287], ['TCTCG', -0.52856851809916], ['TCTCT', -0.510219379430963],
			['TCTGA', -0.480366416281282], ['TCTGC', -0.517315202412432], ['TCTGG', -0.458067867558826], ['TCTGT', -0.549359287768234],
			['TCTTA', -0.72206337549124], ['TCTTC', -0.681690920200852], ['TCTTG', -0.801274136361383], ['TCTTT', -1.04317356570769],
			['TGAAA', -1.06053511290359], ['TGAAC', -0.987929394412457], ['TGAAG', -0.9653841560914], ['TGAAT', -1.06404388843327],
			['TGACA', -0.693753792650127], ['TGACC', -0.655653946417857], ['TGACG', -0.717082045141036], ['TGACT', -0.673332662586651],
			['TGAGA', -0.510219379430963], ['TGAGC', -0.523437670516816], ['TGAGG', -0.484295694421172], ['TGAGT', -0.603309802496975],
			['TGATA', -0.583550652516513], ['TGATC', -0.638282345707096], ['TGATG', -0.675713616092393], ['TGATT', -0.914170482707913],
			['TGCAA', -0.259578578659531], ['TGCAC', -0.254872687622119], ['TGCAG', -0.250188838309692], ['TGCAT', -0.254090520980756],
			['TGCCA', -0.197105869087379], ['TGCCC', -0.163696806956249], ['TGCCG', -0.20675343927792], ['TGCCT', -0.153746476103081],
			['TGCGA', -0.260365051370145], ['TGCGC', -0.270645885299213], ['TGCGG', -0.285864440930456], ['TGCGT', -0.295596877848687],
			['TGCTA', -0.100051541795893], ['TGCTC', -0.0567660961289052], ['TGCTG', -0.108126955801438], ['TGCTT', -0.0913761453766228],
			['TGGAA', -0.37618306379647], ['TGGAC', -0.428779047490789], ['TGGAG', -0.398515389850962], ['TGGAT', -0.421357863153172],
			['TGGCA', -0.197105869087379], ['TGGCC', -0.165126399765843], ['TGGCG', -0.197105869087379], ['TGGCT', -0.18098830406631],
			['TGGGA', -0.156579339187385], ['TGGGC', -0.181715312458927], ['TGGGG', -0.128605487144979], ['TGGGT', -0.227093123515043],
			['TGGTA', -0.445680858293392], ['TGGTC', -0.465767616860129], ['TGGTG', -0.549359287768234], ['TGGTT', -0.766742152819007],
			['TGTAA', -0.608868460500803], ['TGTAC', -0.660337795730283], ['TGTAG', -0.733362930745173], ['TGTAT', -0.775922545163969],
			['TGTCA', -0.693753792650127], ['TGTCC', -0.626866696623419], ['TGTCG', -0.690119627535908], ['TGTCT', -0.719569608612837],
			['TGTGA', -0.639431110910969], ['TGTGC', -0.696183927503419], ['TGTGG', -0.584638200203912], ['TGTGT', -0.830062964838552],
			['TGTTA', -1.15988144805117], ['TGTTC', -1.0782034170369], ['TGTTG', -1.22790766890703], ['TGTTT', -1.55859954261274],
			['TTAAA', -1.04145387482816], ['TTAAC', -0.997749440593432], ['TTAAG', -0.864012476994807], ['TTAAT', -1.15409551098413],
			['TTACA', -0.608868460500803], ['TTACC', -0.571665045282532], ['TTACG', -0.626866696623419], ['TTACT', -0.608868460500803],
			['TTAGA', -0.509209788229611], ['TTAGC', -0.460948330424181], ['TTAGG', -0.427848381997836], ['TTAGT', -0.672144308317272],
			['TTATA', -0.564174373553374], ['TTATC', -0.621207371954518], ['TTATG', -0.667404962953376], ['TTATT', -0.875590030337249],
			['TTCAA', -0.447576593458291], ['TTCAC', -0.469639838542639], ['TTCAG', -0.444734336689361], ['TTCAT', -0.456152158160688],
			['TTCCA', -0.37618306379647], ['TTCCC', -0.307072413615549], ['TTCCG', -0.390418179618343], ['TTCCT', -0.348306694268216],
			['TTCGA', -0.448525810425623], ['TTCGC', -0.457109554117015], ['TTCGG', -0.457109554117015], ['TTCGT', -0.514267967956964],
			['TTCTA', -0.254090520980756], ['TTCTC', -0.155161904506411], ['TTCTG', -0.237804779109971], ['TTCTT', -0.233200012723223],
			['TTGAA', -0.447576593458291], ['TTGAC', -0.556739395065856], ['TTGAG', -0.484295694421172], ['TTGAT', -0.562044447295549],
			['TTGCA', -0.259578578659531], ['TTGCC', -0.208993081871425], ['TTGCG', -0.286671869315058], ['TTGCT', -0.225572210674336],
			['TTGGA', -0.179535870985995], ['TTGGC', -0.26351714223846], ['TTGGG', -0.232434608935377], ['TTGGT', -0.332115458581212],
			['TTGTA', -0.567377793270912], ['TTGTC', -0.601094962167422], ['TTGTG', -0.687704167424304], ['TTGTT', -0.954299323666907],
			['TTTAA', -1.04145387482816], ['TTTAC', -1.27019726847337], ['TTTAG', -1.1275284835994], ['TTTAT', -1.3796458023289],
			['TTTCA', -1.06053511290359], ['TTTCC', -0.94177959832198], ['TTTCG', -1.02104500319695], ['TTTCT', -1.016007209167],
			['TTTGA', -0.971773954190171], ['TTTGC', -1.07287007106154], ['TTTGG', -0.828673110549498], ['TTTGT', -1.30090143481734],
			['TTTTA', -1.63027199933694], ['TTTTC', -1.59081316259639], ['TTTTG', -1.79845252737464], ['TTTTT', -7.4079243225598]]
		
		temp = np.array(PROT)
		N_PROT = temp[:,1].astype(float).min()


	if('pcr' in biasType):
		PCR = 1
		COVARI_NUM = COVARI_NUM + 2 # ANNEAL & DENATURE

		COVARI_ORDER.extend(["Anneal_pcr", "Denature_pcr"])

		global GIBBS
		global ENTROPY
		global MIN_TM
		global MAX_TM
		global PARA1
		global PARA2
		global N_GIBBS

		GIBBS = [['AA', -1.04], ['AC', -2.04], ['AG', -1.29], ['AT', -1.27],
			 ['CA', -0.78], ['CC', -1.97], ['CG', -1.44], ['CT', -1.29],
			 ['GA', -1.66], ['GC', -2.7], ['GG', -1.97], ['GT', -2.04],
			 ['TA', -0.12], ['TC', -1.66], ['TG', -0.78], ['TT', -1.04]]
	
		ENTROPY = -0.02485
		temp = np.array(GIBBS)
		MIN_TM = -0.12 / ENTROPY
		MAX_TM = -2.7 / ENTROPY
		PARA1 = (math.pow(10, 6) - math.exp(1)) / (math.pow(10, 6) - 1)
		PARA2 =  math.pow(10, -6) / (1-PARA1)
		N_GIBBS = np.median(temp[:,1].astype(float))

	if('map' in biasType):
		MAP = 1
		COVARI_NUM = COVARI_NUM + 1

		COVARI_ORDER.extend(["Map_map"])


		global MAPFILE
		global KMER

		if(args.mapFile == None):
			print("ERROR: No map file was specified !")
			sys.exit()
		if(args.kmer == None):
			print("ERROR: No kmer parameter was specified !")
			sys.exit()
	
		MAPFILE = args.mapFile
		KMER = int(args.kmer)

	if('gquad' in biasType):
		GQUAD = 1
		COVARI_NUM = COVARI_NUM + 1
		
		COVARI_ORDER.extend(["Gquad_gquad"])

		global GQAUDFILE
		global GQAUD_MAX

		guadFileNum = len(args.gquadFile)
		
		if(guadFileNum == 0):
			print("ERROR: No g-quadruplex file was specified !")
			sys.exit()

		GQAUDFILE = [0] * guadFileNum
		for i in range(guadFileNum):
			GQAUDFILE[i] = args.gquadFile[i]
		GQAUD_MAX = args.gquadMax

	return


def setFragLen(fragLen):
	global FRAGLEN
	FRAGLEN = int(fragLen)

	return

def setAnlaysisRegion(region, bl):
	global REGION

	REGION = []
	input_filename = region
	input_stream = open(input_filename)
	input_file = input_stream.readlines()

	for i in range(len(input_file)):
		temp = input_file[i].split()
		temp[1] = int(temp[1])
		temp[2] = int(temp[2])
		REGION.append(temp)
	input_stream.close()

	if(len(REGION) > 1):
		REGION = np.array(REGION)
		REGION = REGION[np.lexsort(( REGION[:,1].astype(int), REGION[:,0])  ) ]
		REGION = REGION.tolist()

		region_merged = []

		pos = 0
		pastChromo = REGION[pos][0]
		pastStart = int(REGION[pos][1])
		pastEnd = int(REGION[pos][2])
		region_merged.append([ pastChromo, pastStart, pastEnd])
		resultIdx = 0

		pos = 1
		while( pos < len(REGION) ):
			currChromo = REGION[pos][0]
			currStart = int(REGION[pos][1])
			currEnd = int(REGION[pos][2])

			if( (currChromo == pastChromo) and (currStart >= pastStart) and (currStart <= pastEnd)):
				maxEnd = np.max([currEnd, pastEnd])
				region_merged[resultIdx][2] = maxEnd
				pos = pos + 1
				pastChromo = currChromo
				pastStart = currStart
				pastEnd = maxEnd
			else:
				region_merged.append([currChromo, currStart, currEnd])
				resultIdx = resultIdx + 1
				pos = pos + 1
				pastChromo = currChromo
				pastStart = currStart
				pastEnd = currEnd

		REGION = region_merged

	if(bl != None):  ### REMOVE BLACKLIST REGIONS FROM 'REGION'     
		bl_region_temp = []
		input_stream = open(bl)
		input_file = input_stream.readlines()
		for i in range(len(input_file)):
			temp = input_file[i].split()
			temp[1] = int(temp[1])
			temp[2] = int(temp[2])
			bl_region_temp.append(temp)

		## merge overlapping blacklist regions
		if(len(bl_region_temp) == 1):
			bl_region = bl_region_temp
			bl_region = np.array(bl_region)
		else:
			bl_region_temp = np.array(bl_region_temp)
			bl_region_temp = bl_region_temp[np.lexsort( ( bl_region_temp[:,1].astype(int), bl_region_temp[:,0] ) )]
			bl_region_temp = bl_region_temp.tolist()

			bl_region = []
			pos = 0
			pastChromo = bl_region_temp[pos][0]
			pastStart = int(bl_region_temp[pos][1])
			pastEnd = int(bl_region_temp[pos][2])
			bl_region.append([pastChromo, pastStart, pastEnd])
			resultIdx = 0

			pos = 1
			while( pos < len(bl_region_temp) ):
				currChromo = bl_region_temp[pos][0]
				currStart = int(bl_region_temp[pos][1])
				currEnd = int(bl_region_temp[pos][2])

				if( (currChromo == pastChromo) and (currStart >= pastStart) and (currStart <= pastEnd)):
					bl_region[resultIdx][2] = currEnd
					pos = pos + 1
					pastChromo = currChromo
					pastStart = currStart
					pastEnd = currEnd
				else:
					bl_region.append([currChromo, currStart, currEnd])
					resultIdx = resultIdx + 1
					pos = pos + 1
					pastChromo = currChromo
					pastStart = currStart
					pastEnd = currEnd
			bl_region = np.array(bl_region)

		region_woBL = []
		for region in REGION:
			regionChromo = region[0]
			regionStart = int(region[1])
			regionEnd = int(region[2])

			overlapped_bl = []
			## overlap Case 1 : A blacklist region completely covers the region. 
			idx = np.where( (bl_region[:,0] == regionChromo) & (bl_region[:,1].astype(int) <= regionStart) & (bl_region[:,2].astype(int) >= regionEnd) )[0]
			if(len(idx) > 0):
				continue

			## overlap Case 2 
			idx = np.where( (bl_region[:,0] == regionChromo) & (bl_region[:,2].astype(int) > regionStart) & (bl_region[:,2].astype(int) <= regionEnd) )[0]
			if(len(idx) > 0):
				overlapped_bl.extend( bl_region[idx].tolist() )

			## overlap Case 3
			idx = np.where( (bl_region[:,0] == regionChromo) & (bl_region[:,1].astype(int) >= regionStart) & (bl_region[:,1].astype(int) < regionEnd) )[0]
			if(len(idx) > 0):
				overlapped_bl.extend( bl_region[idx].tolist() )

			if(len(overlapped_bl) == 0):
				region_woBL.append(region)
				continue

			overlapped_bl = np.array(overlapped_bl)
			overlapped_bl = overlapped_bl[overlapped_bl[:,1].astype(int).argsort()]
			overlapped_bl = np.unique(overlapped_bl, axis=0)
			overlapped_bl = overlapped_bl[overlapped_bl[:,1].astype(int).argsort()]

			currStart = regionStart
			for pos in range(len(overlapped_bl)):
				blStart = int(overlapped_bl[pos][1])
				blEnd = int(overlapped_bl[pos][2])

				if( blStart <= regionStart ):
					currStart = blEnd
				else:
					if(currStart == blStart):
						currStart = blEnd
						continue

					region_woBL.append([ regionChromo, currStart, blStart ])
					currStart = blEnd

				if( (pos == (len(overlapped_bl)-1)) and (blEnd < regionEnd) ):
					if(blEnd == regionEnd):
						break
					region_woBL.append([ regionChromo, blEnd, regionEnd ])

		REGION = region_woBL


	# check if all chromosomes in the REGION in bigwig files
	bw = pyBigWig.open(CTRLBW_NAMES[0])
	region_final = []
	for regionIdx in range(len(REGION)):
		chromo = REGION[regionIdx][0]
		start = int(REGION[regionIdx][1])
		end = int(REGION[regionIdx][2])

		chromoLen = bw.chroms(chromo)
		if(chromoLen == None):
			continue
		if(end > chromoLen):
			REGION[regionIdx][2] = chromoLen
			if( chromoLen <= start ):
				continue
		region_final.append([chromo, start, end])
	bw.close()

	REGION = region_final	

	return


def setFilterCriteria(minFrag):
	global FILTERVALUE

	if(minFrag == None):
		FILTERVALUE = int(SAMPLE_NUM)		
	else:
		FILTERVALUE = int(minFrag)

	return


def setScaler(scalerResult):
	global CTRLSCALER
	global EXPSCALER

	CTRLSCALER = [0] * CTRLBW_NUM
	EXPSCALER = [0] * EXPBW_NUM
	CTRLSCALER[0] = 1

	for i in range(1, CTRLBW_NUM):
		CTRLSCALER[i] = scalerResult[i-1]
	for i in range(EXPBW_NUM):
		EXPSCALER[i] = scalerResult[i+CTRLBW_NUM-1]
	
	return


def setBinSize(binSize):
	global BINSIZE

	BINSIZE = int(binSize)

	return

def setNumProcess(numProcess):
	global NUMPROCESS
	
	system_cpus = int(multiprocessing.cpu_count())

	if(numProcess == None):
		NUMPROCESS = int(system_cpus / 2.0 )
		if(NUMPROCESS < 1):
			NUMPROCESS = 1
	else:
		NUMPROCESS = int(numProcess)

	if(NUMPROCESS > system_cpus):
		print("ERROR: You specified too many cpus! (-p). Running with the maximum cpus in the system")
		NUMPROCESS = system_cpus

	return

def setNormalization(norm, generateNormBW):
	global I_NORM
	global I_GENERATE_NormBW

	if(norm.lower() == 'false'):
		I_NORM = False
	else:
		I_NORM = True	

	if(generateNormBW.lower() == 'false'):
		I_GENERATE_NormBW = False
	else:
		I_GENERATE_NormBW = True

	if((I_NORM == False) and (I_GENERATE_NormBW == True)):
		print("ERROR: I_NOMR should be 'True' if I_GENERATE_NormBW is 'True'")
		sys.exit()

	return
