source('environment.r')


#set a seed so sampling is consistent between runs of this code
#new normalization -- first sample each replicates at min depth, and combine sampled replicates.



set.seed(9)

nuc.counts<-data.frame(experiment=character(),
                       title=character(),
                       nuc1LTotal=integer(),
                       nuc3RTotal=integer(),
                       nfrTotal=integer(),
                       nuc1LR1=integer(),
                       nuc3RR1=integer(),
                       nfrRR1=integer(),
                       nuc1LR2=integer(),
                       nuc3RR2=integer(),
                       nfrRR2=integer()
)

parent.dir <- 'data'

replicate.1.filenames <- get_filenames_group(parent.dir, 1, FALSE)
replicate.2.filenames <- get_filenames_group(parent.dir, 2, FALSE)
replicate.1.chr2.filenames <- get_filenames_group(parent.dir, 1, TRUE)
replicate.2.chr2.filenames <- get_filenames_group(parent.dir, 2, TRUE)


#provide a vector of labels for the samples used in this experiment

titles = c("Pre-Induction",
           "15 Mins",
           "30 Mins",
           "60 Mins",
           "90 Mins",
           "120 Mins"
)


#now we can start to make our dot plots & pictographs with the idealized nucleosome analysis complete

nuc.stats<-read.table('nuc_stats.df')
experiment=c("WT", "YKU70", "MRE11")

pictographtitle=c("WT Nucleosome Positioning",
        expression(italic("yku70")*italic(Delta)*" Nucleosome Positioning"),
        expression(italic("mre11")*italic(Delta)*" Nucleosome Positioning"))

for (e in 0:2){
  
  exp=which(nuc.stats[,1]==experiment[e+1])  
  nucleosome_size=nuc.stats[exp,'nucleosome_size']
  var_x=nuc.stats[exp,'var_x']
  var_y=nuc.stats[exp,'var_y']
  std_x=nuc.stats[exp,'std_x']
  std_y=nuc.stats[exp,'std_y']
  
  depth.r1 = vector()
  depth.r2 = vector()
  
  
  
  
  for (j in (1+e*6):(6+e*6)){
    
    replicate.1.filename = as.character(replicate.1.filenames[j])
    replicate.2.filename = as.character(replicate.2.filenames[j])
    
    #read in the bam files to data frames
    chr = "chrII"
    df2 = get_dot_mat(replicate.1.filename, chr, 1, get_chr_length(replicate.1.filename, chr))
    df3 = get_dot_mat(replicate.2.filename, chr, 1, get_chr_length(replicate.2.filename, chr))
    
   
    
    depth.r1 = c(depth.r1, dim(df2)[1])
    depth.r2 = c(depth.r2, dim(df3)[1])
    
    #df_2 = rbind(df2, df3)
    
    #depth.v = c(depth.v, dim(df_2)[1])
  }
  
  sampling_depth.r1 = min(depth.r1)
  sampling_depth.r2 = min(depth.r2)
  
  
  #generate the idealized nucleosome 2d kernel
  #find cross correlation score to kernel density across the region of interest
  library(reshape)
  library(mvtnorm)
  library(lattice)
  
  # all lengths and positions
  lengths <- seq(1, 250, by = 1)
  pos <- seq(-75, 75, by = 1)
  
  # combinatorial combination of lengths and positions
  dens.df <- as.data.frame(expand.grid(lengths, pos))
  colnames(dens.df) <- c('length', 'pos')
  
  #note we are using variance here not std_dev as we will use later so we use 1/4 variance which is 1/2 std-dev
  get.density <- function(row)
  {
    length.mean <- nucleosome_size
    pos.mean <- 0
    length.std <- var_y/4
    pos.std <- var_x/4
    
    covmat <- matrix(c(length.std, 0, 0, pos.std), ncol=2)
    return(dmvnorm(c(row[1], row[2]), mean=c(length.mean, pos.mean), sigma=covmat))
  }
  
  # get the density for each pair of length and pos
  dens.df$density <- apply(dens.df, 1, get.density)
  
  # pivot narrow length, pos dataframe into a kernel matrix: 
  # each row is a length, each column is a position
  kernel.df <- cast(dens.df, length ~ pos, value='density')
  kernel.mat <- as.matrix(kernel.df)
  
  #plot the idealized nucleosome/2d kernel
  
  png(filename = "2d_kernel_wt.png", width = 5, height = 10, units = "in",  res = 300)
  levelplot(t(kernel.mat),
            main = "Idealized Nucleosome (WT) 2D Kernel",
            xlab = "Pos From Nucleosome Center",
            ylab = "Fragment Size",
            colorkey = list(labels = list(col="white")
            ),
            scales=
              list(
                x= list(at = seq(0,151,25),
                        labels = seq(-75,75,25)),
                y = list(at = seq(0,250,50),
                         labels = seq(0,250,50))
              ),
            col.regions = colorRampPalette(c("white","blue"))(100)
  )
  
  dev.off()
  
  
  #calculate the distribution of 2d cross correlation values for every nucleosome on chrIV (based on broggard date) and set a threshold (10%) for what we will call as nucleosomes in the data
  #do this on the preinduction sample
  
  i = e*6+1
  
  if (i == 1 || i == 7 || i == 13){
    
    replicate.1.filename = as.character(replicate.1.filenames[i])
    replicate.2.filename = as.character(replicate.2.filenames[i])
    
    #read in the bam files to data frames
    chr = "chrIV"
    df2 = get_dot_mat(replicate.1.filename, chr, 1, get_chr_length(replicate.1.filename, chr))
    df3 = get_dot_mat(replicate.2.filename, chr, 1, get_chr_length(replicate.2.filename, chr))
    
    
    #read in the bam files to data frames and sample to the lowest depth
    #chr = "chrIV"
    #df2 = get_dot_mat(as.character(sacCer3_files2[i]), chr, 1, get_chr_length(as.character(sacCer3_files2[i]), chr))
    #df3 = get_dot_mat(as.character(sacCer3_files3[i]), chr, 1, get_chr_length(as.character(sacCer3_files3[i]), chr))
    
    df_2 = rbind(df2[sample(nrow(df2),(sampling_depth.r1/813184)*1531933, replace = F),], df3[sample(nrow(df3),(sampling_depth.r2/813184)*1531933, replace = F),])
    
    set.seed(9)
    
    
    norm.df = df_2
    
    rm(df2,df3,df_2)
    
    
    reads.m = get_matrix_from_df(norm.df, 1, get_chr_length(as.character(replicate.1.filenames[j]), chr))
    
    #run a sliding correlation at every base between the idealized nucleosome and the chrIV data
    score = signal$correlate2d(reads.m,kernel.mat, mode='valid')
    chrIV_cor.v = as.vector(score[1,])
    
    #shift the chrIV_cor.v vector by padding 75bp to adjust for the size of the idealized nucleosome sliding window (1/2 of 150bp)
    
    chrIV_cor.v = c(rep(0,75),chrIV_cor.v)
    
    #normalize to read depth and scale
    scaling_factor = (dim(norm.df)[1]/1531933)*2016
    chrIV_cor.v = (chrIV_cor.v)*10000/scaling_factor
    
    rm(norm.df)
    
    #cor.v contains all the correlation values for ChrIV
    #find the cor values for the nucs on broggard positions
    #use wget to get the unique nuc positions from the broggard published data set
    #https://www.nature.com/articles/nature11142
    #https://media.nature.com/original/nature-assets/nature/journal/v486/n7404/extref/nature11142-s2.txt
    
    #make a vector with all the x positions of the nucleosomes on chrIV
    chr4_nucs_pos = broggard_unique.df$pos[which(broggard_unique.df$chrom == "chrIV")]
    
    #subset the correlation vector for all of chrIV on the nuc position vector
    chr4_nucs_cor.v = chrIV_cor.v[chr4_nucs_pos]
    
    #remove 0 values
    chr4_nucs_cor.v = chr4_nucs_cor.v[chr4_nucs_cor.v!=0]
    
    #plot this distribution to see what it looks like
    plot(density(chr4_nucs_cor.v))
    
    #get the statistics for this distribution
    summary(chr4_nucs_cor.v)
    
    #set the threshold at the 10th percentile of all nucleosomes
    threshold_value = quantile(chr4_nucs_cor.v, 0.1)
    
    
    rm(reads.m)
    
  }
  
  #now we are ready to generate the dot plots
  #start by defining the window we want to plot
  
  ho_start = 431525
  
  ho_end = 431641
  
  start = ho_start-900
  
  end = ho_end+1000
  
  chr = "chrII"
  
  #name the file and initialize the plotting window
  file_name = paste("figures/Figure_3_",experiment[exp], "_pho5.png", sep="")
  png(file_name, width = 4, height = 10, units = "in", res = 300)
  par(mfcol=c(7,1))
  
  #this function plots the gene bodies on top of the typhoon plots in gray boxes. if you only want annotated protein coding genes set the proteinCoding = T, otherwise if you set it to F (as i have done here) every ORF will be represented
  par(mar=c(1,3,3.5,4))
  MakeArrowSchematic_ho("2", start, end, cex_title = 1.5, proteinCoding = F)
  
  #annotate the location of small factors (based on taking the midpoint of SGD position data)
  
  text(x= (431878+431888+117*2)/2,
       y = .25,
       labels = expression(bold("Sum1p")),
       srt = 90,
       cex = 1.2
  )
  
  #annotate the HO cut site
  text(x= (ho_start+ho_end)/2,
       y = .25,
       labels = expression(bold("HOcs")),
       #las = 2
       srt = 90,
       cex = 1.2
  )
  
  par(mar=c(3,3,1,4))
  
  #initialize lists that contain the quantitative parameters describing nucleosomes in this plotting window
  
  nuc_occupancy.l = list()
  nuc_pos.l = list()
  nuc_fuzz.l = list()
  
  #begin analysis + plotting for each sample
  
  #normalize to chr2 sample depth
  depth.v = vector()
  depth.r1 = vector()
  depth.r2 = vector()
  
  for (i in 1:6){
    
    replicate.1.filename = as.character(replicate.1.chr2.filenames[i+e*6])
    replicate.2.filename = as.character(replicate.2.chr2.filenames[i+e*6])
    
    #read in the bam files to data frames
    chr = "chrII"
    df2 = get_dot_mat(replicate.1.filename, chr, 1, get_chr_length(replicate.1.filename, chr))
    df3 = get_dot_mat(replicate.2.filename, chr, 1, get_chr_length(replicate.2.filename, chr))
    
    #read in the bam files to data frames
   # chr = "chrII"
    #df2 = get_dot_mat(as.character(chr2_files2[i+e*6]), chr, 1, get_chr_length(as.character(chr2_files2[i+e*6]), chr))
    #df3 = get_dot_mat(as.character(chr2_files3[i+e*6]), chr, 1, get_chr_length(as.character(chr2_files3[i+e*6]), chr))
    
    #df_2 = rbind(df2, df3)
    
    #depth.v = c(depth.v, dim(df_2)[1])
    depth.r1=c(depth.r1,dim(df2)[1])
    depth.r2=c(depth.r2,dim(df3)[1])
  }
  
 # sampling_depth = min(depth.v)
  sampling_depth.r1 = min(depth.r1)
  sampling_depth.r2 = min(depth.r2)
  
  for (i in 1:6){
    
    replicate.1.filename = as.character(replicate.1.chr2.filenames[i+e*6])
    replicate.2.filename = as.character(replicate.2.chr2.filenames[i+e*6])
    
    #read in the bam files to data frames
    chr = "chrII"
    df2 = get_dot_mat(replicate.1.filename, chr, 1, get_chr_length(replicate.1.filename, chr))
    df3 = get_dot_mat(replicate.2.filename, chr, 1, get_chr_length(replicate.2.filename, chr))
    
    #read in the bam files to data frames and normalize to lowest read depth
    #chr = "chrII"
    #df2 = get_dot_mat(as.character(chr2_files2[i+e*6]), chr, 1, get_chr_length(as.character(chr2_files2[i+e*6]), chr))
    #df3 = get_dot_mat(as.character(chr2_files3[i+e*6]), chr, 1, get_chr_length(as.character(chr2_files3[i+e*6]), chr))
    
   # df_2 = rbind(df2, df3)
    
    df_2 = df2[sample(nrow(df2),sampling_depth.r1, replace = F),]
    df_3 = df3[sample(nrow(df3),sampling_depth.r2, replace = F),]
    
    
    #norm.df = df_2[sample(nrow(df_2), sampling_depth, replace = FALSE),]
    
    df_1 = rbind(df_2,df_3)
    
    reads.m = get_matrix_from_df(df_1, 
                                 (start-76), (end+151))
    
    
    cor.v = vector()
    
    #run the sliding cross correlation to the idealized nucleosome/2d kernel for this plotted window
    
    for (n in 1:((end)-(start-76))){
      
      mod_start = n
      mod_end = n + 150
      
      temp_window = reads.m[1:250,mod_start:mod_end]
      
      score = signal$correlate2d(temp_window,kernel.mat, mode='valid')
      cor.v = c(cor.v, score)
      
    }
    
    #subet the vector on the window we are plotting
    cor.v = cor.v[1:((end)-start)]
    
    #not sure why vinay renamed an exisitg variable.  will put the normalized counts in df1
    #df_1 = norm.df
    #df2 = df2[sample(nrow(df2), sampling_depth.r1, replace = FALSE),]
    #df3 = df3[sample(nrow(df3), sampling_depth.r2, replace = FALSE),]
    
    #subset the data we read in above on the window we want to plot
    window.df = df_1[which(df_1$mpoint<(end) & df_1$mpoint>start),]
    
    #scale the correlation vector
    cor.v = cor.v*10000/dim(window.df)[1]
    
    #create a color palate that defines color based on relative read density within a 2D region
    dcolor = densColsDM(window.df$mpoint, window.df$fsize,
                        nbin=c(1024,1024), 
                        bandwidth=c(36,16), 
                        transformation = function(x) x^.5,
                        colramp = colorRampPalette(brewer.pal(9, "Oranges")),
                        z_factor = 1
    )
    
    #make sure you plot axis labels but only for the bottom plot (to save space)
    if (i == 6){
      plot(window.df$mpoint, window.df$fsize, 
           col=dcolor, 
           cex=0.25, pch=20, 
           main=titles[i], 
           xlab='ChrII Position (bp)', 
           ylab='Fragment Size',
           #xaxt = "n",
           mgp = c(2, 1, 0),
           cex.axis = 0.8,
           xaxs = "i"
      )
    } else{
      
      plot(window.df$mpoint, window.df$fsize, 
           col=dcolor, 
           cex=0.25, pch=20, 
           main=titles[i], 
           xlab='', 
           ylab='Fragment Size',
           #xaxt = "n",
           mgp = c(2, 1, 0),
           cex.axis = 0.8,
           xaxs = "i"
      )
      
    }
    
    #plot the borders of the HO cut site
    abline(v = ho_start, col = "blue", lty = "dotted")
    abline(v = ho_end, col = "blue", lty = "dotted")
    
    #find the peaks of the cross-correlation curve
    peaks.df = data.frame(findpeaks(smooth.spline(cor.v, spar = .001)$y, 
                                    minpeakdistance = 75, 
                                    minpeakheight = threshold_value, 
                                    sortstr= TRUE,
                                    nups= 1))
    
    #annotate the called peak data set
    colnames(peaks.df) = c("height", "center", "start", "end")
    
    #sort peaks by position
    peaks.v = sort(peaks.df$center)
    
    #update the lists for each sample with the position of called peaks (nucleosomes) and their corresponding correlation score (Fuzziness)
    nuc_pos.l[[i]] = peaks.v+start
    nuc_fuzz.l[[i]] = cor.v[peaks.v]
    nuc_pos.v = vector()
    
    y = nucleosome_size
    x = peaks.v+start
    
    for (p in 1:length(x)){
      nuc_window.df = df_1[which(df_1$mpoint<=(x[p]+std_x) &
                                  df_1$mpoint>=(x[p]-std_x) &
                                  df_1$fsize>=(y-std_y) &
                                  df_1$fsize<=(y+1*std_y)),] #expand y to catch larger fragments which may be remodeler complexes
      
      
      nuc_pos.v = c(nuc_pos.v, dim(nuc_window.df)[1])
      
      rect(xleft = x[p]-std_x,
           ybottom = 0,
           ytop = 250,
           xright = x[p]+std_x,
           border = NA,
           col = rgb(0,0,1.0,alpha=.15*nuc_fuzz.l[[i]][p]/max(unlist(nuc_fuzz.l))))
      
    }
    
    #use the nucleosome positions in the uninduced sample to track changes in subsequent samples
    
    nuc1L = nuc_pos.l[[1]][5]
    
    nuc3R = nuc_pos.l[[1]][8]
    
    nfr = (nuc_pos.l[[1]][4] + nuc_pos.l[[1]][5])/2
    
    #annotate the nuc1L position with a blue arrow
    
    points(x= nuc1L,
           y = 235,
           pch = 25,
           cex = 1,
           col = "deepskyblue3",
           bg="deepskyblue3")
    
    #count the nucleosomal reads at 1L
    
    x = nuc1L
    y = nucleosome_size
    
    nuc_window.df = df_1[which(df_1$mpoint<=(x+std_x) &
                                df_1$mpoint>=(x-std_x) &
                                df_1$fsize>=(y-std_y) &
                                df_1$fsize<=(y+1*std_y)),]
    
    nuc_window.df2 = df_2[which(df_2$mpoint<=(x+std_x) &
                                 df_2$mpoint>=(x-std_x) &
                                 df_2$fsize>=(y-std_y) &
                                 df_2$fsize<=(y+1*std_y)),]
    
    nuc_window.df3 = df_3[which(df_3$mpoint<=(x+std_x) &
                                 df_3$mpoint>=(x-std_x) &
                                 df_3$fsize>=(y-std_y) &
                                 df_3$fsize<=(y+1*std_y)),]
    
    
    
    
    
    nuc1L.counts=dim(nuc_window.df)[1]
    nuc1LR1.counts=dim(nuc_window.df2)[1]
    nuc1LR2.counts=dim(nuc_window.df3)[1]
    
    
    #comment or uncomment this line below to get the occupancy (read) counts for each nucleosome printed on the graph
    #this is what is plotted for nucleosome kinetics in the line plots
    ##text(x = nuc1L, y = 60, labels = nuc1L.counts, cex = 0.75)
    
    #annotate the nuc3R position with a gold arrow
    points(x= nuc3R,
           y = 235,
           pch = 25,
           cex = 1,
           col = "darkgoldenrod3",
           bg="darkgoldenrod3")
    
    #count the nucleosomal reads at 3R
    x = nuc3R
    y = nucleosome_size
    
    nuc_window.df = df_1[which(df_1$mpoint<=(x+std_x) &
                                df_1$mpoint>=(x-std_x) &
                                df_1$fsize>=(y-std_y) &
                                df_1$fsize<=(y+1*std_y)),]
    
    nuc_window.df2 = df_2[which(df_2$mpoint<=(x+std_x) &
                                 df_2$mpoint>=(x-std_x) &
                                 df_2$fsize>=(y-std_y) &
                                 df_2$fsize<=(y+1*std_y)),]
    
    nuc_window.df3 = df_3[which(df_3$mpoint<=(x+std_x) &
                                 df_3$mpoint>=(x-std_x) &
                                 df_3$fsize>=(y-std_y) &
                                 df_3$fsize<=(y+1*std_y)),]
    
    
    
    
    
    nuc3R.counts=dim(nuc_window.df)[1]
    nuc3RR1.counts=dim(nuc_window.df2)[1]
    nuc3RR2.counts=dim(nuc_window.df3)[1]
    
    
    
    
    #comment or uncomment this line below to get the occupancy (read) counts for each nucleosome printed on the graph
    #this is what is plotted for nucleosome kinetics in the line plots
    #text(x, y = 60, labels = nuc3R.counts, cex = 0.75)
    
    #annotate the NFR with a red arrow
    points(x= nfr,
           y = 235,
           pch = 25,
           cex = 1,
           col = "red",
           bg="red")
    
    #count the nucleosomal reads in the NFR
    x = nfr
    y = nucleosome_size
    
    nuc_window.df = df_1[which(df_1$mpoint<=(x+std_x) &
                                df_1$mpoint>=(x-std_x) &
                                df_1$fsize>=(y-std_y) &
                                df_1$fsize<=(y+1*std_y)),]
    
    nuc_window.df2 = df_2[which(df_2$mpoint<=(x+std_x) &
                                 df_2$mpoint>=(x-std_x) &
                                 df_2$fsize>=(y-std_y) &
                                 df_2$fsize<=(y+1*std_y)),]
    
    nuc_window.df3 = df_3[which(df_3$mpoint<=(x+std_x) &
                                 df_3$mpoint>=(x-std_x) &
                                 df_3$fsize>=(y-std_y) &
                                 df_3$fsize<=(y+1*std_y)),]
    
    
    
    
    
    nfr.counts=dim(nuc_window.df)[1]
    nfrR1.counts=dim(nuc_window.df2)[1]
    nfrR2.counts=dim(nuc_window.df3)[1]
    
    
    
    #comment or uncomment this line below to get the occupancy (read) counts for each nucleosome printed on the graph
    #this is what is plotted for nucleosome kinetics in the line plots
    ##text(x, y = 60, labels =nfr.counts, cex = 0.75)
    
    
    nuc_occupancy.l[[i]] = nuc_pos.v
    #abline(v = peaks.v, col = "deeppink")
    
    par(new=TRUE)
    
    plot(cor.v, 
         type = "l",
         ylim = c(0, 0.2),
         axes = FALSE,
         ann=FALSE,
         col = "darkslategray",
         xaxs = "i"
    )
    
    
    print(titles[i])
    
    nuc.counts=rbind(nuc.counts,data.frame(experiment=experiment[exp],title=titles[i],nuc1LTotal=nuc1L.counts,nuc3RTotal=nuc3R.counts,nfrTotal=nfr.counts,nuc1LR1=nuc1LR1.counts,nuc3RR1=nuc3RR1.counts,nfrR1=nfrR1.counts,nuc1LR2=nuc1LR2.counts,nuc3RR2=nuc3RR2.counts,nfrR2=nfrR2.counts))  
    
    
  }
  
  
  
  dev.off()
  
  
  #plot the nucleosome pictographs
  
  file_name = paste("figures/Figure_4A_",experiment[exp], "_pho5.png", sep="")
  png(file_name, width = 6, height = 6, units = "in", res = 300)
  #par(bg=NA)
  par(mfcol=c(2,1))
  
  #this function plots the gene bodies on top of the typhoon plots in gray boxes. if you only want annotated protein coding genes set the proteinCoding = T, otherwise if you set it to F (as i have done here) every ORF will be represented
  par(mar=c(1,3.5,8,1))
  MakeArrowSchematic_ho("2", start, end, cex_title = 1.5, proteinCoding = F)
  text(x= (431878+431888+117*2)/2,
       y = .25,
       labels = expression(bold("Sum1")),
       srt = 90,
       cex = 1.2
  )
  
  text(x= (ho_start+ho_end)/2,
       y = .25,
       labels = expression(bold("HOcs")),
       #las = 2
       srt = 90,
       cex = 1.2
  )
  
  
  
  par(mar=c(3.5,3.5,1,1))
  
  i = 1
  
  heights = c(13, 11.5, 10, 7, 4, 1)
  
  x <- nuc_pos.l[[i]]
  
  nuc_scale<-nuc_occupancy.l[[i]]/max(nuc_occupancy.l[[1]])
  nuc_scale[which(nuc_scale>1)]=1
  nuc_fuzzy<-nuc_fuzz.l[[i]]/max(nuc_fuzz.l[[1]])
  nuc_fuzzy[which(nuc_fuzzy>1)]=1
  
  plot(x = x,
       y = rep(heights[i], length(x)),
       pch = 19, 
       ylab = "Time Post Induction (Mins)", 
       xlab = "ChrII Position (bp)", 
       cex = 2.5*nuc_scale,
       col = rgb(0,0,1, alpha = nuc_fuzzy),
       ylim = c(0,14),
       yaxt='n',
       main = pictographtitle[e+1],
       mgp = c(2.5, 1, 0),
       cex.axis = 0.8,
       xlim = c(start,end),
       xaxs = "i"
  )
  
  abline(v = ho_start, col = "blue", lty = "dotted")
  abline(v = ho_end, col = "blue", lty = "dotted")
  
  axis(2, at = c(13, 11.5, 10, 7, 4, 1), 
       labels = c("Pre", "15", "30", "60", "90", "120"),
       las=1,
       cex = 0.8)
  
  for (i in 2:6){
    
    
    x <- nuc_pos.l[[i]]
    
    nuc_scale<-nuc_occupancy.l[[i]]/max(nuc_occupancy.l[[1]])
    nuc_scale[which(nuc_scale>1)]=1
    nuc_fuzzy<-nuc_fuzz.l[[i]]/max(nuc_fuzz.l[[1]])
    nuc_fuzzy[which(nuc_fuzzy>1)]=1
    
    points(x = x,
           y = rep(heights[i], length(x)),
           pch = 19, 
           ylab = "Time Post Induction", 
           xlab = "Position (ChrII)", 
           cex = 2.5*nuc_scale,
           col = rgb(0,0,1, alpha = nuc_fuzzy),
           ylim = c(0,14),
           yaxt='n',
           main = "WT Pho5 Nucleosome Positioning",
           mgp = c(2, 1, 0),
           cex.axis = 0.8
    )
    
  }
  
  dev.off()
  print(experiment[exp])
  for (n in 1:6){
    print(sum(nuc_occupancy.l[[n]]))
  }
  
}


#build the kinetic plots 
wt_1.nuc=nuc.counts[1:6,"nuc1LTotal"]
yku70_1.nuc=nuc.counts[7:12,"nuc1LTotal"]
mre11_1.nuc=nuc.counts[13:18,"nuc1LTotal"]

wt_3.nuc=nuc.counts[1:6,"nuc3RTotal"]
yku70_3.nuc=nuc.counts[7:12,"nuc3RTotal"]
mre11_3.nuc=nuc.counts[13:18,"nuc3RTotal"]

wt_nfr.nuc=nuc.counts[1:6,"nfrTotal"]
yku70_nfr.nuc=nuc.counts[7:12,"nfrTotal"]
mre11_nfr.nuc=nuc.counts[13:18,"nfrTotal"]


timecourse=c(0,15,30,60,90,120)

file_name = paste("figures/Figure_4B_nuc1L_kinetics.png", sep="")
png(file_name, width = 5, height = 4, units = "in", res = 300)
#par(bg=NA)
plot(x = timecourse,
     y = log2(wt_1.nuc/wt_1.nuc[1]),
     type = "b",
     xlab = "Time (Minutes)",
     ylab = "Log2 Occupancy (Relative)",
     ylim = c(-5,0),
     xaxt = 'n',
     yaxt = 'n',
     pch = 0,
     main = "Nucleosomal Fragment Kinetics (1L)"
)




axis(1,
     at = c(0, 15, 30, 60, 90, 120),
     labels = c(0, 15, 30, 60, 90, 120))

axis(2,
     at = seq(-5,0,1),
     labels = seq(-5,0,1))



points(x = timecourse,
       y = log2(nuc.counts[1:6,"nuc1LR1"]/nuc.counts[1,"nuc1LR1"]),
       type = "p",
       xaxt = 'n',
       yaxt = 'n',
       lty = 2,
       pch = 0,
       col='gray'
)

points(x = timecourse,
       y = log2(nuc.counts[1:6,"nuc1LR2"]/nuc.counts[1,"nuc1LR2"]),
       type = "p",
       xaxt = 'n',
       yaxt = 'n',
       lty = 2,
       pch = 0,
       col='gray'
)

points(x = timecourse,
       y = log2(nuc.counts[7:12,"nuc1LR1"]/nuc.counts[7,"nuc1LR1"]),
       type = "p",
       xaxt = 'n',
       yaxt = 'n',
       lty = 2,
       pch = 1,
       col="gray"
)

points(x = timecourse,
       y = log2(nuc.counts[7:12,"nuc1LR2"]/nuc.counts[7,"nuc1LR2"]),
       type = "p",
       xaxt = 'n',
       yaxt = 'n',
       lty = 2,
       pch = 1,
       col="gray"
)

points(x = timecourse,
       y = log2(nuc.counts[13:18,"nuc1LR1"]/nuc.counts[13,"nuc1LR1"]),
       type = "p",
       xaxt = 'n',
       yaxt = 'n',
       lty = 2,
       pch = 2,
       col="gray"
)

points(x = timecourse,
       y = log2(nuc.counts[13:18,"nuc1LR2"]/nuc.counts[13,"nuc1LR2"]),
       type = "p",
       xaxt = 'n',
       yaxt = 'n',
       lty = 2,
       pch = 2,
       col="gray"
)

lines(x = timecourse,
      y = log2(wt_1.nuc/wt_1.nuc[1]),
      type = "b",
      #xlab = "Time",
      #ylab = "Fraction Cut",
      #ylim = c(0,1),
      xaxt = 'n',
      yaxt = 'n',
      lty = 2,
      pch = 0
)

lines(x = timecourse,
      y = log2(yku70_1.nuc/yku70_1.nuc[1]),
      type = "b",
      #xlab = "Time",
      #ylab = "Fraction Cut",
      #ylim = c(0,1),
      xaxt = 'n',
      yaxt = 'n',
      lty = 2,
      pch = 1
)

lines(x = timecourse,
      y = log2(mre11_1.nuc/mre11_1.nuc[1]),
      type = "b",
      #xlab = "Time",
      #ylab = "Fraction Cut",
      ylim = c(0,1),
      xaxt = 'n',
      yaxt = 'n',
      lty = 4,
      pch = 2
)


legend(15,
       -3,
       legend = c("WT", 
                  expression(italic("yku70")*italic(Delta)), 
                  expression(italic("mre11")*italic(Delta))),
       lty = c(1,2,4),
       pch = c(0,1,2),
       cex = 0.75
       
)
dev.off()

file_name = paste("figures/Figure_4C_nuc3R_kinetics.png", sep="")
png(file_name, width = 5, height = 4, units = "in", res = 300)
#par(bg=NA)
plot(x = timecourse,
     y = log2(wt_3.nuc/wt_3.nuc[1]),
     type = "b",
     xlab = "Time (Minutes)",
     ylab = "Log2 Occupancy (Relative)",
     ylim = c(-3,3),
     xaxt = 'n',
     yaxt = 'n',
     pch = 0,
     main = "Nucleosomal Fragment Kinetics (3R)"
)

axis(1,
     at = c(0, 15, 30, 60, 90, 120),
     labels = c(0, 15, 30, 60, 90, 120))

axis(2,
     at = seq(-3,3,1),
     labels = seq(-3,3,1))



points(x = timecourse,
       y = log2(nuc.counts[1:6,"nuc3RR1"]/nuc.counts[1,"nuc3RR1"]),
       type = "p",
       xaxt = 'n',
       yaxt = 'n',
       lty = 2,
       pch = 0,
       col='gray'
)

points(x = timecourse,
       y = log2(nuc.counts[1:6,"nuc3RR2"]/nuc.counts[1,"nuc3RR2"]),
       type = "p",
       xaxt = 'n',
       yaxt = 'n',
       lty = 2,
       pch = 0,
       col='gray'
)

points(x = timecourse,
       y = log2(nuc.counts[7:12,"nuc3RR1"]/nuc.counts[7,"nuc3RR1"]),
       type = "p",
       xaxt = 'n',
       yaxt = 'n',
       lty = 2,
       pch = 1,
       col="gray"
)

points(x = timecourse,
       y = log2(nuc.counts[7:12,"nuc3RR2"]/nuc.counts[7,"nuc3RR2"]),
       type = "p",
       xaxt = 'n',
       yaxt = 'n',
       lty = 2,
       pch = 1,
       col="gray"
)

points(x = timecourse,
       y = log2(nuc.counts[13:18,"nuc3RR1"]/nuc.counts[13,"nuc3RR1"]),
       type = "p",
       xaxt = 'n',
       yaxt = 'n',
       lty = 2,
       pch = 2,
       col="gray"
)

points(x = timecourse,
       y = log2(nuc.counts[13:18,"nuc3RR2"]/nuc.counts[13,"nuc3RR2"]),
       type = "p",
       xaxt = 'n',
       yaxt = 'n',
       lty = 2,
       pch = 2,
       col="gray"
)

lines(x = timecourse,
      y = log2(wt_3.nuc/wt_3.nuc[1]),
      type = "b",
      #xlab = "Time",
      #ylab = "Fraction Cut",
      #ylim = c(0,1),
      xaxt = 'n',
      yaxt = 'n',
      lty = 2,
      pch = 0
)

lines(x = timecourse,
      y = log2(yku70_3.nuc/yku70_3.nuc[1]),
      type = "b",
      #xlab = "Time",
      #ylab = "Fraction Cut",
      #ylim = c(0,1),
      xaxt = 'n',
      yaxt = 'n',
      lty = 2,
      pch = 1
)

lines(x = timecourse,
      y = log2(mre11_3.nuc/mre11_3.nuc[1]),
      type = "b",
      #xlab = "Time",
      #ylab = "Fraction Cut",
      ylim = c(0,1),
      xaxt = 'n',
      yaxt = 'n',
      lty = 4,
      pch = 2
)


legend(90,
       3,
       legend = c("WT", 
                  expression(italic("yku70")*italic(Delta)), 
                  expression(italic("mre11")*italic(Delta))),
       lty = c(1,2,4),
       pch = c(0,1,2),
       cex = 0.75
       
)
dev.off()

file_name = paste("figures/Figure_4D_nfr_kinetics.png", sep="")
png(file_name, width = 5, height = 4, units = "in", res = 300)
#par(bg=NA)
plot(x = timecourse,
     y = log2(wt_nfr.nuc/wt_nfr.nuc[1]),
     type = "b",
     xlab = "Time (Minutes)",
     ylab = "Log2 Occupancy (Relative)",
     ylim = c(0,2),
     xaxt = 'n',
     yaxt = 'n',
     pch = 0,
     main = "Linker Region Kinetics",
     # col= "blue"
)

axis(1,
     at = c(0, 15, 30, 60, 90, 120),
     labels = c(0, 15, 30, 60, 90, 120))

axis(2,
     at = seq(0,2,1),
     labels = seq(0,2,1))


points(x = timecourse,
       y = log2(nuc.counts[1:6,"nfrR1"]/nuc.counts[1,"nfrR1"]),
       type = "p",
       xaxt = 'n',
       yaxt = 'n',
       lty = 2,
       pch = 0,
       col='gray'
)

points(x = timecourse,
       y = log2(nuc.counts[1:6,"nfrR2"]/nuc.counts[1,"nfrR2"]),
       type = "p",
       xaxt = 'n',
       yaxt = 'n',
       lty = 2,
       pch = 0,
       col='gray'
)

points(x = timecourse,
       y = log2(nuc.counts[7:12,"nfrR1"]/nuc.counts[7,"nfrR1"]),
       type = "p",
       xaxt = 'n',
       yaxt = 'n',
       lty = 2,
       pch = 1,
       col="gray"
)

points(x = timecourse,
       y = log2(nuc.counts[7:12,"nfrR2"]/nuc.counts[7,"nfrR2"]),
       type = "p",
       xaxt = 'n',
       yaxt = 'n',
       lty = 2,
       pch = 1,
       col="gray"
)

points(x = timecourse,
       y = log2(nuc.counts[13:18,"nfrR1"]/nuc.counts[13,"nfrR1"]),
       type = "p",
       xaxt = 'n',
       yaxt = 'n',
       lty = 2,
       pch = 2,
       col="gray"
)

points(x = timecourse,
       y = log2(nuc.counts[13:18,"nfrR2"]/nuc.counts[13,"nfrR2"]),
       type = "p",
       xaxt = 'n',
       yaxt = 'n',
       lty = 2,
       pch = 2,
       col="gray"
)

lines(x = timecourse,
      y = log2(wt_nfr.nuc/wt_nfr.nuc[1]),
      type = "b",
      #xlab = "Time",
      #ylab = "Fraction Cut",
      #ylim = c(0,1),
      xaxt = 'n',
      yaxt = 'n',
      lty = 2,
      pch = 0
)

lines(x = timecourse,
      y = log2(yku70_nfr.nuc/yku70_nfr.nuc[1]),
      type = "b",
      #xlab = "Time",
      #ylab = "Fraction Cut",
      #ylim = c(0,1),
      xaxt = 'n',
      yaxt = 'n',
      lty = 2,
      pch = 1
)

lines(x = timecourse,
      y = log2(mre11_nfr.nuc/mre11_nfr.nuc[1]),
      type = "b",
      #xlab = "Time",
      #ylab = "Fraction Cut",
      ylim = c(0,1),
      xaxt = 'n',
      yaxt = 'n',
      lty = 4,
      pch = 2
)




legend(90,
       2,
       legend = c("WT", 
                  expression(italic("yku70")*italic(Delta)), 
                  expression(italic("mre11")*italic(Delta))),
       lty = c(1,2,4),
       pch = c(0,1,2),
       cex = 0.75
       
)

dev.off()


for (n in 1:6){
  
  print(
    
    t.test(
      c(log2(nuc.counts[n,"nuc1LR1"]/nuc.counts[1,"nuc1LR1"]), log2(nuc.counts[n,"nuc1LR2"]/nuc.counts[1,"nuc1LR2"])), 
      c(log2(nuc.counts[n+12,"nuc1LR1"]/nuc.counts[13,"nuc1LR1"]),log2(nuc.counts[n+12,"nuc1LR2"]/nuc.counts[13,"nuc1LR2"] ))
      , alternative = "less")$p.value
  ) 
  
}
