#!/bin/bash

PREFETCH=prefetch
SAM_DUMP=sam-dump
WRITE_DIR="data"

# Declare an array of string with type
declare -a SRA_IDS=("SRR13397179" "SRR13397180" "SRR13397181" "SRR13397182" "SRR13397183" "SRR13397184" "SRR13397185" "SRR13397186" "SRR13397187" "SRR13397188" "SRR13397189" "SRR13397190" "SRR13397191" "SRR13397192" "SRR13397193" "SRR13397194" "SRR13397195" "SRR13397196" "SRR13397197" "SRR13397198" "SRR13397199" "SRR13397200" "SRR13397201" "SRR13397202" "SRR13397203" "SRR13397204" "SRR13397205" "SRR13397206" "SRR13397207" "SRR13397208" "SRR13397209" "SRR13397210" "SRR13397211" "SRR13397212" "SRR13397213" "SRR13397214" "SRR13397215" "SRR13397216" "SRR13397217" "SRR13397218" "SRR13397219" "SRR13397220" "SRR13397221" "SRR13397222" "SRR13397223" "SRR13397224" "SRR13397225" "SRR13397226" "SRR13397227" "SRR13397228" "SRR13397229" "SRR13397230" "SRR13397231" "SRR13397232" "SRR13397233" "SRR13397234" "SRR13397235" "SRR13397236" "SRR13397237" "SRR13397238" "SRR13397239" "SRR13397240" "SRR13397241" "SRR13397242" "SRR13397243" "SRR13397244" "SRR13397245" "SRR13397246" "SRR13397247" "SRR13397248" "SRR13397249" "SRR13397250" "SRR13397251" "SRR13397252" "SRR13397253" "SRR13397254" "SRR13397255" "SRR13397256" "SRR13397257" "SRR13397258" "SRR13397259" "SRR13397260" "SRR13397261" "SRR13397262" "SRR13397263" "SRR13397264" "SRR13397265" "SRR13397266" "SRR13397267" "SRR13397268" "SRR13397269" "SRR13397270" "SRR13397271" "SRR13397272" "SRR13397273" "SRR13397274" "SRR13397275" "SRR13397276" "SRR13397277" "SRR13397278" "SRR13397279" "SRR13397280" "SRR13397281" "SRR13397282" "SRR13397283" "SRR13397284" "SRR13397285" "SRR13397286" "SRR13397287" "SRR13397288" "SRR13397289" "SRR13616441" "SRR13397291" "SRR13397292" "SRR13397293" "SRR13397294" "SRR13397295" "SRR13397296" "SRR13397297" "SRR13397298")


# Iterate the string array using for loop
for SRA_ID in ${SRA_IDS[@]}; do
    echo $SRA_ID

    SRA_WRITE_PATH=$WRITE_DIR/${SRA_ID}.sra
    SAM_WRITE_PATH=$WRITE_DIR/${SRA_ID}.sam
    BAM_WRITE_PATH=$WRITE_DIR/${SRA_ID}.bam
    BAM_INDEX_WRITE_PATH=$WRITE_DIR/${SRA_ID}.bam.bai

    CMD="$PREFETCH $SRA_ID --output-file $SRA_WRITE_PATH"
    echo "Prefetching: $CMD"
    eval $CMD

    CMD="$SAM_DUMP $SRA_WRITE_PATH > $SAM_WRITE_PATH"
    echo "Creating SAM: $CMD"
    eval $CMD

    CMD="rm $SRA_WRITE_PATH"
    echo "Deleting SRA: $CMD"
    eval $CMD
    
    CMD="samtools view -b -S $SAM_WRITE_PATH > $BAM_WRITE_PATH"
    echo "Creating BAM: $CMD"
    eval $CMD

    CMD="samtools index $BAM_WRITE_PATH > $BAM_INDEX_WRITE_PATH"
    echo "Creating BAM index: $CMD"
    eval $CMD

    CMD="rm $SAM_WRITE_PATH"
    echo "Deleting SAM: $CMD"
    eval $CMD

    echo "Done."
done

