# set working directory
setwd("")
#read the data
dat<-read.csv("gc_Toxo_Neo.csv",header=TRUE, dec=".")

         
         reg1<-lm(dat$GC1_i ~ dat$GC1)
         reg2<-lm (dat$GC2_i ~ dat$GC2)
         reg3<-lm (dat$GC3_i ~ dat$GC3)
         regi <- lm( dat$GCintron_i ~ dat$GCintron)


m<-matrix(c(1:3),byrow=TRUE,nrow = 1, ncol=3)
layout(m)
layout.show(3)

plot(dat$GC1,dat$GC1_i, xlim=c(0,1),ylim=c(0,1),main="GC1", xlab="N. caninum",ylab="T. gondii", font.lab=3,pch=20)
abline(0,1, col="light grey", lty=1,lwd=1)
text(0.9, 0.05, length(dat$GC1[dat$GC1>dat$GC1_i]), adj=1,cex=0.8)
text( 0.1,1,length(dat$GC1[dat$GC1<dat$GC1_i]),adj=1,cex=0.8)
 abline(reg1) 
 mtext(paste("y=", formatC(reg1$coefficients[2], digits=2),"x + ",formatC(reg1$coefficients[1], digits=2)), adj=1,cex=0.7, line=0)
 text(0.8,1, expression(R^2==0.54),cex=0.8 )
    
plot(dat$GC2,dat$GC2_i, xlim=c(0,1),ylim=c(0,1),main="GC2",xlab="N. caninum",ylab="T. gondii", font.lab=3,pch=20)
abline(0,1, col="light grey", lty=1,lwd=1)
text( 0.9, 0.05,length(dat$GC2[dat$GC2>dat$GC2_i]), adj=1,cex=0.8)
text( 0.1,1, length(dat$GC2[dat$GC2<dat$GC2_i]),adj=1,cex=0.8)
 abline(reg2) 
  mtext(paste("y=", formatC(reg2$coefficients[2], digits=2),"x + ",formatC(reg2$coefficients[1], digits=2)) , adj=1,cex=0.7, line=0)
  text(0.8,1, expression(R^2==0.73),cex=0.8 )

plot(dat$GC3,dat$GC3_i, xlim=c(0,1),ylim=c(0,1),main="GC3", xlab="N. caninum",ylab="T. gondii", font.lab=3,pch=20)
abline(0,1, col="light grey", lty=1,lwd=1)
text(1, 0.05, length(dat$GC3[dat$GC3>dat$GC3_i]), adj=1,cex=0.8)
text(0.1,1, length(dat$GC3[dat$GC3<dat$GC3_i]),adj=1,cex=0.8)
 abline(reg3) 
  mtext(paste("y=", formatC(reg3$coefficients[2], digits=2),"x + ",formatC(reg3$coefficients[1], digits=2)), adj=1,cex=0.7, line=0)
  text(0.8,1, expression(R^2==0.19),cex=0.8 )
  
plot(dat$GCintron,dat$GCintron_i, xlim=c(0,1),ylim=c(0,1),main="GCi", xlab="N. caninum",ylab="T. gondii", font.lab=3,pch=20)
abline(0,1, col="light grey", lty=1,lwd=1)
text(1, 0.05,length(dat$GCintron[dat$GCintron>dat$GCintron_i]), adj=1,cex=0.8)
text(0.1,1, length(dat$GCintron[dat$GCintron<dat$GCintron_i]),adj=1,cex=0.8)
 abline(regi) 
  mtext(paste("y=", formatC(regi$coefficients[2], digits=2),"x + ",formatC(regi$coefficients[1], digits=2)), adj=1,cex=0.7, line=0)
    text(0.8,1, expression(R^2==0.01),cex=0.7 )
dev.copy2pdf(file="GC_ort_numb.pdf")

         nrow(dat$GC1[dat$GC1>dat$GC1_i])

         abline(regi) 
         
         hist(dat$GC3/dat$GC3_i,500, xlim=c(0,2))