# set working directory
setwd("")
#read the data
dat<-read.csv("coa.csv",header=TRUE, dec=".")

reg1<-lm(dat$GC3  ~  dat$Axis1)
reg2<-lm (dat$GC3s ~ dat$Axis1s)
reg3<-lm(dat$y3  ~  dat$Axis2)

m<-matrix(c(1:4),byrow=TRUE,nrow = 2, ncol=2)
layout(m)
layout.show(4)

plot(dat$Axis1,dat$Axis2, xlim=c(-0.8,0.8),ylim=c(-0.8,0.8),main="T. gondii", xlab="Axis 1 (11.32%)",ylab="Axis 2 (4.96%)", font.main=3,pch=20)
abline(0,0, v=0,col="light grey", lty=3,lwd=1)
abline(0,0,col="light grey", lty=3,lwd=1)
plot(dat$Axis1s,dat$Axis2s, xlim=c(-0.8,0.8),ylim=c(-0.8,0.8),main="N. caninum", xlab="Axis 1 (14.48%)",ylab="Axis 2 (3.88%)", font.main=3,pch=20)
abline(0,0, v=0,col="light grey", lty=3,lwd=1)
abline(0,0,col="light grey", lty=3,lwd=1)
   # c(bottom, left, top, right)

par(mar=c(5,4,1,2))
plot(dat$Axis1,dat$GC3,xlim=c(-0.6,0.6), ylim=c(0,0.8), xlab="Axis 1",ylab="GC3", font.main=3,pch=20)
text(0.4,0.8, expression(R^2==0.82),cex=0.7 )
par(mar=c(5,4,1,2))
 abline(reg1)
plot(dat$Axis1s,dat$GC3s,xlim=c(-0.6,0.6),  ylim=c(0,0.8), xlab="Axis 1",ylab="GC3", font.main=3,pch=20)
text(0.4,0.8, expression(R^2==0.92),cex=0.7 )
  abline(reg2)
  
  
  dev.copy2pdf(file="coa.pdf")

 
###################################### COA RSCU  ####################################
coa<-read.csv("coa_rscu_int.csv",header=TRUE, dec=".")

m<-matrix(c(1:2),byrow=TRUE,nrow = 1, ncol=2)
layout(m)
layout.show(2)
                                                      
plot(coa$Axis1_RSCU,coa$Axis2_RSCU, xlim=c(-0.8,0.8),ylim=c(-0.8,0.8),main="T. gondii", xlab="Axis 1 (11.32%)",ylab="Axis 2 (4.96%)", font.main=3,pch=20)
points(coa$Axis1_RSCU[coa$X==1],coa$Axis2_RSCU[coa$X==1], col='#CB181D', pch=20)
abline(0,0, v=0,col="light grey", lty=3,lwd=1)
abline(0,0,col="light grey", lty=3,lwd=1)
legend(-0.83,-0.7, "Ribosomal proteins", col='#CB181D', pch=20, bty= "n", cex=0.9)

reg1<-lm(coa$GC3  ~  coa$Axis1_RSCU)
plot(coa$Axis1_RSCU,coa$GC3,xlim=c(-0.6,0.6), ylim=c(0,0.8), xlab="Axis 1",ylab="GC3", font.main=3,pch=20)
text(0.4,0.8, expression(R^2==0.82),cex=0.8)
abline(reg1)

dev.copy2pdf(file="rscu_int.pdf")

###################################### COA RSCU  ####################################
coas<-read.csv("coa_rscu_sav.csv",header=TRUE, dec=".")

m<-matrix(c(1:2),byrow=TRUE,nrow = 1, ncol=2)
layout(m)
layout.show(2)

plot(coas$Axis1_RSCU,coas$Axis2_RSCU, xlim=c(-0.8,0.8),ylim=c(-0.8,0.8),main="N. caninum", xlab="Axis 1 (14.48%)",ylab="Axis 2 (3.88%)", font.main=3,pch=20)
points(coas$Axis1_RSCU[coa$X==1],coas$Axis2_RSCU[coa$X==1], col='#CB181D', pch=20)
abline(0,0, v=0,col="light grey", lty=3,lwd=1)
abline(0,0,col="light grey", lty=3,lwd=1)
legend(-0.83,-0.7, "Ribosomal proteins", col='#CB181D', pch=20, bty= "n", cex=0.9)

reg2<-lm(coas$GC3  ~  coas$Axis1_RSCU)
plot(coas$Axis1_RSCU,coas$GC3,xlim=c(-0.6,0.6),  ylim=c(0,0.8), xlab="Axis 1",ylab="GC3", font.main=3,pch=20)
text(0.4,0.8, expression(R^2==0.92),cex=0.8 )
  abline(reg2)

dev.copy2pdf(file="rscu_sav.pdf")

###################################### COA   ####################################

dat<-read.csv("axis1_coa_sav.csv",header=TRUE, dec=".")

mm<-rbind(dat$gc3,dat$est,dat$deltagc3)
barplot(mm, beside=T,names.arg=dat$a, col=c('#DE2D26', '#FC9272' ,'#FEE0D2'), xlab="Axis 1", main="N. caninum", font.main=3)
legend(30,0.6,c("GC3","EST (1e+04)",expression(paste(Delta,"GC3")) ),col=c('#DE2D26', '#FC9272' ,'#FEE0D2'), fill=c('#DE2D26', '#FC9272' ,'#FEE0D2'))
dev.copy2pdf(file="axis1_coa_sav_1.pdf")
