sub get_mean {
        my $ref=shift;
        my @array=@$ref;
        my $sum=0; my $count=1;
        foreach my $num (@array) {
                if ($num=~/\d/) {
                        $sum+=$num;
                        $count++;
                }
        }
        my $mean=$sum/$count;
        return($mean);
}

sub get_blast_hits {
        #raw sequence, full path to database file, what to match to
        my $file='temp_subroutine.fas';
        my $seq=$_[0]; my $db=$_[1]; my $type=$_[2]; my $evalue=$_[3];
        if ($seq!~/\w+/) {print "ERROR IN BLAST\!\n"; return "error"; last;}
        open_out_test($file,'TEMP_BLAST','Y'); print TEMP_BLAST "$seq\n"; close(TEMP_BLAST);
        my $output;
        if ($type eq 'blastn') {
                $output=`blastall -i $file -F T  -d $db -a 1  -p blastn -e $evalue`;
        } elsif ($type eq 'tblastx') {
                $output=`blastall -i $file -F T  -d $db -a 1  -p tblastx -e $evalue`;
        } elsif ($type eq 'blastp') {
                $output=`blastall -i $file -F F  -d $db -a 1  -p blastp -e $evalue`;
        } elsif ($type eq 'blastx') {
                $output=`blastall -i $file -F F  -d $db -a 1  -p blastx -e $evalue`;
        } else {
                print STDERR 'no type given just doing blastn'."\n";
                $output=`blastall -i $file -F F  -d $db -a 1  -p blastn -e $evalue`;
        }
#       print STDERR "$output\n";
        my $r=blast_data_to_hash($output);
        my %hash=%$r; $hash{'nothing'}{'raw_output'}=$output;
        return (\%hash);
}
#sub get_one_seq_from_fasta_exact_v2 {
#	my $name=$_[0]; my $file=$_[1];
#	my $sequence=grep -Pzo \'>$name[^>]+\' $file;# ~/genomes/ToxoDB-30_HhammondiHH34_Genome.fasta
 #	return $sequence;
#}

sub check_user_input	{
	my @stuff=@_;
	foreach my $thing (@stuff)	{
		unless ($thing=~/\w/)	{
			return 'FALSE';
		}
	}
	
}

sub print_array_sort	{
	my $hashref=$_[0];
	my @array=@$hashref;
	my $count=0;
	foreach my $thing (sort {$a<=>$b} @array)	{
		print "$count\t$thing\n";
		$count++;
	}
}

sub print_hash	{
	my $hashref=$_[0];
	my %hash=%$hashref;
	foreach my $key (keys %hash)	{
		print "$key\t$hash{$key}\n";
	}
}
sub print_hash_stderr	{
	my $hashref=$_[0];
	my %hash=%$hashref;
	foreach my $key (keys %hash)	{
		print STDERR "$key\t$hash{$key}\n";
	}
}

sub print_hash_sort_key	{
	my $hashref=$_[0];
	my %hash=%$hashref;
	foreach my $key (sort by_number keys %hash)	{
		print "$key\t$hash{$key}\n";
	}
}

sub sum_numbers_array {
	my $refy=$_[0];
	my $total=0;
	foreach my $thing (@$refy)	{
		$total+=$thing;
	}
	return $total;
}

sub log_base {
    my ($base, $value) = @_;
    return log($value)/log($base);
}
		
sub get_one_seq_from_fasta_exact	{
	my $infile=$_[0];
	my $seq_name=$_[1];
#	print STDERR "$infile\n";
	my $stuff=`grep '$seq_name' $infile -A 1000000`; #big hack.  if seq is >1000 lines it fails
	#(my $name)=($stuff=~/^\>(.*)\n/);
	(my $seq)=($stuff=~/(^\>.*\n(?:^(?!>).*\n)+)/gm);
	#print "<pre>$seq</pre>\n";
	#my $string="$name"."\n"."$seq";
	return $seq;
}





sub GiveHex
{
use POSIX;
my $Dec=$_[0];
$Dec=floor($Dec);
my $Value;

   if($Dec == 10)	{

      $Value = "A";

} elsif($Dec == 11)	{

      $Value = "B";

}    elsif($Dec == 12)	{
	
      $Value = "C";

}   elsif($Dec == 13)	{

      $Value = "D";

}  elsif($Dec == 14)	{

      $Value = "E";
   

}   elsif($Dec == 15)	{
      $Value = "F";
   } else {
      $Value = ""+$Dec;
   }
   return $Value;

}



sub get_sub_sequence 	{
	my $c1=$_[0];#that's tstart
	my $c2=$_[1];#that's tend
	my $seq=$_[2];
	$seq=~s/\s//g;
	unless ($seq=~/[actgACTC]/)	{
		print "you have a format problem\n";
		print "i am going to quit Jon\.pm get_sub_sequence\n";
	}
	my $subseq;
	# all the '1s' are to correct fencepost stuff...the substring works on a 0-up fashion, while 
	# blast counts the first nuc as '1'
	if ($c1 < $c2)	{
		$subseq=substr($seq,$c1-1,($c2-$c1+1));
		
	} elsif ($c1>$c2)	{
		$subseq=substr($seq,$c2-1,($c1-$c2+1));
	}
	unless ($subseq=~/\w/)	{print STDERR "nothing in subsequence\nfor $c1 $c2\n\(may be out of range\)\n";}
	#print STDERR " sequence should be ".($c2-$c1)." long but it is ".(length($subseq))." long\n";
	return $subseq;
}

sub fasta_to_hash_clean	{	#difference from fasta_to_hash is that key is name,
				# value is the sequence only
	my $infile=$_[0];
	my $number_of_sequences_to_get=$_[1];
	if ($number_of_sequences_to_get!~/\d/)	{$number_of_sequences_to_get=10000000000000000000000;}
	my %seq_hash;
	open_in_test($infile,'SUBROUTINE');
	$/='>';
	my $count=0;
	SEQUENCE: while (<SUBROUTINE>)	{
		$count++;
		chomp($_);	#this removes the ">" at the end of each entry.
		(my $name,my $seq)=($_=~/^(.*)\n((?:^.*\n)+)/m);
		#print "$name\n";
		#$_=~s/$name//;
		$seq=~s/\s//g;
		#print "$name\n";
		#print "$seq\n";
		$seq_hash{$name}="$seq";
		#print "$_\n";
		if ($count>=$number_of_sequences_to_get)	{
			last SEQUENCE;
		}
	}	
	close (SUBROUTINE);
	$/="\n";
	return \%seq_hash;
}
sub fasta_to_hash	{
	my $infile=$_[0];
	
	my %seq_hash;
	open_in_test($infile,'SUBROUTINE');
	$/='>';
	my $counter;
	while (<SUBROUTINE>)	{
		chomp($_);	#this removes the ">" at the end of each entry.
		$counter++;
		(my $name)=($_=~/^(.*)\n/);
		#$_=~s/^.*\n//;
		$seq_hash{$name}=">$_";
		
	}	
	close (SUBROUTINE);
	$/="\n";
	return \%seq_hash;
}

sub fasta_to_hash_v2	{
	my $infile=$_[0];
	my $shorten_name=$_[1];
	my $limit=$_[2];
	unless ($limit=~/\d/)	{
		$limit=10000000000000000000000000000;
	}
	my %seq_hash;
	open_in_test($infile,'SUBROUTINE');
	$/='>';
	my $ct;
	while (<SUBROUTINE>)	{
		$ct++;
		$_=~s/\>//;	#this removes the ">" at the end of each entry.
		
		(my $name)=($_=~/^(.*)\n/);

#		print STDERR "$name\n from sub\n";
		if ($shorten_name=~/y/i)	{
			$name=~s/^([\w\.\-]+).*/$1/;
		}
#		print "name\#$name\#\n";
#		print "$name\n";
		print STDERR "$ct FASTA to hash done\n" if ($ct=~/000$/);
		$_=~s/^.*\n//;
		$_=~s/\s//g;
		$seq_hash{$name}="$_";
#		print STDERR "$name\n again from sub\n";
#		print STDERR "\$$seq_hash{$name}\$\n";
		last if ($ct>$limit);
	}	
	close (SUBROUTINE);
	$/="\n";
	
	return \%seq_hash;
}




sub data_format_fasta	{
	#determine if file is nucleotide or protein...fasta files only
	#takes as an argument the filename, opens it, looks at the first 500 lines, and then
	#returns either 'nt' or 'prot';
	
	my $filename=$_[0];
	open_in_test($filename,'IN');
	
	my $recordct=0;
	my $seq='';
	
	while (<IN>)	{		
		unless ($recordct>500)	{
			unless ($_=~/^>/) 	{
				$_=~s/ //;
				$seq.=$_;
			}
		}
	$recordct++;
	}

	my $nct=($seq=~tr/agctAGCTnN//); #print "$nct\n";
	my $totalct=($seq=~tr/A-Za-z//);	
	my $perc=($nct/$totalct);
	print "\n\n$perc nucleotide composition\n";
	print "\n$recordct total records\n";
	if ($perc>0.9)	{$filetype='nt'} else {$filetype='prot'}
	close (IN);
	return $filetype;
}

sub print_60	{
	my $seq=$_[0];
	$seq=~s/(.{60})/$1\n/g;
	print "$seq\n";
}
sub print_80	{
	my $seq=$_[0];
	$seq=~s/(.{80})/$1\n/g;
	print "$seq\n";
}

sub get_tgg	{
	my $scaff_name=$_[0];
	my $tggno;
	unless (
		($tggno)=($scaff_name=~/(TGG\_\d+)/)
	)	{ print 'WARNING Jon.pm get_tgg failed to match on string #'."$scaff_name\#\n";}
	return $tggno;
}


sub count_seqs_in_fasta {
	my $filename=$_[0];
	open_in_test($filename,'IN');
	my $seqct;
	while (<IN>)	{
		$seqct++ if ($_=~/\>/);
	}
	close (IN);
	return $seqct;
}

sub open_in_test	{
	my $infile=$_[0];
	my $filehandle=$_[1];
	unless (open $filehandle, "<$infile")	{		#open as read only
		print "could not open infile $infile\: $!\n";
		exit;
	}
}

sub open_log_test	{
	my $logfile=$_[0];
	my $filehandle=$_[1];
	unless (open $filehandle, ">>$logfile")	{		#open to append
		print "could not open logfile $logfile\: $!\n";
		exit;
	}
}

sub open_out_test	{
	#usage:  outfile, handle, and Y or N on overwrite
	my $outfile=$_[0];
	my $filehandle=$_[1];
	my $overwrite=$_[2];
	unless ($overwrite eq 'Y')	{
		if (-e $outfile)	{
			print STDERR "\n$outfile already exists\.  Do you want to overwrite\? \(enter Y or N)\n";
			my $answer=(<STDIN>);
			if ($answer=~/N/i)	{
				print STDERR "ok then is it ok if I write to this file \"shit\.txt\" \?";
				my $answer2=(<STDIN>); 
				if ($answer2=~/N/i) {
					print STDERR "Ok change the script\.\.\.dying\n";
					exit;
				} else {
					print "OK all output goes to \"shit\.txt\"";
					$outfile='shit.txt';
				}
			}
		}
	}
		
	unless (open $filehandle, ">$outfile")	{		#create new, write to it
		print STDERR "could not open outfile $outfile\: $!\n";
		exit;
	}
}

sub open_out_append_test	{
	my $outfile=$_[0];
	my $filehandle=$_[1];
	unless (open $filehandle, ">>$outfile")	{		#create new, write to it
		print "could not open outfile $outfile\: $!\n";
		exit;
	}
}
sub halt	{
	print STDERR "\n".'***'."  Hit return to continue  ".'***';
	$_=<STDIN>;
}

sub timey	{
	my $end=times();
	printf STDERR "\n\nthat took %.2f CPU seconds of user time\n",
		$end-$beginning_time;
}

sub datestamp 	{
	my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
	my $string="$hour\:$min\:$sec\, ".($mon+1)."\/$mday\/".($year+1900)." ";
	return $string;
}

sub blast_file_format	{
	
# ARGUMENTS:  input filename
# RETURN VALUES:  FILETYPE (HTML OR TEXT), ALGORITHM (BLASTX, BLASTN, BLASTP, TBLASTN, TBLASTX)
####open the file once to see if it is html or text formatted, and set the variables accordingly####
####also parse out database used
	my $infile=$_[0];
	my $verbose=$_[1]; #if this is "quiet" don't print it
	
	open_in_test($infile,'INTEST');
	my $filetype='';
	my $algorithm='';
	my $linect=0;
	LINE: while (<INTEST>)	{

	if ($linect<50)	{
	
		if ( ($filetype)&&($algorithm) )	{
			close INTEST;
			last LINE;
		} else	{
			unless ($filetype) 	{if ( ($_=~/<HTML>/)||($_=~/<a href>/) )	{$filetype='HTML'}}
			unless ($algorithm)	{if ($_=~/(T?BLAST[XNP]) \d\.\d.*\[/)	{$algorithm=$1;}}
		}
	} elsif (!$filetype)	{
		$filetype='TEXT';
		close INTEST;
		last LINE;
	}
	$linect++;
	}	#END WHILE
	if (!$filetype)	{
		$filetype='TEXT';
	}
	if (!$algorithm)	{
		$algorithm='BLASTN';
	}
	my ($shortin)=($infile=~/.*\\(.+\..+)$/);
	print "\nThe file format of $shortin is $filetype\nThe algorithm used to generate the blast output is $algorithm\n" unless ($verbose eq 'quiet');
	return ($filetype,$algorithm);
	
}	# END SUBROUTINE


sub short_file_name	{
	my $filename=$_[0];
	my ($shortin)=($filename=~/.*\\(.+\..+)$/);
	return $shortin;
}

sub by_number	{$a<=>$b}

sub by_value_desc {
   $grades{$b} <=> $grades{$a};
}

sub count_nucleotides_in_fasta_file {
	my $filename=$_[0];
	open_in_test($filename,'IN');
	my $nuc_ct;
	while (<IN>)	{
		unless ($_=~/^\>/)	{
			(my $nucs)=($_=~tr/[a-zA-Z]//);
			$nuc_ct+=$nucs;
		}
	}
	return $nuc_ct;
}

sub blast_data_to_hash	{
	my %hash;
	# take blast output, then hits to get per query and hsps to get per query (0 is all)
	my $output=$_[0];
	my $hits_to_get=$_[1];
	my $hsps_to_get=$_[2];
	open_out_test('tempblast.txt','TEMP','Y');
	print TEMP "$output";
	close (TEMP);
	my ($filetype,$algorithm)=(blast_file_format('tempblast.txt','quiet'));
	#print "$filetype\t$algorithm\n";
	my $database;		#database queried...get from first entry only.
	my $sequences;		#number of seqs in database
	my $residues;		#number of residues in database
	my $expchg;		#number of expect values changed to put into microsoft access (1e-20 to 1E-20)
	my $scchg=0;		#number of score values changed for access
	my $dbaseflag='no';
	$/=$algorithm;
	my $sort_key=1;
	my $queryct;
	my $error_ct=0;
	my $statement='';
	open_out_test('outblast_data_to_hash.txt','OUT','Y');
	#print OUT "$filetype\t$algorithm\t";
	open_in_test('tempblast.txt','TEMPIN');
	QUERY: while (<TEMPIN>)	{
		$queryct++;
		#print "i am in\n";
		#order for the output file tab delimited
		#print "\b"x100;
   		#print "$queryct done\.\.\.";
		my $qacc="";		#accession number for query
		my $qlen;		#query length
		my $aligned;		#all of the alignments for a query
		my $all_hsps;		#all of the hsps for a particular target
		my $one_hsp;		#an individual hsp
		#my $value;		#an individual alignment for the query (the first hsp only)
		my $descall;		#for html format only...description of hit with html tags...parsed into $desc eventually
		my $desc;		#the full description of the hit
		my $species;		#the species name of the hit
		my $tleng;		#the target length (in genbank)
		my $aleng;		#the length of the alignment
		my $ident;		#number of identities
		my $posit;		#number of positives
		my $score;
		my $expect;
		my $library='unknown';	#get library est information
		my $strain='unknown';	#get strain information
		my $frame;		#frame of alignment
		my $strand;		#strand of query seq for blastn only
		my $hsp_query;	#the query sequence alignment string
		my $hsp_target;	#the target sequence alignment string
		my ($qstart,$qend);	#query start, query end	
		my ($tstart,$tend);	#target start, target end
	
		if ($sort_key==1)	{
			($database,$sequences,$residues)=($_=~/Database\:(.+)\n^\s+([\d\,]+) sequences\; ([\d\,]+) total letters/m);
			#print "$database\n";
		}
		
		if ($filetype eq 'HTML')	{
			($qacc)=($_=~/Query=<\/b>[\n ](.*)\([\d\,]+ letters\)/s);	#this is the acc number for the query 
			#print "$qacc\n";
		}	
		elsif 
		($filetype eq 'TEXT')	{
			($qacc)=($_=~/Query\=(.*)\([\d\,]+ letters\)/s);
		}
		# get lib and strain info before messing with the qacc
		
		$qacc=~s/\n/ /g;
		$qacc=~s/\s+$//g;
		$qacc=~s/^ //;
		$qacc=~s/  +/ /g;
		#print "\#$qacc\#\n";

		#$qacc=&chk($qacc,'acc',$qacc,$_);
		
		# for toxo only
		#gi|20269739|gb|AF465611.1| Toxoplasma gondii mRNA sequence 
		($qlen)=($_=~/\(([\d\,]+) letters\)/);		#query length
		$qlen=~s/\,//g;
		#print "$qlen\n";
		####need to deal with nohits.  if there were no hits, we still 
		#  want to print out the accession number and the length####		

		if ($_=~/\*\* No hits found \*\*/)	{
			$desc='No Hits';
			print OUT "$sort_key\t$qacc\t$qlen\t$desc\t\n";
			$hash{$qacc}{desc}[1][1]=$desc;
			#print "no hit\n";
			$sort_key++;
		}  else  {
		($aligned)=($_=~/.*significant (alignments:.*)Posted date/ms);	#these are the highscoring pairs
		#print "$aligned\n";
		my $hitct=-1;
		HIT:  while ($aligned=~/^>.*\n.*(^(?!>).*\n)+/gm)	{
			
			$hitct++;
			unless ($hits_to_get==0)	{
				if ($hitct>$hits_to_get)	{last HIT;}
			}
			#print "$hitct\n";
			$all_hsps=$&;		#this is an individual set of hsps
			($tleng)=($all_hsps=~/\n +Length = (\d+)/ms);	
				$tleng=&chk($tleng,'tleng',$qacc);
				#print "$tleng\n";
			#take the description for the hit
			if ($filetype eq 'HTML')	{
				#><a name = 540></a>TgME49B7|TGG_995301|GENOMIC_scaffold|2003.08.13|TIGR
				($desc)=($all_hsps=~/^><a name = [^\>]+><\/a>(?:\<[^\>]+\>)?(.*)\n +[L]ength/ms);
				#($desc)=($all_hsps=~/^><a name = [^\>]+><\/a>(?:<a href\=\"http\:\/\/[^ ]+ ?>)?([\d\w-\|\.]+(?:<\/a>)? .*)\n +Length = /ms);
				#($desc)=($all_hsps=~/^><a name = [\w-\d\|]+><\/a>(.*) +Length/ms);
				$desc=~s/<\/a>//;
				#print "$desc\n";
			} else {
				($desc)=($all_hsps=~/^>(.*)\n +Length = /ms);
			}
			$desc=&chk($desc,'desc',$qacc);
			$desc=~s/ +/ /g; $desc=~s/\n//g;	#clean up description
			$desc=~s/^ //;
			$desc=~s/ $//;
			#print "$desc\t$hitct\n";
			#for toxo only
			#$desc=~s/^TgME49B7\|(TGG_\d+)\|.*$/$1/;
			#TgME49B7|TGG_9920|GENOMIC_scaffold|2003.04.17|TIGR
			#######################################################################
			#take an individiual hsp...'score' to 'score'
			my $hspct=-1;
			HSP:  while ($all_hsps=~/^ Score.*\n(^(?! Score).*\n)+/gm)	{
				
				$hspct++;
				unless ($hsps_to_get==0)	{
					if ($hspct>$hsps_to_get)	{last HSP;}
				}
				$one_hsp=$&;
				
				($score)=($one_hsp=~/Score = +([\d\+e\.]+) bits/);	
					$score=&chk($score,'score',$qacc);
				($expect)=($one_hsp=~/Expect[\(\)\d ]+= ((e|\.|\d|-)+)/);
				
				$expect=&chk($expect,'expect',$qacc);
				$expect=~tr/e/E/;
				$score=~tr/e/E/;
				if ($expect=~/^E-\d+/)	{
					$expect='1'."$expect";
					$expchg++;
				}
				
				if ( $algorithm ne 'BLASTN' ) {
					# here, if it's blastx, tblastn, or blastp.
					($ident,$aleng,$posit)=($one_hsp=~/Ident\w+ = (\d+)\/(\d+) \(\d+\%\)\, Posit\w+ = (\d+)\/\d+/);
					($frame)=($one_hsp=~/Frame = ((\+|\-)\d)/) if ($algorithm ne 'BLASTP');
					$posit=&chk($posit,'posit',$qacc);
					$frame=&chk($frame,'frame',$qacc) if ($algorithm ne 'BLASTP');
				} else {
					($ident,$aleng)=($one_hsp=~/Identities = (\d+)\/(\d+) \(\d+\%\)/);
					#update 1-05:  make it take the second one as the strand...it's the only
					# one that changes.
					($strand)=($one_hsp=~/Strand = \w+ \/ (\w+)/);
					$strand=&chk($strand,'strand',$qacc);
				}		

				$ident=&chk($ident,'ident',$qacc);
				$aleng=&chk($aleng,'aleng',$qacc);
					

				#join up the lines with the query or target  sequence (gapped and all)
				$hsp_query=(join ('',$one_hsp=~/^Query.*\n/gm) );
				$hsp_target=(join ('',$one_hsp=~/^Sbjct.*\n/gm) );
				
				#extract start and end points using the /s modifier so it will match to the end...	
				($qstart,$qend)=($hsp_query=~/^Query\: +(\d+).*\D (\d+)/s);	
				($tstart,$tend)=($hsp_target=~/^Sbjct\: +(\d+).*\D (\d+)/s);
				$qstart=&chk($qstart,'qstart',$qacc);
				$qend=&chk($qend,'qend',$qacc);
				$tstart=&chk($tstart,'tstart',$qacc);
				$tend=&chk($tend,'tend',$qacc);			

				############print information for the hsp ########################################
				# put information for the HSP into a hash.  needs to be flexible so that you can
				# put multiple hsps and multiple hits per query
				if ($algorithm ne 'BLASTN')	{
					#$hash[$hitct][$hspct]{qacc}=$qacc;
					$hash{$qacc}{qacc}[$hitct][$hspct]=$qacc;
					$hash{$qacc}{qlen}[$hitct][$hspct]=$qlen;
					$hash{$qacc}{desc}[$hitct][$hspct]=$desc;
					
					$hash{$qacc}{expect}[$hitct][$hspct]=$expect;
					$hash{$qacc}{score}[$hitct][$hspct]=$score;
					#$hash{$qacc}{strand}[$hitct][$hspct]=$strand;
					$hash{$qacc}{ident}[$hitct][$hspct]=$ident;
					$hash{$qacc}{posit}[$hitct][$hspct]=$posit;
					$hash{$qacc}{aleng}[$hitct][$hspct]=$aleng;
					$hash{$qacc}{qstart}[$hitct][$hspct]=$qstart;
					$hash{$qacc}{qend}[$hitct][$hspct]=$qend;
					$hash{$qacc}{tstart}[$hitct][$hspct]=$tstart;
					$hash{$qacc}{tend}[$hitct][$hspct]=$tend;
					$hash{$qacc}{tleng}[$hitct][$hspct]=$tleng;
					
					print OUT "$sort_key\t$qacc\t$qlen\t$desc\t$expect\t$score\t";
					print OUT "$frame\t" if (($algorithm eq 'BLASTX')||($algorithm eq 'TBLASTN'));
					print OUT "$ident\t$posit\t$aleng\t$qstart\t";
					print OUT "$qend\t$tstart\t$tend\t$tleng";
					print OUT "\t$library\t$strain" if ($libstrain=~/y/i);
					print OUT "\n";
				} else {
					#for toxo only
					#	if ($expect<=1e-30)	{
					#print "\#$qacc\#\n";
					#print "$hitct\t$hspct\n";
					$hash{$qacc}{qacc}[$hitct][$hspct]=$qacc;
					$hash{$qacc}{qlen}[$hitct][$hspct]=$qlen;
					$hash{$qacc}{desc}[$hitct][$hspct]=$desc;
					#print "\+$desc\n";
					
					#print "$hash{$qacc}{desc}[$hitct][$hspct]\n";
					#print "$hitct\n$hspct\n";
					#print "$qacc\n";
					$hash{$qacc}{expect}[$hitct][$hspct]=$expect;
					$hash{$qacc}{score}[$hitct][$hspct]=$score;
					$hash{$qacc}{strand}[$hitct][$hspct]=$strand;
					$hash{$qacc}{ident}[$hitct][$hspct]=$ident;
					$hash{$qacc}{aleng}[$hitct][$hspct]=$aleng;
					$hash{$qacc}{qstart}[$hitct][$hspct]=$qstart;
					$hash{$qacc}{qend}[$hitct][$hspct]=$qend;
					$hash{$qacc}{tstart}[$hitct][$hspct]=$tstart;
					$hash{$qacc}{tend}[$hitct][$hspct]=$tend;
					$hash{$qacc}{tleng}[$hitct][$hspct]=$tleng;
					#print "$hash{$qacc}{tstart}[1][1]\n";
					#print "hit ct $hitct\t hsp ct $hspct\n";
					print OUT "$sort_key\t$qacc\t$qlen\t$desc\t$expect\t$score\t$strand\t$ident\t$aleng\t$qstart\t";
					print OUT "$qend\t$tstart\t$tend\t$tleng";
					print OUT "\t$library\t$strain" if ($libstrain=~/y/i);
					print OUT "\n";
				}
				$sort_key++;
			}	#end of second while
		}		#end of first while
		
		}			#end of if else
		
	}	#end of file 'while'

	close (TEMPIN);
	close (TEMP);
	#print "\n";
	close (OUT);
	$/="\n";
	#print "\nthere were $error_ct total errors\n";
	#print "\nI changed $expchg expect values\n";
	#print "\nI added error information to $errorlog\n";
	return \%hash;
} #END BLAST SUBROUTINE

sub chk	{
	my $var=$_[0];
	my $name=$_[1];
	my $acc=$_[2];
	my $hit=$_[3];
	
	if ( (!$var)||($var=~/^\s+$/) )	{
		#print "1$var\n2$name\n3$acc\n4$hit\n";
		$var=('error!'.$name);
		$error_ct++;
		print STDERR "$acc\t$var\n";
		print LOG1 '************ERROR************'."\nQNAME\n$acc\nFIELD\n$var\nHIT\n$hit\n";
		print LOG1 '*********END ERROR***********'."\n\n";
	} 
	

	return $var;
}
1;

