#include <iostream>
#include <string>
#include <fstream>
#include <sstream>
#include <map>
#include <math.h>
#include "graph.cpp"
#include "linked_list.cpp"
#include <stdlib.h>     /* srand, rand */      
#include <unistd.h>
#include "permute.cpp"


#define NUM_PERMUTES 1000

using namespace::std;

class Gene {
public:
    Gene() {subgenome[0]=FALSE;subgenome[1]=FALSE;subgenome[2]=FALSE;};
    int operator==(Gene test);
    Gene& operator=(Gene &assign_from); //reference
    void set_name (string new_name) {name=new_name;};
    void set_subgenome_pres(int num) {subgenome[num]=TRUE;};
    void set_subgenome_abs(int num) {subgenome[num]=FALSE;};
    string get_name() {return(name);};
    BOOL subgenome_present(int num) {return(subgenome[num]);};
    
protected:
    string name;
    BOOL subgenome[3];
};

class Met_Net_Node {
public:
    Met_Net_Node() {num_genes=0; the_genes=0;};
    Met_Net_Node(int num_genes);
    ~Met_Net_Node(); //desctructor
	int operator==(Met_Net_Node test);
	Met_Net_Node& operator=(Met_Net_Node &assign_from);
	
	string get_name() {return(name);};
    int get_num_genes() {return(num_genes);};
    void set_name(string new_name) {name=new_name;};
    Gene* get_nth_gene(int n) {return(the_genes[n]);}; //pointer
    void set_gene(int n, Gene* gene_loc) {the_genes[n]=gene_loc;};
    
    
protected:
	string name;
	int num_genes;
    Gene **the_genes;
};



class Named_Pair {
public:
	Met_Net_Node the_pair[2];
};

class Read_Met_Net_Graph : public Read_Graph<Met_Net_Node> 
{
public:
	Read_Met_Net_Graph() : Read_Graph<Met_Net_Node>() {};
	Read_Met_Net_Graph(BOOL undir) : Read_Graph<Met_Net_Node>(undir) {};
    
    int read_genes(string gene_file);
protected:
    int num_genes;
    Gene *my_genes;
    map<string, int> Gene_map, node_map;
    
	int get_node_list();
	void get_edge_list();
    
    Node<Met_Net_Node>* find_node(Met_Net_Node *match);
};

// randomize subgenome assignment WRONG
// int permute(string gene_file);

// count edges connecting genes from the same subgenome
int subgenome_edge(string node_file, string interact_file, string gene_file);

// shuffle rows in the gene file (single copy rows, duplicates rows)
void shuffle(int *inlist, int count);

int get_row_count(string gene_file, int copy_num);


int main(int argc, char **argv)
{
	
	string node_file, interact_file, gene_file;

	if (argc>3) {
		node_file=argv[1];
		interact_file=argv[2];
		gene_file=argv[3];


		subgenome_edge(node_file, interact_file, gene_file);

		int num_single, num_dupl, num_tripl, num_none, num_all; 
		num_single = get_row_count(gene_file, 1);
		num_dupl = get_row_count(gene_file, 2);
		num_tripl = get_row_count(gene_file, 3);
		num_none = get_row_count(gene_file, 0);
		num_all = num_single + num_dupl + num_tripl + num_none;
		// get inlists
		int *singlelist, *dupllist, *tripllist, *nonelist, *alllist;
		int i, j, sum, total_row;
		int single, dupl, tripl, none;
    	string name, present[3];
    	ifstream fin;

		singlelist=new int[num_single];
		dupllist=new int[num_dupl];
		tripllist=new int[num_tripl];
		nonelist=new int[num_none];

		alllist = new int[num_all];

    	fin.open(gene_file.c_str());
    	if(!fin.fail()) {	
			total_row = 0;
			single = 0;
			dupl = 0;
			tripl = 0;
			none = 0;
        	while(!fin.eof()) {
            	name="";
            	fin>>name>>present[0]>>present[1]>>present[2];
            	if (name != "") {
					sum = 0;
            		for(i=0; i<3; i++) {
            			if (present[i] == "PRESENT") {
            				sum++;
						}
        			}
					alllist[total_row] = total_row;
            	    switch(sum) {
    				case(0):
						nonelist[none] = total_row;
					//	cout << "None row: " << nonelist[none] << endl;
						none++;
    					break;
					case(1):
						singlelist[single] = total_row;
					//	cout << "Single row: " << singlelist[single] << endl;
						single++;		
        				break;
					case(2):
						dupllist[dupl] = total_row;
					//	cout << "Dupl row: " << dupllist[dupl] << endl;
						dupl++;
						break;
					case(3):
						tripllist[tripl] = total_row;
					//	cout << "Tripl row: " << tripllist[tripl] << endl;
						tripl++;
						break;
				    }

					total_row++;
				}
       		}
		} else {
        	cerr<<"Error: invalid gene file "<<gene_file<<endl;
			return(-1);
        }
		fin.close();

		remove("permu_rownum.txt");
	//	shuffle(singlelist, num_single);
	//	shuffle(dupllist, num_dupl);

		shuffle(alllist, num_all);

		//get subgenome info from genefile
		string genename[total_row], subgenome[total_row];
		
  		fin.open(gene_file.c_str());
    	if(!fin.fail()) {	
			i = 0;
        	while(!fin.eof()) {
            	name="";
            	fin>>name>>present[0]>>present[1]>>present[2];
            	if (name != "") {
					genename[i] = name;
            		subgenome[i] = present[0] + "\t" + present[1] + "\t" + present[2];
					i++;
				}
       		}
		} else {
        	cerr<<"Error: invalid gene file "<<gene_file<<endl;
			return(-1);
        }
		fin.close();

        //get subgenome_edges for randomized graphs
        int permu, row, rand_row;
		ofstream outfile;

		for(i=0; i<NUM_PERMUTES; i++) {

   			fin.open("permu_rownum.txt");
			outfile.open ("random.txt");
    		if(!fin.fail()) {	
        		while(!fin.eof()) {
					permu = -1;
            		fin>>permu>>row>>rand_row;
            		if (permu == i) {
						outfile << genename[row] << "\t" << subgenome[rand_row] << endl;
					}
       			}
				/*
				for(j=0; j< num_tripl; j++) {
					outfile << genename[tripllist[j]] << "\t" << subgenome[tripllist[j]] << endl;
				}
				for(j=0; j< num_none; j++) {
					outfile << genename[nonelist[j]] << "\t" << subgenome[nonelist[j]] << endl;
				}
				*/
				outfile.close();
				//get subgenome_edges for the randomized graph
				cout << "Permutation " << i << endl;
				subgenome_edge(node_file, interact_file, "random.txt");
				remove("random.txt");  
				} else {
        			cerr<<"Error: invalid gene file "<<"permu_rownum.txt"<<endl;
					return(-1);
        		}		
			fin.close();
		}
	    

		return(0);
	}
	else {
		cerr<<"Usage: subgenome_met_net <node file> <interactions file> <gene_file>\n";
		return(-1);
	}


}



int subgenome_edge(string node_file, string interact_file, string gene_file)
{
	
	//	Permute<int> *the_permuter;   

		Node<Met_Net_Node> *curr_node;
		Graph<Met_Net_Node> *the_graph, *rand_graph;
		Read_Met_Net_Graph *read_graph;

		int i,j, m, n, sum;
	    int sub[2][3], single[2][3], tripl[2];
		int cnt1 = 0;
		int cnt2 = 0;
		int cnt3 = 0;
		int cnt_tri = 0;

		read_graph=new Read_Met_Net_Graph(TRUE); //directed
        read_graph->read_genes(gene_file);
		the_graph=read_graph->get_graph(node_file, interact_file);
 	//	the_graph->number_components();
 	//	cout << "Number of components: " << the_graph->get_num_components() << endl;
		
		int d = 0;
		
		for(i=0; i<the_graph->get_num_nodes(); i++) {
			/*
	   	 	cout << the_graph->get_node(i)->get_element()->get_name() << "\t";
	   	 	cout <<"#genes:"<< the_graph->get_node(i)->get_element()->get_num_genes() << "\t";
	   	 	cout <<"#edges:"<< the_graph->get_node(i)->get_num_edges() << "\t" ;
	   	 	cout << "component: " << the_graph->get_node(i)->get_component_num() << endl;
	   	 	*/
	   	 	for(j=0; j<the_graph->get_num_nodes(); j++) {
	   	 		if ((i<j) && ( the_graph->get_node(i)->get_edge(the_graph->get_node(j)) !=0)){
	   	 			int sub[2][3] = {{0,0,0}, {0,0,0}} ;   
					int single[2][3] = {{0,0,0}, {0,0,0}} ;
					int tripl[2] = {0,0}; 
	   	    //        cout <<"Edge:"<<the_graph->get_node(i)->get_element()->get_name() << "->" << the_graph->get_node(j)->get_element()->get_name() << the_graph->get_node(i)->get_edge(the_graph->get_node(j))<< endl;
	   	 	        for (m=0; m < the_graph->get_node(i)->get_element()->get_num_genes(); m++) {
				        sum = 0;
						for (n=0; n<3; n++) {
				        	sum = sum + the_graph->get_node(i)->get_element()->get_nth_gene(m)->subgenome_present(n);
							if (sub[0][n] < the_graph->get_node(i)->get_element()->get_nth_gene(m)->subgenome_present(n)) {
				        		sub[0][n] = the_graph->get_node(i)->get_element()->get_nth_gene(m)->subgenome_present(n);
							}
				        }
						/* at least one pair of genes that are single copy & from the same subgenome */    
				        if (sum == 1) {
			//	        	cout <<the_graph->get_node(i)->get_element()->get_name() << ": " << the_graph->get_node(i)->get_element()->get_nth_gene(m)->get_name() << "\t";
				        	for (n=0; n<3; n++) {
			//	        		cout << the_graph->get_node(i)->get_element()->get_nth_gene(m)->subgenome_present(n) << "\t";
				        		if (single[0][n] < the_graph->get_node(i)->get_element()->get_nth_gene(m)->subgenome_present(n)) {
				            		single[0][n] = the_graph->get_node(i)->get_element()->get_nth_gene(m)->subgenome_present(n);
								}
				        	}
			//	        	cout << "\n";
						} else if (sum == 3) {
							tripl[0] = 1;
						}
			        }

	   	 	        for (m=0; m < the_graph->get_node(j)->get_element()->get_num_genes(); m++) {
				        sum = 0;
						for (n=0; n<3; n++) {
				        	sum = sum + the_graph->get_node(j)->get_element()->get_nth_gene(m)->subgenome_present(n);
							if (sub[1][n] < the_graph->get_node(j)->get_element()->get_nth_gene(m)->subgenome_present(n)) {
				        		sub[1][n] = the_graph->get_node(j)->get_element()->get_nth_gene(m)->subgenome_present(n);
							}
				        }    
				        if (sum == 1) {
			//	        	cout <<the_graph->get_node(j)->get_element()->get_name() << ": " << the_graph->get_node(j)->get_element()->get_nth_gene(m)->get_name() << "\t";
				        	for (n=0; n<3; n++) {
			//	        		cout << the_graph->get_node(j)->get_element()->get_nth_gene(m)->subgenome_present(n) << "\t";
				        		if (single[1][n] < the_graph->get_node(j)->get_element()->get_nth_gene(m)->subgenome_present(n)) {
				            		single[1][n] = the_graph->get_node(j)->get_element()->get_nth_gene(m)->subgenome_present(n);
								}
				        	}
			//	        	cout << "\n";
						} else if (sum == 3) {
							tripl[1] = 1;
						} 
			        }

            // currnode->delete_edge(Node *old_edge_node)
\
					if ((single[0][0] == 1) && (single[0][0] == single[1][0])) {
						cnt1++;
			//			cout <<"Sub1 edge: "<<the_graph->get_node(i)->get_element()->get_name() << "->" << the_graph->get_node(j)->get_element()->get_name() << endl;
					} else if ((single[0][1] == 1) && (single[0][1] == single[1][1])) {
						cnt2++;
			//			cout <<"Sub2 edge: "<<the_graph->get_node(i)->get_element()->get_name() << "->" << the_graph->get_node(j)->get_element()->get_name() << endl;
					} else if ((single[0][2] == 1) && (single[0][2] == single[1][2])) {
						cnt3++;
			//			cout <<"Sub3 edge: "<<the_graph->get_node(i)->get_element()->get_name() << "->" << the_graph->get_node(j)->get_element()->get_name() << endl;
					}
					if ((tripl[0] == 1) && (tripl[0] == tripl[1])) {
						cnt_tri++;
			//			cout <<"Tripl edge: " <<the_graph->get_node(i)->get_element()->get_name() << "->" << the_graph->get_node(j)->get_element()->get_name() << endl;
					}
					/*
					if ((single[0][0] == 1) && (single[0][1] == 1) && (single[0][2] == 1) && (single[0][0] == single[1][0]) && (single[0][1] == single[1][1]) && (single[0][2] == single[1][2])) {
						tripl++;
					}
															
					if ((single[0][0] == 1) && (single[0][1] == 0) && (single[0][2] == 0) && (single[0][0] == single[1][0]) && (single[0][1] == single[1][1]) && (single[0][2] == single[1][2])) {
						cnt1++;
					}
					if ((single[0][0] == 0) && (single[0][1] == 1) && (single[0][2] == 0) && (single[0][0] == single[1][0]) && (single[0][1] == single[1][1]) && (single[0][2] == single[1][2])) {
						cnt2++;
					}
					if ((single[0][0] == 0) && (single[0][1] == 0) && (single[0][2] == 1) && (single[0][0] == single[1][0]) && (single[0][1] == single[1][1]) && (single[0][2] == single[1][2])) {
						cnt3++;
					}
					*/	
					/* delete edges between pair of nodes that don't have at least one pair genes from the sanme subgenome */
					if ( (sub[0][0] != sub[1][0]) || (sub[0][1] != sub[1][1]) || (sub[0][2] != sub[1][2])) {
						the_graph->get_node(i)->delete_edge(the_graph->get_node(j));
						d++;
					//	 cout << the_graph->get_node(i)->get_edge(the_graph->get_node(j)) <<endl;
					//	 cout <<"Delete edge "<< d << ": "<<the_graph->get_node(i)->get_element()->get_name() << "->" << the_graph->get_node(j)->get_element()->get_name() << endl;
					}
										 						 	   	 	            
 
	   	        }
	   	        
	   	    }
	   	   // cout << "\n";

		}
		cout <<"Subgenome1 to 1: "<< cnt1 << endl;
		cout <<"Subgenome2 to 2: "<< cnt2 << endl;		
		cout <<"Subgenome3 to 3: "<< cnt3 << endl;
		cout <<"Triplets to triplets: "<< cnt_tri << endl;			
		//cout <<"Triplets to triplets: "<< tripl << endl;
		
		
 	//	the_graph->number_components();
 	//	cout << "Number of components after deleting edges: " << the_graph->get_num_components() << endl; 	
		
		/*
		for(i=0; i<the_graph->get_num_nodes(); i++) {
	   	 	cout << the_graph->get_node(i)->get_element()->get_name() << "\t";
	   	 	cout <<"#genes:"<< the_graph->get_node(i)->get_element()->get_num_genes() << "\t";
	   	 	cout <<"#edges:"<< the_graph->get_node(i)->get_num_edges() << "\t" ;
	   	 	cout << "component: " << the_graph->get_node(i)->get_component_num() << endl;
 		}
		*/


		if(the_graph==0) {
			cerr<<"Error reading graph\n";
			return(-1);
		}
		
		
		
	//	the_permuter=new Permute<int>();
		
	
			
		
	//	delete the_permuter;
		delete the_graph;
		delete read_graph;
		
		return (0);	
}

void shuffle(int *inlist, int count)
{
    int i, j, *outlist;
	Permute<int> *the_permuter;
 	ofstream outfile;
	outfile.open( "permu_rownum.txt", ios::out | ios::app ); //append
    the_permuter=new Permute<int>();

	for(i=0; i<NUM_PERMUTES; i++) {
		outlist= the_permuter->do_permutation(count, inlist);
		for(j=0; j<count; j++) {
			outfile << i << "\t" << inlist[j] << "\t" << outlist[j] << endl;
		}
	}

	outfile.close();
}


// copy_num = 1: single, 2: dupl, 3: tripl
int get_row_count(string gene_file, int copy_num)
{	
	int i, sum, count;
    string name, present[3];
    ifstream fin;
    fin.open(gene_file.c_str());
    if(!fin.fail()) {	
		count = 0;
        while(!fin.eof()) {
            name="";
            fin>>name>>present[0]>>present[1]>>present[2];
            if (name != "") {
				sum = 0;
            	for(i=0; i<3; i++) {
            		if (present[i] == "PRESENT") {
            			sum++;
					}
        		}
				if (sum == copy_num) {
					count++;
				}
			}
        }
		cout << count << " rows contain " << copy_num << " gene copies." << endl;
        return(count);
    }
    else {
        cerr<<"Error: invalid gene file "<<gene_file<<endl;
		return(-1);
    }
}



int Gene::operator==(Gene test)
{
    if (name == test.get_name()) return(-1);
    else return(0);
}


Gene& Gene::operator=(Gene &assign_from)
{
    int i;
  
    name = assign_from.get_name();
    for(i=0; i<3; i++) subgenome[i]=assign_from.subgenome_present(i);
    
    return(*this);
}


Met_Net_Node::Met_Net_Node(int n_genes)
{
    num_genes=n_genes;
    the_genes=new Gene*[num_genes];
}


Met_Net_Node::~Met_Net_Node()
{
    
    if (the_genes !=0) {
        delete[] the_genes;
    }
}


int Read_Met_Net_Graph::read_genes(string gene_file)
{
    int i;
    string name, present[3];
    Gene the_gene;
    List<Gene> the_list;
    ifstream fin;
    
    fin.open(gene_file.c_str());
    if(!fin.fail()) {
        
        while(!fin.eof()) {
            name="";
            fin>>name>>present[0]>>present[1]>>present[2];
            
            if (name != "") {
                the_gene.set_name(name);
                
                for(i=0; i<3; i++) {
                     std::transform(present[i].begin(), present[i].end(), present[i].begin(), ::tolower);
                    if (present[i] == "present") the_gene.set_subgenome_pres(i);
                    else  the_gene.set_subgenome_abs(i);
                }
                
                the_list.add_to_list(the_gene);
            }
        }
        
        num_genes=the_list.get_list_length();
        fin.close();
        
        my_genes=new Gene[num_genes];
        
        the_list.return_to_start();
        for(i=0; i<num_genes; i++) {
            my_genes[i]=*(the_list.get_current_item());
            the_list.get_next();
        }
        
        for(i=0; i<num_genes; i++)
            Gene_map[my_genes[i].get_name()]=i;
        
        return(0);
    }
    else {
        cerr<<"Error: invalid gene file "<<gene_file<<endl;
        return(-1);
    }
}

int Read_Met_Net_Graph::get_node_list()
{
	int i, val, num_genes;
    string name, line, gene_name;
	Met_Net_Node *the_node;
	List<Met_Net_Node> the_list;	
	ifstream fin;
	
	fin.open(node_filename.c_str());
	
	if(!fin.fail()) {
		while(!fin.eof()) {
			name="";
			
            getline(fin, line);
           
            num_genes=0;
            stringstream string_in(line);
            
            string_in>>name;
            
			if (name != "" ) {
                
                num_genes=0;
                
                while (!string_in.eof()) {
                    string_in>>gene_name;
                    num_genes++;
                }
                
                the_node=new Met_Net_Node(num_genes);
                
                stringstream string_in(line);
                
                string_in>>name;
                
                i=0;
                while (!string_in.eof()) {
                    string_in>>gene_name;
                    
                    the_node->set_gene(i, &my_genes[Gene_map[gene_name]]);
                    //cout<<"Read "<<gene_name<<endl;
                    i++;
                }
                
				//cout<<"Read "<<name<<endl;
				the_node->set_name(name);
                
				the_list.add_to_list((*the_node));
			}	
		}
		num_nodes=the_list.get_list_length();
		fin.close();
		
	//	cout<<"Graph has "<<num_nodes<<" nodes\n";
		
		units=new Met_Net_Node [num_nodes];
		
		the_list.return_to_start();
		for(i=0; i<num_nodes; i++) {
			units[i]=*(the_list.get_current_item());
			the_list.get_next();
		}
		
		return(0);
	}
	else {
		cerr<<"Error: invalid node file "<<node_filename<<endl;
		return(-1);
	}
	
	
	
}


void Read_Met_Net_Graph::get_edge_list()
{
	int i;
	string name1, name2;
	ifstream fin;
	Named_Pair a_pair;
	List<Named_Pair> the_list;
	
	have_edge_names=FALSE;
	
    for(i=0; i<the_graph->get_num_nodes(); i++)
        node_map[the_graph->get_node(i)->get_element()->get_name()]=the_graph->get_node(i)->get_node_num();
    
	fin.open(edge_filename.c_str());
	if(fin.fail())
		cerr<<"Error: invalid interaction file\n";
	
	while(!fin.eof()) {
		name1="";
		fin>>name1>>name2;
		if (name1 != "" ) {
			//cout<<"Read "<<name1<<" and "<<name2<<": "<<edge_name<<endl;
			
			a_pair.the_pair[0].set_name(name1);
			a_pair.the_pair[1].set_name(name2);
			the_list.add_to_list(a_pair);
		}
		
		
	}
	num_edges=the_list.get_list_length();	
	fin.close();
	
	node_edges=new Met_Net_Node *[num_edges];
	for(i=0; i<num_edges; i++) {
		node_edges[i]=new Met_Net_Node[2];
	}
	the_list.return_to_start();
	
	for(i=0; i<num_edges; i++) {
		node_edges[i][0]=the_list.get_current_item()->the_pair[0];
		node_edges[i][1]=the_list.get_current_item()->the_pair[1];
	//	cout<< the_list.get_current_item()->the_pair[0].get_name() <<" and "<< the_list.get_current_item()->the_pair[1].get_name() <<endl;
		the_list.get_next();

	}
	
	//cout<<"Graph has "<<num_edges<<" edges  (may double count)"<<endl;
}

Node<Met_Net_Node>* Read_Met_Net_Graph::find_node(Met_Net_Node *match)
{
    return(the_nodes[node_map[match->get_name()]]);
}

int Met_Net_Node::operator==(Met_Net_Node test)
{
	if (test.get_name()==name) return(-1);
	else return(0);
}


Met_Net_Node& Met_Net_Node::operator=(Met_Net_Node &assign_from)
{
    int i;
    
	name= assign_from.get_name();
    
    delete[] the_genes;
    num_genes = assign_from.get_num_genes();
    
    the_genes= new Gene*[num_genes];
    
    for(i=0; i<num_genes; i++)
        the_genes[i]=assign_from.get_nth_gene(i);
    
	return(*this);
}


