#include <math.h>
#include <iostream>
#include <fstream>


#ifndef ___PERMUTE_H___
#define ___PERMUTE_H___


class BinIndex_Node {
public:
    BinIndex_Node () {};
    BinIndex_Node (BinIndex_Node *new_par, int so_far, int total);
    int get_num_left()  {return(num_left);};
    void set_num_left(int val) {num_left=val;}
    void decrease_num_left();
    int get_index_value()  {return(index_value);};
    BOOL is_tip()       {return(tip);};
    BinIndex_Node* get_child(int child_num)  {return(children[child_num]);};
    ~BinIndex_Node();
    
protected:
    int num_left, index_value;
    BOOL tip;
    BinIndex_Node *children[2], *parent;
    
};

class BinIndex_Tree {
public:
    BinIndex_Tree();
    BinIndex_Tree(int t_range);
    int get_index_value(int target_num);
    void reset_tree() {recurse_reset(head_node);};
    ~BinIndex_Tree();
    
protected:
    int total_range;
    BinIndex_Node *head_node;
    
    int recurse_search_for_node(BinIndex_Node *curr_node, int so_far, int target);
    int recurse_reset(BinIndex_Node *curr_node);
};

template <class PERMUTE_UNIT>
class Permute {
	public:
		Permute();
		Permute(BOOL have_seed);
		PERMUTE_UNIT * do_permutation(int num_elements, PERMUTE_UNIT *elements);
		~Permute();
	protected:
		int *mark_used;
		long seed1, seed2;
		BOOL had_seed;
		ifstream infile, seedin;
		ofstream outfile, seedout;
		
};

template <class PERMUTE_UNIT>
class Permute_with_Tree {
public:
    Permute_with_Tree();
    Permute_with_Tree(BOOL have_seed);
    PERMUTE_UNIT * do_permutation(int num_elements, PERMUTE_UNIT *elements);
    PERMUTE_UNIT * do_permutation_repeat(int num_elements, PERMUTE_UNIT *elements);
    ~Permute_with_Tree();
protected:
    int previous_num_elements;
    long seed1, seed2;
    BOOL had_seed;
    ifstream infile, seedin;
    ofstream outfile, seedout;
    
    BinIndex_Tree *the_tree;
};
#endif
