#include "permute.h"
#include "libranlib.h"



BinIndex_Node::BinIndex_Node (BinIndex_Node *new_par, int so_far, int total)
{
    if (new_par != 0)
        parent=new_par;
    else parent=0;
    
    if (so_far == (total -1)) {
        tip=TRUE;
        children[0]=0;
        children[1]=0;
        index_value=total;
        num_left=1;
    }
    else {
        tip=FALSE;
        num_left = (total-so_far)/2;
        index_value=-1;
        
        children[0]= new BinIndex_Node(this, so_far, so_far+num_left);
        children[1]= new BinIndex_Node(this, so_far+num_left, total);
    }
    
}

void BinIndex_Node::decrease_num_left()
{
    num_left--;
}

BinIndex_Node::~BinIndex_Node()
{
    int i;
    
    for(i=0; i<2; i++) {
        if (children[i] != 0) {
            delete children[i];
        }
    }
}


BinIndex_Tree::BinIndex_Tree()
{
    head_node=0;
}





BinIndex_Tree::BinIndex_Tree(int t_range)
{
    head_node=new BinIndex_Node(0, 0, t_range);
}

int BinIndex_Tree::get_index_value(int target_num)
{
    return(recurse_search_for_node(head_node, 0, target_num));
}



BinIndex_Tree::~BinIndex_Tree()
{
    if (head_node!=0)
        delete head_node;
}


int BinIndex_Tree::recurse_search_for_node(BinIndex_Node *curr_node, int so_far, int target)
{
    int ret_val;
    if (curr_node->is_tip() == TRUE) ret_val=curr_node->get_index_value();
    else {
        if (so_far+ curr_node->get_num_left() >= target) {
            ret_val=recurse_search_for_node(curr_node->get_child(0), so_far, target);
            curr_node->decrease_num_left();
            
        }
        else {
            ret_val=recurse_search_for_node(curr_node->get_child(1), so_far+curr_node->get_num_left(), target);
        }
    }
    return(ret_val);
}


int BinIndex_Tree::recurse_reset(BinIndex_Node *curr_node)
{
    int left_val, right_val;
    if (curr_node->is_tip() == TRUE) return(1);
    else {
        left_val=recurse_reset(curr_node->get_child(0));
        right_val=recurse_reset(curr_node->get_child(1));
        curr_node->set_num_left(left_val);
        return(left_val+right_val);
    }
}


template <class PERMUTE_UNIT>
Permute<PERMUTE_UNIT>::Permute()
{
	had_seed=FALSE;
	seedin.open("seed.txt");
	if (seedin.fail()) {
		cerr<<"Cannot find seed file seed.txt\n";
		cerr<<"WARNING: Use of default seeds will invalidate random number generation\n";
	}
	else {
		seedin>>seed1>>seed2;
		seedin.close();
	}
	setall(seed1, seed2);		
}


template <class PERMUTE_UNIT>
Permute<PERMUTE_UNIT>::Permute(BOOL have_seed)
{
	had_seed=have_seed;
	if (have_seed == FALSE) {
		seedin.open("seed.txt");
		if (seedin.fail()) {
			cerr<<"Cannot find seed file seed.txt\n";
			cerr<<"WARNING: Use of default seeds will invalidate random number generation\n";
		}
		else {
			seedin>>seed1>>seed2;
			seedin.close();
		}
		setall(seed1, seed2);
	}
}


template <class PERMUTE_UNIT>
PERMUTE_UNIT * Permute<PERMUTE_UNIT>::do_permutation(int num_elements, PERMUTE_UNIT *elements)
{
	int i,j,k, rand_choice;
	PERMUTE_UNIT *new_perm;

	mark_used=new int [num_elements];
	new_perm=new PERMUTE_UNIT[num_elements];

	for(i=0; i<num_elements; i++) {
		mark_used[i]=0;
		new_perm[i]=0;
	}
	
	for(i=0; i<num_elements-1; i++)	{
		rand_choice=(int)ignuin(0,num_elements-i-1);
		j=k=0;
		while(mark_used[k] == 1) k++;

		j++;	
		while(j<=rand_choice) {
			k++;
			if (mark_used[k] == 0)
				j++;
		
		}
		
		new_perm[i]=elements[k];
		mark_used[k]=1;
		//cout<<i<<"\t"<<k<<endl;
	}
			
	i=0;
	while (mark_used[i] != 0) i++;
	new_perm[num_elements-1]=elements[i];
	
	delete[] mark_used;

	return(new_perm);
			
}


template <class PERMUTE_UNIT>
Permute<PERMUTE_UNIT>::~Permute()
{
	if (had_seed == FALSE) {
		seedout.open("./seed.txt");
		getsd(&seed1, &seed2);
		seedout<<seed1<<"\t"<<seed2<<endl;
		seedout.close();
	}
}





template <class PERMUTE_UNIT>
Permute_with_Tree<PERMUTE_UNIT>::Permute_with_Tree()
{
    had_seed=FALSE;
    seedin.open("seed.txt");
    if (seedin.fail()) {
        cerr<<"Cannot find seed file seed.txt\n";
        cerr<<"WARNING: Use of default seeds will invalidate random number generation\n";
    }
    else {
        seedin>>seed1>>seed2;
        seedin.close();
    }
    setall(seed1, seed2);
}


template <class PERMUTE_UNIT>
Permute_with_Tree<PERMUTE_UNIT>::Permute_with_Tree(BOOL have_seed)
{
    had_seed=have_seed;
    the_tree=0;
    previous_num_elements=0;
    if (have_seed == FALSE) {
        seedin.open("seed.txt");
        if (seedin.fail()) {
            cerr<<"Cannot find seed file seed.txt\n";
            cerr<<"WARNING: Use of default seeds will invalidate random number generation\n";
        }
        else {
            seedin>>seed1>>seed2;
            seedin.close();
        }
        setall(seed1, seed2);
    }
}


template <class PERMUTE_UNIT>
PERMUTE_UNIT * Permute_with_Tree<PERMUTE_UNIT>::do_permutation(int num_elements, PERMUTE_UNIT *elements)
{
    int i, return_index, rand_choice;
    PERMUTE_UNIT *new_perm;
    
    the_tree=new BinIndex_Tree(num_elements);
    
    new_perm=new PERMUTE_UNIT[num_elements];
    
    for(i=0; i<num_elements; i++)
        new_perm[i]=0;
   
    
    for(i=0; i<num_elements-1; i++)	{
        rand_choice=(int)ignuin(0,num_elements-i-1);
       
        return_index=the_tree->get_index_value(rand_choice);
        
        //cout<<"Doing tree assignment with "<<rand_choice<<" = "<<return_index<<endl;
        
        new_perm[i]=elements[return_index];
        
    }
    return_index=the_tree->get_index_value(0);
    new_perm[num_elements-1]=elements[return_index];
    
    delete the_tree;
    
    return(new_perm);
    
}



template <class PERMUTE_UNIT>
PERMUTE_UNIT * Permute_with_Tree<PERMUTE_UNIT>::do_permutation_repeat(int num_elements, PERMUTE_UNIT *elements)
{
    int i, return_index, rand_choice;
    PERMUTE_UNIT *new_perm;
    
    if ((num_elements != previous_num_elements) && (the_tree !=0)) {
        delete the_tree;
        the_tree=0;
    }
    if (the_tree == 0)
        the_tree=new BinIndex_Tree(num_elements);
    else
        the_tree->reset_tree();
    
    
    new_perm=new PERMUTE_UNIT[num_elements];
    
    for(i=0; i<num_elements; i++)
        new_perm[i]=0;
    
    
    for(i=0; i<num_elements-1; i++)	{
        rand_choice=(int)ignuin(0,num_elements-i-1);
        
        return_index=the_tree->get_index_value(rand_choice);
        
        //cout<<"Doing tree assignment with "<<rand_choice<<" = "<<return_index<<endl;
        
        new_perm[i]=elements[return_index];
        
    }
    return_index=the_tree->get_index_value(0);
    new_perm[num_elements-1]=elements[return_index];
    
    previous_num_elements=num_elements;
    
    return(new_perm);
    
}


template <class PERMUTE_UNIT>
Permute_with_Tree<PERMUTE_UNIT>::~Permute_with_Tree()
{
    if (the_tree!=0) delete the_tree;
    if (had_seed == FALSE) {
        seedout.open("./seed.txt");
        getsd(&seed1, &seed2);
        seedout<<seed1<<"\t"<<seed2<<endl;
        seedout.close();
    }
}

