#True edge counts
#LF-LF  MF1-MF1 MF2-MF2 LF-MF1  LF-MF2  MF1-MF2
#56630		19962		17514 33759	31118 18729

Edges <- read.table('edge_count_0_99.txt', head = T)


graphics.off()
par(mar=c(4,4,1,0.5))
par(mfrow=c(2,3))

#Intra edges
hist(Edges$LF.LF, breaks = 10,col="#D1532A", border = "#D1532A",main = "Number of LF-LF edges", xlab = "", 
     ylab = "Number of rewired networks", cex.lab=1.5, cex.axis=1.5, cex.main=1.5, cex.sub=1.5) 
abline(v = 56630, col="grey28", lwd=2, lty=2)
legend("topleft","a)",bty="n", cex=1.5)
p<-p_value(Edges$LF.LF, 56630)
legend(x=56500,y=22, legend = c("P-value",round(p, digits = 4)),bty="n", cex=1.5)


hist(Edges$MF1.MF1, breaks = 10,col="#74B158", border = "#74B158",main = "Number of MF1-MF1 edges", xlab = "", ylab = "", cex.lab=1.5, cex.axis=1.5, cex.main=1.5, cex.sub=1.5) 
abline(v = 19962, col="grey28", lwd=2, lty=2)
legend("topleft","b)",bty="n", cex=1.5)
p<-p_value(Edges$MF1.MF1, 19962)
legend("topright",legend = round(p, digits = 4),bty="n", cex=1.5)

hist(Edges$MF2.MF2,breaks = 10,col="#6EB5E4", border = "#6EB5E4",main = "Number of MF2-MF2 edges", xlab = "", ylab = "", cex.lab=1.5, cex.axis=1.5, cex.main=1.5, cex.sub=1.5) 
abline(v = 17514, col="grey28", lwd=2, lty=2)
legend("topleft","c)",bty="n", cex=1.5)
p<-p_value(Edges$MF2.MF2, 17514)
legend(x=17450,y=22,legend = round(p, digits = 4),bty="n", cex=1.5)


#Inter edges

hist(Edges$LF.MF1, breaks = 10,col="#ab8b13", border = "#ab8b13",main = "Number of LF-MF1 edges", xlab = "", ylab = "Number of rewired networks", cex.lab=1.5, cex.axis=1.5, cex.main=1.5, cex.sub=1.5) 
abline(v = 33759, col="grey28", lwd=2, lty=2)
legend("topleft","d)",bty="n", cex=1.5)
p<-p_value(Edges$LF.MF1, 33759)
legend("topright",legend = round(p, digits = 4),bty="n", cex=1.5)


hist(Edges$LF.MF2, breaks = 10,col="#c878c2", border = "#c878c2",main = "Number of LF-MF2 edges", xlab = "", ylab = "", cex.lab=1.5, cex.axis=1.5, cex.main=1.5, cex.sub=1.5) 
abline(v = 31118, col="grey28", lwd=2, lty=2)
legend("topleft","e)",bty="n", cex=1.5)
p<-p_value(Edges$LF.MF2, 31118)
legend("topright",legend = round(p, digits = 4),bty="n", cex=1.5)

hist(Edges$MF1.MF2,breaks = 10,col="#00bcb7", border = "#00bcb7",main = "Number of MF1-MF2 edges", xlab = "", ylab = "", cex.lab=1.5, cex.axis=1.5, cex.main=1.5, cex.sub=1.5) 
abline(v = 18729, col="grey28", lwd=2, lty=2)
legend("topleft","f)",bty="n", cex=1.5)
p<-p_value(Edges$MF1.MF2, 18729)
legend("topright",legend = round(p, digits = 4),bty="n", cex=1.5)


p_value <- function(List,trueval) {
  meanval <- mean(List)
  if (trueval <= meanval) {
    p <- 2*sum(List <= trueval) / 100
  } else {
    p <- 2*sum(List > trueval) / 100
  }
  print(p)
}



