#!/bin/bash


# bcftools version
# bcftools 1.9
# Using htslib 1.9
# Copyright (C) 2018 Genome Research Ltd.
# License Expat: The MIT/Expat license

bcftools query -f '%CHROM\t%POS\n' -i 'SVTYPE="INV"' merged_manta.passed.samples.only129.v2.vcf | sort -n -k2 | uniq |awk '{print int($2/100) }'|  sort -n | uniq -c | awk '{print "NC_045512.2",$2*100,$2*100+100,$1}' > inv.count.txt
bcftools query -f '%CHROM\t%POS\n' -i 'SVTYPE="INS"' merged_manta.passed.samples.only129.v2.vcf | sort -n -k2 | uniq |awk '{print int($2/100) }'|  sort -n | uniq -c | awk '{print "NC_045512.2",$2*100,$2*100+100,$1}' > ins.count.txt
bcftools query -f '%CHROM\t%POS\n' -i 'SVTYPE="DEL"' merged_manta.passed.samples.only129.v2.vcf | sort -n -k2 | uniq |awk '{print int($2/100) }'|  sort -n | uniq -c | awk '{print "NC_045512.2",$2*100,$2*100+100,$1}' > del.count.txt
bcftools query -f '%CHROM\t%POS\n' -i 'SVTYPE="DUP"' merged_manta.passed.samples.only129.v2.vcf | sort -n -k2 | uniq |awk '{print int($2/100) }'|  sort -n | uniq -c | awk '{print "NC_045512.2",$2*100,$2*100+100,$1}' > dup.count.txt


# SNVs density
grep -v "#" SNVs-merged.vcf | cut -f 1,2 | sort -n -k2 | uniq |awk '{print int($2/100) }'|  sort -n | uniq -c | awk '{print "NC_045512.2",$2*100,$2*100+100,$1}' > snv.density_100bp.tab
