library(ggplot2)
library(RColorBrewer)
library(grDevices)
#import the SNP counts and primer tables
primer <- read.csv("primer_maps_NA.txt",  sep="\t", header=T, row.names=1)
SNP_count <- read.csv("SNP-count-vector.txt", header=F)

#make an empty matrix that has the same dimensions as the primer map
mat<-matrix(0, 272, 30)
#annotate the rows to match the primer map
rownames(mat)<-rownames(primer)
#convert it to a dataframe and append the rownames to a column 
mat<-as.data.frame(mat)
mat$names<-row.names(mat)

for(i in 1:length(mat$names)) {
  counts <- SNP_count[primer$start[i]:primer$stop[i], ]
  for(j in 1:length(counts)) {
    mat[i, j] <- counts[j] 
  }
}

#Add a function to replace the NA sequences in the primer list inside the matrix
compareNA <- function(v1,v2) {
  # This function returns TRUE wherever elements are the same, including NA's,
  # and false everywhere else.
  same <- (v1 == v2)  |  (is.na(v1) & is.na(v2))
  same[is.na(same)] <- FALSE
  return(same)
}

#iterate the function over the primer list and make the replacements
for(i in 1:nrow(primer))
{
  for(j in 6:ncol(primer))
  {
    if (compareNA(primer[i,j], NA)==TRUE)
    {
      # print(primer[i,j])
      mat[i, j - 5] <- NA
    }
  }
}

mat$names <- NULL
matSNP <- as.matrix.data.frame(mat)
colnames(matSNP) <- c(1:30)

figureSNP<-matSNP[1:54, ]

phm <- pheatmap::pheatmap(figureSNP, 
                   color = colorRampPalette((brewer.pal(n = 6, name ="PuRd")))(12), 
                   kmeans_k = NA, 
                   breaks = NA, 
                   border_color = "grey20",
                   #width=1200,
                   #height=2400,
                   cellwidth = 14, 
                   cellheight = 14, 
                   scale = "none", 
                   cluster_rows = FALSE,
                   cluster_cols = FALSE, 
                   clustering_distance_rows = "euclidean",
                   clustering_method = "complete",
                   cutree_rows = NA, 
                   legend = T, 
                   annotation_legend = FALSE,
                   drop_levels = TRUE, 
                   show_rownames = T, 
                   show_colnames = T, 
                   main = "SNP locations in primer sequences",
                   fontsize = 10, 
                   fontsize_row = 10, 
                   fontsize_col = 10,
                   angle_col = 0, 
                   display_numbers = F,
                   number_format = "%.2f", 
                   number_color = "grey30", 
                   fontsize_number = 0.8 * fontsize, 
                   gaps_row = NULL, 
                   gaps_col = NULL, 
                   #labels_row = "Primer Name",
                   #labels_col = "Position in sequence (5' to 3')", 
                   silent = FALSE, 
                   na_col = "#888888")

save_pheatmap_png <- function(x, filename, width=2000, height=3800, res = 300) {
  png(filename, width = width, height = height, res = res)
  grid::grid.newpage()
  grid::grid.draw(x$gtable)
  dev.off()
}

save_pheatmap_png(phm, "SNP-plot-dpi300.png", width=3000, height=3600)
