## mWGCNA R script (Panwar et al 2021)

## 1. Data input and cleaning
getwd();
workingDir = "/Users/bharatpanwar/SLE/mWGCNA"
setwd(workingDir);
library(WGCNA);
options(stringsAsFactors = FALSE);
femData = read.csv("ExpressionProfilesTPM1.csv");
dim(femData);
names(femData);
datExpr0 = as.data.frame(t(femData[, -c(1:2)]));
names(datExpr0) = femData$gene_id;
rownames(datExpr0) = names(femData)[-c(1:2)];
gsg = goodSamplesGenes(datExpr0, verbose = 3);
if (!gsg$allOK){ if (sum(!gsg$goodGenes)>0) printFlush(paste("Removing genes:", paste(names(datExpr0)[!gsg$goodGenes], collapse = ", "))); if (sum(!gsg$goodSamples)>0) printFlush(paste("Removing samples:", paste(rownames(datExpr0)[!gsg$goodSamples], collapse = ", "))); datExpr0 = datExpr0[gsg$goodSamples, gsg$goodGenes] }
sampleTree = hclust(dist(datExpr0), method = "average");
sizeGrWindow(16,12)
pdf(file = "sampleClustering1.pdf", width = 12, height = 9);
par(cex = 0.6);
par(mar = c(4,6,2,2))
plot(sampleTree, main = "Sample clustering to detect outliers", cex.lab = 1.5, cex.axis = 1.5, cex.main = 2)
dev.off()
datExpr = datExpr0;
nGenes = ncol(datExpr)
nSamples = nrow(datExpr)
traitData = read.csv("ClinicalTraits.csv");
dim(traitData)
names(traitData)
allTraits = traitData[, c(1,3,5,6,10,11,12,13,15,16,22,28,31,35,48,52,53)];
allTraits
dim(allTraits)
names(allTraits)
femaleSamples = rownames(datExpr);
traitRows = match(femaleSamples, allTraits$PatientID);
traitRows
datTraits = allTraits[traitRows, -1];
datTraits
rownames(datTraits) = allTraits[traitRows, 1];
datTraits
collectGarbage();
sampleTree2 = hclust(dist(datExpr), method = "average")
traitColors = numbers2colors(datTraits, signed = FALSE);
pdf(file = "sampleClustering2.pdf", width = 16, height = 12);
par(cex = 0.6);
par(mar = c(4,6,2,2))
plotDendroAndColors(sampleTree2, traitColors,groupLabels = names(datTraits),main = "Sample dendrogram and trait heatmap")
save(datExpr, datTraits, file = "mWGCNA-01-dataInput.RData")
dev.off()

## 2. Network construction and module detection
lnames = load(file = "mWGCNA-01-dataInput.RData");
lnames
powers = c(c(1:10), seq(from = 12, to=20, by=2))
sft = pickSoftThreshold(datExpr, powerVector = powers, verbose = 5)
sizeGrWindow(9, 5)
par(mfrow = c(1,2));
cex1 = 0.9;
plot(sft$fitIndices[,1], -sign(sft$fitIndices[,3])*sft$fitIndices[,2],xlab="Soft Threshold (power)",ylab="Scale Free Topology Model Fit,signed R^2",type="n",main = paste("Scale independence"));
text(sft$fitIndices[,1], -sign(sft$fitIndices[,3])*sft$fitIndices[,2],labels=powers,cex=cex1,col="red");
abline(h=0.90,col="red")
plot(sft$fitIndices[,1], sft$fitIndices[,5],xlab="Soft Threshold (power)",ylab="Mean Connectivity", type="n",main = paste("Mean connectivity"))
text(sft$fitIndices[,1], sft$fitIndices[,5], labels=powers, cex=cex1,col="red")
net = blockwiseModules(datExpr, checkMissingData = TRUE, power = 3,TOMType = "unsigned", minModuleSize = 50, maxBlockSize = 101282, reassignThreshold = 0, mergeCutHeight = 0.25, numericLabels = TRUE, pamRespectsDendro = FALSE,saveTOMs = TRUE, saveTOMFileBase = "mWGCNATOM", verbose = 3)
sizeGrWindow(15, 15)
table(net$colors)
mergedColors = labels2colors(net$colors)
plotDendroAndColors(net$dendrograms[[1]], mergedColors[net$blockGenes[[1]]],"Module colors",dendroLabels = FALSE, hang = 0.03,addGuide = TRUE, guideHang = 0.05)
moduleLabels = net$colors
moduleColors = labels2colors(net$colors)
MEs = net$MEs;
geneTree = net$dendrograms[[1]];
save(MEs, moduleLabels, moduleColors, geneTree, file = "mWGCNA-02-networkConstruction-auto.RData")

## 3. Relating modules to external clinical traits and identifying important genes
lnames = load(file = "mWGCNA-01-dataInput.RData");
lnames
lnames = load(file = "mWGCNA-02-networkConstruction-auto.RData");
lnames
nGenes = ncol(datExpr);
nSamples = nrow(datExpr);
MEs0 = moduleEigengenes(datExpr, moduleColors)$eigengenes
MEs = orderMEs(MEs0)
moduleTraitCor = cor(MEs, datTraits, use = "p");
moduleTraitPvalue = corPvalueStudent(moduleTraitCor, nSamples);
sizeGrWindow(20,20)
textMatrix =  paste(signif(moduleTraitCor, 2), " (",signif(moduleTraitPvalue, 1), ")", sep = "");
textMatrix
dim(textMatrix) = dim(moduleTraitCor)
par(mar = c(8, 12, 1, 4));
labeledHeatmap(Matrix = moduleTraitCor,xLabels = names(datTraits),yLabels = names(MEs),ySymbols = names(MEs),colorLabels = FALSE,colors = redWhiteGreen(50),textMatrix = textMatrix,setStdMargins = FALSE,cex.text = 0.6,zlim = c(-1,1),main = paste("mWGCNA: Module-trait relationships (pearson)"))
write.csv(moduleTraitCor, file = "moduleTraitsPearsonCor.csv", row.names = TRUE)
write.csv(moduleTraitPvalue, file = "moduleTraitPearsonPvalue.csv", row.names = TRUE)
moduleTraitCor = cor(MEs, datTraits, use = "p", method="spearman");
moduleTraitPvalue = corPvalueStudent(moduleTraitCor, nSamples);
sizeGrWindow(20,20)
textMatrix =  paste(signif(moduleTraitCor, 2), " (",signif(moduleTraitPvalue, 1), ")", sep = "");
textMatrix
dim(textMatrix) = dim(moduleTraitCor)
par(mar = c(8, 12, 1, 4));
labeledHeatmap(Matrix = moduleTraitCor,xLabels = names(datTraits),yLabels = names(MEs),ySymbols = names(MEs),colorLabels = FALSE,colors = redWhiteGreen(50),textMatrix = textMatrix,setStdMargins = FALSE,cex.text = 0.6,zlim = c(-1,1),main = paste("mWGCNA: Module-trait relationships (spearman)"))
write.csv(moduleTraitCor, file = "moduleTraitsSpearmanCor.csv", row.names = TRUE)
write.csv(moduleTraitPvalue, file = "moduleTraitSpearmanPvalue.csv", row.names = TRUE)

datTraits
dim(datTraits)
names(allTraits)
modNames = substring(names(MEs), 3)
modNames
geneModuleMembership = as.data.frame(cor(datExpr, MEs, use = "p"));
geneModuleMembership
MMPvalue = as.data.frame(corPvalueStudent(as.matrix(geneModuleMembership), nSamples));
names(geneModuleMembership) = paste("MM", modNames, sep="");
names(MMPvalue) = paste("p.MM", modNames, sep="");
names(datExpr)
names(datExpr)[moduleColors=="black"]
annot = read.csv(file = "geneinfo.csv");
dim(annot)
names(annot)
probes = names(datExpr)
probes2annot = match(probes, annot$gene_id)
sum(is.na(probes2annot))
name(datTraits)
datTraits

IFN = as.data.frame(datTraits$IFN);
names(IFN) = "IFN"
geneTraitSignificance_IFN = as.data.frame(cor(datExpr, IFN, use = "p"));
names(geneTraitSignificance_IFN) = paste("GS.", names(IFN), sep="");
GSPvalue_IFN = as.data.frame(corPvalueStudent(as.matrix(geneTraitSignificance_IFN), nSamples));
names(GSPvalue_IFN) = paste("p.GS.", names(IFN), sep="");
Age = as.data.frame(datTraits$Age);
names(Age) = "Age"
geneTraitSignificance_Age = as.data.frame(cor(datExpr, Age, use = "p"));
names(geneTraitSignificance_Age) = paste("GS.", names(Age), sep="");
GSPvalue_Age = as.data.frame(corPvalueStudent(as.matrix(geneTraitSignificance_Age), nSamples));
names(GSPvalue_Age) = paste("p.GS.", names(Age), sep="");
Ethnicity = as.data.frame(datTraits$Ethnicity);
names(Ethnicity) = "Ethnicity"
geneTraitSignificance_Ethnicity = as.data.frame(cor(datExpr, Ethnicity, use = "p"));
names(geneTraitSignificance_Ethnicity) = paste("GS.", names(Ethnicity), sep="");
GSPvalue_Ethnicity = as.data.frame(corPvalueStudent(as.matrix(geneTraitSignificance_Ethnicity), nSamples));
names(GSPvalue_Ethnicity) = paste("p.GS.", names(Ethnicity), sep="");
Flare = as.data.frame(datTraits$Flare);
names(Flare) = "Flare"
geneTraitSignificance_Flare = as.data.frame(cor(datExpr, Flare, use = "p"));
names(geneTraitSignificance_Flare) = paste("GS.", names(Flare), sep="");
GSPvalue_Flare = as.data.frame(corPvalueStudent(as.matrix(geneTraitSignificance_Flare), nSamples));
names(GSPvalue_Flare) = paste("p.GS.", names(Flare), sep="");
Severity = as.data.frame(datTraits$Severity);
names(Severity) = "Severity"
geneTraitSignificance_Severity = as.data.frame(cor(datExpr, Severity, use = "p"));
names(geneTraitSignificance_Severity) = paste("GS.", names(Severity), sep="");
GSPvalue_Severity = as.data.frame(corPvalueStudent(as.matrix(geneTraitSignificance_Severity), nSamples));
names(GSPvalue_Severity) = paste("p.GS.", names(Severity), sep="");
SLEDAI = as.data.frame(datTraits$SLEDAI);
names(SLEDAI) = "SLEDAI"
geneTraitSignificance_SLEDAI = as.data.frame(cor(datExpr, SLEDAI, use = "p"));
names(geneTraitSignificance_SLEDAI) = paste("GS.", names(SLEDAI), sep="");
GSPvalue_SLEDAI = as.data.frame(corPvalueStudent(as.matrix(geneTraitSignificance_SLEDAI), nSamples));
names(GSPvalue_SLEDAI) = paste("p.GS.", names(SLEDAI), sep="");
Years_of_disease = as.data.frame(datTraits$Years_of_disease);
names(Years_of_disease) = "Years_of_disease"
geneTraitSignificance_Years_of_disease = as.data.frame(cor(datExpr, Years_of_disease, use = "p"));
names(geneTraitSignificance_Years_of_disease) = paste("GS.", names(Years_of_disease), sep="");
GSPvalue_Years_of_disease = as.data.frame(corPvalueStudent(as.matrix(geneTraitSignificance_Years_of_disease), nSamples));
names(GSPvalue_Years_of_disease) = paste("p.GS.", names(Years_of_disease), sep="");
Affected_Renal = as.data.frame(datTraits$Affected_Renal);
names(Affected_Renal) = "Affected_Renal"
geneTraitSignificance_Affected_Renal = as.data.frame(cor(datExpr, Affected_Renal, use = "p"));
names(geneTraitSignificance_Affected_Renal) = paste("GS.", names(Affected_Renal), sep="");
GSPvalue_Affected_Renal = as.data.frame(corPvalueStudent(as.matrix(geneTraitSignificance_Affected_Renal), nSamples));
names(GSPvalue_Affected_Renal) = paste("p.GS.", names(Affected_Renal), sep="");
Steroids = as.data.frame(datTraits$Steroids);
names(Steroids) = "Steroids"
geneTraitSignificance_Steroids = as.data.frame(cor(datExpr, Steroids, use = "p"));
names(geneTraitSignificance_Steroids) = paste("GS.", names(Steroids), sep="");
GSPvalue_Steroids = as.data.frame(corPvalueStudent(as.matrix(geneTraitSignificance_Steroids), nSamples));
names(GSPvalue_Steroids) = paste("p.GS.", names(Steroids), sep="");
Quinie = as.data.frame(datTraits$Quinie);
names(Quinie) = "Quinie"
geneTraitSignificance_Quinie = as.data.frame(cor(datExpr, Quinie, use = "p"));
names(geneTraitSignificance_Quinie) = paste("GS.", names(Quinie), sep="");
GSPvalue_Quinie = as.data.frame(corPvalueStudent(as.matrix(geneTraitSignificance_Quinie), nSamples));
names(GSPvalue_Quinie) = paste("p.GS.", names(Quinie), sep="");
MMF = as.data.frame(datTraits$MMF);
names(MMF) = "MMF"
geneTraitSignificance_MMF = as.data.frame(cor(datExpr, MMF, use = "p"));
names(geneTraitSignificance_MMF) = paste("GS.", names(MMF), sep="");
GSPvalue_MMF = as.data.frame(corPvalueStudent(as.matrix(geneTraitSignificance_MMF), nSamples));
names(GSPvalue_MMF) = paste("p.GS.", names(MMF), sep="");
MTX = as.data.frame(datTraits$MTX);
names(MTX) = "MTX"
geneTraitSignificance_MTX = as.data.frame(cor(datExpr, MTX, use = "p"));
names(geneTraitSignificance_MTX) = paste("GS.", names(MTX), sep="");
GSPvalue_MTX = as.data.frame(corPvalueStudent(as.matrix(geneTraitSignificance_MTX), nSamples));
names(GSPvalue_MTX) = paste("p.GS.", names(MTX), sep="");
Azathrioprine = as.data.frame(datTraits$Azathrioprine);
names(Azathrioprine) = "Azathrioprine"
geneTraitSignificance_Azathrioprine = as.data.frame(cor(datExpr, Azathrioprine, use = "p"));
names(geneTraitSignificance_Azathrioprine) = paste("GS.", names(Azathrioprine), sep="");
GSPvalue_Azathrioprine = as.data.frame(corPvalueStudent(as.matrix(geneTraitSignificance_Azathrioprine), nSamples));
names(GSPvalue_Azathrioprine) = paste("p.GS.", names(Azathrioprine), sep="");
other_IS = as.data.frame(datTraits$other_IS);
names(other_IS) = "other_IS"
geneTraitSignificance_other_IS = as.data.frame(cor(datExpr, other_IS, use = "p"));
names(geneTraitSignificance_other_IS) = paste("GS.", names(other_IS), sep="");
GSPvalue_other_IS = as.data.frame(corPvalueStudent(as.matrix(geneTraitSignificance_other_IS), nSamples));
names(GSPvalue_other_IS) = paste("p.GS.", names(other_IS), sep="");
SLEDAI_class = as.data.frame(datTraits$SLEDAI_class);
names(SLEDAI_class) = "SLEDAI_class"
geneTraitSignificance_SLEDAI_class = as.data.frame(cor(datExpr, SLEDAI_class, use = "p"));
names(geneTraitSignificance_SLEDAI_class) = paste("GS.", names(SLEDAI_class), sep="");
GSPvalue_SLEDAI_class = as.data.frame(corPvalueStudent(as.matrix(geneTraitSignificance_SLEDAI_class), nSamples));
names(GSPvalue_SLEDAI_class) = paste("p.GS.", names(SLEDAI_class), sep="");

geneInfo0 = data.frame(gene_id = probes, moduleColor = moduleColors, geneTraitSignificance_IFN, GSPvalue_IFN, geneTraitSignificance_Age, GSPvalue_Age, geneTraitSignificance_Ethnicity, GSPvalue_Ethnicity, geneTraitSignificance_Flare, GSPvalue_Flare, geneTraitSignificance_Severity, GSPvalue_Severity, geneTraitSignificance_SLEDAI, GSPvalue_SLEDAI, geneTraitSignificance_Years_of_disease, GSPvalue_Years_of_disease, geneTraitSignificance_Affected_Renal, GSPvalue_Affected_Renal, geneTraitSignificance_Steroids, GSPvalue_Steroids, geneTraitSignificance_Quinie, GSPvalue_Quinie, geneTraitSignificance_MMF, GSPvalue_MMF, geneTraitSignificance_MTX, GSPvalue_MTX, geneTraitSignificance_Azathrioprine, GSPvalue_Azathrioprine, geneTraitSignificance_other_IS, GSPvalue_other_IS, geneTraitSignificance_SLEDAI_class, GSPvalue_SLEDAI_class)
modOrder = order(-abs(cor(MEs, IFN, use = "p")));
for (mod in 1:ncol(geneModuleMembership)){
oldNames = names(geneInfo0)
geneInfo0 = data.frame(geneInfo0, geneModuleMembership[, modOrder[mod]], MMPvalue[, modOrder[mod]]);
names(geneInfo0) = c(oldNames, paste("MM.", modNames[modOrder[mod]], sep=""),paste("p.MM.", modNames[modOrder[mod]], sep=""))
}
geneOrder = order(geneInfo0$moduleColor, -abs(geneInfo0$GS.IFN));
geneOrder
geneInfo = geneInfo0[geneOrder, ]
write.csv(geneInfo, file = "MASTER_GS_MM.csv")
write.csv(MEs, file = "MEs.csv", row.names = TRUE)

## 4. Interfacing network analysis with other data such as functional annotation and gene ontology
annot = read.csv(file = "geneinfo.csv");
probes = names(datExpr)
names(annot)
probes = names(datExpr)
names(probes)
probes2annot = match(probes, annot$gene_id)
allLLIDs = annot$EntrezID[probes2annot];
intModules = c("black")
for (module in intModules)
{modGenes = (moduleColors==module)
modLLIDs = allLLIDs[modGenes];
fileName = paste("LocusLinkIDs-", module, ".txt", sep="");
write.table(as.data.frame(modLLIDs), file = fileName,row.names = FALSE, col.names = FALSE)}
fileName = paste("LocusLinkIDs-all.txt", sep="");
write.table(as.data.frame(allLLIDs), file = fileName,row.names = FALSE, col.names = FALSE)
GOenr = GOenrichmentAnalysis(moduleColors, allLLIDs, organism = "human", nBestP = 50);
tab = GOenr$bestPTerms[[4]]$enrichment
names(tab)
write.table(tab, file = "GOEnrichmentTable.csv", sep = ",", quote = TRUE, row.names = FALSE)
module = "black"
column = match(module, modNames);
moduleGenes = moduleColors==module;
sizeGrWindow(7, 7);
par(mfrow = c(1,1));
verboseScatterplot(abs(geneModuleMembership[moduleGenes, column]),abs(geneTraitSignificance_IFN[moduleGenes, 1]),xlab = paste("Module Membership in", module, "module"),ylab = "Gene significance for IFN",main = paste("Module membership vs. gene significance\n"),cex.main = 1.2, cex.lab = 1.2, cex.axis = 1.2, col = module)
keepCols = c(1, 2, 5, 6, 7, 12, 13);
screenTab = tab[, keepCols];
numCols = c(3, 4);
screenTab[, numCols] = signif(apply(screenTab[, numCols], 2, as.numeric), 2)
screenTab[, 7] = substring(screenTab[, 7], 1, 40)
colnames(screenTab) = c("module", "size", "p-val", "Bonf", "nInTerm", "ont", "term name");
rownames(screenTab) = NULL;
options(width=95)
screenTab

## 5. Network visualization using WGCNA functions
dissTOM = 1-TOMsimilarityFromExpr(datExpr, power = 3);
dissTOM[1:5,1:5]
plotTOM = dissTOM^4;
diag(plotTOM) = NA;
#sizeGrWindow(12,12)
#TOMplot(plotTOM, geneTree, moduleColors, main = "Network heatmap plot, all genes")
nSelect = 1000
set.seed(10);
select = sample(nGenes, size = nSelect);
selectTOM = dissTOM[select, select];
selectTree = hclust(as.dist(selectTOM), method = "average")
selectColors = moduleColors[select];
sizeGrWindow(9,9)
plotDiss = selectTOM^4;
diag(plotDiss) = NA;
TOMplot(plotDiss, selectTree, selectColors, main = "Network heatmap plot, selected genes")
MEs = moduleEigengenes(datExpr, moduleColors)$eigengenes
MEs
names(datTraits)
IFN = as.data.frame(datTraits$IFN);
names (IFN) = "IFN"
MET = orderMEs(cbind(MEs, IFN))
sizeGrWindow(5,7.5);
par(cex = 0.9)
plotEigengeneNetworks(MET, "", marDendro = c(0,4,1,2), marHeatmap = c(3,4,1,2), cex.lab = 0.8, xLabelsAngle = 90)

# 6. Export of networks to external software
TOM = TOMsimilarityFromExpr(datExpr, power = 3);
TOM[1:5,1:5]
annot = read.csv(file = "geneinfo2.csv");

table(moduleColors)
mod <- array(unique(moduleColors))
mod
for(i in mod){ modules = i
probes = names(datExpr)
inModule = is.finite(match(moduleColors, modules));
modProbes = probes[inModule];
modGenes = annot$gene_symbol[match(modProbes, annot$gene_id)];
modTOM = TOM[inModule, inModule];
dimnames(modTOM) = list(modProbes, modProbes)
cyt = exportNetworkToCytoscape(modTOM,edgeFile = paste("CytoscapeInput-edges-", paste(modules, collapse="-"), ".txt", sep=""),nodeFile = paste("CytoscapeInput-nodes-", paste(modules, collapse="-"), ".txt", sep=""),weighted = TRUE,threshold = 0.05,nodeNames = modProbes,altNodeNames = modGenes); }

modules = "black"
probes = names(datExpr)
inModule = is.finite(match(moduleColors, modules));
modProbes = probes[inModule];
modGenes = annot$gene_symbol[match(modProbes, annot$gene_id)];
modTOM = TOM[inModule, inModule];
dimnames(modTOM) = list(modProbes, modProbes)
cyt = exportNetworkToCytoscape(modTOM,edgeFile = paste("CytoscapeInput-edges-", paste(modules, collapse="-"), ".txt", sep=""),nodeFile = paste("CytoscapeInput-nodes-", paste(modules, collapse="-"), ".txt", sep=""),weighted = TRUE,threshold = 0.05,nodeNames = modProbes,altNodeNames = modGenes);
cyt = exportNetworkToCytoscape(modTOM,edgeFile = paste("CytoscapeInput-edges-0.05-", paste(modules, collapse="-"), ".txt", sep=""),nodeFile = paste("CytoscapeInput-nodes-0.05-", paste(modules, collapse="-"), ".txt", sep=""),weighted = TRUE,threshold = 0.05,nodeNames = modProbes,altNodeNames = modGenes);
cyt = exportNetworkToCytoscape(modTOM,edgeFile = paste("CytoscapeInput-edges-0.1-", paste(modules, collapse="-"), ".txt", sep=""),nodeFile = paste("CytoscapeInput-nodes-0.1-", paste(modules, collapse="-"), ".txt", sep=""),weighted = TRUE,threshold = 0.1,nodeNames = modProbes,altNodeNames = modGenes);
cyt = exportNetworkToCytoscape(modTOM,edgeFile = paste("CytoscapeInput-edges-0.15-", paste(modules, collapse="-"), ".txt", sep=""),nodeFile = paste("CytoscapeInput-nodes-0.15-", paste(modules, collapse="-"), ".txt", sep=""),weighted = TRUE,threshold = 0.15,nodeNames = modProbes,altNodeNames = modGenes);
cyt = exportNetworkToCytoscape(modTOM,edgeFile = paste("CytoscapeInput-edges-0.20-", paste(modules, collapse="-"), ".txt", sep=""),nodeFile = paste("CytoscapeInput-nodes-0.20-", paste(modules, collapse="-"), ".txt", sep=""),weighted = TRUE,threshold = 0.20,nodeNames = modProbes,altNodeNames = modGenes);
cyt = exportNetworkToCytoscape(modTOM,edgeFile = paste("CytoscapeInput-edges-0.25-", paste(modules, collapse="-"), ".txt", sep=""),nodeFile = paste("CytoscapeInput-nodes-0.25-", paste(modules, collapse="-"), ".txt", sep=""),weighted = TRUE,threshold = 0.25,nodeNames = modProbes,altNodeNames = modGenes);

modules = "lightyellow"
probes = names(datExpr)
inModule = is.finite(match(moduleColors, modules));
modProbes = probes[inModule];
modGenes = annot$gene_symbol[match(modProbes, annot$gene_id)];
modTOM = TOM[inModule, inModule];
dimnames(modTOM) = list(modProbes, modProbes)
cyt = exportNetworkToCytoscape(modTOM,edgeFile = paste("CytoscapeInput-edges-0.05-", paste(modules, collapse="-"), ".txt", sep=""),nodeFile = paste("CytoscapeInput-nodes-0.05-", paste(modules, collapse="-"), ".txt", sep=""),weighted = TRUE,threshold = 0.05,nodeNames = modProbes);
cyt = exportNetworkToCytoscape(modTOM,edgeFile = paste("CytoscapeInput-edges-0.1-", paste(modules, collapse="-"), ".txt", sep=""),nodeFile = paste("CytoscapeInput-nodes-0.1-", paste(modules, collapse="-"), ".txt", sep=""),weighted = TRUE,threshold = 0.1,nodeNames = modProbes);
cyt = exportNetworkToCytoscape(modTOM,edgeFile = paste("CytoscapeInput-edges-0.15-", paste(modules, collapse="-"), ".txt", sep=""),nodeFile = paste("CytoscapeInput-nodes-0.15-", paste(modules, collapse="-"), ".txt", sep=""),weighted = TRUE,threshold = 0.15,nodeNames = modProbes);
cyt = exportNetworkToCytoscape(modTOM,edgeFile = paste("CytoscapeInput-edges-0.20-", paste(modules, collapse="-"), ".txt", sep=""),nodeFile = paste("CytoscapeInput-nodes-0.20-", paste(modules, collapse="-"), ".txt", sep=""),weighted = TRUE,threshold = 0.20,nodeNames = modProbes);
cyt = exportNetworkToCytoscape(modTOM,edgeFile = paste("CytoscapeInput-edges-0.25-", paste(modules, collapse="-"), ".txt", sep=""),nodeFile = paste("CytoscapeInput-nodes-0.25-", paste(modules, collapse="-"), ".txt", sep=""),weighted = TRUE,threshold = 0.25,nodeNames = modProbes);
cyt = exportNetworkToCytoscape(modTOM,edgeFile = paste("CytoscapeInput-edges-0.30-", paste(modules, collapse="-"), ".txt", sep=""),nodeFile = paste("CytoscapeInput-nodes-0.30-", paste(modules, collapse="-"), ".txt", sep=""),weighted = TRUE,threshold = 0.30,nodeNames = modProbes);

TopHubInEachModule <- chooseTopHubInEachModule(datExpr, moduleColors, omitColors = "grey", power = 3, type = "unsigned")
write.csv(TopHubInEachModule, file = "TopHubInEachModule.csv", row.names = TRUE)

savehistory("mWGCNA.Rhistory")
